// hottopics.js
// NLS_CHARSET=UTF-8
//
// (C) Copyright IBM Corporation, 2003, 2006                        //
// All rights reserved. Licensed Materials Property of IBM          //
// US Government Users Restricted Rights                            //
// Use, duplication or disclosure restricted by                     //
// GSA ADP Schedule Contract with IBM Corp.                         //

//START NON-TRANSLATABLE
//////////////////////////////////////////////////////////////////////
// define simple object.
function hotTopic() {
	args=hotTopic.arguments;
	this.text = args[0];
	this.stext = args[1] || "intentionally blank";
	this.url = args[2] || "";

   this.getText = getText;
   this.getBlurb = getBlurb;
   this.getURL = getURL;
}

function getText() {
	return this.text;
}
function getBlurb(){
	return this.stext;
}
function getURL(){
	return this.url;
}
//
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
// redefine the 'push' function for all browsers.
//if (Array.prototype.push && ([0].push(true)==true))
//        Array.prototype.push = null;

if(!Array.prototype.push) {
    function array_push() {
        for(i=0;i<arguments.length;i++){
            this[this.length] = arguments[i];
        }
        return this.length;
    }

    Array.prototype.push = array_push;

}
//
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// function for generating random number.

var masterHTid=null;
function getHTvalue(aQuotes){
  if (!masterHTid) {
	// select random quote (integer).
	var numRand = Math.random();
	var numQuote = aQuotes.length - 1;
	masterHTid = Math.round((numQuote - 1) * numRand) + 1;
  }
  return masterHTid;
}
//
//////////////////////////////////////////////////////////////////////




//END NON-TRANSLATABLE

//////////////////////////////////////////////////////////////////////
// initialize an array of objects.
var quotes = new Array;
//START QUOTE TRANSLATABLE 1 2
quotes.push(new hotTopic("您可對特定的頁面標上書籤。", "標書籤", "./icfaq.htm#bookmark"));
quotes.push(new hotTopic("您可以使用「引導式設定」精靈，來配置您的「硬體管理主控台 (HMC)」。", "使用「引導式設定」精靈配置 HMC", "../iphai/confighmcgs.htm"));
quotes.push(new hotTopic("您可以建立符合您要求所自訂的伺服器設定核對清單。", "建立自訂的起始伺服器設定核對清單", "../iphaf/issintwelcome.htm"));
quotes.push(new hotTopic("您可以下載及安裝 CD 安裝版的資訊中心更新。", "下載 CD 安裝版的資訊中心更新", "./icupdates.htm#downloadupdates"));
quotes.push(new hotTopic("您可以檢視新資訊中心介面的產品導覽動畫。", "資訊中心介面", "./icfaq.htm#flashdemo"));
quotes.push(new hotTopic("您可以安裝各種硬體功能，並更換您伺服器或擴充裝置中的許多組件。", "安裝功能", "../iphaj/installcifcio.htm"));
quotes.push(new hotTopic("您可以選取數個互動式課程及教學課程，以協助您學習更多的伺服器虛擬化資訊。", "學習及教學課程", "../iphcy/learningandtutorials.html"));
quotes.push(new hotTopic("您可以檢視型號清單 (內含機型及型號 (MTM) 名稱、完整名稱、簡短名稱及品牌或系列)。", "型號及名稱清單", "./modelnumbersandnames.htm"));
quotes.push(new hotTopic("您可使用易讀的圖表尋找現在位於「IBM 系統硬體資訊中心」的 pSeries 文件。", "資訊中心的 pSeries 書籍對映圖", "./icpserieslist.htm"));
quotes.push(new hotTopic("您可列印每一項主要主題及其子主題。", "列印", "./icfaq.htm#print"));
quotes.push(new hotTopic("您可以訂閱網際網路更新，以在出現「IBM 系統硬體資訊中心」更新時接收到通知。", "訂閱網際網路更新", "./icupdates.htm#subscribe"));

//END QUOTE TRANSLATABLE
// end array of objects
//////////////////////////////////////////////////////////////////////

//START QUOTE TRANSLATABLE
var strDidYouKnowHeader = "<H2>您知道嗎？<\/H2>";
var sDidYouKnow = "&nbsp;&nbsp;您知道嗎？";
var sSeeAllTips = "查看所有要訣";
//END QUOTE TRANSLATABLE

//START NON-TRANSLATABLE
//////////////////////////////////////////////////////////////////////
// begin execution path
var HTid=getHTvalue(quotes);
// end execution path
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
// suport functions
//////////////////////////////////////////////////////////////////////
// functions to create formatted strings and write to document.
function getHotTopic(){
	result = '<A href="'+quotes[HTid].getURL()+'">'+quotes[HTid].getText()+'<\/A>';
	return result;
}
function getHotTopic2(){
	result = '<A href="'+quotes[HTid].getURL()+'"><IMG src=".\/images\/fw.gif" width="16" height="17" vspace="0" hspace="0" border="0" alt=""\/><\/A> ';
	return result;

}
function getHotTopic3(){
	result = '<A href="'+quotes[HTid].getURL()+'">'+quotes[HTid].getBlurb()+'<\/A>';
	return result;

}
function dumpHotTopics(){
	document.writeln(strDidYouKnowHeader);
	document.writeln('<BLOCKQUOTE>');
	for ( ht in quotes ) {
		result = '<P class="frontendbarlink" style="width: 100%;"><A href="'+quotes[ht].url+'">'+quotes[ht].stext+'<\/A><\/P>';
		result += '<P>'+quotes[ht].text+'<\/P>';
		document.writeln(result);
	}
	document.writeln('<\/BLOCKQUOTE>');
}
//////////////////////////////////////////////////////////////////////
// This hideous function is a work around for Netscape 4.x.  The function 
// creates the WHOLE callout box. Since, we cannot call a function from within
// a TD in Netscape 4.x, we cannot do the getHotTopic() calls in a callout box
// within the HTML.  That would result in an empty callout box. So we have a
// 'parent' function call in the HTML that creates the whole callout box.
// This function is not executed in Netscape 4.x, so there is no empty calloutbox.  QED.
function doDidYouKnow(){
	var result=getHotTopic();
	result+='<br>';
	result+=getHotTopic2();
	result+=getHotTopic3();
	result+='<br>';
	result+='       <A href=".\/hottopics.htm"><IMG src=".\/images\/fw.gif" width="16" height="17" vspace="0" hspace="0" border="0" alt=""><\/A> ';
//result+='       <A href=".\/hottopics.htm" class="fbox">'+sSeeAllTips+'</A>';
	result+='       <A href=".\/hottopics.htm">'+sSeeAllTips+'<\/A>';
	document.open();
	document.write(result);
	document.close();
}

//END NON-TRANSLATABLE

