// hottopics.js
// NLS_CHARSET=UTF-8
//
// (C) Copyright IBM Corporation, 2003, 2006                        //
// All rights reserved. Licensed Materials Property of IBM          //
// US Government Users Restricted Rights                            //
// Use, duplication or disclosure restricted by                     //
// GSA ADP Schedule Contract with IBM Corp.                         //

//START NON-TRANSLATABLE
//////////////////////////////////////////////////////////////////////
// define simple object.
function hotTopic() {
	args=hotTopic.arguments;
	this.text = args[0];
	this.stext = args[1] || "intentionally blank";
	this.url = args[2] || "";

   this.getText = getText;
   this.getBlurb = getBlurb;
   this.getURL = getURL;
}

function getText() {
	return this.text;
}
function getBlurb(){
	return this.stext;
}
function getURL(){
	return this.url;
}
//
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
// redefine the 'push' function for all browsers.
//if (Array.prototype.push && ([0].push(true)==true))
//        Array.prototype.push = null;

if(!Array.prototype.push) {
    function array_push() {
        for(i=0;i<arguments.length;i++){
            this[this.length] = arguments[i];
        }
        return this.length;
    }

    Array.prototype.push = array_push;

}
//
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// function for generating random number.

var masterHTid=null;
function getHTvalue(aQuotes){
  if (!masterHTid) {
	// select random quote (integer).
	var numRand = Math.random();
	var numQuote = aQuotes.length - 1;
	masterHTid = Math.round((numQuote - 1) * numRand) + 1;
  }
  return masterHTid;
}
//
//////////////////////////////////////////////////////////////////////




//END NON-TRANSLATABLE

//////////////////////////////////////////////////////////////////////
// initialize an array of objects.
var quotes = new Array;
//START QUOTE TRANSLATABLE 1 2
quotes.push(new hotTopic("Môžete vytvoriť záložku na konkrétnu stranu.", "Vytváranie záložiek", "./icfaq.htm#bookmark"));
quotes.push(new hotTopic("Hardvérovú riadiacu konzolu môžete nakonfigurovať pomocou sprievodcu riadeným nastavovaním.", "Konfigurácia HMC pomocou sprievodcu riadeným nastavovaním", "../iphai/confighmcgs.htm"));
quotes.push(new hotTopic("Môžete vytvoriť kontrolný zoznam nastavenia servera, ktorý je prispôsobený vašim potrebám.", "Vytvorenie prispôsobeného kontrolného zoznamu úvodného nastavenia servera", "../iphaf/issintwelcome.htm"));
quotes.push(new hotTopic("Môžete prevziať a nainštalovať aktualizácie pre vašu verziu Informačného centra, ktorú ste inštalovali z CD.", "Preberanie aktualizácií pre verzie Informačného centra, ktoré boli nainštalované z CD", "./icupdates.htm#downloadupdates"));
quotes.push(new hotTopic("Môžete zobraziť animovaného sprievodcu novým rozhraním Informačného centra.", "Rozhranie informačného centra", "./icfaq.htm#flashdemo"));
quotes.push(new hotTopic("Môžete inštalovať rôzne hardvérové vlastnosti a vymieňať mnoho dielov vo vašich serveroch alebo rozširujúcich jednotkách.", "Inštalácia vlastností", "../iphaj/installcifcio.htm"));
quotes.push(new hotTopic("Môžete si vybrať z niekoľkých interaktívnych kurzov a výukových programov, ktoré vám pomôžu dozvedieť sa viac o virtualizácii servera.", "Získavanie vedomostí a výukové programy", "../iphcy/learningandtutorials.html"));
quotes.push(new hotTopic("Môžete zobraziť zoznam modelov, vrátane typu-modelu počítača, úplného názvu, krátkeho názvu, značky alebo rodiny.", "Zoznam čísiel a názvov modelov", "./modelnumbersandnames.htm"));
quotes.push(new hotTopic("Pomocou prehľadnej tabuľky môžete nájsť dokumentáciu pre pSeries, ktorá sa teraz nachádza v Informačnom centre pre hardvér systémov IBM.", "Mapa publikácií pSeries v Informačnom centre", "./icpserieslist.htm"));
quotes.push(new hotTopic("Každú hlavnú tému spolu s jej podtémami môžete vytlačiť.", "Tlač", "./icfaq.htm#print"));
quotes.push(new hotTopic("Môžete sa zaregistrovať na príjem notifikácií o aktualizáciách na Internete, keď pre Informačné centrum pre hardvér systémov IBM vyjde nová aktualizácia.", "Registrácia pre aktualizácie cez Internet", "./icupdates.htm#subscribe"));

//END QUOTE TRANSLATABLE
// end array of objects
//////////////////////////////////////////////////////////////////////

//START QUOTE TRANSLATABLE
var strDidYouKnowHeader = "<H2>Vedeli ste?<\/H2>";
var sDidYouKnow = "&nbsp;&nbsp;Vedeli ste?";
var sSeeAllTips = "Zobraziť všetky tipy";
//END QUOTE TRANSLATABLE

//START NON-TRANSLATABLE
//////////////////////////////////////////////////////////////////////
// begin execution path
var HTid=getHTvalue(quotes);
// end execution path
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
// suport functions
//////////////////////////////////////////////////////////////////////
// functions to create formatted strings and write to document.
function getHotTopic(){
	result = '<A href="'+quotes[HTid].getURL()+'">'+quotes[HTid].getText()+'<\/A>';
	return result;
}
function getHotTopic2(){
	result = '<A href="'+quotes[HTid].getURL()+'"><IMG src=".\/images\/fw.gif" width="16" height="17" vspace="0" hspace="0" border="0" alt=""\/><\/A> ';
	return result;

}
function getHotTopic3(){
	result = '<A href="'+quotes[HTid].getURL()+'">'+quotes[HTid].getBlurb()+'<\/A>';
	return result;

}
function dumpHotTopics(){
	document.writeln(strDidYouKnowHeader);
	document.writeln('<BLOCKQUOTE>');
	for ( ht in quotes ) {
		result = '<P class="frontendbarlink" style="width: 100%;"><A href="'+quotes[ht].url+'">'+quotes[ht].stext+'<\/A><\/P>';
		result += '<P>'+quotes[ht].text+'<\/P>';
		document.writeln(result);
	}
	document.writeln('<\/BLOCKQUOTE>');
}
//////////////////////////////////////////////////////////////////////
// This hideous function is a work around for Netscape 4.x.  The function 
// creates the WHOLE callout box. Since, we cannot call a function from within
// a TD in Netscape 4.x, we cannot do the getHotTopic() calls in a callout box
// within the HTML.  That would result in an empty callout box. So we have a
// 'parent' function call in the HTML that creates the whole callout box.
// This function is not executed in Netscape 4.x, so there is no empty calloutbox.  QED.
function doDidYouKnow(){
	var result=getHotTopic();
	result+='<br>';
	result+=getHotTopic2();
	result+=getHotTopic3();
	result+='<br>';
	result+='       <A href=".\/hottopics.htm"><IMG src=".\/images\/fw.gif" width="16" height="17" vspace="0" hspace="0" border="0" alt=""><\/A> ';
//result+='       <A href=".\/hottopics.htm" class="fbox">'+sSeeAllTips+'</A>';
	result+='       <A href=".\/hottopics.htm">'+sSeeAllTips+'<\/A>';
	document.open();
	document.write(result);
	document.close();
}

//END NON-TRANSLATABLE

