// hottopics.js
// NLS_CHARSET=UTF-8
//
// (C) Copyright IBM Corporation, 2003, 2006                        //
// All rights reserved. Licensed Materials Property of IBM          //
// US Government Users Restricted Rights                            //
// Use, duplication or disclosure restricted by                     //
// GSA ADP Schedule Contract with IBM Corp.                         //

//START NON-TRANSLATABLE
//////////////////////////////////////////////////////////////////////
// define simple object.
function hotTopic() {
	args=hotTopic.arguments;
	this.text = args[0];
	this.stext = args[1] || "intentionally blank";
	this.url = args[2] || "";

   this.getText = getText;
   this.getBlurb = getBlurb;
   this.getURL = getURL;
}

function getText() {
	return this.text;
}
function getBlurb(){
	return this.stext;
}
function getURL(){
	return this.url;
}
//
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
// redefine the 'push' function for all browsers.
//if (Array.prototype.push && ([0].push(true)==true))
//        Array.prototype.push = null;

if(!Array.prototype.push) {
    function array_push() {
        for(i=0;i<arguments.length;i++){
            this[this.length] = arguments[i];
        }
        return this.length;
    }

    Array.prototype.push = array_push;

}
//
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// function for generating random number.

var masterHTid=null;
function getHTvalue(aQuotes){
  if (!masterHTid) {
	// select random quote (integer).
	var numRand = Math.random();
	var numQuote = aQuotes.length - 1;
	masterHTid = Math.round((numQuote - 1) * numRand) + 1;
  }
  return masterHTid;
}
//
//////////////////////////////////////////////////////////////////////




//END NON-TRANSLATABLE

//////////////////////////////////////////////////////////////////////
// initialize an array of objects.
var quotes = new Array;
//START QUOTE TRANSLATABLE 1 2
quotes.push(new hotTopic("U kunt bladwijzers instellen voor bepaalde pagina's.", "Bladwijzers", "./icfaq.htm#bookmark"));
quotes.push(new hotTopic("U kunt de Hardware Management Console configureren met de Configuratiewizard.", "De HMC configureren met de Configuratiewizard", "../iphai/confighmcgs.htm"));
quotes.push(new hotTopic("U kunt een installatiecontrolelijst maken die aangepast is aan uw situatie.", "Een aangepaste controlelijst maken voor eerste installatie van de server", "../iphaf/issintwelcome.htm"));
quotes.push(new hotTopic("U kunt updates voor de CD-versie van het Informatiecentrum downloaden en installeren.", "Updates downloaden voor de vanaf CD geïnstalleerde versie van het Informatiecentrum", "./icupdates.htm#downloadupdates"));
quotes.push(new hotTopic("U kunt een tour van de nieuwe interface van het informatiecentrum bekijken.", "Interface van het Informatiecentrum", "./icfaq.htm#flashdemo"));
quotes.push(new hotTopic("U kunt een aantal hardwarevoorzieningen installeren en onderdelen van de servers of uitbreidingseenheden vervangen.", "Voorzieningen installeren", "../iphaj/installcifcio.htm"));
quotes.push(new hotTopic("U kunt kiezen uit een aantal interactieve cursussen en zelfstudieprogramma's voor informatie over servervirtualisatie.", "e-learning en zelfstudieprogramma's", "../iphcy/learningandtutorials.html"));
quotes.push(new hotTopic("U kunt een lijst van modellen bekijken, inclusief machinetype, modelnaam, de volledige naam, de korte naam en het merk of de familie.", "Lijst van modelnummers en -namen", "./modelnumbersandnames.htm"));
quotes.push(new hotTopic("U kunt een naslagschema gebruiken voor een overzicht van pSeries-documentatie die zich nu in het IBM Systems Hardware Informatiecentrum bevindt.", "Overzicht van pSeries-documenten in het Informatiecentrum", "./icpserieslist.htm"));
quotes.push(new hotTopic("U kunt elk onderwerp afdrukken inclusief de bijbehorende subonderwerpen.", "Afdrukken", "./icfaq.htm#print"));
quotes.push(new hotTopic("U kunt zich abonneren op Internet-updates. U ontvangt dan bericht wanneer er updates beschikbaar zijn van het IBM Systems Hardware Informatiecentrum.", "Abonneren op internetupdates", "./icupdates.htm#subscribe"));

//END QUOTE TRANSLATABLE
// end array of objects
//////////////////////////////////////////////////////////////////////

//START QUOTE TRANSLATABLE
var strDidYouKnowHeader = "<H2>Wist u dat?<\/H2>";
var sDidYouKnow = "&nbsp;&nbsp;Wist u dat?";
var sSeeAllTips = "Alle tips bekijken";
//END QUOTE TRANSLATABLE

//START NON-TRANSLATABLE
//////////////////////////////////////////////////////////////////////
// begin execution path
var HTid=getHTvalue(quotes);
// end execution path
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
// suport functions
//////////////////////////////////////////////////////////////////////
// functions to create formatted strings and write to document.
function getHotTopic(){
	result = '<A href="'+quotes[HTid].getURL()+'">'+quotes[HTid].getText()+'<\/A>';
	return result;
}
function getHotTopic2(){
	result = '<A href="'+quotes[HTid].getURL()+'"><IMG src=".\/images\/fw.gif" width="16" height="17" vspace="0" hspace="0" border="0" alt=""\/><\/A> ';
	return result;

}
function getHotTopic3(){
	result = '<A href="'+quotes[HTid].getURL()+'">'+quotes[HTid].getBlurb()+'<\/A>';
	return result;

}
function dumpHotTopics(){
	document.writeln(strDidYouKnowHeader);
	document.writeln('<BLOCKQUOTE>');
	for ( ht in quotes ) {
		result = '<P class="frontendbarlink" style="width: 100%;"><A href="'+quotes[ht].url+'">'+quotes[ht].stext+'<\/A><\/P>';
		result += '<P>'+quotes[ht].text+'<\/P>';
		document.writeln(result);
	}
	document.writeln('<\/BLOCKQUOTE>');
}
//////////////////////////////////////////////////////////////////////
// This hideous function is a work around for Netscape 4.x.  The function 
// creates the WHOLE callout box. Since, we cannot call a function from within
// a TD in Netscape 4.x, we cannot do the getHotTopic() calls in a callout box
// within the HTML.  That would result in an empty callout box. So we have a
// 'parent' function call in the HTML that creates the whole callout box.
// This function is not executed in Netscape 4.x, so there is no empty calloutbox.  QED.
function doDidYouKnow(){
	var result=getHotTopic();
	result+='<br>';
	result+=getHotTopic2();
	result+=getHotTopic3();
	result+='<br>';
	result+='       <A href=".\/hottopics.htm"><IMG src=".\/images\/fw.gif" width="16" height="17" vspace="0" hspace="0" border="0" alt=""><\/A> ';
//result+='       <A href=".\/hottopics.htm" class="fbox">'+sSeeAllTips+'</A>';
	result+='       <A href=".\/hottopics.htm">'+sSeeAllTips+'<\/A>';
	document.open();
	document.write(result);
	document.close();
}

//END NON-TRANSLATABLE

