// hottopics.js
// NLS_CHARSET=UTF-8
//
// (C) Copyright IBM Corporation, 2003, 2006                        //
// All rights reserved. Licensed Materials Property of IBM          //
// US Government Users Restricted Rights                            //
// Use, duplication or disclosure restricted by                     //
// GSA ADP Schedule Contract with IBM Corp.                         //

//START NON-TRANSLATABLE
//////////////////////////////////////////////////////////////////////
// define simple object.
function hotTopic() {
	args=hotTopic.arguments;
	this.text = args[0];
	this.stext = args[1] || "intentionally blank";
	this.url = args[2] || "";

   this.getText = getText;
   this.getBlurb = getBlurb;
   this.getURL = getURL;
}

function getText() {
	return this.text;
}
function getBlurb(){
	return this.stext;
}
function getURL(){
	return this.url;
}
//
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
// redefine the 'push' function for all browsers.
//if (Array.prototype.push && ([0].push(true)==true))
//        Array.prototype.push = null;

if(!Array.prototype.push) {
    function array_push() {
        for(i=0;i<arguments.length;i++){
            this[this.length] = arguments[i];
        }
        return this.length;
    }

    Array.prototype.push = array_push;

}
//
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// function for generating random number.

var masterHTid=null;
function getHTvalue(aQuotes){
  if (!masterHTid) {
	// select random quote (integer).
	var numRand = Math.random();
	var numQuote = aQuotes.length - 1;
	masterHTid = Math.round((numQuote - 1) * numRand) + 1;
  }
  return masterHTid;
}
//
//////////////////////////////////////////////////////////////////////




//END NON-TRANSLATABLE

//////////////////////////////////////////////////////////////////////
// initialize an array of objects.
var quotes = new Array;
//START QUOTE TRANSLATABLE 1 2
quotes.push(new hotTopic("E' possibile contrassegnare una determinata pagina.", "Segnalibri", "./icfaq.htm#bookmark"));
quotes.push(new hotTopic("E' possibile configurare l'HMC (Hardware Management Console) utilizzando la procedura di installazione guidata.", "Configurazione dell'HMC utilizzando la procedura di installazione guidata", "../iphai/confighmcgs.htm"));
quotes.push(new hotTopic("E' possibile creare l'elenco di controllo di configurazione iniziale del server personalizzato secondo le necessità.", "Creazione di un elenco di controllo di configurazione iniziale del server personalizzato", "../iphaf/issintwelcome.htm"));
quotes.push(new hotTopic("E' possibile scaricare ed installare gli aggiornamenti per la versione installata da CD dell'Information Center.", "Download degli aggiornamenti per la versione installata da CD dell'Information Center", "./icupdates.htm#downloadupdates"));
quotes.push(new hotTopic("E' possibile visualizzare una visita interattiva del prodotto della nuova interfaccia dell'Information Center.", "Interfaccia dell'Information Center", "./icfaq.htm#flashdemo"));
quotes.push(new hotTopic("E' possibile installare vari dispositivi hardware e sostituire molte parti nei server o nelle unità di espansione.", "Installazione di dispositivi", "../iphaj/installcifcio.htm"));
quotes.push(new hotTopic("E' possibile scegliere tra differenti esercitazioni e corsi interattivi, utili per avere ulteriori informazioni sulla virtualizzazione del server.", "Learning and tutorials", "../iphcy/learningandtutorials.html"));
quotes.push(new hotTopic("E' possibile visualizzare un elenco dei modelli che comprende il nome MTM (machine type-model), il nome completo, il nome in forma breve e la marca o la famiglia.", "Elenco dei nomi e dei numeri dei modelli", "./modelnumbersandnames.htm"));
quotes.push(new hotTopic("E' possibile utilizzare un grafico facile da consultare per trovare la documentazione pSeries ora presente nell'IBM Systems Hardware Information Center.", "Mappa dei manuali pSeries nell'Information Center", "./icpserieslist.htm"));
quotes.push(new hotTopic("E' possibile stampare ciascun argomento principale insieme ai relativi sottoargomenti.", "Stampa", "./icfaq.htm#print"));
quotes.push(new hotTopic("E' possibile iscriversi agli aggiornamenti Internet per ricevere le notifiche degli aggiornamenti dell'IBM Systems Hardware Information Center.", "Iscrizione agli aggiornamenti Internet", "./icupdates.htm#subscribe"));

//END QUOTE TRANSLATABLE
// end array of objects
//////////////////////////////////////////////////////////////////////

//START QUOTE TRANSLATABLE
var strDidYouKnowHeader = "<H2>Sapevate che...<\/H2>";
var sDidYouKnow = "&nbsp;&nbsp;Sapevate che...?";
var sSeeAllTips = "Consultare tutti i suggerimenti";
//END QUOTE TRANSLATABLE

//START NON-TRANSLATABLE
//////////////////////////////////////////////////////////////////////
// begin execution path
var HTid=getHTvalue(quotes);
// end execution path
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
// suport functions
//////////////////////////////////////////////////////////////////////
// functions to create formatted strings and write to document.
function getHotTopic(){
	result = '<A href="'+quotes[HTid].getURL()+'">'+quotes[HTid].getText()+'<\/A>';
	return result;
}
function getHotTopic2(){
	result = '<A href="'+quotes[HTid].getURL()+'"><IMG src=".\/images\/fw.gif" width="16" height="17" vspace="0" hspace="0" border="0" alt=""\/><\/A> ';
	return result;

}
function getHotTopic3(){
	result = '<A href="'+quotes[HTid].getURL()+'">'+quotes[HTid].getBlurb()+'<\/A>';
	return result;

}
function dumpHotTopics(){
	document.writeln(strDidYouKnowHeader);
	document.writeln('<BLOCKQUOTE>');
	for ( ht in quotes ) {
		result = '<P class="frontendbarlink" style="width: 100%;"><A href="'+quotes[ht].url+'">'+quotes[ht].stext+'<\/A><\/P>';
		result += '<P>'+quotes[ht].text+'<\/P>';
		document.writeln(result);
	}
	document.writeln('<\/BLOCKQUOTE>');
}
//////////////////////////////////////////////////////////////////////
// This hideous function is a work around for Netscape 4.x.  The function 
// creates the WHOLE callout box. Since, we cannot call a function from within
// a TD in Netscape 4.x, we cannot do the getHotTopic() calls in a callout box
// within the HTML.  That would result in an empty callout box. So we have a
// 'parent' function call in the HTML that creates the whole callout box.
// This function is not executed in Netscape 4.x, so there is no empty calloutbox.  QED.
function doDidYouKnow(){
	var result=getHotTopic();
	result+='<br>';
	result+=getHotTopic2();
	result+=getHotTopic3();
	result+='<br>';
	result+='       <A href=".\/hottopics.htm"><IMG src=".\/images\/fw.gif" width="16" height="17" vspace="0" hspace="0" border="0" alt=""><\/A> ';
//result+='       <A href=".\/hottopics.htm" class="fbox">'+sSeeAllTips+'</A>';
	result+='       <A href=".\/hottopics.htm">'+sSeeAllTips+'<\/A>';
	document.open();
	document.write(result);
	document.close();
}

//END NON-TRANSLATABLE

