#!/bin/bash

# checkmedia.sh
#
# Usage: checkmedia.sh <device file> <media type> <log file>
#
# 00  10/28/2004  P. Provost  Rewritten for support of USB flash memory drives
# 01  03/17/2005  P. Provost  Fixed tracing
# 02  09/05/2006  J. Kunz     Handle USB Diskette returning 'No medium found' in MCP4
# 03  12/07/2006  J. Kunz     Handle dd returning 'error' as no media found

DEVICEFILE=$1
MEDIA=$2
LOGFILE=$3

echo "-> checkmedia.sh" >> $LOGFILE
echo "checkmedia.sh: Checking if the media is present in the device at $DEVICEFILE for `date`" >> $LOGFILE

actzTrace "XMDA   T: -> checkmedia.sh"
actzTrace "XMDA   F: checkmedia.sh: Checking if the media is present in the device at $DEVICEFILE for `date`"

# Determine what drive is to be used to check for the presence of the media
case "$MEDIA" in
    1)
        # Check if the media is present in a diskette drive
	echo "checkmedia.sh: Checking a diskette drive for the presence of the media." >> $LOGFILE
	actzTrace "XMDA   F: checkmedia.sh: Checking a diskette drive for the presence of the media."
        
        if dd if=$DEVICEFILE bs=1 skip=32808 count=1 2>&1 | grep -q -i 'No such device or address
error
No medium found'; then
            
            echo "checkmedia.sh: No media is present in the diskette drive." >> $LOGFILE
	    actzTrace "XMDA   F: checkmedia.sh: No media is present in the diskette drive."
            
            echo "<- checkmedia.sh for `date`" >> $LOGFILE
            echo "" >> $LOGFILE
            
            actzTrace "XMDA   T: <- checkmedia.sh for `date`"            
            
            exit 1
        
        else
            
            echo "checkmedia.sh: Media is present in the diskette drive." >> $LOGFILE
            actzTrace "XMDA   F: checkmedia.sh: Media is present in the diskette drive."
	
        fi
    ;;
    2)
        # Check if the media is present in a CD-ROM/DVD-RAM drive
	echo "checkmedia.sh: Checking a CD-ROM/DVD-RAM drive for the presence of the media." >> $LOGFILE
        actzTrace "XMDA   F: checkmedia.sh: Checking a CD-ROM/DVD-RAM drive for the presence of the media."
	
        if dd if=$DEVICEFILE bs=1 skip=32808 count=1 2>&1 | grep -q -i 'No medium found
error'; then
	    
            echo "checkmedia.sh: No media is present in the CD-ROM/DVD-RAM drive." >> $LOGFILE
            actzTrace "XMDA   F: checkmedia.sh: No media is present in the CD-ROM/DVD-RAM drive." 
            
            echo "<- checkmedia.sh for `date`" >> $LOGFILE
            echo "" >> $LOGFILE
            
            actzTrace "XMDA   T: <- checkmedia.sh for `date`"
	    
            exit 1
	
        else
	    
            echo "checkmedia.sh: Media is present in the CD-ROM/DVD-RAM drive." >> $LOGFILE
            actzTrace "XMDA   F: checkmedia.sh: Media is present in the CD-ROM/DVD-RAM drive."
	
        fi
    ;;
    8)
        # Check if the USB flash memory drive is present
	echo "checkmedia.sh: Checking if a USB flash memory drive is present." >> $LOGFILE
	actzTrace "XMDA   F: checkmedia.sh: Checking if a USB flash memory drive is present."
        
        if dd if=$DEVICEFILE bs=1 skip=32808 count=1 2>&1 | grep -q -i 'No such device or address
error'; then
            
            echo "checkmedia.sh: No USB flash memory drive is present." >> $LOGFILE
	    actzTrace "XMDA   F: checkmedia.sh: No USB flash memory drive is present."

            echo "<- checkmedia.sh for `date`" >> $LOGFILE
            echo "" >> $LOGFILE
            
            actzTrace "XMDA   T: <- checkmedia.sh for `date`"           
            
            exit 1
        
        else
            
	    echo "checkmedia.sh: A USB flash memory drive is present" >> $LOGFILE
            actzTrace "XMDA   F: checkmedia.sh: A USB flash memory drive is present."
	
        fi
    ;;   
esac

echo "<- checkmedia.sh for `date`" >> $LOGFILE
echo "" >> $LOGFILE

actzTrace "XMDA   T: <- checkmedia.sh for `date`"

exit 0


