#!/bin/bash

actzTrace "XSETNETT: -> createFirewallChain $*"

if [ -x /sbin/iptables ]; then
    iptables=/sbin/iptables
elif [ -x /usr/sbin/iptables ]; then
    iptables=/usr/sbin/iptables
else
    actzTrace "XSETNETF: createFirewallChain: No 'iptables' executable found"
    exit 0
fi

$iptables --new $1 && \
$iptables --insert INPUT --in-interface "$2" --jump $1
rc=$?

actzTrace "XSETNETT: <- createFirewallChain: rc=$rc"

exit $rc
