#!/bin/bash
#
# detectdevices.sh
#
# Usage: devicefile.sh <hwinfo parms> <temp file> <log file> <delete log>
#
# Return Codes:
#
# Module History:
#  00  12/28/2004  P. Provost  Initial release
#  01  03/17/2005  P. Provost  Fixed tracing
#  02  04/27/2006  J. Kunz     add parm to delete log, ensure log has permissions 660

PARMS=$1
TEMPFILE=$2
LOGFILE=$3
DELETELOG=$4

# if delete indicator is a 1, delete the log
if [ "$DELETELOG" = "1" ]; then
	rm $LOGFILE
fi
# ensure log exists with permissions 660
touch $LOGFILE
chmod 660 $LOGFILE

echo "-> detectdevices.sh" >> $LOGFILE
echo "detectdevices.sh: Detecting media devices $PARMS for `date`" >> $LOGFILE

actzTrace "XMDA   T: -> detectdevices.sh"
actzTrace "XMDA   F: detectdevices.sh: Detecting media devices $PARMS for `date`"

# run the SUSE hwinfo command and pass it the appropriate parameters 
if /usr/sbin/hwinfo $PARMS > $TEMPFILE; then
    
    # copy the output of the hwinfo command to the log file
    echo "" >> $LOGFILE    
    cat $TEMPFILE >> $LOGFILE
    echo "" >> $LOGFILE    

    echo "<- detectdevices.sh for `date`" >> $LOGFILE
    echo "" >> $LOGFILE    
    
    actzTrace "XMDA   T: <- detectdevices.sh for `date`"
    
    exit 0

# Else the script to detect devices failed         
else
    
    echo "detectdevices.sh Error detecting devices" >> $LOGFILE
    actzTrace "XMDA   F: detectdevices.sh: Error detecting devices."

    echo "" >> $LOGFILE    
    cat $TEMPFILE >> $LOGFILE
    echo "" >> $LOGFILE    
    
    echo "<- detectdevices.sh for `date`" >> $LOGFILE
    echo "" >> $LOGFILE
    
    actzTrace "XMDA   T: <- detectdevices.sh for `date`"
    
    exit 1
fi
 

