#!/bin/bash

# dvdformat.sh
#
# Usage: dvdformat.sh <device file> <log file> <label>
#
# Label: The optional volume id for the DVD-RAM media
#
# Return Codes:
# 2 - Error formating the dvd media
#
# Module History
#  00  05/10/02  D. Deamond - Initial Release
#  01  07/12/02  P. Provost - Changed to use mkudffs instead of mkudf
#  02  07/18/02  P. Provost - Changed script to use device file argument
#  03  12/03/03  P. Provost - Removed params --udrev=0x0150 --media-type=dvdram --blocksize=2048
#  04  01/14/03  P. Provost - Put --udfrev=0x0150 back in because of problems with default value
#  05  12/14/04  P. Provost - Removed the --lvid option, use only the --vid option for label
#  06  12/15/04  P. Provost - Put quotes around $LABEL in case the given label contains spaces
#  07  03/17/05  P. Provost - Fixed tracing.
#  08  04/25/05  P. Provost - Put --lvid option back in because OS/2 looks for logical volume id
#  09  08/29/05  J. Kunz    - Remove check for whether label is blank, use label that comes in either way
#  10  01/19/07  J. Kunz    - Zero out 1st 32K before running mkudffs

DEVICEFILE=$1
LOGFILE=$2
LABEL=$3

echo "-> dvdformat.sh" >> $LOGFILE
echo "dvdformat.sh: Formatting the DVD-RAM at $DEVICEFILE for `date`" >> $LOGFILE

actzTrace "XMDA   T: -> dvdformat.sh"
actzTrace "XMDA   F: dvdformat.sh: Formatting the DVD-RAM at $DEVICEFILE for `date`"

# first zero out the first 32K
echo "dvdformat.sh: zero out first 32K at $DEVICEFILE for `date`" >> $LOGFILE
dd if=/dev/zero of=$DEVICEFILE count=32768 >> $LOGFILE 2>&1
echo "dvdformat.sh: zero out finished at $DEVICEFILE for `date`" >> $LOGFILE

# Format the DVD-RAM media with the given label, blank or otherwise
echo "dvdformat.sh: Formatting the DVD-RAM with the label: $LABEL" >> $LOGFILE
actzTrace "XMDA   F: dvdformat.sh: Formatting the DVD-RAM with the label: $LABEL" 

if ! mkudffs --udfrev=0x0150 --vid="$LABEL" --lvid="$LABEL" $DEVICEFILE >> $LOGFILE 2>&1; then  
  
  echo "dvdformat.sh: Couldn't format the DVD-RAM media...exiting" >> $LOGFILE
  actzTrace "XMDA   F: dvdformat.sh: Couldn't format the DVD-RAM media...exiting"
  
  echo "<- dvdformat.sh for `date`" >> $LOGFILE
  echo "" >> $LOGFILE
  
  actzTrace "XMDA   T: <- dvdformat.sh for `date`"
  
  exit 2

fi

echo "<- dvdformat.sh for `date`" >> $LOGFILE
echo "" >> $LOGFILE

actzTrace "XMDA   T: <- dvdformat.sh for `date`"

exit 0
