#!/bin/bash

actzTrace "XSETNETT: editFirewallChain $*"

op=$1
chain=$2
ifname=$3
protocol=$4
sourceAddr=$5
sourceAddrMask=$6
port=$7

if [ -x /sbin/iptables ]; then
    iptables=/sbin/iptables
elif [ -x /usr/sbin/iptables ]; then
    iptables=/usr/sbin/iptables
else
    actzTrace "XSETNETF: editFirewallChain: No iptables executable found."
    exit 0
fi

if [ "$protocol" = "icmp" ]; then
    cmd="$iptables $op $chain --in-interface \"$ifname\" --protocol $protocol --source $sourceAddr/$sourceAddrMask --icmp-type $port --jump ACCEPT --verbose"
    actzTrace "XSETNETF: executing cmd: '$cmd'"
    eval $cmd
    rc=$?
elif echo $port | grep ","; then
    ports=$(echo $port | sed -e "s/,/ /g")
    for port in $ports; do
        cmd="$iptables $op $chain --in-interface \"$ifname\" --protocol $protocol --source $sourceAddr/$sourceAddrMask --destination-port $port --jump ACCEPT --verbose"
        actzTrace "XSETNETF: executing cmd: '$cmd'"
        eval $cmd
        rc=$?
        if [ "$rc" != "0" ]; then
            exit $rc
        fi
    done
else
    cmd="$iptables $op $chain --in-interface \"$ifname\" --protocol $protocol --source $sourceAddr/$sourceAddrMask --destination-port $port --jump ACCEPT --verbose"
    actzTrace "XSETNETF: executing cmd: '$cmd'"
    eval $cmd
    rc=$?
fi

actzTrace "XSETNETF: <- editFirewallChain: rc=$rc"

exit $rc
