#!/bin/bash

# findsymlink.sh
#
# Usage: findsymlink.sh <pathstring> <temp file> <log file>
#
# Return Codes:
# 1 - Error finding symbolic link
#
# Author: P. Provost

PATHSTRING=$1
TEMPFILE=$2
LOGFILE=$3

echo "-> findsymlink.sh" >> $LOGFILE
echo "`date` Checking if $PATHSTRING is a symbolic link." >> $LOGFILE

actzTrace "XMDA   T: -> findsymlink.sh"
actzTrace "XMDA   F: findsymlink.sh: `date` Checking if $PATHSTRING is a symbolic link"

ls -l $PATHSTRING >> $LOGFILE 

if ls -l $PATHSTRING | grep '>' > $TEMPFILE; then
    
    actzTrace "XMDA   F: findsymlink.sh: $PATHSTRING is a symbolic link" 
    echo "$PATHSTRING is a symbolic link" >> $LOGFILE
    cat $TEMPFILE >> $LOGFILE # Add the result of the search to the log file
    
    actzTrace "XMDA   T: <- findsymlink.sh"
    echo "<- findsymlink.sh" >> $LOGFILE
    echo "" >> $LOGFILE
    exit 0
else

    actzTrace "XMDA   F: findsymlink.sh: $PATHSTRING is not a symbolic link"
    actzTrace "XMDA   T: <- findsymlink.sh"
    
    echo "$PATHSTRING is not a symbolic link" >> $LOGFILE
    echo "<- findsymlink.sh" >> $LOGFILE
    echo "" >> $LOGFILE
    exit 1
fi
