#!/usr/bin/perl -w

#
# 06/30/2006 S. Lyons MM line item to monitor modem use
#
# The file /proc/tty/driver/serial can not be read by 
# a non-root user.  If you are not root the full information
# in the file is not visible.  The info of interest is the 
# state of the modem lines, ie CD, CTS, ... and the number of
# bytes sent and received.   Only root is privy to this info. 
# This script should be called by the 
# com.ibm.hwmca.fw.util.cmd.Command.execAsRoot method.  The 
# main purpose of this script is to run as root, open the 
# file /proc/tty/driver/serial and write its contents to
# standard out.  The execAsRoot program captures standard 
# out and makes it available to the calling Java program. 

$SYSTEM_MODEM_FILE = "/proc/tty/driver/serial";
$UNABLE_TO_OPEN_FILE = 10;
$GOOD_RETURN         =  0;

# Open the modem stat file
open (MODEMSTAT, "$SYSTEM_MODEM_FILE")
  or exit($UNABLE_TO_OPEN_FILE);

# Write its contents to standard out
while(<MODEMSTAT>) {
  print "$_" ;
}

exit($GOOD_RETURN);

