#!/bin/bash
#
# Collect HMC EED 
#
# Description: Issue to Collect HMC EED for the machinne 
#
# Change Activity:
#   05/08/2006 Dovin       - initial version collect hmc eed code level and connected systems 
#   10/19/2006 Dovin       - change lshmc to not go through command router 572913
#
#STARTUSAGE
#
# Usage:
#   collecteed -l palock
#
# Where:
#   -l   lock 
#
#
#ENDUSAGE
#****************************************************************************
noopt=1
giveUsage=0

echo the parms are "$1"

# Parse the options
while getopts 'l:?' optname; do
   case "$optname" in
      l) palock="$OPTARG";;
      \?) giveUsage=1; break;;
   esac
   noopt=0
done


if [ "$giveUsage" -eq 1 ]; then
   # Print out the prologue comments as usage info
   sed -e '/STARTUSAGE/,/ENDUSAGE/ s/^#//' -e '1,/STARTUSAGE/ d' -e '/ENDUSAGE/,$ d' "$0"
   exit 0
fi
      
if [ "$noopt" -eq 1 ]; then
   # Print out the prologue comments as usage info
   sed -e '1 d' -e '2,/ENDUSAGE/ s/^#//' -e '/ENDUSAGE/,$ d' "$0"
   exit 0
fi

# ------------------------------------
# find necessary archiving directories
# ------------------------------------

# attempt to locate hmcfunctions script
if [ -z "$CONSOLE_PATH" ]; then
   CONSOLE_PATH="$HWMCAHOME/"
fi
echo " hwmcahome dir =$HWMCAHOME"
FOUND=
for FUNCDIR in "" "$CONSOLE_PATH/" "$CONSOLE_PATH/native/scripts/"; do
   . ${FUNCDIR}hmcfunctions >/dev/null 2>&1 && FOUND=true && break 1
done
if [ -z "$FOUND" ]; then
   echo "Error: Could not locate hmcfunctions script file!" >&2
   exit 2
fi

# find locations and names of archiving files
CONFIG_FILE="`queryFileLocation eeddirectory`"
if [ ! -e $CONFIG_FILE ]; then
   echo "Error: Could not locate eeddirectory !" >&2
   exit 6
else
   echo "found eeddirectory $CONFIG_FILE"
fi
  


    echo "collect base information for hmc eed"
    echo "/opt/hsc/bin/lshmc -V"
    /opt/hsc/bin/lshmc -V  > $CONFIG_FILE/${palock}tmphmc.eed
    echo "/opt/hsc/bin/lssysconn -r all"
    /opt/hsc/bin/lssysconn -r all  >>  $CONFIG_FILE/${palock}tmphmc.eed
    
  mv $CONFIG_FILE/${palock}tmphmc.eed $CONFIG_FILE/hmc.eed
 



exit 0
