#!/usr/bin/perl -w
##
## iqzmShutdownProcessingAsRoot.pl
##
## (c)  Copyright  IBM Corp.  2006  All Rights Reserved
##
## US Government Users Restricted Rights - Use, duplication or
## disclosure restricted by GSA ADP Schedule Contract with IBM Corp
##
##
## This script is run when it is time to run the iqzmShutdownProcessing.pl
## script but the caller is not running as root. This is run in the root
## environment created by runAsRoot. It sets up the environment to call
## the true iqzmShutdownProcessing.pl script.
##
## Module History:
##  -00 04/18/2006 John Thornton   D66D H8721 - new file swapping
##
##

################################################################################
######                          GLOBAL VARIABLES                          ######
################################################################################

# Trace Constants
$TRC_T = "XMCLSHLT:";
$TRC_F = "XMCLSHLF:";

# Program Data
$me = $0;
$me =~ s/^(.*)\///;
$me =~ s/.pl$//;

$traceCmd = "actzTrace";

################################################################################
######                          SHARED METHODS                            ######
################################################################################

# If an error occurs that prevents this function from doing its job, then the
# likely result is that the command execution that required this setup will
# fail. That will be sufficient to reflect this error into the traces and logs.
#
sub createEnvironment
{
   my $this = $me . ".createEnvironment()";
   trace("$TRC_T -> $this");
   my $consoleDir;
   # Many possibilities in the non-production world
   if ($ENV{'CONSOLE_PATH'})
   {
      $consoleDir = $ENV{'CONSOLE_PATH'}.'/';
      trace("$TRC_F    $this - used CONSOLE_PATH");
   }
   elsif ($ENV{'HWMCAHOME'})
   {
      $consoleDir = $ENV{'HWMCAHOME'}.'/';
      trace("$TRC_F    $this - used HWMCAHOME");
   }
   else
   {
      $consoleDir = "/console/";
      trace("$TRC_F    $this - used default");
   }
   # Change any "//" to "/"
   $consoleDir =~ s/\/+/\//g;
   trace("$TRC_F    $this - console root is $consoleDir");
   if ( -x "$consoleDir/hmcfunctions" )
   {
     my $myhmcfunctions = $consoleDir . "hmcfunctions";
     `. $myhmcfunctions; setupEnv $consoleDir`;
     # Nothing, no error is ever returned
   }
   else
   {
     # This should never happen.
     trace("$TRC_F    $this - hmcfunctions not found!");
   }
   trace("$TRC_T <- $this");
}

#
#
#
sub trace
{
    my $text = shift;
    chomp($text);

    if ("actzTrace" eq "$traceCmd")
    {
       system(("$traceCmd", "$text"));
    }
    else
    {
       print(STDOUT "$text\n");
    }
}


################################################################################
######                           SCRIPT CODE                              ######
################################################################################

# No arguments

trace("$TRC_T -> $me(@ARGV)");

# Set up the execution environment, because linux took away our PATH and
# LD_LIBRARY_PATH environment variables for security reasons.

createEnvironment();

# Now run the "real" shutdown file swapping code.

my $error = `iqzmShutdownProcessing.pl 2>&1`;
my $rc = $? >> 8;

trace("$TRC_T <- $me() - rc = $rc");

exit($rc);
