#!/bin/bash

# rcsKillTree.sh
#
# Usage: cdvdlabel.sh <parent pid> 
#  Find all the pids of the process that have lineage back to the input pid, 
#  and stop them all.   This is based upon a script originally written by Jim 
#  Hennessy.
# Error Return Codes:
# 1 - missing input parm 
# 2 - input pid not found to be running 
# 3 - not all requested pids were stopped.
# 
#
# Author: S. Lyons
#
# 06/30/20006 S  lyons    initial code for MM lineitem to reset the modem 
#

function printChildren() {
   local child
   local children=$(pgrep -P "$1")
   if [[ -n "$children" ]]; then
      echo $children
      for child in $children; do
         printChildren $child
      done
   fi
}


actzTrace "XRCSMMOF: -> rcsKillTree.sh  $*"

if [[ -z "$1" ]]; then
    actzTrace "XRCSMMOF:  rcsKillTree.sh missing input parent-pid"
   exit 1
fi

pid="$1"

if [[ ! -e "/proc/$pid" ]]; then
   actzTrace "XRCSMMOF: rcsKillTree.sh pid $pid not found." 
   exit 2
fi

allpids="$pid $(printChildren $pid)"
actzTrace "XRCSMMOF: rcsKillTree.sh Stoping the following pids:  $allpids"

kill -9 $allpids

 
if [[ $? -NE 0 ]]; then
   actzTrace "XRCSMMOF: rcsKillTree.sh Not all pids were stopped." 
   exit 3
fi

actzTrace "XRCSMMOF: <- rcsKillTree.sh  $allpids"

exit 0 
