#!/bin/bash

# rundf.sh
#
# Usage: rundf.sh <temp file> <log file>
#
# Return Codes:
# 1 - Error running df command
#
# Author: C. Schuck
# 05/20/2003  P. Provost  changed 2>&1 to > /dev/null
# 03/17/2005  P. Provost  Fixed tracing
# 07/13/2006  J. Kunz     return counts in bytes --block-size=1

TEMPFILE=$1
LOGFILE=$2

echo "-> rundf.sh" >> $LOGFILE
actzTrace "XMDA   T: -> rundf.sh"

echo "rundf.sh: Running df command to check the filesystems of media for `date`" >> $LOGFILE
actzTrace "XMDA   F: rundf.sh: Running df command to check the filesystems of media for `date`"

if ! df --block-size=1 --print-type | tee --append $TEMPFILE $LOGFILE > /dev/null; then

   echo "rundf.sh: Couldn't run df.. exiting" >> $LOGFILE
   actzTrace "XMDA   F: rundf.sh: Couldn't run df.. exiting"

   echo "<- rundf.sh for `date`" >> $LOGFILE
   echo "" >> $LOGFILE

   actzTrace "XMDA   T: <- rundf.sh for `date`"
   
   exit 1
fi

echo "<- rundf.sh for `date`" >> $LOGFILE
echo "" >> $LOGFILE

actzTrace "XMDA   T: <- rundf.sh for `date`"

exit 0

