#!/bin/bash

# unmountmedia.sh
#
# Usage: unmountmedia.sh <mount point> <log file>
#
# mount point: the mount point for the media
#
# Return Codes:
# 1 - Error unmounting the media
#
# Author: C. Schuck
#
# Module History
#  00  01/22/2004  P. Provost - Changed to not look in mtab to do umount
#  01  03/16/2005  P. Provost - Changed back to look in mtab before unmount
#  02  03/17/2005  P. Provost - Fixed tracing
#  03  04/18/2005  P. Provost - Commented out sleep delay before unmounting
#  04  04/20/2005  P. Provost - Put sleep back because of intermittent unmount errors
#  05  08/17/2005  S. Nichols - Add retry logic                          
#  06  03/06/2006  J. Kunz    - when umount fails pump lsof info into mediasvcs.log, 
#								use tempfile (need change in MediaDevice.unmount())
#  07  07/31/2006  J. Kunz    - remove ignore of "not mounted" command output check

MOUNTPOINT=$1
LOGFILE=$2
TEMPFILE=$3

echo "-> unmountmedia.sh" >> $LOGFILE
echo "unmountmedia.sh: Unmounting media at $MOUNTPOINT for `date`" >> $LOGFILE

actzTrace "XMDA   T: -> unmountmedia.sh"
actzTrace "XMDA   F: unmountmedia.sh: Unmounting media at $MOUNTPOINT for `date`"

echo "unmountmedia.sh: checking /etc/mtab for mounted media at $MOUNTPOINT" >> $LOGFILE
actzTrace "XMDA   F: unmountmedia.sh: checking /etc/mtab for mounted media at $MOUNTPOINT"

echo "unmountmedia.sh: contents of /etc/mtab = " >> $LOGFILE
echo "" >> $LOGFILE
cat /etc/mtab >> $LOGFILE
echo "" >> $LOGFILE 

if ! umount -vf $MOUNTPOINT > $TEMPFILE 2>&1; then

    echo "***$TEMPFILE***" >> $LOGFILE
    cat $TEMPFILE >> $LOGFILE
    echo "***$TEMPFILE***" >> $LOGFILE
   	
    echo "unmountmedia.sh: Couldn't unmount the media at $MOUNTPOINT... put lsof info to $LOGFILE" >> $LOGFILE
    actzTrace "XMDA   F: unmountmedia.sh: Couldn't unmount the media at $MOUNTPOINT...put lsof info to $LOGFILE."
    echo "lsof info begin" >> $LOGFILE
    lsof | grep $MOUNTPOINT >> $LOGFILE 2>&1
    echo "lsof info end" >> $LOGFILE
   	
    echo "unmountmedia.sh: Couldn't unmount the media at $MOUNTPOINT... sleep then retry" >> $LOGFILE
    actzTrace "XMDA   F: unmountmedia.sh: Couldn't unmount the media at $MOUNTPOINT...sleep then retry."

    # Sleep for a few seconds to ensure that Java garbage collection occurs
    # before the unmount is attemped. Otherwise, there may be some Java objects
    # hanging around that reference paths to the media that can cause the umount
    # command to fail with device busy errors. See MediaDevice.unmount()
    # for the explicit call to Java garbage collector.  
    sleep 10
    if ! umount -vf $MOUNTPOINT > $TEMPFILE 2>&1; then
	
	    echo "***$TEMPFILE***" >> $LOGFILE
	    cat $TEMPFILE >> $LOGFILE
	    echo "***$TEMPFILE***" >> $LOGFILE
   	
    	echo "unmountmedia.sh: Still couldn't unmount the media at $MOUNTPOINT... put lsof info to $LOGFILE" >> $LOGFILE
	    actzTrace "XMDA   F: unmountmedia.sh: Still couldn't unmount the media at $MOUNTPOINT...put lsof info to $LOGFILE."
    	echo "lsof info begin" >> $LOGFILE
	    lsof | grep $MOUNTPOINT >> $LOGFILE 2>&1
    	echo "lsof info end" >> $LOGFILE
    
        echo "unmountmedia.sh: Still couldn't unmount the media at $MOUNTPOINT... exiting" >> $LOGFILE
        actzTrace "XMDA   F: unmountmedia.sh: Still couldn't unmount the media at $MOUNTPOINT...exiting."
        echo "<- unmountmedia.sh for `date`" >> $LOGFILE
        echo "" >> $LOGFILE
        
        actzTrace "XMDA   T: <- unmountmedia.sh for `date`"
       	
        exit 1
    else	        		
	    echo "***$TEMPFILE***" >> $LOGFILE
	    cat $TEMPFILE >> $LOGFILE
	    echo "***$TEMPFILE***" >> $LOGFILE	   	
    fi
else	
    echo "***$TEMPFILE***" >> $LOGFILE
    cat $TEMPFILE >> $LOGFILE
    echo "***$TEMPFILE***" >> $LOGFILE
fi  

echo "<- unmountmedia.sh for `date`" >> $LOGFILE
echo "" >> $LOGFILE

actzTrace "XMDA   T: <- unmountmedia.sh for `date`"

exit 0
