<%--
 This is an error page delivered by the Connect servlet when the user attempts
 to reconnect to a session that does not exist.  Its job is to display an
 error message and offer them a choice to logon normally or to cancel.
--%>

<%@taglib prefix="c" uri="http://java.sun.com/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>

<%@page session="false"%>   <%-- prevent a session from being created --%>

<fmt:bundle basename="com.ibm.hwmca.fw.servlet.connect.res.connect">
<html>
<head>
   <hmc:title><fmt:message key="reconnectErrorTitle"/></hmc:title>
   <link href='<%=application.getAttribute("hmcStyleSheet")%>' rel="stylesheet" type="text/css"/>
   <link rel="SHORTCUT ICON" href="/favicon.ico"/>
   <link rel="icon" href="/hmc.png" type="image/png"/>

<%--
   Internet Explorer exhibits some weird and (I think) incorrect behavior
   when submitting forms contains <button> tags.  It does two things wrong:

    1. It submits information for every button tag in the form, not just the
       one that was pressed.  This makes it impossible to determine what button
       was pressed.
    2. It submits the text making up the body of the <button> tag instead of
       the value of the "value" attribute.  This is a problem for us because
       the button label itself may have been translated.

   The following function is used to correct this behavior on IE.  It
   explicitly loads the URL set on the form, manually appending the value.
   Note that it uses the "id" attribute instead of the "value" attribute,
   because IE seems to return the body of the <button> tag instead of the
   value of the "value" attribute, when asking for the "value" attribute.  Sigh.
--%>
   <script type="text/javascript" language="JavaScript">
      function submitAnswer(buttonTag) {
         var ie = navigator.userAgent.indexOf("MSIE") != -1;
         if (!ie) return true;

         if (buttonTag.id.length == 0) {
            location.replace(buttonTag.form.action);
         } else {
            var separator = buttonTag.form.action.indexOf('?') == -1 ? "?" : "&";
            location.replace(buttonTag.form.action+separator+buttonTag.name+'='+buttonTag.id);
         }
         return false;
      }
   </script>
</head>
<body>
<span class="cont1">
<h1><fmt:message key="reconnectErrorTitle"/></h1>
<p><fmt:message key="reconnectErrorMessage"/></p>
<p/>
<form action="<c:out value='${connectURL}' escapeXml='false'/>" method="post">
 <button type="submit"
         class="b1" onmouseout="className='b1'"
         onmouseover="className='b2'"
         onclick="return submitAnswer(this);">
    <fmt:message key="proceedButtonLabel"/>
 </button>

 <button type="submit" name="session" value="cancel" id="cancel"
         class="b1" onmouseout="className='b1'"
         onmouseover="className='b2'"
         onclick="return submitAnswer(this);">
    <fmt:message key="cancelButtonLabel"/>
 </button>
</form>
</span>
</body>
</html>
</fmt:bundle>
