<%--
 This is an error page delivered by the TaskInterface servlet when the user
 appears to have interacted with a page in the browser's history, but we can't
 figure out what task is affected.  Its job is to display a brief warning
 message instructing them not to do that, then redirect the browser to a URL
 that will show the current panel for that task, using the window's name as the
 key.
--%>

<%@taglib prefix="c" uri="http://java.sun.com/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>

<fmt:bundle basename="com.ibm.hwmca.fw.servlet.tasks.res.task">
<html>
<head>
   <hmc:title><fmt:message key="historyWarningTitle"/></hmc:title>
   <link href='<%=application.getAttribute("hmcStyleSheet")%>' rel="stylesheet" type="text/css"/>
   <link rel="SHORTCUT ICON" href="/favicon.ico"/>
   <link rel="icon" href="/hmc.png" type="image/png"/>
   <script type="text/javascript" src="/js/task/taskWindow.js"></script>
</head>
<body>
<script type="text/javascript">
   <%-- Trap window closings, if we can, since some users are click-happy.
        The following is an unfortunately dependency on knowing that the
        window naming algorithm puts the task id at the end of the string --%>
   var matchResult = window.name.match(/_task(\d*?)$/);
   if (matchResult.length >= 2) {
      initializeWinProps(matchResult[1], "<c:out value='${mainWindowName}'/>");
      trapWindowClose();
   }
</script>
<span class="cont1">
<h1><fmt:message key="historyWarningTitle"/></h1>
<p><fmt:message key="historyWarningMessage"/></p>
</span>

<script type="text/javascript">
   function updatePanel() {
      if (window.name == "") {
         document.writeln("<fmt:message key='unknownWindowMessage'/>");
         document.close();

      } else {
         window.location.replace("/hmc/content?windowName="+window.name);
      }
   }

   // Make sure the message can be read
   window.resizeTo(<fmt:message key="historyWindowWidth"/>,
                   <fmt:message key="historyWindowHeight"/>);

   <c:if test="${not empty noDelay}">
      updatePanel();
   </c:if>
   <c:if test="${empty noDelay}">
      window.setTimeout("updatePanel()", 4000);
   </c:if>
</script>
</body>
</html>
</fmt:bundle>
