<%--
 If an HMC session is forcibly disconnected, for example due to being idle or
 because the connection with the browser was lost, and the user then attempts
 to access the HMC (within the window when the HTTP session is still valid),
 this JSP is dispatched (by ActivityMonitor.java) to open a new window that
 will close any HMC browser windows and display an error message.  We can't
 simply display the error message in this window because it might not be
 visible.  The request we intercepted for this processing might be coming from
 a hidden frame or one too small to show the message.
--%>

<%@taglib prefix="c" uri="http://java.sun.com/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>

<%@page session="false"%>   <%-- prevent a session from being created --%>

<fmt:bundle basename="com.ibm.hwmca.fw.servlet.tasks.res.task">
<html>
<head>
   <hmc:title><fmt:message key="launchDefunctCleanupTitle"/></hmc:title>
   <link href='<%=application.getAttribute("hmcStyleSheet")%>' rel="stylesheet" type="text/css"/>
   <meta http-equiv="Cache-Control" content="no-cache">
   <script type="text/javascript" src="/js/task/taskWindow.js"></script>
</head>
<body>
<span class="wclContainer">

<script type="text/javascript">
   try {
      <%--
       // The window options specified below also appear in ActivityManager.java.
       // They should be kept in sync with each other.  See the
       // ActivityManager.LAUNCH_CLEANUP_SCRIPT variable.
      --%>
      window.open("<c:out value='${pageContext.request.contextPath}'/>/tasks/defunctCleanup.jsp",
                  "", "width=450,height=375,top="+((screen.availHeight-375)/2)+
                  ",left="+((screen.availWidth-450)/2)+",scrollbars=yes,resizable=yes");
   } catch (e) {
      // Ignore exceptions.  If it failed, they don't get to see the error message.
   }
</script>

<fmt:message key="launchDefunctCleanupMessage"/>
</span>
</body>
</html>
</fmt:bundle>
