<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<!--<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">-->

<!--
/*********************************************************** {COPYRIGHT-TOP} ***
 * Licensed materials - Property of IBM
 * Tivoli Presentation Services
 *
 * (C) Copyright IBM Corp. 2003
 *
 * US Government Users Restricted Rights - Use, duplication, or
 * disclosure restricted by GSA ADP Schedule Contract with
 * IBM Corp.
 *
 * Module History:
 * 11/10/2005  JMiller      prevent drag-and-drop actions within the page
 * 08/11/2006  JMiller      show/hide workarea icons support
 * 10/24/2006  JMiller      add asyncjsonrefresh.js to handle workarea refreshes for ajax updates
 * 03/22/2007  J. Miller    Add js to set resize cursor when along nav/workarea frame border
 *
 ************************************************************ {COPYRIGHT-END} ****/
-->
<%@taglib prefix="wcl" uri="/WEB-INF/WCLTagLib.tld"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>
<%@taglib prefix="c" uri="http://java.sun.com/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt"%>

<%@page contentType="text/html;charset=UTF-8"
		language="java"
		import="java.util.Iterator,
                java.util.List,
                java.util.Map,

                javax.servlet.ServletConfig,
                javax.servlet.ServletContext,
                javax.servlet.ServletException,
                javax.servlet.http.HttpServletRequest,
                javax.servlet.http.HttpServletResponse,
                javax.servlet.http.HttpSession,
                javax.servlet.jsp.JspFactory,
                javax.servlet.jsp.JspWriter,

                org.apache.jasper.runtime.HttpJspBase,

                com.ibm.hwmca.fw.servlet.util.HMCSession,
                com.ibm.hwmca.fw.servlet.util.HMCSession,
                com.ibm.hwmca.fw.servlet.util.ServletRuntime,
                com.ibm.hwmca.fw.settings.user.BonsaiUserSettings,
                com.ibm.hwmca.fw.util.LocalizableText,
                com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager,
                com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode,
                com.ibm.hwmca.ui.bonsai.servlet.ControllerServlet,
                com.ibm.hwmca.ui.bonsai.servlet.HealthAction,
                com.ibm.hwmca.ui.bonsai.servlet.WorkareaAction,
                com.ibm.hwmca.ui.bonsai.servlet.util.UserObject,
                com.ibm.hwmca.ui.bonsai.servlet.util.UserObjectListener,
                com.ibm.hwmca.ui.bonsai.status.ExceptionsAndMessagesTreeModel,
                com.ibm.hwmca.ui.bonsai.status.StatusOverviewModel,
                com.ibm.hwmca.ui.bonsai.status.StatusUtils,
                com.ibm.hwmca.ui.bonsai.status.TypedChildrenStatisticsBean,
                com.ibm.hwmca.ui.bonsai.util.SettingsRetriever" %>

<% response.flushBuffer(); %>

<fmt:bundle basename="com.ibm.hwmca.ui.bonsai.res.bonsai">

<%!
    private static final LocalizableText TITLE = new LocalizableText("com/ibm/hwmca/ui/bonsai/res/bonsai",
                                                                     "status.overview.title");
    private static final LocalizableText CAPTION = new LocalizableText("com/ibm/hwmca/ui/bonsai/res/bonsai",
                                                                       "status.overview.caption");
    private static final String MODEL_SESSION_KEY = "ExcAndMsgsOverviewModel";
%>

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

<!-- ===========================================================================
  This JSP is a view.  That is, the WclFacade and all data is defined inside a
  controller Servlet.
  ========================================================================== -->
<wcl:Foundation
	objectScope="session"
    wclFacadeScope="<%= HMCSession.getHMCSession(session).getHMCCustomScope().getScopeName() %>"
    wclFacadeScopeId="<%= ControllerServlet.FACADE_ID_ATTRIBUTE %>"
    pageName="excandmsgsoverviewpage">

<head>

<meta http-equiv="Content-Type" content="text/html;CHARSET=UTF-8"/>

<link href="/css/ui/bonsai/excandmsgsoverview.css" rel="stylesheet" type="text/css"/>

<script src="/js/ui/bonsai/nodrag.js" type="text/javascript"></script>
<script src="/js/ui/bonsai/utilities.js" type="text/javascript"></script>
<script src="/js/ui/bonsai/navcursor.js" type="text/javascript"></script>
<script src="/js/ui/bonsai/asyncjsonrefresh.js" type="text/javascript"></script>

<%
    // attach the user context to this thread
    ServletRuntime.getRuntime().attachUserContextToServletThread(request);

    // get the user's session data
    HMCSession hmcSession = HMCSession.getHMCSession(session);
    UserObject userObj = UserObject.getUserObject(hmcSession);
    BonsaiUserSettings bonsaiSettings = SettingsRetriever.getBonsaiUserSettings(hmcSession);
    String waKey = request.getParameter("wakey");
    if (waKey == null)
    {
        throw(new IllegalArgumentException("request parameter 'wakey' is required but missing!"));
    }

    // get the model, creating it if this is the first request by the session
    synchronized(session)
    {
        if (hmcSession.getSessionAttribute(MODEL_SESSION_KEY) == null)
        {
            StatusOverviewModel model = new StatusOverviewModel(ControllerServlet.HEALTH_TREE_KEY,
                                                                waKey,
                                                                userObj);
            BonsaiTreeManager.getBonsaiTreeManager().getEventQueue().addEventQueueListener(model);
            model.init();
            hmcSession.setSessionAttribute(MODEL_SESSION_KEY, model);

            // setup a UserObjectListener so we can deregister backend listener registrations
            userObj.addUserObjectListener(
                new UserObjectListener()
                {
                    public void userObjectDisconnecting(UserObject userObj) {}
                    public void userObjectReconnecting(UserObject userObj) {}
                    public void userObjectDying(UserObject userObj)
                    {
                        StatusOverviewModel model = (StatusOverviewModel)(userObj.getHMCSession().getSessionAttribute(MODEL_SESSION_KEY));
                        BonsaiTreeManager.getBonsaiTreeManager().getEventQueue().removeEventQueueListener(model);
                    }
                }
            );
        }
    }

    // retrieve the body style info
    StringBuffer bodyStyle = new StringBuffer();
    try
    {
        Map.Entry style = null;
        for (Iterator i = WorkareaAction.getURIStyle(waKey).entrySet().iterator(); i.hasNext(); )
        {
            style = (Map.Entry)i.next();
            bodyStyle.append((String)style.getKey());
            bodyStyle.append(": ");
            bodyStyle.append((String)style.getValue());
            if (i.hasNext())
            {
                bodyStyle.append("; ");
            }
        }
    }
    catch (IllegalArgumentException iaEx)
    {
        // workarea must have changed since we were asked to render, so ignore
    }
%>

</head>

<c:set var="showIcons" scope="page"><%= bonsaiSettings.isShowWorkareaIcons() %></c:set>

<body style="<%= bodyStyle.toString() %>" onmousemove="navOnMouseMove('west');" onmouseout="navOnMouseOut();">
<div id="bodyOuterDiv">

<wcl:WTitledLayout objectScopeId="excAndMsgsOverviewTitle" description="<%= CAPTION.toString(request.getLocale()) %>" title="<%= TITLE.toString(request.getLocale()) %>" ></wcl:WTitledLayout>

<div class="monitor_table">

<%
    StatusOverviewModel model = (StatusOverviewModel)(HMCSession.getHMCSession(session).getSessionAttribute(MODEL_SESSION_KEY));
    List beans = model.getBeans();
    TypedChildrenStatisticsBean bean = null;
    Map statsMap = null;
    Class[] classObjects = null;
    String className = null;
    Integer numOfType = null;
    for (Iterator i = beans.iterator(); i.hasNext(); )
    {
        bean = (TypedChildrenStatisticsBean)i.next();
%>
    <div class="<%= (bean.getTotalChildren() == 0) ? "monitor_entry_ok" : ((bean.getStatusType() == ExceptionsAndMessagesTreeModel.STATUS_TYPE_HWMESSAGES) ?  "monitor_entry_hwmessages" : ((bean.getStatusType() == ExceptionsAndMessagesTreeModel.STATUS_TYPE_OSMESSAGES) ? "monitor_entry_osmessages" : "monitor_entry_unacceptable")) %>">

        <div class="monitor_title_area">
<%      if (bean.getTotalChildren() > 0) {%>
            <span class="monitor_title_text"><a class="monitor_title_text" href="<%= HealthAction.getSelectionUrl(bean.getId()) %>" target="<%= HealthAction.FRAME_NAME %>" title="<%= new LocalizableText("com/ibm/hwmca/ui/bonsai/res/bonsai", "view.open.alt", new String[] { bean.getName() }).toString(request.getLocale()) %>"><c:if test="${showIcons}"><img class="monitor_title_image" src="<%= bean.getImage() %>"/></a><a class="monitor_title_text" href="<%= HealthAction.getSelectionUrl(bean.getId()) %>" target="<%= HealthAction.FRAME_NAME %>" title="<%= new LocalizableText("com/ibm/hwmca/ui/bonsai/res/bonsai", "view.open.alt", new String[] { bean.getName() }).toString(request.getLocale()) %>"></c:if><%= bean.getName() %></a> (<%= bean.getTotalChildren() %>)</span>
<%      } else {%>
            <span class="monitor_title_text" title="<%= bean.getName() %>"><c:if test="${showIcons}"><img class="monitor_title_image_disabled" src="<%= (bean.getDisabledImage() == null) ? bean.getImage() : bean.getDisabledImage() %>"/></c:if><%= bean.getName() %> (0)</span>
<%      }%>
        </div>
<%
        if (bean.getTotalChildren() > 0)
        {
%>
        <div class="monitor_details_area">
<%
            statsMap = bean.getTypedChildrenStats();
            for (Iterator j = statsMap.keySet().iterator(); j.hasNext(); )
            {
                classObjects = (Class[])j.next();
                className = classObjects[0].getName();
                numOfType = (Integer)statsMap.get(classObjects);
                if (numOfType.intValue() > 0)
                {
%>
            <p class="monitor_details_text">
                <c:if test="${showIcons}"><img height="16" width="16" src="<%= StatusUtils.getCategoryIcon(className) %>"/></c:if>
                <%= StatusUtils.getCategoryName(request.getLocale(), className) %>: <%= numOfType %>
            </p>
<%
                }
            }
%>
        </div>
<%
        }
%>
        <br style="clear: both"/>

    </div>

<%
        if (i.hasNext())
        {
%>
    <div class="monitor_entry_spacer"></div>
<%
        }
    }
%>

</div>
</div>
</body>

</wcl:Foundation>

</html>

</fmt:bundle>
