<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">

<!--
/*********************************************************** {COPYRIGHT-TOP} ***
* Licensed materials - Property of IBM
* Tivoli Presentation Services
*
* (C) Copyright IBM Corp. 2003
*
* US Government Users Restricted Rights - Use, duplication, or
* disclosure restricted by GSA ADP Schedule Contract with
* IBM Corp.
*
* Module History:
*     08/11/2005   JMiller        New Release
*     09/19/2006   JMiller        Remove On Demand Management node
*                                 Fix IE spacer height, column widths
*     10/10/2006   JMiller        Fix Guided Setup Wizard Task Url
*                                 Disable What's New and eLearning links
*                                 Use phmc.welcome bundle values
*     10/24/2006   JMiller        add asyncjsonrefresh.js to handle workarea refreshes for ajax updates
*     11/02/2006   JMiller        HMC version additional info localizeable text fix
*                                 nowrap first column
*     11/03/2006   P. Liu         Add toggle DIV by groupID for online information, fix outline of 'plus button'
*     11/07/2006   P. Liu         Add isLocalContext,openURL() logic for online information
*     11/09/2006   JMiller        Move HMC Version code into (and include) phmc-hmcversionpopup.jsp
*     11/10/2006   P. Liu         Modify isLocalContext logic for online information, add a.disabled style
*     11/15/2006   P. Liu         To show the whole content of URL when hovering the disabled anchor
*     11/28/2006   JMiller        Enlarge title
*                                 Remove top/bottom padding from hmc version popup
*     12/14/2006   P. Liu         Change a.disabled:hover span padding-right: 2px;
*     01/11/2007   JMiller        Underline links on hover only
*     02/09/2007   P. Liu         Update URLs and Description for Online Information
*                                 Add HMC Readme link (/console/www/iphmc/en_US/hscreadme.html)
*     03/07/2007   P. Liu         merge online education and tutorial
*                                 Add view as HTML for remote HMC Operation Guide
*     03/08/2007   P. Liu         Change Operations Guide url for html/pdf
*     03/15/2007   P. Liu         Change the order of sysplan,
*                                 Use ServletRuntime::isExternalWebReferenceAllowed() to determine local context
*                                 Use locale info to determine HMC guide and readme path
*                                 Use ViewerTask to launch html when it is a local HMC
*     03/21/2007   J. Miller      Add js to set resize cursor when along nav/workarea frame border   
*     04/06/2007   P. Liu         Change ViewerTask window size to w=900, h=600,
*                                 Fix locale_path problem (check for locale.getCountry())
*     04/12/2007   P. Liu         Change hmcoperationsguide.gif to operationsguide.gif
*                                 Use bundle com.ibm.hwmca.ui.bonsai.res.bonsai
*     04/13/2007   J. Jenks       Move english op guides and readme to be country-independent.
*
************************************************************ {COPYRIGHT-END} ****/
-->

<%@taglib prefix="wcl" uri="/WEB-INF/WCLTagLib.tld"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>
<%@taglib prefix="c" uri="http://java.sun.com/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt"%>
<%@page contentType="text/html;charset=UTF-8"
        language="java"
        import="java.io.File,

                java.util.Iterator,
                java.util.Locale,
                java.util.Map,
                java.util.SortedMap,

                javax.servlet.ServletConfig,
                javax.servlet.ServletContext,
                javax.servlet.ServletException,
                javax.servlet.http.HttpServletRequest,
                javax.servlet.http.HttpServletResponse,
                javax.servlet.http.HttpSession,
                javax.servlet.jsp.JspFactory,
                javax.servlet.jsp.JspWriter,

                org.apache.jasper.runtime.HttpJspBase,

                com.ibm.hwmca.fw.managed.ObjectId,
                com.ibm.hwmca.fw.managed.TaskProperties,
                com.ibm.hwmca.fw.servlet.util.HMCSession,
                com.ibm.hwmca.fw.servlet.util.ServletRuntime,
                com.ibm.hwmca.fw.settings.user.BonsaiUserSettings,
                com.ibm.hwmca.fw.ui.LauncherUtils,
                com.ibm.hwmca.fw.ui.UIBook,
                com.ibm.hwmca.fw.util.LocalizableText,
                com.ibm.hwmca.fw.util.ShortIdManager,

                com.ibm.hwmca.ui.bonsai.servlet.Action,
                com.ibm.hwmca.ui.bonsai.servlet.util.TaskUrl,
                com.ibm.hwmca.ui.bonsai.servlet.util.UserObject,
                com.ibm.hwmca.ui.bonsai.util.GraphicsConstants,
                com.ibm.hwmca.ui.bonsai.util.SettingsRetriever,
                com.ibm.hwmca.ui.bonsai.util.hmcversion.HmcVersionInfo,
                com.ibm.hwmca.fw.panel.htmlviewer.ViewerTask,
                com.ibm.hwmca.fw.panel.htmlviewer.HtmlViewerParms,
                com.ibm.hwmca.fw.ui.UIInfo,
                com.ibm.hwmca.fw.task.PresentationTaskParms,
                com.ibm.hwmca.fw.task.PresentationTask,
                com.ibm.hwmca.fw.task.TaskLauncher"
%>

<% response.flushBuffer(); %>

<fmt:bundle basename="com.ibm.hwmca.ui.bonsai.res.bonsai">
<html>
<head>

<%!
    private static final String BUNDLE_NAME = "com/ibm/hwmca/ui/bonsai/res/bonsai";

    private static final String WIZARD_TASK_CLASS = "com.ibm.hwmca.fw.managed.Task";//"com.ibm.hmc.cv.mom.CvTask";
    private static final String WIZARD_TASK_KEY = "com.ibm.hsc.iw.WizardFrame";

    private static final String HMCGUIDE_BASEDIR = "www/books";
    private static final String HMCGUIDE_HTML = "sa76-0085.html";
    private static final String HMCGUIDE_PDF = "sa76-0085.pdf";
    private static final String README_BASEDIR = "www/iphmc";
    private static final String README_HTML = "hscreadme.html";
%>

<%
    // attach the user context to this thread
    ServletRuntime.getRuntime().attachUserContextToServletThread(request);

    // get useful session/context data
    HMCSession hmcSession = HMCSession.getHMCSession(session);
    UserObject userObj = UserObject.getUserObject(hmcSession);
    Locale locale = userObj.getLocale();
    BonsaiUserSettings bonsaiSettings = SettingsRetriever.getBonsaiUserSettings( hmcSession );
    boolean isLocalContext = !ServletRuntime.isExternalWebReferenceAllowed(session);

    // if requested, launch viewer task
    final String url = request.getParameter("viewerURL");
    final String base = request.getParameter("viewerBase");
    if (url != null && base != null)
    {
        final LocalizableText name = new LocalizableText(url);
       PresentationTaskParms parms = new PresentationTaskParms();
        parms.setUIInfo(new UIInfo(name, name));
        parms.setData(ViewerTask.VIEWER_TASK_PARMS_KEY,
                      new HtmlViewerParms() {
                          public String getContentBasePath() { return base; }
                          public String getTargetUrl() { return url; }
                          public LocalizableText getWindowTitle() { return name; }
                          public LocalizableText getBannerTitle() { return name; }
                          public int getWindowWidth() { return 900; }
                          public int getWindowHeight() { return 600; }
                      });
        TaskLauncher.startTask(parms, ViewerTask.class.getName(), hmcSession, false);
    }

    // get the guide and readme file urls
    String hmcguide_html = null;
    String hmcguide_pdf = null;
    String hscreadme_html = null;
    if (isLocalContext)
    {
        hmcguide_html = "/hmc/ui/bonsai/workarea.do?viewerBase=" + HMCGUIDE_BASEDIR + "&viewerURL=" + HMCGUIDE_HTML;
        hscreadme_html = "/hmc/ui/bonsai/workarea.do?viewerBase=" + README_BASEDIR + "&viewerURL=" + README_HTML;
    }
    else
    {
        ServletRuntime runtime = ServletRuntime.getRuntime();

        // the file discovery calls are slow, so we cache them in the HttpSession object

        // 1) HMC Guide in HTML
        String sessionKey = HMCGUIDE_BASEDIR + "/*/" + HMCGUIDE_HTML;
        hmcguide_html = (String)session.getAttribute(sessionKey);
        if (hmcguide_html == null)
        {
            File file = runtime.findLocaleSpecificFile(HMCGUIDE_BASEDIR + "/", locale, "/" + HMCGUIDE_HTML);
            if (file == null)
            {
                hmcguide_html = "";
            }
            else
            {
                hmcguide_html = file.getPath().substring(3);
                session.setAttribute(sessionKey, hmcguide_html);
            }
        }

        // 2) HMC Guide in PDF
        sessionKey = HMCGUIDE_BASEDIR + "/*/" + HMCGUIDE_PDF;
        hmcguide_pdf = (String)session.getAttribute(sessionKey);
        if (hmcguide_pdf == null)
        {
            File file = runtime.findLocaleSpecificFile(HMCGUIDE_BASEDIR + "/", locale, "/" + HMCGUIDE_PDF);
            if (file == null)
            {
                hmcguide_pdf = "";
            }
            else
            {
                hmcguide_pdf = file.getPath().substring(3);
                session.setAttribute(sessionKey, hmcguide_pdf);
            }
        }

        // 3) HMC Reame in HTML
        sessionKey = README_BASEDIR + "/*/" + README_HTML;
        hscreadme_html = (String)session.getAttribute(sessionKey);
        if (hscreadme_html == null)
        {
            File file = runtime.findLocaleSpecificFile(README_BASEDIR + "/", locale, "/" + README_HTML);
            if (file == null)
            {
                hscreadme_html = "";
            }
            else
            {
                hscreadme_html = file.getPath().substring(3);
                session.setAttribute(sessionKey, hscreadme_html);
            }
        }
    }
%>
<c:set var="showIcons" scope="page"><%= bonsaiSettings.isShowWorkareaIcons() %></c:set>

<meta http-equiv="Content-Type" content="text/html;CHARSET=UTF-8"/>

<link href="/css/ui/bonsai/popup.css" rel="stylesheet" type="text/css"/>
<link href="/css/ui/bonsai/phmc-welcome.css" rel="stylesheet" type="text/css"/>

<script src="/js/ui/bonsai/nodrag.js" type="text/javascript"></script>
<script src="/js/ui/bonsai/utilities.js" type="text/javascript"></script>
<script src="/js/ui/bonsai/navcursor.js" type="text/javascript"></script>
<script src="/js/ui/bonsai/asyncjsonrefresh.js" type="text/javascript"></script>
<script language="JavaScript">
<!--
    function toggleDiv(textDivId, booksDivId, imgId) {
        if ( document.getElementById(booksDivId) && document.getElementById(textDivId) ) {
            var booksDivStyle = document.getElementById(booksDivId).style;
            var textDivStyle  = document.getElementById(textDivId).style;

            booksDivStyle.display = booksDivStyle.display == "block" ? "none" : "block";
            textDivStyle.display = booksDivStyle.display == "block" ? "none" : "block";
            if ( document.getElementById(imgId) ) {
                var img = document.getElementById(imgId);
                if ( booksDivStyle.display == "none" ) {
                    img.src = "/res/com/ibm/hwmca/ui/bonsai/images/plus.gif";
                } else {
                    img.src = "/res/com/ibm/hwmca/ui/bonsai/images/minus.gif";
                }
            }
        }
    }
    function toggleAllDiv(DivId, imgId) {
        var theDiv = document.getElementById(DivId);
        if (  theDiv  ) {
            var theDivStyle = theDiv.style;
            var display = theDivStyle.display == "block" ? "none" : "block";
            var divs = document.getElementsByTagName('div')
            for (var i=0;i<divs.length;i++)
            {
                if (divs[i].getAttribute("groupID") == theDiv.getAttribute("groupID"))
                    divs[i].style.display = display;
            }
            if ( document.getElementById(imgId) ) {
                var img = document.getElementById(imgId);
                if ( display == "none" ) {
                    img.src = "/res/com/ibm/hwmca/ui/bonsai/images/plus.gif";
                } else {
                    img.src = "/res/com/ibm/hwmca/ui/bonsai/images/minus.gif";
                }
            }
        }
    }

    function eLearningWin(event) {
        var win = window.open('Index_viewlet_swf.html','eLearning',config='height=screen.height,width=screen.width,toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=no,resizable=yes');
        win.moveTo(0,0);
        win.resizeTo(screen.width, screen.height);
        win.focus();
        window.close();
    }
// -->
</script>
</head>

<!-- image dir /res/com/ibm/hwmca/ui/bonsai/ -->
<body onmousemove="navOnMouseMove('west');" onmouseout="navOnMouseOut();">
<div id="bodyOuterDiv">
<div id="bodyInnerDiv">
    <span class="title"><fmt:message key="welcome.name"/></span>
    &nbsp;&nbsp;(&nbsp;<%@ include file="/ui/bonsai/phmc-hmcversionpopup.jsp" %>&nbsp;)
    <br><br>
    <fmt:message key="phmc.welcome.overview"/>
    <br><br>
<%
        //get Guided Setup Wizard URL
        ObjectId objId = new ObjectId(WIZARD_TASK_CLASS);
        objId.setKeyProperty(TaskProperties.NAME_PROPERTY, WIZARD_TASK_KEY);
        String taskId = ShortIdManager.getShortIdManager().getShortId(objId);
        TaskUrl setupwizUrl = new TaskUrl(taskId, LauncherUtils.ID_LAUNCH_TYPE_CONSOLE_TASK);
%>
  <table class="welcome_table">
        <tr><td class="welcome_item"><span><c:if test="${showIcons}"><img class="nodeIcon" src="/res/com/ibm/hwmca/ui/bonsai/images/system-icon.gif"     width="16" height="16" /></c:if><fmt:message key="sysconfig.name"/></span></td><td><fmt:message key="phmc.welcome.overview.sysconfig"/></td></tr>
        <tr><td class="welcome_item"><span><c:if test="${showIcons}"><img class="nodeIcon" src="/res/com/ibm/hwmca/ui/bonsai/images/system_plan.t.gif"   width="16" height="16" /></c:if><fmt:message key="sysplans.name" /></span></td><td><fmt:message key="phmc.welcome.overview.sysplans" /></td></tr>
        <tr><td class="welcome_item"><span><c:if test="${showIcons}"><img class="nodeIcon" src="/res/com/ibm/hwmca/ui/bonsai/images/hmc-16.gif"      width="16" height="16" /></c:if><fmt:message key="hmcmgmt.name"  /></span></td><td><fmt:message key="phmc.welcome.overview.hmcmgmt"  /></td></tr>
        <tr><td class="welcome_item"><span><c:if test="${showIcons}"><img class="nodeIcon" src="/res/com/ibm/hwmca/ui/bonsai/images/servicemanagement-16.gif"  width="16" height="16" /></c:if><fmt:message key="service.name"  /></span></td><td><fmt:message key="phmc.welcome.overview.service"  /></td></tr>
        <tr><td class="welcome_item"><span><c:if test="${showIcons}"><img class="nodeIcon" src="/res/com/ibm/hwmca/ui/bonsai/images/updates-16.gif" width="16" height="16" /></c:if><fmt:message key="updates.name"  /></span></td><td><fmt:message key="phmc.welcome.overview.updates"  /></td></tr>
        <tr><td class="welcome_item"><span><c:if test="${showIcons}"><img class="nodeIcon" src="/res/com/ibm/hwmca/ui/bonsai/images/status-combo-16.gif" width="16" height="16" /></c:if><fmt:message key="statusbar.name"/></span></td><td><fmt:message key="phmc.welcome.overview.statusbar"/></td></tr>
        <tr class="rootspacer"><td colspan="2"><img src="<%= GraphicsConstants.getTransparentIcon() %>" /></td></tr>
        <tr><td class="item_title" colspan="2"><span><fmt:message key="phmc.welcome.additionalresources"/></span></td></tr>
        <tr><td class="welcome_item"><span><c:if test="${showIcons}"><img class="nodeIcon" src="/res/com/ibm/hwmca/ui/bonsai/images/setupwiz.gif"     width="16" height="16" /></c:if><a title="<%= new LocalizableText(Action.BUNDLE_NAME, "phmc.welcome.setupwiz.mo"  ).toString(request.getLocale())%>" href="<%= setupwizUrl %>"><fmt:message key="phmc.welcome.setupwiz.title"  /></a></span></td><td><span><fmt:message key="phmc.welcome.setupwiz.overview"  /></span></td></tr>

<!-- add HMC Operations Guide -->
<%
       if (isLocalContext)
       {
%>
        <tr>
           <td class="welcome_item">
             <span>
               <c:if test="${showIcons}"><img class="nodeIcon" src="/res/com/ibm/hwmca/ui/bonsai/images/operationsguide.gif"     width="16" height="16" /></c:if>
               <a title="<%= new LocalizableText(Action.BUNDLE_NAME, "phmc.welcome.hmcGuide.title.mo").toString(request.getLocale())%>"
                 href="<%= hmcguide_html %>" >
                 <fmt:message key="phmc.welcome.hmcGuide.title"/>
             </a></span>
           </td>
           <td><span><fmt:message key="phmc.welcome.hmcGuide.overview"/></span></td>
        </tr>
<%
      }else
      {
%>
        <tr>
           <td class="viewAs_item">
             <span>
               <c:if test="${showIcons}"><img class="nodeIcon" src="/res/com/ibm/hwmca/ui/bonsai/images/operationsguide.gif"     width="16" height="16" /></c:if>
               <a title="<%= new LocalizableText(Action.BUNDLE_NAME, "phmc.welcome.hmcGuide.title.mo").toString(request.getLocale())%>"
                 href="<%= hmcguide_pdf %>" target="_new">
                 <fmt:message key="phmc.welcome.hmcGuide.title"/>
             </a></span>
           </td>
           <td rowspan="2"><span><fmt:message key="phmc.welcome.hmcGuide.overview"/></span></td>
        </tr>
        <tr>
           <td>
             <span>
               <a title="<%= new LocalizableText(Action.BUNDLE_NAME, "phmc.welcome.hmcGuide.title.viewAsHtml.mo").toString(request.getLocale())%>"
                 href="<%= hmcguide_html %>" target="_new">
                 <fmt:message key="phmc.welcome.hmcGuide.title.viewAsHtml"/>
             </a></span>
           </td>
        </tr>
<%
     }
%>
<!-- add HMC Readme -->
<%
       if (isLocalContext)
       {
%>
        <tr>
           <td class="welcome_item">
             <span>
               <c:if test="${showIcons}"><img class="nodeIcon" src="/res/com/ibm/hwmca/ui/bonsai/images/readme.gif"     width="16" height="16" /></c:if>
               <a title="<%= new LocalizableText(Action.BUNDLE_NAME, "phmc.welcome.hmcReadme.title.mo").toString(request.getLocale())%>"
                 href="<%= hscreadme_html %>">
                 <fmt:message key="phmc.welcome.hmcReadme.title"/>
             </a></span>
           </td>
           <td><span><fmt:message key="phmc.welcome.hmcReadme.overview"/></span></td>
        </tr>
<%
      }else
      {
%>
        <tr>
           <td class="welcome_item">
             <span>
               <c:if test="${showIcons}"><img class="nodeIcon" src="/res/com/ibm/hwmca/ui/bonsai/images/readme.gif"     width="16" height="16" /></c:if>
               <a title="<%= new LocalizableText(Action.BUNDLE_NAME, "phmc.welcome.hmcReadme.title.mo").toString(request.getLocale())%>"
                 href="<%= hscreadme_html %>" target="_new">
                 <fmt:message key="phmc.welcome.hmcReadme.title"/>
             </a></span>
           </td>
           <td><span><fmt:message key="phmc.welcome.hmcReadme.overview"/></span></td>
        </tr>

<%
     }
%>

<!-- add Related online information -->
        <tr>
            <td class="welcome_item">
                <A class="imageButton" onclick="toggleAllDiv('onlineListDiv', 'onlineListImg');return false;"
                   title="<%= new LocalizableText(Action.BUNDLE_NAME, "phmc.welcome.online.title.mo").toString(request.getLocale())%>">
                   <img id="onlineListImg" align="absmiddle" border="0" src="/res/com/ibm/hwmca/ui/bonsai/images/plus.gif"/>
                </A>
                <span>
                  <A title="<%= new LocalizableText(Action.BUNDLE_NAME, "phmc.welcome.online.title.mo").toString(request.getLocale()) %>"
                     href="javascript: toggleAllDiv('onlineListDiv', 'onlineListImg')">
                     <fmt:message key="phmc.welcome.online.title"/>
                  </A>
                </span>
            </td>
            <td>
                <fmt:message key="phmc.welcome.online.overview"/>
            </td>
        </tr>
<%
        int numUrls = 3;
        int strMaxSize = 30;
        String[] urls={
          "http://www.ibm.com/systems/support",
          "https://www14.software.ibm.com/webapp/set2/sas/f/hmc/home.html",
          "https://www.ibm.com/servers/resourcelink/lib03030.nsf/pages/HardwareManagementConsoleSupportingPOWER6TechnologySupport?OpenDocument",
          "http://publib.boulder.ibm.com/infocenter/eserver/v1r3s/index.jsp?topic=/iphcy/learningandtutorials.html"};
        String[] titleKeys={
          "phmc.welcome.online.systemSupport.title",
          "phmc.welcome.online.hmcSupport.title",
          "phmc.welcome.online.educationCourses.title",
          "phmc.welcome.online.tutorials.title"};
        String[] overviewKeys={
          "phmc.welcome.online.systemSupport.overview",
          "phmc.welcome.online.hmcSupport.overview",
          "phmc.welcome.online.educationCourses.overview",
          "phmc.welcome.online.tutorials.overview"};

        String [] strTitle = new String[numUrls];
        String [] strOverview = new String[numUrls];
        for (int i=0 ; i<numUrls; i++)
        {
           strTitle[i] = new LocalizableText(Action.BUNDLE_NAME, titleKeys[i]).toString(request.getLocale());
           strOverview[i] = new LocalizableText(Action.BUNDLE_NAME, overviewKeys[i]).toString(request.getLocale());
        }

        String strDisable = new LocalizableText(Action.BUNDLE_NAME, "phmc.welcome.online.link.disabled").toString(request.getLocale());
        String strDisable1 = new LocalizableText(Action.BUNDLE_NAME, "phmc.welcome.online.link.disabled.1").toString(request.getLocale());
        String [] strPopup = new String[numUrls];
        String s,left;
        for (int i=0 ; i<numUrls; i++)
        {
           left  = urls[i];
           s = "";
           while (left.length() > strMaxSize)
           {
              s = s+"\n"+left.substring(0,strMaxSize);
              left = left.substring(strMaxSize);
           }
           s = s + "\n"+left;
           strPopup[i] = strDisable + "<font color='#2c567f'>" + s + "</font> "+ strDisable1;
        }

        for ( int i = 0; i<numUrls ; i++ )
        {
          if (! isLocalContext)
          {
%>
          <tr>
            <td>
              <div id="onlineListDiv" groupID="1" class="padded" style="display: none">
                <a target="_new" href="<%= urls[i] %>"
                   title="<%= strTitle[i] %>" >
                   <%= strTitle[i] %>
                </a>
              </div>
            </td>
            <td>
              <div groupID="1" class="desc-padded" style="display: none">
                 <%= strOverview[i] %>
              </div>
            </td>
          </tr>
<%        }else
          {
%>
          <tr>
            <td>
              <div id="onlineListDiv" groupID="1" class="padded" style="display: none">
                <a href="#" class="disabled" onmousedown="blur(); return false;" onclick="blur(); return false;">
                   <%= strTitle[i] %>
                   <span> <img align="absmiddle" border="0" src="/res/com/ibm/hwmca/ui/bonsai/images/warning-16.gif"/>
                          <%= strPopup[i] %>
                   </span>
                </a>
              </div>
            </td>
            <td>
              <div groupID="1" class="desc-padded" style="display: none">
                 <%= strOverview[i] %>
              </div>
            </td>
          </tr>
<%        }
        }
%>
    </table>
</div>
</div>
</body>
</html>
</fmt:bundle>
