<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<!--<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">-->

<!--
/*********************************************************** {COPYRIGHT-TOP} ***
* Licensed materials - Property of IBM
* Tivoli Presentation Services
*
* (C) Copyright IBM Corp. 2003
*
* US Government Users Restricted Rights - Use, duplication, or
* disclosure restricted by GSA ADP Schedule Contract with
* IBM Corp.
*
* Module History:
* 11/10/2005  JMiller      prevent drag-and-drop actions within the page
* 08/11/2006  JMiller      show/hide workarea icons support
* 10/24/2006  JMiller      add asyncjsonrefresh.js to handle workarea refreshes for ajax updates
* 02/02/2007  JStapels     Updated the layout to match perlogin monitor.
* 03/21/2007  J. Miller    Add js to set resize cursor when along nav/workarea frame border
* 05/15/2007  J. Jenks     Update Attentions text color, and make icons links.
************************************************************ {COPYRIGHT-END} ****/
-->
<%@taglib prefix="wcl" uri="/WEB-INF/WCLTagLib.tld"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>
<%@taglib prefix="c" uri="http://java.sun.com/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt"%>

<%@page contentType="text/html;charset=UTF-8"
		language="java"
		import="java.util.Iterator,
                java.util.List,
                java.util.Map,
                javax.servlet.ServletConfig,
                javax.servlet.ServletContext,
                javax.servlet.ServletException,
                javax.servlet.http.HttpServletRequest,
                javax.servlet.http.HttpServletResponse,
                javax.servlet.http.HttpSession,
                javax.servlet.jsp.JspFactory,
                javax.servlet.jsp.JspWriter,
                org.apache.jasper.runtime.HttpJspBase,
                com.ibm.hwmca.fw.servlet.util.HMCSession,
                com.ibm.hwmca.fw.servlet.util.HMCSession,
                com.ibm.hwmca.fw.servlet.util.ServletRuntime,
                com.ibm.hwmca.fw.settings.user.BonsaiUserSettings,
                com.ibm.hwmca.fw.util.LocalizableText,
                com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager,
                com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode,
                com.ibm.hwmca.ui.bonsai.servlet.ControllerServlet,
                com.ibm.hwmca.ui.bonsai.servlet.HealthAction,
                com.ibm.hwmca.ui.bonsai.servlet.WorkareaAction,
                com.ibm.hwmca.ui.bonsai.servlet.health.PStatusBar,
                com.ibm.hwmca.ui.bonsai.servlet.util.UserObject,
                com.ibm.hwmca.ui.bonsai.servlet.util.UserObjectListener,
                com.ibm.hwmca.ui.bonsai.status.PStatusBarTreeModel,
                com.ibm.hwmca.ui.bonsai.status.StatusOverviewModel,
                com.ibm.hwmca.ui.bonsai.status.StatusUtils,
                com.ibm.hwmca.ui.bonsai.status.TypedChildrenStatisticsBean,
                com.ibm.hwmca.ui.bonsai.util.SettingsRetriever" %>

<% response.flushBuffer(); %>

<fmt:bundle basename="com.ibm.hwmca.ui.bonsai.res.bonsai">

<%!
    private static final LocalizableText TITLE = new LocalizableText("com/ibm/hwmca/ui/bonsai/res/bonsai",
                                                                     "status.overview.title");
    private static final LocalizableText CAPTION = new LocalizableText("com/ibm/hwmca/ui/bonsai/res/bonsai",
                                                                       "phmc.status.overview.caption");
    private static final String MODEL_SESSION_KEY = "PStatusOverviewModel";
%>

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

<!-- ===========================================================================
  This JSP is a view.  That is, the WclFacade and all data is defined inside a
  controller Servlet.
  ========================================================================== -->
<wcl:Foundation
	objectScope="session"
    wclFacadeScope="<%= HMCSession.getHMCSession(session).getHMCCustomScope().getScopeName() %>"
    wclFacadeScopeId="<%= ControllerServlet.FACADE_ID_ATTRIBUTE %>"
    pageName="pstatusoverviewpage">

<head>

<meta http-equiv="Content-Type" content="text/html;CHARSET=UTF-8"/>

<link href="/css/ui/bonsai/pstatusoverview.css" rel="stylesheet" type="text/css"/>

<script src="/js/ui/bonsai/nodrag.js" type="text/javascript"></script>
<script src="/js/ui/bonsai/utilities.js" type="text/javascript"></script>
<script src="/js/ui/bonsai/navcursor.js" type="text/javascript"></script>
<script src="/js/ui/bonsai/asyncjsonrefresh.js" type="text/javascript"></script>

<%
    // attach the user context to this thread
    ServletRuntime.getRuntime().attachUserContextToServletThread(request);

    // get the user's session data
    HMCSession hmcSession = HMCSession.getHMCSession(session);
    UserObject userObj = UserObject.getUserObject(hmcSession);
    BonsaiUserSettings bonsaiSettings = SettingsRetriever.getBonsaiUserSettings(hmcSession);
    String waKey = request.getParameter("wakey");
    if (waKey == null)
    {
        throw(new IllegalArgumentException("request parameter 'wakey' is required but missing!"));
    }

    // get the model, creating it if this is the first request by the session
    synchronized(session)
    {
        if (hmcSession.getSessionAttribute(MODEL_SESSION_KEY) == null)
        {
            StatusOverviewModel model = new StatusOverviewModel(ControllerServlet.HEALTH_TREE_KEY,
                                                                waKey,
                                                                userObj);
            BonsaiTreeManager.getBonsaiTreeManager().getEventQueue().addEventQueueListener(model);
            model.init();
            hmcSession.setSessionAttribute(MODEL_SESSION_KEY, model);

            // setup a UserObjectListener so we can deregister backend listener registrations
            userObj.addUserObjectListener(
                new UserObjectListener()
                {
                    public void userObjectDisconnecting(UserObject userObj) {}
                    public void userObjectReconnecting(UserObject userObj) {}
                    public void userObjectDying(UserObject userObj)
                    {
                        StatusOverviewModel model = (StatusOverviewModel)(userObj.getHMCSession().getSessionAttribute(MODEL_SESSION_KEY));
                        BonsaiTreeManager.getBonsaiTreeManager().getEventQueue().removeEventQueueListener(model);
                    }
                }
            );
        }
    }

    // retrieve the body style info
    StringBuffer bodyStyle = new StringBuffer();
    try
    {
        Map.Entry style = null;
        for (Iterator i = WorkareaAction.getURIStyle(waKey).entrySet().iterator(); i.hasNext(); )
        {
            style = (Map.Entry)i.next();
            bodyStyle.append((String)style.getKey());
            bodyStyle.append(": ");
            bodyStyle.append((String)style.getValue());
            if (i.hasNext())
            {
                bodyStyle.append("; ");
            }
        }
    }
    catch (IllegalArgumentException iaEx)
    {
        // workarea must have changed since we were asked to render, so ignore
    }
%>

    <style>

    /*
        COLORS
        good #0c0
        critical #f00
        attentions #cc0
        serviceables #f90
    */

    * {
        margin: 0px;
        padding: 0px;
        font-family: Helvetica, Arial, sans-serif;
        font-size: 12px inherit;
    }

    body { }

    ul {
        list-style-type: none;
        margin-top: 50px;
        margin: 0px auto;
    }

    .status li {
        margin: 0px 12px 12px;
        padding: 4px;
        /*background-color: #fff;*/
    }

    .status li.heading {
        margin: 0px;
        height: auto;
        border: none;
        background: none;
        font-size: 16px;
        font-weight: bold;
    }

    .status a.icon {
        display: block;
        width: 32px;
        height: 32px;
        float: left;
        z-index: 1;
        /*background-image: url(/images/fw/prelogin/okayIcon.gif);*/

        /* IE6 fixes for float and z-index bugs */
        margin-right: 0px !important;
        margin-right: -16px;
        position: static !important;
        position: relative;
    }

    .status h2 {
        margin: 7px 0px 0px 16px;
        padding: 1px 0px 0px 20px;
        height: 16px;
        background-color: #1e814d;
        background-image: url(/images/fw/prelogin/okayBar.gif);
        background-position: top right;
        background-repeat: repeat-y;
        border-width: 0px 0px 2px 0px;
        border-style: solid;
        border-color: #1e814d;
        color: #fff;
        font-size: 14px;
        font-weight: bold;
    }

    .status h2 a { color: #fff; text-decoration: none; }
    .status h2 a:hover { text-decoration: underline; }

    .status p      { margin: 2px 0px 0px 36px; font-size: 12px; }
    .status p span { margin-right: 15px; }
    .status p img  { vertical-align: middle; }

    #system a.icon     { background-image: url(/images/fw/prelogin/errorIconGray.gif); }
    #system.bad a.icon { background-image: url(/images/fw/prelogin/errorIcon.gif); }
    #system.bad h2       { border-color: #a91d20; background-color: #a91d20; background-image: url(/images/fw/prelogin/errorBar.gif); }

    #attentions a.icon     { background-image: url(/images/fw/prelogin/warningIconGray.gif); }
    #attentions.bad a.icon { background-image: url(/images/fw/prelogin/warningIcon.gif); }
    #attentions.bad h2       { /*color: #000;*/ border-color: #f5b84f; background-color: #f5b84f; background-image: url(/images/fw/prelogin/warningBar.gif); }

    #serviceables a.icon     { background-image: url(/images/fw/prelogin/serviceIconGray.gif); }
    #serviceables.bad a.icon { background-image: url(/images/fw/prelogin/serviceIcon.gif); }
    #serviceables.bad h2       { border-color: #905f37; background-color: #905f37; background-image: url(/images/fw/prelogin/serviceBar.gif); }

    </style>

</head>

<c:set var="showIcons" scope="page"><%= bonsaiSettings.isShowWorkareaIcons() %></c:set>

<body style="<%= bodyStyle.toString() %>" onmousemove="navOnMouseMove('west');" onmouseout="navOnMouseOut();">
<div id="bodyOuterDiv">

<wcl:WTitledLayout objectScopeId="pStatusOverviewTitle" description="<%= CAPTION.toString(request.getLocale()) %>" title="<%= TITLE.toString(request.getLocale()) %>" ></wcl:WTitledLayout>

<%
	int    errors 	           = 0;
	String errorText           = "";
	String errorMiniText       = "";
	String errorAnchorAttr     = null;
	int    attentions          = 0;
	String attentionText       = "";
	String attentionMiniText   = "";
	String attentionAnchorAttr = null;
	int	   events              = 0;
	String eventText           = "";
	String eventMiniText       = "";
	String eventAnchorAttr     = null;

    StatusOverviewModel model = (StatusOverviewModel)(HMCSession.getHMCSession(session).getSessionAttribute(MODEL_SESSION_KEY));
    List                beans = model.getBeans();
    Iterator            i     = beans.iterator();
    while (i.hasNext()) {
        TypedChildrenStatisticsBean bean = (TypedChildrenStatisticsBean)i.next();

        String miniText = "";
        Map minis = bean.getTypedChildrenStats();
        if (minis != null) {
        	Iterator n = minis.keySet().iterator();
        	while (n.hasNext()) {
        		Class[] classObjects = (Class[])n.next();
        		String  className    = classObjects[0].getName();
        		int     numOfType    = ((Integer)minis.get( classObjects )).intValue();
        		
        		if (numOfType > 0) {
        			miniText += "<span><img height=\"16\" width=\"16\" src=\"" + StatusUtils.getCategoryIcon( className ) + "\" /> "
						      + StatusUtils.getCategoryName( request.getLocale(), className ) + ": " + numOfType + "</span>";
        		}
        	}
        }

		if (bean.getStatusType() == PStatusBarTreeModel.STATUS_TYPE_ERRORS) {
			errors = bean.getTotalChildren();
			errorText = bean.getName();
			errorMiniText = miniText;
            if (errors > 0) {
                errorAnchorAttr = "href=\"" + HealthAction.getSelectionUrl(bean.getId()) + "\" "
                                + "target=\"" + HealthAction.FRAME_NAME + "\" "
                                + "title=\"" + new LocalizableText("com/ibm/hwmca/ui/bonsai/res/bonsai", "view.open.alt", new String[] { errorText }).toString(request.getLocale()) + "\"";
            }
		}
		else if (bean.getStatusType() == PStatusBarTreeModel.STATUS_TYPE_ATTENTIONS) {
			attentions = bean.getTotalChildren();
			attentionText = bean.getName();
			attentionMiniText = miniText;
            if (attentions > 0) {
                attentionAnchorAttr = "href=\"" + HealthAction.getSelectionUrl(bean.getId()) + "\" "
                                    + "target=\"" + HealthAction.FRAME_NAME + "\" "
                                    + "title=\"" + new LocalizableText("com/ibm/hwmca/ui/bonsai/res/bonsai", "view.open.alt", new String[] { attentionText }).toString(request.getLocale()) + "\"";
            }
		}
		else if (bean.getStatusType() == PStatusBarTreeModel.STATUS_TYPE_EVENTS) {
			events = bean.getTotalChildren();
			eventText = bean.getName();
			eventMiniText = miniText;
            if (events > 0) {
                eventAnchorAttr = "href=\"" + ((PStatusBar.EPStatusBar)hmcSession.getSessionAttribute(PStatusBar.HEALTHAREA_SESSIONKEY)).getEventsTaskUrl() + "\" "
                                + "title=\"" + new LocalizableText("com/ibm/hwmca/ui/bonsai/res/bonsai", "view.open.alt", new String[] { eventText }).toString(request.getLocale()) + "\"";
            }
        }
    }
%>

<ul class="status">
    <li id="system" <%= errors == 0 ? "" : "class=\"bad\"" %>>
        <a class="icon" <%= (errorAnchorAttr == null) ? "" : errorAnchorAttr %>></a>
        <h2><%= (errorAnchorAttr == null) ? "" : ("<a " + errorAnchorAttr + ">") %><%= errorText %><%= (errorAnchorAttr == null) ? "" : "</a>" %> (<%= errors %>)</h2>
        <p id="systemMessage"><%= errorMiniText %></p>
    </li>
    <li id="attentions" <%= attentions == 0 ? "" : "class=\"bad\"" %>>
        <a class="icon" <%= (attentionAnchorAttr == null) ? "" : attentionAnchorAttr %>></a>
        <h2><%= (attentionAnchorAttr == null) ? "" : ("<a " + attentionAnchorAttr + ">") %><%= attentionText %><%= (attentionAnchorAttr == null) ? "" : "</a>" %> (<%= attentions %>)</h2>
        <p id="attentionsMessage"><%= attentionMiniText %></p>
    </li>
    <li id="serviceables" <%= events == 0 ? "" : "class=\"bad\"" %>>
        <a class="icon" <%= (eventAnchorAttr == null) ? "" : eventAnchorAttr %>></a>
        <h2><%= (eventAnchorAttr == null) ? "" : ("<a " + eventAnchorAttr + ">") %><%= eventText %><%= (eventAnchorAttr == null) ? "" : "</a>" %> (<%= events %>)</h2>
        <p id="serviceablesMessage"><%= eventMiniText%></p>
    </li>
</ul>

</div>
</body>

</wcl:Foundation>

</html>

</fmt:bundle>
