function adjustWindowSize(defWidth, defHeight, screenVerticalAdjustment) {
   var element = document.getElementById("hmcPanelTable");
   var desiredWidth = -1, desiredHeight = -1;

   // If the width and height were explicitly given, use those.
   var attr = element.attributes.getNamedItem["width"];
   if (attr != null) desiredWidth = attr.value;

   attr = element.attributes.getNamedItem["height"];
   if (attr != null) desiredHeight = attr.value;

   if (desiredWidth == -1 && desiredHeight == -1) {
      // If the window starts narrow, we don't necessarily want it to stay
      // narrow.  Give the window the default size initially and let it go up
      // or down from there.
      window.resizeTo(defWidth, defHeight);
//window.resizeTo(screen.availWidth, screen.availHeight);
   }

   var setFullWidth  = desiredWidth  == -1;
   var setFullHeight = desiredHeight == -1;

   // If no explicit values, but the browser will tell us the size, use that.
//if (desiredWidth == -1 && "offsetWidth" in element) window.alert("Browser says to use "+element.offsetWidth+" for width")
   if (desiredWidth == -1 && "offsetWidth" in element)
      desiredWidth = element.offsetWidth;

//if (desiredHeight == -1 && "offsetHeight" in element) window.alert("Browser says to use "+element.offsetHeight+" for height")
   if (desiredHeight == -1 && "offsetHeight" in element)
      desiredHeight = element.offsetHeight;

   // Resize if we know what the desired size is, otherwise leave it alone.
   if (desiredWidth != -1 && desiredHeight != -1) {
      // See if we can figure out how much extra to add to account for the frame
      var widthPadding = 32, heightPadding = 32;

      if ("innerWidth" in window && "outerWidth" in window)
         widthPadding = window.outerWidth - window.innerWidth;

      if ("innerHeight" in window && "outerHeight" in window)
         heightPadding = window.outerHeight - window.innerHeight;
//window.alert("Using widthPadding=="+widthPadding+" and heightPadding=="+heightPadding);

      var screenAvailHeight = screen.availHeight - screenVerticalAdjustment;

//    window.alert("Using a height pad of 24, width pad of 27");
      var finalWidth  = desiredWidth + widthPadding + 27;
//window.alert("finalWidth=="+finalWidth+", screen.availWidth=="+screen.availWidth);
//if (finalWidth > screen.availWidth * 95 / 100) window.alert("Limiting width to "+(screen.availWidth * 95 / 100));
      if (finalWidth > screen.availWidth * 95 / 100)
         finalWidth = screen.availWidth * 95 / 100;

      var finalHeight = desiredHeight + heightPadding + 24;
//window.alert("finalHeight=="+finalHeight+", screen.availHeight=="+screen.availHeight);
//if (finalHeight > screen.availHeight * 95 / 100) window.alert("Limiting height to "+(screen.availHeight * 95 / 100));
      if (finalHeight > screenAvailHeight * 95 / 100)
         finalHeight = screenAvailHeight * 95 / 100;

      window.resizeTo(finalWidth, finalHeight);

      if (("screenX" in window && "screenY" in window) ||
          ("screenLeft" in window && "screenTop" in window)) {
         // Capture window position.  Since screenLeft and screenTop give
         // info regarding the location of the content area, attempt to deduce
         // browser window location by subtracting the padding.
         var localScreenX = ("screenX" in window) ? window.screenX : window.screenLeft - widthPadding;
         var localScreenY = ("screenY" in window) ? window.screenY : window.screenTop - heightPadding;
//window.alert("Window is at coords "+localScreenX+", "+localScreenY);

         // Remember the beginning position of the window
         window.savedScreenX = localScreenX;
         window.savedScreenY = localScreenY;
//       alert("Window is presently at "+window.savedScreenX+", "+window.savedScreenY);

         // If we resized the window, the right edge or bottom edge might now
         // be off the screen.  Move left or up to correct that if necessary.
         var moveLeft = 0, moveUp  = 0;
         if (localScreenX + finalWidth > screen.availWidth)
            moveLeft = localScreenX + finalWidth - screen.availWidth;

         if (localScreenY + finalHeight > screenAvailHeight)
            moveUp = localScreenY + finalHeight - screenAvailHeight;

         if (moveLeft != 0 || moveUp != 0) {
            window.moveBy(-moveLeft, -moveUp);
         }
      }
   }

   // Change this so that the panel stretches when the window is made wider
//if (setFullWidth) window.alert("Setting width to 100%");
   if (setFullWidth)  element.setAttribute("width", "100%");

   // Change this so that the panel stretches when the window is made taller
   if (setFullHeight) element.setAttribute("height", "100%");
}

function isWindowClosed(windowHandle) {
   // Recent versions of IE give exceptions checking the closed property of
   // a closed window, so we wrap the check in a try/catch and assume the
   // window is closed if an exception is encountered.
   try {
      var isClosed = windowHandle.closed;
      return isClosed == null ? true : isClosed;

   } catch (e) {
      return true;
   }
}

function getHMCMainWindow(target) {
   // window.opener refers to the TaskController frame in the main ui window.
   // window.opener.top, therefore, refers to that frameset, which is defined
   // in mainuiFrameset.jsp.
   if ("hmcuimainwin" in target) {
//alert("using hmcuimainwin from window properties");
      return target.hmcuimainwin;
   } else if ("hmcMainWindowName" in target) {
      try {
         var mw = window.open("", target.hmcMainWindowName);
         if (mw != null) {
            // See if it's the main window we're expecting.  If it is,
            // it has a function called markWindowCloseHandled().  If our
            // window.open() call just created the window, then it won't.
            if ("markWindowCloseHandled" in mw)
               return mw;
            mw.close();  // We must have just opened it.  Close it quickly.
         }
      } catch (e) {
      }
   } else {
      try {
         if (target.opener != null) {
            var parts = target.opener.top.name.split('_');
            var topname = 'hmcuimainwin';
            if (parts != null && parts.length > 0) {
               topname = parts[parts.length-1];
            }
            if (topname == "hmcuimainwin") {
//alert("using opener.top");
               return target.opener.top;
            }
         }

//alert("using window.open from inside window with name="+window.name);
         var mw = window.open("", "hmcuimainwin");
         if (mw != null) {
            // See if it's the main window we're expecting.  If it is,
            // it has a function called markWindowCloseHandled().  If our
            // window.open() call just created the window, then it won't.
            if ("markWindowCloseHandled" in mw)
               return mw;
            mw.close();  // We must have just opened it.  Close it quickly.
         }

      } catch (e) {
      }
   }

   return null;
}

function callProcessTaskWindowUnload() {
   var mw = getHMCMainWindow(window);
   if (mw != null && isWindowClosed(mw)) return;

   //-opera start
   // deregister with the main UI window, so window closes are no longer monitored
   var userAgent  = navigator.userAgent.toLowerCase();
   var isOpera    = ( userAgent.indexOf( "opera" ) != -1 );
   if (isOpera) {
       if (mw != null && "deRegisterTaskWindow" in mw)
          mw.deRegisterTaskWindow(window.hmcTaskId);
   }
   //-opera end

   if (mw != null && "processTaskWindowUnload" in mw)
      mw.processTaskWindowUnload(window);
}

function initializeWinProps(taskId, mainWindowName) {
   //alert("in initializeWinProps().  Task id is "+taskId+"; main window name is "+mainWindowName);
   window.hmcTaskId = taskId;
   window.hmcMainWindowName = mainWindowName;

   try {
      if (opener != null && opener.top.name == mainWindowName)
         window.hmcuimainwin = opener.top;
      else
         var mw = window.open("", mainWindowName);
         if (mw != null) {
            // See if it's the main window we're expecting.  If it is,
            // it has a function called markWindowCloseHandled().  If our
            // window.open() call just created the window, then it won't.
            if ("markWindowCloseHandled" in mw) {
               window.hmcuimainwin = mw;
            } else {
               mw.close();  // We must have just opened it.  Close it quickly.
            }
         }

   } catch (e) {
      // Can't figure out main window
   }
}

function hmcFormSubmitted() {
   if ("screenX" in window && "screenY" in window &&
       "savedScreenX" in window && "savedScreenY" in window) {
      if (window.screenX != window.savedScreenX ||
          window.screenY != window.savedScreenY) {    // Window was moved

         if ("action" in this && this.action.indexOf("/hmc/wcl/") != -1) {
            // Create a hidden form field to transmit the current window position
            // This name/value pair will be included in the form that is submitted.
            var hmcScreenElement = document.createElement("input");
            hmcScreenElement.setAttribute("type", "hidden");
            hmcScreenElement.setAttribute("name", "hmcWindowPosition");
            hmcScreenElement.setAttribute("value", ""+window.screenX+","+window.screenY);
            this.appendChild(hmcScreenElement);
         }
      }
   }
}

//-opera start
var mainWinChecker;
var mainWindow;
var closeCount = 0;
function checkMainWindow() {
   //window.alert("closeCount="+closeCount+";.closed="+isWindowClosed(mainWindow));
   if (mainWindow != null && isWindowClosed(mainWindow)) {
      if (closeCount > 2) {
         tempwin = window.open("", "mainlogoff_local", "width=500,height=500,top="+((screen.availHeight-500)/2)+",left="+((screen.availWidth-500)/2));
         if ("xCloseHandled" in tempwin) {
         } else {
            tempwin.xCloseHandled = true;
            tempwin.location.replace("/hmc/task?op=mainwindowclose&windowname=mainlogoff_local");
         }
         if (window.name != "mainlogoff_local") {
            window.close();
         }
      } else {
         closeCount++;
         mainWindowChecker = window.setTimeout("checkMainWindow()", 1000);
      }
   } else {
      closeCount = 0;
      mainWindowChecker = window.setTimeout("checkMainWindow()", 1000);
   }
}

var mainWinRegister;

function registerWithMainWindow() {
   if (window.name.indexOf("mainlogoff_") != 0) {
      mw = getHMCMainWindow(window);

      if (mw != null && "registerTaskWindow" in mw) {
         mw.registerTaskWindow(window, window.hmcTaskId);
         mainWindow = mw;
         checkMainWindow();
      } else {
         // setup timer to try and register later
         //window.alert("trying to register later with main window for window: "+window.name+"\nwindow.opener="+window.opener+"\n"+"window.top.name="+window.top.name);
         mainWinRegister = window.setTimeout("registerWithMainWindow()", 1000);
      }
   }
}
//-opera end

function trapWindowClose() {
//alert("in trapWindowClose");
   window.onunload = callProcessTaskWindowUnload;

   setUpJSError(); //HMCPanel.java includes onerror.js

   // Trap any form submissions so that we can communicate any window moves
   for (var i=0; i<document.forms.length; ++i) {
//    alert("Form "+i+": "+(typeof document.forms[i].onsubmit));
      document.forms[i].onsubmit = hmcFormSubmitted;
   }

   //-opera start
   // register with the main UI window, so window closes can be performed with Opera
   var userAgent  = navigator.userAgent.toLowerCase();
   var isOpera    = ( userAgent.indexOf( "opera" ) != -1 );
   if (isOpera) {
      registerWithMainWindow();
   }
   //-opera end
}


/****************************************************************/
/***** Table sizing code -- Should be moved to its own file *****/
/****************************************************************/

// nudge the table size a bit to accomodate the scrollbars
var SCROLLBAR_PADDING = 20;

/** WTable (scrolling)**
 * setup table for scrolling
 */
function hmc_setupTable(dataBodyEnc, disableResizers) {

   var dataBody = document.getElementById(dataBodyEnc);

   if ( ( WClient.isBrowserOpera() && dataBody.clientHeight > 0)
     || (!WClient.isBrowserOpera() && dataBody.offsetHeight > 0) ) {
      var scrollPaneEnc = dataBody.getAttribute('SPID');
      var scrollPane = document.getElementById(scrollPaneEnc);
      var actionBarEnc = dataBody.getAttribute('ABID');
      var actionBar = document.getElementById(actionBarEnc);
      var offset = actionBar ? actionBar.offsetHeight : 0;
      var viewRows = dataBody.getAttribute('RPV');
      var numRows = dataBody.getAttribute('DR');
      var currentPage = dataBody.getAttribute( "CPG" );

      var height = WClient.isBrowserOpera() ? dataBody.clientHeight : dataBody.offsetHeight;
      scrollPane.style.height = offset + ((height / dataBody.rows.length) * Math.min(numRows, viewRows));

      isScrollbars = ( parseInt(numRows) > parseInt(viewRows) );

      // scroll the table to ensure the current page is visible
      scrollPane.scrollTop = 0;  // scroll to top by default ...
      var firstRow = currentPage * viewRows;

      /************************************************/
      /********** Depends on EventManager.js **********/
      /************************************************/
      // delay scrollbar positioning to allow panel to fully render ...
      hmcAddEvent( window, "load", function() {
         hmcAddEvent( window, "load", function(){
            delaySetScrollbarPosition( scrollPane.id, dataBody.rows[firstRow].offsetTop );
         });
      });

      if (scrollPane.getAttribute('H1BID')) {
         hmc_resizeDiv(scrollPaneEnc, disableResizers, isScrollbars);

         if ( WClient.isBrowserOpera() ) {
            var div = document.getElementById(scrollPaneEnc);
            var headBody2 = document.getElementById(div.getAttribute('H2BID'));
            headBody2.style.display = 'none';
            hmc_resizeDiv(scrollPaneEnc, disableResizers, isScrollbars);
         }
      }
   }
   else {
      hmcAddEvent( window, "load", function() {hmc_setupTable( dataBodyEnc, disableResizers ); } );
   }
}

/**
 */
function delaySetScrollbarPosition( scrollbar, position ) {
   setTimeout( "setScrollbarPosition('" + scrollbar + "','" + position + "')", 50 );
}

/**
 * Adjust the final position of the scrollbar ... after a brief delay ...
 */
function setScrollbarPosition( scrollbar, position ) {
   var scrollbar = document.getElementById( scrollbar );
   scrollbar.scrollTop = position;
}

/** WTable (scrolling)**
 * handles resize of div
 */
function hmc_resizeDiv(divID,disableResizers,isScrollbars) {

   var resizeOption = ''
   if (document != null && document.forms != null) {
      for (var i=0; i < document.forms.length && resizeOption == ''; i++) {
         var form = document.forms[i];
         if (form != null) {
            if ( form.resizeOption ) {
               resizeOption = form.resizeOption.value;
            }
         }
      }
   }

   if ( WClient.isBrowserOpera() ) {    //opera call before IE as Opera may identify itself as IE
       hmc_resizeDivOpera(divID, resizeOption, disableResizers, isScrollbars);
   } else if ( WClient.isBrowserInternetExplorer() ) {
       hmc_resizeDivIE(divID, resizeOption, disableResizers, isScrollbars);
   } else {
       hmc_resizeDivMoz(divID, resizeOption, disableResizers, isScrollbars);
   }
}

/** WTable (scrolling)**
 * handles resize of div for IE
 */
function hmc_resizeDivIE(divID, resizeOption, disableResizers, isScrollbars) {

   var div = document.getElementById(divID);
   var headBody1 = document.getElementById(div.getAttribute('H1BID'));
   var headBody2 = document.getElementById(div.getAttribute('H2BID'));
   var tableStyle = headBody2.parentNode.style;
   var cellCount = headBody2.rows[0].cells.length-1;
   var cellCount = (disableResizers=="true") ? headBody2.rows[0].cells.length-1 : headBody2.rows[0].cells.length;
   var widths = new Array(cellCount);

   tableStyle.tableLayout = 'auto';

   var totalWidth = 0;
   for (var c = 0; c < cellCount; c++) {
       var head1 = headBody1.rows[0].cells[c];
       var head2 = headBody2.rows[0].cells[c];

       head1.style.tableLayout = 'auto';
       head2.firstChild.style.tableLayout = 'auto';
       widths[c] = head1.width != '' ? head1.width : head2.offsetWidth;
       totalWidth += parseInt(widths[c]);
   }

   //handle WTableResizeLast resizeOption
   if ( resizeOption == "WTableResizeLast" ) {
      widths[cellCount-1] = '100%';
   }

   tableStyle.display = 'none';
   tableStyle.tableLayout = 'fixed';
   tableStyle.display = '';

   for (var c = 0; c < cellCount; c++) {
       var head1 = headBody1.rows[0].cells[c];
       var head2 = headBody2.rows[0].cells[c];

       //handle WTableResizeJustify resizeOption
       if ( resizeOption == "WTableResizeJustify" && headBody1.offsetWidth > totalWidth )
          widths[c] = widths[c] + Math.round(((headBody1.offsetWidth - totalWidth) * (widths[c] / totalWidth)));

       head1.width = widths[c];
       head2.width = widths[c];
   }

   headBody1.parentNode.style.tableLayout = "fixed";
   headBody1.parentNode.style.width = "auto";

}


/** WTable (scrolling)**
 * handles resize of div for Mozilla
 */
function hmc_resizeDivMoz(divID, resizeOption, disableResizers, isScrollbars) {

   var div = document.getElementById(divID);
   var headBody1 = document.getElementById(div.getAttribute('H1BID'));
   var headBody2 = document.getElementById(div.getAttribute('H2BID'));
   var tableStyle  = headBody2.parentNode.style;
   var tableStyle1 = headBody1.style;
   var cellCount = (disableResizers=="true") ? headBody2.rows[0].cells.length-1 : headBody2.rows[0].cells.length;
   var widths = new Array(cellCount);

   var cellWidths = new Array(cellCount);
   for (var c = 0; c < cellCount; c++) {
       cellWidths[c] = 0;
   }

   div.style.width='0px';           //shrink div to content
   headBody1.style.width='0px';     //shrink header table to content
   headBody2.style.width='0px';     //shrink data table to content

   //get auto-sized column widths
   var totalWidth = 0;
   for (var c = 0; c < cellCount; c++) {
      var head1 = headBody1.rows[0].cells[c];
      var head2 = headBody2.rows[0].cells[c];

//    head2.firstChild.style.tableLayout = 'auto';
      widths[c] = head2.offsetWidth;
      totalWidth += parseInt(widths[c]);
   }

   //handle WTableResizeLast resizeOption
   if ( resizeOption == "WTableResizeLast" ) {
      widths[cellCount-1] = '100%';
   }

   //disable autosizing
   tableStyle.display = 'none';
   tableStyle.tableLayout = 'fixed';
   tableStyle.display = '';

   //set fixed column widths
   for (var c = 0; c < cellCount; c++) {
      var head1 = headBody1.rows[0].cells[c];
      var head2 = headBody2.rows[0].cells[c];

      //handle WTableResizeJustify resizeOption
      if ( resizeOption == "WTableResizeJustify" && headBody1.offsetWidth > totalWidth )
          widths[c] = widths[c] + Math.round(((headBody1.offsetWidth - totalWidth) * (widths[c] / totalWidth)));

      head1.width = head1.width != '' ? head1.width : widths[c];
      head2.width = head1.width != '' ? head1.width : widths[c];

      // if processing last column and scrollbars are present, add some extra space
      if ( ( c == cellCount-1 ) && isScrollbars ) {
         if ( resizeOption != "WTableResizeLast" ) {
            head1.width = parseInt( head1.width ) + SCROLLBAR_PADDING;
            head2.width = parseInt( head2.width ) + SCROLLBAR_PADDING;
         } // end if
      } // end if
   }

   //now that column sizes are set, set div to 100%
   div.style.width='100%';
}


/** WTable (scrolling)**
 * handles resize of div
 */
function hmc_resizeDivOpera(divID, resizeOption, disableResizers, isScrollbars) {

   var div = document.getElementById(divID);
   var headBody1 = document.getElementById(div.getAttribute('H1BID'));
   var headBody2 = document.getElementById(div.getAttribute('H2BID'));
   var tableStyle  = headBody2.parentNode.style;
   var tableStyle1 = headBody1.style;
   var cellCount = (disableResizers=="true") ? headBody2.rows[0].cells.length-1 : headBody2.rows[0].cells.length;
   var widths = new Array(cellCount);

   var divWidth = div.offsetWidth;

   //flag tables for autosize
   div.style.width         = '0px';
   div.style.overflow      = 'auto'
   headBody1.style.width   = '0px';
   headBody2.style.width   = '0px';
   tableStyle1.tableLayout = 'auto';

   //get auto-sized column widths
   var totalWidth = 0;
   for (var c = 0; c < cellCount; c++) {
      var head1 = headBody1.rows[0].cells[c];
      var head2 = headBody2.rows[0].cells[c];

      head1.style.tableLayout = 'auto';
      head2.firstChild.style.tableLayout = 'auto';

      widths[c] = ( head2.offsetWidth == 0 ) ? head1.offsetWidth : head2.offsetWidth;
      totalWidth += parseInt(widths[c]);
   }

   //disable autosizing
   tableStyle.display      = 'none';
   tableStyle.tableLayout  = 'fixed';
   tableStyle.display      = '';
   tableStyle1.display     = 'none';
   tableStyle1.tableLayout = 'fixed';
   tableStyle1.display     = '';

   //handle WTableResizeLast resizeOption
   if ( resizeOption == "WTableResizeLast" ) {
      widths[cellCount-1] = '100%';
   }

   if ( headBody1.rows[0].cells[0].width == '' ) {
      //set fixed column widths
      for (var c = 0; c < cellCount; c++) {
         var head1 = headBody1.rows[0].cells[c];
         var head2 = headBody2.rows[0].cells[c];

         //handle WTableResizeJustify resizeOption
         if ( resizeOption == "WTableResizeJustify" && divWidth > totalWidth )
             widths[c] = widths[c] + Math.round(((divWidth - totalWidth) * (widths[c] / totalWidth)));

         head2.width = head1.width = head1.width != '' ? head1.width : widths[c];

         // if processing last column and scrollbars are present, add some extra space
         if ( ( c == cellCount-1 ) && isScrollbars ) {
            if ( resizeOption != "WTableResizeLast" ) {
               head1.width = parseInt( head1.width ) + SCROLLBAR_PADDING;
               head2.width = parseInt( head2.width ) + SCROLLBAR_PADDING;
            } // end if
         } // end if

      }
   } else {
      //set fixed column widths
      for (var c = 0; c < cellCount; c++) {
         var head1 = headBody1.rows[0].cells[c];
         var head2 = headBody2.rows[0].cells[c];
         var body2 = headBody2.nextSibling;

         var rowCount = body2.rows.length;
         //set fixed column widths
         for (var r = 0; r < rowCount; r++) {
            var cell        = body2.rows[r].cells[c];
            var cellStyle   = document.defaultView.getComputedStyle(cell, "");
            var cellPadding = parseInt(cellStyle.getPropertyValue("padding"));

            if ( c == cellCount-1 ) {
               cell.width  = '100%';
               head2.width = head1.width;
            } else {
               cell.width  = head1.width - (2 * cellPadding);   //account for left & right cell padding
               head2.width = head1.width;
            }
         }

         if ( c == cellCount-1 ) {
            head1.width = head2.width;
         }

         // if processing last column and scrollbars are present, add some extra space
         if ( ( c == cellCount-1 ) && isScrollbars ) {
            if ( resizeOption != "WTableResizeLast" ) {
               head1.width = parseInt( head1.width ) + SCROLLBAR_PADDING;
               head2.width = parseInt( head2.width ) + SCROLLBAR_PADDING;
            } // end if
         } // end if

      }
   }

   //now that column sizes are set, set div to 100%
   div.style.width='100%';
}
