/*
 * (c)  Copyright  IBM Corp.  1999, 2006  All Rights Reserved
 *
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp
 *
 * Notes:
 * js file used to persist wcl table column widths
 *
 * Module History:
 * 05/23/2006  J. Miller    Initial Release
 * 08/30/2006  J. Miller    AJAX support for clearing column widths
 * 09/18/2006  J. Miller    new wtable onresize method to help align toolbar's buttons
 * 10/09/2006  J. Miller    onBonsaiWorkareaResizeAjax cleanup
 * 11/13/2006  J. Miller    kick up column width/scroll position updates using AJAX
 * 02/22/2007  J. Miller    resize table on frame resize when using ajax
 * 03/01/2007  J. Miller    table row client-side faux select
 *                          don't resize table on frame resize when using ajax unit initWidth bug can be fixed
 * 03/02/2007  J. Miller    reset rpvmax on resize
 * 03/23/2007  J. Miller    do not faux select table row if isAjaxOutstanding
 * 04/17/2007  JMiller      ajax resize table on frame resize fixes
 *
 */

//onBonsaiWorkareaResizeAjax - perform actions needed when a bonsai workarea frame is resized
// -in: divID  - id of the div containing the table
//      formID - id of AJAX form to submit
//      colUrl - callback url of the WTable colWidths trigger
//      event  - event which triggered this method
//-out: none, form submitted, values reset
function onBonsaiWorkareaResizeAjax(dataBodyEnc, formID, colUrl, event) {
  if ( typeof saveFrameDimensionsAjax == 'function' ) { 
    saveFrameDimensionsAjax(event);
  }

  var dataBody = document.getElementById(dataBodyEnc);
  if ( !dataBody ) {
     return;
  }
  
  //if autosize reset rpvmax value
  var autosize = ( dataBody.getAttribute("autorpv") == "true" );
  if ( autosize ) {
    dataBody.setAttribute("rpvmax", 0);
    var scrollPaneEnc = dataBody.getAttribute('SPID');
    var scrollPane = document.getElementById(scrollPaneEnc);
    if (scrollPane != null) {
      scrollPane.childNodes[2].value = 0;
    }
  }

  //clear persisted column widths and resize table
  var dataBody = document.getElementById(dataBodyEnc);
  if (dataBody != null) {
    var scrollPaneEnc = dataBody.getAttribute('SPID');
    clearSavedColumnWidthsAjax(scrollPaneEnc, colUrl);

    if ( typeof setupTableAjax == 'function' ) { 
      setupTableAjax(dataBodyEnc, true);
    }
  }
}

//onBonsaiWorkareaResize - perform actions needed when a bonsai workarea frame is resized
// -in: divID  - id of the div containing the table
//      event  - event which triggered this method
//-out: none, form submitted, values reset
function onBonsaiWorkareaResize(dataBodyEnc, event) {
  if ( typeof saveFrameDimensions == 'function' ) { 
    saveFrameDimensions(event);
  }
  
  if ( typeof setupTable == 'function' ) { 
    setupTable(dataBodyEnc, true);
  }
}

//clearSavedColumnWidthsAjax - clear values in AJAX divs that send column widths to server
// -in: divID - id of the div containing the table
//-out: none
function clearSavedColumnWidthsAjax(divID, colUrl) {
  var div = document.getElementById(divID);
  if ( div != null ) {  
    var headBody1 = document.getElementById(div.getAttribute('H1BID'));
    if ( headBody1 != null ) {
      //loop over table columns and set AJAX column width values
      var cellCount = headBody1.rows[0].cells.length-1;
      for (var c = 0; c < cellCount; c++) {
        var head1 = headBody1.rows[0].cells[c];
        head1.removeAttribute("prefWidth");
        try {
          head1.firstChild.rows[0].lastChild.lastChild.value = "0";
        } catch (widthError) {
          debug("Error setting table column width: [" + widthError.name + "] [" + widthError.message + "]");
        }
      }
      columnWidthsHelperAjax(divID, colUrl, true);
    }
  }
}

//saveColumnWidths - submit column widths dimensions for persisitence
// -in: divID - id of the div containing the table
//-out: none, column width form submitted
function saveColumnWidthsAjax(divID, colUrl) {
  columnWidthsHelperAjax(divID, colUrl, false);
}

//updateTableDataAjax - submit AJAX form update
// -in: formID - id of AJAX form to submit
//-out: none, form submitted, values reset
function updateTableDataAjax(formID, action) {
  if ( action == null ) {
      action = '';
  }
  var form = document.getElementById(formID);
  if ( form != null ) {
    startRequest(form, '');
    // Reset the form values.
    if ( form.wclanchor != null && form.wclhidden != null ) {
      eval("form." + wclanchor + ".value = ''");
      eval("form." + wclhidden + ".value = ''");
    }
    return false;
  }
}

//columnWidthsHelperAjax - submit column widths dimensions for persisitence
// -in: divID - id of the div containing the table
//      clearWidths - clear saved column widths for this tableID/workareaWidth
//-out: none, column width form submitted
function columnWidthsHelperAjax(divID, colUrl, clearWidths) {
  var url = colUrl;//"/hmc/ui/bonsai/columnwidths.do";
  var params = "";
  var inputName  = "";
  var inputValue = "";
  var input;

  try {
    //tablePage id
    var frame = window.top.hmcmainui.workarea_frame.frames[0];
    inputName = "tablePageId";
    input     = document.getElementById( inputName );

    if ( frame && frame.document && frame.document.body && frame.document.body.getAttribute("id") ) {
      inputValue = frame.document.body.getAttribute("id");
      params = addParam(params, inputName, inputValue);
    }


    //if !clearWidths append inputs for column widths
    var div           = document.getElementById(divID);
    var headBody1     = document.getElementById(div.getAttribute('H1BID'));
    var cellCount     = headBody1.rows[0].cells.length-1;
    if ( !clearWidths ) {
      for (var c = 0; c < cellCount; c++) {
        var head1 = headBody1.rows[0].cells[c];
        inputName  = head1.getAttribute("colIdentifier");
        inputValue = head1.width;
        if ( isNaN(inputValue) ) {
           return;
        }
        params = addParam(params, inputName, inputValue);
      }
    }


    //clear widths?
    inputName  = "clearWidths";
    inputValue = ( clearWidths ) ? "true" : "false";
    params = addParam(params, inputName, inputValue);


    //column order
    var colOrder  = "";
    for (var c = 0; c < cellCount; c++) {
      var head1 = headBody1.rows[0].cells[c];
      colId  = head1.getAttribute("colIdentifier");
      colOrder = colOrder + colId;
    }

    inputName  = "columnOrder";
    inputValue = colOrder;
    params = addParam(params, inputName, inputValue);
  } catch (e) {
    //no frame width/id -> abort
    return;
  }

  try {
    new AsyncJson( url + params,
                   function(json) {
                     return true;
                   }
    );
  } catch( e ) {
  }

  return true;
}



//clearSavedColumnWidths - submit request to clear saved column width dimensions for given tableID/workareaWidth
// -in: divID - id of the div containing the table
//-out: none, column width reset form submitted
function clearSavedColumnWidths(divID) {
  columnWidthsHelper(divID, true);
}

//saveColumnWidths - submit column widths dimensions for persisitence
// -in: divID - id of the div containing the table
//-out: none, column width form submitted
function saveColumnWidths(divID) {
  columnWidthsHelper(divID, false);
}

//saveColumnWidths - submit column widths dimensions for persisitence
// -in: divID - id of the div containing the table
//      clearWidths - clear saved column widths for this tableID/workareaWidth
//-out: none, column width form submitted
function columnWidthsHelper(divID, clearWidths) {
  var formName = "columnWidthsForm";
  var form = document.forms[formName];
  if ( form != null ) {
    document.body.removeChild(form);
  }

  //create form
  form = document.createElement( "FORM" );
  with ( form ) {
    name   = formName;
    id     = formName;
    action = "/hmc/ui/bonsai/columnwidths.do";
    method = "POST";
  }

  try {
    //tablePage id
    frame     = window.top.hmcmainui.workarea_frame.frames[0];
    inputName = "tablePageId";
    input     = document.getElementById( inputName );

    if ( frame && frame.document && frame.document.body && frame.document.body.getAttribute("id") ) {
      inputValue = frame.document.body.getAttribute("id");
      if ( !input ) {
        input = document.createElement( "INPUT" );
        with ( input ) {
          type  = "hidden";
          id    = inputName;
          name  = inputName;
        }
        form.appendChild( input );
      }
      input.value = inputValue;
    } else if ( input ) {
      form.removeChild( input );
    }


    //if !clearWidths append inputs for column widths
    var div           = document.getElementById(divID);
    var headBody1     = document.getElementById(div.getAttribute('H1BID'));
    var cellCount     = headBody1.rows[0].cells.length-1;
    if ( !clearWidths ) {
      for (var c = 0; c < cellCount; c++) {
        var head1 = headBody1.rows[0].cells[c];
   
        inputName  = head1.getAttribute("colIdentifier");
        inputValue = head1.width;
        input      = document.getElementById( inputName );
   
        if ( !input ) {
          input = document.createElement( "INPUT" );
          with ( input ) {
            type  = "hidden";
            id    = inputName;
            name  = inputName;
          }
          form.appendChild( input );
        }
        input.value = inputValue;
      }
    }

    //clear widths?
    inputName  = "clearWidths";
    inputValue = ( clearWidths ) ? "true" : "false";
    input      = document.getElementById( inputName );

    if ( !input ) {
      input = document.createElement( "INPUT" );
      with ( input ) {
        type  = "hidden";
        id    = inputName;
        name  = inputName;
      }
      form.appendChild( input );
    }
    input.value = inputValue;


    //column order
    var colOrder  = "";
    for (var c = 0; c < cellCount; c++) {
      var head1 = headBody1.rows[0].cells[c];
      colId  = head1.getAttribute("colIdentifier");
      colOrder = colOrder + colId;
    }

    inputName  = "columnOrder";
    input      = document.getElementById( inputName );
    inputValue = colOrder;

    if ( !input ) {
      input = document.createElement( "INPUT" );
      with ( input ) {
        type  = "hidden";
        id    = inputName;
        name  = inputName;
      }
      form.appendChild( input );
    }
    input.value = inputValue;

    submitMe = true;
  } catch (e) {
    //no frame width/id -> abort
    return;
  }

  document.body.appendChild(form);
  document.forms[formName].submit();
  return false;
}

//alignToolbarButtons - set the width of the parent TDs of the elements with the 
//given IDs to the given widths
// -in: vmbId - id of the views menubutton
//      vmbTdWidth - desired width of the views menubutton's parent TD
//      sepId - id of the toolbar separator image
//      sepTdWidth - desired width of the separator's parent TD
//-out: none, parent TD widths updated
function alignToolbarButtons(vmbId, vmbTdWidth, sepId, sepTdWidth) {
    var vmb = document.getElementById(vmbId);
    var sep = document.getElementById(sepId);
    try {
        var vmbTd = vmb.parentNode;
        while( vmbTd.className != 'lyt2' ) {
            vmbTd = vmbTd.parentNode;
        }
        vmbTd.width = vmbTdWidth;
    } catch(e) {
    }
    try {
        var sepTd = sep.parentNode;
        while( sepTd.tagName.toUpperCase() != 'TD' ) {
            sepTd = sepTd.parentNode;  
        }
        sepTd.width = sepTdWidth;
    } catch(e) {
    }
}


var BONSAI_SCROLL_TOP = "bonsaiTableScrollTop";   //name of cookie which stores the opened menu's path
//bonsaiSaveScrollPosition - handles scroll of table then sends scrollTOp up to server
// -in: scrollPaneID - id of the scrollPane
//      formID - id for wcl form to use to update the table data 
//-out: none, scroll position update sent to server
function bonsaiSaveScrollPositionAjax(scrollPaneID, formID) {
    var scrollPane = document.getElementById(scrollPaneID);
    setScrollPositionAjax(scrollPane); //wcl method
    if ( scrollPane != null && scrollPane.scrollTop > 0 ) {
        var scrollTop = getCookie(BONSAI_SCROLL_TOP);
        if ( scrollTop == scrollPane.scrollTop ) {
            return;
        }
        createCookie(BONSAI_SCROLL_TOP, scrollPane.scrollTop);
    }
    updateTableDataAjax(formID, 'rahr');
}

//bonsaiSetScrollPosition - set the scrollTop for the elem with the given id
// -in: scrollPaneID - id of the scrollPane
//-out: none, scrollTop updated
function bonsaiSetScrollPosition(scrollPaneID) {
    var scrollPane = document.getElementById(scrollPaneID);
    if ( scrollPane != null ) {
        var scrollTop = getCookie(BONSAI_SCROLL_TOP);
        if ( scrollTop != null ) {
            scrollPane.scrollTop = scrollTop;
        }
    }
}


/** WTable **
 * persist table scrollTop
 * url - WTable callback url, may already have params defined
 * actionName - the name of the action being performed
 * actionValue - the name of the component performing the action
 * divId - the id of the table div
 * clearWait - if true ignore/clear isScrolling flag, used to process a script-trigger
 *             follow-up scroll event .5sec after the first scroll event is received.
 *             This is done because browsers currently trigger multiple scroll events
 *             while scrolling; ideally scrollTop should be persisted when onscrollend.
 */
function doScrlAjax(url, actionName, actionValue, divId, clearWait) {
    var div = document.getElementById(divId);
    if ( div == null ) {
        return;
    }

    try {
        window.top.hmcmainui.workarea_frame.workareaScrollTopValue = div.scrollTop;
        window.top.hmcmainui.workarea_frame.workareaScrollTopID    = window.top.hmcmainui.workarea_frame.frames[0].document.body.id;
    } catch(e) {
        try {
            window.top.hmcmainui.workarea_frame.workareaScrollTopValue = 0;
            window.top.hmcmainui.workarea_frame.workareaScrollTopID    = null;
        } catch(e) {
        }
    }
    
    try {
        if ( div.getAttribute(SCROLL_LOCK) == "true" && !clearWait ) {
           //already scrolling and not flagged to ignore lock, so dont process scroll event
           return;
        }
        div.setAttribute(SCROLL_LOCK, "true" );   //set div lock
    } catch (e) {
        return;
    }

    //only update if necessary
    if ( div.scrollTop != div.firstChild.value ) {
        setScrollPositionAjax(divId);

        //ajax update new scroll value
        try {
            var params = "";
            if ( url.indexOf('?') == -1 ) {
                params = "?";
            } else if ( url.indexOf('=') != -1 ) {
                params = "&";
            }
            params = params + actionName + "=" + actionValue + "(" + div.scrollTop + ")";
            new AsyncJson( url + params,
                           function(json) {
                               return true;
                           }
            );
        }catch (e) {
        }
    }

    //clear lock if this was a follow-up scroll event, otherwise schedule follow-up event after timeout
    if ( clearWait ) {
        div.setAttribute(SCROLL_LOCK, "false" );   //set div lock
    } else {
        setTimeout("doScrlAjax('" + url + "', '" + actionName + "', '" + actionValue + "', '" + divId + "', true)", 500);
    }
    return false;
}

/** WTable (scrolling)**
 * set scroll top value based on scroll position value
 */
function bonsaiSetScrollTopAjax(scroller)
{
   var scrollDiv = document.getElementById(scroller);
   if (scrollDiv != null) {
      var scrollPos = null;
      try { 
          if ( document.body.id == window.top.hmcmainui.workarea_frame.workareaScrollTopID ) {
              scrollPos = window.top.hmcmainui.workarea_frame.workareaScrollTop;
          }
      } catch (e) {
      }
      if ( !scrollPos ) {
         scrollPos = scrollDiv.firstChild.value;
      }
      scrollDiv.scrollTop = scrollPos;
   }
}

//bonsaiToggleRowSelection
//client-side table row deselect - changes table row cells style class and 
//hides/disables the rows select column image.  if the row is being 
//deselected or radio select is used and another row is selected (indicated 
//by selIndex != -1), the currently selected row's style is toggled and any
//context menu launcher in the row are disabled
// -in: dataBodyEnc - table div ID
//      rowIndex - index of row that is being toggled
//      newClass - new css class of the row that is being selected
//      newImage - img src for the toggled row's select cell
//      selIndex - index of currently selected row if radio selection enabled
//      selClass - new css class of the row that was selected
//      selImage - new img src for selected row's select cell
// -out: none
function bonsaiToggleRowSelection(dataBodyEnc, rowIndex, newClass, newImage, selIndex, selClass, selImage) {
   //abort if isAjaxOutstanding
   if ( (typeof isAJAXOutstanding == "boolean") && isAJAXOutstanding ) {
      return;
   }
   
   var dataBody = document.getElementById(dataBodyEnc);
   if (dataBody != null) {
      //loop over columns in table
      var cellCount = dataBody.rows[rowIndex].cells.length;
      for (var c = 0; c < cellCount; c++) {
         var td = dataBody.rows[rowIndex].cells[c];
         var oldClass = td.className;

         //update table cell style/row selection image    
         if ( selIndex == -1 || ( selIndex != -1 && selIndex != rowIndex ) ) {
            td.className = newClass;
            if ( c == 0 ) {
               toggleAndDisableSelectImage(td, newImage);
            }
         }

         //toggle previously selected row class and select image and hide the popup menu
         if ( selIndex != -1 || oldClass == 'tbls2') {
            //toggle previously selected row class and select image
            if ( selIndex != -1 ) {
               td = dataBody.rows[selIndex].cells[c];
               td.className = selClass;
               if ( c == 0 ) {
                  toggleAndDisableSelectImage(td, selImage);
               }
            }

            disableCellPopupMenu(td, cellCount);
         }
      }
   }
}

//toggleAndDisableSelectImage
//hides/disables the row's select column image.
// -in: div - table div
//      newImage - img src for the toggled row's select cell
// -out: none
function toggleAndDisableSelectImage(div, newImage) {
   //loop til we find td's select image, then disable and change 
   //it (refresh will reenable it)
   while ( div.firstChild && div.tagName != 'IMG' ) {
      div = div.firstChild;
   }
   if ( div.tagName == 'IMG' ) {
      div.parentNode.onclick = null;
      div.style.display = 'none';
      div.src = newImage;
      div.style.display = '';
   }
}

//disableCellPopupMenu
//hide/disable context menu launcher in the given row's cells
// -in: td - table row td
//      cellCount - number of columns in the table row
// -out: none
function disableCellPopupMenu(td, cellCount) {
   //hide the popup previously selected row's popup menu
   try {
      var links = td.getElementsByTagName('A');
      if ( links.length > 0 ) {
         //loop over the td's link decendants; disable any popup menu links 
         //and hide their launcher images
         for (var l = 0; l < cellCount; l++) {
            var link = links[l];
            if ( link && link.id && link.id.indexOf("popup_") != -1 ) {
               link.disabled = true;
               link.firstChild.style.display = 'none';
            }
         }
      }
   } catch (e) {
   }
}
