/*
 * (c)  Copyright  IBM Corp.  1999, 2006  All Rights Reserved
 *
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp
 *
 * Notes:
 * Scripts to change the cursor to a resize cursor when mousing over the
 * navigation/workarea frame border.  Only necessary in IE.
 *
 * Module History:
 * 02/12/2007  J. Miller    Initial Release
 * 03/22/2007  J. Miller    use offsetWidth for E direction - in case scrollbar is present
 *                          ignore event if not on BODY or inner/outer DIV tag
 */

var userAgent = navigator.userAgent.toLowerCase();
var isIE = ( userAgent.indexOf( "msie" ) != -1 ) && (!(( navigator.userAgent.indexOf("Opera") !=-1 ) && ( navigator.userAgent.indexOf("MSIE") !=-1)));

//navOnMouseMove
//onmousemove method to change the cursor to a resize cursor when near the eastern
//or western edge of the frame
// -in: cardDir - [east|west] - side of the frame upon which the resize cursor should be used
//-out: none, cursor changed to resize cursor when appropriate
function navOnMouseMove(cardDir) {
    if ( !isIE ) {
        return;
    }

    //only care about body tag or inner/outer div events (prevents resize cursor
    //from appearing along all images/tables/etc, yet ensure it continues for the
    //height of the page)
    var tagName = window.event.srcElement.tagName;
    var parentTagName = window.event.srcElement.parentNode.tagName;
    if ( tagName != 'BODY' && parentTagName != 'BODY' ) {
        return;
    }

    var cd = cardDir.toUpperCase().substr(0,1);
    if ( cd == "E" ) {
        var x = window.event.offsetX;
        if ( x >= window.top.hmcmainui.navigation_frame.document.body.offsetWidth - 2 ) {
            document.body.style.cursor = "e-resize";
        } else {
            document.body.style.cursor = "";
        }
    } else if ( cd == "W" ) {
        var x = window.event.offsetX;
        if ( x <= 0 ) {
            document.body.style.cursor = "w-resize";
        } else {
            document.body.style.cursor = "";
        }
    }
}


//navOnMouseOut
//onmouseout method to clear the cursor when leaving the page
// -in: none
//-out: none, cursor reset
function navOnMouseOut() {
    document.body.style.cursor = "";
}

