/*
 * (c)  Copyright  IBM Corp.  1999, 2003  All Rights Reserved
 *
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp
 *
 * Notes:
 * js file used to prevent drag-and-drop actions within a page
 *
 * Module History:
 * 11/10/2005  JMiller      Initial Release
 * 03/20/2007  JMiller      prevent escape key from propagating to task controller queue frame
 */

//prevent image dragging -------------------------------------------------------
//IE
document.ondragstart = function(e) {
  return false;
}

//Mozilla
document.onmousedown = function(e) {
  if ( e && e.preventDefault ) {
    var target = e.target;
    if ( target.nodeName.toUpperCase() == "IMG" ) {
      e.preventDefault();
      return false;
    }
    while (target) {
      if (target.nodeName.toUpperCase() == "A") {
        e.preventDefault();
        return false;
      }
      target = target.parentNode;
    }
  }
}


//register bonsai key handler (to trap escape key) -----------------------------
document.onkeydown  = bonsaiKeyHandler;
document.onkeypress = bonsaiKeyHandler;
document.onkeyup    = bonsaiKeyHandler;


//bonsaiKeyHandler
//Tree Style UI onkeydown/press/up Handler - prevent escape key from propagating
// -in: the Event object
//-out: none
function bonsaiKeyHandler(event) {
    var keyCode = (event) ? event.which : window.event.keyCode;
    if (!event) {
        event = window.event;
    }

    var rc = true;
    switch (keyCode) {
        case 27:
            //escape key
            rc = false;
        break;
    }
    
    if ( !rc ) {
        stopEvent(event);
    }
    
    return rc;
}


//stopEvent
//Try to prevent others from seeing the event.
// -in: the Event object
//-out: none
function stopEvent(event)
{
    // Don't allow others to see the event.
    if (isBrowserInternetExplorer()) {
        event.cancelBubble = true;    // IE
    } else if (event.stopPropogation) {
        event.stopPropogation();      // DOM 2
    }

   // Don't allow the event's default action to occur.
   if (event.preventDefault)
      event.preventDefault();       // DOM 2

   if (event.returnValue)
      event.returnValue = false;    // IE

   return false;
}

//isBrowserInternetExplorer
//return true if browser is internet explorer
// -in: none
//-out: true is browser identified as IE 
function isBrowserInternetExplorer() {
    var userAgent  = navigator.userAgent.toLowerCase();
    return ( userAgent.indexOf( "msie" ) != -1 ) && (!(( userAgent.indexOf("Opera") !=-1 ) && ( userAgent.indexOf("MSIE") !=-1)));
}

