/*********************************************************** {COPYRIGHT-TOP} ***
* Licensed materials - Property of IBM
*
* (C) Copyright IBM Corp. 2006
*
* US Government Users Restricted Rights - Use, duplication, or
* disclosure restricted by GSA ADP Schedule Contract with
* IBM Corp.
*
* Javascript methods to reopen a wcl popup menu or menu button after a refresh
*
* Module History:
*     10/20/2006   JMiller        Initial Release
*     11/08/2006   JMiller        remove debug code
************************************************************ {COPYRIGHT-END} ****/

var BONSAI_OPENED_MENU_PATH = "bonsaiOpenedMenuPath";   //name of cookie which stores the opened menu's path

var opening_ = false;   //true if a menu is being opened by automation, false otherwise (ignore listener events while automation is ongoing)

var userAgent = navigator.userAgent.toLowerCase();
var isIE = ( userAgent.indexOf( "msie" ) != -1 ) && (!(( navigator.userAgent.indexOf("Opera") !=-1 ) && ( navigator.userAgent.indexOf("MSIE") !=-1)));
var menus_ = null;   //used for IE, which has to open the menu path via a setTimeout call
var menu_  = null;   //used for IE, which has to re-enabled menu actions via a setTimeout call


// openMenu
//  -in: launcherId - id attribute of the dom element whose onclick launches the menu
//       i - attempt number
// -out: none
function openMenu(ctr) {
    opening_ = true;

    var menuPath = getCookie(BONSAI_OPENED_MENU_PATH);
    if ( menuPath == null || menuPath == "" ) {
        opening_ = false;
        return;
    }

    var menus = menuPath.split("->");
    var done = false;

    //open menu path
    var menuElem = document.getElementById(menus[0]);
    if ( menuElem != null ) {
        //open root menu
        var x = getLeft(menuElem, true);
        var y = getTop( menuElem, true);
        if ( x > 0 && y > 0 ) {
            x = x + 13;
            y = x - 12;
            done = openMenuHelper(menuElem, x, y);
        }

        //disable menu actions, required for IE, which will continue to throw
        //events on the menu items while the automation opens them
        if ( isIE ) {
            var menu = getContextMenuByText( menus[0] );
            disableMenuActions(menu);
        }

        //open submenus
        if ( done ) {
            if ( isIE ) {
                menus_ = menus;
                setTimeout("openSubmenuHelperIE(1)", 10);
            } else {
                openSubmenuHelper(menus, 1);
            }
        }
    }

    //if !done, retry up to 5 timres (needed for IE, which takes its time loading the menu button)
    //otherwise clear the opening_ semaphore
    if ( ctr == null ) ctr = 1;
    if ( !done && ctr < 5 ) {
        ctr = ctr + 1;
        setTimeout("openMenu(" + ctr + ")", 250);
    } else {
        setTimeout("setSemaphore(false)", 250);
    }
}


// setSemaphore - update the value of the opening_ semaphore
//  -in: value - true or false
// -out: none, opening_ value updated
function setSemaphore(value) {
    opening_ = value;
}


// openMenuHelper - create and fire an onclick event for the given node with the given x,y coordinates
//  -in: menu - dom element whose onclick launches the menu
//       x - x coordinate
//       y - y coordinate
// -out: true is the event was successfully created and fired, false otherwise
function openMenuHelper(menu, x, y) {
    try {
        if ( document.createEvent ) {
            var evt = document.createEvent('MouseEvents');
            evt.initMouseEvent('click', false, true, window, 1, x, y, x, y, false, false, false, false, 1, null);
            menu.dispatchEvent(evt);
        } else {
            var evt = document.createEventObject();
            evt.screenX = x;
            evt.screenY = y;
            evt.clientX = x;
            evt.clientY = y;
            menu.fireEvent('onclick', evt);
        }
    } catch (e) { 
        return false;
    }
    return true;
}


// openSubmenuHelper - open and select the given submenu
//  -in: submenu - javascript submenu object
// -out: none, submenu is opened and selected
function openSubmenuHelper(menus, index) {
    try { 
        var menu = null;
        for (var i = index; i < menus.length; i++) {
            menu = getContextMenuByText( menus[i] );
            if ( menu != null ) {
                try {
                    menu.show(menu.parentItem.anchorTag, menu.parentItem);
                    menu.parentItem.setSelected(true);
                    done = true;
                } catch (e) {
                    done = false;
                }
            }
        }
    } catch (e) {
    }
}


// openSubmenuHelperIE - open and select submenu_ in Internet Explorer
//  -in: none
// -out: none, submenu is opened and selected
function openSubmenuHelperIE(index) {
    if ( index < menus_.length ) {
        var submenu = getContextMenuByText( menus_[index] );
        if ( submenu == null ) return;

        submenu.show(submenu.parentItem.anchorTag, submenu.parentItem);
        submenu.parentItem.setSelected(true);

        setTimeout("openSubmenuHelperIE("+(index+1)+")", 250);
    } else {
        menu_ = getContextMenuByText( menus_[0] );
        setTimeout("enableMenuActions(menu_)", 250);
    }
}   


// menuListenerCallback - track menu openings/closings, saving the currently opened menu path in a cookie
//  -in: menu - menu object which triggered the event
//       event - event text string - MENU_SHOWN, MENU_HIDDEN, etc
// -out: none
function menuListenerCallback(menu, event) {
    if ( opening_ ) return;

    //we only care about MENU_SHOWN/HIDDEN events
    if ( event == 'MENU_SHOWN' || event == 'MENU_HIDDEN' ) {
        //build menu path string (working from current node up to the root)
        var menuPath = "";
        if ( event == 'MENU_SHOWN' ) {
            menuPath = menu.text;
        } else if ( isIE ) {
            //in IE MENU_HIDDEN events are sometimes received before MENU_SHOWN events, 
            //so only process MENU_HIDDEN events if the current cookie menu path
            //ends with the menu we're told was hidden
            var cookiePath = getCookie(BONSAI_OPENED_MENU_PATH);
            if ( cookiePath == null 
              || ( cookiePath != menu.text && cookiePath.length > menu.text.length && menu.text != cookiePath.substring(cookiePath.length-menu.text.length) ) )
            {
                return;
            }
        }

        //continue building menu path string (til we hit the root)
        var parentItem = menu.parentItem;
        while ( parentItem != null && parentItem.parentMenu != null ) {
            if ( menuPath == "" ) {
                menuPath = parentItem.parentMenu.text;
            } else {
                menuPath = parentItem.parentMenu.text + "->" + menuPath;
            }
            parentItem = parentItem.parentMenu.parentItem;
        }

        //set/clear cookie
        if ( menuPath == "" ) {
            deleteCookie(BONSAI_OPENED_MENU_PATH);
        } else {
            createCookie(BONSAI_OPENED_MENU_PATH, menuPath);
        }
    }
}


// getCookie - return the value stored in the document cookie for the given property name
//  -in: name - property name whose value should be returned
// -out: value of property name if found in cookie, null otherwise
function getCookie(name) {
    var nameEQ = name + "=";
    var nvps = document.cookie.split(';');
    for ( var i=0; i < nvps.length; i++ ) {
        var nvp = nvps[i];
        while ( nvp.charAt(0) == ' ' ) {
            nvp = nvp.substring(1,nvp.length);
        }
        if ( nvp.indexOf(nameEQ) == 0 ) {
            return nvp.substring(nameEQ.length,nvp.length);
        }
    }
    return null;
}


// createCookie - create a cookie with the given name/value to expire in <days> days
//  -in: name  - property name
//       value - property value
//       days  - number of days til the cookie expires
// -out: none, cookie created
function createCookie(name, value, days) {
    var expires = "";
    if ( days ) {
        var date = new Date();
        date.setTime(date.getTime()+(days*24*60*60*1000));
        expires = "; expires"+date.toGMTString();
    }
    document.cookie = name+"="+value+expires+"; path=/";
}


// deleteCookie - delete the cookie with the given name
//  -in: name  - property name
// -out: none, cookie deleted
function deleteCookie(name) {
    createCookie(name,"",-1);
}


// enableMenuActions - enable anchor/itemTag events for the given menu and its submenus/items
//  -in: menu - menu object
// -out: none, menu actions enabled
function enableMenuActions(menu) {
    if ( menu == null ) return;

    if ( menu.items != null && menu.items.length > 0 ) {
        for ( var i = 0; i < menu.items.length; i++ ) {
            enableMenuItemActions(menu.items[i]);
        }
    }

}


// enableMenuItemActions - enable anchor/itemTag events for the given menu item and its submenu
//  -in: item - menu item object
// -out: none, menu item actions enabled
function enableMenuItemActions(item) {
    if ( item == null ) return;

    if ( !item.isSeparator ) {
        if ( item.anchorTag ) {
            item.anchorTag.onfocus = menuItemFocus;
            item.anchorTag.onblur = menuItemBlur;
            item.anchorTag.onkeydown = menuItemKeyDown;
        }
        if ( item.itemTag ) {
            item.itemTag.onmousemove = menuItemMouseMove;
            item.itemTag.onmousedown = menuItemMouseDown;
        }

        if ( item.submenu != null ) {
            enableMenuActions(item.submenu);
        }
    }
}


// disableMenuActions - disable anchor/itemTag events for the given menu and its submenus/items
//  -in: menu - menu object
// -out: none, menu actions disabled
function disableMenuActions(menu) {
    if ( menu == null ) return;

    if ( menu.items != null && menu.items.length > 0 ) {
        for ( var i = 0; i < menu.items.length; i++ ) {
            disableMenuItemActions(menu.items[i]);
        }
    }
}


// disableMenuItemActions - disable anchor/itemTag events for the given menu item and its submenu
//  -in: item - menu item object
// -out: none, menu item actions disabled
function disableMenuItemActions(item) {
    if ( item == null ) return;

    if ( !item.isSeparator ) {
        if ( item.anchorTag ) {
            item.anchorTag.onfocus = function() { return true; };
            item.anchorTag.onblur = function() { return true; };
            item.anchorTag.onkeydown = function() { return true; };
        }

        if ( item.itemTag ) {
            item.itemTag.onmousemove = function() { return true; };
            item.itemTag.onmousedown = function() { return true; };
        }

        if ( item.submenu != null ) {
            disableMenuActions(item.submenu);
        }
    }
}
