/*********************************************************** {COPYRIGHT-TOP} ***
* Licensed Materials - Property of IBM
* Tivoli Presentation Services
*
* (C) Copyright IBM Corp. 2002, 2004  All Rights Reserved.
*
* US Government Users Restricted Rights - Use, duplication, or
* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
************************************************************ {COPYRIGHT-END} ***
* Change Activity on 4/29/03 version 1.13:
* @00=WCL, V3R0, 04/14/2002, JCP: Initial version
* @01=D96484, V3R2, 06/14/2002, bcourt: hide select/iframe elements
* @02=D99598, V3R2, 07/02/2002, JCP: IE6 has different body size than IE5
* @03=D104656, V3R3, 09/16/2002, JCP: form submit instead of triggers
* @04=D107029, V3R4, 12/03/2002, Mark Rebuck:  Added support for timed menu hiding
* @05=D113641, V3R4, 04/28/2003, LSR: Requirement #258 Shorten CSS Names
* @06=HMC            3/15/2005   EAW: Menu Hiding done with setTimeout instead of explicity onMouseDown
*                    04/26/2005       Position ContextMenu based on Event that triggered it
*                                         create ContextMenu using user's custom cssString, stored in the root MenuItem
*                    05/10/2005,      adjust posX by scrollLeft
*                                         if menuWidth is 0, check for valid width from menuTag's firstChild
*                    05/16/2005      ContextMenu initial selection fix, menu action triggers link action
*                    10/25/2005  JMiller  added ContextMenuHelper, a static object to notify if a menu is visible 
*                    10/26/2005  JMiller  disable menu timer when using keyboard navigation
*******************************************************************************/

var visibleMenu_ = null;
var padding_ = 10;
var menuVisible_ = false;
var MENU_TIMEOUT = 250;

var transImg_ = "transparent.gif";

var arrowNorm_ = "contextArrowDefault.gif";
var arrowSel_ = "contextArrowSelected.gif";
var arrowDis_ = "contextArrowDisabled.gif";
var launchNorm_ = "contextLauncherDefault.gif";
var launchSel_ = "contextLauncherSelected.gif";

var arrowNormRTL_ = "contextArrowDefault.gif";
var arrowSelRTL_ = "contextArrowSelected.gif";
var arrowDisRTL_ = "contextArrowDisabled.gif";
var launchNormRTL_ = "contextLauncherDefault.gif";
var launchSelRTL_ = "contextLauncherSelected.gif";

var arrowWidth_ = "12";
var arrowHeight_ = "12";

var submenuAltText_ = "+";
var noActionsText_ = "(0)";

var hideCurrentMenuTimer_ = null;

function clearMenuTimer( ) {
   if (null != hideCurrentMenuTimer_) {
      clearTimeout( hideCurrentMenuTimer_ );
      hideCurrentMenuTimer_ = null;
   }
}

function setMenuTimer( ) {
   clearMenuTimer( );
  hideCurrentMenuTimer_ = setTimeout( 'hideCurrentContextMenu()', 1000); // @06
}

function debug( str ) {
   //opera.postError(str);
   /*
   if ( xbDEBUG != null ) {
      xbDEBUG.dump( str );
   }
   */
}

// constructor
function UilContextMenu( name, isLTR, width, cssString ) {
   // member variables
   this.name = name;
   this.items = new Array();
   this.isVisible = false;
   this.isDismissable = true;
   this.selectedItem = null;
   this.isDynamic = false;
   this.isCacheable = false;
   this.isEmpty = true;
   this.isLTR = isLTR;
   this.hiddenItems = new Array(); //@01A
   this.isHyperlinkChild = true;  //  We will reset later if needed.
   this.listeners = new Array();
   this.cssStyles = new CssStyles(cssString);   //user-defined custom CSS for this WPopupMenu
   this.rootItem = null;    //this is the rootItem in the ContextMenu, children will use this cssStyles object

   // html variables
   this.launcher = null;
   this.menuTag = null;

   // external methods
   this.add = UilContextMenuAdd;
   this.addSeparator = UilContextMenuAddSeparator;
   this.show = UilContextMenuShow;
   this.hide = UilContextMenuHide;
   this.addListener = UilContextMenuAddListener;

   // internal methods
   this.create = UilContextMenuCreate;
   this.destroy = UilContextMenuDestroy;
   this.getMenuItem = UilContextMenuGetMenuItem;
   this.getSelectedItem = UilContextMenuGetSelectedItem;
   this.notifyListeners = UilContextMenuNotifyListeners;

   if ( this.name == null ) {
      this.name = "UilContextMenu_" + allMenus_.length;
   }
}

// adds a menu item to the context menu
function UilContextMenuAdd( item ) {
   this.items[ this.items.length ] = item;
   this.isEmpty = false;
   //set rootItem for child to add
   if ( this.rootItem == null ) {
      item.rootItem = this;           //direct descendant of rootItem
   } else {
      item.rootItem = this.rootItem;  //indirect descendant of rootItem
   }
}

function UilContextMenuAddSeparator() {
   var sep = new UilMenuItem();
   sep.isSeparator = true;
   this.add( sep );
}

// shows the context menu
// launcher- html element (anchor) that is launching the menu
// launchItem- menu item that is launching the menu
function UilContextMenuShow( launcher, launchItem ) {
   if ( this.items.length == 0 ) {
      // empty context menu
      debug( 'menu is empty!' );
      this.add( new UilMenuItem( noActionsText_, false, "javascript:void(0);" ) );
      this.isEmpty = true;
   }

   if ( this.menuTag == null ) {
      // create the context menu html
      this.create();
   }

   if ( this.menuTag != null) {
      // store the launcher for later
      this.launcher = launcher;
      if ( this.launcher.tagName == "IMG" ) {
         this.isHyperlinkChild = false;

         // we want the anchor tag
         this.launcher = this.launcher.parentElement;
      }

      // boundaries of window
      // @02 - minor difference between IE5 and IE6 to determine available space
      var maxX = document.documentElement.scrollLeft + document.documentElement.clientWidth;
      var maxY = document.documentElement.scrollTop + document.documentElement.clientHeight;
      var maxX2 = document.body.scrollLeft + document.body.clientWidth;
      var maxY2 = document.body.scrollTop + document.body.clientHeight;
      if ( maxX2 > maxX ) maxX = maxX2;
      if ( maxY2 > maxY ) maxY = maxY2;
      var menuWidth = getWidth( this.menuTag );
      var menuHeight = getHeight( this.menuTag );
      //if menuTag's width is 0, check its firstChild for a real width
      if ( menuWidth == 0 && this.menuTag.firstChild != null ) {
         menuWidth = getWidth( this.menuTag.firstChild );
      }

      // move the context menu to the right of the launcher
      var posX = 0;
      var posY = 0;
      if ( launchItem != null ) {
         // launched from submenu
         var launchTag = launchItem.itemTag;
         var launchTagWidth = getWidth( launchTag );
         var parentTag = launchItem.parentMenu.menuTag;
         var parentOffsetX = getLeft( parentTag );
         var parentOffsetY = getTop( parentTag );

         posX = parentOffsetX + getLeft( launchTag ) + launchTagWidth - document.documentElement.scrollLeft;
         posY = parentOffsetY + getTop( launchTag );

         if ( !this.isLTR ) {
            posX -= launchTagWidth;
            posX -= menuWidth;
         }

         // try to keep it in the window
         if ( this.isLTR ) {
            if ( posX + menuWidth > maxX ) {
               // try to show it to the left of the parent menu
               var posX1 = parentOffsetX - menuWidth;
               var posX2 = maxX - menuWidth;
               if ( 0 <= posX1 ) {
                  posX = posX1;
               }
               else {
                  posX = Math.max( 0, posX2 );
               }
            }
         }
         else {
            if ( posX < 0 ) {
               // try to show it to the right of the parent menu
               var posX1 = parentOffsetX + getWidth( parentTag );
               if ( posX1 + menuWidth < maxX ) {
                  posX = posX1;
               }
               else {
                  posX = Math.min( 0, maxX - menuWidth );
               }
            }
         }

         if ( posY + menuHeight > maxY ) {
            var posY1 = maxY - menuHeight;
            posY = Math.max( 0, posY1 );
         }
      }
      else {
         // launched from menu link
         var launcherLeft = getLeft( this.launcher, true );
         posX = launcherLeft + this.launcher.offsetWidth;
         posY = (this.event == null) ? getTop( this.launcher.offsetParent, true ) : this.event.pageY;

         if ( !this.isLTR ) {
            posX -= this.launcher.offsetWidth;
            posX -= menuWidth;
         }

         // keep it in the window
         if ( this.isLTR ) {
            if ( posX + menuWidth > maxX ) {
               // try to show it on the left side of the launcher
               var posX1 = launcherLeft - menuWidth;
               if ( posX1 > 0 ) {
                  posX = posX1;
               }
               else {
                  posX = Math.max( 0, maxX - menuWidth );
               }
            }
         }
         else {
            if ( posX < 0 ) {
               // try to show it on the right side of the launcher
               var posX1 = launcherLeft + this.launcher.offsetWidth;
               if ( posX1 + menuWidth < maxX ) {
                  posX = posX1;
               }
               else {
                  posX = Math.min( 0, maxX - menuWidth );
               }
            }
         }

         if ( posY + menuHeight > maxY ) {
            posY = Math.max( 0, maxY - menuHeight );
         }
      }

      this.isVisible = true;

      //set focus on the first menu item
      //moved before visibility/pos changes to fix timing issue with downstream
      //select and style changes to allow out of the gate keyboard navigation of menu
      if ( this.items != null && this.items.length > 0 && this.items[0].anchorTag != null )
      {
         this.items[0].anchorTag.focus();
         this.items[0].anchorTag.onfocus();
         this.items[0].setSelected(true);
      }

      debug( 'show ' + this.name + ': ' + posX + ', ' + posY );
      this.menuTag.style.left = posX + "px";
      this.menuTag.style.top = posY + "px";
      this.menuTag.style.zIndex = 900;

      // make the context menu visible
      this.menuTag.style.visibility = "visible";

      // @01A - Hide any items that intersect this menu
      var coll = document.getElementsByTagName("SELECT");
      if (coll!=null)
      {
         for (i=0; i<coll.length; i++)
         {
            //Hide the element
            if (intersect(this.menuTag,coll[i]) == true ) {
               if (coll[i].style.visibility != "hidden")
               {
                  coll[i].style.visibility = "hidden";
                  this.hiddenItems.push(coll[i]);
               }
            }
         }
      }
      coll = document.getElementsByTagName("IFRAME");
      if (coll!=null)
      {
         for (i=0; i<coll.length; i++)
         {
            //Hide the element
            if (intersect(this.menuTag,coll[i]) == true ) {
               if (coll[i].style.visibility != "hidden")
               {
                  coll[i].style.visibility = "hidden";
                  this.hiddenItems.push(coll[i]);
               }
            }
         }
      }
   }
   // notify listeners
   this.notifyListeners( "MENU_SHOWN" );
}

/**
 * Add menu listener
 *
 * @param listener Callback function that will be called as follows
 *        when a menu event occurs:
 *          listener( menu, event )
 *        where menu is this instance of UilContextMenu and event
 *        is one of the following Strings:
 *          MENU_CREATED
 *          MENU_SHOWN
 *          MENU_HIDDEN
 *          MENU_DESTROYED
 */
function UilContextMenuAddListener( listener )
{
    if ( this.listeners == null )
    {
        this.listeners = new Array();
    }
    this.listeners[ this.listeners.length ] = listener;
}

/**
 * Internal method for notifying menu listeners
 */
function UilContextMenuNotifyListeners( event )
{
    if ( this.listeners != null )
    {
        for ( var i = 0; i < this.listeners.length; i++ )
        {
            var listener = this.listeners[ i ];
            listener( this, event );
        }
    }
}

// Test whether two objects overlap
function intersect(obj1, obj2) //@01A
{
   var left1 =  parseInt(document.defaultView.getComputedStyle(obj1, '').getPropertyValue("left"));
   var right1 = left1 + parseInt(document.defaultView.getComputedStyle(obj1, '').getPropertyValue("width"));
   var top1 = parseInt(document.defaultView.getComputedStyle(obj1, '').getPropertyValue("top"));
   var bottom1 = top1 + parseInt(document.defaultView.getComputedStyle(obj1, '').getPropertyValue("height"));

   var left2 =  parseInt(document.defaultView.getComputedStyle(obj2, '').getPropertyValue("left"));
   var right2 = left2 + parseInt(document.defaultView.getComputedStyle(obj2, '').getPropertyValue("width"));
   var top2 = parseInt(document.defaultView.getComputedStyle(obj2, '').getPropertyValue("top"));
   var bottom2 = top2 + parseInt(document.defaultView.getComputedStyle(obj2, '').getPropertyValue("height"));

    //debug("Comparing: " +left1 + ", " + right1+ ", " +top1 + ", " + bottom1+ " to "  +left2 + ", "  +right2 + ", " +top2 + ", " +bottom2);
   if (lineIntersect(left1,right1, left2,right2)== true &&
       lineIntersect(top1,bottom1,top2,bottom2) == true) {
      return true;
   }

   return false;
}

// Test whether the two line segments a--b and c--d intersect.
function lineIntersect(a, b, c, d) //@01A
{
   //debug (a+"--"+b + "   " + c + "--" + d);
   //Assume that a < b && c < d
   if ( (a <= c  && c <= b) ||
        (a <= d && d <= b) ||
        (c <= a && d >= b ) )
   {
      return true;
   } else {
      return false;
   }
}

// hides the context menu
function UilContextMenuHide() {
   if ( this.menuTag != null ) {
      debug( 'hide ' + this.name );

      // hide any visible submenus first
      for ( var i=0; i<this.items.length; i++ ) {
         if ( this.items[i].submenu != null &&
              this.items[i].submenu.isVisible ) {
            this.items[i].submenu.hide();
         }
      }

      // clear selection
      if ( this.selectedItem != null ) {
         this.selectedItem.setSelected( false );
      }

      // make the context menu hidden
      this.menuTag.style.visibility = "hidden";
      this.isVisible = false;
      this.isDismissable = true;

      // @01A - Show any items that were hidden by this menu
      var itemCount = this.hiddenItems.length;
      for (i=0; i<itemCount; i++)
      {
         var item = this.hiddenItems.pop();
         item.style.visibility = "visible";
      }

      // clear the launcher
      this.launcher = null;
      // notify listeners
      this.notifyListeners( "MENU_HIDDEN" );
   }
}

// creates the context menu html element
function UilContextMenuCreate( recurse ) {
   if ( this.menuTag == null ) {
      this.menuTag = document.createElement( "DIV" );
      this.menuTag.style.position = "absolute";
      this.menuTag.style.cursor = "default";
      this.menuTag.style.visibility = "hidden";
      this.menuTag.style.width = "0px"; // this causes dynamic sizing
      this.menuTag.onmouseover = contextMenuDismissDisable;
      this.menuTag.onmouseout = contextMenuDismissEnable;
      this.menuTag.oncontextmenu = contextMenuOnContextMenu;

      var numItems = this.items.length;

      // check if this context menu contains icons or submenus
      var hasIcon = false;
      var hasSubmenu = false;
      for ( var i=0; i<numItems; i++ ) {
         if ( !this.items[i].isSeparator ) {
            if ( !hasSubmenu && this.items[i].submenu != null ) {
               hasSubmenu = true;
            }
            if ( !hasIcon && this.items[i].icon != null ) {
               hasIcon = true;
            }
            if ( hasSubmenu && hasIcon ) {
               break;
            }
         }
      }

      // create the menu items
      for ( var i=0; i<numItems; i++ ) {
         this.items[i].isFirst = ( i == 0 );
         this.items[i].isLast = ( i+1 == numItems );
         this.items[i].parentMenu = this;
         this.items[i].create( hasIcon, hasSubmenu );
      }

      // create the context menu border
      var border = document.createElement( "TABLE" );
      if (!this.isLTR) border.dir = "RTL";
      border.className = "pop2"; //@05C1
      border.rules = "none";
      border.cellPadding = 0;
      border.cellSpacing = 0;
      border.width = "100%";
      border.border = 0;
      var borderBody = document.createElement( "TBODY" );
      var borderRow = document.createElement( "TR" );
      var borderData = document.createElement( "TD" );
      borderRow.appendChild( borderData );
      borderBody.appendChild( borderRow );
      border.appendChild( borderBody );

      // create the context menu
      var table = document.createElement( "TABLE" );
      if (!this.isLTR) table.dir = "RTL";
      table.className = "pop1";  //@05C1
      table.rules = "none";
      table.cellPadding = 3;
      table.cellSpacing = 0;
      table.width = "100%";
      table.border = 0;

      // add the menu items
      var tableBody = document.createElement( "TBODY" );
      table.appendChild( tableBody );
      for ( var i=0; i<numItems; i++ ) {
         if ( this.items[i].isSeparator ) {
            this.items[i].createSeparator( tableBody, hasSubmenu );
         }
         else {
            tableBody.appendChild( this.items[i].itemTag );
         }
      }
      borderData.appendChild( table );
      this.menuTag.appendChild( border );

      // add to document
      document.body.appendChild( this.menuTag );
   }

   if ( recurse ) {
      // this is used when cloning dynamic menus
      for ( var i=0; i<this.items.length; i++ ) {
         if ( this.items[i].submenu != null ) {
            this.items[i].submenu.create( recurse );
         }
      }
   }
   // notify listeners
   this.notifyListeners( "MENU_CREATED" );
}

// destroy context menu
function UilContextMenuDestroy()
{
    // clear selection
    if ( this.selectedItem != null )
    {
       this.selectedItem.setSelected( false );
    }
    // clear the launcher
    this.launcher = null;
    // clear items
    this.items = new Array();
    this.isEmpty = true;
    // destroy HTMLElements
    if ( this.menuTag != null )
    {
        document.body.removeChild( this.menuTag );
        this.menuTag = null;
    }
    // notify listeners
    this.notifyListeners( "MENU_DESTROYED" );
}

// returns the menu item object associated with the html element
function UilContextMenuGetMenuItem( htmlElement ) {
   if ( htmlElement != null ) {
      for ( var i=0; i<this.items.length; i++ ) {
         if ( this.items[i].itemTag != null &&
              this.items[i].itemTag.contains( htmlElement ) ) {
            // found the item
            return this.items[i];
         }
         else if ( this.items[i].submenu != null &&
                   this.items[i].submenu.isVisible ) {
            // recurse through any visible submenus
            var item = this.items[i].submenu.getMenuItem( htmlElement );
            if ( item != null ) {
               // found the item
               return item;
            }
         }
      }
   }
   return null;
}

// returns the deepest selected menu item
function UilContextMenuGetSelectedItem() {
   var item = this.selectedItem;
   if ( item != null && item.submenu != null && item.submenu.isVisible ) {
      // recurse through the item's visible submenu
      return item.submenu.getSelectedItem();
   }
   return item;
}

// method called by an event handler (onmouseover for context menu div)
function contextMenuDismissEnable() {
   if ( visibleMenu_ != null ) {
      visibleMenu_.isDismissable = true;
     // if (visibleMenu_.isHyperlinkChild) {
      //    alert("setting timer");
         setMenuTimer( );
     // }
   }
}

// method called by an event handler (onmouseout for context menu div)
function contextMenuDismissDisable() {
   if ( visibleMenu_ != null ) {
      visibleMenu_.isDismissable = false;
      clearMenuTimer( );
   }
}

// method called by an event handler (oncontextmenu for context menu div)
function contextMenuOnContextMenu() {
   return false;
}

// constructor
function UilMenuItem( text, enabled, action, clientAction, submenu, icon, defItem ) {
   // member variables
   this.text = text;
   this.icon = icon;
   this.action = action;
   this.clientAction = clientAction;
   this.submenu = submenu;
   this.isSeparator = false;
   this.isSelected = false;
   this.isEnabled = ( enabled != null ) ? enabled : true;
   this.isDefault = ( defItem != null ) ? defItem : false;
   this.isFirst = false;
   this.isLast = false;
   this.parentMenu = null;
   this.rootItem = null;    //rootItem of the ContextMenu, use its cssStyles object; set by UilContextMenu.add

   // html variables
   this.itemTag = null;
   this.anchorTag = null;
   this.arrowTag = null;

   // internal methods
   this.create = UilMenuItemCreate;
   this.createSeparator = UilMenuItemCreateSeparator;
   this.setSelected = UilMenuItemSetSelected;
   this.updateStyle = UilMenuItemUpdateStyle;
   this.getNextItem = UilMenuItemGetNextItem;
   this.getPrevItem = UilMenuItemGetPrevItem;
   this.getFirstItem = UilMenuItemGetFirstItem;
   this.getLastItem  = UilMenuItemGetLastItem;

   if ( this.submenu != null ) {
      // menu items with submenus do not have actions
      this.action = null;
   }
}

// creates the menu item html element
function UilMenuItemCreate( menuHasIcon, menuHasSubmenu ) {
   if ( !this.isSeparator ) {
      this.anchorTag = document.createElement( "A" );
      if ( this.action != null ) {
         this.anchorTag.href = "javascript:menuItemLaunchAction();";
         if ( this.clientAction != null ) {
             this.anchorTag.onclick = null;//this.clientAction;
         }
      }
      else if ( this.submenu != null ) {
         this.anchorTag.href = "javascript:void(0);";
         this.anchorTag.onclick = menuItemShowSubmenu;
      }
      else if ( this.clientAction != null ) {
         this.anchorTag.href = "javascript:menuItemLaunchAction();";
         this.anchorTag.onclick = null;//this.clientAction;
      }
      this.anchorTag.onfocus = menuItemFocus;
      this.anchorTag.onblur = menuItemBlur;
      this.anchorTag.onkeydown = menuItemKeyDown;
      this.anchorTag.innerHTML = this.text;
      this.anchorTag.className = "pop5";   //@05C1
      //this.anchorTag.hideFocus = true;
      if ( this.isDefault ) {
         this.anchorTag.style.fontWeight = "bold";
      }

      var td = document.createElement( "TD" );
      td.noWrap = true;
      td.appendChild( this.anchorTag );

      // left padding or icon
      var leftPad = document.createElement( "TD" );
      leftPad.noWrap = true;
      if ( this.icon != null ) {
         var imgTag = document.createElement( "IMG" );
         imgTag.src = this.icon;
         if ( this.text != null ) {
            imgTag.alt = this.text;
            imgTag.title = this.text;
         }
         leftPad.appendChild( imgTag );
      }
      else {
         leftPad.width = padding_;
      }

      // right padding
      var rightPad = document.createElement( "TD" );
      rightPad.noWrap = true;
      rightPad.width = padding_;

      this.itemTag = document.createElement( "TR" );
      this.itemTag.onmousemove = menuItemMouseMove;
      this.itemTag.onmousedown = menuItemMouseDown;
      this.itemTag.className = "pop5";  //@05C1

      // put together the table row
      this.itemTag.appendChild( leftPad );
      this.itemTag.appendChild( td );
      this.itemTag.appendChild( rightPad );
      if ( menuHasSubmenu ) {
         // submenu arrow
         var submenuArrow = document.createElement( "TD" );
         submenuArrow.noWrap = true;
         if ( this.submenu != null ) {
            var submenuImg = document.createElement( "IMG" );
            submenuImg.alt = submenuAltText_;
            submenuImg.title = submenuAltText_;
            submenuImg.width = arrowWidth_;
            submenuImg.height = arrowHeight_;
            if (this.parentMenu.isLTR) submenuImg.src = arrowNorm_;
            else submenuImg.src = arrowNormRTL_;
            submenuArrow.appendChild( submenuImg );
            this.arrowTag = submenuImg;
         }
         this.itemTag.appendChild( submenuArrow );
      }

      // update the style of the menu item
      this.updateStyle( this.itemTag );
   }
}

// create the context menu separator html elements
function UilMenuItemCreateSeparator( tableBody, menuHasSubmenu ) {
   // create the context menu separator
   var numCols = ( menuHasSubmenu ) ? 4 : 3;

   for ( var i=0; i<4; i++ ) {
      var tr = document.createElement( "TR" );
      if ( i == 1 ) {
         tr.className = "pop3";    //@05C1
      }
      else if ( i == 2 ) {
         tr.className = "pop4";  //@05C1
      }
      else {
         tr.className = "pop5";  //@05C1
      }

      var td = document.createElement( "TD" );
      td.noWrap = true;
      td.width = "0";    //@pchin
      td.colSpan = numCols;

      tr.appendChild( td );
      tableBody.appendChild( tr );
   }
}

// changes the selected state for menu item
function UilMenuItemSetSelected( isSelected ) {
   if ( isSelected && !this.isSelected ) {
      debug( 'selected: ' + this.text );
      // handle the previous selection first
      if ( this.parentMenu != null &&
           this.parentMenu.isVisible &&
           this.parentMenu.selectedItem != null &&
           this.parentMenu.selectedItem != this ) {
         // hide previous selection's submenu
         if ( this.parentMenu.selectedItem.submenu != null ) {
            this.parentMenu.selectedItem.submenu.hide();
         }
         // unselect previous selection from parent menu
         this.parentMenu.selectedItem.setSelected( false );
      }

      // select this menu item
      this.isSelected = true;
      if ( this.parentMenu != null && this.parentMenu.isVisible ) {
         this.parentMenu.selectedItem = this;
      }

      // update the styles
      this.updateStyle( this.itemTag );
   }
   else if ( !isSelected && this.isSelected ) {
      // menu item cannot be unselected if its submenu is visible
      if ( this.submenu == null || ( this.submenu != null && !this.submenu.isVisible ) ) {
         // unselect this menu item
         this.isSelected = false;
         if ( this.parentmenu != null ) {
            this.parentmenu.selectedItem = null;
         }

         // update the styles
         this.updateStyle( this.itemTag );
      }
   }
}

// recursively set the style of the menu item html element
function UilMenuItemUpdateStyle( tag, styleID ) {
   if ( tag != null ) {
      if ( styleID == null ) {
         styleID = "pop5";   //@05C1
         if ( !this.isEnabled ) {
            styleID = "pop7";    //@05C1
         }
         else if ( this.isSelected ) {
            styleID = "pop6";  //@05C1
         }
         if ( this.arrowTag != null ) {
            if ( this.isEnabled && this.isSelected ) {
               if (this.parentMenu.isLTR) this.arrowTag.src = arrowSel_;
               else this.arrowTag.src = arrowSelRTL_;
            }
            else if ( !this.isEnabled ) {
               if (this.parentMenu.isLTR) this.arrowTag.src = arrowDis_;
               else this.arrowTag.src = arrowDisRTL_;
            }
            else {
               if (this.parentMenu.isLTR) this.arrowTag.src = arrowNorm_;
               else this.arrowTag.src = arrowNormRTL_;
            }
         }
      }
      tag.className = styleID;
      this.rootItem.cssStyles.setStyles(this.anchorTag,styleID); //attach custom CSS to anchorTag
      if ( tag.children != null ) {
         for ( var i=0; i<tag.children.length; i++ ) {
            this.updateStyle( tag.children[i], styleID );
         }
      }
   }
}

// returns the next enabled, non-separator menu item after the given item
function UilMenuItemGetNextItem() {
   var menu = this.parentMenu;
   if ( menu != null ) {
      for ( var i=0; i<menu.items.length; i++ ) {
         if ( menu.items[i] == this ) {
            for ( var j=i+1; j<menu.items.length; j++ ) {
               if ( !menu.items[j].isSeparator && menu.items[j].isEnabled ) {
                  return menu.items[j];
               }
            }
            // no next item
            return null;
         }
      }
   }
   return null;
}

// returns the previous enabled, non-separator menu item before the given item
function UilMenuItemGetPrevItem() {
   var menu = this.parentMenu;
   if ( menu != null ) {
      for ( var i=menu.items.length-1; i>=0; i-- ) {
         if ( menu.items[i] == this ) {
            for ( var j=i-1; j>=0; j-- ) {
               if ( !menu.items[j].isSeparator && menu.items[j].isEnabled ) {
                  return menu.items[j];
               }
            }
            // no previous item
            return null;
         }
      }
   }
   return null;
}

// returns the first enabled, non-separator menu item after the given item
function UilMenuItemGetFirstItem() {
   var menu = this.parentMenu;
   if ( menu != null ) {
      for ( var i=0; i<menu.items.length; i++ ) {
         if ( !menu.items[i].isSeparator && menu.items[i].isEnabled ) {
            return menu.items[i];
         }
      }
   }
   return null;
}

// returns the last enabled, non-separator menu item before the given item
function UilMenuItemGetLastItem() {
   var menu = this.parentMenu;
   if ( menu != null ) {
      for ( var i=menu.items.length-1; i>=0; i-- ) {
         if ( !menu.items[i].isSeparator && menu.items[i].isEnabled ) {
            return menu.items[i];
         }
      }
   }
   return null;
}

// launches the action for a menu item
// method called by an event handler (href for anchor tag)
function menuItemLaunchAction() {
   debug("menuitemlaunchaction");
   if ( visibleMenu_ != null ) {
      //var evt = window.event;
      //var item = visibleMenu_.getMenuItem( evt.srcElement );
       debug(" menuitemlaunchaction visibleMenu_ *not* null");
      var item = visibleMenu_.getSelectedItem();
      if ( item != null && item.isEnabled ) {
         hideCurrentContextMenu( true );
         if ( item.clientAction != null ) {
            eval( item.clientAction );
         }
         if ( item.action != null ) {
            if ( item.action.indexOf( "javascript:" ) == 0 ) {
               eval( item.action );
            }
            else {
               //window.location.href = item.action; //@03D
            }
         }
      }
   }
}

// shows the submenu for a menu item
// method called by an event handler (onclick for anchor tag)
function menuItemShowSubmenu() {
   if ( visibleMenu_ != null ) {
      var evt = window.event;
      var item = visibleMenu_.getMenuItem( evt.srcElement );
      if ( item != null && item.isEnabled ) {
         var menu = item.submenu;
         if ( menu != null ) {
            menu.show( item.anchorTag, item );
         }
      }
   }
}

// focus handler for menu item
// method called by an event handler (onfocus for anchor tag)
function menuItemFocus() {
   if ( visibleMenu_ != null ) {
      var evt = window.event;
      var item = visibleMenu_.getMenuItem( this );//evt.srcElement );
      if ( item != null ) {
         // select the focused menu item
         //item.anchorTag.hideFocus = item.isEnabled;
         item.setSelected( true );
      }
   }
}

// blur handler for menu item
// method called by an event handler (onblur for anchor tag)
function menuItemBlur() {
   if ( visibleMenu_ != null ) {
      var evt = window.event;
      var item = visibleMenu_.getMenuItem( evt.srcElement );
      if ( item != null ) {
         if ( item.isFirst && evt.shiftKey ) {
            // user is shift tabbing off the beginning of the menu
            // set focus on the launcher
            item.parentMenu.launcher.focus();
            item.parentMenu.launcher.onfocus();
            // hide the menu
            item.parentMenu.hide();
         }
      }
   }
}

// key press handler for menu item
// method called by an event handler (onkeydown for anchor tag)
function menuItemKeyDown() {
   contextMenuDismissDisable();
   debug( 'menuitem keydown' );
   var item = null;
   if ( visibleMenu_ != null ) {
      var evt = window.event;
      item = visibleMenu_.getMenuItem( evt.srcElement );
   }
   if ( item != null ) {
      var next = null;
      switch ( evt.keyCode ) {
      case 38: // up key
         next = item.getPrevItem();
         var last = item.getLastItem();
         if ( next != null ) {
            next.anchorTag.focus();
            next.anchorTag.onfocus();
         }
         else if ( last != null ) {
           last.anchorTag.focus();
           last.anchorTag.onfocus();
         }
         else if ( item.parentMenu != visibleMenu_ ) {
            item.parentMenu.launcher.focus();
            item.parentMenu.launcher.onfocus();
            item.parentMenu.hide();
         }
         else {
            visibleMenu_.launcher.focus();
            hideCurrentContextMenu( true );
         }
         break;
      case 40: // down key
         next = item.getNextItem();
         var first = item.getFirstItem();
         if ( next != null ) {
            next.anchorTag.focus();
            next.anchorTag.onfocus();
         }
         else if ( first != null ) {
           first.anchorTag.focus();
           first.anchorTag.onfocus();
         }
         else if ( item.parentMenu != visibleMenu_ ) {
            item.parentMenu.launcher.focus();
            item.parentMenu.launcher.onfocus();
            item.parentMenu.hide();
         }
         else {
            visibleMenu_.launcher.focus();
            hideCurrentContextMenu( true );
         }
         break;
      case 39: // right key
         if ( visibleMenu_.isLTR ) {
            if ( item.submenu != null ) {
               menuItemShowSubmenu(evt);
               item.submenu.items[0].anchorTag.focus();
               item.submenu.items[0].anchorTag.onfocus();
            }
         }
         else {
            if ( item.parentMenu != visibleMenu_ ) {
               item.parentMenu.launcher.focus();
               item.parentMenu.launcher.onfocus();
               item.parentMenu.hide();
            }
            else {
               visibleMenu_.launcher.focus();
               hideCurrentContextMenu( true );
            }
         }
         break;
      case 37: // left key
         if ( visibleMenu_.isLTR ) {
            if ( item.parentMenu != visibleMenu_ ) {
               item.parentMenu.launcher.focus();
               item.parentMenu.launcher.onfocus();
               item.parentMenu.hide();
            }
            else {
               visibleMenu_.launcher.focus();
               hideCurrentContextMenu( true );
            }
         }
         else {
            if ( item.submenu != null ) {
               menuItemShowSubmenu(evt);
               item.submenu.items[0].anchorTag.focus();
               item.submenu.items[0].anchorTag.onfocus();
            }
         }
         break;
      case 9: // tab key
         visibleMenu_.launcher.focus();
         hideCurrentContextMenu( true );
         break;
      case 27: // escape key
         visibleMenu_.launcher.focus();
         hideCurrentContextMenu( true );
         break;
      case 13: // enter key
         menuItemLaunchAction();
         break;
      default:
         break;
      }
   }
}

// handle mouse move for menu item
// method called by an event handler (onmousemove for item tag)
function menuItemMouseMove() {
   if ( visibleMenu_ != null ) {
      var evt = window.event;
      var item = visibleMenu_.getMenuItem( evt.srcElement );
      if ( item != null ) {
         if ( !item.isSelected ) {
            // set focus on the anchor and select the menu item
            item.anchorTag.focus();
            item.anchorTag.onfocus();
         }
         if ( item.submenu != null && !item.submenu.isVisible && item.isEnabled ) {
            // show the submenu
            item.submenu.show( item.anchorTag, item );
         }
      }
   }
}

// handle mouse down event for menu item
// method called by an event handler (onmousedown for item tag)
function menuItemMouseDown() {
    debug("mouseItemMouseDown");
   if ( visibleMenu_ != null ) {
      var evt = window.event;
      var item = visibleMenu_.getMenuItem( evt.srcElement );
      if ( item != null ) {
         item.setSelected( true );
         menuItemLaunchAction();
//         if ( item.anchorTag != evt.srcElement ) {
//            item.anchorTag.click();
//         }
      }
   }
}

document.onmousedown = hideCurrentContextMenu;  //uncommented to dismiss menu that never gains & loses focus

var allMenus_ = new Array();

function createContextMenu( name, isLTR, width, cssString ) {
   var menu = new UilContextMenu( name, isLTR, width, cssString );
   allMenus_[ allMenus_.length ] = menu;
   return menu;
}

function getContextMenu( name ) {
   for ( var i=0; i<allMenus_.length; i++ ) {
      if ( allMenus_[i].name == name ) {
         return allMenus_[i];
      }
   }
   return null;
}

function showContextMenu( name, isDynamic, isCacheable ) {
   contextMenuShow( name, isDynamic, isCacheable, window.event.srcElement, true );
   clearMenuTimer( );
}

function contextMenuShow( name, isDynamic, isCacheable, launcher, doLoad ) {
   debug( "***** showContextMenu: " + name )

   if ( eval( isDynamic ) ) {
      debug( 'showContextMenu: dynamic=true, load=' + eval( doLoad ) + ', cache=' + eval( isCacheable ) );
      // dynamically loaded menu
      if ( eval( doLoad ) ) {
         // load the url into hidden frame
         loadDynamicMenu( name );
      }

      // clone the dynamic menu from hidden frame
      menu = getDynamicMenu( name, eval( isCacheable ) );

      if ( menu == null && top.isContextMenuManager_ != null ) {
         // menu not done loading yet
         debug( 'showContextMenu: ' + name + ' added to queue' );
         top.contextMenuManagerRequest( name, window, launcher, isCacheable );
      }
   }
   else {
      debug( 'showContextMenu: static context menu' );
      // statically defined menu
      menu = getContextMenu( name );
      debug("menu = getContextMenu ( name ) name ="+name.toString()+"menu="+menu.toString());
      if ( menu == null ) {
         menu = createContextMenu( name, 150 );
         debug("createContextMenu menu="+menu.toString());
      }
   }

   if ( menu != null ) {
      hideCurrentContextMenu( true );
      menu.show( launcher );
      visibleMenu_ = menu;
      menuVisible_ = true;
      debug("visibleMenu_="+visibleMenu_.toString());
   }
   else {
      debug( 'showContextMenu: ' + name + ' unavailable' );
   }
}

// method called by an event handler (onmousedown for document)
function hideCurrentContextMenu( forceHide ) {

   if ( visibleMenu_ != null && ( forceHide || visibleMenu_.isDismissable ) ) {
      // alert("hideCurrentContextMenu VisibleMenu_"+visibleMenu_.toString());
      contextMenuDismissEnable();
      if ( visibleMenu_.isVisible ) {
         visibleMenu_.hide();
      }
      if ( visibleMenu_.isDynamic && !visibleMenu_.isCacheable ) {
         uncacheContextMenu( visibleMenu_ );
      }
     visibleMenu_ = null;
      setTimeout( 'clearCurrentContextMenu( )', MENU_TIMEOUT );
   }
}

function clearCurrentContextMenu() {
    //if visibleMenu_ is still null, its safe to say no menu is visible
    if ( visibleMenu_ == null ) {
        menuVisible_ = false;
    }
}

function uncacheContextMenu( menu ) {
   debug( 'uncache menu: ' + menu.name );
   // recurse
   for ( var i=0; i<menu.items.length; i++ ) {
      if ( menu.items[i].submenu != null ) {
         uncacheContextMenu( menu.items[i].submenu );
      }
   }

   // remove from all menus array
   for ( var i=0; i<allMenus_.length; i++ ) {
      if ( allMenus_[i] == menu ) {
         var temp = new Array();
         var index = 0;
         for ( var j=0; j<allMenus_.length; j++ ) {
            if ( j != i ) {
               temp[ index ] = allMenus_[ j ];
               index++;
            }
         }
         allMenus_ = temp;
         break;
      }
   }
}

function contextMenuSetIcons( transparentImage,
                              arrowDefault, arrowSelected, arrowDisabled,
                              launcherDefault, launcherSelected,
                              arrowDefaultRTL, arrowSelectedRTL, arrowDisabledRTL,
                              launcherDefaultRTL, launcherSelectedRTL ) {
   transImg_ = transparentImage;

   arrowNorm_ = arrowDefault;
   arrowSel_ = arrowSelected;
   arrowDis_ = arrowDisabled;
   launchNorm_ = launcherDefault;
   launchSel_ = launcherSelected;

   arrowNormRTL_ = arrowDefaultRTL;
   arrowSelRTL_ = arrowSelectedRTL;
   arrowDisRTL_ = arrowDisabledRTL;
   launchNormRTL_ = launcherDefaultRTL;
   launchSelRTL_ = launcherSelectedRTL;

   contextMenuPreloadImage( transImg_ );

   contextMenuPreloadImage( arrowNorm_ );
   contextMenuPreloadImage( arrowSel_ );
   contextMenuPreloadImage( arrowDis_ );
   contextMenuPreloadImage( launchNorm_ );
   contextMenuPreloadImage( launchSel_ );

   contextMenuPreloadImage( arrowNormRTL_ );
   contextMenuPreloadImage( arrowSelRTL_ );
   contextMenuPreloadImage( arrowDisRTL_ );
   contextMenuPreloadImage( launchNormRTL_ );
   contextMenuPreloadImage( launchSelRTL_ );
}

function contextMenuSetArrowIconDimensions( width, height ) {
   arrowWidth_ = width;
   arrowHeight_ = height;
}

function contextMenuPreloadImage( imgsrc ) {
   var preload = new Image();
   preload.src = imgsrc;
}

function toggleLauncherIcon( popupID, selected, isLTR ) {
   if ( selected ) {
      if ( isLTR ) {
         document.images[ popupID ].src = launchSel_;
      }
      else {
         document.images[ popupID ].src = launchSelRTL_;
      }
   }
   else {
      if ( isLTR ) {
         document.images[ popupID ].src = launchNorm_;
      }
      else {
         document.images[ popupID ].src = launchNormRTL_;
      }
   }
   return true;
}

function contextMenuSetNoActionsText( noActionsText, submenuAltText ) {
   noActionsText_ = noActionsText;
   submenuAltText_ = submenuAltText;
}

function contextMenuGetNoActionsText() {
   return noActionsText_;
}

function getWidth( tag ) {
   return tag.offsetWidth;
}

function getHeight( tag ) {
   return tag.offsetHeight;
}

function getLeft( tag, recurse ) {
   var size = 0;
   if ( recurse && tag.offsetParent != null ) {
      size += getLeft( tag.offsetParent, recurse );
   }
   if ( tag != null ) {
      size += tag.offsetLeft;
   }
   return size;
}

function getTop( tag, recurse ) {
   var size = 0;
   if ( recurse && tag.offsetParent != null ) {
      size += getTop( tag.offsetParent, recurse );
   }
   if ( tag != null ) {
      size += tag.offsetTop;
   }
   return size;
}

/*****************************************************
* code for dynamically loaded menus
*****************************************************/
function loadDynamicMenu( menuURL ) {
   debug( '* loadDynamicMenu: ' + menuURL );
   var menu = getContextMenu( menuURL );
   if ( menu != null ) {
      if ( menu.isVisible ) {
         // dynamic menu requested, but it's currently showing
         menu.hide();
      }
      if ( !menu.isCacheable ) {
         // make sure it's not in the cache
         uncacheContextMenu( menu );
      }
   }
   if ( getContextMenu( menuURL ) == null ) {
      if ( top.isContextMenuManager_ != null ) {
         debug( 'loadDynamicMenu: loading' );
         top.contextMenuManagerLoadDynamicMenu( menuURL );
      }
   }
}

function getDynamicMenu( menuURL, cache ) {
   debug( '* getDynamicMenu: ' + menuURL );
   var clone = getContextMenu( menuURL );
   if ( clone == null ) {
      if ( top.isContextMenuManager_ != null ) {
         if ( top.contextMenuManagerIsDynamicMenuLoaded() ) {
            var menu = top.contextMenuManagerGetDynamicMenu();
            debug( 'getDynamicMenu: fetched menu from other frame' );
            clone = cloneMenu( menu, menuURL, cache );
            if ( clone.items.length == 0 ) {
               contextMenuSetNoActionsText( top.contextMenuManagerGetNoActionsText() );
            }
         }
         else {
            debug( 'getDynamicMenu: menu not loaded' );
         }
      }
      else {
         debug( 'getDynamicMenu: menu manager not present' );
      }
   }
   else {
      debug( 'getDynamicMenu: menu previously loaded' );
   }
   return clone;
}

/**
 * Clone menu (deep copy). This does not clone listeners
 */
function cloneMenu( menu, name, cache ) {
   var clone = getContextMenu( name );
   if ( clone == null ) {
      if ( menu != null ) {
         clone = createContextMenu( name, menu.isLTR, menu.width );
      }
      else {
         clone = createContextMenu( name, true, 150 );
      }
      clone.isDynamic = true;
      clone.isCacheable = cache;
      if ( menu != null ) {
         for ( var i=0; i<menu.items.length; i++ ) {
            clone.add( cloneMenuItem( menu.items[i], name + "_sub" + i, cache ) );
         }
      }
   }
   return clone;
}

function cloneMenuItem( item, submenuName, cache ) {
   var submenu = null;
   if ( item.submenu != null ) {
      submenu = cloneMenu( item.submenu, submenuName, cache );
   }
   var clone = new UilMenuItem( item.text, item.isEnabled, item.action, item.clientAction, submenu, item.icon, item.isDefault );
   //clone.isEnabled = item.isEnabled;
   clone.isSelected = item.isSelected;
   clone.isSeparator = item.isSeparator;
   clone.isFirst = item.isFirst;
   clone.isLast = item.isLast;
   clone.parentMenu = item.parentMenu;
   clone.itemTag = item.itemTag;
   clone.anchorTag = item.anchorTag;
   clone.arrowTag = item.arrowTag;

   return clone;
}


// constructor
function CssStyles( cssString ) {
   // member variables
   this.cssString = cssString;   //big css string: ".class1 { prop1:val1; ... propn:valn; } ... .classn { prop1:val1; ... propn:valn; } "
   this.styles = new Object();   //associative array of defined class styles found in cssString: this.styles[class1] = "prop1:val1; ... propn:valn;"

   // external methods
   this.getStyle = CssStylesGet;
   this.setStyle = CssStylesSet;
   this.setStyles = CssStyleSetStyles;

   // internal methods
   this.parseCssString = CssStylesParseCssString;
   this.propCssToJs    = CssStylesPropCssToJsFormat;

   this.parseCssString();
}

//parse this.cssString into its individual css class definitions
function CssStylesParseCssString() {
   if ( this.cssString == null || this.cssString == "" ) {
       return;
   }

   var styles = this.cssString.trim().split("\.");
   //alert(styles.length);
   for (i=0; i<styles.length; i++) {
      var re = /(\w+)\s*\{\s*([^\}]+)\s*\}/;
      var string = styles[i];
      //alert(string);
      if ( re.test(string) ) {
         //if ( !confirm(RegExp.$1 + ": " + RegExp.$2) ) return;
         this.setStyle(RegExp.$1,RegExp.$2);
      }
   }

}

//return css definition for className: "prop1:val1; ... propn:valn;"
function CssStylesGet(className) {
   if ( this.styles[className] == null ) {
      return "";
   }
   return this.styles[className];
}

//set cssString as te css string definition for given className
function CssStylesSet(className, cssString) {
   this.styles[className] = cssString;
}

//set CSS style for the given HTML tag based on the given css class styleID
function CssStyleSetStyles(tag, styleID) {
   var style = this.styles[styleID];
   if ( style == null || style == "" ) return;
   var styles = this.getStyle(styleID).trim().split("\;");
   
   for (i=0; i<styles.length; i++) {
      //split font-family:Arial into its attribute (font-family) and value (Arial) components
      if ( styles[i] == "" ) continue;
      var attrVal = styles[i].trim().split("\:");
      if ( attrVal.length != 2 ) continue;

      var attr  = attrVal[0];
      var value = attrVal[1];

      attr = this.propCssToJs(attr);
      tag.style[attr]=value;
   }

}

//convert given css property name to its cooresponding Mozilla JavaScript name
function CssStylesPropCssToJsFormat(attr) {
   //convert from font-family to fontFamily for Mozilla Javascript
   var re2 = /^([^\-]+)(\-)([^\-])(.*)/;
   var results = attr.match(re2);
   if ( results != null && results.length == 5 ) {
      return attr = results[1] + results[3].toUpperCase() + this.propCssToJs(results[4]);
   }
   return attr;
}

//remove leading/trialing whitespace from this
String.prototype.trim = function() {
   var str = this;
   str = str.replace(/^\s*(.*)/,  "$1");
   str = str.replace(/(.*?)\s*$/, "$1");
   return str;
}


/**
 * Static delcaration of ContextMenuHelper class.
 */
if ( !self.ContextMenuHelper ) {
    self.ContextMenuHelper = new ContextMenuHelperImpl();
}

function ContextMenuHelperImpl() {
    this.isMenuVisible = ContextMenuHelperIsMenuVisible;
}

function ContextMenuHelperIsMenuVisible() {
    return menuVisible_;
}
