/*********************************************************** {COPYRIGHT-TOP} ***
* Licensed Materials - Property of IBM
*
* (C) Copyright IBM Corp. 2007  All Rights Reserved.
*
* US Government Users Restricted Rights - Use, duplication, or
* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
************************************************************ {COPYRIGHT-END} ***
*******************************************************************************/

/*******************************************************************************
* This js file contains functions to support a custom html select box which
* supports both standard select and an editable combobox.  It supports regular
* keyboard and mouse controls and also enhances accessiblity over regular
* <select> elements.  The current implementation mimics a swing ecb with the
* addition of notify complete.
*
* Html elements included for support:
* 
* Name             Description
* 
* id               A hidden input element which stores the ecb's value
*                  This is the element which will actually be submitted
* id_select        The div container which holds the comboBox options
* id_inp           The main text entry
* id_opt_xx        Anchor tag option
* id_opt_xx_val    The value of an option
* id_editable      Hidden input element to store the editable tex
* id_inpstore      Contains the initial value so we can revert if need be
* id_HTMLSelect    A select element which will hold the same options to 
*                  allow a js function to resize the input box accordingly
* 

* Module History:
* 2006          Koziol      Initial Version
* 04/04/2007    Koziol      Defect 595930 - Adjusted editable combobox to act 
*                           like a swing ecb
* 04/09/2007    Koziol      Defect 599855 - If there are space constraints
*                            open the cb upward.
* 04/18/2007    Koziol      Defect 602041 - Non-Editable combobox won't respond to keyboard letters
*******************************************************************************/


//Custom selectBox constructor
function CustomSelectBox( prefix, isEditable, hasStatus, optLength ){

    //Private elements    
    this.prefix = prefix; //name of the select box
    this.selectedIdx = -1;  //selected index number initially -1
    this.selectedId = null; //currently selected id
    this.selectedIdxStore = -1;  //Stores the old selected index number initially -1
    this.selectedIdStore = null; //Stores the old selected id    
    this.isKeyScroll = false; //indicates key scrolling just occured (up/down arrow);
    this.isNotifyComplete = false; //is this select box notify complete?    
    this.isDismissable = true;  //can this select be closed?    
    this.isEditable = isEditable; //am I editable or static?
    this.hasStatus = hasStatus; //is there any error checking or is this required.
    this.optLength = optLength;  //max length for this comboBox
    this.hiddenElements = new Array();  //elements that we hid during open
    this.overflowHidden = new Array();  //elements that were overflowHidden
    this.offsetTop = 0;  //the static offsetTop     
    this.options = new Array(); //array of CSBOptions

    //html elements
    this.select = null;
    this.input = null;
    this.inpstore = null;
    this.editable = null;
    this.HTMLSelect = null;
                                        
    //Public functions
    this.close = CSBRollUp;
    this.isOpen = CSBIsOpen; 
    this.hideOverlayingControls = CSBHideOverlayingControls;
    this.showOverlayingControls = CSBShowOverlayingControls;
    this.getHiddenElements = CSBGetHiddenElements;
    this.removeParentOverflow = CSBRemoveParentOverflow;
    this.setParentOverflowHidden = CSBSetParentOverflowHidden;
    this.scrollToOption = CSBScrollToOption;
    this.scrollDown = CSBScrollDown;
    this.scrollUp = CSBScrollUp;
    this.findNextKeyMatch = CSBFindNextKeyMatch;
}

function CSBRollUp(){
    var prefix = this.prefix;
    //if the select box is open, close it, update state, and revert the old value
    //this of course only happens if no option was chosen.    
    if( this.isOpen() ){    
        CSBHandleCollapse(prefix);
        justOpenedId = null;
    }    
}

function CSBIsOpen(){
    var sel = document.getElementById(this.prefix + '_select');
    return !(sel.style.display == 'none' || sel.style.display == '' );
}

/**
 * Hides controls that do not obey z-index
 * 
 * @author context_ie.js
 * @param prefix the selectBox that is open
 */
function CSBHideOverlayingControls( ){
    selectDiv = document.getElementById( this.prefix + "_select");
    if( selectDiv && WClient.isBrowserInternetExplorer() && !WClient.isBrowserVersion7Up()){    
          // @01A - Hide any items that intersect this menu
          var coll = document.getElementsByTagName("SELECT");
          if (coll!=null)
          {
             for (i=0; i<coll.length; i++)
             {
                //Hide the element
                if (CSBIntersect(selectDiv,coll[i]) == true ) {
                   if (coll[i].style.visibility != "hidden")
                   {
                      coll[i].style.visibility = "hidden";
                      this.hiddenElements.push(coll[i]);
                   }
                }
             }
          }
         // Hide any embed tag items that intersect this menu
          coll = document.getElementsByTagName("EMBED");
          if (coll!=null)
          {
             for (i=0; i<coll.length; i++)
             {
                //Hide the element
                if (CSBIntersect(selectDiv,coll[i]) == true ) {
                   if (coll[i].style.visibility != "hidden")
                   {
                      coll[i].style.visibility = "hidden";
                      this.hiddenItems.push(coll[i]);                      
                   }
                }
             }
          }
          coll = document.getElementsByTagName("IFRAME");
          if (coll!=null)
          {
             for (i=0; i<coll.length; i++)
             {
                //Hide the element
                if (CSBIntersect(selectDiv,coll[i]) == true ) {
                   if (coll[i].style.visibility != "hidden")
                   {
                      coll[i].style.visibility = "hidden";
                      this.hiddenItems.push(coll[i]);
                   }
                }
             }
         }
    }
}

/**
 * Show any elements that were hidden
 * @author context_ie.js
 */
function CSBShowOverlayingControls(){    
      // @01A - Show any items that were hidden by this menu
      var itemCount = this.hiddenElements.length;
      for (i=0; i<itemCount; i++)
      {
         var item = this.hiddenElements.pop();
         item.style.visibility = "visible";
      }
      itemCount = hiddenComponents.length;
      for (i=0; i<itemCount; i++)
      {
         var item = hiddenComponents.pop();
         item.style.visibility = "visible";
      }
}

/**
 * Remove the first parent overflow if it's hidden otherwise
 * the select div will dive under the next container.
 */
function CSBRemoveParentOverflow(){
    var sel = document.getElementById( this.prefix + "_select");
    var foundOverflowHidden = false;
    if( sel && WClient.isBrowserMozilla()){    
        var parent = sel.parentNode;
        while( parent && !foundOverflowHidden ){
            if( parent.style) {            
                if( parent.style.overflow == "hidden"){
                    //foundOverflowHidden = true;
                    parent.style.overflow = "visible";
                    this.overflowHidden.push( parent );                
                } 
                if( parent.className && parent.className != "" ) {
                    className = parent.className + "|";
                    for ( var i = 0; i < document.styleSheets.length; i++ ){
                        var styleSheet = document.styleSheets.item(i);
                        var rules = null;
                        if ( WClient.isBrowserInternetExplorer() ){
                            rules = styleSheet.rules;
                        }else if ( WClient.isBrowserMozilla() ){
                            rules = styleSheet.cssRules;
                        }
                        for ( var j = 0; j < rules.length; j++ ){
                            var rule = rules[j];
                            if ( rule.selectorText == ('.' + parent.className) ){                            
                                if( rule.style && rule.style.overflow == "hidden"){
                                    //foundOverflowHidden = true;
                                    parent.style.overflow = "visible";                                
                                    this.overflowHidden.push( parent );
                                }
                                j=rules.length;
                            }
                        }                                     
                    }
                }
            }
            parent = parent.parentNode;
        }
    }

}

/**
 * Return the any changed overflow back to hidden on close
 */
function CSBSetParentOverflowHidden(){
    var itemCount = this.overflowHidden.length;
    for( i =0;i<itemCount;i++){
        var item = this.overflowHidden.pop();
        if( item ){
            item.style.overflow = "hidden";
        }
    }
}

/**
 * Return all the elements that were just hidden
 */
function CSBGetHiddenElements(){
    return this.hiddenElements;
}

// author - Context_ie.js
// Test whether two objects overlap
function CSBIntersect(obj1, obj2) //@01A
{
   var rect1 = obj1.getBoundingClientRect();
   var rect2 = obj2.getBoundingClientRect();
   if (CSBLineIntersect(rect1.top, rect1.bottom, rect2.top, rect2.bottom) &&
       CSBLineIntersect(rect1.left, rect1.right, rect2.left, rect2.right) ) {
      return true;
   }
   return false;
}

// author - Context_ie.js
// Test whether the two line segments a--b and c--d intersect.
function CSBLineIntersect(a, b, c, d) //@01A
{
   //alert (a+"--"+b + "   " + c + "--" + d);
   //Assume that a < b && c < d
   if ( (a <= c  && c <= b) ||
        (a <= d && d <= b) ||
        (c <= a && d >= b ) )
   {
      return true;
   } else {
      return false;
   }
}

/**
 * Scroll the combobox to the typed key.
 * 
 * @param key
 */
function CSBScrollToOption( optionIdx ){
    var oldIdx = this.selectedIdx;
    CSBHighlightSelection( this.prefix, this.options[optionIdx].divId );
    if( optionIdx > oldIdx )
        this.scrollDown();
    else
        this.scrollUp();
}

/**
 * Find the next option to match the key.
 *
 *@param key
 */
function CSBFindNextKeyMatch( key ){
    var currOpt = this.selectedIdx + 1;        
    var processedOptions = 0;
    while( processedOptions < this.options.length - 1 ){
        if( currOpt == this.options.length )
            currOpt = 0;
        //convert the key to lowercase because IE always uses upper for some reason.
        key = String.fromCharCode(key).toLowerCase().charCodeAt(0);        
        if( this.options[currOpt].text.toLowerCase().charCodeAt(0) == key ){                    
            return currOpt;
        }
        currOpt++;
        processedOptions++;
    }
    return null;
}

/**
 *  Scroll down
 */
function CSBScrollDown( ){
    var selel = document.getElementById( this.selectedId );
    var sel = this.select;
    if( selel && selel.offsetTop != 0 ){
        if(  (selel.offsetTop - sel.scrollTop) > ( sel.clientHeight / 1.5 ) && (selel.offsetTop - sel.scrollTop) < sel.clientHeight ) {
            //scroll down showing two underneath
            sel.scrollTop = sel.scrollTop + (selel.clientHeight );
        } else if( (selel.offsetTop - sel.scrollTop) <= 0 || sel.scrollTop < (selel.offsetTop - (sel.clientHeight / 1.5)) ) {
            //item is of view, just scroll to it.
            sel.scrollTop = selel.offsetTop;
        }
    }else if( selel && selel.offsetParent){
        //in IE after the selectbox is toggled on/off the anchor element looses its offset top
        //but its parent gains it.            
        if(  (selel.offsetParent.offsetTop - sel.scrollTop) > ( sel.clientHeight / 1.5 )&& (selel.offsetParent.offsetTop - sel.scrollTop) < sel.clientHeight ) {
            //scroll down showing two underneath
            sel.scrollTop = sel.scrollTop + (selel.clientHeight );
        } else if ( ( selel.offsetParent.offsetTop - sel.scrollTop) <= 0 || sel.scrollTop < (selel.offsetParent.offsetTop - (sel.clientHeight / 1.5))) {
            //item is out of view just scroll to it.
            sel.scrollTop = selel.offsetParent.offsetTop;
        }
    }
}

function CSBScrollUp(){
    //scroll the select box up
    var selel = document.getElementById( this.selectedId );    
    var sel = this.select;
    if( selel && selel.offsetTop != 0 ){
        //scroll the window to the selected option if it's out of view.
        if(  (selel.offsetTop - sel.scrollTop) <= 0 || selel.offsetTop >= (sel.scrollTop + sel.clientHeight)){
            sel.scrollTop = selel.offsetTop;
        }
    }else if( selel && selel.offsetParent){
        //in IE after the selectbox is toggled on/off the anchor element looses its offset top
        //but its parent gains it.
        if(  (selel.offsetParent.offsetTop - sel.scrollTop) <= 0 || selel.offsetParent.offsetTop >= (sel.scrollTop + sel.clientHeight)){
            sel.scrollTop = selel.offsetParent.offsetTop;
        }            
    }
}
//END CSB FUNCTIONS


/**
 * Replace an img source
 * 
 * @param id            element id to replace
 * @param imagesrc      new image source
 */
function CSBReplaceImage(id, imagesrc) {
    var el = document.getElementById(id);
    el.src = imagesrc;
}

/**
 * Make an element visible (namely the select dropdown )
 * 
 * @param id            the element to make visible
 */
function CSBShowItem(id) {
   var el = document.getElementById(id);
    el.style.display = 'block';
}

/**
 * Make an element invisible
 * 
 * @param id            the element to hide
 */
function CSBHideItem(id) {
    var el = document.getElementById(id);
    el.style.display = 'none';
}

/**
 * The input field is editable no matter what item is selected.
 * Once the input element is changed this method fires updating
 * state information on the comboBox.  The editable option in
 * the dropdown is updated.
 * 
 * @param prefix            the comboBox
 * @param srcid             the input element
 * @param destid            the editable option
 */
function CSBUpdateOptionFromInput(prefix, destid) {
    var csBox = getCustomSelectBox(prefix);
    //return before we break something;
    if( csBox == null ){
        return;
    }
    //if we aren't scrolling
    if( !csBox.isKeyScroll ){	  
    	var srcel = document.getElementById(prefix + '_inp'); //input text               
        var destelHidden = document.getElementById(prefix + "_editable");   
        var destval = document.getElementById( prefix );                                     
        //check to see if entered text already matches an option
        var optionExists = CSBGetExistingOption( srcel.value, prefix );
        if( optionExists ){
            //highlight the option already selected
            CSBUpdateInputFromOption( optionExists, prefix );
            return;
        }
        //update values across the board           

        //update the editable value
        destelHidden.value = srcel.value;
        destelHidden.disabled = false;
        //update the real value
        destval.value = "editable";
        //nothing is selected
        csBox.selectedIdx = -1;        
        //(un)highlight the selected option
        CSBHighlightSelection( prefix, destid );                                       
   }    	
}

/**
 * Get the id of the option value if it exists
 * 
 * @param value             the new value
 * @param prefix            the comboBox
 */
function CSBGetExistingOption( value, prefix ){
    var selel = document.getElementById( prefix + '_select');
	var optionArray = selel.childNodes;
	for( i = 0; i < optionArray.length;i++){
		if( optionArray[i].firstChild.firstChild.data == value )
			return optionArray[i].firstChild.id;
	}    
}

/**
 * Update the text entry with the selected option
 * 
 * @param srcid             input option
 * @param prefix            the comboBox
 */
function CSBUpdateInputFromOption( srcid, prefix) {
    var srcel = document.getElementById(srcid);
    var destel = document.getElementById(prefix + '_inp');
    var initialsrcel = document.getElementById(prefix + '_inpstore');
    var realdest = document.getElementById(prefix );
    var srcval = document.getElementById( srcid + '_val');
    var inpel = document.getElementById( prefix + '_editable');
    var csBox = getCustomSelectBox(prefix);
    //prevent bad things
    if( csBox == null){
        return;
    }
    //update the input box's text
    destel.value = srcel.firstChild.data;    
    //update the real value
    realdest.value = srcval.value;    
    CSBHighlightSelection( prefix, srcid );       
    //if the select box is editable, mandatory, and the editable text is blank, reset the editable value
    //to prevent an occurrence where, a blank value is sumbmitted, then changed to an option, then submitted
    //it will still think the blank option was chosen.
    if(inpel && (inpel.value == "") && csBox.isEditable && csBox.hasStatus ){
        inpel.value = "- Editable Value -";
    }    
}

/**
 * Execute a function passed in then submit.  Browsers won't
 * keep variables if used within hrefs so the form passed into
 * frmAct won't exist after it exits.
 * 
 * @param strToEval         function to evaluate
 * @param formName          form to submit
 * @param prefix            the comboBox
 */
function executeInFunction( strToEval, formName, prefix, allowSubmit ){           
    var selel = document.getElementById( prefix );    
    var initialel = document.getElementById( prefix + '_inpstore');
    var csBox = getCustomSelectBox(prefix);

    //return so we don't break anything
    if( csBox == null){
        return;
    }
    if (document != null && document.forms != null && formName != null) {
        var form = document.forms[formName];
        //submit if 
        // selected option isn't editable
        // editable value isn't default        
        if( (selel && selel.value != "editable") && (selel.value != initialel.value) ){
            eval( strToEval );
            if( allowSubmit )
                form.submit();
        }
    }
    
}


/**
 * Highlight an option, un-highlighting previous.
 * 
 * @param prefix            the comboBox
 * @param srcid             option to highlight
 */
function CSBHighlightSelection( prefix, srcid ){	
	var srcel = document.getElementById(srcid);
    var csBox = getCustomSelectBox(prefix);
    var realel = document.getElementById( prefix );
    //un-highlight previous option
    if( csBox.selectedId ){
	    var hlightedOpt = document.getElementById( csBox.selectedId );
    	hlightedOpt.style.backgroundColor= '';
    	hlightedOpt.style.color= 'black';
	}
    //update selected index if the element exists, otherwise it's editable
    if( srcel ){    
        //updated selected index
        csBox.selectedIdx = CSBGetScrollIndex( srcid );        
        srcel.style.backgroundColor = 'navy';
        srcel.style.color = 'white';
        //update selected id    
        csBox.selectedId = srcid;
    } else {
        csBox.selectedIdx = -1;        
        csBox.selectedId = null;
    }
    
}

/**
 * Obtain the index # of the option
 * 
 * @param srcid             option id
 */
function CSBGetScrollIndex( srcid ){
    var srcel = document.getElementById(srcid);
	var optionArray = srcel.parentNode.parentNode.childNodes;
	for( i = 0; i < optionArray.length;i++){
		if( optionArray[i].firstChild == srcel )
			return i;		
	}
} 

/**
 * Run various functions to hide the select box.
 * 
 * @param prefix
 */
function CSBHandleCollapse(prefix) {
    CSBReplaceImage(prefix + '_img', '/wclres/../skin/images/ecbClosed.gif');
    CSBHideItem(prefix + '_select');   
    var csBox = getCustomSelectBox(prefix);    
    if( csBox ){    
        if(!justOpenedId || csBox.prefix == justOpenedId ){                
            csBox.showOverlayingControls();
        }
        csBox.setParentOverflowHidden();
        CSBHighlightSelection( prefix, csBox.selectedIdStore);
        csBox.selectedIdx = csBox.selectedIdxStore;
        csBox.selectedId = csBox.selectedIdStore;

    }
}

/**
 * Run various functions to expand the select box
 * 
 * @param prefix            the comboBox
 */
function CSBHandleExpand(prefix) {
    CSBReplaceImage(prefix + '_img', '/wclres/../skin/images/ecbOpen.gif');
    CSBShowItem(prefix + '_select');        
}


/**
 * Hide or Show the comboBox dropdown
 * 
 * @param prefix            the comboBox.
 */
function CSBToggleExpansion(prefix) {
    
    var sel = document.getElementById(prefix + '_select');
    var inpel = document.getElementById(prefix + '_inp');    
    var img = document.getElementById(prefix + '_img');    
    var csBox = getCustomSelectBox(prefix);
    //return before we break something;
    if( csBox == null ){
        return;
    }
    //update the revert values;
    csBox.selectedIdxStore = csBox.selectedIdx;
    csBox.selectedIdStore = csBox.selectedId;
    
    //get the selected anchor element
    var selel = document.getElementById( csBox.selectedId );  

    if (!csBox.isOpen()) {
        //change hidden stuff to regular
        csBox.removeParentOverflow();
        CSBMakeAllDismissable();        
        justOpenedId = prefix;
        
        //adjust the size of the box depending on browser to line up the scrollbar and dropdown img
        var adjustment = 0;
        if( navigator.appName == 'Netscape' ){
	        adjustment = -7;	        
        } else if(navigator.userAgent.indexOf("Opera")!=-1){
			var versionindex=navigator.userAgent.indexOf("Opera")+6
			if (parseInt(navigator.userAgent.charAt(versionindex))>=8)
				adjustment = -7;
		} else if( navigator.appName == "Microsoft Internet Explorer" ){
			adjustment = 6;
		} 
        CSBHandleExpand(prefix);
        var newWidth = CSBGetComponentWidth(prefix + '_inp') + CSBGetComponentWidth(prefix + '_img') + adjustment;        
        sel.style.width = newWidth + inpel.offsetLeft;        
        
        //prevents bottom scroll bar from appearing when it's not needed        
        if( newWidth < sel.scrollWidth -10 ){
            //do nothing I'm not sure why this fixes a bug in IE            
            //allows the entire option to be highlightable not just the text
            //the first time the select box is open
        }        
        var totalOptionHeight = 0;
        var optionList = sel.childNodes;
        
        //calcuate total height of options        
        for( i = 0; i< optionList.length; i++){
            if( optionList[i].nodeName == "DIV" ){
                totalOptionHeight += eval(optionList[i].offsetHeight);
            }
        }
        
        //adjust the option box location
        csBox.offsetTop = getOffsetTop( inpel ) + 27

        //if total height less than preset value, shrink the box
        //to prevent extra whitespace
        var maxHeightBelow = document.body.scrollTop + document.body.clientHeight - csBox.offsetTop -10;
        var maxHeightAbove = document.body.clientHeight - (maxHeightBelow + 10) - inpel.offsetHeight;
        

        var putBelow = true;        
        if( maxHeightBelow < 100 ){
            if( maxHeightAbove > maxHeightBelow && (totalOptionHeight + 18) > maxHeightBelow ){
                putBelow = false;
            }
        }
        if( putBelow ){        
            sel.style.height = maxHeightBelow;
            if( totalOptionHeight + 18 < maxHeightBelow ){        
                if( totalOptionHeight +5 <= 300 ){                
                    //set height to option height
                    sel.style.height = totalOptionHeight + 5;
                } else {
                    sel.style.height = 300;
                }
            } else if( maxHeightBelow > 300 ){
                //Many options let's make it 300
                sel.style.height = 300;
            } else if( maxHeightBelow < 50) {               
                sel.style.height = 100;
            }        
            //find out if the scroll bar showed if so, size a little bigger,
            //be weary of the bottom of the browser though
            if( sel.clientHeight < sel.scrollHeight ){            
                if( maxHeightBelow > parseInt(sel.style.height) + 15 ){
                    if( WClient.isBrowserInternetExplorer() ){                
                        sel.style.height = parseInt(sel.style.height) + 7;
                    } else {
                        sel.style.height = parseInt(sel.style.height) + 15;
                    }
                }
            }                  

            sel.style.top = csBox.offsetTop;
        } else {
            //putabove            
            sel.style.height = maxHeightAbove -10;            
            if( totalOptionHeight + 18 < maxHeightAbove  ){        
                if( totalOptionHeight + 5 <= 300 ){                
                    //set height to option height
                    sel.style.height = totalOptionHeight + 5;
                } else {
                    sel.style.height = 300;
                }
            } else if( maxHeightAbove > 300 ){
                //Many options let's make it 300
                sel.style.height = 300;
            } else if( maxHeightAbove < 50 ){
                sel.style.height = 100;
            }
            
            //move the top of the select box appropiately
            var adjust = 10;
            if( WClient.isBrowserInternetExplorer() )
                adjust = 5;
            var tempTop = csBox.offsetTop - inpel.offsetHeight - (parseInt(sel.style.height) + adjust);            
            //could be negative top, if so move down and adjust height;
            if( tempTop < 0 ){                
                sel.style.top = 0;
                sel.style.height = parseInt(sel.style.height) + tempTop;                
            } else 
                sel.style.top = tempTop;            
        }

        //give the inputbox the focus
        inpel.focus();
        csBox.isDismissable = false;
        
        //move the scroll to selection              
        if( selel && selel.offsetTop != 0 ){
            sel.scrollTop = selel.offsetTop;
        }else if( selel && selel.offsetParent){
            //in IE after the selectbox is toggled on/off the anchor element looses its offset top
            //but its parent gains it.
            sel.scrollTop = selel.offsetParent.offsetTop;
        } else {
            sel.scrollTop = 0;
        }        
        //hide any controls that will be overlayed
        csBox.hideOverlayingControls();
        var hiddenElements = csBox.getHiddenElements();
        for( i = 0 ;i<hiddenElements.length;i++){
            hiddenComponents.push( hiddenElements[i]);
        }
    } else {          
        //close the combox and update state        
        csBox.isDismissable = true;        
        CSBHandleCollapse( prefix );        
    }    
}

/**
 * Resize the options within the select box
 * 
 * @param prefix        the comboBox
 * @param width         new width
 */
function CSBResizeOptionDivs( prefix, width ){
    var selDiv = document.getElementById( prefix + '_select');

    for( i = 0; i < selDiv.childNodes.length; i ++ ){
        if( selDiv.childNodes[i].nodeName == "DIV" ){
                selDiv.childNodes[i].style.width = width;                                            
        }
    }
}

/**
 * Obtain the width of a component
 * 
 * @param id
 */
function CSBGetComponentWidth(id) {
    var el = document.getElementById(id);
    return el.offsetWidth;
}

/**
 * obtain the height of a component
 * 
 * @param id
 */
function CSBGetComponentHeight(id) {
    var el = document.getElementById(id);
    return el.offsetHeight;
}

/**
 * Certain function keys fire onkeypress in IE so fire on
 * keydown as well
 * 
 * @param prefix
 * @param e
 */
function CSBKeyDown( prefix, e ){
    //just return if browser is opera because it might also emulate IE
    //and fire scrolling twice
    if(navigator.userAgent.indexOf("Opera")!=-1){
			var versionindex=navigator.userAgent.indexOf("Opera")+6
			if (parseInt(navigator.userAgent.charAt(versionindex))>=8)
				return;
    }
    //fire scrollist because IE doesn't cause onkeypress event for arrow keys 
    if( navigator.appName == "Microsoft Internet Explorer" ){
        CSBKeyPress( prefix, e );
	} 
}

/**
 * Fired on keypress to scroll through the options using the
 * keyboard, submit on enter, and revert on escape.
 * 
 * @param prefix
 * @param e
 */
function CSBKeyPress(prefix,e){		        
	var destel = document.getElementById(prefix + '_inp');
    var destval = document.getElementById(prefix );
	var sel = document.getElementById(prefix + '_select');
    var csBox = getCustomSelectBox(prefix);
    //return before we break something;
    if( csBox == null ){
        return;
    }
    var key;
    //get the keycode
    var wEvent = new WEvent( e );
    key = wEvent.getKeyCode();
    //process the keystroke
    if( key == 13 || key == 9){    
        // enter or tab key    
        if( key == 9 ){
            if (!csBox.isOpen()) {
                return true;
            }
        }

        //cancel the event and any registered handlers, normal comboboxs don't submit the form on enter
        if( e.preventDefault ){        
            e.preventDefault();
            e.cancelBubble = true;
            if( e.stopPropagation)
                e.stopPropagation();            
        }else{                    
            e.cancelBubble = true;
            e.returnValue = false; //IE
        }  
 
        var selectedElement;
        if (csBox.isOpen()) {
            //combobox is open and an option was selected
            CSBToggleExpansion( prefix );
            //execute the selected href            
            var selectedId = csBox.selectedId;            
            if( selectedId ){        
                selectedElement = document.getElementById( selectedId );
            }
        } else {        
            //an editable option was entered or nothing was changed and the enterkey was pressed
            //check if entered option exists in list
            var currOptId = CSBGetExistingOption( destel.value, prefix );
            if( currOptId ){
                //found what the user typed in our list of options                
                selectedElement = document.getElementById( currOptId );
            } else {
                //didn't find it in the list, update the editable val
                CSBUpdateOptionFromInput(prefix, (prefix + "_evalueopt" ));
            }
        }
        if( selectedElement )            
            if( selectedElement.href )
                eval( unescape(selectedElement.href) );

        return false;
    }       
    if( key == 27 ){
        //escape key, revert selection and close select box
        if (csBox.isOpen() ) {            
            csBox.close();            
        }
    }else if( key == 38 && !e.shiftKey) {
        //key up
        csBox.isKeyScroll = true;
        //if the combobox isn't open yet, open and return;
        if (!csBox.isOpen()) {
            CSBToggleExpansion( prefix );            
            csBox.isDismissable = true;
            return false;
        }   

		var storeFirstOpt = csBox.selectedIdx;			
        //increment selected option to next
        do{
			if( csBox.selectedIdx > 0 ){				
				csBox.selectedIdx -= 1;
			}
			
		} while( csBox.selectedIdx > 1 && sel.childNodes[csBox.selectedIdx].nodeName != "DIV" );
 				
		if( csBox.selectedIdx > -1 && sel.childNodes[csBox.selectedIdx].nodeName == "DIV" ){	
            CSBHighlightSelection( prefix, sel.childNodes[csBox.selectedIdx].firstChild.id );
		} else {
            //no more options above this one, set to old option
			csBox.selectedIdx =  storeFirstOpt;             
		}    

        //scroll the select box up
        csBox.scrollUp();
	}else if( key == 40 && !e.shiftKey){
		//key down        
		csBox.isKeyScroll = true;
        //if combobox isn't open; open and return
        if (!csBox.isOpen()) {
            CSBToggleExpansion( prefix );
            csBox.isDismissable = true;
            return;
        } 
		var storeLastOpt = csBox.selectedIdx;
        //advance to next option
		do{
			csBox.selectedIdx += 1;
		} while( csBox.selectedIdx < sel.childNodes.length - 1  && sel.childNodes[csBox.selectedIdx].nodeName != "DIV" );
 			
		
		if( csBox.selectedIdx < sel.childNodes.length && sel.childNodes[csBox.selectedIdx].nodeName == "DIV" ){
            CSBHighlightSelection( prefix, sel.childNodes[csBox.selectedIdx].firstChild.id );
		} else {
            //no more options below            
			csBox.selectedIdx = storeLastOpt;
            
		}
       
        //scroll down
        csBox.scrollDown();
	}else {        
        //any other character.        

        //kill the keystroke if the selectbox is editable, an altkey was pressed or code =20
        if(!document.getElementById(prefix + "_editable") || e.altKey || e.keyCode == 20) {            
            if( e.preventDefault ){                        
                e.preventDefault();                 
            }else{                    
                e.cancelBubble = true;
                e.returnValue = false; //IE
            }
            var optionMatch = csBox.findNextKeyMatch( key );
            if( optionMatch != null && optionMatch >= 0 ){            
                if(!csBox.isOpen()){            
                    CSBToggleExpansion(prefix);
                    csBox.isDismissable = true;
                }
                //Scroll with keyInput
                csBox.scrollToOption( optionMatch );
            }
            return false;
        }        
        //if the box is open
        if (csBox.isOpen()) {            
            //if the shiftkey was pressed alone eat the keystroke,
            //if a modifier key is pressed and an arrow, chomp away
            //if control do the same ( if its open we want to be able to do a select all )
            if( e.shiftKey && e.keyCode == 16 || ( e.keyCode >36 && e.keyCode < 41 ) || e.ctrlKey){ 
                if( e.preventDefault ){        
                    e.preventDefault();
                }else{                                        
                    e.cancelBubble = true;
                    e.returnValue = false; //IE
                }   
                return false;
            } 
            
            CSBToggleExpansion( prefix );                                   
        }
        //regular input update state to allow submission if neccessary

        csBox.isNotifyComplete = false;		        
		csBox.isKeyScroll = false;
        CSBHighlightSelection( prefix, null );
        csBox.selectedIdxStore = csBox.selectedIdx = -1;
        csBox.selectedIdStore = csBox.selectedId = null;       
	}
}
/**
 * Size the inputs to fit the text.
 * 
 * An optimum length can be specified in the auiml using
 * optimum-size.  The input box will go no wider if specifed
 * above the minimum size of 126;
 * 
 * @param prefix
 */
function CSBSizeInput( prefix ){
    var selinp = document.getElementById( prefix + "_HTMLSelect");    
    var csBox = getCustomSelectBox( prefix );
    var inpel = document.getElementById( prefix + "_inp");            
    if( inpel && selinp){    
        //if dummy select is bigger than minimum size and
        //dummy select is smaller than optimum length or optLength is less than 126
        // use the dummy select width
        if( selinp.scrollWidth > 126 && (selinp.scrollWidth < csBox.optLength || csBox.optLength < 126) ){
            inpel.style.width = selinp.scrollWidth;
        //if opt size is bigger than minium size and dummy select is bigger than it
        } else if( csBox && csBox.optLength > 126 && selinp.scrollWidth > csBox.optLength ){
            inpel.style.width = csBox.optLength;
        //default to minimum size
        } else {
            inpel.style.width = 126;
        }
        selinp.style.display="none";
    }    
}

/**
 * Build the array of options
 * 
 * @param prefix
 */
function CSBBuildOptions( prefix ){
    var csBox = getCustomSelectBox( prefix );
    if( csBox ){
        for( var i=0;i < csBox.select.childNodes.length; i++){
            var tempOption = new CSBOption(prefix);
            if( csBox.select.childNodes[i].nodeName == "DIV" ){
                tempOption.divId = csBox.select.childNodes[i].firstChild.id;
                tempOption.text = csBox.select.childNodes[i].firstChild.firstChild.data; 
                var tempOptValue = document.getElementById( tempOption.divId + "_val");
                tempOption.value = tempOptValue.value;
                csBox.options.push( tempOption );
            }
        }
    }
}

/**
 * Run any initialization functions.  This is after all the
 * components have been loaded by the browser
 * 
 * @param prefix
 */
function CSBInit( prefix ){    
    var csBox = getCustomSelectBox(prefix);
    //Load this csbox's objects
    csBox.select = document.getElementById(prefix + "_select");
    csBox.input = document.getElementById(prefix + "_inp");    
    csBox.inputStore = document.getElementById(prefix + "_inpstore");    
    csBox.editable = document.getElementById(prefix + "_editable");    
    csBox.HTMLSelect = document.getElementById(prefix + "_HTMLSelect");    
    CSBSizeInput(prefix);
    CSBBuildOptions( prefix );
}

/**
 * get the real offsetTop
 */

function getOffsetTop( element ){
    var offsetTop =0;
    while( element ) {
        offsetTop += element.offsetTop;
        element = element.offsetParent;
    }
    return offsetTop;
}

function createCustomSelectBox( prefix, isEditable, hasStatus, maxLength ){
    var csBox = new CustomSelectBox( prefix, isEditable, hasStatus, maxLength );
    allCSBoxes[allCSBoxes.length] = csBox;    
}

function getCustomSelectBox( prefix ) {
   for ( var i=0; i<allCSBoxes.length; i++ ) {
      if ( allCSBoxes[i].prefix == prefix ) {
         return allCSBoxes[i];
      }
   }
   return null;
}

function hideAnyCombo( e ){
    if( allCSBoxes ){        
        //opera fix because it fires onclick when someone clicks on a scrollBar.        
        var seldiv = null;
        if ( e.target && e.target.nodeName == "DIV") {
            seldiv = e.target;            
        }
        //go through all the registered comboboxes and hide them
        for( j=0; j< allCSBoxes.length;j++){
            var csBox = allCSBoxes[j];
            if(csBox){
                if( csBox.isDismissable && csBox.isOpen() && !(seldiv && seldiv.id == csBox.prefix + "_select" )){ 
                    csBox.close();
                } else {                    
                    csBox.isDismissable = true;
                }
            }
        }
    }
}

function CSBMakeAllDismissable(){
    if( allCSBoxes ){
        for( k=0; k< allCSBoxes.length;k++){
            var csBox = allCSBoxes[k];
            if(csBox && csBox.isOpen()){                
                    csBox.isDismissable = true;
            }
        }
    }
}


//store all the select boxes;
var allCSBoxes = new Array();
//see which combobox id was just opened
var justOpenedId = null;
//what components were just hidden?
var hiddenComponents = new Array();
//register onclick to hide the option list
if( document.addEventListener )
    document.addEventListener('click', hideAnyCombo, false);    
else
    document.attachEvent('onclick', hideAnyCombo);


//Combobox option

function CSBOption( prefix ){
    this.prefix = prefix; //Just keep track of what csBox we are of
    this.divId = null; //id of the div holding this option
    this.text = null; //text displayed for this option
    this.value = null; //value associated with this option
}

