# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2007 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#
#
# @(#)70   1.47.1.19   src/csm/install/pkgdefs/Linux-RedHatAS2.1.pm.perl, setup, csm_rfish, rfishs001b 8/22/06 05:01:49

#--------------------------------------------------------------------------------

=head3	Linux-RedHatAS2.1.pm.perl  

        Package Definition File:   RedHatAS 2.1

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [MgmtServer | MgdNode ]
                $::csm_version  = [1.3.0 | 1.3.1 | 1.3.2 | ... ]


        exceptions:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,
	otherwise the execption assignment will be overwriten by the default.

	OTHER DOCUMENTATION - see pkgdefs/Linux.pm

=cut

#--------------------------------------------------------------------------------

# houskeeping

package RedHatAS21;

do "/opt/csm/install/pkgdefs/Linux-RedHatEL2.1.pm";

MessageUtils->messageFromCat(
							 'csmInstall.cat',
							 $::MSGMAPPATH,
							 'csminstall',
							 'V',
							 'IMsgLoading',
							 "/opt/csm/install/pkgdefs/Linux-RedHatAS2.1.pm"
							);

my $_server_  = 'MgmtServer';
my $_node_    = 'MgdNode';
my $_iserver_ = 'InstallServer';

# where this distribution is supported
$::pkgdefs{'where_supported'} = ['MgdNode'];

#--------------------------------------------------------------------------------

=head3	DISTRO Defintions

	Notes :

=cut

#--------------------------------------------------------------------------------
{

	# distribution name
	$::pkgdefs{DISTRO_NAME} = "Red Hat Linux Advanced Server 2.1";

	$::pkgdefs{DISTRO_DISKLIST} = "1 2";           # TO BE REMOVED

	# directory on CDs which contains rpm packages
	$::pkgdefs{DISTRO_RPMDIR}   = "RedHat/RPMS";

}

#--------------------------------------------------------------------------------

=head3  distro_disks - Distribution Disk Defines

    Distribution Disk descriptions used to prompt for the CD-ROMs
    during installation.

    One stanza per CDROM:

        num                     = the number on the CD-ROM's label
        name                    = the text string describing the CD-ROM
        diskid_searchargs       = the arguments be searched to identify the disk
            file    - specific file on the disk
            key	    - specific contents of this file

        diskid_searchprog       = the subroutine be used when identifying the disk
        diskid_target		= the target this disk would be copied to

=cut

#--------------------------------------------------------------------------------
{
	my $dd_ref = [
		{
		 num  => '1',
		 name => $::pkgdefs{DISTRO_NAME},

		 #diskid_filename     => '.disc1-i386',
		 #diskid_searchstring => '',
		 diskid_searchargs => {
							   file => '.disc1-i386',
							   key  => '1020464629.319525',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => 'RedHatAS2.1-i386',
		},
		{
		 num  => '2',
		 name => $::pkgdefs{DISTRO_NAME},

		 #diskid_filename     => '.disc2-i386',
		 #diskid_searchstring => '',
		 diskid_searchargs => {
							   file => '.disc2-i386',
							   key  => '1020464629.319525',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => 'RedHatAS2.1-i386',
		},
		{
		 num  => '3',
		 name => $::pkgdefs{DISTRO_NAME},

		 #diskid_filename     => '.disc2-i386',
		 #diskid_searchstring => '',
		 diskid_searchargs => {
							   file => '.disc3-i386',
							   key  => '1020464629.319525',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => 'RedHatAS2.1-i386',
		},
	];

	$::pkgdefs{distro_disks} = $dd_ref;
}

#--------------------------------------------------------------------------------

=head3	Service Pack disks defination

        Distribution QU Disk descriptions used to prompt for the CD-ROMs
        during installation.

        One stanza per CDROM:

            num                     = the number on the CD-ROM's label
            name                    = the text string describing the CD-ROM
            diskid_searchargs       = the arguments be searched to identify the disk
                file    - specific file on the disk
                key	    - specific contents of this file

            diskid_searchprog       = the subroutine be used when identifying the disk
            diskid_target		= the target this disk would be copied to

=cut

#--------------------------------------------------------------------------------
{
	my $qu2_ref = [
		{
		 num               => '1',
		 name              => $::pkgdefs{DISTRO_NAME} . ' QU2',
		 diskid_searchargs => {
							   file => '.disc1-i386',
							   key  => '1054091198.158084',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => 'RedHatAS2.1-QU2',
		},

		{
		 num               => '2',
		 name              => $::pkgdefs{DISTRO_NAME} . ' QU2',
		 diskid_searchargs => {
							   file => '.disc2-i386',
							   key  => '1054091198.158084',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => 'RedHatAS2.1-QU2',
		},

		{
		 num               => '3',
		 name              => $::pkgdefs{DISTRO_NAME} . ' QU2',
		 diskid_searchargs => {
							   file => '.disc3-i386',
							   key  => '1054091198.158084',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => 'RedHatAS2.1-QU2',
		},
	];

	$::pkgdefs{sp_disks}{QU2} = $qu2_ref;
}

#--------------------------------------------------------------------------------
{
	my $qu4_ref = [
		{
		 num               => '1',
		 name              => $::pkgdefs{DISTRO_NAME} . ' QU4',
		 diskid_searchargs => {
							   file => '.disc1-i386',
							   key  => '1083183287.924640',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => 'RedHatAS2.1-QU4',
		},

		{
		 num               => '2',
		 name              => $::pkgdefs{DISTRO_NAME} . ' QU4',
		 diskid_searchargs => {
							   file => '.disc2-i386',
							   key  => '1083183287.924640',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => 'RedHatAS2.1-QU4',
		},

		{
		 num               => '3',
		 name              => $::pkgdefs{DISTRO_NAME} . ' QU4',
		 diskid_searchargs => {
							   file => '.disc3-i386',
							   key  => '1083183287.924640',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => 'RedHatAS2.1-QU4',
		},

		{
		 num               => '4',
		 name              => $::pkgdefs{DISTRO_NAME} . ' QU4',
		 diskid_searchargs => {
							   file => '.disc4-i386',
							   key  => '1083183287.924640',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => 'RedHatAS2.1-QU4',
		},
	];

	$::pkgdefs{sp_disks}{QU4} = $qu4_ref;
}

#--------------------------------------------------------------------------------
{
	my $qu5_ref = [
		{
		 num               => '1',
		 name              => $::pkgdefs{DISTRO_NAME} . ' QU5',
		 diskid_searchargs => {
							   file => '.disc1-i386',
							   key  => '1092171318.467063',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => 'RedHatAS2.1-QU5',
		},

		{
		 num               => '2',
		 name              => $::pkgdefs{DISTRO_NAME} . ' QU5',
		 diskid_searchargs => {
							   file => '.disc2-i386',
							   key  => '1092171318.467063',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => 'RedHatAS2.1-QU5',
		},

		{
		 num               => '3',
		 name              => $::pkgdefs{DISTRO_NAME} . ' QU5',
		 diskid_searchargs => {
							   file => '.disc3-i386',
							   key  => '1092171318.467063',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => 'RedHatAS2.1-QU5',
		},
	];

	$::pkgdefs{sp_disks}{QU5} = $qu5_ref;
}


1;    # end
