# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2006,2007 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 

# @(#)94   1.5   src/csm/install/pkgdefs/Linux-RedHatEL-Server5-x86_64.pm.perl, setup, csm_rfish, rfishs001b 2/28/07 03:45:49
#--------------------------------------------------------------------------------

=head3	Linux-RedHatEL-Server5-x86_64.pm.perl

        Package Definition File:    RedHatEL 5 x86_64

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [MgmtServer | MgdNode ]
                $::csm_version  = [1.3.0 | 1.3.1 | 1.3.2 | ... ]


        exceptions:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,
	otherwise the execption assignment will be overwriten by the default.

	OTHER DOCUMENTATION - see pkgdefs/Linux.pm

=cut

#--------------------------------------------------------------------------------

# houskeeping

package RedHatELServer5;

my $progdir = $0;
$progdir =~ s/\/[^\/]*$/\//g;
if (-e "$progdir/pkgdefs/Linux-RedHatEL5-x86_64.pm")
{
	do "$progdir/pkgdefs/Linux-RedHatEL5-x86_64.pm";
}
else
{
	do "/opt/csm/install/pkgdefs/Linux-RedHatEL5-x86_64.pm";
}

MessageUtils->messageFromCat(
						 'csmInstall.cat',
						 $::MSGMAPPATH,
						 'csminstall',
						 'V',
						 'IMsgLoading',
						 "/opt/csm/install/pkgdefs/Linux-RedHatEL-Server5-x86_64.pm"
);

my $_server_  = 'MgmtServer';
my $_node_    = 'MgdNode';
my $_iserver_ = 'InstallServer';
$::pkgdefs{'where_supported'} = ['MgmtServer', 'InstallServer', 'MgdNode'];

#--------------------------------------------------------------------------------

=head3	DISTRO Defintions

	Notes :

=cut

#--------------------------------------------------------------------------------
{

	$::pkgdefs{DISTRO_NAME} = "Red Hat Enterprise Linux Server 5 x86_64";
	$::pkgdefs{DISTRO_DISKLIST} = "1 2 3 4 5";     # TO BE REMOVED
	$::pkgdefs{DISTRO_RPMDIR}   = "Server";

}

#--------------------------------------------------------------------------------

=head3  distro_disks - Distribution Disk Defines

        Distribution Disk descriptions used to prompt for the CD-ROMs
        during installation.

        One stanza per CDROM:

                num                     = the number on the CD-ROM's label
                name                    = the text string describing the CD-ROM
                diskid_filename         = the filename to search to identify the disk
                                          - supportsw shell wildcards.
                diskid_searchstring     = the string to search for in diskid_filename
                                          - supports perl regular expressions


=cut

#--------------------------------------------------------------------------------
{
	my $dd_ref = [
				  {
				   num               => '1',
				   name              => $::pkgdefs{DISTRO_NAME},
				   diskid_searchargs => {
									   file => '.discinfo',
									   num  => '1',
									   arch => 'x86_64',
									   key  => '1170978545.752040',
									   rpm  => 'Server/redhat-release-5Server-5.0.0.9.x86_64.rpm',
				   },
				   diskid_searchprog => \&Linux::rhel_diskid_match_prog,
				   diskid_target     => 'RedHatEL-Server5-x86_64',
				  },
				  {
				   num               => '2',
				   name              => $::pkgdefs{DISTRO_NAME},
				   diskid_searchargs => {
										 file => '.discinfo',
										 num  => '2',
										 arch => 'x86_64',
										 key  => '1170978545.752040',
										 rpm  => '',
										},
				   diskid_searchprog => \&Linux::rhel_diskid_match_prog,
				   diskid_target     => 'RedHatEL-Server5-x86_64',
				  },
				  {
				   num               => '3',
				   name              => $::pkgdefs{DISTRO_NAME},
				   diskid_searchargs => {
										 file => '.discinfo',
										 num  => '3',
										 arch => 'x86_64',
										 key  => '1170978545.752040',
										 rpm  => '',
										},
				   diskid_searchprog => \&Linux::rhel_diskid_match_prog,
				   diskid_target     => 'RedHatEL-Server5-x86_64',
				  },
				  {
				   num               => '4',
				   name              => $::pkgdefs{DISTRO_NAME},
				   diskid_searchargs => {
										 file => '.discinfo',
										 num  => '4',
										 arch => 'x86_64',
										 key  => '1170978545.752040',
										 rpm  => '',
										},
				   diskid_searchprog => \&Linux::rhel_diskid_match_prog,
				   diskid_target     => 'RedHatEL-Server5-x86_64',
				  },
				  {
				   num               => '5',
				   name              => $::pkgdefs{DISTRO_NAME},
				   diskid_searchargs => {
										 file => '.discinfo',
										 num  => '5',
										 arch => 'x86_64',
										 key  => '1170978545.752040',
										 rpm  => '',
										},
				   diskid_searchprog => \&Linux::rhel_diskid_match_prog,
				   diskid_target     => 'RedHatEL-Server5-x86_64',
				  },
                  {   
				   num               => '6',
				   name              => $::pkgdefs{DISTRO_NAME},
                   is_extracd        => '1',
				   diskid_searchargs => {
										 file => '.discinfo',
										 num  => '6',
										 arch => 'x86_64',
										 key  => '1170978545.752040',
										 rpm  => '',
										},
				   diskid_searchprog => \&Linux::rhel_diskid_match_prog,
				   diskid_target     => 'RedHatEL-Server5-x86_64',
				  },
				 ];

	$::pkgdefs{distro_disks} = $dd_ref;
}

#--------------------------------------------------------------------------------

=head3  csm_bin_copy_tftpboot

        CSM binaries copied to /tftpboot directory
        Notes :

=cut

#--------------------------------------------------------------------------------
{

        my %a_ref;
        my $_distro_sl = $::ATTRS{"InstallServiceLevel"};
        if ($_distro_sl eq "")
        {
                my $disable_warning_msg = 1;
                # disable waring msg from subroutine get_ServiceLevel 
                $_distro_sl = NodeUtils->get_ServiceLevel($disable_warning_msg);
        }

        $a_ref{$_distro_sl} = ['/usr/lib/syslinux/pxelinux.0'];

        $::pkgdefs{csm_bin_copy_tftpboot} = $a_ref{$_distro_sl};

}

1;    # end
