# @(#)61   1.2   src/csm/install/pkgdefs/Linux-RedHatEL2.1.pm.perl, setup, csm_rfish, rfishs001b 3/26/06 23:29:31
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2006,2007 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#--------------------------------------------------------------------------------

=head3	Linux-RedHatEL2.1.pm.perl

        Package Definition File:    RedHat 2.1 i386

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [ MgmtServer | MgdNode ]
                $::csm_version  = [ 1.3.0 | 1.3.1 | 1.3.2 | ... ]


        exceptions:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,
	otherwise the execption assignment will be overwriten by the default.

	OTHER DOCUMENTATION - see pkgdefs/Linux.pm

=cut

#--------------------------------------------------------------------------------

package RedHatEL21;

#--------------------------------------------------------------------------------

=head3  simple common attributes	

        Notes:

=cut

#--------------------------------------------------------------------------------

{
    # install package architecture
    $::pkgdefs{'arch'} = 'i386';
    
    # the directory where kernel and initrd (or zImage) is placed is CD
    $::pkgdefs{'install_image_dir'} = "isolinux";
    
    # the file name of kernel in CD
    $::pkgdefs{'kernel_file_name'} = "vmlinuz";
    
    # the file name of initrd (or zImage) in CD
    $::pkgdefs{'initrd_file_name'} = "initrd.img";

    # the network installation method
    $::pkgdefs{'install_method'} = 'kickstart';
                           
}

my $progdir = $0;
$progdir =~ s/\/[^\/]*$/\//g;
if (-e "$progdir/pkgdefs/Linux.pm")
{
	do "$progdir/pkgdefs/Linux.pm";
}
else
{
	do "/opt/csm/install/pkgdefs/Linux.pm";
}

MessageUtils->messageFromCat(
							 'csmInstall.cat',
							 $::MSGMAPPATH,
							 'csminstall',
							 'V',
							 'IMsgLoading',
							 "/opt/csm/install/pkgdefs/Linux-RedHatEL2.1.pm"
							);

my $_server_  = 'MgmtServer';
my $_node_    = 'MgdNode';
my $_iserver_ = 'InstallServer';

#--------------------------------------------------------------------------------

=head3	os_prereqs - Operating System pre-requisites

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $distroName = $::pkgdefs{pkgdefs_distro_name};
	my %ospr_ref;

	my $perl_pkg = new Rpm( 'perl', '5');
	my $pdksh_pkg = new Rpm( 'pdksh');
	my $nfs_utils_pkg = new Rpm( 'nfs-utils');
	my $rdist_pkg = new Rpm( 'rdist', '6');
	my $tcl_pkg = new Rpm( 'tcl', '8.3');
	my $tk_pkg = new Rpm( 'tk', '8.3');
	my $expect_pkg = new Rpm( 'expect', '5.38');
	my $freetype_pkg = new Rpm( 'freetype', '2.1');
	my $xfree86_libs_pkg = new Rpm( 'XFree86-libs', '4.1');

	my $dhcp_pkg = new Rpm( 'dhcp', '3');

	my $perl_libnet_pkg = new Rpm( 'perl-libnet', '1.07');
	my $perl_db_file_pkg = new Rpm( 'perl-DB_File');

	$ospr_ref{$_server_} = new RpmList(
			'Management Server Operating System Prerequisites Packages',
			$perl_pkg,
			$pdksh_pkg,
			$rdist_pkg,
			$tcl_pkg,
			$tk_pkg,
			$expect_pkg,
			$xfree86_libs_pkg,
			$freetype_pkg,
			$nfs_utils_pkg
	);

	$ospr_ref{$_iserver_} = new RpmList(
			'Install Server Operating System Prerequisites Packages',
			$nfs_utils_pkg,
			$dhcp_pkg
	);


	$ospr_ref{$_node_} = new RpmList(
			'Managed Node Operating System Prerequisites Packages',
			$perl_pkg,
			$nfs_utils_pkg,
			$pdksh_pkg,
			$rdist_pkg,
			$perl_libnet_pkg,
			$perl_db_file_pkg
	);

	$ospr_ref{$_server_}->setContainedInCds(1);
	$ospr_ref{$_iserver_}->setContainedInCds(1);
	$ospr_ref{$_node_}->setContainedInCds(1);

	my $lsof_pkg = new Rpm( 'lsof', '4.51');
    if ($distroName =~ m/ES$/)
    {
        $ospr_ref{$_server_}->addRpm( $lsof_pkg);
    }

	$::pkgdefs{'pkgs'}{$_server_}{$::OS_PREREQ_PKGS} = $ospr_ref{$_server_};
	$::pkgdefs{'pkgs'}{$_iserver_}{$::OS_PREREQ_PKGS} = $ospr_ref{$_iserver_};
	$::pkgdefs{'pkgs'}{$_node_}{$::OS_PREREQ_PKGS} = $ospr_ref{$_node_};

}
#-------------------------------------------------------------------------------

=head3	getmacs_Exec

        Notes:	non-eth0 support

=cut

#--------------------------------------------------------------------------------
{
	my $ge_ref = [
				  'usr/bin/grep', 'usr/sbin/ifconfig',
				  'usr/bin/sed',  'usr/bin/sleep',
				  'usr/bin/bash'
				 ];

	$::pkgdefs{getmacs_Exec} = $ge_ref;
}

#--------------------------------------------------------------------------------

=head3 getmacs_RamDiskSize

	Nodes: if this attributes defined, it will replace the value given by
               getGetmacsRAMDiskSize

=cut

#--------------------------------------------------------------------------------
{
	$::pkgdefs{'getmacs_RamDiskSize'};
}

#--------------------------------------------------------------------------------

=head3	getmacs_Lib

        Notes:	non-eth0 support

=cut

#--------------------------------------------------------------------------------
{
	my $gl_ref = '/lib';

	$::pkgdefs{getmacs_Lib} = $gl_ref;
}

#--------------------------------------------------------------------------------

=head3	getmacs_ReqLibs

        Notes:	non-eth0 support

=cut

#--------------------------------------------------------------------------------
{
	my $gr_ref = [
				  '/lib/ld-linux.so.2', '/lib/libc.so.6',
				  '/lib/libdl.so.2',    '/lib/libtermcap.so.2'
				 ];

	$::pkgdefs{getmacs_ReqLibs} = $gr_ref;
}

#--------------------------------------------------------------------------------

=head3	getmacs_DirStructure

        Notes:	non-eth0 support

=cut

#--------------------------------------------------------------------------------
{
	my $gd_ref = [
				  "bin",  "etc",      "linuxrc", "modules",
				  "proc", ".profile", "sbin",    "tmp",
				  "var"
				 ];

	$::pkgdefs{getmacs_DirStructure} = $gd_ref;
}

#-------------------------------------------------------------------------------

=head3 kernel_arch_dir

        Notes: the architecture directory for drivers

=cut

#--------------------------------------------------------------------------------
{
	my $kernel_arch_dir = {
						   'default'  => 'i386',
						  };
	$::pkgdefs{'kernel_arch_dir'} = $kernel_arch_dir;
}

#--------------------------------------------------------------------------------

=head3 ramdisk_size

        Notes: the ramdisk size

=cut

#---------------------------------------------------------------------------------
{
	$::pkgdefs{'ramdisk_size'} = 7120;
}

#--------------------------------------------------------------------------------


=head3  hwmaint_Exec

        Notes:  Prerequisite exec utilities for hwmaint. Will be copied to preinstall
		ramdisk:/bin.

=cut

#--------------------------------------------------------------------------------
{
	$::pkgdefs{hwmaint_Exec};
}

#--------------------------------------------------------------------------------

=head3  hwmaint_ReqLibs

        Notes:  Prerequisite libs for hwmaint. Will be copied to preinstall
		ramdisk:/lib.

=cut

#--------------------------------------------------------------------------------
{
	$::pkgdefs{hwmaint_ReqLibs};
}

#--------------------------------------------------------------------------------

=head3  install_kernel_parameter

        Notes:  the strings used to be inserted into PXE config file

=cut

#--------------------------------------------------------------------------------
{
    $::pkgdefs{'install_kernel_parameter'}{'e326'}{'46Z'}{'GA'} = 'blank';
    $::pkgdefs{'install_kernel_parameter'}{'8835'}{'all_models'}{'GA'} = 'hpet=disable acpi=noirq';
    $::pkgdefs{'install_kernel_parameter'}{'8848'}{'all_models'}{'GA'} = 'hpet=disable acpi=noirq';
    $::pkgdefs{'install_kernel_parameter'}{'e325'}{'all_models'}{'GA'} = 'hpet=disable acpi=noirq';
    $::pkgdefs{'install_kernel_parameter'}{'e326'}{'all_models'}{'GA'} = 'hpet=disable acpi=noirq';
    $::pkgdefs{'install_kernel_parameter'}{'8843'}{'all_models'}{'all_svclevels'} = 'n8r acpi=noirq';
}

#--------------------------------------------------------------------------------

=head3  hwmaintain_kernel_parameter

        Notes:  the strings used by hardware maintainance

=cut

#--------------------------------------------------------------------------------
{
    $::pkgdefs{'hwmaintain_kernel_parameter'}{'e326'}{'46Z'}{'GA'} = 'blank';
    $::pkgdefs{'hwmaintain_kernel_parameter'}{'8835'}{'all_models'}{'GA'} = 'hpet=disable acpi=noirq';
    $::pkgdefs{'hwmaintain_kernel_parameter'}{'8848'}{'all_models'}{'GA'} = 'hpet=disable acpi=noirq';
    $::pkgdefs{'hwmaintain_kernel_parameter'}{'e325'}{'all_models'}{'GA'} = 'hpet=disable acpi=noirq';
    $::pkgdefs{'hwmaintain_kernel_parameter'}{'e326'}{'all_models'}{'GA'} = 'hpet=disable acpi=noirq';
}

1;    # end
