# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2006,2007 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 

# @(#)78   1.1.1.2   src/csm/install/pkgdefs/Linux-RedHatEL5-ppc64.pm.perl, setup, csm_rfish, rfishs001b 1/9/07 03:57:56
#--------------------------------------------------------------------------------

=head3	Linux-RedHatEL5-ppc64.pm.perl

        Package Definition File:   RedHatEL 5 ppc

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [ MgmtServer | MgdNode ]
                $::csm_version  = [1.3.0 | 1.3.1 | 1.3.2 | ... ]


        exceptions:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,
	otherwise the execption assignment will be overwriten by the default.

	OTHER DOCUMENTATION - see pkgdefs/Linux.pm

=cut

#--------------------------------------------------------------------------------

package RedHatELAS5ppc64;

#--------------------------------------------------------------------------------

=head3  simple common attributes

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    # install package architecture
    $::pkgdefs{'arch'} = 'ppc64';

    # the directory where kernel and initrd (or zImage) is placed is CD
    $::pkgdefs{'install_image_dir'} = "images/netboot";

    # the file name of kernel in CD
    $::pkgdefs{'kernel_file_name'} = "ppc64.img";

    # the file name of initrd (or zImage) in CD
    $::pkgdefs{'initrd_file_name'} = "ppc64.img";

    # the network installation method
    $::pkgdefs{'install_method'} = 'kickstart';

    # additional options for "rpm" command
    $::pkgdefs{'additionalRpmCmdOptions'} = '--nosignature';
}

my $progdir = $0;
$progdir =~ s/\/[^\/]*$/\//g;
if (-e "$progdir/pkgdefs/Linux.pm")
{
	do "$progdir/pkgdefs/Linux.pm";
}
else
{
	do "/opt/csm/install/pkgdefs/Linux.pm";
}

MessageUtils->messageFromCat(
						  'csmInstall.cat',
						  $::MSGMAPPATH,
						  'csminstall',
						  'V',
						  'IMsgLoading',
						  "/opt/csm/install/pkgdefs/Linux-RedHatEL5-ppc64.pm"
);

my $_server_  = 'MgmtServer';
my $_node_    = 'MgdNode';
my $_iserver_ = 'InstallServer';

#--------------------------------------------------------------------------------

=head3	csm_bin_copy_tftpboot

        Notes: CSM binaries copied to /tftpboot directory

=cut

#--------------------------------------------------------------------------------
{
	my $a_ref;

	# defaults
	$a_ref = [];

	# exceptions  - must follow the default assignments.
	# none

	$::pkgdefs{csm_bin_copy_tftpboot} = $a_ref;
}

#--------------------------------------------------------------------------------

=head3	os_prereqs - Operating System pre-requisites

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my %ospr_ref;

    my $perl_pkg = new Rpm( 'perl', '5');
    my $ksh_pkg = new KshRpm( 'ksh');
    my $nfs_utils_pkg = new Rpm( 'nfs-utils');
    my $rdist_pkg = new Rpm( 'rdist', '6');
    my $tcl_pkg = new Rpm( 'tcl', '8.4');
    my $tk_pkg = new Rpm( 'tk', '8.4', 'ppc');
    my $expect_pkg = new Rpm( 'expect', '5.42');
    my $freetype_pkg = new Rpm( 'freetype', '2.1');
    my $compat_libstdc296_pkg = new Rpm( 'compat-libstdc++-296', undef, 'ppc');
    my $compat_libstdc33_pkg = new Rpm( 'compat-libstdc++-33', undef, 'ppc');
    my $snmp_pkg = new Rpm( 'net-snmp');
    my $snmp_utils_pkg = new Rpm( 'net-snmp-utils');

    my $dhcp_pkg = new Rpm( 'dhcp', '3');

    my $sg3_utils_pkg = new Rpm( 'sg3_utils');
    my $sg3_utils_libs_pkg = new Rpm( 'sg3_utils-libs');
    my $createrepo = new Rpm( 'createrepo');
	my $libxml2_python = new Rpm( 'libxml2-python');

    # IBMJava2-JRE-ppc needs libXp.so.6 ...
    my $libxp_pkg = new Rpm('libXp',undef,'ppc');

    $ospr_ref{$_server_} = new RpmList(
			'Management Server Operating System Prerequisites Packages',
            $perl_pkg,
            $ksh_pkg,
            $nfs_utils_pkg,
            $rdist_pkg,
            $tcl_pkg,
            $tk_pkg,
            $expect_pkg,
            $freetype_pkg,
            $compat_libstdc296_pkg,
            $compat_libstdc33_pkg,
            $libxp_pkg,
    	    $libxml2_python,
			$createrepo
            );

    $ospr_ref{$_iserver_} = new RpmList(
			'Install Server Operating System Prerequisites Packages',
            $nfs_utils_pkg,
            $dhcp_pkg,
			$snmp_pkg,
			$snmp_utils_pkg,
			new TftpRpm('tftp-server'),
            $libxp_pkg,
			$libxml2_python,
			$createrepo
            );

    $ospr_ref{$_node_} = new RpmList(
			'Managed Node Operating System Prerequisites Packages',
            $perl_pkg,
            $nfs_utils_pkg,
            $ksh_pkg,
            $rdist_pkg,
            $compat_libstdc296_pkg,
            $compat_libstdc33_pkg,
            $sg3_utils_pkg,
            $sg3_utils_libs_pkg,
            );
    $ospr_ref{$_server_}->setContainedInCds(1);
    $ospr_ref{$_iserver_}->setContainedInCds(1);
    $ospr_ref{$_node_}->setContainedInCds(1);

    $::pkgdefs{'pkgs'}{$_server_}{$::OS_PREREQ_PKGS} = $ospr_ref{$_server_};
    $::pkgdefs{'pkgs'}{$_iserver_}{$::OS_PREREQ_PKGS} = $ospr_ref{$_iserver_};
    $::pkgdefs{'pkgs'}{$_node_}{$::OS_PREREQ_PKGS} = $ospr_ref{$_node_};

}

#-------------------------------------------------------------------------------

=head3	apache_packages

        Notes:	List of packages that comprise the Apache http server.
                These packages will always get copied, but will only be 
                installed if SetupNetworkInstallProtocol=1.

=cut

#-------------------------------------------------------------------------------
{
    my $apache_ref = new RpmList(
			'Install Server HTTP Server Packages',
            new Rpm( 'httpd', '2'),
            new Rpm( 'apr', '', 'ppc'),
            new Rpm( 'apr-util'),
            new Rpm( 'postgresql-libs')
            );
    $apache_ref->setContainedInCds(1);

    $::pkgdefs{'pkgs'}{$_iserver_}{$::HTTP_SERVER_PKGS} = $apache_ref;
}

#--------------------------------------------------------------------------------

=head3  install_kernel_parameter

        Notes:  the strings used to be inserted into PXE config file

=cut

#--------------------------------------------------------------------------------
{
    $::pkgdefs{'install_kernel_parameter'}{'8843'}{'all_models'}{'all_svclevels'} = 'n8r acpi=noirq';
    $::pkgdefs{'install_kernel_parameter'}{'8676'}{'61x'}{'GA'} = 'acpi=noirq';
}

#--------------------------------------------------------------------------------

=head3  hwmaintain_kernel_parameter

        Notes:  the strings used by hardware maintainance

=cut

#--------------------------------------------------------------------------------
{
    $::pkgdefs{'hwmaintain_kernel_parameter'};
    # until CSM 1.6.0, no special string is required.
}

1;    # end

