# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2006,2007 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 

#############################################################
# @(#)33   1.10.1.2   src/csm/install/pkgdefs/Linux-SLES10.pm.perl, setup, csm_rfish, rfishs001b 3/5/07 03:02:15
#############################################################
#--------------------------------------------------------------------------------

=head3  Linux-SLES10.pm.perl

        Package Definition File:    SLES 10

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [ MgmtServer | MgdNode ]
                $::csm_version  = [ 1.3.0 | 1.3.1 | 1.3.2 | ... ]


        exceptions:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

        The approach uses $::csm_version to set default values for both server and
        node defines.  It allows for execptions to these default values by defining
        specific csm versions assignments which overwrite the defaults when
        $::csm_version is equal to the execption's version number.

        ORDER IS IMPORTANT:
        As noted in the code, any excptions must follow the default assignments,
        otherwise the execption assignment will be overwriten by the default.

        OTHER DOCUMENTATION - see pkgdefs/Linux.pm

=cut

#--------------------------------------------------------------------------------

# houskeeping

package SLES10;

#--------------------------------------------------------------------------------

=head3  simple common attributes

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    # install package architecture
    $::pkgdefs{'arch'} = 'i386';

    # the directory where kernel and initrd (or zImage) is placed is CD
    $::pkgdefs{'install_image_dir'} = "boot/i386/loader";

    # the file name of kernel in CD
    $::pkgdefs{'kernel_file_name'} = "linux";

    # the file name of initrd (or zImage) in CD
    $::pkgdefs{'initrd_file_name'} = "initrd";

    # the installing ramdisk format
    $::pkgdefs{'ramdisk_format'} = 'cpio';

    # the network installation method
    $::pkgdefs{'install_method'} = 'autoyast';

    # where this distribution is supported
    $::pkgdefs{'where_supported'} = ['MgmtServer', 'InstallServer',
        'MgdNode', 'diskless'];
}

#--------------------------------------------------------------------------------

=head3  DISTRO Defintions

        Notes :

=cut

#--------------------------------------------------------------------------------
{
	# distribution name
	$::pkgdefs{DISTRO_NAME}     = "SuSE SLES 10";

	$::pkgdefs{DISTRO_DISKLIST} = "1 2 3";

	# directory on CDs which contains rpm packages
	$::pkgdefs{DISTRO_RPMDIR}   = "suse/*";

}

my $_server_  = 'MgmtServer';
my $_node_    = 'MgdNode';
my $_iserver_ = 'InstallServer';

my $progdir = $0;
$progdir =~ s/\/[^\/]*$/\//g;
if (-e "$progdir/pkgdefs/Linux.pm")
{
	do "$progdir/pkgdefs/Linux.pm";
}
else
{
	do "/opt/csm/install/pkgdefs/Linux.pm";
}

MessageUtils->messageFromCat(
							 'csmInstall.cat',
							 $::MSGMAPPATH,
							 'csminstall',
							 'V',
							 'IMsgLoading',
							 "/opt/csm/install/pkgdefs/Linux-SLES10.pm"
							);


#--------------------------------------------------------------------------------

=head3  distro_disks - Distribution Disk Defines

    Distribution Disk descriptions used to prompt for the CD-ROMs
    during installation.

    One stanza per CDROM:

        num                     = the number on the CD-ROM's label
        name                    = the text string describing the CD-ROM
        diskid_searchargs       = the arguments be searched to identify the disk
            file    - specific file on the disk
            key	    - specific contents of this file

        diskid_searchprog       = the subroutine be used when identifying the disk
        diskid_target		= the target this disk would be copied to

=cut

#--------------------------------------------------------------------------------
{
	my $dd_ref = [
				  {
				   num               => '1',
				   name              => $::pkgdefs{DISTRO_NAME},
				   diskid_searchargs => {
										 file => 'media.1/products',
										 key  => '/ SUSE-Linux-Enterprise-Server-i386 10',
										},
				   diskid_searchprog => \&Linux::linux_diskid_match_prog,
				   diskid_target     => "CD1",
				  },
				  {
				   num               => '2',
				   name              => $::pkgdefs{DISTRO_NAME},
				   diskid_searchargs => {
										 file => 'media.2/products',
										 key  => '/ SUSE-Linux-Enterprise-Server-i386 10',
										},
				   diskid_searchprog => \&Linux::linux_diskid_match_prog,
				   diskid_target     => "CD2",
				  },
				  {
				   num               => '3',
				   name              => $::pkgdefs{DISTRO_NAME},
				   diskid_searchargs => {
										 file => 'media.3/products',
										 key  => '/ SUSE-Linux-Enterprise-Server-i386 10',
										},
				   diskid_searchprog => \&Linux::linux_diskid_match_prog,
				   diskid_target     => "CD3",
				  },
				  {
				   num               => '4',
				   name              => $::pkgdefs{DISTRO_NAME},
				   diskid_searchargs => {
										 file => 'media.4/products',
										 key  => '/ SUSE-Linux-Enterprise-Server-i386 10',
										},
				   diskid_searchprog => \&Linux::linux_diskid_match_prog,
				   diskid_target     => "CD4",
				  },
				 ];

	$::pkgdefs{distro_disks} = $dd_ref;
}

#--------------------------------------------------------------------------------

=head3  Service Pack disks defination

        Distribution SP Disk descriptions used to prompt for the CD-ROMs
        during installation.

        One stanza per CDROM:

            num                     = the number on the CD-ROM's label
            name                    = the text string describing the CD-ROM
            diskid_searchargs       = the arguments be searched to identify the disk
                file    - specific file on the disk
                key	    - specific contents of this file

            diskid_searchprog       = the subroutine be used when identifying the disk
            diskid_target		= the target this disk would be copied to

=cut

#--------------------------------------------------------------------------------
{
	my $sp1_ref = [
				   {
					num               => '1',
					name              => "SuSE SLES 10 SP1",
					diskid_searchargs => {
										  file1 => 'media.1/products',
										  key1  => '/ SUSE-Linux-Enterprise-Server-SP1 10.1-0',
										  file2 => 'content',
										  key2  => 'DEFAULTBASE i586',
										 },
					diskid_searchprog => \&Linux::linux_diskid_match_prog,
					diskid_target     => "CD1",
				   },
				   {
					num               => '2',
					name              => "SuSE SLES 10 SP1",
					diskid_searchargs => {
										  file1 => 'media.2/products',
										  key1  => '/ SUSE-Linux-Enterprise-Server-SP1 10.1-0',
										  file2 => 'content',
										  key2  => 'DEFAULTBASE i586',
										 },
					diskid_searchprog => \&Linux::linux_diskid_match_prog,
					diskid_target     => "CD2",
				   },
				   {
					num               => '3',
					name              => "SuSE SLES 10 SP1",
					diskid_searchargs => {
										  file1 => 'media.3/products',
										  key1  => '/ SUSE-Linux-Enterprise-Server-SP1 10.1-0',
										  file2 => 'content',
										  key2  => 'DEFAULTBASE i586',
										 },
					diskid_searchprog => \&Linux::linux_diskid_match_prog,
					diskid_target     => "CD3",
				   },
				   {
					num               => '4',
					name              => "SuSE SLES 10 SP1",
					diskid_searchargs => {
										  file1 => 'media.4/products',
										  key1  => '/ SUSE-Linux-Enterprise-Server-SP1 10.1-0',
										  file2 => 'content',
										  key2  => 'DEFAULTBASE i586',
										 },
					diskid_searchprog => \&Linux::linux_diskid_match_prog,
					diskid_target     => "CD4",
				   }
				  ];

	$::pkgdefs{sp_disks}{SP1} = $sp1_ref;
}

#--------------------------------------------------------------------------------

=head3  os_prereqs - Operating System pre-requisites

        Notes:
            Packages of the OS that needed to install CSM. There are three classes:
            for CSM installed on MS, for CSM installed on IS and for CSM installed
            on MN. These packages will always get copied, but will only be installed
             in corresponding conditions. 

            The stepes to add a operating system pre-requisites:
            1. Create a Rpm object of the rpm package, such as:
                my $kernel_pkg = new Rpm('kernel', '2.8');
            2. Add this Rpm object to the corresponding RpmList object:
                $ospr_ref{$_server_} = new RpmList(
                        'Management Server Operating System Prerequisites Packages',
                        $perl_pkg,
                        $ksh_pkg,
                        .....
                        $kernel_pkg
                        );
            You must ensure the rpm package be added consisting in the 
            distribution's CD.

=cut

#--------------------------------------------------------------------------------
{

	my %ospr_ref;
    my $perl_pkg = new Rpm( 'perl','5');
    my $ksh_pkg = new Rpm( 'ksh');
    my $nfs_utils_pkg = new Rpm( 'nfs-utils');
    my $rdist_pkg = new Rpm( 'rdist','6.1.5');
    my $tcl_pkg = new Rpm( 'tcl','8');
    my $tk_pkg = new Rpm( 'tk','8');
    my $expect_pkg = new Rpm( 'expect','5.43');
    my $xorg_x11_pkg=  new Rpm( 'xorg-x11');
    my $freetype2_pkg = new Rpm( 'freetype2');
    my $termcap_pkg = new Rpm( 'termcap');
    my $expat_pkg = new Rpm( 'expat');
    my $bootsplash_theme_pkg = new Rpm( 'bootsplash-theme-SuSE-SLES','3');
    my $bootsplash_pkg = new Rpm( 'bootsplash','3');
    my $mtools_pkg = new Rpm( 'mtools','3');
    my $perl_xml_parse_pkg = new Rpm( 'perl-XML-Parser');
    my $perl_xml_dom_pkg = new Rpm( 'perl-XML-DOM');
    my $perl_html_target_pkg = new Rpm( 'perl-HTML-Tagset');
    my $perl_html_parse_pkg = new Rpm( 'perl-HTML-Parser');
    my $perl_uri_pkg = new Rpm( 'perl-URI');
    my $perl_libwww_perl_pkg = new Rpm( 'perl-libwww-perl');
    my $perl_xml_regexp_pkg = new Rpm( 'perl-XML-RegExp');
    my $syslinux_pkg = new Rpm( 'syslinux', '3');
    my $rsh_server_pkg = new Rpm( 'rsh-server');
    my $dhcp_pkg = new Rpm( 'dhcp', '3');
    my $dhcp_server_pkg = new Rpm( 'dhcp-server');
    my $compat_readline_pkg = new Rpm( 'compat-readline4');
    my $snmp_pkg = new Rpm( 'net-snmp');
	my $perl_termreadykey_pkg = new Rpm( 'perl-TermReadKey');

	$ospr_ref{$_server_} = new RpmList(
        'Management Server Operating System Prerequisites Packages',
        $perl_pkg,
        $ksh_pkg,
        $nfs_utils_pkg,
        $rdist_pkg,
        $tcl_pkg,
        $tk_pkg,
        $expect_pkg,
        $xorg_x11_pkg,
        $freetype2_pkg,
        $termcap_pkg,
        $expat_pkg,
        $bootsplash_theme_pkg,
        $bootsplash_pkg,
        $mtools_pkg,
        $perl_xml_parse_pkg,
        $perl_xml_dom_pkg,
        $perl_html_target_pkg,
        $perl_html_parse_pkg,
        $perl_uri_pkg,
        $perl_libwww_perl_pkg,
        $perl_xml_regexp_pkg,
	$compat_readline_pkg
    );

	$ospr_ref{$_iserver_} = new RpmList(
        'Install Server Operating System Prerequisites Packages',
        $nfs_utils_pkg,
        $rdist_pkg,
        $termcap_pkg,
        $expat_pkg,
        $perl_xml_parse_pkg,
        $bootsplash_theme_pkg,
        $bootsplash_pkg,
        $mtools_pkg,
        $perl_xml_dom_pkg,
        $perl_html_target_pkg,
        $perl_html_parse_pkg,
        $perl_uri_pkg,
        $perl_libwww_perl_pkg,
        $perl_xml_regexp_pkg,
        $syslinux_pkg,
        $dhcp_pkg,
        $dhcp_server_pkg,
		$snmp_pkg,
		$perl_termreadykey_pkg,
	$compat_readline_pkg,
		new TftpRpm('tftp')
    );

	$ospr_ref{$_node_} = new RpmList(
        'Managed Node Operating System Prerequisites Packages',
        $perl_pkg,
        $nfs_utils_pkg,
        $ksh_pkg,
        $dhcp_pkg,
        $dhcp_server_pkg,
        $rdist_pkg,
        $tcl_pkg,
        $tk_pkg,
        $expect_pkg,
        $xorg_x11_pkg,
        $freetype2_pkg,
        $rsh_server_pkg
    );
    $ospr_ref{$_server_}->setContainedInCds(1);
    $ospr_ref{$_iserver_}->setContainedInCds(1);
    $ospr_ref{$_node_}->setContainedInCds(1);

	$::pkgdefs{'pkgs'}{$_server_}{$::OS_PREREQ_PKGS} = $ospr_ref{$_server_};
	$::pkgdefs{'pkgs'}{$_iserver_}{$::OS_PREREQ_PKGS} = $ospr_ref{$_iserver_};
	$::pkgdefs{'pkgs'}{$_node_}{$::OS_PREREQ_PKGS} = $ospr_ref{$_node_};

}

#-------------------------------------------------------------------------------

=head3	apache_packages

        Notes:  List of packages that comprise the Apache http server.
                These packages will always get copied, but will only be 
                installed if SetupNetworkInstallProtocol=1.

=cut

#-------------------------------------------------------------------------------
{
	my $apache_ref = new RpmList(
        'Install Server HTTP Server Packages',
	    new Rpm( 'libapr-util1'),
	    new Rpm( 'libapr1'),
	    new Rpm( 'apache2', '2'),
	    new Rpm( 'apache2-worker')
	);
    $apache_ref->setContainedInCds(1);

	$::pkgdefs{'pkgs'}{$_iserver_}{20} = $apache_ref;
}


#--------------------------------------------------------------------------------

=head3  getmacs_Exec

        Notes:  The extra programes needed when CSM try to get MAC address of
            the node's network devices. Those programs would be put into a 
            new ramdisk which be used to boots up nodes and get their MAC address.

=cut

#--------------------------------------------------------------------------------
{

	my $ge_ref =
	  ['bin/grep'];

	$::pkgdefs{getmacs_Exec} = $ge_ref;

}

#--------------------------------------------------------------------------------

=head3  getmacs_Lib

        Notes:  The lib path will be created in the new ramdisk for containing the
            libs that needed by the extra programs for getting MAC address.

=cut

#--------------------------------------------------------------------------------
{

	my $gl_ref = '/lib';

	$::pkgdefs{getmacs_Lib} = $gl_ref;

}

#--------------------------------------------------------------------------------

=head3  getmacs_ReqLibs

        Notes:  The libs needed by the extra programs that be used to get node's
            MAC address. They also would be copied from the preinstall ramdisk 
            into the new ramdisk.

=cut

#--------------------------------------------------------------------------------
{

	my $gr_def = [];

	$::pkgdefs{getmacs_ReqLibs} = $gr_def;

}

#--------------------------------------------------------------------------------

=head3	getmacs_DirStructure

        Notes:	Directories must be created in the new ramdisk for getting MAC
            address from nodes. They will be copied from the preinstall ramdisk 
            of the distribution.

=cut

#--------------------------------------------------------------------------------
{
	my $gd_ref = [];

	$::pkgdefs{getmacs_DirStructure} = $gd_ref;
}

#--------------------------------------------------------------------------------

=head3  hwmaint_Exec

        Notes:  Prerequisite exec utilities for hwmaint. Will be copied to preinstall
		ramdisk:/bin.

=cut

#--------------------------------------------------------------------------------
{
	my $he_ref = [
					'/bin/gzip',
					'/bin/tar',
					'/sbin/ifconfig',
                    '/bin/mount',
					'/bin/awk',
					'/bin/gawk',
					'/bin/mkdir',
					'/usr/bin/tail',
					'/bin/rm',
					'/bin/gunzip',
					'/bin/chmod',
					'/bin/uname',
					'/bin/ls',
					'/bin/cp',
					'/bin/ln',
					'/sbin/portmap'
				 ];

	$::pkgdefs{hwmaint_Exec} = $he_ref;

}

#--------------------------------------------------------------------------------

=head3  hwmaint_ReqLibs

        Notes:  Prerequisite libs for hwmaint. Will be copied to preinstall
		ramdisk:/lib.

=cut

#--------------------------------------------------------------------------------
{
	my $hl_ref = [
					'/lib/libc.so.6',
                    '/usr/lib/libstdc++.so.6',
                    '/lib/libm.so.6',
                    '/lib/libgcc_s.so.1',
					'/lib/libacl.so.1',
					'/lib/libattr.so.1',
					'/lib/libwrap.so.0',
					'/lib/libutil.so.1',
                    '/lib/librt.so.1',
                    '/lib/libpthread.so.0',
                    '/lib/libdl.so.2',
                    '/lib/ld-linux.so.2'
				 ];

	$::pkgdefs{hwmaint_ReqLibs} = $hl_ref;

}

#--------------------------------------------------------------------------------

=head3  hwmaint_ReqLibsFromRPM

        Notes: These are required libraries for hwmaint operations, but are not
        in the initrd used to build the hwmaint ramdisk.  They must be extracted
        from the rpm files and manually copied to the ramdisk.

        This hash contains the needed libraries and the RPMs where they are packaged.

 $::pkgdefs{'hwmaint_ReqLibsFromRPM'}{'/usr/lib64/libstdc++.so.5'} = "compat-libstdc++-33*.x86_64";
                      ^                       ^                                ^
                      |                       |                                |
                  hash name             required library                 source rpm

=cut

#--------------------------------------------------------------------------------
{
    $::pkgdefs{'hwmaint_ReqLibsFromRPM'}{'/usr/lib/libstdc++.so.5'} = "compat-libstdc++-5*.i586";
    $::pkgdefs{'hwmaint_ReqLibsFromRPM'}{'/usr/lib/libstdc++-libc6.2-2.so.3'} = "compat-2006.1*.i586";
}

#-------------------------------------------------------------------------------
=head3 preinstall_libs
    
    Notes:
        Overwrite the default values in Linux.pm for sles10.

=cut
#-------------------------------------------------------------------------------
{
    my $hl_ref = [
                 ];

    $::pkgdefs{preinstall_libs} = $hl_ref;
}
#--------------------------------------------------------------------------------

=head3  install_kernel_parameter

        Notes:  For some specific machines, installing some specific service 
            levels need adding some specific kernel parameters into the PXE config
            file. This parameter of %::pkgdefs be used for this purpose.

            The last three indices be used to specify for what machine and what
            sevice level you want to insert a string into the PXE config file.
            Their means is:

$::pkgdefs{'install_kernel_parameter'}{'8850'}{'all_models'}{'GA'} = "barrier=off";
                                         ^          ^         ^             ^
                                         |          |         |             |
                                        (1)        (2)       (3)           (4)
            (1) 'HWType' of the nodes, such as '8850'. 'all_types' means for all 
                hardware types.
            (2) 'HWModel' of the nodes, such as '61x'. 'all_models' means for all
                hardware models.
            (3) InstallServiceLevel of the nodes, such as 'GA' 'SP3'.'all_svclevels'
                means for all sevice levels.
            (4) The string will be inserted into pxe file

            For example, you want to install SLES 10 GA on a new machine, but the
            usb driver has some problems, and you want to disable usb device in the
            installation. The machine's HWType is '7283', then you could add a new
            one like this (suppose for all models of this machine):

$::pkgdefs{'install_kernel_parameter'}{'7283'}{'all_models'}{'GA'} = "nousb";

=cut

#--------------------------------------------------------------------------------
{
    # Append kernel parameters "acpi=oldboot" for NON-some platforms
    $::pkgdefs{'install_kernel_parameter'}{'8850'}{'all_models'}{'GA'} = "barrier=off";
    $::pkgdefs{'install_kernel_parameter'}{'7969'}{'all_models'}{'GA'} = "barrier=off";
    $::pkgdefs{'install_kernel_parameter'}{'8840'}{'all_models'}{'GA'} = "barrier=off";
    $::pkgdefs{'install_kernel_parameter'}{'8837'}{'all_models'}{'GA'} = "barrier=off";
    $::pkgdefs{'install_kernel_parameter'}{'8843'}{'all_models'}{'GA'} = "barrier=off";

    $::pkgdefs{'install_kernel_parameter'}{'8850'}{'all_models'}{'all_svclevels'} = "blank";
    $::pkgdefs{'install_kernel_parameter'}{'7969'}{'all_models'}{'all_svclevels'} = "blank";
    $::pkgdefs{'install_kernel_parameter'}{'8840'}{'all_models'}{'all_svclevels'} = "blank";
    $::pkgdefs{'install_kernel_parameter'}{'8837'}{'all_models'}{'all_svclevels'} = "blank";
    $::pkgdefs{'install_kernel_parameter'}{'8843'}{'all_models'}{'all_svclevels'} = "blank";


	# Append kernel parameters "barrier=off" for SLES10 GA nodes
    $::pkgdefs{'install_kernel_parameter'}{'all_types'}{'all_models'}{'GA'} = 'acpi=oldboot barrier=off';
    $::pkgdefs{'install_kernel_parameter'}{'all_types'}{'all_models'}{'all_svclevels'} = 'acpi=oldboot';

}

1;    # end
