# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2007 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#
#
# @(#)50   1.52.1.43   src/csm/install/pkgdefs/Linux-SLES8.1-ppc64.pm.perl, setup, csm_rfish, rfishs001b 8/22/06 %U
#--------------------------------------------------------------------------------

=head3	 Linux-SLES8.1-ppc64.pm.perl

        Package Definition File:    SLES 8.1 ppc64

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [ MgmtServer | MgdNode ]
                $::csm_version  = [ 1.3.0 | 1.3.1 | 1.3.2 | ... ]


        exceptions:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,
	otherwise the execption assignment will be overwriten by the default.

	OTHER DOCUMENTATION - see pkgdefs/Linux.pm

=cut

#--------------------------------------------------------------------------------

# houskeeping

package  SLES81;

#--------------------------------------------------------------------------------

=head3  simple common attributes

        Notes:

=cut

#--------------------------------------------------------------------------------

{
    my $svlLevel = $::ATTRS{"InstallServiceLevel"};
    if ($svlLevel eq "")
    {
        my $disable_warning_msg = 1;
        # disable warning msg from subroutine get_ServiceLevel 
        $svlLevel = NodeUtils->get_ServiceLevel($disable_warning_msg);
    }
    
    # install package architecture
    $::pkgdefs{'arch'} = 'ppc64';

    # the directory where kernel and initrd (or zImage) is placed is CD
    $::pkgdefs{'install_image_dir'} = ".";
    if ($svlLevel eq "SP4")
    {
        $::pkgdefs{'install_image_dir'} = "linux/suse/ppc-sles8";
    }

    # the file name of kernel in CD
    $::pkgdefs{'kernel_file_name'} = "install";

    # the file name of initrd (or zImage) in CD
    $::pkgdefs{'initrd_file_name'} = "install";

    # the network installation method
    $::pkgdefs{'install_method'} = 'autoyast';

    # the stage 1 ramdisk format
    $::pkgdefs{'ramdisk_format'} = 'ext';

    # where this distribution is supported
    $::pkgdefs{'where_supported'} = ['MgdNode'];
}

my $progdir = $0;
$progdir =~ s/\/[^\/]*$/\//g;
if (-e "$progdir/pkgdefs/Linux.pm")
{
	do "$progdir/pkgdefs/Linux.pm";
}
else
{
	do "/opt/csm/install/pkgdefs/Linux.pm";
}

MessageUtils->messageFromCat(
							 'csmInstall.cat',
							 $::MSGMAPPATH,
							 'csminstall',
							 'V',
							 'IMsgLoading',
							 "/opt/csm/install/pkgdefs/Linux-SLES8.1-ppc64.pm"
							);

my $_server_  = 'MgmtServer';
my $_node_    = 'MgdNode';
my $_iserver_ = 'InstallServer';

#--------------------------------------------------------------------------------

=head3	mkzimage	

	cmd to hack the zimage

        Notes:


=cut
#--------------------------------------------------------------------------------
{
	$::pkgdefs{mkzimage} = "/lib/lilo/chrp/mkzimage_cmdline";
}

#--------------------------------------------------------------------------------

=head3	DISTRO Defintions

	Notes :

=cut

#--------------------------------------------------------------------------------
{

	$::pkgdefs{DISTRO_NAME}     = "SuSE SLES 8.1 PPC";
	$::pkgdefs{DISTRO_DISKLIST} = "1 2 4";               # TO BE REMOVED
	$::pkgdefs{DISTRO_RPMDIR}   = "";

}

#--------------------------------------------------------------------------------

=head3  distro_disks - Distribution Disk Defines

        Distribution Disk descriptions used to prompt for the CD-ROMs
        during installation.

        One stanza per CDROM:

            num                     = the number on the CD-ROM's label
            name                    = the text string describing the CD-ROM
            diskid_searchargs       = the arguments be searched to identify the disk
                file    - specific file on the disk
                key	    - specific contents of this file

            diskid_searchprog       = the subroutine be used when identifying the disk
            diskid_target		= the target this disk would be copied to

=cut

#--------------------------------------------------------------------------------
{
	my $dd_ref = [
		{
		 num  => '1',
		 name => $::pkgdefs{DISTRO_NAME},

		 #diskid_filename     => 'media.1/products',
		 #diskid_searchstring => '/ SuSE-Linux-SLES-PPC 8',
		 diskid_searchargs => {
							   file => 'media.1/products',
							   key  => '/ SuSE-Linux-SLES-PPC 8',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => "sles8-ppc64",
		},
		{
		 num  => '2',
		 name => $::pkgdefs{DISTRO_NAME},

		 #diskid_filename      => 'media.2/products',
		 #diskid_searchstring  => '/ SuSE-Linux-SLES-PPC 8',
		 not_for_full_install => 'TRUE',
		 diskid_searchargs    => {
							   file => 'media.2/products',
							   key  => '/ SuSE-Linux-SLES-PPC 8',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => "sles8-ppc64",
		},
		{
		 num        => '3',
		 name       => $::pkgdefs{DISTRO_NAME},
		 is_extracd => '1',

		 #diskid_filename      => 'media.2/products',
		 #diskid_searchstring  => '/ SuSE-Linux-SLES-PPC 8',
		 not_for_full_install => 'TRUE',
		 diskid_searchargs    => {
							   file => 'media.3/products',
							   key  => '/ SuSE-Linux-SLES-PPC 8',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => "sles8-ppc64",
		},
		{
		 num  => '1',
		 name => $::pkgdfs{DISTRO_NAME} . ' Supplementary',

		 #diskid_filename      => 'media.1/products',
		 #diskid_searchstring  => '/ SuSE-Linux-SLES-PPC-SUPP 1',
		 not_for_full_install => 'TRUE',
		 is_extracd           => '1',
		 diskid_searchargs    => {
							   file => 'media.1/products',
							   key  => '/ SuSE-Linux-SLES-PPC-SUPP 1',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => "sles8-ppc64",
		},
		{
		 num  => '2',
		 name => $::pkgdfs{DISTRO_NAME} . ' Supplementary',

		 #diskid_filename      => 'media.1/products',
		 #diskid_searchstring  => '/ SuSE-Linux-SLES-PPC-SUPP 1',
		 not_for_full_install => 'TRUE',
		 is_extracd           => '1',
		 diskid_searchargs    => {
							   file => 'media.2/products',
							   key  => '/ SuSE-Linux-SLES-PPC-SUPP 1',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => "sles8-ppc64",
		},
	];

	$::pkgdefs{distro_disks} = $dd_ref;
}

#--------------------------------------------------------------------------------

=head3	Service Pack disks defination

        Distribution SP Disk descriptions used to prompt for the CD-ROMs
        during installation.

        One stanza per CDROM:

            num                     = the number on the CD-ROM's label
            name                    = the text string describing the CD-ROM
            diskid_searchargs       = the arguments be searched to identify the disk
                file    - specific file on the disk
                key	    - specific contents of this file

            diskid_searchprog       = the subroutine be used when identifying the disk
            diskid_target		= the target this disk would be copied to

=cut

#--------------------------------------------------------------------------------
{
	my $sp3_ref = [
		{
		 num  => '1',
		 name => "SuSE SLES 8.1 SP3 PPC",

		 #	    diskid_filename     => '',
		 #	    diskid_searchstring => '',
		 diskid_searchargs => {
							   file => 'media.1/products',
							   key  => '/ SuSE-Linux-SLES-PPC 3',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => "sles8-sp3",
		},
		{
		 num        => '2',
		 name       => "SuSE SLES 8.1 SP3 PPC",
		 is_extracd => '1',

		 #	    diskid_filename     => '',
		 #	    diskid_searchstring => '',
		 diskid_searchargs => {
							   file => 'media.2/products',
							   key  => '/ SuSE-Linux-SLES-PPC 3',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => "sles8-sp3",
		},
	];

	$::pkgdefs{sp_disks}{SP3} = $sp3_ref;
}

#--------------------------------------------------------------------------------

{
	my $sp3a_ref = [
		{
		 num  => '1',
		 name => "SuSE SLES 8.1 SP3A PPC",

		 #	    diskid_filename     => '',
		 #	    diskid_searchstring => '',
		 diskid_searchargs => {
							   file => 'media.1/products',
							   key  => '/ SuSE-Linux-SLES-PPC 3a',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => "sles8-sp3a",
		},
	];

	$::pkgdefs{sp_disks}{SP3A} = $sp3a_ref;
}

#--------------------------------------------------------------------------------
{
	my $sp4_ref = [
		{
		 num  => '1',
		 name => "SuSE SLES 8.1 SP4 PPC",

		 diskid_searchargs => {
							   file => 'media.1/products',
							   key  => '/ SuSE-Linux-SLES-PPC 4',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => "sles8-sp4",
		},
		{
		 num        => '2',
		 name       => "SuSE SLES 8.1 SP4 PPC",
		 is_extracd => '1',

		 diskid_searchargs => {
							   file => 'media.2/products',
							   key  => '/ SuSE-Linux-SLES-PPC 4',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => "sles8-sp4",
		},
	];

	$::pkgdefs{sp_disks}{SP4} = $sp4_ref;
}

#--------------------------------------------------------------------------------

=head3	csm_bin_copy_tftpboot	

	 CSM binaries copied to /tftpboot directory

        Notes:

	Overloads values in Linux.pm

=cut

#--------------------------------------------------------------------------------
{
	my %cbct_ref;

	# defaults
	$cbct_ref{$::csm_version} = [];

	# exceptions
	# none

	$::pkgdefs{csm_bin_copy_tftpboot} = $cbct_ref{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	os_prereqs - Operating System pre-requisites

        Notes:
            Packages of the OS that needed to install CSM. There are three classes:
            for CSM installed on MS, for CSM installed on IS and for CSM installed
            on MN. These packages will always get copied, but will only be installed
             in corresponding conditions. 

            The stepes to add a operating system pre-requisites:
            1. Create a Rpm object of the rpm package, such as:
                my $kernel_pkg = new Rpm('kernel', '2.8');
            2. Add this Rpm object to the corresponding RpmList object:
                $ospr_ref{$_server_} = new RpmList(
                        'Management Server Operating System Prerequisites Packages',
                        $perl_pkg,
                        $ksh_pkg,
                        .....
                        $kernel_pkg
                        );
            You must ensure the rpm package be added consisting in the 
            distribution's CD.

=cut

#--------------------------------------------------------------------------------
{
	my %ospr_ref;
	my $perl_pkg = new Rpm( 'perl','5');
	my $pdksh_pkg = new Rpm( 'pdksh');
	my $nfs_utils_pkg = new Rpm( 'nfs-utils');
	my $rdist_pkg = new Rpm( 'rdist','6.1.5');
	my $tcl_pkg = new Rpm( 'tcl','8');
	my $tk_pkg = new Rpm( 'tk','8');
	my $expect_pkg = new Rpm( 'expect','5');
	my $xf86_pkg=  new Rpm( 'xf86');
	my $freetype2_pkg = new Rpm( 'freetype2');
	my $termcap_pkg = new Rpm( 'termcap');
	my $expat_pkg = new Rpm( 'expat');
	my $rsync_pkg = new Rpm( 'rsync');
	my $rsh_server_pkg = new Rpm( 'rsh-server');
	
	my $perl_xml_parse_pkg = new Rpm( 'perl-XML-Parser');
	my $perl_xml_dom_pkg = new Rpm( 'perl-XML-DOM');
	my $perl_html_target_pkg = new Rpm( 'perl-HTML-Tagset');
	my $perl_html_parse_pkg = new Rpm( 'perl-HTML-Parser');
	my $perl_uri_pkg = new Rpm( 'perl-URI');
	my $perl_libwww_perl_pkg = new Rpm( 'perl-libwww-perl');
	my $perl_xml_regexp_pkg = new Rpm( 'perl-XML-RegExp');
	
	my $dhcp_base_pkg = new Rpm( 'dhcp-base');
	my $dhcp_server_pkg = new Rpm( 'dhcp-server');

	$ospr_ref{$_server_} = new RpmList(
			'Management Server Operating System Prerequisites Packages',
			$perl_pkg,
			$pdksh_pkg,
			$nfs_utils_pkg,
			$rdist_pkg,
			$tcl_pkg,
			$tk_pkg,
			$expect_pkg,
			$xf86_pkg,
			$freetype2_pkg,
			$rsync_pkg,
			$rsh_server_pkg
	);

	$ospr_ref{$_iserver_} = new RpmList(
			'Install Server Operating System Prerequisites Packages',
			$nfs_utils_pkg,
			$dhcp_base_pkg,
			$dhcp_server_pkg,
			$expat_pkg,
			$perl_xml_parse_pkg,
			$perl_xml_dom_pkg,
			$perl_html_target_pkg,
			$perl_html_parse_pkg,
			$perl_uri_pkg,
			$perl_libwww_perl_pkg,
			$perl_xml_regexp_pkg
	);

	$ospr_ref{$_node_} = new RpmList(
			'Managed Node Operating System Prerequisites Packages',
			$perl_pkg,
			$nfs_utils_pkg,
			$pdksh_pkg,
			$dhcp_base_pkg,
			$dhcp_server_pkg,
			$rdist_pkg,
			$tcl_pkg,
			$tk_pkg,
			$expect_pkg,
			$xf86_pkg,
			$freetype2_pkg,
			$rsh_server_pkg
	);

	$ospr_ref{$_server_}->setContainedInCds(1);
	$ospr_ref{$_iserver_}->setContainedInCds(1);
	$ospr_ref{$_node_}->setContainedInCds(1);

	# Add perl-XML-RegExp to os_prereqs since
	# it has been shipped with SP3

	$::pkgdefs{'pkgs'}{$_server_}{$::OS_PREREQ_PKGS} = $ospr_ref{$_server_};
	$::pkgdefs{'pkgs'}{$_iserver_}{$::OS_PREREQ_PKGS} = $ospr_ref{$_iserver_};
	$::pkgdefs{'pkgs'}{$_node_}{$::OS_PREREQ_PKGS} = $ospr_ref{$_node_};

}

#--------------------------------------------------------------------------------

=head3	logfiles	

	CSM Log files ( used while uninstalling)

        Notes:

	Overloads values in Linux.pm

=cut

#--------------------------------------------------------------------------------
{
	my %lf_ref;

	$lf_ref{$_server_} = [
						  '/var/log/csm/csmsetupsis.log*',
						  '/var/log/csm/installnode.log*',
						  '/var/log/csm/updatenode.log*',
						  '/var/log/csm/installms.log*'
						 ];
	$lf_ref{$_node_} = ['/var/log/csm/install.log*', '/var/opt/csm/cfmlocal*'];

	$::pkgdefs{logfiles} = $lf_ref{$::mgmt_type};
}

#--------------------------------------------------------------------------------

=head3	Misc. global variables

	should be moved elsewhere...	

	definately move somewhere else!  - maybe the registry

        Notes:

=cut

#--------------------------------------------------------------------------------
{

	%::rpm_pkg_flag = ();
	$::rpm_pkg_flag{openCIMOM} = " --ignoreos";

	#default kernel path name based on SUSE_TOP
	$::kernel_path_name =
	  "sles8-ppc64/suse/ppc/kernel-ppc64-2.4.19-108.ppc.rpm";

}

1;    # end
