# @(#)69   1.5   src/csm/install/pkgdefs/Linux-ScientificLinux4-x86_64.pm.perl, setup, csm_rfish, rfishs001b 10/26/06 04:33:26
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2006,2007 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#--------------------------------------------------------------------------------

=head3	Linux-ScientificLinux4-x86_64.pm.perl

        Package Definition File:    ScientificLinux44.0 x86_64

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [MgmtServer | MgdNode ]
                $::csm_version  = [1.3.0 | 1.3.1 | 1.3.2 | ... ]


        exceptions:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,
	otherwise the execption assignment will be overwriten by the default.

	OTHER DOCUMENTATION - see pkgdefs/Linux.pm

=cut

#--------------------------------------------------------------------------------

# houskeeping

package CentOS40;

my $progdir = $0;
$progdir =~ s/\/[^\/]*$/\//g;
if (-e "$progdir/pkgdefs/Linux-RedHatEL-AS4-x86_64.pm")
{
    do "$progdir/pkgdefs/Linux-RedHatEL-AS4-x86_64.pm";
}
else
{
    do "/opt/csm/install/pkgdefs/Linux-RedHatEL-AS4-x86_64.pm";
}


MessageUtils->messageFromCat(
                         'csmInstall.cat',
                         $::MSGMAPPATH,
                         'csminstall',
                         'V',
                         'IMsgLoading',
                         "/opt/csm/install/pkgdefs/Linux-ScientificLinux4.0-x86_64.pm"
                         );


#--------------------------------------------------------------------------------

=head3	DISTRO Defintions

	Notes :

=cut

#--------------------------------------------------------------------------------
{

	# distribution name
    $::pkgdefs{DISTRO_NAME} = "Scientific Linux 4 x86_64";

    $::pkgdefs{DISTRO_DISKLIST} = "1 2 3 4";       # TO BE REMOVED

	# directory on CDs which contains rpm packages
    $::pkgdefs{DISTRO_RPMDIR}   = "SL/RPMS";

}

#--------------------------------------------------------------------------------

=head3  distro_disks - Distribution Disk Defines

        Distribution Disk descriptions used to prompt for the CD-ROMs
        during installation.

        There is a trick, and you may now create one stanza per service level:

                key	                    = specific contents of the specific file on
                                          the CD-ROMs
                diskid_target		    = the target those CD-ROMs would be copied to
                rpm	                    = specific rpm package on the first disk
                num                     = the numbers of this service level's CD-ROMs
                name                    = the text string describing those CD-ROMs

        and then in running time, CSM would generate ordinary disk description.

=cut

#--------------------------------------------------------------------------------
{
    my %disc_info;
    my $rpm;

    %disc_info=(
        GA     =>  {
        key             => "1114113670.332588",
        diskid_target   => "ScientificLinux4-x86_64",
        rpm             => "SL/RPMS/sl-release-4.0-5.noarch.rpm",
        name            => $::pkgdefs{DISTRO_NAME},
        num             => 4,
        },
        QU1     =>  {
        key             => "1123178956.722822",
        diskid_target   => "ScientificLinux4-QU1",
        rpm             => "SL/RPMS/sl-release-4.1-4.noarch.rpm",
        name            => $::pkgdefs{DISTRO_NAME} . " QU1",
        num             => 4,
        },
	QU2     =>  {
        key             => "1132699212.963502",
        diskid_target   => "ScientificLinux4-QU2",
        rpm             => "SL/RPMS/sl-release-4.2-7.noarch.rpm",
        name            => $::pkgdefs{DISTRO_NAME} . " QU2",
        num             => 4,
        },
	QU3     =>  {
        key             => "1144097072.398717",
        diskid_target   => "ScientificLinux4-QU3",
        rpm             => "SL/RPMS/sl-release-4.3-3.noarch.rpm",
        name            => $::pkgdefs{DISTRO_NAME} . " QU3",
        num             => 4,
        },
    QU4     =>  {
        key             => "1160165616.594774",
        diskid_target   => "ScientificLinux4-QU4",
        rpm             => "SL/RPMS/sl-release-4.4-4.noarch.rpm",
        name            => $::pkgdefs{DISTRO_NAME} . " QU4",
        num             => 5,
        },
    );

    foreach my $sl(keys(%disc_info))
    {
        my @discs=();
        foreach my $no(1..$disc_info{$sl}{num})
        {
            if($no == 1)
            {
                $rpm=$disc_info{$sl}{rpm};
            }
            else
            {
                $rpm='';
            }

            my $info={
				num               => $no,
        		name              => $disc_info{$sl}{name},
		        diskid_searchargs => {
				                       file => '.discinfo',
									   num  => $no,
									   arch => 'x86_64',
									   key  => $disc_info{$sl}{key},
									   rpm => $rpm,
				                        },
        		diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		        diskid_target     => $disc_info{$sl}{diskid_target},
            };

            push (@discs, $info);
        }

        if ($sl eq 'GA') {
            $::pkgdefs{distro_disks} = \@discs;
        }
        else {
            $::pkgdefs{sp_disks}{$sl} = \@discs;
        }
     }
}

1;    # end

