# @(#)71   1.22   src/csm/install/pkgdefs/distro_id.pm.perl, setup, csm_rfish, rfishs001b 4/28/07 04:37:26
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2006,2007 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 

################################################################################
#
# This file defines information that CSM can use to recognize a supported
# distribution. Users can modify this file to support new Linux distribution
# versions or service levels. But it is required to backup this file.
#
# Each entry stands for one platform CSM will run on.
#
# distro_name       the distribution name
# distro_version    the distribution version
# svc_level         the service level
# arch              the architecture. Valid values of this attribute can be
#                   "i386", "x86_64", and "ppc64"
# id_name           the resource name that is used to uniquely identify the
#                   distribution' name, version and service level. This resource
#                   can be a file, a RPM name or a command
# id_type           the resource type. Valid values of this attribute can be
#                   "file", "rpm_version" and "command".
#                 
#                   For a "file" type resource, CSM will read all contents from
#                       the file stored in id_name, and compare the result with
#                       the resource value defined in id_val.
#                   For a "rpm_version" type resource, CSM will run "rpm -q"
#                       command to query the version of this rpm, and compare the
#                       the result with the resource value defined in id_val
#                   For a "command" type resource, CSM will run this command and
#                       compare the result with the resource value defined in id_val
# id_val            the value of the resource
#
#                   For a "file" type resource, the id_val can only contains a
#                       sub-string of a line. If this sub-string can be found in
#                       this file, CSM can recognize this distribution. The regular
#                       expressions are supported in this value.
#                   For an "rpm_version" type resource, the id_val indicate a version
#                       range of this rpm, to make sure CSM can recognize this
#                       distribution after this rpm is updated. The low version and
#                       the high version are separated by a comma. This version value
#                       includes a version number and a release number, and the
#                       version number and the release number are separated by a dash
#                       sign. If the version of this rpm is no less than the low
#                       version number and is not greater than the high version number,
#                       this distribution can be recognized by CSM. If the low version
#                       or high version is omitted, that means the range is open-ended.
#                   For a "command" type resource, the id_val only contains a
#                       sub-string of a line. If this sub-string can be found in the
#                       result of this command, CSM can recognize this distribution.
#                       The regular expressions are supported in this value. The
#                       regular expressions should be Perl style, but it should NOT
#                       contain the division sign. For example:
#                           ...
#                           'id_name' => 'cat /etc/redhat-release',
#                           'id_type' => 'command',
#                           'id_val' => '.* Enterprise Linux AS .* Taroon Update 2',
#
# Following attributes are optional for a distribution:
# effective_distro_name     the effective distribution's name. If this attribute has
#                           not been set, CSM will take the value of attribute
#                           distro_name as its effective distribution name.
# effective_distro_ver      the effective distribution's version. If this attribute
#                           has not been set, CSM will take the value of attribute
#                           distro_ver as its effective distribution version.
# effective_svc_level       the effective distribution's service level. If this
#                           attribute has not been set, CSM will take the value of
#                           attribute svc_level as its effective distribution service
#                           level.
#
# Above information should be described in following format:
# $::distro_id{'<Full distro name>'}=
# {
#    'distro_name' => '<distribution name>',
#    'distro_version' => '<distribution version>',
#    'svc_level' => '<service level of this system>',
#    'arch' => '<architecture of this system>',
#    'id_name' => '<the resource name>',
#    'id_type' => '<the resource type>',
#    'id_val' => '<id_val>',
#    'effective_distro_name' => '<effective distribution name>',
#    'effective_distro_ver' => '<effective distribution version>',
#    'effective_svc_level' => '<effective distribution service level>'
# };
#
# Note the string in <Full distro name> is the key of above information, and it
# should be unique in this file. It should be named as
# "<Distribution name><Version>-<Service levelevel>-<Architecture>".
#
################################################################################
#!/usr/bin/perl
package distro_id;

#========================SUSE LINUX Enterprise Server=====================
#---------------------------------SLES10 i386-----------------------------
$::distro_id{'SLES10-GA-i386'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '10',
    'svc_level' => 'GA',
    'arch' => 'i386',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '10-12.8,10-12.25'
};
$::distro_id{'SLES10-SP1-i386'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '10',
    'svc_level' => 'SP1',
    'arch' => 'i386',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '10-12.25'
};
#---------------------------------SLES9 i386------------------------------
$::distro_id{'SLES9-GA-i386'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '9',
    'svc_level' => 'GA',
    'arch' => 'i386',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '9-29.8,9-29.20'
};

$::distro_id{'SLES9-SP1-i386'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '9',
    'svc_level' => 'SP1',
    'arch' => 'i386',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '9-29.20,9-29.35'
};

$::distro_id{'SLES9-SP2-i386'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '9',
    'svc_level' => 'SP2',
    'arch' => 'i386',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '9-29.35,9-29.46'
};

$::distro_id{'SLES9-SP3-i386'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '9',
    'svc_level' => 'SP3',
    'arch' => 'i386',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '9-29.46'
};

$::distro_id{'MCPLinux-SP2-i386'}=
{
    'distro_name' => 'MCPLinux',
    'distro_version' => '4',
    'svc_level' => 'SP2',
    'arch' => 'i386',
    'id_name' => '/opt/hsc/data/hmcType.properties',
    'id_type' => 'file',
    'id_val' => 'HMCTYPE',
    'effective_distro_name' => 'SLES',
    'effective_distro_ver' => '9',
    'effective_svc_level' => 'SP2'

};

#---------------------------------SLES8 i386------------------------------
$::distro_id{'SLES8.1-GA-i386'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '8.1',
    'svc_level' => 'GA',
    'arch' => 'i386',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '2002.10.21-1'
};

$::distro_id{'SLES8.1-SP3-i386'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '8.1',
    'svc_level' => 'SP3',
    'arch' => 'i386',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '2003.3.27-55'
};

$::distro_id{'SLES8.1-SP4-i386'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '8.1',
    'svc_level' => 'SP4',
    'arch' => 'i386',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '2003.3.27-76'
};

#---------------------------------SLES10 x86_64------------------------------
$::distro_id{'SLES10-GA-x86_64'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '10',
    'svc_level' => 'GA',
    'arch' => 'x86_64',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '10-12.8,10-12.25'
};
$::distro_id{'SLES10-SP1-x86_64'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '10',
    'svc_level' => 'SP1',
    'arch' => 'x86_64',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '10-12.25'
};
#---------------------------------SLES9 x86_64------------------------------
$::distro_id{'SLES9-GA-x86_64'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '9',
    'svc_level' => 'GA',
    'arch' => 'x86_64',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '9-29.8,9-29.20'
};

$::distro_id{'SLES9-SP1-x86_64'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '9',
    'svc_level' => 'SP1',
    'arch' => 'x86_64',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '9-29.20,9-29.35'
};

$::distro_id{'SLES9-SP2-x86_64'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '9',
    'svc_level' => 'SP2',
    'arch' => 'x86_64',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '9-29.35,9-29.46'
};

$::distro_id{'SLES9-SP3-x86_64'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '9',
    'svc_level' => 'SP3',
    'arch' => 'x86_64',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '9-29.46'
};

#---------------------------------SLES8 x86_64------------------------------
$::distro_id{'SLES8.1-GA-x86_64'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '8.1',
    'svc_level' => 'GA',
    'arch' => 'x86_64',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '2003.1.28-13'
};

$::distro_id{'SLES8.1-SP3-x86_64'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '8.1',
    'svc_level' => 'SP3',
    'arch' => 'x86_64',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '2003.3.27-57'
};

$::distro_id{'SLES8.1-SP4-x86_64'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '8.1',
    'svc_level' => 'SP4',
    'arch' => 'x86_64',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '2003.3.27-76'
};
#---------------------------------SLES10 ppc64----------------------------
$::distro_id{'SLES10-GA-ppc64'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '10',
    'svc_level' => 'GA',
    'arch' => 'ppc64',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '10-12.8,10-12.25'
};

$::distro_id{'SLES10-SP1-ppc64'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '10',
    'svc_level' => 'SP1',
    'arch' => 'ppc64',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '10-12.25'
};
#---------------------------------SLES9 ppc64------------------------------
$::distro_id{'SLES9-GA-ppc64'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '9',
    'svc_level' => 'GA',
    'arch' => 'ppc64',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '9-29.8,9-29.20'
};

$::distro_id{'SLES9-SP1-ppc64'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '9',
    'svc_level' => 'SP1',
    'arch' => 'ppc64',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '9-29.20,9-29.35'
};

$::distro_id{'SLES9-SP2-ppc64'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '9',
    'svc_level' => 'SP2',
    'arch' => 'ppc64',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '9-29.35,9-29.46'
};

$::distro_id{'SLES9-SP3-ppc64'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '9',
    'svc_level' => 'SP3',
    'arch' => 'ppc64',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '9-29.46'
};

#---------------------------------SLES8 ppc64-----------------------------
$::distro_id{'SLES8.1-GA-ppc64'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '8.1',
    'svc_level' => 'GA',
    'arch' => 'ppc64',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '2002.11.11-0'
};

$::distro_id{'SLES8.1-SP3-ppc64'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '8.1',
    'svc_level' => 'SP3',
    'arch' => 'ppc64',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '2003.3.27-41'
};

$::distro_id{'SLES8.1-SP4-ppc64'}=
{
    'distro_name' => 'SLES',
    'distro_version' => '8.1',
    'svc_level' => 'SP4',
    'arch' => 'ppc64',
    'id_name' => 'aaa_base',
    'id_type' => 'rpm_version',
    'id_val' => '2003.3.27-76'
};


#========================Red Hat Enterprise Linux=========================
#------------------------------i386 AS------------------------------------
# try to support rhel5 beta1
$::distro_id{'RedHatELServer5-GA-i386'}=
{
    'distro_name' => 'RedHatEL-Server',
    'distro_version' => '5',
    'svc_level' => 'GA',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux Server release 5 (Tikanga)',
};

$::distro_id{'RedHatELAS4-GA-i386'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '4',
    'svc_level' => 'GA',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 4 (Nahant)'
};

$::distro_id{'RedHatELAS4-QU1-i386'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '4',
    'svc_level' => 'QU1',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 4 (Nahant Update 1)'
};

$::distro_id{'RedHatELAS4-QU2-i386'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '4',
    'svc_level' => 'QU2',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 4 (Nahant Update 2)'
};

$::distro_id{'RedHatELAS4-QU3-i386'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '4',
    'svc_level' => 'QU3',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 4 (Nahant Update 3)'
};

$::distro_id{'RedHatELAS4-QU4-i386'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '4',
    'svc_level' => 'QU4',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 4 (Nahant Update 4)'
};

$::distro_id{'RedHatELAS4.5-GA-i386'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '4.5',
    'svc_level' => 'GA',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 4 (Nahant Update 5)'
};

$::distro_id{'CentOS4-GA-i386'}=
{
    'distro_name' => 'CentOS',
    'distro_version' => '4',
    'svc_level' => 'GA',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'CentOS release 4.0 (Final)',
    'effective_distro_name' => 'RedHatEL-AS',
    'effective_distro_ver' => '4',
    'effective_svc_level' => 'GA'
};

$::distro_id{'CentOS4-QU1-i386'}=
{
    'distro_name' => 'CentOS',
    'distro_version' => '4',
    'svc_level' => 'QU1',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'CentOS release 4.1 (Final)',
    'effective_distro_name' => 'RedHatEL-AS',
    'effective_distro_ver' => '4',
    'effective_svc_level' => 'QU1'
};

$::distro_id{'CentOS4-QU2-i386'}=
{
    'distro_name' => 'CentOS',
    'distro_version' => '4',
    'svc_level' => 'QU2',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'CentOS release 4.2 (Final)',
    'effective_distro_name' => 'RedHatEL-AS',
    'effective_distro_ver' => '4',
    'effective_svc_level' => 'QU2'
};

$::distro_id{'CentOS4-QU3-i386'}=
{
    'distro_name' => 'CentOS',
    'distro_version' => '4',
    'svc_level' => 'QU3',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'CentOS release 4.3 (Final)',
    'effective_distro_name' => 'RedHatEL-AS',
    'effective_distro_ver' => '4',
    'effective_svc_level' => 'QU3'
};

$::distro_id{'CentOS4-QU4-i386'}=
{
    'distro_name' => 'CentOS',
    'distro_version' => '4',
    'svc_level' => 'QU4',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'CentOS release 4.4 (Final)',
    'effective_distro_name' => 'RedHatEL-AS',
    'effective_distro_ver' => '4',
    'effective_svc_level' => 'QU4'
};

$::distro_id{'ScientificLinux4-GA-i386'}=
{
    'distro_name' => 'ScientificLinux',
    'distro_version' => '4',
    'svc_level' => 'GA',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Scientific Linux SL Release 4.0 (Beryllium)',
    'effective_distro_name' => 'RedHatEL-AS',
    'effective_distro_ver' => '4',
    'effective_svc_level' => 'GA'
};

$::distro_id{'ScientificLinux4-QU1-i386'}=
{
    'distro_name' => 'ScientificLinux',
    'distro_version' => '4',
    'svc_level' => 'QU1',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Scientific Linux SL release 4.1 (Beryllium)',
    'effective_distro_name' => 'RedHatEL-AS',
    'effective_distro_ver' => '4',
    'effective_svc_level' => 'QU1'
};

$::distro_id{'ScientificLinux4-QU2-i386'}=
{
    'distro_name' => 'ScientificLinux',
    'distro_version' => '4',
    'svc_level' => 'QU2',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Scientific Linux SL release 4.2 (Beryllium)',
    'effective_distro_name' => 'RedHatEL-AS',
    'effective_distro_ver' => '4',
    'effective_svc_level' => 'QU2'
};

$::distro_id{'ScientificLinux4-QU3-i386'}=
{
    'distro_name' => 'ScientificLinux',
    'distro_version' => '4',
    'svc_level' => 'QU3',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Scientific Linux SL release 4.3 (Beryllium)',
    'effective_distro_name' => 'RedHatEL-AS',
    'effective_distro_ver' => '4',
    'effective_svc_level' => 'QU3'
};

$::distro_id{'ScientificLinux4-QU4-i386'}=
{
    'distro_name' => 'ScientificLinux',
    'distro_version' => '4',
    'svc_level' => 'QU4',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Scientific Linux SL release 4.4 (Beryllium)',
    'effective_distro_name' => 'RedHatEL-AS',
    'effective_distro_ver' => '4',
    'effective_svc_level' => 'QU4'
};

$::distro_id{'RedHatELAS3-GA-i386'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '3',
    'svc_level' => 'GA',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 3 (Taroon)'
};

$::distro_id{'RedHatELAS3-QU1-i386'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '3',
    'svc_level' => 'QU1',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 3 (Taroon Update 1)'
};

$::distro_id{'RedHatELAS3-QU2-i386'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '3',
    'svc_level' => 'QU2',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 3 (Taroon Update 2)'
};

$::distro_id{'RedHatELAS3-QU3-i386'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '3',
    'svc_level' => 'QU3',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 3 (Taroon Update 3)'
};

$::distro_id{'RedHatELAS3-QU4-i386'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '3',
    'svc_level' => 'QU4',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 3 (Taroon Update 4)'
};

$::distro_id{'RedHatELAS3-QU5-i386'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '3',
    'svc_level' => 'QU5',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 3 (Taroon Update 5)'
};

$::distro_id{'RedHatELAS3-QU6-i386'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '3',
    'svc_level' => 'QU6',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 3 (Taroon Update 6)'
};

$::distro_id{'RedHatELAS3-QU7-i386'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '3',
    'svc_level' => 'QU7',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 3 (Taroon Update 7)'
};

$::distro_id{'RedHatAS2.1-GA-i386'}=
{
    'distro_name' => 'RedHatAS',
    'distro_version' => '2.1',
    'svc_level' => 'GA',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Linux Advanced Server release 2.1AS'
};


#------------------------------x86_64 AS------------------------------------
$::distro_id{'RedHatELServer5-GA-x86_64'}=
{
    'distro_name' => 'RedHatEL-Server',
    'distro_version' => '5',
    'svc_level' => 'GA',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux Server release 5 (Tikanga)',
};

$::distro_id{'RedHatELAS4-GA-x86_64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '4',
    'svc_level' => 'GA',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 4 (Nahant)'
};

$::distro_id{'RedHatELAS4-QU1-x86_64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '4',
    'svc_level' => 'QU1',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 4 (Nahant Update 1)'
};

$::distro_id{'RedHatELAS4-QU2-x86_64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '4',
    'svc_level' => 'QU2',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 4 (Nahant Update 2)'
};

$::distro_id{'RedHatELAS4-QU3-x86_64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '4',
    'svc_level' => 'QU3',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 4 (Nahant Update 3)'
};

$::distro_id{'RedHatELAS4-QU4-x86_64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '4',
    'svc_level' => 'QU4',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 4 (Nahant Update 4)'
};

$::distro_id{'RedHatELAS4.5-GA-x86_64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '4.5',
    'svc_level' => 'GA',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 4 (Nahant Update 5)'
};

$::distro_id{'CentOS4-GA-x86_64'}=
{
    'distro_name' => 'CentOS',
    'distro_version' => '4',
    'svc_level' => 'GA',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'CentOS release 4.0 (Final)',
    'effective_distro_name' => 'RedHatEL-AS',
    'effective_distro_ver' => '4',
    'effective_svc_level' => 'GA'
};

$::distro_id{'CentOS4-QU1-x86_64'}=
{
    'distro_name' => 'CentOS',
    'distro_version' => '4',
    'svc_level' => 'QU1',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'CentOS release 4.1 (Final)',
    'effective_distro_name' => 'RedHatEL-AS',
    'effective_distro_ver' => '4',
    'effective_svc_level' => 'QU1'
};

$::distro_id{'CentOS4-QU2-x86_64'}=
{
    'distro_name' => 'CentOS',
    'distro_version' => '4',
    'svc_level' => 'QU2',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'CentOS release 4.2 (Final)',
    'effective_distro_name' => 'RedHatEL-AS',
    'effective_distro_ver' => '4',
    'effective_svc_level' => 'QU2'
};

$::distro_id{'CentOS4-QU3-x86_64'}=
{
    'distro_name' => 'CentOS',
    'distro_version' => '4',
    'svc_level' => 'QU3',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'CentOS release 4.3 (Final)',
    'effective_distro_name' => 'RedHatEL-AS',
    'effective_distro_ver' => '4',
    'effective_svc_level' => 'QU3'
};

$::distro_id{'CentOS4-QU4-x86_64'}=
{
    'distro_name' => 'CentOS',
    'distro_version' => '4',
    'svc_level' => 'QU4',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'CentOS release 4.4 (Final)',
    'effective_distro_name' => 'RedHatEL-AS',
    'effective_distro_ver' => '4',
    'effective_svc_level' => 'QU4'
};

$::distro_id{'ScientificLinux4-GA-x86_64'}=
{
    'distro_name' => 'ScientificLinux',
    'distro_version' => '4',
    'svc_level' => 'GA',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Scientific Linux SL Release 4.0 (Beryllium)',
    'effective_distro_name' => 'RedHatEL-AS',
    'effective_distro_ver' => '4',
    'effective_svc_level' => 'GA'

};

$::distro_id{'ScientificLinux4-QU1-x86_64'}=
{
    'distro_name' => 'ScientificLinux',
    'distro_version' => '4',
    'svc_level' => 'QU1',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Scientific Linux SL release 4.1 (Beryllium)',
    'effective_distro_name' => 'RedHatEL-AS',
    'effective_distro_ver' => '4',
    'effective_svc_level' => 'QU1'
};

$::distro_id{'ScientificLinux4-QU2-x86_64'}=
{
    'distro_name' => 'ScientificLinux',
    'distro_version' => '4',
    'svc_level' => 'QU2',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Scientific Linux SL release 4.2 (Beryllium)',
    'effective_distro_name' => 'RedHatEL-AS',
    'effective_distro_ver' => '4',
    'effective_svc_level' => 'QU2'
};

$::distro_id{'ScientificLinux4-QU3-x86_64'}=
{
    'distro_name' => 'ScientificLinux',
    'distro_version' => '4',
    'svc_level' => 'QU3',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Scientific Linux SL release 4.3 (Beryllium)',
    'effective_distro_name' => 'RedHatEL-AS',
    'effective_distro_ver' => '4',
    'effective_svc_level' => 'QU3'
};

$::distro_id{'ScientificLinux4-QU4-x86_64'}=
{
    'distro_name' => 'ScientificLinux',
    'distro_version' => '4',
    'svc_level' => 'QU4',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Scientific Linux SL release 4.4 (Beryllium)',
    'effective_distro_name' => 'RedHatEL-AS',
    'effective_distro_ver' => '4',
    'effective_svc_level' => 'QU4'
};

$::distro_id{'RedHatELAS3-GA-x86_64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '3',
    'svc_level' => 'GA',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 3 (Taroon)'
};

$::distro_id{'RedHatELAS3-QU1-x86_64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '3',
    'svc_level' => 'QU1',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 3 (Taroon Update 1)'
};

$::distro_id{'RedHatELAS3-QU2-x86_64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '3',
    'svc_level' => 'QU2',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 3 (Taroon Update 2)'
};

$::distro_id{'RedHatELAS3-QU3-x86_64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '3',
    'svc_level' => 'QU3',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 3 (Taroon Update 3)'
};

$::distro_id{'RedHatELAS3-QU4-x86_64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '3',
    'svc_level' => 'QU4',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 3 (Taroon Update 4)'
};

$::distro_id{'RedHatELAS3-QU5-x86_64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '3',
    'svc_level' => 'QU5',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 3 (Taroon Update 5)'
};

$::distro_id{'RedHatELAS3-QU6-x86_64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '3',
    'svc_level' => 'QU6',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 3 (Taroon Update 6)'
};

$::distro_id{'RedHatELAS3-QU7-x86_64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '3',
    'svc_level' => 'QU7',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 3 (Taroon Update 7)'
};

#------------------------------ppc64 AS------------------------------------
# try to support alpha rhel5 
$::distro_id{'RedHatELServer5-GA-ppc64'}=
{
    'distro_name' => 'RedHatEL-Server',
    'distro_version' => '5',
    'svc_level' => 'GA',
    'arch' => 'ppc64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux Server release 5 (Tikanga)',
};

$::distro_id{'RedHatELAS4-GA-ppc64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '4',
    'svc_level' => 'GA',
    'arch' => 'ppc64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 4 (Nahant)'
};

$::distro_id{'RedHatELAS4-QU1-ppc64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '4',
    'svc_level' => 'QU1',
    'arch' => 'ppc64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 4 (Nahant Update 1)'
};

$::distro_id{'RedHatELAS4-QU2-ppc64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '4',
    'svc_level' => 'QU2',
    'arch' => 'ppc64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 4 (Nahant Update 2)'
};

$::distro_id{'RedHatELAS4-QU3-ppc64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '4',
    'svc_level' => 'QU3',
    'arch' => 'ppc64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 4 (Nahant Update 3)'
};

$::distro_id{'RedHatELAS4-QU4-ppc64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '4',
    'svc_level' => 'QU4',
    'arch' => 'ppc64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 4 (Nahant Update 4)'
};


$::distro_id{'RedHatELAS4.5-GA-ppc64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '4.5',
    'svc_level' => 'GA',
    'arch' => 'ppc64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 4 (Nahant Update 5)'
};

$::distro_id{'RedHatELAS3-GA-ppc64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '3',
    'svc_level' => 'GA',
    'arch' => 'ppc64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 3 (Taroon)'
};

$::distro_id{'RedHatELAS3-QU1-ppc64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '3',
    'svc_level' => 'QU1',
    'arch' => 'ppc64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 3 (Taroon Update 1)'
};

$::distro_id{'RedHatELAS3-QU2-ppc64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '3',
    'svc_level' => 'QU2',
    'arch' => 'ppc64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 3 (Taroon Update 2)'
};

$::distro_id{'RedHatELAS3-QU3-ppc64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '3',
    'svc_level' => 'QU3',
    'arch' => 'ppc64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 3 (Taroon Update 3)'
};

$::distro_id{'RedHatELAS3-QU4-ppc64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '3',
    'svc_level' => 'QU4',
    'arch' => 'ppc64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 3 (Taroon Update 4)'
};

$::distro_id{'RedHatELAS3-QU5-ppc64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '3',
    'svc_level' => 'QU5',
    'arch' => 'ppc64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 3 (Taroon Update 5)'
};

$::distro_id{'RedHatELAS3-QU6-ppc64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '3',
    'svc_level' => 'QU6',
    'arch' => 'ppc64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 3 (Taroon Update 6)'
};

$::distro_id{'RedHatELAS3-QU7-ppc64'}=
{
    'distro_name' => 'RedHatEL-AS',
    'distro_version' => '3',
    'svc_level' => 'QU7',
    'arch' => 'ppc64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux AS release 3 (Taroon Update 7)'
};

#------------------------------i386 ES------------------------------------
$::distro_id{'RedHatELES4-GA-i386'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '4',
    'svc_level' => 'GA',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 4 (Nahant)'
};

$::distro_id{'RedHatELES4-QU1-i386'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '4',
    'svc_level' => 'QU1',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 4 (Nahant Update 1)'
};

$::distro_id{'RedHatELES4-QU2-i386'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '4',
    'svc_level' => 'QU2',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 4 (Nahant Update 2)'
};

$::distro_id{'RedHatELES4-QU3-i386'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '4',
    'svc_level' => 'QU3',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 4 (Nahant Update 3)'
};

$::distro_id{'RedHatELES4-QU4-i386'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '4',
    'svc_level' => 'QU4',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 4 (Nahant Update 4)'
};

$::distro_id{'RedHatELES4.5-GA-i386'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '4.5',
    'svc_level' => 'GA',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 4 (Nahant Update 5)'
};

$::distro_id{'RedHatELES3-GA-i386'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '3',
    'svc_level' => 'GA',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 3 (Taroon)'
};

$::distro_id{'RedHatELES3-QU1-i386'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '3',
    'svc_level' => 'QU1',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 3 (Taroon Update 1)'
};

$::distro_id{'RedHatELES3-QU2-i386'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '3',
    'svc_level' => 'QU2',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 3 (Taroon Update 2)'
};

$::distro_id{'RedHatELES3-QU3-i386'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '3',
    'svc_level' => 'QU3',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 3 (Taroon Update 3)'
};

$::distro_id{'RedHatELES3-QU4-i386'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '3',
    'svc_level' => 'QU4',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 3 (Taroon Update 4)'
};

$::distro_id{'RedHatELES3-QU5-i386'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '3',
    'svc_level' => 'QU5',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 3 (Taroon Update 5)'
};

$::distro_id{'RedHatELES3-QU6-i386'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '3',
    'svc_level' => 'QU6',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 3 (Taroon Update 6)'
};

$::distro_id{'RedHatELES3-QU7-i386'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '3',
    'svc_level' => 'QU7',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 3 (Taroon Update 7)'
};

$::distro_id{'RedHatELES2.1-GA-i386'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '2.1',
    'svc_level' => 'GA',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Linux Advanced Server release 2.1ES'
};

#------------------------------x86_64 ES------------------------------------
$::distro_id{'RedHatELES4-GA-x86_64'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '4',
    'svc_level' => 'GA',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 4 (Nahant)'
};

$::distro_id{'RedHatELES4-QU1-x86_64'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '4',
    'svc_level' => 'QU1',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 4 (Nahant Update 1)'
};

$::distro_id{'RedHatELES4-QU2-x86_64'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '4',
    'svc_level' => 'QU2',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 4 (Nahant Update 2)'
};

$::distro_id{'RedHatELES4-QU3-x86_64'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '4',
    'svc_level' => 'QU3',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 4 (Nahant Update 3)'
};

$::distro_id{'RedHatELES4-QU4-x86_64'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '4',
    'svc_level' => 'QU4',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 4 (Nahant Update 4)'
};

$::distro_id{'RedHatELES4.5-GA-x86_64'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '4.5',
    'svc_level' => 'GA',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 4 (Nahant Update 5)'
};

$::distro_id{'RedHatELES3-GA-x86_64'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '3',
    'svc_level' => 'GA',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 3 (Taroon)'
};

$::distro_id{'RedHatELES3-QU1-x86_64'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '3',
    'svc_level' => 'QU1',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 3 (Taroon Update 1)'
};

$::distro_id{'RedHatELES3-QU2-x86_64'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '3',
    'svc_level' => 'QU2',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 3 (Taroon Update 2)'
};

$::distro_id{'RedHatELES3-QU3-x86_64'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '3',
    'svc_level' => 'QU3',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 3 (Taroon Update 3)'
};

$::distro_id{'RedHatELES3-QU4-x86_64'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '3',
    'svc_level' => 'QU4',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 3 (Taroon Update 4)'
};

$::distro_id{'RedHatELES3-QU5-x86_64'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '3',
    'svc_level' => 'QU5',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 3 (Taroon Update 5)'
};

$::distro_id{'RedHatELES3-QU6-x86_64'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '3',
    'svc_level' => 'QU6',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 3 (Taroon Update 6)'
};

$::distro_id{'RedHatELES3-QU7-x86_64'}=
{
    'distro_name' => 'RedHatEL-ES',
    'distro_version' => '3',
    'svc_level' => 'QU7',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux ES release 3 (Taroon Update 7)'
};

#------------------------------i386 WS------------------------------------
# rhel5 client
$::distro_id{'RedHatELClient5-GA-i386'}=
{
    'distro_name' => 'RedHatEL-Client',
    'distro_version' => '5',
    'svc_level' => 'GA',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux Client release 5 (Tikanga)',
};

$::distro_id{'RedHatELWS4-GA-i386'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '4',
    'svc_level' => 'GA',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 4 (Nahant)'
};

$::distro_id{'RedHatELWS4-QU1-i386'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '4',
    'svc_level' => 'QU1',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 4 (Nahant Update 1)'
};

$::distro_id{'RedHatELWS4-QU2-i386'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '4',
    'svc_level' => 'QU2',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 4 (Nahant Update 2)'
};

$::distro_id{'RedHatELWS4-QU3-i386'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '4',
    'svc_level' => 'QU3',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 4 (Nahant Update 3)'
};

$::distro_id{'RedHatELWS4-QU4-i386'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '4',
    'svc_level' => 'QU4',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 4 (Nahant Update 4)'
};

$::distro_id{'RedHatELWS4.5-GA-i386'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '4.5',
    'svc_level' => 'GA',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 4 (Nahant Update 5)'
};

$::distro_id{'RedHatELWS3-GA-i386'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '3',
    'svc_level' => 'GA',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 3 (Taroon)'
};

$::distro_id{'RedHatELWS3-QU1-i386'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '3',
    'svc_level' => 'QU1',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 3 (Taroon Update 1)'
};

$::distro_id{'RedHatELWS3-QU2-i386'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '3',
    'svc_level' => 'QU2',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 3 (Taroon Update 2)'
};

$::distro_id{'RedHatELWS3-QU3-i386'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '3',
    'svc_level' => 'QU3',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 3 (Taroon Update 3)'
};

$::distro_id{'RedHatELWS3-QU4-i386'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '3',
    'svc_level' => 'QU4',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 3 (Taroon Update 4)'
};

$::distro_id{'RedHatELWS3-QU5-i386'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '3',
    'svc_level' => 'QU5',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 3 (Taroon Update 5)'
};

$::distro_id{'RedHatELWS3-QU6-i386'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '3',
    'svc_level' => 'QU6',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 3 (Taroon Update 6)'
};

$::distro_id{'RedHatELWS3-QU7-i386'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '3',
    'svc_level' => 'QU7',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 3 (Taroon Update 7)'
};

$::distro_id{'RedHatELWS2-GA-i386'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '2.1',
    'svc_level' => 'GA',
    'arch' => 'i386',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Linux Advanced Server release 2.1WS'
};

#------------------------------x86_64 WS------------------------------------
# rhel5 x86_64 client
$::distro_id{'RedHatELClient5-GA-x86_64'}=
{
    'distro_name' => 'RedHatEL-Client',
    'distro_version' => '5',
    'svc_level' => 'GA',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux Client release 5 (Tikanga)',
};

$::distro_id{'RedHatELWS4-GA-x86_64'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '4',
    'svc_level' => 'GA',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 4 (Nahant)'
};

$::distro_id{'RedHatELWS4-QU1-x86_64'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '4',
    'svc_level' => 'QU1',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 4 (Nahant Update 1)'
};

$::distro_id{'RedHatELWS4-QU2-x86_64'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '4',
    'svc_level' => 'QU2',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 4 (Nahant Update 2)'
};

$::distro_id{'RedHatELWS4-QU3-x86_64'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '4',
    'svc_level' => 'QU3',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 4 (Nahant Update 3)'
};

$::distro_id{'RedHatELWS4-QU4-x86_64'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '4',
    'svc_level' => 'QU4',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 4 (Nahant Update 4)'
};

$::distro_id{'RedHatELWS4.5-GA-x86_64'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '4.5',
    'svc_level' => 'GA',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 4 (Nahant Update 5)'
};

$::distro_id{'RedHatELWS3-GA-x86_64'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '3',
    'svc_level' => 'GA',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 3 (Taroon)'
};

$::distro_id{'RedHatELWS3-QU1-x86_64'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '3',
    'svc_level' => 'QU1',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 3 (Taroon Update 1)'
};

$::distro_id{'RedHatELWS3-QU2-x86_64'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '3',
    'svc_level' => 'QU2',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 3 (Taroon Update 2)'
};

$::distro_id{'RedHatELWS3-QU3-x86_64'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '3',
    'svc_level' => 'QU3',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 3 (Taroon Update 3)'
};

$::distro_id{'RedHatELWS3-QU4-x86_64'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '3',
    'svc_level' => 'QU4',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 3 (Taroon Update 4)'
};

$::distro_id{'RedHatELWS3-QU5-x86_64'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '3',
    'svc_level' => 'QU5',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 3 (Taroon Update 5)'
};

$::distro_id{'RedHatELWS3-QU6-x86_64'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '3',
    'svc_level' => 'QU6',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 3 (Taroon Update 6)'
};

$::distro_id{'RedHatELWS3-QU7-x86_64'}=
{
    'distro_name' => 'RedHatEL-WS',
    'distro_version' => '3',
    'svc_level' => 'QU7',
    'arch' => 'x86_64',
    'id_name' => '/etc/redhat-release',
    'id_type' => 'file',
    'id_val' => 'Red Hat Enterprise Linux WS release 3 (Taroon Update 7)'
};

1;
