#!/usr/bin/perl
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2005,2007 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#
# @(#)66   1.14   src/csm/core/pm/ApacheUtils.pm.perl, setup, csm_rfish, rfishs001b 3/5/07 01:07:55
#
#####################################################################

#$::DEBUG = 1;
package ApacheUtils;

use strict;
use File::Basename;	# Provides basename()
use File::Path;		# Provides mkpath and rmtree

my $csmroot;
my ($MSGCAT, $MSGMAPPATH, $MSGSET);

# $NodeUtils::errno;          # Will be set if an error occurs.  You must zero
# this out before calling a NodeUtils function,
# if you want to check it afterwards.

BEGIN
{

    #    This enables us to redirect where it looks for other CSM files during development
    $csmroot = $ENV{'CSM_ROOT'} ? $ENV{'CSM_ROOT'} : '/opt/csm';

    $MSGCAT = 'nodecmds.cat';
    if (defined $::MSGMAPPATH)
    {
        $MSGMAPPATH = $ENV{'CSM_ROOT'} ? "$csmroot/msgmaps" : $::MSGMAPPATH;
    }
    else
    {
        $MSGMAPPATH = "$csmroot/msgmaps";
    }
    $MSGSET = 'NodeUtils';
}

umask(0022);   #  This sets umask for all CSM files so that group and world only
               #  have read permissions.
               #  To change it, simply use the umask call in your script, after
               #  the "use NetworkUtils;" line

# get the definitions we need for this command
#    in this case get_OSDefs uses the attrs of the management
#    server to identify the correct definitions
%::msOSDefs= ServerUtils->get_OSDefs();

#-------------------------------------------------------------------------------

=head1    ApacheUtils


This perl module contains the subroutines needed to automataically configure
the Apache HTTP server.


If adding to this file, please take a moment to ensure that:

    1.  Your contrib has a readable pod header describing the purpose and use 
        of the subroutine.

    2. Your contrib is under the correct heading and is in alphabetical order
        under that heading.

    3. You  have run tidypod on your this file and copied 
       ApacheUtils.pm.perl.tdy to ApacheUtils.pm.perl before checking it in.

       You can examine the pod output in ApacheUtils.pm.perl.html file in a 
       browser.

    4. Copy the new ./ApacheUtils.pm.perl.html to /project/csm/www. 
       This will update the pod for the team.

=cut

#-------------------------------------------------------------------------------

=head2    Apache Support

=cut


#-------------------------------------------------------------------------------

=head3    setup_apache_csminstall

        Set up the Apache 2 HTTP server for use by CSM install of the OS.
		This setup includes the following:
	    - Install Apache2 RPMs (assume they have already been copied)
		- Copy the csminstall_httpd.conf.tmpl file to 
		  $HTTPD_CONF_DIR/csminstall.conf, and fill in the "/csminstall" or
		  "/csmserver" directory name in the resulting file.
		- Set the security context on the /csminstall or /csmserver directory.
	    - Start the Apache server.

        Arguments:
	    $csminstall_top - (OPTIONAL)
	                    The location of the /csminstall directory.  If not
	                    provided, this defaults to /csminstall.  Otherwise,
	                    a different directory can be specified, such as
	                    /csmserver (for IS), or a user-defined directory.
	                    This value is used to detemrine where to find the 
	                    Apache RPMs, and which directory to set the SELinux
						security context for.
        Returns:
	    0 = Apache was set up without errors.
	    1 = There was a problem setting up Apache
        Globals:
	    $::msOSDefs{'HTTPD_CONF_DIR'} - Pathname to the http config directory.
        Error:
        Example:
			ApacheUtils->setup_apache_csminstall($csminstall_top);
        Comments:

=cut

#-------------------------------------------------------------------------------

sub setup_apache_csminstall
{
    my ($self, $csminstall_top) = @_;
    my $status=0;
	my $restart_required;

	# Determine the CSMINSTALL_TOP value
    if ($csminstall_top)
    {
        $::CSMINSTALL_TOP = $csminstall_top;
    }
    else
    {
        $::CSMINSTALL_TOP = $::CSMINSTDIR; 		# Default to /csminstall
    }

	ApacheUtils->initialize_vars();
	ApacheUtils->copy_httpd_conf_template($::CSMINSTALL_TOP);
	$restart_required = 1;	# After copying the template, must restart httpd

	ApacheUtils->set_SELinux_context($::CSMINSTALL_TOP, "system_u:object_r:httpd_sys_content_t");
    ApacheUtils->start_apache($restart_required);

    return ($status);
}
#-------------------------------------------------------------------------------

=head3    setup_apache_websm

        Set up the Apache 2 HTTP server for use by WebSM.  This setup includes 
		the following:
	    - Install Apache2 RPMs (assume they have already been copied)
	    - Get the DocumentRoot directory from the http configuration file.
	    - Add the FollowSymLinks directive to the http configuration file
	         for the DocumentRoot directory.
	    - Start the Apache server.

        Arguments:
	    $DocumentRoot - This subroutine will fill in the DocumentRoot
	                    variable based on the value it finds in the http 
	                    configuration file.  This variable should be passed
	                    in as a reference (\$DcoumentRoot).
	    $csminstall_top - (OPTIONAL)
	                    The location of the /csminstall directory.  If not
	                    provided, this defaults to /csminstall.  Otherwise,
	                    a different directory can be specified, such as
	                    /csmserver (for IS), or a user-defined directory.
	                    This value is used to detemrine where to find the 
	                    Apache RPMs.
        Returns:
	    0 = Apache was set up without errors.
	    1 = There was a problem setting up Apache
        Globals:
	    $::msOSDefs{'HTTPD_CONF'} - Pathname to the http configuration file.
        Error:
        Example:
			ApacheUtils->setup_apache_websm(\$DocumentRoot);
        Comments:

=cut

#-------------------------------------------------------------------------------

sub setup_apache_websm
{
    my ($self, $DocumentRoot_ref, $csminstall_top) = @_;
    my $status=0;
    my $docroot;
	my $restart_required;

	my $orig_MSGCAT = $::MSGCAT;
	my $orig_MSGSET = $::MSGSET;
	$::MSGCAT = "csmInstall.cat";
	$::MSGSET = "csminstall";


	# Determine the CSMINSTALL_TOP value
    if ($csminstall_top)
    {
        $::CSMINSTALL_TOP = $csminstall_top;
    }
    else
    {
        $::CSMINSTALL_TOP = $::CSMINSTDIR; 		# Default to /csminstall
    }

	ApacheUtils->initialize_vars();
    ApacheUtils->install_apache();
    $docroot = ApacheUtils->get_DocumentRoot();
    $restart_required = ApacheUtils->add_FollowSymLinks($docroot);
    ApacheUtils->start_apache($restart_required);

    $$DocumentRoot_ref = $docroot;

	$::MSGCAT = $orig_MSGCAT;
	$::MSGSET = $orig_MSGSET;

    return ($status);
}

#-------------------------------------------------------------------------------

=head3    initialize_vars

		Initialize global variables.

        Arguments: NONE
        Returns: NONE
        Globals:
        Error:
        Example:
	    ApacheUtils->initialize_vars();
        Comments:

=cut

#-------------------------------------------------------------------------------
sub initialize_vars
{
	# Get the pkgdefs for the current machine (MS or IS)
	%::pkgdefs = ServerUtils->get_pkgdefs();

	# Get the attributes for the install server from the local machine,
	# just in case they were not already set.
	$::PREREQS_ATTR{'OSName'}              = NodeUtils->get_OSName;
	$::PREREQS_ATTR{'PkgArchitecture'}     = NodeUtils->get_PkgArchitecture;
	$::PREREQS_ATTR{'DistributionName'}    = NodeUtils->get_DistributionName;
	$::PREREQS_ATTR{'DistributionVersion'} = NodeUtils->get_DistributionVersion;
	$::PREREQS_ATTR{'CsmCoreVersion'} = NodeUtils->get_CSMVersion("csm\.core");

	if ($::PREREQS_ATTR{'PkgArchitecture'} =~ /i.86/)
	{
		$::PREREQS_ATTR{'PkgArchitecture'} = "i386";
	}
	if (length($::PREREQS_ATTR{'CsmCoreVersion'}) == 0)
	{
		MessageUtils->message('E2', 'EMsgNO_CORE');
	}

	# Set installation paths
	$::INSTALLDIR_CSM   = $::CSMINSTALL_TOP . "/csm";
	$::INSTALLDIR_CSMVR =
	  $::INSTALLDIR_CSM . "/" . $::PREREQS_ATTR{CsmCoreVersion};
	$::INSTALLDIR_CSMVRBIN = $::INSTALLDIR_CSMVR . "/bin";
	$::INSTALLDIR_OS       =
	    $::CSMINSTALL_TOP . "/"
	  . $::PREREQS_ATTR{"OSName"} . "/"
	  . $::PREREQS_ATTR{'DistributionName'};
	$::INSTALLDIR_OSVER =
	  $::INSTALLDIR_OS . "/" . $::PREREQS_ATTR{DistributionVersion};
	$::INSTALLDIR_OSVER_ARCH =
	  $::INSTALLDIR_OSVER . "/" . $::PREREQS_ATTR{'PkgArchitecture'};
	$::INSTALLDIR_OSCSM  = $::INSTALLDIR_OS . "/csm";
	$::INSTALLDIR_CSMVER =
	  $::INSTALLDIR_OSCSM . "/" . $::PREREQS_ATTR{CsmCoreVersion};
	my $INSTALLDIR_OS_NAME = $::PREREQS_ATTR{DistributionName};

	if ($::PREREQS_ATTR{DistributionName} =~ /RedHat/)
	{
		$INSTALLDIR_OS_NAME = "RedHat";
	}
    
    my ($effective_distro_name) =
        NodeUtils->getEffectiveDistro($::PREREQS_ATTR{DistributionName});
	my $is_sl = NodeUtils->get_ServiceLevel;
	if ($effective_distro_name =~ /RedHat/)
	{
		my $my_dirname;
		if ($is_sl eq "GA")
		{
			$my_dirname =
			    $::PREREQS_ATTR{'DistributionName'}
			  . $::PREREQS_ATTR{'DistributionVersion'} . "-"
			  . $::PREREQS_ATTR{'PkgArchitecture'};
		}
		else
		{
			$my_dirname =
			    $::PREREQS_ATTR{'DistributionName'}
			  . $::PREREQS_ATTR{'DistributionVersion'} . "-"
			  . $is_sl;
		}
		$::INSTALLDIR_OS_NAME_RPMS =
		  $::INSTALLDIR_OSVER_ARCH . "/" . $my_dirname .
          "/". $::pkgdefs{DISTRO_RPMDIR};
	}
	else
	{
		$::INSTALLDIR_OS_NAME_RPMS =
		  $::INSTALLDIR_OSVER_ARCH . "/" . $is_sl . "/RPMS";
	}

	$::INSTALLDIR_CSMBIN = $::INSTALLDIR_CSMVER . "/bin";
	$::INSTALLDIR_CSMPKG = $::INSTALLDIR_CSMVER . "/packages";
}

#-------------------------------------------------------------------------------

=head3    install_apache

        Install all the Apache RPMs on the current machine.  This machine might
	be either the install server or the management server. 

        Arguments: NONE
        Returns: ??
        Globals: %::pkgdefs{apache_packages}
        Error:
        Example: ApacheUtils->install_apache();
        Comments:

=cut

#-------------------------------------------------------------------------------

sub install_apache()
{
	my $routine = "install_apache";
	print "ENTERING: $routine\n" if $::DEBUG;


	#SSS START
	my $location = 'InstallServer';
	my $sequence = '20'; # that stands for apache_packages
	my $rpmList = $::pkgdefs{'pkgs'}{$location}{$sequence};
	if ($rpmList)
	{
		my @rpmDirs = ( $::INSTALLDIR_OS_NAME_RPMS);
		$rpmList->searchAllRpmsInDirList( \@rpmDirs);
		my $installFlag = '-U';
		$rpmList->installAll($installFlag);
	}
	print "LEAVING: $routine\n" if $::DEBUG;
}

#-------------------------------------------------------------------------------

=head3    get_DocumentRoot

        Determine the document root from the Apache configuration. 
	The first time the DocumentRoot is obtained, it is cached, so that
	the next time get_DocumentRoot is called, the cached copy is returned. 

        Arguments:
		None
        Returns:
		value from http conf, or the cached value
        Globals:
		$::__HTTP_DOCUMENT_ROOT  (do not reference this directly)
		$::msOSDefs{'HTTPD_CONF'} - Pathname to http config file.
        Error: EMsgCANT_READ_FILE
        Example:
                $DocumentRoot =
                    NodesetUtils->get_DocumentRoot();
        Comments:

=cut

#-------------------------------------------------------------------------------

sub get_DocumentRoot
{
    my $DocumentRoot;
    my $line;
    my $var;
    my $value;

    # If the value is already cached, or set in the environment above, then 
    # use it.  The global variable should not be used directly except within 
    # this subroutine.
    if (! $::__HTTP_DOCUMENT_ROOT)
    {
	#$::HTTPD_CONF = "/etc/apache2/default-server.conf";	# For SLES
	#$::HTTPD_CONF = "/etc/httpd/conf/httpd.conf";	# For RedHat
	
	my $docroot_string = "DocumentRoot";	# Same for RedHat and SLES

	my $httpd_conf = $::msOSDefs{'HTTPD_CONF'};
	open (HTTPD_CONF, "<$httpd_conf") 
	    || MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 
					 'csminstall','E2', 
					 'EMsgCANT_READ_FILE', $httpd_conf);

	while (<HTTPD_CONF>)
	{
	    $line = $_;
	    if (/^\s*$docroot_string\s/)
	    {
		($var, $value) = split (/\s+/, $line);
		chomp $value;
		$value =~ s/"//g;
		last;
	    }
	}
	close(HTTPD_CONF);

	$::__HTTP_DOCUMENT_ROOT = $value;
    }

    return ($::__HTTP_DOCUMENT_ROOT);
}

#-------------------------------------------------------------------------------

=head3    add_FollowSymLinks

        Ensure that the FollowSymLinks directive is enabled in the 
	DocumentRoot directory definition inside the http configuration file. 
	If it is missing, add it. If it is set to "-FollowSymLinks", change it
	to "+FollowSymLinks".

	The FollowSymLinks directive is required because a symbolic link to
	the /csminstall directory will be created under DocumentRoot, and the
	HTTP server must be able to get to that directory.

        Arguments:
		DocumentRoot - DocumentRoot attribute from http config file.
		    If not provided, calls get_DocumentRoot, which causes
		    http config file to be parsed (again).
        Returns:
			0 - http server does not need to be restarted (no changes made)
			1 - http server needs to be restarted (httpd config file changes)
        Globals:
		$::msOSDefs{'HTTPD_CONF'} - Pathname to http config file.
        Error:
		EMsgCANT_READ_FILE
		EMsgCANT_WRITE_FILE
		EMsgNO_RENAME
        Example:
		ApacheUtils->add_FollowSymLinks($DocumentRoot);
        Comments:

=cut

#-------------------------------------------------------------------------------

sub add_FollowSymLinks()
{
    my ($self, $DocumentRoot) = @_;
    if (! $DocumentRoot) 
    {
		$DocumentRoot = ApacheUtils->get_DocumentRoot();
    }

	my $restart_required = 0;
    my $httpd_conf = $::msOSDefs{'HTTPD_CONF'};
    my $new_httpd_conf = "${httpd_conf}.NEW";
    if (-f $new_httpd_conf)
    {
		rmtree ($new_httpd_conf, $::VERBOSE, 1);
    }

    open (HTTPD_CONF, "<$httpd_conf") 
		|| MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 
				     'csminstall','E2', 
				     'EMsgCANT_READ_FILE', $httpd_conf);

    open (NEW_HTTPD_CONF, ">$new_httpd_conf") 
		|| MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 
				     'csminstall','E2', 
				     'EMsgCANT_WRITE_FILE', $new_httpd_conf);


    my $inside_docroot_def = 0;
    my $found_Options = 0;
    my $found_FollowSymLinks = 0;
    my $rewrite_httpd_conf = 1;

    PROCESS_HTTPD: while (<HTTPD_CONF>)
    {
	if (/^\s*\<\s*Directory\s*"$DocumentRoot"\s*\>/i)
	{
	    $inside_docroot_def = 1;
	    ($::DEBUG) && print "Inside $DocumentRoot Directory Stanza.\tLine = $_\n";
	}

	if ($inside_docroot_def and /^\s*\<\/Directory\>/i)
	{
	    $inside_docroot_def = 0;
	    ($::DEBUG) && print "Exiting $DocumentRoot Directory Stanza.\tLine = $_\n";
	    # If the "Options" directive was not found at all, then add one.
	    if (! $found_Options)
	    {
			($::DEBUG) && print "Options Directive not found.  Adding \"Options +FollowSymLinks\"\n";
			print NEW_HTTPD_CONF "\tOptions +FollowSymLinks\n";
	    }
	}

	# Handle the "Options" line inside the DocumentRoot Directory stanza
	if ($inside_docroot_def and /^(\s*)Options\s*/i)
	{
	    $found_Options = 1;

	    chomp;
	    ($::DEBUG) && print "Found Options Line:  $_\n";

	    # Figure out how much the line is indented, based on the pattern
	    # match above.  Note that $1 matches what is in parentheses.
	    my $indent = $1;
	    ($::DEBUG) && print "INDENT = [$indent]\n";

	    my ($opt, @options) = split;

	    my @new_options;
	    foreach my $o (@options)
	    {
			if ($o =~ /^\+FollowSymLinks/i or $o =~ /^FollowSymLinks/i)
			{
				# Set a flag that indicates that FollowSymlinks is already
				# turned on, and that the http config file does not
				# have to get rewritten.
				($::DEBUG) && print "Found FollowSymLinks.\tLine = $_\n";
				$rewrite_httpd_conf = 0;
				$found_FollowSymLinks = 1;

				last PROCESS_HTTPD;
			}

			# If FollowSymLinks is turned off, turn it back on.
			if ($o =~ /^-FollowSymLinks/i)
			{
				($::DEBUG) && print "Found -FollowSymLinks.  Changing to +FollowSymLinks.\tLine = $_\n";
				$found_FollowSymLinks = 1;
				push (@new_options, "+FollowSymLinks");
			}
			else
			{
				# Keep all other options.
				push (@new_options, $o);
			}
	    }

	    # The FollowSymLinks option was not found in the OPTIONS
	    if (! $found_FollowSymLinks)
	    {
			push (@new_options, "+FollowSymLinks");
	    }

	    print NEW_HTTPD_CONF "$indent$opt "
				 . join(" ", @new_options) . "\n";
	    next;
	}

	# If we get through all the checks, just print the line.
	print NEW_HTTPD_CONF "$_";
    }
    close(HTTPD_CONF);
    close(NEW_HTTPD_CONF);

    # Rewrite the http config file, but only if the FollowSymLinks option was
    # not already turned on.
    if ($rewrite_httpd_conf)
    {
		# Replace the original file with the new file.  Save the original
		# file to a backup copy.

		my $httpd_conf_bak = $httpd_conf . ".bak";
		if (-f $httpd_conf_bak)
		{
			rmtree ($httpd_conf_bak, $::VERBOSE, 1);
		}


		# Print a message describing what we are doing.
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 
						 'csminstall','I', 
						 'IMsgAdding_FollowSymLinks', 
						 $httpd_conf, $httpd_conf_bak);

		rename ($httpd_conf, $httpd_conf_bak) || 
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 
						 'csminstall','E2', 
						 'EMsgNO_RENAME', 
						 $httpd_conf, $httpd_conf_bak);
		rename ($new_httpd_conf, $httpd_conf) ||
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 
						 'csminstall','E2', 
						 'EMsgNO_RENAME', 
						 $new_httpd_conf, $httpd_conf);

		# The httpd config file changed, so the http daemon must be restarted
		$restart_required = 1;
    }
    else
    {
		# Just clean up the temp file
		rmtree ($new_httpd_conf, $::VERBOSE, 1);

		# The httpd config file did not change, so the http daemon 
		# does not need to be restarted
		$restart_required = 0;
    }

	return $restart_required;
}

#-------------------------------------------------------------------------------

=head3    start_apache

	Start the Apache2 HTTP server.  Run "apachectl" on RedHat, and
	"rcapache2" on SLES.  Use the "graceful" directive which restarts
	the apache daemon.  If it is not running start it.  The graceful
	directive differs from a regular restart in that existing connections
	are not aborted.
	
        Arguments: 
			restart_required - if 1, the daemon must be restarted.
			                   if 0, only start the daemon if not running
        Returns: N/A (exits the program if apache fails to start)
        Globals: $::APACHECTL
        Error: EMsgCANT_START_APACHE
        Example: ApacheUtils->start_apache();
        Comments:

=cut

#-------------------------------------------------------------------------------

sub start_apache()
{
    my ($self, $restart_required) = @_;

    # Determine if apache is running.  If not, then start it.
    my $cmd = NetworkUtils->service($::APACHE_SERVICE, "status");
    NodeUtils->runcmd($cmd, -1); #Don't show errors, just get rc.
    if ($::RUNCMD_RC)
    {
        # Apache is not running, so start it.
        MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 
                     'csminstall','V', 
                     'IMsgSTARTING_APACHE');

        NodeUtils->runcmd("$::APACHECTL start",0);
        if ($::RUNCMD_RC)
        {
            MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 
                         'csminstall','E2', 
                         'EMsgCANT_START_APACHE');
        }
    }
    elsif ($restart_required)
    {
        # The server is already running, but it needs to be restarted

        MessageUtils->messageFromCat('csmInstall.cat', 
                                        $::MSGMAPPATH, 
                                        'csminstall','V', 
                                        'IMsgSTARTING_APACHE');

        # Do a graceful restart.
        # $::APACHECTL is set to 'apachectl' for RedHat or 'rcapache2' for SLES.
        NodeUtils->runcmd("$::APACHECTL graceful",0);
        if ($::RUNCMD_RC)
        {
            MessageUtils->messageFromCat('csmInstall.cat', 
                                            $::MSGMAPPATH, 
                                            'csminstall','E2', 
                                            'EMsgCANT_START_APACHE');
        }

    }

    return 0;
}

#-------------------------------------------------------------------------------

=head3    test_apache

	Test the Apache2 HTTP server.  
	Run "service httpd status" to determine if the daemon is running.
	On RedHat, the return code=0 if running, >0 if not running.
	
        Arguments: 
				Server (OPTIONAL) - 
				          The hostname or IP address of the HTTP server.
		                  If not provided, defaults to current machine
        Returns: 0 if apache is running, >0 if not
        Globals: NONE
        Error: 
        Example: ApacheUtils->test_apache();
        Comments:

=cut

#-------------------------------------------------------------------------------

sub test_apache()
{
	my ($self, $server) = @_;

	if (! $server)
	{
		$server = `hostname`;
		chomp $server;
	}

	my $rc = 0;

    MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 
				 'csminstall','V', 
				 'IMsgTESTING_APACHE');

	my $cmd = NetworkUtils->service($::APACHE_SERVICE, "status");
	NodeUtils->runcmd($cmd, 0);
    if ($::RUNCMD_RC)
    {
		#print "Apache is not running\n";
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 
						 'csminstall','W', 
						 'IMsgHTTP_NOT_RUNNING', $server);

		$rc = $::RUNCMD_RC;
    }
	else
	{
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 
						 'csminstall','W', 
						 'IMsgHTTP_IS_RUNNING', $server);

	}

	return $rc;
}

#-------------------------------------------------------------------------------

=head3    test_http_wget

        Arguments:
				Filename (REQUIRED) -
				          The file to attempt to get from the HTTP server
				Server (OPTIONAL) - 
				          The hostname or IP address of the HTTP server.
		                  If not provided, defaults to current machine
        Returns:
				0 = success
				1 = cannot run wget because it is not installed.
				2 = error - didn't provide filename parameter.
				3 = error - something went wrong with wget.
        Globals: none
        Error:
				If the wget fails, this subroutine exits the program with an
				error message.  It does not return with a bad return code.
        Example:
				$rc = ApacheUtils->test_http_wget("$testfile");
        Comments:

=cut

#-------------------------------------------------------------------------------
sub test_http_wget
{
	my ($self, $filename, $server) = @_;

	my $rc = 0;

	if (! $server)
	{
		$server = `hostname`;
		chomp $server;
	}

	if (! $filename)
	{
		print "No filename provided\n";
		return 2;
	}

	MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 
				 'csminstall','V', 
				 'IMsgTESTING_HTTP_WGET', $filename, $server);

	my $slash = "/";
	if ($filename =~ /^\//) # if it starts with a slash(/)
	{
		$slash = "";
	}

	require HTTP::Request;
	require LWP::UserAgent;
	
	my $useragent = LWP::UserAgent->new;
	my $request = HTTP::Request->new(GET => "http://$server$slash$filename");
	my $response = $useragent->request($request);
	if (! $response->is_success)
	{
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 
					 'csminstall','E2', 
					 'EMsgHTTP_GET_FAILED', $server);
		$rc = 3;
	}

	return ($rc);
}

#-------------------------------------------------------------------------------

=head3    set_SELinux_context

        Set the specified SELinux security context for all the specified file 
        or directory.  You can also pass wildcards in the filename, which will 
        get processed by the shell when calling the chcon command.

        The -R flag is passed to the chcon command which sets the context 
        recursively down the entire specified directory tree.

        The full context label must be provided.  You cannot just provide the
        type.  For example, "system_u:object_r:httpd_sys_content_t". 

        Arguments:
            file_or_directory - File or directory
            context           - SELinux security context
                                If not provided, defaults to HTTP context.
        Returns:
            NONE - exits program on failure
        Globals:
        Error:
                  'EMsgCHCON_FAILED' - chcon cmd cannot set security context
        Example:  
            ApacheUtils->set_SELinux_context("/csminstall", "system_u:object_r:httpd_sys_content_t");

=cut

#-------------------------------------------------------------------------------

sub set_SELinux_context
{
    my ($self, $target, $context) = @_;

    # Default to context needed for HTTP
    if (! $context)
    {
        $context = "system_u:object_r:httpd_sys_content_t";
    }

    # Set the security context of the DOCROOT/csminstall directory
    # to "httpd_sys_content_t". 
    #
    # First we need to check if the chcon command exists, and if SELinux 
    # is active in this kernel.
    # Other useful SELinux commands:
    #      "ls --context" show file's context.
    #      "id --context" show user's context.
    #      "restorecon" restores the original, preset context of a file.
    #      "sestatus" shows SELinux status)
    #      "selinuxenabled" shows whether SELinux is enabled(rc=0) or not(rc<0)
    if (NodeUtils->isSELinux)
    {
        # SELinux is active in the kernel, so set the security context
        # of all the files under DOCROOT/csminstall.
        MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 
                                     'csminstall','V', 
                                     'IMsgSETTING_SECURITY_CONTEXT', 
                                     $target, $context);
        NodeUtils->runcmd("/usr/bin/chcon -R $context $target",0);
        if ($::RUNCMD_RC)
        {
            MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 
                         'csminstall','E2', 
                         'EMsgCHCON_FAILED', $target, $context);
        }
    }
}

#-------------------------------------------------------------------------------

=head3    copy_httpd_conf_template

        Copy the /opt/csm/install/csminstall_httpd.conf.tmpl file to 
		HTTPD_CONF_DIR/csminstall.conf.  Also, modify the #CSMINSTALL# variable
		in the file to refer to the csminstall_top directory.

        Arguments:
            csminstall_top - pathname of /csminstall, /csmserver, or 
                             user-defined directory.
        Returns:
            NONE - exits program on failure
        Globals:
        Error:
            'EMsgCANT_READ_FILE' - Can't open template file
            'EMsgCANT_WRITE_FILE' - Can't write to target .conf file
        Example:  
			ApacheUtils->copy_httpd_conf_template("/csminstall");
        Comments:

=cut

#-------------------------------------------------------------------------------
sub copy_httpd_conf_template
{
	my $routine = "copy_httpd_conf_template";
	print "ENTERING: $routine\n" if $::DEBUG;
    my ($self, $csminstall_top) = @_;

    if ($csminstall_top !~ /^\/$/)
    {
		$csminstall_top =~ s:/$::;	# Strip trailing /
    }

	my $httpd_conf_template = "/opt/csm/install/csminstall_httpd.conf.tmpl";
    my $httpd_conf_target = $::msOSDefs{'HTTPD_CONF_DIR'} . "/csminstall.conf";

    open (HTTPD_CONF_TEMPLATE, "<$httpd_conf_template")
        || MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 
						'csminstall','E2', 'EMsgCANT_READ_FILE', 
						$httpd_conf_template);
    open (HTTPD_CONF, ">$httpd_conf_target")
        || MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 
						'csminstall', 'E2', 'EMsgCANT_WRITE_FILE', 
						$httpd_conf_target);

	MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 
						'csminstall', 'V', 'IMsgCOPYING_HTTPD_CONF', 
						$httpd_conf_template, $httpd_conf_target);

	while (<HTTPD_CONF_TEMPLATE>)
	{
		s/#CSMINSTALL#/$csminstall_top/g;    # /csminstall or /csmserver
		print HTTPD_CONF $_;
	}

	close (HTTPD_CONF_TEMPLATE);
	close (HTTPD_CONF);

	print "LEAVING: $routine\n" if $::DEBUG;
}

1;
