# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2007 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#####################################################################
#                                                                   #
# Module:  CSMDefs.pm                                               #
#                                                                   #
#                                                                   #
# Description:   This module contains definitions used by CSM       #
#                commands.  These are definitions of CSM            #
#                directories and commands.  These definitions       #
#                are not specific to any operating system or        #
#                distribution.                                      #
#                                                                   #
# Subroutines:   None                                               #
#                                                                   #
# Notes:                                                            #
#                                                                   #
#####################################################################
# @(#)46   1.50.1.50   src/csm/core/pm/CSMDefs.pm.perl, setup, csm_rfish, rfishs001b 8/10/06 01:23:10

package CSMDefs;

BEGIN
{
	use File::Basename;    # - this gives us the path of the command
	($::Bin) = dirname($0);    # - for this command we assume the modules and
	                           #     message maps are in the same place
}
use lib "$::Bin";

use NodeUtils;
use Rpm::RpmList;
use Rpm::Child::RsctRpmList;
use Rpm::Child::HAMSRpmList;

#-------------------------------------------------------------------
#    Global Definitions
#-------------------------------------------------------------------

#--Default Values--

#management server is an install server (by default)
$::MS_INSTALL_SERVER = 1;   

#directory used to store CSM repository on Install servers
$::SERVER_DIRECTORY  = "/csmserver";    

$::NOK = 1;
$::OK  = 0;

# The string that indicates a "Lite" node
$::CSMLITE = 'MinManaged';

# CSM and RSCT Directories
$::CSMTOP            = "/opt/csm";
$::CSMREQS           = $::CSMTOP . "/reqs";
$::CSMBIN            = $::CSMTOP . "/bin";
$::CSMCSMBIN         = $::CSMTOP . "/csmbin";
$::OPTCSMINSTALL     = $::CSMTOP . "/install";
$::RSCTBIN           = "/usr/sbin/rsct/bin";
$::CSMINSTDIR        = "/csminstall";
if (NodeUtils->isHMC && ($ENV{'DC_ENVIRONMENT'} ne 1) && ($ENV{'DC_ENVIRONMENT'} ne 1))
{
    $::CSMINSTDIR    = "/home/hscroot/csm/csminstall";
}
$::CSMSTATUSDIR      = "$::CSMINSTDIR/csm/status";
$::CSMCFGDIR         = $::CSMINSTDIR . "/csm/config/";
$::CSMTMP            = "/var/opt/csm/tmp";
$::SERVER_STATUS_DIR = $::SERVER_DIRECTORY . "/csm/status";

$::CSMCLIENTMNTDIR = "/var/opt/csm/mnt";
$::CSMDRIVERDIR    = "$::CSMINSTDIR/csm/drivers";
$::CSMUSERKERNELDIR  = "$::CSMINSTDIR/csm/usrkernel";

# CSM Files
$::NODEMAP_FILE = "$::CSMCFGDIR/nodemap";
$::CFGINFOFILE  = "/opt/csm/install/configinfo";

# CSM and RSCT Commands
$::CFORCE             = $::CSMBIN . "/cfmupdatenode";
$::CHHWDEV            = $::CSMBIN . "/chhwdev";
$::CHNODE             = $::CSMBIN . "/chnode";
$::CREATEDHCP         = $::CSMCSMBIN . "/createDHCP";
$::CREATEHWDEV        = $::CSMCSMBIN . "/createhwdev";
$::CREATENODE         = $::CSMCSMBIN . "/createnode";
$::CSM2NIMGRPS        = $::CSMBIN . "/csm2nimgrps";
$::CSM2NIMNODES       = $::CSMBIN . "/csm2nimnodes";
$::CHECK_GPL_PACKAGES = $::CSMCSMBIN . "/check_gpl_packages";
$::DSH                = $::CSMBIN . "/dsh";
$::DCP                = $::CSMBIN . "/dcp";
$::GETMACS            = $::CSMBIN . "/getmacs";
$::HWDEVGRP           = $::CSMBIN . "/hwdevgrp";
$::LSCONDRESP         = $::RSCTBIN . "/lscondresp";
$::LSHWDEV            = $::CSMBIN . "/lshwdev";
$::LSNODE             = $::CSMBIN . "/lsnode";
$::MGMTSVR            = $::CSMBIN . "/mgmtsvr";
$::MKGETMACRD         = $::CSMCSMBIN . "/mkgetmacrd";
$::MONITORINSTALL     = $::CSMBIN . "/monitorinstall";
$::NODEGRP            = $::CSMBIN . "/nodegrp";
$::REMOTESHELL_EXPECT = $::CSMCSMBIN . "/remoteshell.expect";
$::RMCONDRESP         = $::RSCTBIN . "/rmcondresp";
$::RMHWDEV            = $::CSMBIN . "/rmhwdev";
$::RMNODE             = $::CSMBIN . "/rmnode";
$::RPOWER             = $::CSMBIN . "/rpower";
$::SMSUPDATENODE      = $::CSMBIN . "/smsupdatenode";
$::STARTCONDRESP      = $::RSCTBIN . "/startcondresp";
$::SYNCSERVERS_CLIENT = $::CSMCSMBIN . "/syncServers.client";
$::UPDATEDHCP         = $::CSMCSMBIN . "/updateDHCP";
$::UPDATENODE         = $::CSMBIN . "/updatenode";
$::UPDATERDMDSERVER   = $::CSMCSMBIN . "/updateRDMdserver";
$::GETSOURCEIP2TARGET = $::CSMCSMBIN . "/getSourceIP2Target";
$::MAKEDHCP           = $::CSMCSMBIN . "/makedhcp";

# Logfiles
$::LOGFILE_HANDLE   = undef;
$::CSMLOG           = "/var/log/csm";
if (NodeUtils->isHMC && ($ENV{'DC_ENVIRONMENT'} ne 1))
{
    $::CSMLOG    = "/home/hscroot/csm/csmlog";
}
$::COPYCDS_LOG      = $::CSMLOG . "/copycds.log";
$::COPYCSMPKGS_LOG  = $::CSMLOG . "/copycsmpkgs.log";
$::CSMSETUPKS_LOG   = $::CSMLOG . "/csmsetupks.log";
$::CSMSETUPHWMAINT_LOG = $::CSMLOG . "/csmsetuphwmaint.log";
$::CSMSETUPYAST_LOG = $::CSMLOG . "/csmsetupyast.log";
$::INSTALLNODE_LOG  = $::CSMLOG . "/installnode.log";
$::NODESET_LOG      = $::CSMLOG . "/nodeset.log";
$::NODESETUTILS_LOG = $::CSMLOG . "/nodeset.log";
$::MAKENODE_LOG     = $::CSMLOG . "/makenode.log";
$::UPDATENODE_LOG   = $::CSMLOG . "/updatenode.log";
$::CSMPREREBOOT_LOG = $::CSMLOG . "/csmprereboot.log";
$::CSMFIRSTBOOT_LOG = $::CSMLOG . "/csmfirstboot.log";
$::INSTALLMSLOG     = $::CSMLOG . "/installms.log";
$::CSMSETUPSIS_LOG  = $::CSMLOG . "/csmsetupsis.log";
$::CSMSETUPNIM_LOG  = $::CSMLOG . "/csmsetupnim.log";
$::CSMSETUPINSTALL_LOG = $::CSMLOG . "/csmsetupinstall.log";
$::CSM2NIMNODES_LOG = $::CSMLOG . "/csm2nimnodes.log";
$::CSM2NIMGRPS_LOG  = $::CSMLOG . "/csm2nimgrps.log";
$::COPYSISRPMS_LOG  = $::CSMLOG . "/copysisrpms.log";
$::MKSIIMAGE_LOG    = $::CSMLOG . "/mksiimage.log";
$::HAMS_LOG         = $::CSMLOG . "/hams/hams.log";
$::INSTALL_LOG      = "/var/log/csm/install.log";
$::GETADAPTERS_LOG  = $::CSMLOG . "/getadapters/getadapters.log";
$::GETUUID_LOG      = $::CSMLOG . "/getuuid.log";
$::MAKEDHCP_LOG     = $::CSMLOG . "/makedhcp.log";
$::MONITORINSTALL_LOG = $::CSMLOG . "/monitorinstall.log";

# CSM creates the isInstallServer file on the install server to indicate to
# other tools (such as RDM) that the machine has been configured as a CSM
# install server.  CSM must remove this file when CSM is uninstalled
# (rmnode -u or uninstallms).
$::IsInstallServer_file = "/var/opt/csm/isInstallServer";

# locations of OS and package definition files
$::OSDEFS   = $::OPTCSMINSTALL . "/defs";
$::PKGDEFS  = $::OPTCSMINSTALL . "/pkgdefs";

$::TFTPBOOT = "/tftpboot";

# locations of user-provided customization scripts and data files
$::SCRIPTDIR            = "$::CSMINSTDIR/csm/scripts";
$::PREINSTALLDIR        = "$::SCRIPTDIR/installprereboot";
$::POSTINSTALLDIR       = "$::SCRIPTDIR/installpostreboot";
$::PREOSUPGRADEDIR      = "$::SCRIPTDIR/osupgradeprereboot";
$::POSTOSUPGRADEDIR     = "$::SCRIPTDIR/osupgradepostreboot";
$::UPDATEDIR            = "$::SCRIPTDIR/update";
$::SCRIPTDATADIR        = "$::SCRIPTDIR/data";
$::DISKLESSPREBUILDDIR = "$::SCRIPTDIR/disklessprebuild";
$::DISKLESSBOOTDIR      = "$::SCRIPTDIR/disklessboot";
#$::VNFSDIR		        = "$::CSMINSTDIR/diskless/vnfs";

%::DirPermission = (
					$::CSMTOP        => 0755,
					$::CSMBIN        => 0755,
					$::CSMCSMBIN     => 0755,
					$::OPTCSMINSTALL => 0755,
					$::RSCTBIN       => 0755,
					$::TFTPBOOT      => 0110,
					$::CSMINSTDIR    => 0755,
					$::CSMSTATUSDIR  => 0755,
					$::CSMCFGDIR     => 0755,
					$::CSMLOG        => 0755,
					$::OSDEFS        => 0755,
					$::PKGDEFS       => 0755,
					$::CSMUSERKERNELDIR => 0755,
				   );

if (NodeUtils->isLinux() == 1)
{
	$::PLTFRM = "Linux";
}
elsif (NodeUtils->isAIX() == 1)
{
	$::PLTFRM = "AIX";
}

#Network service related
$::PXELINUX_CFG_DIR = "$::TFTPBOOT/pxelinux.cfg";
if ($::PLTFRM eq "AIX")
{
    $::DHCPDCONF = "/etc/dhcpsd.cnf";
}
else
{
    $::DHCPDCONF = "/etc/dhcpd.conf";
}

# These variables are required to determine which .pm files to load
# They are used by get_DistributionVersion, get_PkgArchitecture & get_CSMVersion
if ($::PLTFRM eq "AIX")
{
	$::UNAME  = "/bin/uname";
	$::RPMCMD = "/bin/rpm";
	$::LSLPP  = "/bin/lslpp";
}
elsif ($::PLTFRM eq "Linux")
{
	$::UNAME  = "/bin/uname";
	$::RPMCMD = "/bin/rpm";
}

$::DISTRIBUTION = NodeUtils->distribution();

@::VALID_AIX_DISTROS =
  ('AIX5.1', 'AIX5.1.0', 'AIX5.2', 'AIX5.2.0', 'AIX5.3', 'AIX5.3.0',);
@::VALID_CSM_DISTROS = (
	'1.1.0', '1.1.1', '1.1.2', '1.1.3', '1.2.0', '1.3.0',
	'1.3.1', '1.3.2', '1.3.3', '1.4.0', '1.4.1', '1.5.0',
	'1.5.1', '1.6.0'
);

@::VALID_INSTALLMETHODS = ('kickstart', 'autoyast', 'warewulf', 'kickstart-upgrade', 'you'); 

@::VALID_X86_ARCHS = ('noarch', 'i286', 'i386', 'i486', 'i586', 'i686',);

@::VALID_X86_64_ARCHS = ('noarch', 'x86_64', 'i386', 'i486', 'i586', 'i686',);

@::VALID_IA64_ARCHS = ('noarch', 'ia64');

@::VALID_PPC_ARCHS = ('noarch', 'ppc', 'ppc64',);

$::DISTRO            = "";
$::IS_DEFAULT_DIR    = "/csmserver";
@::valid_powermethod = ();
@::valid_console     = ();
@::valid_TFTP        = ('tftp-hpa',"");
$::DEFLOOP           = 10;

$::HWMAINT_STATUSLOCK = "/tmp/hwmaint_statuslock";
$::UPDATENODE_LOCK    = "/tmp/updatenode.sem";
$::SMSUPDATENODE_LOCK = "/tmp/smsupdatenode.sem";

# Java related 
if ($::PLTFRM eq "AIX")
{
	$::JAVA_LOCATION = "/usr/java\*";
	$::JAVA_NAME = "Java14.sdk";
}
elsif ($::PLTFRM eq "Linux")
{
	$::JAVA_LOCATION = "/opt/IBMJava\*";
	$::JAVA_NAME = "IBMJava2-JRE";
}
$::JAVA_VERSION = "1.4.2";

1;
