#!/usr/bin/perl
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2007 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
# @(#)29   1.13   src/csm/core/pm/MessageUtils.pm.perl, setup, csm_rfish, rfishs001b 1/23/06 04:38:58
#
#####################################################################

package MessageUtils;

use strict;

#     locale tells perl to honor locale for sorting, dates, etc.
#     more info about locale.pm and perl handling of locales can be found
#     in /usr/lib/perl5/5.6.0/locale.pm and the man page for perllocale.

use locale;
use Socket;
use File::Path;

my $msgs;
my $distro;
my $useTranslatedMsg;
my %catHashes;
my $csmroot;
my ($MSGCAT, $MSGMAPPATH, $MSGSET);
my $NO_NODERANGES;
my $NODEGROUPEXPMEM_WARNING = 1;

# $NodeUtils::NO_MESSAGES;    # Set this to 1 if you do not want NodeUtils to
                              # print any error msgs

# $NodeUtils::errno;          # Will be set if an error occurs.  You must zero
                              # this out before calling a NodeUtils function,
                              # if you want to check it afterwards.

BEGIN
{

    #    This enables us to redirect where it looks for other CSM files during development
    $csmroot = $ENV{'CSM_ROOT'} ? $ENV{'CSM_ROOT'} : '/opt/csm';

    $MSGCAT = 'nodecmds.cat';
    if (defined $::MSGMAPPATH)
    {
        $MSGMAPPATH = $ENV{'CSM_ROOT'} ? "$csmroot/msgmaps" : $::MSGMAPPATH;
    }
    else
    {
        $MSGMAPPATH = "$csmroot/msgmaps";
    }
    $MSGSET = 'NodeUtils';
}

umask(0022); #  This sets umask for all CSM files so that group and world only
             #  have read permissions.
             #  To change it, simply use the umask call in your script, after
             #  the "use NodeUtils;" line



#--------------------------------------------------------------------------------


=head1    MessageUtils


=head2    Package Description


This program module file, supports the CSM/install messaging and status
dependencies.  

If adding to this file, please take a moment to ensure that:

    1.  Your contrib has a readable pod header describing the purpose and use of
         your contrib.

    2. Your contrib is under the correct heading and is in alphabetical order
    under that heading.

    3. You test your contribution by running from the command line:  

       pod2html  --verbose --title=MessageUtils MessageUtils.pm.perl --outfile=MessageUtils.html
       
       and examining the ./MessageUtils.html file in a browser.


=cut

#--------------------------------------------------------------------------------

=head2    Package Dependancies

    use strict;
    use Fcntl qw(:flock);
    use File::Basename;
    use File::Find;
    use File::Path;    # Provides mkpath()


=cut


=cut


#--------------------------------------------------------------------------------

=head1    Subroutines by Functional Group

=cut

#--------------------------------------------------------------------------------

=head2    Messaging 

=cut

#--------------------------------------------------------------------------------

=head3    getMessage

     Returns a msg from a catalog.

    Arguments:
        Input arguments are: msg id and then the values to be
        plugged into the msg.
    Returns:
        A msg from a catalog.
    Globals:
        $::MSGCAT
        $::MSGMANPATH
        $::MSGSET
    Error:
        Internal error message.
    Example:
         MessageUtils->getMessageFromCat (    $::MSGCAT,
                        $::MSGMAPPATH,
                        $::MSGSET,
                        @_);
    Comments:
         This function also uses the same global vars as message().

=cut

#--------------------------------------------------------------------------------

sub getMessage
{
    shift;    # get rid of the class name
    if (!defined($::MSGCAT) || !defined($::MSGMAPPATH))
    {
        return NodeUtils->programName()
          . ":  Internal globabl variable MSGCAT or MSGMAPPATH not defined on call to NodeUtils::getMessage().\n";
    }
    return MessageUtils->getMessageFromCat($::MSGCAT, $::MSGMAPPATH, $::MSGSET,
                                           @_);
}

#--------------------------------------------------------------------------------

=head3    getMessageFromCat

    Returns a message without relying on the global variables for msg catalog,
    msg map path, and msg set parameters.

    Arguments:
         The arguments are:    msg catalog,
                    msg map path,
                    msg set,
                    and then the same args as getMessage().

    Returns:
        Multiple posible message strings.
    Globals:
        $::MSGCAT
        $::MSGMAPPATH
        $::MSGSET
    Error:
        Multiple posible message strings.
    Example:
        MessageUtils->getMessageFromCat( $::MSGCAT,
                                         $::MSGMAPPATH,
                                         $::MSGSET,
                                         @_);
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub getMessageFromCat
{

    # Process the arguments
    shift;    # get rid of the class name
    my $msgcat     = shift;
    my $msgmappath = shift;
    my $msgset     = shift;
    my $msgid      = shift;

    # the rest are the values to be plugged into the msg.  They are in @_
    if (!length($msgset)) { $msgset = NodeUtils->programName(); }

    my ($msgnum, $msgsetnum, $defaultmsg) =
      MessageUtils->getmsgmap($msgmappath, $msgset, $msgcat, $msgid);

    # Check the NLS related env vars to determine if we really have to get the msg from a
    # translated catalog, or if we can just use the default msg from the msg map, because
    # the latter is much faster (does not have to fork a process for each msg).
    if (!MessageUtils->useTranslatedMsg()
      )    # just display default msg from msg map
    {

        #print "(using default msg...)\n";
        $defaultmsg =~ s/^\'(.*)\'$/$1/s; # remove the surrounding single quotes
        if (NodeUtils->isLinux())
        {
            $defaultmsg =~ s/^(\s*%\d\$s:\s*|\s*)\d{4}-\d{3}\s*/$1/;
        }                                 # on linux remove the error number
        $defaultmsg = MessageUtils->substituteValues($defaultmsg, @_);
        $defaultmsg = MessageUtils->processNewlines($defaultmsg);
        return $defaultmsg;
    }
    else    # use translated msg from catalog via dspmsg
    {

        #print "(using translated msg via dspmsg...)\n";
        # We have to quote the values if they have embedded blanks and other funny
        # chars.
        my @values = @_;    # have to make a copy because @_ is readonly
        foreach my $v (@values)
        {
            $v = NodeUtils->quote(MessageUtils->processNewlines($v));
        }

        # Build the command string and invoke dspmsg
        my $cmd =
          "/usr/bin/dspmsg -s $msgsetnum $msgcat $msgnum $defaultmsg "
          . join(' ', @values) . ' 2>&1';

        #print "$cmd\n";
        my $msg = `$cmd`;
        my $rc  = $? >> 8;
        if ($rc)
        {
            return NodeUtils->programName()
              . ":  Error running dspmsg to display a message.  Exit code from dspmsg is $rc.  Command: $cmd\nMessage from command: $msg\n";
        }
        return $msg;
    }
}

#--------------------------------------------------------------------------------

=head3	getmsg

        Get and return a msg from a msg hash ref.  Used in a similar way to the msg()
        function, except w/o the severity code.

    Arguments:
        $msg catalog,
        $msg ID
    Returns:
        a message string
    Globals:
        none
    Error:
        warining
    Example:
         $msg = MessageUtils->getmsg($msgcat, $msgid, @_);
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub getmsg
{
    my $class  = shift;
    my $msgcat = shift;
    my $msgid  = shift;

    # Find the msg and substitute the values left in @_ into the msg
    my $m = $$msgcat{$msgid};
    if (!defined($m))
    {
        $m =
          NodeUtils->programName()
          . ": Can not find message $msgid in the message hash variable.\n";
    }
    if (NodeUtils->isLinux())
    {
        $m =~ s/^(\s*%\d\$s:\s*)\d{4}-\d{3}\s*/$1/;
    }    # on linux remove the error number
    $m = MessageUtils->substituteValues($m, @_);
    $m = MessageUtils->processNewlines($m);

    return $m;
}

#--------------------------------------------------------------------------------

=head3    getmsgmap

     The perl equivalent of the ctdspmsg command.  It finds a msg mnemonic and
    the corresponding msg set, msg number, and default msg in a msg map file.

    Arguments:
         $msgpath, $msgset, $msgcat, $msgid
    Returns:
        a tuple: msg set, msg number and default msg
        as an array.
    Globals:
        _
    Error:
        (-1, -1, $message or progam name);
    Example:
        my ($msgnum, $msgsetnum, $defaultmsg) =
            MessageUtils->getmsgmap($msgmappath, $msgset, $msgcat, $msgid);
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub getmsgmap
{
    my ($class, $msgpath, $msgset, $msgcat, $msgid) = @_;
    my ($catbase) = $msgcat =~ /(.+)\.cat$/;
    my $mapname = "$msgpath/$catbase.$msgset.map";

    # If we have not read the msg map yet, do that
    my $catHash =
      $catHashes{$mapname};    # this gets a reference to the msg set hash
    if (!defined($catHash))
    {

        #print "Opening $mapname...\n";
        if (!open(CATFILE, $mapname))
        {
            my $m =
              NodeUtils->programName()
              . ": Can not open message map file $mapname to retrieve message $msgid.\n";
            return (-1, -1, $m);
        }
        $catHash = {};         # create the hash and save the reference to it
        $catHashes{$mapname} = $catHash;
        while (<CATFILE>)      # this puts the next line into $_
        {
            my ($mnemonic, $msgnum, $msgset, $defaultmsg) = split(' ', $_, 4);
            chomp($defaultmsg);
            $$catHash{$mnemonic} = [$msgnum, $msgset, $defaultmsg];
        }
    }

    # Find the msg in the hash and display it
    my $msgref = $$catHash{$msgid};
    if (!defined($msgref))
    {
        my $m =
          NodeUtils->programName()
          . ": Can not find message $msgid in message map file $mapname.\n";
        return (-1, -1, $m);
    }

    return @$msgref;    # msgnum, msgset, defaultmsg
}

#--------------------------------------------------------------------------------

=head3    msg

    Display a msg from a hash reference.  The 1st arg is the hash reference and
    the rest of the args are the same as message().  The msgs in the hash should
    be similar in format to msgs in a catalog.

    This means the following:
    
        - it should use %1$s for substitution instead of %s
        - it should include a newline on the end, if desired
        - if the msg is a warning or error, it should have %1$s: at the beginning
          to have the program name plugged in
        - it can have a msg number, but doesn't have to

    Arguments:
        see intro above
    Returns:
        nothing
    Globals:
        none
    Error:
        none
    Example:
        
        MessageUtils->msg($::MSGS,'E2','OPERATION_FAILED',$var);
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub msg
{
    my $class  = shift;
    my $msgcat = shift;

    MessageUtils->messageFromCat($msgcat, '', '', @_);
}

#--------------------------------------------------------------------------------

=head3    message

    Display a msg from a msg catalog to stdout, stderr, or a log file.  This
    function is primarily meant for commands and other code that is sending
    output directly to the user.  Even the log is really a capture of this
    interactive output.  The CLOG API should be used by daemons to log important
    events.

    Arguments:
        The arguments of the message() function are:

        - severity_code -
            A string containing 1 or 2 characters indicating the severity
            or type of message, then some optional digits containing an exit
            code.

            Here's the meaning of the 1st character:
                I - informational
                W - warning.  This type of message will be sent to stderr.
                    The program name will be plugged into the 1st argument in the msg.
                E - error.  This type of message will be sent to stderr.
                    The program name will be plugged into the 1st argument in the msg.
                P - prompt string.  If you don't want the newline at the end of the
                    prompt, don't put it in the message in the catalog.
                O - program output.
                V - verbose.  This message should only be displayed if $::VERBOSE is set.

            If $::LOG_FILE_HANDLE is set, the message goes to both the screen and that
            log file.  (Verbose msgs will be sent to the log file even if $::VERBOSE
            is not set.)  Optionally, an L can be put before any of the above characters
            meaning send this message only to the log file handle in $::LOG_FILE_HANDLE.
            Also, a lowercase L can be put before any of the above characters to mean
            do NOT send this to the log file, even if $::LOG_FILE_HANDLE is set.

        - msg_id The message to display out of the catalog.  The messages in the catalog
            should have the newline at the end (if appropriate) and the error
            message number in it (if an error).

         - The rest of the arguments are values to substitute for %s in the msg.

    Returns:
        none

    Globals:
         MSGCAT        - the name of the message catalog containing the messages
        MSGMAPPATH    - the path of the message map containing the messages
        MSGSET        - the name of the msg set withing the catalog.  If not set, it
                    will default to the program name.
    Error:
        _none

    Example:
        $::MSGCAT    = 'csmserver.cat';
        $::MSGMAPPATH    = '/opt/csm/msgmaps';
        blah;
        MessageUtils->message('E2', 'EMsgOPERATION_FAILED', $value1, $value2);


    Comments:
         For debugging purposes, if you set the undocumented environment variable
        CSM_MESSAGE_DEBUG, it will prefix each msg with the msg mnemonic.

=cut

#--------------------------------------------------------------------------------

sub message
{
    shift;    # get rid of the class name
    if (!defined($::MSGCAT) || !defined($::MSGMAPPATH))
    {

        # Make this msg go through the normal msg processing so we send it to the log file,
        # if appropriate, and we exit with the right rc, if appropriate.
        my $m =
          NodeUtils->programName()
          . ":  Internal globabl variable MSGCAT or MSGMAPPATH not defined on call to NodeUtils::message().\n";
        my $hashref = {M => $m};
        MessageUtils->messageFromCat($hashref, '', '', $_[0], 'M');
        return;
    }
    MessageUtils->messageFromCat($::MSGCAT, $::MSGMAPPATH, $::MSGSET, @_);
}

#--------------------------------------------------------------------------------

=head3    messageFromCat

        Prints a msg w/o relying on the global vars for the msg catalog,
         msg map path, and msg set.

    Arguments:
        $msg catalog,
        $msg map path,
        $msg set, 
        then the same args as message().
        
    Returns:
        none
    Globals:
        none
    Error:
        none
    Example:
                MessageUtils->messageFromCat('csmInstall.cat',
                                          $::MSGMAPPATH,
                                          'csminstall',
                                          'E',
                                          'EMsgCANT_RUN',
                                          $cmd,
                                          $rc);
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub messageFromCat
{

    # Process the arguments
    shift;    # get rid of the class name
    my $msgcat     = shift;
    my $msgmappath = shift;
    my $msgset     = shift;
    my $sevcode    = shift;
    if (   $sevcode =~ /V/
        && !$::VERBOSE
        && (!defined($::LOG_FILE_HANDLE) || $sevcode =~ /l/))
    {
        return;
    }
    my $msgid = shift;

    # the rest are the values to be plugged into the msg.  They are in @_

    # Parse the severity code
    my $i       = 1;
    my $logonly = 0;
    my $nolog   = 0;
    my $sev     = substr($sevcode, 0, 1);  # should be I, W, E, P, O, V, L, or l
    if ($sev eq 'L' || $sev eq 'l')
    {
        if ($sev eq 'L') { $logonly = 1; }
        else { $nolog = 1; }
        $i = 2;                          # logically shift everything by 1 char
        $sev = substr($sevcode, 1, 1);
    }
    if (!($sev =~ /[WEPVO]/)) { $sev = 'I'; }
    my $code = substr($sevcode, $i);     # optional exit code

    if ($sev =~ /[WE]/)
    {
        unshift @_, NodeUtils->programName();
    }    # only warnings and errors should have the program name prepended

    my $stdouterrf = \*STDOUT;
    my $stdouterrd = '';
    if ($sev =~ /[WE]/)
    {
        $stdouterrf = \*STDERR;
        $stdouterrd = '1>&2';
    }

    my $msg;

    # If they pass in a hash reference instead of a msg catalog name, we will
    # get the msg from the hash ref.
    if (ref($msgcat) eq 'HASH')
    {
        $msg = MessageUtils->getmsg($msgcat, $msgid, @_);
    }
    else
    {
        $msg =
          MessageUtils->getMessageFromCat($msgcat, $msgmappath, $msgset, $msgid,
                                          @_);
    }

    # If there is a problem with getMessageFromCat() it returns the error as the msg

    # This is used for debugging
    if ($ENV{'CSM_MESSAGE_DEBUG'}) { $msg = "$msgid: $msg"; }

    if (!$logonly && !($sev eq 'V' && !$::VERBOSE)) { print $stdouterrf $msg; }
    if (defined($::LOG_FILE_HANDLE) && !$nolog)
    {
        print $::LOG_FILE_HANDLE $msg;
    }

    if (length($code))
    {
        if (defined($::LOG_FILE_HANDLE))
        {
            close $::LOG_FILE_HANDLE;
            undef $::LOG_FILE_HANDLE;
        }
        exit $code;
    }
}

#--------------------------------------------------------------------------------

=head3    processNewlines

    Process the new lines in a message.

    Arguments:
        message string
    Returns:
        message string with processed \n's
    Globals:
        none
    Error:
        undefined
    Example:
         $defaultmsg = MessageUtils->processNewlines($defaultmsg);
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub processNewlines
{
    my ($class, $msg) = @_;

    # For some reason, the presence of $ and @ makes this eval erase the msg, so we
    # must escape them.
    #if ($msg =~ /%\d\$s/) { return $msg; }    # return it unprocessed
    $msg =~ s/([\$\@])/\\$1/sg;

    # Previously newlines were converted using eval as follows:
    #    $msg = 'qq(' . $msg . ')';    # surround with qq() so we can eval it
    #    $msg = eval $msg;             # this processes the \n correctly
    #
    # For some reason, other encodings do not work with this.  Instead
    # we substitute newlines and tabs as follows (Note that other special
    # characters will require their own substitution):
    $msg =~ s/\\n/\n/sg;
    $msg =~ s/\\t/\t/sg;
    $msg =~ s/\\'/'/sg;
    $msg =~ s/\\"/"/sg;
    $msg =~ s/\\\(/\(/sg;
    $msg =~ s/\\\)/\)/sg;
    $msg =~ s/\\\^/\^/sg;

    return $msg;
}

#--------------------------------------------------------------------------------

=head3    substituteValues

    Substitue values in a msg string.

    Arguments:
        msg string
        substitute values
    Returns:
        altered msg string
    Globals:
        none
    Error:
        undefined
    Example:
        $defaultmsg =
            MessageUtils->substituteValues($defaultmsg, @_);
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub substituteValues
{
    shift @_;    # get rid of the class argument
    my $msg = shift @_; # the rest of the arguments are values to be substituted

    # Have to substitute the values in the correct order
    my $i = 1;
    foreach my $v (@_)
    {
        $msg =~ s/%$i\$s/$v/;
        $i++;
    }
    return $msg;
}

#--------------------------------------------------------------------------------

=head3    useTranslatedMsg

    Check the NLS related env vars to determine if we really have to
    get the msg from a translated catalog, or if we can just use the
    default msg from the msg map.

    Arguments:
        none
    Returns:
        0 - use translated msg.
        1 - don't use translated msg.d 
    Globals:
        none
    Error:
        none
    Example:
        if (!MessageUtils->useTranslatedMsg()) { blah; }
    Comments:
        not clear which is true: 1 or 0.

=cut

#--------------------------------------------------------------------------------

sub useTranslatedMsg
{
    my $pattern = "(?i)en_us";     # do case-insensitive pattern match
    if (!defined($useTranslatedMsg))    # cache the result
    {
        if    (!(-x '/usr/bin/dspmsg')) { $useTranslatedMsg = 0; }
        elsif ($ENV{CSM_USE_DSPMSG})    { $useTranslatedMsg = 1; }
        elsif (defined($ENV{LC_ALL}) && length($ENV{LC_ALL}))
        {
            if ($ENV{LC_ALL} =~ /^(C|POSIX|$pattern)/) { $useTranslatedMsg = 0; }
            else { $useTranslatedMsg = 1; }
        }
        elsif (defined($ENV{LC_MESSAGES}) && length($ENV{LC_MESSAGES}))
        {
            if ($ENV{LC_MESSAGES} =~ /^(C|POSIX|$pattern)/)
            {
                $useTranslatedMsg = 0;
            }
            else { $useTranslatedMsg = 1; }
        }
        elsif (defined($ENV{LANG}) && length($ENV{LANG}))
        {
            if ($ENV{LANG} =~ /^(C|POSIX|$pattern)/) { $useTranslatedMsg = 0; }

            else { $useTranslatedMsg = 1; }
        }
        elsif (defined($ENV{LC_CTYPE}) && length($ENV{LC_CTYPE}))
        {
            if ($ENV{LC_CTYPE} =~ /^(C|POSIX|$pattern)/) { $useTranslatedMsg = 0; }
            else { $useTranslatedMsg = 1; }
        }
        elsif (defined($ENV{RC_LANG}) && length($ENV{RC_LANG}))
        {
            if ($ENV{RC_LANG} =~ /^(C|POSIX|$pattern)/) { $useTranslatedMsg = 0; }
            else { $useTranslatedMsg = 1; }
        }
    }

    # The only part of this decision we shouldn't cache is whether dspmsg is available,
    # because that can change as we are installing RSCT.
    if (!(-x '/usr/bin/dspmsg')) { return 0; }
    else { return $useTranslatedMsg; }
}

#--------------------------------------------------------------------------------

=head2    Server Logging Routines

=cut

#--------------------------------------------------------------------------------

=head3 append_logging

        Append logging messages to a logfile. Return the log file handle so
        it can be used to close the file when done logging.

        Arguments:
                 $logFileName
                 $quiet_flag
        Returns:
                $::LOG_FILE_HANDLE
        Globals:
                $::LOG_FILE_HANDLE
        Error:
                $::NOK
        Example:
                ServerUtils->append_logging($::INSTALL_LOG);
        Comments:
                It is the responsibility of the caller to close the
                log file;  this is best done with stop_logging().

=cut

#--------------------------------------------------------------------------------

sub append_logging
{
    my ($class, $logfile, $quiet_flag) = @_;
    my ($cmd, $rc);
    if (!$quiet_flag)
    {
        $quiet_flag = 0;
    }

    # create the log directory if it's not already there
    if (!-d $::CSMLOG)
    {
        $cmd = "$::MKDIR -m 644 -p $::CSMLOG";
        $rc  = system("$cmd");
        if ($rc >> 8)
        {
            MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                              'csminstall', "E", 'EMsgNO_CreateDir', $::CSMLOG);
            return ($::NOK);
        }
    }

    #
    #  get log file ready
    #
    if (!-e $logfile)
    {    #  create the log file if not already there
            # open the log file
        unless (open(LOGFILE, ">$logfile"))
        {

            # Cannot open file
            MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                            'csminstall', "E", 'EMsgCANT_WRITE_FILE', $logfile);
            return $::NOK;
        }
    }
    else
    {       # it's there so just append
        unless (open(LOGFILE, ">>$logfile"))
        {
            MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                            'csminstall', "E", 'EMsgCANT_WRITE_FILE', $logfile);
            return $::NOK;
        }
    }

    $::LOG_FILE_HANDLE = \*LOGFILE;

    # Print the date to the top of the logfile
    my $sdate = `/bin/date`;
    chomp $sdate;
    my $program = NodeUtils->programName();
    if ($quiet_flag != 1)
    {
        MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                     'csminstall', "LI", 'IMsgSTART_LOGGING',
                                     $program, $sdate);
        MessageUtils->messageFromCat(
                                     'csmInstall.cat',  $::MSGMAPPATH,
                                     'csminstall',      "LI",
                                     'IMsgShow_Output', $::command_line
                                     );
    }

    return ($::LOG_FILE_HANDLE);
}

#--------------------------------------------------------------------------------

=head3    backup_logfile

        Backup the current logfile. Move logfile to logfile.1. Shift all other logfiles
        (logfile.[1-3]) up one number. The original logfile.4 is removed as in a FIFO.   

        Arguments:
                $logFileName
        Returns:
                $::OK
        Error:
                undefined
        Example:
                MessageUtils->backup_logfile($logfile);
        Comments:
                Never used outside of ServerUtils.

=cut

#--------------------------------------------------------------------------------

sub backup_logfile
{
    my ($class, $logfile) = @_;

    my ($logfile1) = $logfile . ".1";
    my ($logfile2) = $logfile . ".2";
    my ($logfile3) = $logfile . ".3";
    my ($logfile4) = $logfile . ".4";

    if (-f $logfile)
    {
        rename($logfile3, $logfile4) if (-f $logfile3);
        rename($logfile2, $logfile3) if (-f $logfile2);
        rename($logfile1, $logfile2) if (-f $logfile1);
        rename($logfile,  $logfile1);
    }
    return $::OK;
}


#--------------------------------------------------------------------------------

=head3 start_logging

        Start logging messages to a logfile. Return the log file handle so it
        can be used to close the file when done logging.

        Arguments:
                $logFile
                $quiet_flag
        Returns:
                $::LOG_FILE_HANDLE
        Globals:
                $::LOG_FILE_HANDLE
                $::CSMLOG
        Error:
                $::NOK
        Example:
                ServerUtils->start_logging($::CSMSETUPKS_LOG);
        Comments:
                Common method for logging script runtime output.

=cut

#--------------------------------------------------------------------------------

sub start_logging
{
    my ($class, $logfile, $quiet_flag) = @_;
    my ($cmd, $rc);
    if (!$quiet_flag)
    {
        $quiet_flag = 0;
    }
    MessageUtils->backup_logfile($logfile);

    # create the log directory if it's not already there
    if (!-d $::CSMLOG)
    {
        $cmd = "$::MKDIR -m 644 -p $::CSMLOG";
        $rc  = system("$cmd");
        if ($rc >> 8)
        {
            MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                              'csminstall', "E", 'EMsgNO_CreateDir', $::CSMLOG);
            return ($::NOK);
        }
    }

    # open the log file
    unless (open(LOGFILE, ">>$logfile"))
    {

        # Cannot open file
        MessageUtils->messageFromCat(
                                     'csmInstall.cat',      $::MSGMAPPATH,
                                     'csminstall',          "E",
                                     'EMsgCANT_WRITE_FILE', $logfile
                                     );
        return $::NOK;
    }

    $::LOG_FILE_HANDLE = \*LOGFILE;

    # Print the date to the top of the logfile
    my $sdate = `/bin/date`;
    chomp $sdate;
    my $program = NodeUtils->programName();
    if ($quiet_flag != 1)
    {
        MessageUtils->messageFromCat(
                                     'csmInstall.cat',      $::MSGMAPPATH,
                                     'csminstall',          'V',
                                     'IMsgWRITING_LOGFILE', $program,
                                     $logfile
                                     );
        MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                     'csminstall', "LI", 'IMsgSTART_LOGGING',
                                     $program, $sdate);
        MessageUtils->messageFromCat(
                                     'csmInstall.cat',  $::MSGMAPPATH,
                                     'csminstall',      "LI",
                                     'IMsgShow_Output', $::command_line
                                     );
    }

    return ($::LOG_FILE_HANDLE);
}

#--------------------------------------------------------------------------------

=head3 stop_logging

        Turn off message logging. Routine expects to have a file handle
        passed in via the global $::LOG_FILE_HANDLE.

        Arguments:
                 $quiet_flag
        Returns:
                $::OK
        Globals:
                $::LOG_FILE_HANDLE
        Error:
                none
        Example:
                ServerUtils->append_logging($::INSTALL_LOG);
        Comments:
                closes the logfile and undefines $::LOG_FILE_HANDLE
                even on error.

=cut

#--------------------------------------------------------------------------------

sub stop_logging
{
    my ($class, $quiet_flag) = @_;
    if (!$quiet_flag)
    {
        $quiet_flag = 0;
    }
    if (defined($::LOG_FILE_HANDLE))
    {

        # Print the date at the bottom of the logfile
        if ($quiet_flag != 1)
        {
            my $date = `/bin/date`;
            chomp $date;
			my $program = NodeUtils->programName();
            MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                 'csminstall', "LI", 'IMsgSTOP_LOGGING', $program, $date);
        }

        close($::LOG_FILE_HANDLE);
        undef $::LOG_FILE_HANDLE;
    }
    return $::OK;
}

#--------------------------------------------------------------------------------

=head2    Node Installation Status Routines

=cut

#--------------------------------------------------------------------------------

=head3    initialize_status

        The status directory is used to collect the installation
        status of nodes that are getting full installs.  Each node
        contains a separate file in the status directory with the
        name of the node's hostname.

        Create the /csminstall/csm/status directory and make it
        world writable so that the node can write to it with the
        atftp command.  Also, create initial files for each node
        to be installed.

        Arguments:
                reference to an array of Node Names
        Returns:
                number of errors encounter across node list
        Globals:
                $::CSMSTATUSDIR
                $::CSMSTATUSLINK
        Error:
                number of errors encournterd
        Example:
                 $rc =
                   ServerUtils->initialize_status(\@NODELIST);
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub initialize_status
{
    my ($class, $nodes) = @_;
    my ($mode, $rc);
    my ($errors) = 0;
    unlink($::CSMSTATUSDIR);
    mkpath($::CSMSTATUSDIR, $::VERBOSE, 0755);
    $mode = 0755;
    #NodeUtils->runcmd("$::CHMOD $mode $::CSMSTATUSDIR");
    chmod $mode, $::CSMSTATUSDIR;

    #symlink ($::CSMSTATUSDIR, $::CSMSTATUSLINK);

    foreach my $node (@$nodes)
    {
        my $statusfile = "$::CSMSTATUSDIR/$node";
        unlink($statusfile);
        NodeUtils->touchFile($statusfile);
		chmod $mode, $statusfile;
    }

    return ($errors);
}

#--------------------------------------------------------------------------------

=head3    write_status

        Write an entry in the node install status file
        at /csminstall/csm/status/<node>

        Arguments:
                node    - The hostname of the node
                msg     - The message to add to the status file
                status  - (optional) The status of the operation
                dateReference - an empty array reference to get the
                                time the message was written.
        Returns:
                none
        Globals:
                none
        Error:
                csmInstall.cat  E2
        Example:
                ServerUtils->write_status($node, $msg, $rc);
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub write_status
{
    my ($class, $node, $msg, $status, $dateReference) = @_;
    my $statusfile = "$::CSMSTATUSDIR/$node";
    open(STATUSFILE, ">>$statusfile")
      || MessageUtils->messageFromCat(
                                      'csmInstall.cat',      $::MSGMAPPATH,
                                      'csminstall',          'E2',
                                      'EMsgCANT_WRITE_FILE', $statusfile
                                      );

    my $date = `date`;
    chomp $date;
    push(@$dateReference, $date);

    chomp $msg;

    if ($status) { print STATUSFILE "$date: $msg: status=$status\n"; }
    else { print STATUSFILE "$date: $msg\n"; }

    close(STATUSFILE);
}

#--------------------------------------------------------------------------------

1;

