#!/usr/bin/perl
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2007 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 

#---------------------------------------------------------------------------
# Module:NodesetUtils
#
# Description:
#   This module consists of subroutines that would be helpful in setting
# up net boots for various purposes like gettting mac address or for kickstar
# installation of nodes etc. Most of the net boots involve setting up similar
# steps like creating dhcp, setting up pxe files, creating ram disk etc.By
# consolidating the subroutines here, future additions can make use of already
# existing infrastructure.
#
#----------------------------------------------------------------------------
# @(#)95   1.70.8.8   src/csm/core/pm/NodesetUtils.pm.perl, setup, csm_rfish, rfishs001b 4/28/07 04:38:43

package NodesetUtils;

use strict;
BEGIN
{
    $::csmpm = $ENV{'CSM_PM'} ? $ENV{'CSM_PM'} : '/opt/csm/pm';
    $::moduleDir = "/csminstall/csm/drivers/pm";
    if ($ENV{CSMINSTALL_ROOT})
    {
        $::moduleDir = "$ENV{CSMINSTALL_ROOT}/csm/drivers/pm";
    }
}
use lib $::csmpm;
use FindBin qw($Bin);
use lib "$Bin";
use Getopt::Std;
use File::Path;    # Provides mkpath() and rmtree();
use File::Copy;    # Provides copy();
use File::Basename;
use Cwd;
use NodeUtils;
use CSMDefs;
require NetworkUtils;
require MessageUtils;
require ServerUtils;
require ApacheUtils;

# Script to set up Kickstart, dhcp, pxe

#---------------------
# Global Variables
#---------------------
# %::BOOT_ATTRIBUTES;
$::BOOT_EXIT       = 0;
$::HS20_8843       = "8843";
$::CSMINSTALL_ROOT =
  defined $ENV{CSMINSTALL_ROOT} ? $ENV{CSMINSTALL_ROOT} : '/csminstall';

# get the definitions we need for this command
#    in this case get_OSDefs uses the attrs of the management
#    server to identify the correct definitions
%::msOSDefs = ServerUtils->get_OSDefs();

# Directories
$::INSTALLDIR    = $::CSMINSTDIR;
$::PXELINUXCFG   = $::TFTPBOOT . "/pxelinux.cfg";
$::OLDGETMACSPXE = $::PXELINUXCFG . "/getmacs.pxe";
$::GETMACZ       = $::TFTPBOOT . "/csm/getmac.gz";

# Files
$::TEMPLATES_DIR                 = $::CSMINSTALL_ROOT . "/csm/templates/";
$::PXE_INSTALL_TMPL              = $::TEMPLATES_DIR . "/install.pxe";
$::PXE_YASTINSTALL_TMPL          = $::TEMPLATES_DIR . "/yastinstall.pxe";
$::PXE_INSTALL_UUID_TMPL         = $::TEMPLATES_DIR . "/install_UUID.pxe";
$::PXE_INSTALL_HTTP_TMPL         = $::TEMPLATES_DIR . "/install_HTTP.pxe";
$::PXE_YASTINSTALL_UUID_TMPL     = $::TEMPLATES_DIR . "/yastinstall_UUID.pxe";
$::PXE_YASTINSTALL_HTTP_TMPL     = $::TEMPLATES_DIR . "/yastinstall_HTTP.pxe";
$::PXE_GETMACS_TMPL              = $::TEMPLATES_DIR . "/getmacs.pxe";
$::PXE_DEFAULT_TMPL              = $::TEMPLATES_DIR . "/default.pxe";
$::FIRSTBOOT_TMPL                = $::TEMPLATES_DIR . "/firstboot.tmpl";
$::PXE_YAST_PREINSTALL_TMPL      = $::TEMPLATES_DIR . "yasthwmaint.pxe";
$::PXE_KS_PREINSTALL_TMPL        = $::TEMPLATES_DIR . "kshwmaint.pxe";
$::PXE_YAST_PREINSTALL_UUID_TMPL = $::TEMPLATES_DIR . "yasthwmaint_UUID.pxe";
$::PXE_KS_PREINSTALL_UUID_TMPL   = $::TEMPLATES_DIR . "kshwmaint_UUID.pxe";
$::PXE_WAREWULF_TMPL   = $::TEMPLATES_DIR . "warewulf.pxe";

#Warewulf master template files
$::WAREWULF_TMPL_DIR = $::TEMPLATES_DIR . "warewulf/";
$::WAREWULF_MASTER_CONF_TMPL =  "master.conf";
$::WAREWULF_CLIENT_CONF_TMPL =  "client.conf";
$::WAREWULF_INITRD_CONF_TMPL =  "wwinitrd.config";
$::WAREWULF_DEPLOY_DIR = "/etc/warewulf/";


#Warewulf node template files
$::WAREWULF_NODEGRP_CONF_TMPL =  "config";
$::WAREWULF_NODE_CONF_TMPL = "disklessnodecfg";
$::WAREWULF_VNFS_INCLUDES_TMPL = "includes";
$::WAREWULF_VNFS_EXCLUDES_TMPL = "excludes";
$::WAREWULF_VNFS_EXCLUDES_AGGRESSIVE_TMPL = "excludes-aggressive"; 

##Warewulf zimage file
$::WAREWULF_ZIMAGE_FILLE = "/tftpboot/ww-zimage";
#VJB template scripts directory:
$::TEMPLATESCRIPTS = $::TEMPLATES_DIR . "/scripts";

#VJBEND

# Defaults
$::DEFAULT_PKGPATH      = "/mnt/cdrom";
$::DEFAULT_KSCFG_TMPL   = "/opt/csm/install/kscfg.tmpl";
$::DEFAULT_YASTCFG_TMPL = "/opt/csm/install/yastcfg";
$::DEFAULT_WW_TMPL = "/opt/csm/install/warewulf/warewulf-tmpl";

my @VALID_ATTRIBUTES = ("Netmask", "Gateway", "Nameserver", "Nameservers");

my @VALID_BOOT_METHODS = ("getmacs", "kickstart", "kickstart-upgrade", "autoyast", "you", "disk" , "warewulf");
my @VALID_HEX_FILE_OPTIONS = ("yes", "no", "onlyhex");

#Local Variables
our $bootMethod;
my $hexFileOption = "yes";
my @inputNodes;
my @okNodes;
our @targetNodes;
our %nodeHash;
my %ksmapHash;    # cache ks config file for each node

# Clear dsh environment variables
if(!$ENV{'RUNNING_DSH'}){
    delete $ENV{'DSH_NODE_LIST'};
    delete $ENV{'WCOLL'};
    delete $ENV{'DSH_DEVICE_LIST'};
}
sub doFullSetup
{
	&commonNetBootSetup();
	&setupDHCP();
	&setupPxe();

	# Add the nodes to the RDM dserver configuration
	if (ServerUtils->RDMdserver_installed)
	{
		ServerUtils->RDMdserver_add($bootMethod);
	}
	&copyKernel();
	&makeRAMDisk();
	&setupPxeHex();
}

sub doFullSetupGenerateNoHex
{
	&commonNetBootSetup();
	&setupDHCP();
	&setupPxe();
	
	&setupWarewulf();
	# Add the nodes to the RDM dserver configuration
	if (ServerUtils->RDMdserver_installed)
	{
		ServerUtils->RDMdserver_add($bootMethod);
	}
	&copyKernel();
	&makeRAMDisk();
}

sub doSetupGenerateOnlyHex()
{
	if (!$ENV{CSM_NO_VERIFY})
	{
		&verifyDHCP();
		&verifyHTTP();    # Inside verifyHTTP, checks if HTTP is being used.
		&verifyTFTP();

		&verify_setup();
		&verify_files_in_csminstall();
		&verifyPxe();
		&verifyKernel();
		&verifyRAMDisk();
	}

	&setupPxeHex();
}

sub setupDiskBoot
{
	my $hexFileOption = shift;
	&setupPxe();
	if ($hexFileOption eq "onlyhex") { return; }

	# Add the nodes to the RDM dserver configuration
	&setupDHCP();
	if (ServerUtils->RDMdserver_installed)
	{
		ServerUtils->RDMdserver_add($bootMethod);
	}
}

sub doPPC64Setup
{
	&setupDHCP();
    &dup_drivers($::TOP_DIR);
	if ($bootMethod ne "warewulf")
    {
       	&copyAndHackPPC64Kernel();
    }  
    &setupWarewulf();
	&createInstallConfigFiles();
    if ($bootMethod eq "warewulf")
    {
    	&makeRAMDisk();
	}
}

#-----------------------------------------------------------------------------------

=head3 doPPC64Verify

	Verify prereqisite network services and zImage are ready for ppc nodes

	Comments:
		The command will be called when "onlyhex" option is specified to
		run_setupBoot with pSeries nodes.
=cut

#----------------------------------------------------------------------------------

sub doPPC64Verify
{
	if (!$ENV{CSM_NO_VERIFY})
	{
		&verifyDHCP;
		&verifyHTTP;    # Inside verifyHTTP, checks if HTTP is being used.
		&verifyTFTP;

		&verify_setup_ppc64;
		&verify_files_in_csminstall;
		&verifyPPC64Kernel;
	}
}

sub commonNetBootSetup
{
	&createBootDirectory();
	&createDefaultPxe();
}

sub createBootDirectory
{
	my ($rc) = 0;
	my $disable_recurtive = 1;

	if (!-d "/tftpboot")
	{
		mkdir("/tftpboot");
		NetworkUtils->secureFilePermissions("/tftpboot", '0110', '0440',
											$disable_recurtive);
	}

	# Create the /tftpboot/pxelinux.cfg directory.
	mkpath("$::PXELINUX_CFG_DIR", $::VERBOSE, 0110);
	NetworkUtils->secureFilePermissions($::PXELINUX_CFG_DIR, '0110', '0440',
										$disable_recurtive);

	return $rc;
}

sub createDefaultPxe
{
	my $pxetemplate = $::PXE_DEFAULT_TMPL;
	my $pxefile     = "$::PXELINUX_CFG_DIR/default";
	&copyfile($pxetemplate, $pxefile);

	NetworkUtils->secureFilePermissions($pxefile, '0110', '0440');
}

sub setupGetmacsDHCP
{
	my ($cmd, $output_ref);
	MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
								 'I', 'IMsgGENERATING_DHCP');
	my @nodelist = @targetNodes;
	my $nodelist = join(',', @nodelist);
	my $verbose;
	$verbose = ($::VERBOSE ? "-v" : "");
	if (!($verbose)) { $verbose = ($::VERBOSE ? "-V" : ""); }

	my @ips;
	my $info_collected = 0;
	my $filename       = "";	
	foreach my $node (@nodelist)
	{
		my $ip;
		my $instserver   = $::NODEHASH{$node}{'InstallServer'};
		my $apt_hostname = $::NODEHASH{$node}{'InstallAdapterHostname'};
		my ($servname, $servdir) = split ':', $instserver;

		if ($apt_hostname)
		{
			$ip = (NetworkUtils->getHost($apt_hostname))[1];
		}
		else
		{
			$ip = (NetworkUtils->getHost($node))[1];
		}

		if ($ip)
		{
			push @ips, $ip;
			
			# before adding the dynamic range for this node, delete
			# any existence of this node from the dhcp config file.
			if ($apt_hostname)
			{
				$cmd = "$::MAKEDHCP $verbose --delete $apt_hostname";
				NodeUtils->runcmd($cmd, -1, 1);
			}
			$cmd = "$::MAKEDHCP $verbose --delete $node";
			NodeUtils->runcmd($cmd, -1, 1);
		}
		else
		{
			MessageUtils->message('W', 'IMsgNOT_FOUND_IN_HOSTS', $node);
		}

		if (!$info_collected)
		{
			$info_collected = 1;
			my $arch = $::NODEHASH{$node}{"InstallPkgArchitecture"};
			if ($arch eq "ppc64")
			{
				my $distro   = $::NODEHASH{$node}{"InstallDistributionName"};
				my $version  = $::NODEHASH{$node}{"InstallDistributionVersion"};
				my $svclevel = $::NODEHASH{$node}{"InstallServiceLevel"};
				my $akbnode  = $::NODEHASH{$node}{"InstallAdapterHostname"};

				if (!$akbnode)
				{
					$akbnode = $node;
				}
				my $server_ip = NetworkUtils->get_source_ip_to_target($akbnode);
				chomp($server_ip);
				if ($distro =~ /RedHat/)
				{
					$filename =
					  "$::TFTPDIR/csm/ks$version-$svclevel-$arch-zImage.initrd_$server_ip";
				}
				else
				{
					$filename =
					  "$::TFTPDIR/csm/yast$version-$svclevel-$arch-zImage.initrd_$server_ip";
				}

			}
		}
	}
	my $ip_range = join(',', @ips);
	if ($ip_range)
	{

		# For PXE boot method, suppose all the target nodes are in the same subnet.
		# If install server machine are connected to the nodes in the different subnet using
		# more than one InstallServerAKBNode adapter, probably users may be required to run
		# getadapters seperately.
		my (undef, $netmask) = NetworkUtils->getNetmask($ips[0]);
		$netmask ||= $::BOOT_ATTRIBUTES{'Netmask'};
		$cmd =
		  "$::MAKEDHCP $verbose --add-dynamic $ip_range Netmask=$netmask Gateway=$::BOOT_ATTRIBUTES{'Gateway'}";
		if($filename)
		{
			$cmd .= " -o \"filename \\\"$filename\\\";\"";
		}
	}
	$output_ref = NodeUtils->runcmd($cmd, 0, 1);
	my $fstatus = $::RUNCMD_RC;

	# filter the output to make it look simpler
	my $output = NodeUtils->filter_dhcp_output($output_ref);
	MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
								 'I', 'IMsgShow_Output', $output);
	return $fstatus;

}

sub setupInstallDHCP
{
	my $verbose;
	$verbose = ($::VERBOSE ? "-v" : "");
	if (!($verbose)) { $verbose = ($::VERBOSE ? "-V" : ""); }
	my @nodelist  = @targetNodes;
	my $nl_output = join(',', @nodelist);
	if ($bootMethod eq 'kickstart' or $bootMethod eq 'kickstart-upgrade')
	{
		MessageUtils->messageFromCat(
									 'csmInstall.cat',    $::MSGMAPPATH,
									 'csminstall',        'I',
									 'IMsgUPDATING_DHCP', $::DHCPDCONF,
									 $nl_output
									);
	}
	elsif ($bootMethod eq 'autoyast')
	{
		MessageUtils->messageFromCat(
									'csmInstall.cat',             $::MSGMAPPATH,
									'csminstall',                 'I',
									'IMsgUPDATING_DHCP_AUTOYAST', $::DHCPDCONF,
									$nl_output
									);
	}
	elsif ($bootMethod eq 'hwmaint')
	{
		MessageUtils->messageFromCat(
									 'csmInstall.cat',            $::MSGMAPPATH,
									 'csminstall',                'I',
									 'IMsgUPDATING_DHCP_HWMAINT', $::DHCPDCONF,
									 $nl_output
									);
	}
	elsif ( $bootMethod eq 'warewulf')
	{
		MessageUtils->messageFromCat(
									 'csmInstall.cat',            $::MSGMAPPATH,
									 'csminstall',                'I',
									 'IMsgUPDATING_DHCP_WAREWULF', $::DHCPDCONF,
									 $nl_output
									);
	}
    else
	{    
		# Nothing to do for other boot methods.
		return 0;
	}
	my @mac_nodes;
	my @uuid_nodes;
	my @warn_nodes;
	foreach my $node (@nodelist)
	{
		my $mac  = $::NODEHASH{$node}{'InstallAdapterMacaddr'};
		my $uuid = $::NODEHASH{$node}{'UUID'};
		if ($mac)
		{
			push @mac_nodes, $node;
		}
		elsif ($uuid)
		{
			push @uuid_nodes, $node;
		}
		else
		{
			push @warn_nodes, $node;
		}
	}
	if (scalar(@warn_nodes))
	{
		my $nodelist = join(', ', @warn_nodes);
		MessageUtils->messageFromCat(
									 'csmInstall.cat',     $::MSGMAPPATH,
									 'csminstall',         'I',
									 'IMsgNotAddedToConf', $::DHCPDCONF,
									 $nodelist
									);
	}
	my ($fstatus, $cmd);
	if (@mac_nodes)
	{
		my $nodelist = join(",", @mac_nodes);
		$cmd =
		  "$::MAKEDHCP $verbose $nodelist Gateway=$::BOOT_ATTRIBUTES{'Gateway'} Nameservers=$::BOOT_ATTRIBUTES{'Nameservers'} Netmask=$::BOOT_ATTRIBUTES{'Netmask'}";
		my $output_ref = NodeUtils->runcmd($cmd, 0, 1);
		$fstatus = $::RUNCMD_RC;
		my $output = NodeUtils->filter_dhcp_output($output_ref);
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'I', 'IMsgShow_Output',
									 $output);
	}
	if (@uuid_nodes)
	{
		my $nodelist = join(",", @uuid_nodes);
		$cmd =
		  "$::MAKEDHCP $verbose --uuid $nodelist Gateway=$::BOOT_ATTRIBUTES{'Gateway'}";
		my $output_ref = NodeUtils->runcmd($cmd, 0, 1);
		$fstatus = $::RUNCMD_RC;
		my $output = NodeUtils->filter_dhcp_output($output_ref);
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'I', 'IMsgShow_Output',
									 $output);
	}

	return $fstatus;    # 0 is good
}

#
# Set to boot from disk after various boot methods
#   - getmacsdisk
#   - disk
#   - you
#
sub setupBootDiskDHCP
{
	my ($verbose, $nodelist, $cmd);
	$verbose = ($::VERBOSE ? "-v" : "");
	if (!($verbose)) { $verbose = ($::VERBOSE ? "-V" : ""); }

	if ($bootMethod eq "getmacsdisk")
	{

		# set to boot from disk after running getadapters.
		my @ips;
		foreach my $node (@targetNodes)
		{
			my $ip;
			my $instserver   = $::NODEHASH{$node}{'InstallServer'};
			my $apt_hostname = $::NODEHASH{$node}{'InstallAdapterHostname'};
			my ($servname, $servdir) = split ':', $instserver;

			if ($servname)
			{
				if ($apt_hostname)
				{
					$ip = (NetworkUtils->getHost($apt_hostname))[1];
				}
				else
				{
					$ip = (NetworkUtils->getHost($node))[1];
				}
			}
			else
			{
				$ip = (NetworkUtils->getHost($node))[1];
			}
			if ($ip)
			{
				push @ips, $ip;
			}
			else
			{
				MessageUtils->message('W', 'IMsgNOT_FOUND_IN_HOSTS', $node);
			}
		}
		my $ip_range = join(',', @ips);
		if ($ip_range)
		{
			$cmd = "$::MAKEDHCP $verbose --delete-dynamic $ip_range";
		}

	}
	else
	{

		# set to disk boot after csmsetupks/csmsetupyast, or for "you".
		$nodelist = join(',', @targetNodes);
		$cmd = "$::MAKEDHCP $verbose --delete $nodelist";
	}
	NodeUtils->runcmd($cmd, 0);
}

# Run the createdhcp tool to generate the /etc/dhcpd.conf file for use
# during MAC address collection.
sub setupDHCP
{

	if (defined $ENV{CSM_NO_SETUP_DHCP})
	{
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'I', 'IMsgSKIP_SETUP_DHCP');
		return 0;
	}
	if ($bootMethod eq 'getmacs' || $bootMethod eq 'getmacssnmp')
	{
		return &setupGetmacsDHCP;
	}
	elsif (   $bootMethod eq 'kickstart'
		   || $bootMethod eq 'kickstart-upgrade'
		   || $bootMethod eq 'autoyast'
		   || $bootMethod eq 'hwmaint'
		   || $bootMethod eq 'warewulf')
	{
		return &setupInstallDHCP;
	}
	elsif (   $bootMethod eq "disk"
		   || $bootMethod eq "getmacsdisk"
		   || $bootMethod eq "you")
	{
		return &setupBootDiskDHCP;
	}
}

sub setupGetmacsPxeWithoutConsoleSerialDevice
{
	my $pxetemplate = $::PXE_GETMACS_TMPL;
	my ($svclevel, $pxefile, $additional_parm) = @_;

	my $tempARCH = $::ARCH;
	my $rdsize   = &getGetmacsRAMDiskSize();
	if ($rdsize > 8192)
	{
		$rdsize = "ramdisk_size=$rdsize";
	}
	else
	{
		$rdsize = "";
	}
	open(PXETEMPLATE, "<$pxetemplate")
	  || MessageUtils->messageFromCat(
									  'csmInstall.cat',     $::MSGMAPPATH,
									  'csminstall',         'E2',
									  'EMsgCANT_READ_FILE', $pxetemplate
									 );

	open(PXEFILE, ">$pxefile")
	  || MessageUtils->messageFromCat(
									  'csmInstall.cat',      $::MSGMAPPATH,
									  'csminstall',          'E2',
									  'EMsgCANT_WRITE_FILE', $pxefile
									 );

	my $mygetmacz =
	  "getmac-$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-${tempARCH}z";
	my $mygetmacgz =
	  "getmac-$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-${tempARCH}\.gz";

	while (<PXETEMPLATE>)
	{
		s/console=#CONSOLE_DEVICE#,#CONSOLE_SPEED#//g
		  ;    # Console Device e.g. ttyS0, speed
		s/SERIAL #CONSOLE_DEVICE_NUMBER# #CONSOLE_SPEED#//g;    # and number
		s/getmacz$/$mygetmacz/g;
		s/getmac\.gz/$mygetmacgz/g;
		s/#RAMDISK_SIZE#/$rdsize/g;
        s/#ADDITIONAL_KERNEL_PARAM#/$additional_parm/g;

		print PXEFILE $_;
	}
	close PXETEMPLATE;
	close PXEFILE;
}

sub setupGetmacsPxeWithConsoleSerialDevice
{
	my $pxetemplate = $::PXE_GETMACS_TMPL;
	my ($svclevel, $pxefile, $console_device, $console_speed, $additional_parm) =
	  ($_[0], $_[1], $_[2], $_[3], $_[4]);
	my $tempARCH = $::ARCH;
	my $rdsize   = &getGetmacsRAMDiskSize;
	if ($rdsize > 8192)
	{
		$rdsize = "ramdisk_size=$rdsize";
	}
	else
	{
		$rdsize = "";
	}
	$::CONSOLE_DEVICES{$console_device} = 1;    # save list of unique devices
	my $console_device_number = $console_device;
	$console_device_number =~ s/\D//g;          # remove all non-digits
	open(PXETEMPLATE, "<$pxetemplate")
	  || MessageUtils->messageFromCat(
									  'csmInstall.cat',     $::MSGMAPPATH,
									  'csminstall',         'E2',
									  'EMsgCANT_READ_FILE', $pxetemplate
									 );

	open(PXEFILE, ">$pxefile")
	  || MessageUtils->messageFromCat(
									  'csmInstall.cat',      $::MSGMAPPATH,
									  'csminstall',          'E2',
									  'EMsgCANT_WRITE_FILE', $pxefile
									 );

	my $mygetmacz =
	  "getmac-$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-${tempARCH}z";
	my $mygetmacgz =
	  "getmac-$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-${tempARCH}\.gz";
	while (<PXETEMPLATE>)
	{

		# take out the following three entries related to console serial device and speed
		s/#CONSOLE_DEVICE#/$console_device/g; # Console Device e.g. ttyS0, speed
		s/#CONSOLE_DEVICE_NUMBER#/$console_device_number/g;    # and number
		s/#CONSOLE_SPEED#/$console_speed/g;    # console serial speed
		s/getmacz$/$mygetmacz/g;
		s/getmac\.gz/$mygetmacgz/g;
		s/#RAMDISK_SIZE#/$rdsize/g;
        s/#ADDITIONAL_KERNEL_PARAM#/$additional_parm/g;

		print PXEFILE $_;
	}

	close PXETEMPLATE;
	close PXEFILE;
}

sub substituteHwmaintPxe
{
	my (
		$node,         $ip,             $netmask, $gateway,
		$adapter_name, $svclevel,       $is_ip,   $is_dir,
		$pxefile,      $console_device, $console_speed
	   )
	  = @_;

	my $distro_name = &abbreviateDistroName($::DISTRO_NAME);

	my $kernel_level;
	if ($::ARCH eq "x86_64")
	{
		$kernel_level = "hm-"
		  . $distro_name
		  . $::DISTRO_VERSION
		  . $svclevel
		  . "E";    # e.g. hwm-RHEL3QU2
	}
	else
	{
		$kernel_level = "hm-"
		  . $distro_name
		  . $::DISTRO_VERSION
		  . $svclevel;    # e.g. hwm-RHEL3QU2
	}

	my $pxetemplate;
	my $hm_initrd;
	if (!$nodeHash{$node}{InstallAdapterMacaddr} && $nodeHash{$node}{UUID})
	{
		$pxetemplate =
		    $::DISTRO_NAME =~ /SLES/
		  ? $::PXE_YAST_PREINSTALL_UUID_TMPL
		  : $::PXE_KS_PREINSTALL_UUID_TMPL;
		$hm_initrd = "hm-" . $ip;
	}
	else
	{
		$pxetemplate =
		    $::DISTRO_NAME =~ /SLES/
		  ? $::PXE_YAST_PREINSTALL_TMPL
		  : $::PXE_KS_PREINSTALL_TMPL;
		$hm_initrd = $kernel_level;
	}

	my $rdsize = &getGetmacsRAMDiskSize;
	if ($rdsize > 8192)
	{
		$rdsize = "ramdisk_size=$rdsize";
	}
	else
	{
		$rdsize = "";
	}

	my $console_device_number = $console_device;
	$console_device_number =~ s/\D//g;    # remove all non-digits

	open(PXETEMPLATE, "<$pxetemplate")
	  || MessageUtils->messageFromCat(
									  'csmInstall.cat',     $::MSGMAPPATH,
									  'csminstall',         'E2',
									  'EMsgCANT_READ_FILE', $pxetemplate
									 );
	open(PXEFILE, ">$pxefile")
	  || MessageUtils->messageFromCat(
									  'csmInstall.cat',      $::MSGMAPPATH,
									  'csminstall',          'E2',
									  'EMsgCANT_WRITE_FILE', $pxefile
									 );

    my $hwmaintain_parm = NodesetUtils->getKernelParm(
            "hwmaintain", 
            $nodeHash{$node}
            );
	while (<PXETEMPLATE>)
	{
		s/#ISATTR#/$is_ip\:$is_dir/g;
		s/#NODE_IP#/$ip/g;
		s/#NODE_NETMASK#/$netmask/g;
		s/#NODE_GW#/$gateway/g;
		s/#NETDEVICE#/$adapter_name/g;
		s/#KS_LEVEL#/$kernel_level/g;      # Kernel Level
		s/#YAST_LEVEL#/$kernel_level/g;    # Kernel Level
		s/#HM_INITRD#/$hm_initrd/g;
		s/#RAMDISK_SIZE#/$rdsize/g;
        s/#ADDITIONAL_KERNEL_PARAM#/$hwmaintain_parm/g;
        
		if ($console_device eq 'NONE')
		{
			s/console=#CONSOLE_DEVICE#,#CONSOLE_SPEED#//g;
			s/SERIAL #CONSOLE_DEVICE_NUMBER# #CONSOLE_SPEED#//g;
		}
		else
		{
			s/#CONSOLE_DEVICE#/$console_device/g
			  ;    # Console Device e.g. ttyS0, speed
			s/#CONSOLE_DEVICE_NUMBER#/$console_device_number/g;    # and number
			s/#CONSOLE_SPEED#/$console_speed/g;    # console serial speed
		}

		print PXEFILE $_;

	}

	close(PXEFILE);
	close(PXETEMPLATE);
}

sub substituteKickstartPxe
{
	my (
		$node,      $svclevel,       $pxefile,       $ip,
		$is_ipaddr, $ksfile,         $ksfile_dir,    $adapter_name,
        $console_device,             $console_speed, $rdsize
	   )
	  = @_;
    
	my $pxetemplate;
	my $ks_level;
	if (!$nodeHash{$node}{InstallAdapterMacaddr} && $nodeHash{$node}{UUID})
	{
		$pxetemplate = $::PXE_INSTALL_UUID_TMPL;
	}
	else
	{
		my $install_protocol = NodesetUtils->get_NetworkInstallProtocol();
		if ($install_protocol =~ /nfs/i)
		{
			$pxetemplate = $::PXE_INSTALL_TMPL;
		}
		elsif ($install_protocol =~ /http/i)
		{
			$pxetemplate = $::PXE_INSTALL_HTTP_TMPL;
		}
		else
		{
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
					 'csminstall', 'E2', 'EMsgINVALID_NETWORK_INSTALL_PROTOCOL',
					 $install_protocol);
		}
	}

	if ($ENV{CSM_USERPXEFILE})
	{
		$pxetemplate =
		  "$ENV{CSMINSTALL_ROOT}/csm/usrkernel/$ENV{CSM_USERPXEFILE}";
	}

	$ks_level = "ks-"
	  . $::DISTRO_NAME
	  . $::DISTRO_VERSION . "-"
	  . $svclevel . "-"
	  . $::ARCH;    # e.g. ks7.3-GA-i386

	open(PXETEMPLATE, "<$pxetemplate")
	  || MessageUtils->messageFromCat(
									  'csmInstall.cat',     $::MSGMAPPATH,
									  'csminstall',         'E2',
									  'EMsgCANT_READ_FILE', $pxetemplate
									 );
	open(PXEFILE, ">$pxefile")
	  || MessageUtils->messageFromCat(
									  'csmInstall.cat',      $::MSGMAPPATH,
									  'csminstall',          'E2',
									  'EMsgCANT_WRITE_FILE', $pxefile
									 );
	if ($rdsize > 8192)
	{
		$rdsize = "ramdisk_size=$rdsize";
	}
	else
	{
		$rdsize = "";
	}

    my $install_parm = NodesetUtils->getKernelParm(
            "install", 
            $nodeHash{$node}
            );

	my $con_redir;
	my $clearup_console_flags=0;
	if(defined($con_redir=$nodeHash{$node}{ConsoleRedirectionAfterPOST}))
	{
		if($con_redir==1)
		{
			$clearup_console_flags=1;
		}
	}
	if ($console_device)
	{
		my $console_device_number = $console_device;
		$console_device_number =~ s/\D//g;    # remove all non-digits
		while (<PXETEMPLATE>)
		{
			if($clearup_console_flags)
			{
				s/SERIAL #CONSOLE_DEVICE_NUMBER# #CONSOLE_SPEED#//g;
				# avoid double characters from pxelinux over the serial port
			}
			s/#CONSOLE_DEVICE_NUMBER#/$console_device_number/g;
			s/#CONSOLE_SPEED#/$console_speed/g;
			s/#NFS_IP#/$is_ipaddr/g;     # Management server (NFS server)
			s/#IS_IP#/$is_ipaddr/g;
			s/#CLIENT_IP#/$ip/g;
			s/#KS_LEVEL#/$ks_level/g;    # Kickstart Level e.g. ks71
			s/#KS_DIR#/$ksfile_dir/g;    # Kickstart File Directory
			s/#KS_FILE#/$ksfile/g;       # Kickstart File <nodeip>-kickstart
			s/#CONSOLE_DEVICE#/$console_device/g;    # Console Device e.g. ttyS0
			s/#ADAPTER_NAME#/$adapter_name/g;        # AdapterName
			s/#RAMDISK_SIZE#/$rdsize/g;   #Ram Disk Size e.g. ramdisk_size=16384
            s/#ADDITIONAL_KERNEL_PARAM#/$install_parm/g;

			print PXEFILE $_;
		}
	}
	else
	{
		while (<PXETEMPLATE>)
		{
            s/console=#CONSOLE_DEVICE#,#CONSOLE_SPEED#//g;
            # Console Device e.g. ttyS0, speed
			s/#NFS_IP#/$is_ipaddr/g;     # Management server (NFS server)
			s/#IS_IP#/$is_ipaddr/g;
			s/#CLIENT_IP#/$ip/g;
			s/#KS_LEVEL#/$ks_level/g;    # Kickstart Level e.g. ks71
			s/#KS_DIR#/$ksfile_dir/g;    # Kickstart File Directory
			s/#KS_FILE#/$ksfile/g;       # Kickstart File <nodeip>-kickstart
			s/#ADAPTER_NAME#/$adapter_name/g;    # AdapterName
			    # take out the following two entries related to,
			    # console serial device
			s/SERIAL #CONSOLE_DEVICE_NUMBER# #CONSOLE_SPEED#//g;    # and number
			s/#RAMDISK_SIZE#/$rdsize/g;   #Ram Disk Size e.g. ramdisk_size=16384
            s/#ADDITIONAL_KERNEL_PARAM#/$install_parm/g;

			print PXEFILE $_;
		}
	}
	close PXETEMPLATE;
	close PXEFILE;
}

sub substituteAutoyastPxe
{
	my (
		$node,          $svclevel,     $pxefile,     $ip,
		$is_ipaddr,     $gw,           $yastcfgfile, $yastcfgfile_dir,
        $nfs_dir,       $adapter_name, $console_device,
        $console_speed, $nfssvr_ip,    $insmod,	$netwait
	   )
	  = @_;
    
	my $pxetemplate;
	my ($yast_level, $installsrc);

	my $install_protocol = NodesetUtils->get_NetworkInstallProtocol();
	if (!$nodeHash{$node}{InstallAdapterMacaddr} && $nodeHash{$node}{UUID})
	{
		$pxetemplate = $::PXE_YASTINSTALL_UUID_TMPL;

		# Special for HTTP install protocol and UUID with blade machines. Have to move
		# Install=http://... from info file to PXE configuration file. Otherwise,
		# installatation will hang at "could not find installation source".
		if (   $install_protocol =~ /http/i
			&& $nodeHash{$node}{"IsBlade"} =~ /yes/i)
		{
			$installsrc = "install=http://$is_ipaddr/$nfs_dir";
		}
	}
	elsif ($install_protocol =~ /nfs/i)
	{
		$pxetemplate = $::PXE_YASTINSTALL_TMPL;
	}
	elsif ($install_protocol =~ /http/i)
	{
		$pxetemplate = $::PXE_YASTINSTALL_HTTP_TMPL;
	}
	else
	{
		MessageUtils->messageFromCat(
									 'csmInstall.cat',
									 $::MSGMAPPATH,
									 'csminstall',
									 'E2',
									 'EMsgINVALID_NETWORK_INSTALL_PROTOCOL',
									 $install_protocol
									);
	}

	if ($ENV{CSM_USERPXEFILE})
	{
		$pxetemplate =
		  "$ENV{CSMINSTALL_ROOT}/csm/usrkernel/$ENV{CSM_USERPXEFILE}";
	}

	$yast_level = "yast-"
	  . $::DISTRO_NAME
	  . $::DISTRO_VERSION . "-"
	  . $svclevel . "-"
	  . $::ARCH;    # e.g. yast-SLES8.1-SP3-i386

	my $server  = $nfssvr_ip    ? "server=$nfssvr_ip" : "";

	open(PXETEMPLATE, "<$pxetemplate")
	  || MessageUtils->messageFromCat(
									  'csmInstall.cat',     $::MSGMAPPATH,
									  'csminstall',         'E2',
									  'EMsgCANT_READ_FILE', $pxetemplate
									 );
	open(PXEFILE, ">$pxefile")
	  || MessageUtils->messageFromCat(
									  'csmInstall.cat',      $::MSGMAPPATH,
									  'csminstall',          'E2',
									  'EMsgCANT_WRITE_FILE', $pxefile
									 );

    my $install_parm = NodesetUtils->getKernelParm(
            "install", 
            $nodeHash{$node}
            );
	
	my $clearup_console_flags=0;
	if($install_parm ne '')
	{
		$clearup_console_flags=1;
	}

	my $con_redir;
	if(defined($con_redir=$nodeHash{$node}{ConsoleRedirectionAfterPOST}))
	{
		if($con_redir==1)
		{
			$clearup_console_flags=1;
		}
	}
	if ($netwait){
            $install_parm .= " $netwait";
        }
	
        if ($insmod){
        $install_parm .= " $insmod";
        }
	
	if ($console_device)
	{
		my $console_device_number = $console_device;
		$console_device_number =~ s/\D//g;    # remove all non-digits
		while (<PXETEMPLATE>)
		{
            if($clearup_console_flags)
			{
				s/SERIAL #CONSOLE_DEVICE_NUMBER# #CONSOLE_SPEED#//g
				  ; # avoid double characters from pxelinux over the serial port
			}
			s/#NFS_IP#/$is_ipaddr/g;            # Management server (NFS server)
			s/#IS_IP#/$is_ipaddr/g;
			s/#CLIENT_IP#/$ip/g;
			s/#YAST_LEVEL#/$yast_level/g;       # YaST Level (yast-SLES8.1-i386)
			s/#YASTCFG_DIR#/$yastcfgfile_dir/g; # YaST Config File Directory
			s/#YASTCFG_FILE#/$yastcfgfile/g
			  ;                        # YaST Config File <nodeip>-autoyast.xml
			s/#NFS_DIR#/$nfs_dir/g;    # NFS directory (SUSE_TOP)
			s/#CONSOLE_DEVICE#/$console_device/g;    # Console Device e.g. ttyS0
			s/#CONSOLE_DEVICE_NUMBER#/$console_device_number/g;    # and number
			s/#CONSOLE_SPEED#/$console_speed/g; # Console serial speed e.g. 9600
            s/#ADDITIONAL_KERNEL_PARAM#/$install_parm/g;
			s/#ADAPTER_NAME#/$adapter_name/g;   # AdapterName
			s/#GATEWAY#/$gw/g;                  # gatway  for i386
			s/#NFSSERVER#/$server/g;
			s/#INSTALLSRC#/$installsrc/g;

			print PXEFILE $_;
		}
	}
	else
	{
		while (<PXETEMPLATE>)
		{
			s/#NFS_IP#/$is_ipaddr/g;            # Management server (NFS server)
			s/#IS_IP#/$is_ipaddr/g;
			s/#CLIENT_IP#/$ip/g;
			s/#YAST_LEVEL#/$yast_level/g;       # YaST Level (yast-SLES8.1-i386)
			s/#YASTCFG_DIR#/$yastcfgfile_dir/g; # YaST Config File Directory
			s/#YASTCFG_FILE#/$yastcfgfile/g
			  ;                        # YaST Config File <nodeip>-autoyast.xml
			s/#NFS_DIR#/$nfs_dir/g;    # NFS directory (SUSE_TOP)

			# take out the following two entries related to,
			# console serial device
			s/console=#CONSOLE_DEVICE#,#CONSOLE_SPEED#//g
			  ;                        # Console Device e.g. ttyS0, speed
			s/SERIAL #CONSOLE_DEVICE_NUMBER# #CONSOLE_SPEED#//g;    # and number
			    # in case there is an old template:
			s/SERIAL #CONSOLE_DEVICE_NUMBER# 9600//g;
            s/#ADDITIONAL_KERNEL_PARAM#/$install_parm/g;
			s/#ADAPTER_NAME#/$adapter_name/g;    # AdapterName
			s/#GATEWAY#/$gw/g;                   # gatway  for i386
			s/#NFSSERVER#/$server/g;
			s/#INSTALLSRC#/$installsrc/g;

			print PXEFILE $_;
		}
	}
	close PXETEMPLATE;
	close PXEFILE;
}

sub substituteWarewulfPxe
{
	my (
		$node,         $ip,             $netmask, $gateway,
		$adapter_name, $svclevel,       $is_ip,   $is_dir,
		$pxefile,      $console_device, $console_speed,$vnfs
	   )
	  = @_;

	
	my $pxetemplate=$::PXE_WAREWULF_TMPL;
	
	open(PXETEMPLATE, "<$pxetemplate")
	  || MessageUtils->messageFromCat(
									  'csmInstall.cat',     $::MSGMAPPATH,
									  'csminstall',         'E2',
									  'EMsgCANT_READ_FILE', $pxetemplate
									 );
	open(PXEFILE, ">$pxefile")
	  || MessageUtils->messageFromCat(
									  'csmInstall.cat',      $::MSGMAPPATH,
									  'csminstall',          'E2',
									  'EMsgCANT_WRITE_FILE', $pxefile
									 );
    my $kernel = "$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH"."z";
	my $initrd = "ww-$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH.gz";

    my $con_redir;
    my $clearup_console_flags=0;
    if(defined($con_redir=$nodeHash{$node}{ConsoleRedirectionAfterPOST}))
    {
        if($con_redir==1)
        {
            $clearup_console_flags=1;
        }
    }
	if ($console_device)
	{
			my $console_device_number = $console_device;
			$console_device_number =~ s/\D//g;    # remove all non-digits
			while (<PXETEMPLATE>)
			{
				if($clearup_console_flags)
				{
					s/SERIAL #CONSOLE_DEVICE_NUMBER# #CONSOLE_SPEED#//g;
					# avoid double characters from pxelinux over the serial port
				}
				s/#CONSOLE_DEVICE_NUMBER#/$console_device_number/g;
				s/#CONSOLE_SPEED#/$console_speed/g;
            	s/#CONSOLE_DEVICE#/$console_device/g;    # Console Device e.g. ttyS0
				s/#HOSTNAME#/$node/g;
				s/#MASTER#/$is_ip/g;
				s/#GATEWAY#/$gateway/g;
				s/#VNFS#/$vnfs/g;
				s/#DEV#/$adapter_name/g;
				s/#IP#/$ip/g;      # Kernel Level
				s/#NETMASK#/$netmask/g;    # Kernel Level
				# Change the names of kernel and initrd generated by warewulf
				# into CSM definition name 
				s/#KERNEL#/$kernel/g; # Change the kernel 
				s/#INITRD#/$initrd/g; # Change the initrd  
				print PXEFILE $_;

			}
	}
	else
	{
			while (<PXETEMPLATE>)
			{
            		s/console=#CONSOLE_DEVICE#,#CONSOLE_SPEED#//g;
            		# Console Device e.g. ttyS0, speed
                	# take out the following two entries related to,
                	# console serial device
            		s/SERIAL #CONSOLE_DEVICE_NUMBER# #CONSOLE_SPEED#//g;    # and number
					s/#HOSTNAME#/$node/g;
					s/#MASTER#/$is_ip/g;
					s/#GATEWAY#/$gateway/g;
					s/#VNFS#/$vnfs/g;
					s/#DEV#/$adapter_name/g;
					s/#IP#/$ip/g;      # Kernel Level
					s/#NETMASK#/$netmask/g;    # Kernel Level
					# Change the names of kernel and initrd generated by warewulf
					# into CSM definition name 
					s/#KERNEL#/$kernel/g; # Change the kernel 
					s/#INITRD#/$initrd/g; # Change the initrd  
					print PXEFILE $_;

			}

	}

	close(PXEFILE);
	close(PXETEMPLATE);
}
sub setupSisInstallPxeWithoutConsoleSerialDevice
{
	my ($pxefile)   = @_;
	my $pxetemplate = $::PXE_INSTALL_TMPL;
	my $sis_level   = "sis" . $::DISTRO_VERSION;    # e.g. sis7.2

	open(PXETEMPLATE, "<$pxetemplate")
	  || MessageUtils->messageFromCat(
									  'csmInstall.cat',     $::MSGMAPPATH,
									  'csminstall',         'E2',
									  'EMsgCANT_READ_FILE', $pxetemplate
									 );

	open(PXEFILE, ">$pxefile")
	  || MessageUtils->messageFromCat(
									  'csmInstall.cat',      $::MSGMAPPATH,
									  'csminstall',          'E2',
									  'EMsgCANT_WRITE_FILE', $pxefile
									 );

	while (<PXETEMPLATE>)
	{
		s/#SIS_LEVEL#/$sis_level/g; # SIS Level
		                            # take out the following entries related to,
		                            # console serial device
		s/console=#CONSOLE_DEVICE#,#CONSOLE_SPEED#//g
		  ;                         # Console Device e.g. ttyS0, speed
		s/SERIAL #CONSOLE_DEVICE_NUMBER# #CONSOLE_SPEED#//g;    # and number

		print PXEFILE $_;
	}

}

sub setupSisInstallPxeWithConsoleSerialDevice
{

	my ($pxefile, $console_device, $console_speed) = @_;
	my $pxetemplate           = $::PXE_INSTALL_TMPL;
	my $sis_level             = "sis" . $::DISTRO_VERSION;      # e.g. sis7.2
	my $console_device_number = $console_device;
	$console_device_number =~ s/\D//g;    # remove all non-digits

	open(PXETEMPLATE, "<$pxetemplate")
	  || MessageUtils->messageFromCat(
									  'csmInstall.cat',     $::MSGMAPPATH,
									  'csminstall',         'E2',
									  'EMsgCANT_READ_FILE', $pxetemplate
									 );

	open(PXEFILE, ">$pxefile")
	  || MessageUtils->messageFromCat(
									  'csmInstall.cat',      $::MSGMAPPATH,
									  'csminstall',          'E2',
									  'EMsgCANT_WRITE_FILE', $pxefile
									 );

	while (<PXETEMPLATE>)
	{
		s/#SIS_LEVEL#/$sis_level/g;              # SIS Level
		s/#CONSOLE_DEVICE#/$console_device/g;    # Console Device e.g. ttyS0
		s/#CONSOLE_DEVICE_NUMBER#/$console_device_number/g;    # and number
		s/#CONSOLE_SPEED#/$console_speed/g;                    # and speed

		print PXEFILE $_;
	}

	close PXETEMPLATE;
	close PXEFILE;

}

sub setupGetmacsPxe
{
	my $pxetemplate = $::PXE_GETMACS_TMPL;

	# This must be expanded to process the REAL list of nodes
	my $node = $targetNodes[0];
	my $host = $node;
	if ($nodeHash{$node}{"InstallAdapterHostname"})
	{
		$host = $nodeHash{$node}{"InstallAdapterHostname"};
	}

    my $install_parm = NodesetUtils->getKernelParm(
            "install", 
            $nodeHash{$node}
            );

	my $svclevel = NodeUtils->getNodeServiceLevel($node);
	my ($nodename, $nodeip) = NetworkUtils->getHost($host);
	my $pxefile        = "$::PXELINUX_CFG_DIR/getmacs.default";
	my $console_device = $nodeHash{$node}{"ConsoleSerialDevice"};
	my $console_speed  = $nodeHash{$node}{"ConsoleSerialSpeed"};

	# If the ConsoleSerialDevice attribute is set to 'NONE', this is
	# A System that has no console serial device.
	if ($console_device eq 'NONE')
	{
		&setupGetmacsPxeWithoutConsoleSerialDevice($svclevel, $pxefile,
												   $install_parm);
	}
	else
	{

		# If the ConsoleSerialDevice attribute is unset, assume this is
		# a system that was migrated from early CSM 1.2 which hardcoded ttyS1
		if ($console_device eq '')
		{
			$console_device = "ttyS1";
		}
		&setupGetmacsPxeWithConsoleSerialDevice($svclevel, $pxefile,
								$console_device, $console_speed, $install_parm);
	}

	# Secure new pxefile
	NetworkUtils->secureFilePermissions("$pxefile", "0110", "0440");

	# one last edit, get rid of the read/write option in the kernel
    my ($effective_distro_name, $effective_distro_ver) =
        NodeUtils->getEffectiveDistro($::DISTRO_NAME, $::DISTRO_VERSION);
	if (
		!(
		   $effective_distro_name =~ /SLES/ ||
           ($effective_distro_name =~ /RedHat/ &&
           $effective_distro_ver =~ /3/)
		 )
	   )
	{
		open(WRITEFILE, "$pxefile")
		  || MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
						 'csminstall', 'E2', 'EMsgCANT_WRITE_FILE', "$pxefile");
		my @content = <WRITEFILE>;
		close(WRITEFILE);
		grep("s/APPEND rw/APPEND/g", @content);
		open(WRITEFILE, ">$pxefile")
		  || MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
						 'csminstall', 'E2', 'EMsgCANT_WRITE_FILE', "$pxefile");
		print WRITEFILE @content;
		close(WRITEFILE);
	}
}

sub setupGetmacsSNMPPxe
{
	my ($effective_distro_name) = NodeUtils->getEffectiveDistro($::DISTRO_NAME);
	if ($effective_distro_name =~ /RedHat/)
	{
		&setupKickstartPxe;
	}
	else
	{
		&setupAutoyastPxe;
	}
}

sub setupKickstartPxe
{

	# for kickstart
	# Create an install pxe configuration file for each node.
	# The name of the file is /tftpboot/pxelinux.cfg/<nodename>.install.

	my $pxetemplate = $::PXE_INSTALL_TMPL;

	# This must be expanded to process the REAL list of nodes
	foreach my $node (@targetNodes)
	{
		my $svclevel = NodeUtils->getNodeServiceLevel($node);
		my ($nodename, $nodeip) = NetworkUtils->getHost($node);
		if ($nodeHash{$node}{InstallAdapterHostname})
		{
			($nodename, $nodeip) =
			  NetworkUtils->getHost($nodeHash{$node}{InstallAdapterHostname});
		}

		my ($isvr_hostname, $issvr_ip, $issvr_dir) = &get_node_isvr($node);

		# Kickstart config file directory.
		# Example:  /csminstall/csm/1.5.0/kickstart.RedHatEL-AS4
		my $ksfile_dir =
		    "$issvr_dir/csm/"
		  . $::CSM_VERSION
		  . "/kickstart."
		  . $::DISTRO_NAME
		  . $::DISTRO_VERSION;
		my $pxefile;
		my $ksfile;
		$pxefile = "$::PXELINUX_CFG_DIR/$nodename.install";
		$ksfile  = "${nodeip}-kickstart";

		# cache ksfile and ksdir for later use
		$ksmapHash{$node}{ksdir}  = $ksfile_dir;
		$ksmapHash{$node}{ksfile} = $ksfile;

		my $console_device = $nodeHash{$node}{"ConsoleSerialDevice"};
		my $adapter_name   = $nodeHash{$node}{"InstallAdapterName"};
		$adapter_name ||= "eth0";
		my $console_speed = $nodeHash{$node}{"ConsoleSerialSpeed"};

		# If the ConsoleSerialDevice attribute is set to 'NONE', this is
		# a system that has no console serial device.
		if ($console_device eq 'NONE')
		{
			$console_device = undef;
			$console_device = undef;
		}
		elsif (!$console_device)
		{
			$console_device = "ttyS1";
		}
		my $rdsize = &getRAMDiskSize;

		&substituteKickstartPxe(
								$node,          $svclevel,
								$pxefile,       $nodeip,
								$issvr_ip,      $ksfile,
								$ksfile_dir,    $adapter_name,
                                $console_device,$console_speed,
                                $rdsize
							   );

		# Secure new pxefile
		NetworkUtils->secureFilePermissions("$pxefile", "0110", "0440", 1);
	}    #end of for loop
	&createKickstartFiles();
}

sub setupAutoyastPxe
{

	# for autoyast
	# Create an install pxe configuration file for each node.
	# The name of the file is /tftpboot/pxelinux.cfg/<nodename>.install.

	my $pxetemplate = $::PXE_YASTINSTALL_TMPL;

	# This must be expanded to process the REAL list of nodes
	foreach my $node (@targetNodes)
	{
		my $svclevel = NodeUtils->getNodeServiceLevel($node);
		my ($nodename, $nodeip) = NetworkUtils->getHost($node);
		if ($nodeHash{$node}{InstallAdapterHostname})
		{
			($nodename, $nodeip) =
			  NetworkUtils->getHost($nodeHash{$node}{InstallAdapterHostname});
		}

		my $ksfile_dir;
		my $gw = $nodeHash{$node}{"InstallAdapterGateway"};
		if (!$gw)
		{
			$gw = $::BOOT_ATTRIBUTES{"Gateway"};
			if (!$gw) { $gw = "0.0.0.0" }
		}

		my ($issvr_hostname,  $issvr_ip,  $issvr_dir)  = &get_node_isvr($node);
		my ($nfssvr_hostname, $nfssvr_ip, $nfssvr_dir) =
		  &get_node_nfssvr($node);
		my $ms_ip =
		  NetworkUtils->validate_ip($nodeHash{$node}{ManagementServer});

		# AutoYaST config file directory.
		# Example:  /csminstall/csm/1.3.2/autoyast.SLES8.1
		my $yastcfgfile_dir =
		    "$issvr_dir/csm/"
		  . $::CSM_VERSION
		  . "/autoyast."
		  . $::DISTRO_NAME
		  . $::DISTRO_VERSION;

		my $pxefile;
		my $yastcfgfile;
		$pxefile     = "$::PXELINUX_CFG_DIR/$nodename.install";
		$yastcfgfile = "${nodeip}.xml";
		
		my $nfs_dir     = $::SUSE_TOP;				
		if ($::DISTRO_VERSION eq '10')
		{
			$nfs_dir = $nfs_dir . "/" . $svclevel . "/CD1/";
		}
		else
		{
			$nfs_dir = $nfs_dir . "/" . $svclevel . "/";
		}

		# cache ksfile and ksdir for later use
		$ksmapHash{$node}{ksdir}  = $yastcfgfile_dir;
		$ksmapHash{$node}{ksfile} = $yastcfgfile;
		$ksmapHash{$node}{nfsdir} = $nfs_dir;

		# AutoYaST config file should be taken from MS when NFSServer is specified.
		$ksmapHash{$node}{issvr}  = $nfssvr_ip ? $ms_ip : $issvr_ip;
		$ksmapHash{$node}{nfssvr} = $issvr_ip;

		my $console_device = $nodeHash{$node}{"ConsoleSerialDevice"};
		my $adapter_name   = $nodeHash{$node}{"InstallAdapterName"};
		$adapter_name ||= "eth0";
		my $console_speed = $nodeHash{$node}{"ConsoleSerialSpeed"};

		# If the ConsoleSerialDevice attribute is set to 'NONE', this is
		# a system that has no console serial device.
		if ($console_device eq 'NONE')
		{
			$console_device = undef;
			$console_device = undef;
		}
		elsif (!$console_device)
		{
			$console_device = "ttyS1";
		}

		my $insmod="";
		my $raid="";
		my $netwait="";
		if (
			$nodeHash{$node}{'InstallDistributionName'}    eq "SLES"
		)
		{
			if(defined($raid = $nodeHash{$node}{'HostRAIDEnabled'}))
			{
				if ($raid == 1)
				{
					$insmod = "insmod=a320raid brokenmodules=aic79xx";
				}
			}
		}

		# Add netwait parameter to avoid SLES HTTP&UUID installation failure
                my $install_protocol = NodesetUtils->get_NetworkInstallProtocol();
                if (($nodeHash{$node}{'UUID'}) && ($install_protocol =~ /HTTP/i))
                {
                        $netwait = "netwait=30";
                }


		&substituteAutoyastPxe(
							   $node,          $svclevel,
							   $pxefile,       $nodeip,
							   $issvr_ip,      $gw,
							   $yastcfgfile,   $yastcfgfile_dir,
							   $nfs_dir,       $adapter_name,
                               $console_device,$console_speed,
                               $nfssvr_ip,     $insmod,	$netwait
							  );

		# Secure new pxefile
		NetworkUtils->secureFilePermissions("$pxefile", "0110", "0440", 1);
	}    #end of for loop

	&createAutoyastFiles();
}

sub setupSISPxe
{

	# for SIS
	# Create an install pxe configuration file for each node.
	# The name of the file is /tftpboot/pxelinux.cfg/<nodename>.sis.
	my $pxetemplate = $::PXE_INSTALL_TMPL;
	my $sis_level   = "sis" . $::DISTRO_VERSION;    # e.g. sis7.2

	# SIS config file directory.
	# Example:  /csminstall/csm/1.2.0/sis.SLES7.2
	my $sisfile_dir =
	    "/csminstall/csm/"
	  . $::CSM_VERSION . "/sis."
	  . $::DISTRO_NAME
	  . $::DISTRO_VERSION;

	# This must be expanded to process the REAL list of nodes
	foreach my $node (@targetNodes)
	{
		my ($nodename, $nodeip) = NetworkUtils->getHost($node);
		my $pxefile = "$::PXELINUX_CFG_DIR/$nodename.sis";

		# Change for console number support
		my $console_device = $nodeHash{$node}{"ConsoleSerialDevice"};
		my $console_speed  = $nodeHash{$node}{"ConsoleSerialSpeed"};

		# If the ConsoleSerialDevice attribute is set to 'NONE', this is
		# a system that has no console serial device.
		if ($console_device eq 'NONE')
		{
			&setupSisInstallPxeWithoutConsoleSerialDevice($pxefile);
		}
		else
		{

			# If the ConsoleSerialDevice attribute is unset, assume this is
			# a system that was migrated from early CSM 1.2 which hardcoded ttyS1
			if ($console_device eq '')
			{
				$console_device = "ttyS1";
			}
			my $console_device_number = $console_device;
			$console_device_number =~ s/\D//g;    # remove all non-digits
			&setupSisInstallPxeWithConsoleSerialDevice($pxefile,
											   $console_device, $console_speed);
		}
	}    #end of for
}

sub setupDiskPxe
{
	my $InDir    = "/tftpboot/pxelinux.cfg";
	my @nodeList = @targetNodes;
	my @ips;
	foreach my $node (@nodeList)
	{
		my $ip = NetworkUtils->getHost($node);
		push(@ips, $ip);

		# CSM will remove the Hex files for both Hostname and InstallAdapterHostname
		if ($nodeHash{$node}{"InstallAdapterHostname"})
		{
			$ip =
			  NetworkUtils->getHost($nodeHash{$node}{"InstallAdapterHostname"});
			push(@ips, $ip);
		}
	}
	my %hexNames = NetworkUtils->genHex(@ips);
	foreach (keys %hexNames)
	{
		my $HEX = $hexNames{$_};
		if (-f "$::PXELINUXCFG/$HEX")
		{
			rmtree("$::PXELINUXCFG/$HEX", $::VERBOSE, 1);
		}

	}
}

sub setupHwmaintPxe
{
	my @setup_ks_nodes;

	foreach my $node (@targetNodes)
	{
		my $svclevel = NodeUtils->getNodeServiceLevel($node);

		# If the InstallAdapterHostname is set,
		# here nodeip is the IP of InstallAdapterHostname.
		my $ip;
		if ($nodeHash{$node}{InstallAdapterHostname})
		{
			$ip = $nodeHash{$node}{InstallAdapterHostname};
		}
		else
		{
			(undef, $ip) = NetworkUtils->getHost($node);
		}

		# Get the hostname of the management server as known by this node
		#my ($ms_hostname, $ms_ipaddr) = &get_node_management_server($nodename);
		my ($is_hostname, $is_ip, $is_dir) = &get_node_isvr($node);

		my $pxefile = "$::PXELINUX_CFG_DIR/$node.hwmaint";

		my $adapter_name = $nodeHash{$node}{"InstallAdapterName"};
		$adapter_name ||= "eth0";
		my $netmask = $nodeHash{$node}{"InstallAdapterNetmask"};
		$netmask ||= $::BOOT_ATTRIBUTES{"Netmask"};
		my $gateway = $nodeHash{$node}{"InstallAdapterGateway"};
		$gateway ||= $::BOOT_ATTRIBUTES{"Gateway"};
		my $console_device = $nodeHash{$node}{"ConsoleSerialDevice"};
		$console_device ||= 'ttyS0';
		my $console_speed = $nodeHash{$node}{"ConsoleSerialSpeed"};
		$console_speed ||= '9600';

		&substituteHwmaintPxe(
							  $node,         $ip,
							  $netmask,      $gateway,
							  $adapter_name, $svclevel,
							  $is_ip,        $is_dir,
							  $pxefile,      $console_device,
							  $console_speed
							 );

		# Secure new pxefile
		NetworkUtils->secureFilePermissions("$pxefile", "0110", "0440", 1);

		# For the nodes that only has UUID, need to encapsulate the
		# kickstart file into its ramdisk for RedHat nodes. For SLES
		# nodes, only a info file is needed, so don't generate autoyast file.
		if (!$nodeHash{$node}{InstallAdapterMacaddr}
			&& $nodeHash{$node}{UUID})
		{
			push @setup_ks_nodes, $node;

			# now generate the kickstart/autoyast file
            my ($effective_distro_name) =
                NodeUtils->getEffectiveDistro($::DISTRO_NAME);
			if ($effective_distro_name =~ /RedHat/)
			{

				# Kickstart config file directory.
				# Example:  /csminstall/csm/1.5.0/kickstart.RedHatEL-AS4
				my $ksfile_dir =
				    "$is_dir/csm/"
				  . $::CSM_VERSION
				  . "/kickstart."
				  . $::DISTRO_NAME
				  . $::DISTRO_VERSION;
				my $ksfile = "$ip-kickstart";

				# cache ksfile and ksdir for later use
				$ksmapHash{$node}{ksdir}  = $ksfile_dir;
				$ksmapHash{$node}{ksfile} = $ksfile;
			}
		}

	}    #end of for loop

	# generate kickstart file for the RedHat nodes with UUID only.
	# they will be put into each ramdisk of these nodes to avoid sending
	# the DHCP requests.
	if (@setup_ks_nodes)
	{
		my @targetNodes_bak = @targetNodes;
		@targetNodes = @setup_ks_nodes;
		if ($::DISTRO_NAME =~ /RedHat/)
		{
			&createKickstartFiles();
		}
		@targetNodes = @targetNodes_bak;
	}

}

sub setupWarewulfPxe
{

	foreach my $node (@targetNodes)
	{
		my $svclevel = NodeUtils->getNodeServiceLevel($node);

		# If the InstallAdapterHostname is set,
		# here nodeip is the IP of InstallAdapterHostname.
		my $ip;
		if ($nodeHash{$node}{InstallAdapterHostname})
		{
			$ip = $nodeHash{$node}{InstallAdapterHostname};
		}
		else
		{
			(undef, $ip) = NetworkUtils->getHost($node);
		}

		# Get the hostname of the management server as known by this node
		#my ($ms_hostname, $ms_ipaddr) = &get_node_management_server($nodename);
		my ($is_hostname, $is_ip, $is_dir) = &get_node_isvr($node);

		my $pxefile = "$::PXELINUX_CFG_DIR/$node.warewulf";

		my $adapter_name = $nodeHash{$node}{"InstallAdapterName"};
		$adapter_name ||= "eth0";
		# Check and get attribute as this order: node def, cmd line, default
		my $netmask = $nodeHash{$node}{"InstallAdapterNetmask"};
		$netmask ||= $::ATTRS{"Netmask"};
		$netmask ||= $::BOOT_ATTRIBUTES{"Netmask"};
		my $gateway = $nodeHash{$node}{"InstallAdapterGateway"};
		$gateway ||= $::ATTRS{"Gateway"};
		$gateway ||= $::BOOT_ATTRIBUTES{"Gateway"};
		my $console_device = $nodeHash{$node}{"ConsoleSerialDevice"};
		my $console_speed = $nodeHash{$node}{"ConsoleSerialSpeed"};
		$console_speed ||= '9600';
        # If the ConsoleSerialDevice attribute is set to 'NONE', this is
        # a system that has no console serial device.
        if ($console_device eq 'NONE')
        {
            $console_device = undef;
            $console_device = undef;
        }
        elsif (!$console_device)
        {
            $console_device = "ttyS1";
        }

		#----------------------------------------------------
		# Get warewulf diskless group name from the node's 
		# InstallTemplate attribute.
		# If InstallTemplate is blank, we use 
		# $::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH as 
		# default name. 
		#----------------------------------------------------
		
		my $DisklessNodeGroupName = $nodeHash{$node}{"InstallTemplate"}; 
		$DisklessNodeGroupName = `basename $DisklessNodeGroupName`
				if ($DisklessNodeGroupName ne "");
		 $DisklessNodeGroupName =~ s/^.*warewulf-tmpl\.//g;
		chomp($DisklessNodeGroupName);
		$DisklessNodeGroupName = "$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH"
				if ($DisklessNodeGroupName eq "");
	
		my $vnfs = $DisklessNodeGroupName;
		&substituteWarewulfPxe(
							  $node,         $ip,
							  $netmask,      $gateway,
							  $adapter_name, $svclevel,
							  $is_ip,        $is_dir,
							  $pxefile,      $console_device,
							  $console_speed,$vnfs
							 );

		# Secure new pxefile
		NetworkUtils->secureFilePermissions("$pxefile", "0110", "0440", 1);


	}    #end of for loop

	# generate kickstart file for the RedHat nodes with UUID only.
	# they will be put into each ramdisk of these nodes to avoid sending
	# the DHCP requests.
	&createWarewulfFiles();

}
#--------------------------------------------------------------------------------

=head3    createWarewulfFiles

	Customize warewulf configuration files that are in diskless group template:
	    
		These files are config, disklessnodecfg, includes, excludes and excludes-aggressive.
		These files are used to generate the following warewulf configuration files:
		/etc/warewulf/nodes/<NodeGroupName>/config,
		/etc/warewulf/nodes/<NodeGroupName>/<NodeName>,
		/etc/warewulf/vnfs/includes.<NodeGroupName>, /etc/warewulf/vnfs/excludes.<NodeGroupName>
		and /etc/warewulf/vnfs/excludes-aggressive.<NodeGroupName> files.
		
	Copy and create symbol link for wwinitrd.config, which points to the actual value.  
    
	In default, NodeGroupName is $::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH
        Notes:

=cut

#--------------------------------------------------------------------------------

sub createWarewulfFiles
{
 	foreach my $node (@targetNodes)
	{
		my $svclevel = NodeUtils->getNodeServiceLevel($node);
		
		#----------------------------------------------------
		# Get warewulf diskless group name from the node's 
		# InstallTemplate attribute.
		# If InstallTemplate is blank, we use 
		# $::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH as 
		# default name. 
		#----------------------------------------------------
		
		my $DisklessNodeGroupName = $nodeHash{$node}{"InstallTemplate"}; 
		$DisklessNodeGroupName = `basename $DisklessNodeGroupName`
				if ($DisklessNodeGroupName ne "");
		 $DisklessNodeGroupName =~ s/^.*warewulf-tmpl\.//g;
		chomp($DisklessNodeGroupName);
		$DisklessNodeGroupName = "$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH"
				if ($DisklessNodeGroupName eq "");


		# Set adaptername and ip address of node "Hostname" attribute 
		# for disklessnode administration, sharedfs and cluster interface attributes.
		 
		my $ip;
		#if ($nodeHash{$node}{InstallAdapterHostname})
		#{
	    #	$ip = $nodeHash{$node}{InstallAdapterHostname};
		#}
		#else
		#{
			(undef, $ip) = NetworkUtils->getHost($node);
		#}

        my $nodegrptemplate = $::WAREWULF_TMPL_DIR . "warewulf-tmpl." . 
		                     "$DisklessNodeGroupName/".
							  $::WAREWULF_NODEGRP_CONF_TMPL;
		my $nodegrpfile = $::WAREWULF_DEPLOY_DIR . "nodes/" .
	                     "$DisklessNodeGroupName/".
						  $::WAREWULF_NODEGRP_CONF_TMPL;
		my $nodetemplate = $::WAREWULF_TMPL_DIR . "warewulf-tmpl." .
	                      "$DisklessNodeGroupName/".
   						   $::WAREWULF_NODE_CONF_TMPL;
														  	  
        my $nodefile = $::WAREWULF_DEPLOY_DIR . "nodes/".
		              "$DisklessNodeGroupName/".
					   $nodeHash{$node}{"Hostname"};
														   
		

		my $adapter_name = $nodeHash{$node}{"InstallAdapterName"};
		$adapter_name ||= "eth0";
                my ($node_admin_adapter_name, $node_sharedfs_adapter_name , $node_cluster_adapter_name);
		$node_admin_adapter_name = $node_sharedfs_adapter_name = $node_cluster_adapter_name =
					$adapter_name;
	    
		#--------------------------------------------------------------------------------- 
		# This value specify which vnfs is being used, it is diffent from diskless node 
		# group name, this value is read as the name of vnfsrpm postfix.
		# Here we use defualt value.
		#---------------------------------------------------------------------------------
		my $node_vnfs_dir = "$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH";
		
		my $node_hardwareaddr = $nodeHash{$node}{"InstallAdapterMacaddr"};
		my ($node_admin_ipaddr, $node_sharedfs_ipaddr, $node_cluster_ipaddr);
		$node_admin_ipaddr = $node_sharedfs_ipaddr =  $node_cluster_ipaddr = $ip; 
		# Get gateway attribute as this order : node attribute def, command line, default value
		my $node_gateway_ip = $nodeHash{$node}{"InstallAdapterGateway"};
		$node_gateway_ip ||= $::ATTRS{"Gateway"};
		$node_gateway_ip ||= $::BOOT_ATTRIBUTES{"Gateway"};
		#If the gateway is not in the same subnet with node,
		#do not put it in config file
		my $node_netmask = $nodeHash{$node}{"InstallAdapterNetmask"};
		$node_netmask ||= $::BOOT_ATTRIBUTES{"Netmask"};
		if ($node_gateway_ip)
		{
			if (NetworkUtils->within_same_subnet($ip, $node_netmask, $node_gateway_ip, $node_netmask) == $::NOK)
			{
				$node_gateway_ip = "";
			}
		}

		#print "nodegrptmp=$nodegrptemplate  nodegrp=$nodegrpfile\n";
                #make warewulf nodes group directory
	        mkpath($::WAREWULF_DEPLOY_DIR . "nodes/$DisklessNodeGroupName", $::VERBOSE, 0755);
		&substituteWWNodeGrpConf(
								$node_admin_adapter_name, $node_sharedfs_adapter_name, $node_cluster_adapter_name, 
								$node_vnfs_dir, $svclevel,    
								$nodegrptemplate, $nodegrpfile 			             
							   );
		&substituteWWNodeConf(
								$node_hardwareaddr, $node_admin_ipaddr, $node_sharedfs_ipaddr, $node_cluster_ipaddr, 
								$node_admin_adapter_name , $node_cluster_adapter_name, $node_sharedfs_adapter_name, $node_gateway_ip,
								$nodetemplate, $nodefile	             
							);
        # If the specified disklessnodegroup has been deal with,
        # skip it
        if ($::WWCFG_ALREADY_DEPLOIED{$DisklessNodeGroupName})
		{
				next;
		}
        #copy other template files: includes excludes excludes-aggressive wwinitrd.config 
		my $srcdir = $::WAREWULF_TMPL_DIR . "warewulf-tmpl." .
		                     "$DisklessNodeGroupName/";

		my $cmd;
		#make sure /etc/warewulf/vnfs directory exists
            if (!-d "/etc/warewulf/vnfs")
	    {
		  mkpath("/etc/warewulf/vnfs");
                  NetworkUtils->secureFilePermissions("/etc/warewulf/vnfs", "0110", "0755", 1);
	    }
											
	    foreach my $nodefile ($::WAREWULF_VNFS_INCLUDES_TMPL, $::WAREWULF_VNFS_EXCLUDES_TMPL, 
				              $::WAREWULF_VNFS_EXCLUDES_AGGRESSIVE_TMPL)
		{
				my $srcfile = $srcdir . $nodefile;
				my $destfile = $::WAREWULF_DEPLOY_DIR . "vnfs/".
						$nodefile . "." .
						"$DisklessNodeGroupName";

				NodeUtils->BackupWarewulfFile($destfile);
				#{		
						$cmd = "$::CP -f  $srcfile $destfile";
						NodeUtils->runcmd($cmd, -2);
				#}	
		}
		#----------------------------------------------------------------
		# The wwinitrd.config depends on node's distribution, servicelevel,
		# so we don't name it according to diskless node group name
		#----------------------------------------------------------------

		if (NodeUtils->WhetherToModifyFile($::WAREWULF_DEPLOY_DIR . $::WAREWULF_INITRD_CONF_TMPL . "." .
                                "$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH"))
		{
			$cmd = "$::CP $::WAREWULF_TMPL_DIR$::WAREWULF_INITRD_CONF_TMPL.$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH " . 
	            $::WAREWULF_DEPLOY_DIR . $::WAREWULF_INITRD_CONF_TMPL . "." . 
				"$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH";
			NodeUtils->runcmd($cmd, -2);
		}
	
		if (   (-f $::WAREWULF_DEPLOY_DIR . $::WAREWULF_INITRD_CONF_TMPL) 
			&& (! -l $::WAREWULF_DEPLOY_DIR . $::WAREWULF_INITRD_CONF_TMPL))
		{
			NodeUtils->runcmd("$::MV $::WAREWULF_DEPLOY_DIR$::WAREWULF_INITRD_CONF_TMPL ".
                              "$::WAREWULF_DEPLOY_DIR$::WAREWULF_INITRD_CONF_TMPL.precsm",-2);
		}
		#Create symbol link wwinitrd.config to the specific config file
		unlink $::WAREWULF_DEPLOY_DIR . $::WAREWULF_INITRD_CONF_TMPL;
		symlink $::WAREWULF_DEPLOY_DIR . $::WAREWULF_INITRD_CONF_TMPL . "." 
				. "$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH",
		        $::WAREWULF_DEPLOY_DIR . $::WAREWULF_INITRD_CONF_TMPL;
        # Secure
		#NetworkUtils->secureFilePermissions("$", "0110", "0440", 1);

        # Set flag after deploy the warewulf configuation files.
        $::WWCFG_ALREADY_DEPLOIED{$DisklessNodeGroupName} = 1;


	}    #end of for loop 
	#SSH has deployed host keys in ServerUtils->setupVNFS for VNFS. 
	#Update the management servers known_hosts file with the host keys from the target nodes.
	NetworkUtils->update_known_hosts(\@targetNodes); 

    # Clean up flag global variable
    undef %::WWCFG_ALREADY_DEPLOIED;

}
sub setupWarewulf
{
  my ($hostname, $alias, $admin_adapter_name, $sharedfs_adapter_name, $cluster_adapter_name, $boot_adapter_name);
  my ($remoteshell, $vnfs_dir);
  #master.conf 
  my ($mastertemplate, $masterfile);
  #client.conf
  my ($clienttemplate, $clientfile);
  if ($bootMethod eq "warewulf")
  {
    #print "Start setup warewulf configuration...\n";
	#MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
	#		                                     'csminstall', 'I', 'IMsgcsmsetupinstallwwcnf');
																			  
	my $node = $targetNodes[0];
  	my $svclevel = NodeUtils->getNodeServiceLevel($node);
  	#ISHostName: This value will be first extracted from node's InstallServerAKBNode attribute.
  	#If the InstallServerAKBNode is not set, this value will be extracted from InstallServer attribute.
  	#If InstallServer is not set, this value will be extracted from ManagementServer attribute, making 
  	#the assumption that CSM management server is also an install server.
  	my $host_ip;
  	if ($nodeHash{$node}{InstallServerAKBNode})
  	{
			  $host_ip = $nodeHash{$node}{InstallServerAKBNode};
  	}
  	elsif ($nodeHash{$node}{InstallServer})
  	{
			  $host_ip = $nodeHash{$node}{InstallServer};
                          $host_ip =~ s/:\/.*$//g;
  	}
  	else
  	{
			  $host_ip = $nodeHash{$node}{ManagementServer};
  	}

        ($hostname, $host_ip) =  NetworkUtils->getHost($host_ip); 	
        $alias = $hostname;
  	# $admin_adapter_name, $sharedfs_adpter_name and $cluster_adpater_name: The csmsetupinstall command queries 
  	# adapter info(ifconfig) for InstallServerAKBNode, InstallServer or ManagementServer attributes, to find
  	# the adapter name.
  	$admin_adapter_name = $sharedfs_adapter_name = $cluster_adapter_name = $boot_adapter_name   
    	                  = &getNetwork($host_ip);  
  	$remoteshell = NetworkUtils->getRemoteShell();#$nodeHash{$node}{'RemoteShell'};
  	 
  	$vnfs_dir = $ENV{CSMINSTALL_ROOT} . "/diskless/vnfs"; 
  
  	$mastertemplate = $::WAREWULF_TMPL_DIR . $::WAREWULF_MASTER_CONF_TMPL;
  	$masterfile     = $::WAREWULF_DEPLOY_DIR . $::WAREWULF_MASTER_CONF_TMPL;

  	$clienttemplate = $::WAREWULF_TMPL_DIR . $::WAREWULF_CLIENT_CONF_TMPL;
  	$clientfile     = $::WAREWULF_DEPLOY_DIR . $::WAREWULF_CLIENT_CONF_TMPL;
 	&substituteWWClientConf(
			  $hostname,
			  $clienttemplate, $clientfile,
  	);
  	my $if_cfg;
    #Make sure ip addr item have no single quotes in system adapter config file.
    #For RHEL, /etc/sysconfig/network-scripts/ifcfg-eth*
    #For SLES, /etc/sysconfig/network/ifcfg-eth*
    #Because warewulf wwinit command can't identify it.
    #eg: IPADDR='172.20.3.2' should be change to IPADDR=172.20.3.2
    if (-d "/etc/sysconfig/network-scripts")
    { 
    	NodeUtils->runcmd("sed -i \"s/'//g\" /etc/sysconfig/network-scripts/ifcfg-eth*",-2);
        $if_cfg = "/etc/sysconfig/network-scripts/ifcfg-";
    }
    else
    {
		NodeUtils->runcmd("sed -i \"s/'//g\" /etc/sysconfig/network/ifcfg-eth*",-2);
        $if_cfg = "/etc/sysconfig/network/ifcfg-";
		my $dir = Cwd::getcwd();
		chdir "/etc/sysconfig/network";
		my @ifcfglist = `$::LS ifcfg-eth-id-*`;
		foreach my $ifcfg_item (@ifcfglist)
		{
			chomp($ifcfg_item);
			#print "tt=".length($ifcfg_item)."\n";
			if ($ifcfg_item =~ /eth-id-.{17}$/)
			{
				my $ifcfg_adapter_name = `getcfg-interface $&`;
                chomp($ifcfg_adapter_name);
				#print "$adapter_name\n";
				NodeUtils->runcmd("$::LN -sf $ifcfg_item ifcfg-$ifcfg_adapter_name");
			}
		}
		chdir $dir;
		
    };
  	&substituteWWMasterConf(
			  $hostname,   $alias,
			  $admin_adapter_name, $sharedfs_adapter_name, $cluster_adapter_name, $boot_adapter_name,
			  $remoteshell,    $vnfs_dir, $host_ip, $if_cfg,
			  $mastertemplate, $masterfile,
  			);

	 my $distro = NodeUtils->distribution();
     #  On SLES, need to hardcode /etc/init.d/vnfsd and /etc/init.d/warewulf boot scripts.
     if ($distro =~ /SLES/ )
	 {
		 # Change nfs service from /etc/init.d/nfs to /etc/init.d/nfsserver on SLES
		 NodeUtils->runcmd("sed -i \"s/\\\/etc\\\/init.d\\\/nfs\\\s\\\+/\\\/etc\\\/init.d\\\/nfsserver\\\  /g\" $masterfile",-2);

	 #Hardcode /etc/init.d/vnfsd 
		 open(FILE, ">/etc/init.d/vnfsd")
                                || MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
  			                                                    'csminstall', 'E1',
  			                                                    'EMsgCANT_CREATE', "/etc/init.d/vnfsd"
  			                                                   );
         print FILE "#!/bin/bash
#
# chkconfig: 345 95 05
# description: Warewulf Virtual Node File System Daemon (VNFSD)
# processname: vnfsd
# pidfile: /var/run/vnfsd.pid
### BEGIN INIT INFO
# Provides: vnfsd
# Required-Start: network
# Required-Stop: network
# Default-Start: 2 3 5
# Default-Stop:
# Description: Start the vnfsd daemon
### END INIT INFO 
###CSMHARDCODE###
VNFSD=/usr/sbin/vnfsd

if [ -r /etc/rc.config ]
then
	. /etc/rc.config
fi

test -x \$VNFSD || exit 5

# shell functions from /etc/rc.status
. /etc/rc.status

# reset status of the service
rc_reset

case \"\$1\" in
    start)
      	echo -n \"Starting vnfsd: \"
      	if [ -f /var/run/vnfsd.pid ]; then
         	checkproc \$VNFSD
		rc_status -v
      	else
         	startproc \$VNFSD -p 9874 -u nobody -i /var/run/vnfsd.pid -d /srv/vnfs </dev/null
		rc_status -v
            	touch /var/lock/subsys/vnfsd
      	fi
	;;

    stop)
      	echo -n \"Shutting down vnfsd: \"
      	killproc \$VNFSD
	rc_status -v
   	test -f /var/lock/subsys/vnfsd && rm -f /var/lock/subsys/vnfsd
   	test -f /var/run/vnfsd.pid && rm -f /var/run/vnfsd.pid
	;;

    stats|status)
      	echo -n \"Checking for vnfsd: \"
      	checkproc \$VNFSD
	rc_status -v
	;;
    reload|reset|restart)
	\$0 stop
	\$0 start
	;;
    *)
   	echo \$\"Usage: \$0 {start|stop|restart|status|reload|reset|restart}\"
   	exit 1
esac
rc_exit
  ";
          close FILE;
		 #Hardcode /etc/init.d/warewulf 
		 open(FILE, ">/etc/init.d/warewulf")
                                || MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
  			                                                    'csminstall', 'E1',
  			                                                    'EMsgCANT_CREATE', "/etc/init.d/warewulf"
  			                                                   );
         print FILE "#!/bin/bash
#
# chkconfig: 345 95 05
# description: WAREWULFD watches the status of the slave nodes on the cluster
#              and keeps them configured properly and available to cluster
#              users.
# processname: warewulfd
# pidfile: /var/run/warewulfd.pid
### BEGIN INIT INFO
# Provides: warewulf
# Required-Start: network
# Required-Stop: network
# Default-Start: 2 3 5
# Default-Stop:
# Description: Start the warewulfd daemon
### END INIT INFO
###CSMHARDCODE###
WAREWULFD=/usr/sbin/warewulfd


# Source SuSE config
if [ -r /etc/rc.config ]
then
	. /etc/rc.config
fi

test -x \$WAREWULFD || exit 5

# shell functions from /etc/rc.status
. /etc/rc.status

# reset status of the service
rc_reset


case \"\$1\" in
    start)
      	echo -n \"Starting warewulfd: \"
	if [ -f /var/run/warewulfd.pid ]
	then
		checkproc \$WAREWULFD
		rc_status -v
	else
      		startproc \$WAREWULFD
      		rc_status -v
      		touch /var/lock/subsys/warewulfd
      		echo READY > /tmp/nodestatus
	fi
	;;

    stop) 
      	echo -n \$\"Shutting down warewulfd: \"
      	killproc \$WAREWULFD
      	RETVAL=\$?
	rc_status -v
   	test -f /var/lock/subsys/warewulfd && rm -f /var/lock/subsys/warewulfd
   	test -f /var/run/warewulfd.pid && rm -f /var/run/warewulfd.pid
	;;

    stats|status)
	echo -n \"Checking for warewulfd: \"
      	checkproc \$WAREWULFD
      	rc_status -v
	;;
    reload|reset|restart)
	\$0 stop
	\$0 start
	;;
    *)
	echo \"Usage: \$0 {start|stop|stats|status|reload|restart}\"
	exit 1
	;;
esac
rc_exit  ";
          close FILE;
          #Set the permissions 
		  chmod 0755, "/etc/init.d/vnfsd";
          chmod 0755, "/etc/init.d/warewulf";	
          #Enabe vnfsd and wareuwlf system services
		  NodeUtils->runcmd("/sbin/chkconfig warewulf on", -2);
          NodeUtils->runcmd("/sbin/chkconfig vnfsd    on", -2);	
	}	
    ##########################################
    # Export VNFS directory for disklessnodes
    ##########################################
    NodesetUtils->export_vnfs(); 

  }
}

# get the adapter name of warewulf master machine 
sub getNetwork
{
		my $ip = shift;
		my ($adapterip, $network);
        $::CSM = 1;
		if ($::CSM)
		{
				$adapterip = $ip;
				chomp($adapterip);

				if ($::PLTFRM eq "AIX")
				{
						my @output = NodeUtils->runcmd("$::IFCONFIG -lu", -1);
						my @ifs = split(' ', $output[0]);
						foreach my $if (@ifs)
						{
								next if ($if =~ /lo/);
								my @output =
								NodeUtils->runcmd("$::IFCONFIG $if | $::GREP 'inet '", -1);
								foreach my $line (@output)
								{
										my @tabs = split(' ', $line);
										if ($tabs[1] eq $adapterip)
										{
												$network = $if;
												goto FOUND_NETWORK;
										}
								}
						}
				}
				else
				{

						# for Linux
						$network =
						`$::IP addr | $::GREP 'inet ' | $::GREP $adapterip | $::AWK  '{print \$7}'`;
						#print "result is $::IP addr | $::GREP 'inet ' | $::GREP $adapterip | $::AWK  '{print \$7}'\n";
				}

				FOUND_NETWORK:
				chomp($network);
				if (!$network)
				{
						MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,     
			     					'csminstall', 'E1', 'EMsgFailGetApaterName', $ip);
				}

		}
		else
		{
				chomp($network =
						`$::NETSTAT -rn | $::EGREP "^$ip\\b" | $::HEAD -n 1 | $::AWK '{print \$8}'`
				);
				if (!$network)
				{

						# the subnet to be added is not listed in kernel routing table. should
						# add it anyway, and add to default eth0 network.
						$network = "eth0";
				}
		}
		return $network;
}
sub setupPxe
{
		if ($bootMethod eq 'getmacs' || $bootMethod eq 'getmacssnmp')
		{
				&setupGetmacsPxe;
		}
		elsif ($bootMethod eq 'kickstart' or $bootMethod eq 'kickstart-upgrade')
		{
				&setupKickstartPxe;
		}
		elsif ($bootMethod eq 'autoyast')
		{
				&setupAutoyastPxe;
		}
		elsif ($bootMethod eq 'sis')
		{
				&setupSISPxe;
		}    # end of if (sis)
		elsif ($bootMethod eq 'hwmaint')
		{
				&setupHwmaintPxe;
		}
		elsif ($bootMethod eq 'warewulf')
		{
				&setupWarewulfPxe;
	}
	elsif (($bootMethod eq 'disk') 
		|| ($bootMethod eq 'getmacsdisk') 
		|| ($bootMethod eq 'you'))
	{
		&setupDiskPxe;
	}
}

# Create an installation (kickstart or autoyast) configuration file for each node.
sub createInstallConfigFiles
{
	if ($bootMethod eq "kickstart" or $bootMethod eq "kickstart-upgrade")
	{
		&createKickstartFiles();
	}
	elsif ($bootMethod eq "autoyast")
	{
		&createAutoyastFiles();
	}
    elsif ($bootMethod eq "warewulf")
	{
		&createWarewulfFiles();
	}
	elsif ($bootMethod eq "getmacssnmp")
	{
		# clean up the kickstart/autoyast config files
		# to avoid node being installed.
		&cleanupInstallConfigFiles();
	}	
}

sub cleanupInstallConfigFiles
{
	my $type;
	my @nodeList = @targetNodes;

    foreach my $node (@nodeList)
    {
        my $distro_name = $nodeHash{$node}{'InstallDistributionName'};

		if($distro_name =~ /SLES/)
		{
			$type = "AutoYast";
		}
		else
		{
			$type = "KickStart";
		}
        my ($instFile, $real_file, $link_file, $hostlink_file, $hex_link) =
          &getInstallFile($node, $type);
        if($instFile) 
		{
			unlink($link_file);
			unlink($hostlink_file);
			unlink($hex_link);
			unlink($instFile);
		}
	}	

}

=item createKickstartFiles
    
    createKickstartFiles is a shell for createInstallFiles.  

=cut

sub createKickstartFiles
{
	&createInstallFiles("KickStart");
}

=item createInstallFiles

    gets appropriate install template, fills in the template
    stanza and puts it to disk.  This is called by RH & SLES install
    methods.

=cut

sub createInstallFiles
{
	my $type     = shift;          # Which install method are we doing?
	my $tmpl     = "";
	my @nodeList = @targetNodes;

	# Create a file for each node
	foreach my $node (@nodeList)
	{
		my $tmplAttr = $nodeHash{$node}{'InstallTemplate'};

		# The template name:
		$tmpl = "$::TEMPLATES_DIR/tmpl/$node.cfg";
		my ($instFile, $real_file, $link_file, $hostlink_file, $hex_link) =
		  &getInstallFile($node, $type);
		unless ($instFile) { print "Could not get an installation file\n"; }

		# set global variables that will be passed to the
		# install files
		&getVariables($node, $type);
        my ($ref_additional_mods, $ref_explicit_additional_mods) = 
                    NodesetUtils->getAutoyastModules(
                        $nodeHash{$node}{'InstallDistributionName'},
                        $nodeHash{$node}{'InstallDistributionVersion'},
                        $nodeHash{$node}{'InstallServiceLevel'},
                        $nodeHash{$node}{'HWType'},
                        $nodeHash{$node}{'HWModel'});

		if ($tmplAttr =~ /DC.xml/)
		{
			&setVariableForInterOP($instFile, $ref_additional_mods);
		}

		# open the Install file and put the whole mess together
		open(INSTFILE, ">$instFile")
		  || MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
						  'csminstall', 'E2', 'EMsgCANT_WRITE_FILE', $instFile);

        my $hwmaint_sleep     = 0;
        my $insert_net_device = 0;
        my $set_stty          = 0;

        if (   ($bootMethod eq 'hwmaint')
            && (!$nodeHash{$node}{InstallAdapterMacaddr})
            && ($nodeHash{$node}{UUID}))
        {

            # add a sleep for hwmaint to avoid installing the node.
            $hwmaint_sleep = 1;
        }
        if (   (!$nodeHash{$node}{InstallAdapterMacaddr})
            && ($nodeHash{$node}{UUID})
            && ($nodeHash{$node}{InstallAdapterName}))
        {

            # for UUID installation, add adapter name into kickstart config file,
            # otherwise kickstart has no way to figure out which adapter is being
            # used for installation, 'cause UUID install doesn't obtain IP through DHCP.
            $insert_net_device = 1;
        }
        if ($nodeHash{$node}{'HWType'} eq $::HS20_8843)
        {
            $set_stty = 1;
        }

        foreach (&subvars($tmpl))
        {
            if (/^network/)
            {
                if ($insert_net_device)
                {
                    s/static/static --device=$nodeHash{$node}{InstallAdapterName}/;
                }
            }

            print INSTFILE;

            if (/\%pre/)
            {
                if ($hwmaint_sleep)
                {
                    print INSTFILE "sleep 36000\n";
                }
                if ($set_stty)
                {
                    print INSTFILE "stty crtscts\n";
                }
            }
        }

		close(INSTFILE);
		my $nameIsIP;
		if ($nodeHash{$node}{'InstallAdapterHostname'})
		{
			$nameIsIP =
			  NetworkUtils->isIpaddr(
									$nodeHash{$node}{'InstallAdapterHostname'});
		}
		else
		{
			$nameIsIP = NetworkUtils->isIpaddr($node);
		}
		if ($type eq "AutoYast" && $tmplAttr !~ /DC.xml/)
		{
			&parseAutoYast(
						   $instFile,  $real_file,
						   $link_file, $hostlink_file,
						   $hex_link,  $nameIsIP,
						   $node,      $ref_additional_mods, 
						   $ref_explicit_additional_mods
						  );
		}
		elsif ($type eq "KickStart" || $tmplAttr =~ /DC.xml/)
		{
			unlink $link_file;
			symlink $real_file, $link_file;
			unlink($hex_link);
            symlink $real_file, $hex_link;
			if (!$nameIsIP)
			{
				unlink $hostlink_file;
				symlink $real_file, $hostlink_file;
			}
		}
	}
}

sub createAutoyastFiles
{
	&createInstallFiles("AutoYast");
}

sub setVariableForInterOP
{
	my $tmpl               = shift;
	my $additional_mod_ref = shift;

	if (($::GATEWAY ne "") && ($::GATEWAY ne "0.0.0.0"))
	{

		#set env varible ROUTING
		$ENV{'ROUTING'} = <<string;

      <routing>
        <routes config:type="list">
          <route>
            <destination>default</destination>
            <device>-</device>
            <gateway>$::GATEWAY</gateway>
            <netmask>-</netmask>
          </route>
        </routes>
      </routing>
string
	}
	else
	{
		$ENV{'ROUTING'} = "\n     ";
	}

	$ENV{'INSTALLPROTOCAL'} = NodesetUtils->get_NetworkInstallProtocol();
	$ENV{'PROFILELOCATION'} = $tmpl;

	# Edit the prescript file and add it as a CDATA node if it exits
	my $prescriptsource = "$::TEMPLATESCRIPTS/pre.$::DISTRO_NAME";
	my @prefile         = ("$::DISTRO_VERSION", "$::ARCH");

	# get the most specific file we can, but generalize if that's the
	# only thing we can find.
	while (@prefile)
	{
		my $f = "$prescriptsource-" . join('-', @prefile);
		if (-f "$f")
		{
			$prescriptsource = $f;
			last;
		}
		else
		{
			pop @prefile;
		}
	}

	# now make sure we can read it.
	if (-r $prescriptsource)
	{
		$ENV{'PRESOURCE'} = &subvars($prescriptsource);
	}

	#
	# Edit the chrootscript file and add it as a CDATA node
	#
	my $chrootsourcefile = "$::TEMPLATESCRIPTS/chroot." . $::DISTRO_NAME;
	if ($::ARCH eq "ppc64")
	{
		$chrootsourcefile .= ".ppc64";
	}
	if (-r $chrootsourcefile)
	{
		$ENV{'CHROOTSOURCE'} = &subvars($chrootsourcefile);
	}
	else
	{

		MessageUtils->messageFromCat(
									 'csmInstall.cat',     $::MSGMAPPATH,
									 'csminstall',         'E2',
									 'EMsgCANT_READ_FILE', $chrootsourcefile
									);
	}

	#
	# Edit the postscript file and add it as a CDATA node
	#
	my $postsourcefile = "$::TEMPLATESCRIPTS/post." . $::DISTRO_NAME;

	if (-r $postsourcefile)
	{
		$ENV{'POSTSOURCE'} = &subvars($postsourcefile);
	}
	else
	{

		MessageUtils->messageFromCat(
									 'csmInstall.cat',     $::MSGMAPPATH,
									 'csminstall',         'E2',
									 'EMsgCANT_READ_FILE', $postsourcefile
									);
	}
}

sub parseAutoYast
{
	my $tmpl                        = shift;
	my $yastfile_real               = shift;
	my $yastfile_link               = shift;
	my $yastfile_hostlink           = shift;
	my $hexfile_link                = shift;
	my $nameIsIP                    = shift;
	my $target_node                 = shift;
	my $additional_mod_ref          = shift;
	my $explicit_additional_mod_ref = shift;
	my $kernel_parameters           = shift;

	if ($^O eq "linux")
	{

		# Validate the format of this template file.
		my $XMLWF = "/usr/bin/xmlwf";
		if (-x "$XMLWF")
		{
			my $cmd = "$XMLWF $tmpl";
			my @output = NodeUtils->runcmd("$cmd", -1);
			if (@output)
			{

				MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
								 'csminstall', 'E2', 'EMsgBAD_FORMAT_YAST_TMPL',
								 $target_node);
			}
		}

		# Dynamically load XML::DOM when it was really required
		require XML::DOM;
	}

	my $xmlparser = new XML::DOM::Parser(KeepCDATA => 1);
	my $xmldoc    = $xmlparser->parsefile($tmpl);
	my $xmlroot   = $xmldoc->getDocumentElement();
	my $xmlnodelist;

	my ($offset,        $xmlnode);
	my ($configurenode, $installnode);
	my ($scripts,       $post, $chroot, $scriptsnode, $chrootnode, $postnode);

	#VJB for pre installscript.
	my $pre = 0;
	my $prenode;

	#ENDVJB

	$post    = 0;
	$chroot  = 0;
	$scripts = 0;
	my (
		$modenode,          $initnode,            $partitioningnode,
		$usersnode,         $networkingnode,      $clocknode,
		$generalnode,       $reportnode,          $bootloadernode,
		$initrdmodulesnode, $modulenode,          $sysconfignode,
		$sysconfig_keynode, $sysconfig_valuenode, $sysconfig_pathnode,
		$sysconfig_entrynode
	   );
	my (
		$ex_mode,          $ex_init,       $ex_partitioning,
		$ex_users,         $ex_networking, $ex_clock,
		$ex_general,       $ex_report,     $ex_bootloader,
		$ex_initrdmodules, $ex_sysconfig
	   );
	$ex_mode          = 0;
	$ex_init          = 0;
	$ex_partitioning  = 0;
	$ex_users         = 0;
	$ex_networking    = 0;
	$ex_report        = 0;
	$ex_bootloader    = 0;
	$ex_initrdmodules = 0;
	$ex_sysconfig     = 0;

	$xmlnodelist = $xmlroot->getElementsByTagName("configure");

	if ($xmlnodelist->getLength() != 1)
	{
		MessageUtils->messageFromCat(
									 'csmInstall.cat',        $::MSGMAPPATH,
									 'csminstall',            'E2',
									 'EMsgPARSING_YAST_FILE', $tmpl
									);
	}

	$configurenode = $xmlnodelist->item(0);

	$xmlnode = $configurenode->getPreviousSibling;
	if ((defined $xmlnode) && ($xmlnode->getNodeType == 3))
	{
		$offset = $xmlnode->getNodeValue;
	}
	else
	{
		$offset = "\n";
	}

	foreach $xmlnode ($configurenode->getChildNodes)
	{
		if (($xmlnode->getNodeType == 1))
		{
			if ($xmlnode->getNodeName eq "scripts")
			{
				$scriptsnode = $xmlnode;
				$scripts     = 1;
			}
			if ($xmlnode->getNodeName eq "users")
			{
				$usersnode = $xmlnode;
				$ex_users  = 1;
			}
			if ($xmlnode->getNodeName eq "networking")
			{
				$networkingnode = $xmlnode;
				$ex_networking  = 1;
			}
		}
	}

	# parse through and add scripts if there are none.
	if ($scripts == 0)
	{
		$configurenode->insertBefore($xmldoc->createTextNode("$offset "),
									 $configurenode->getLastChild);
		$scriptsnode = $xmldoc->createElement("scripts");
		$scriptsnode->appendChild($xmldoc->createTextNode("$offset "));
		$configurenode->insertBefore($scriptsnode,
									 $configurenode->getLastChild);
	}
	if ($ex_users == 0)
	{
		$configurenode->insertBefore($xmldoc->createTextNode("$offset "),
									 $configurenode->getLastChild);
		$usersnode = $xmldoc->createElement("users");
		$usersnode->appendChild($xmldoc->createTextNode("$offset "));
		$usersnode->setAttribute("config:type", "list");
		$configurenode->insertBefore($usersnode, $configurenode->getLastChild);
	}
	if ($ex_networking == 0)
	{
		$configurenode->insertBefore($xmldoc->createTextNode("$offset "),
									 $configurenode->getLastChild);
		$networkingnode = $xmldoc->createElement("networking");
		$networkingnode->appendChild($xmldoc->createTextNode("$offset "));
		$configurenode->insertBefore($networkingnode,
									 $configurenode->getLastChild);
	}

	$xmlnodelist = $xmlroot->getElementsByTagName("install");

	if ($xmlnodelist->getLength() != 1)
	{
		MessageUtils->messageFromCat(
									 'csmInstall.cat',        $::MSGMAPPATH,
									 'csminstall',            'E2',
									 'EMsgPARSING_YAST_FILE', $tmpl
									);
		exit(1);
	}
	$installnode = $xmlnodelist->item(0);

	$xmlnode = $installnode->getPreviousSibling;
	if ((defined $xmlnode) && ($xmlnode->getNodeType == 3))
	{
		$offset = $xmlnode->getNodeValue;
	}
	else
	{
		$offset = "\n";
	}

	foreach $xmlnode ($installnode->getChildNodes)
	{
		if (($xmlnode->getNodeType == 1))
		{
			if ($xmlnode->getNodeName eq "init")
			{
				$initnode = $xmlnode;
				$ex_init  = 1;
			}
			if ($xmlnode->getNodeName eq "general")
			{
				$generalnode = $xmlnode;
				$ex_general  = 1;
			}
			if ($xmlnode->getNodeName eq "partitioning")
			{
				$partitioningnode = $xmlnode;
				$ex_partitioning  = 1;
			}
			if ($xmlnode->getNodeName eq "report")
			{
				$reportnode = $xmlnode;
				$ex_report  = 1;
			}
			if ($xmlnode->getNodeName eq "bootloader")
			{
				$bootloadernode = $xmlnode;
				$ex_bootloader  = 1;
			}
		}
	}

	if ($ex_init == 0)
	{
		$installnode->insertBefore($xmldoc->createTextNode("$offset "),
								   $installnode->getLastChild);
		$initnode = $xmldoc->createElement("init");
		$initnode->appendChild($xmldoc->createTextNode("$offset "));
		$installnode->insertBefore($initnode, $installnode->getLastChild);
	}
	if ($ex_report == 0)
	{
		$installnode->insertBefore($xmldoc->createTextNode("$offset "),
								   $installnode->getLastChild);
		$reportnode = $xmldoc->createElement("report");
		$reportnode->appendChild($xmldoc->createTextNode("$offset "));
		$installnode->insertBefore($reportnode, $installnode->getLastChild);
	}
	if ($ex_general == 0)
	{
		$installnode->insertBefore($xmldoc->createTextNode("$offset "),
								   $installnode->getLastChild);
		$generalnode = $xmldoc->createElement("general");
		$generalnode->appendChild($xmldoc->createTextNode("$offset "));
		$installnode->insertBefore($generalnode, $installnode->getLastChild);
	}
	if ($ex_partitioning == 0)
	{
		$installnode->insertBefore($xmldoc->createTextNode("$offset "),
								   $installnode->getLastChild);
		$partitioningnode = $xmldoc->createElement("partitioning");
		$partitioningnode->setAttribute("config:type", "list");
		$partitioningnode->appendChild($xmldoc->createTextNode("$offset "));
		$installnode->insertBefore($partitioningnode,
								   $installnode->getLastChild);
	}
	if ($ex_bootloader == 0)
	{
		$installnode->insertBefore($xmldoc->createTextNode("$offset "),
								   $installnode->getLastChild);
		$bootloadernode = $xmldoc->createElement("bootloader");
		# before porting sles10, there is no bootloader in the
		# autoyast configure file if bootloader doesn't appear
		# in the templ file.
		#$installnode->insertBefore($initnode, $installnode->getLastChild);
		#$installnode->insertBefore($bootloadernode, $installnode->getLastChild);
	}

	$xmlnode = $generalnode->getPreviousSibling;
	if ((defined $xmlnode) && ($xmlnode->getNodeType == 3))
	{
		$offset = $xmlnode->getNodeValue;
	}
	else
	{
		$offset = "\n";
	}

	foreach $xmlnode ($generalnode->getChildNodes)
	{
		if (($xmlnode->getNodeType == 1))
		{
			if ($xmlnode->getNodeName eq "mode")
			{
				$modenode = $xmlnode;
				$ex_mode  = 1;
			}
			if ($xmlnode->getNodeName eq "clock")
			{
				$clocknode = $xmlnode;
				$ex_clock  = 1;
			}
		}
	}

	if ($ex_mode == 0)
	{
		$generalnode->insertBefore($xmldoc->createTextNode("$offset "),
								   $generalnode->getLastChild);
		$modenode = $xmldoc->createElement("mode");
		$modenode->appendChild($xmldoc->createTextNode("$offset "));
		$generalnode->insertBefore($modenode, $generalnode->getLastChild);
	}
	if ($ex_clock == 0)
	{
		$generalnode->insertBefore($xmldoc->createTextNode("$offset "),
								   $generalnode->getLastChild);
		$clocknode = $xmldoc->createElement("clock");
		$clocknode->appendChild($xmldoc->createTextNode("$offset "));
		$generalnode->insertBefore($clocknode, $generalnode->getLastChild);
	}

	#users
	my $ex_root = 0;
	foreach $xmlnode ($usersnode->getElementsByTagName("username"))
	{
		foreach my $kid ($xmlnode->getChildNodes)
		{
			if (($kid->getNodeType == 3) && ($kid->getNodeValue eq "root"))
			{
				$ex_root = 1;
				last;
			}
		}
		if ($ex_root) { last; }
	}

	if ($ex_root == 0)
	{
		my ($usernode, $encryptednode, $user_passwordnode, $usernamenode);
		$xmlnode = $usersnode->getPreviousSibling;
		if ((defined $xmlnode) && ($xmlnode->getNodeType == 3))
		{
			$offset = $xmlnode->getNodeValue;
		}
		else
		{
			$offset = "\n";
		}
		$usersnode->insertBefore($xmldoc->createTextNode("$offset "),
								 $usersnode->getLastChild);
		$usernode = $xmldoc->createElement("user");
		$usernode->appendChild($xmldoc->createTextNode("$offset "));
		$usersnode->insertBefore($usernode, $usersnode->getLastChild);

		$usernode->insertBefore($xmldoc->createTextNode("$offset  "),
								$usernode->getLastChild);
		$encryptednode = $xmldoc->createElement("encrypted");
		$encryptednode->setAttribute("config:type", "boolean");
		$encryptednode->appendChild($xmldoc->createTextNode("true "));
		$usernode->insertBefore($encryptednode, $usernode->getLastChild);

		$usernode->insertBefore($xmldoc->createTextNode("$offset  "),
								$usernode->getLastChild);
		$user_passwordnode = $xmldoc->createElement("user_password");
		$user_passwordnode->appendChild(
									  $xmldoc->createTextNode("95G9p0q.CBtl."));
		$usernode->insertBefore($user_passwordnode, $usernode->getLastChild);

		$usernode->insertBefore($xmldoc->createTextNode("$offset  "),
								$usernode->getLastChild);
		$usernamenode = $xmldoc->createElement("username");
		$usernamenode->appendChild($xmldoc->createTextNode("root"));
		$usernode->insertBefore($usernamenode, $usernode->getLastChild);

	}

	#partitioning stanza
	my $ex_drive = 0;
	$xmlnode = $partitioningnode->getPreviousSibling;
	if ((defined $xmlnode) && ($xmlnode->getNodeType == 3))
	{
		$offset = $xmlnode->getNodeValue;
	}
	else
	{
		$offset = "\n";
	}
	foreach $xmlnode ($partitioningnode->getChildNodes)
	{
		if (($xmlnode->getNodeType == 1))
		{
			if ($xmlnode->getNodeName eq "drive")
			{
				$ex_drive = 1;
			}
		}
	}
	if ($ex_drive == 0)
	{
		my ($drivenode, $usenode, $devicenode);
		$partitioningnode->insertBefore($xmldoc->createTextNode("$offset "),
										$partitioningnode->getLastChild);
		$drivenode = $xmldoc->createElement("drive");
		$drivenode->appendChild($xmldoc->createTextNode("$offset "));
		$partitioningnode->insertBefore($drivenode,
										$partitioningnode->getLastChild);

		$drivenode->insertBefore($xmldoc->createTextNode("$offset  "),
								 $drivenode->getLastChild);
		$devicenode = $xmldoc->createElement("device");
		$devicenode->appendChild($xmldoc->createTextNode("$::BOOTDISK"));
		$drivenode->insertBefore($devicenode, $drivenode->getLastChild);

		$drivenode->insertBefore($xmldoc->createTextNode("$offset  "),
								 $drivenode->getLastChild);
		$usenode = $xmldoc->createElement("use");
		$usenode->appendChild($xmldoc->createTextNode("all"));
		$drivenode->insertBefore($usenode, $drivenode->getLastChild);

	}

	#bootloader stanza
	if ($::ARCH eq "ppc64")
	{
		foreach $xmlnode ($bootloadernode->getChildNodes)
		{
			$bootloadernode->removeChild($xmlnode);
		}

		$xmlnode = $bootloadernode->getPreviousSibling;
		if ((defined $xmlnode) && ($xmlnode->getNodeType == 3))
		{
			$offset = $xmlnode->getNodeValue;
		}
		else
		{
			$offset = "\n";
		}

		$bootloadernode->appendChild($xmldoc->createTextNode("$offset"));

		my ($activatenode, $locationnode, $lba_supportnode, $linearnode);

		$activatenode = $xmldoc->createElement("activate");
		$bootloadernode->insertBefore($xmldoc->createTextNode("$offset "),
									  $bootloadernode->getLastChild);
		$bootloadernode->insertBefore($activatenode,
									  $bootloadernode->getLastChild);
		$activatenode->setAttribute("config:type", "boolean");
		$activatenode->appendChild($xmldoc->createTextNode("true"));

		$bootloadernode->insertBefore($xmldoc->createTextNode("$offset "),
									  $bootloadernode->getLastChild);
		$locationnode = $xmldoc->createElement("location");
		$locationnode->appendChild(
							$xmldoc->createTextNode("$::BOOTDISK" . "1")); #????
		$bootloadernode->insertBefore($locationnode,
									  $bootloadernode->getLastChild);

		$lba_supportnode = $xmldoc->createElement("lba_support");
		$bootloadernode->insertBefore($xmldoc->createTextNode("$offset "),
									  $bootloadernode->getLastChild);
		$bootloadernode->insertBefore($lba_supportnode,
									  $bootloadernode->getLastChild);
		$lba_supportnode->setAttribute("config:type", "boolean");
		$lba_supportnode->appendChild($xmldoc->createTextNode("false"));

		$linearnode = $xmldoc->createElement("linear");
		$bootloadernode->insertBefore($xmldoc->createTextNode("$offset "),
									  $bootloadernode->getLastChild);
		$bootloadernode->insertBefore($linearnode,
									  $bootloadernode->getLastChild);
		$linearnode->setAttribute("config:type", "boolean");
		$linearnode->appendChild($xmldoc->createTextNode("false"));
	}

	#insert any additional kernel parameters
	if ($kernel_parameters)
	{
		my $ex_kernelparams = 0;
		my $kernelparamnode;

		foreach $xmlnode ($bootloadernode->getChildNodes)
		{
			if ($xmlnode->getNodeType == 1) # 1=ELEMENT_NODE
			{
				if ($xmlnode->getNodeName eq "kernel_parameters")
				{
					$kernelparamnode = $xmlnode;
					$ex_kernelparams  = 1;
				}
			}
		}
		$xmlnode = $bootloadernode->getPreviousSibling;
		if ((defined $xmlnode) && ($xmlnode->getNodeType == 3)) # 3=TEXT_NODE
		{
			$offset = $xmlnode->getNodeValue;
		}
		else
		{
			$offset = "\n";
		}

		if ($ex_kernelparams eq 0)
		{
			$kernelparamnode = $xmldoc->createElement("kernel_parameters");
			$kernelparamnode->appendChild($xmldoc->createTextNode($kernel_parameters));
			$bootloadernode->appendChild($kernelparamnode);
			$bootloadernode->appendChild($xmldoc->createTextNode("$offset"));
			$ex_kernelparams  = 1;
		}
	}

	#insert the addtional modules for some special platform
	my @additional_modules = @$additional_mod_ref;
	if ($#additional_modules >= 0)
	{
		foreach $xmlnode ($bootloadernode->getChildNodes)
		{
			if ($xmlnode->getNodeType == 1)
			{
				if ($xmlnode->getNodeName eq "initrd_modules")
				{
					$initrdmodulesnode = $xmlnode;
					$ex_initrdmodules  = 1;
				}
			}
		}
		$xmlnode = $bootloadernode->getPreviousSibling;
		if ((defined $xmlnode) && ($xmlnode->getNodeType == 3))
		{
			$offset = $xmlnode->getNodeValue;
		}
		else
		{
			$offset = "\n";
		}

		if ($ex_initrdmodules == 0)
		{
			$initrdmodulesnode = $xmldoc->createElement("initrd_modules");
			$initrdmodulesnode->setAttribute("config:type", "list");
			$bootloadernode->insertBefore($xmldoc->createTextNode("$offset  "),
										  $bootloadernode->getLastChild);
			$bootloadernode->insertBefore($initrdmodulesnode,
										  $bootloadernode->getLastChild);
			$ex_initrdmodules = 1;
		}
		for my $module (@additional_modules)
		{
			$modulenode = $xmldoc->createElement("module");
			$modulenode->appendChild($xmldoc->createTextNode($module));
			$initrdmodulesnode->appendChild(
										$xmldoc->createTextNode("$offset    "));
			$initrdmodulesnode->appendChild($modulenode);
		}
		$initrdmodulesnode->appendChild($xmldoc->createTextNode("$offset  "));
	}

	#  report section

	foreach $xmlnode ($reportnode->getChildNodes)
	{
		$reportnode->removeChild($xmlnode);
	}

	$xmlnode = $reportnode->getPreviousSibling;
	if ((defined $xmlnode) && ($xmlnode->getNodeType == 3))
	{
		$offset = $xmlnode->getNodeValue;
	}
	else
	{
		$offset = "\n";
	}

	$reportnode->appendChild($xmldoc->createTextNode("$offset"));

	my (
		$messagesnode, $errorsnode,  $warningsnode,
		$shownode,     $timeoutnode, $lognode
	   );

	$messagesnode = $xmldoc->createElement("messages");
	$reportnode->insertBefore($xmldoc->createTextNode("$offset "),
							  $reportnode->getLastChild);
	$reportnode->insertBefore($messagesnode, $reportnode->getLastChild);
	$messagesnode->appendChild($xmldoc->createTextNode("$offset "));

	$messagesnode->insertBefore($xmldoc->createTextNode("$offset  "),
								$messagesnode->getLastChild);
	$shownode = $xmldoc->createElement("show");
	$shownode->appendChild($xmldoc->createTextNode("true"));
	$messagesnode->insertBefore($shownode, $messagesnode->getLastChild);

	$messagesnode->insertBefore($xmldoc->createTextNode("$offset  "),
								$messagesnode->getLastChild);
	$timeoutnode = $xmldoc->createElement("timeout");
	$timeoutnode->appendChild($xmldoc->createTextNode("3"));
	$messagesnode->insertBefore($timeoutnode, $messagesnode->getLastChild);

	$messagesnode->insertBefore($xmldoc->createTextNode("$offset  "),
								$messagesnode->getLastChild);
	$lognode = $xmldoc->createElement("log");
	$lognode->appendChild($xmldoc->createTextNode("true"));
	$messagesnode->insertBefore($lognode, $messagesnode->getLastChild);

	$errorsnode = $xmldoc->createElement("errors");
	$reportnode->insertBefore($xmldoc->createTextNode("$offset "),
							  $reportnode->getLastChild);
	$reportnode->insertBefore($errorsnode, $reportnode->getLastChild);
	$errorsnode->appendChild($xmldoc->createTextNode("$offset "));

	$errorsnode->insertBefore($xmldoc->createTextNode("$offset  "),
							  $errorsnode->getLastChild);
	$shownode = $xmldoc->createElement("show");
	$shownode->appendChild($xmldoc->createTextNode("true"));
	$errorsnode->insertBefore($shownode, $errorsnode->getLastChild);

	$errorsnode->insertBefore($xmldoc->createTextNode("$offset  "),
							  $errorsnode->getLastChild);
	$timeoutnode = $xmldoc->createElement("timeout");
	$timeoutnode->appendChild($xmldoc->createTextNode("3"));
	$errorsnode->insertBefore($timeoutnode, $errorsnode->getLastChild);

	$errorsnode->insertBefore($xmldoc->createTextNode("$offset  "),
							  $errorsnode->getLastChild);
	$lognode = $xmldoc->createElement("log");
	$lognode->appendChild($xmldoc->createTextNode("true"));
	$errorsnode->insertBefore($lognode, $errorsnode->getLastChild);

	$warningsnode = $xmldoc->createElement("warnings");
	$reportnode->insertBefore($xmldoc->createTextNode("$offset "),
							  $reportnode->getLastChild);
	$reportnode->insertBefore($warningsnode, $reportnode->getLastChild);
	$warningsnode->appendChild($xmldoc->createTextNode("$offset "));

	$warningsnode->insertBefore($xmldoc->createTextNode("$offset  "),
								$warningsnode->getLastChild);
	$shownode = $xmldoc->createElement("show");
	$shownode->appendChild($xmldoc->createTextNode("true"));
	$warningsnode->insertBefore($shownode, $warningsnode->getLastChild);

	$warningsnode->insertBefore($xmldoc->createTextNode("$offset  "),
								$warningsnode->getLastChild);
	$timeoutnode = $xmldoc->createElement("timeout");
	$timeoutnode->appendChild($xmldoc->createTextNode("3"));
	$warningsnode->insertBefore($timeoutnode, $warningsnode->getLastChild);

	$warningsnode->insertBefore($xmldoc->createTextNode("$offset  "),
								$warningsnode->getLastChild);
	$lognode = $xmldoc->createElement("log");
	$lognode->appendChild($xmldoc->createTextNode("true"));
	$warningsnode->insertBefore($lognode, $warningsnode->getLastChild);

	#  Mode section

	foreach $xmlnode ($modenode->getChildNodes)
	{
		$modenode->removeChild($xmlnode);
	}

	$xmlnode = $modenode->getPreviousSibling;
	if ((defined $xmlnode) && ($xmlnode->getNodeType == 3))
	{
		$offset = $xmlnode->getNodeValue;
	}
	else
	{
		$offset = "\n";
	}

	my $confirmnode = $xmldoc->createElement("confirm");
	$confirmnode->setAttribute("config:type", "boolean");
	$confirmnode->appendChild($xmldoc->createTextNode("false"));

	my $rebootnode = $xmldoc->createElement("reboot");
	$rebootnode->setAttribute("config:type", "boolean");
	$rebootnode->appendChild($xmldoc->createTextNode("false"));

	my $forcebootnode = $xmldoc->createElement("forceboot");
	$forcebootnode->setAttribute("config:type", "boolean");
	$forcebootnode->appendChild($xmldoc->createTextNode("false"));

	my $interactive_bootnode = $xmldoc->createElement("interactive_boot");
	$interactive_bootnode->setAttribute("config:type", "boolean");
	$interactive_bootnode->appendChild($xmldoc->createTextNode("false"));

	foreach $xmlnode ($modenode->getChildNodes)
	{
		$modenode->removeChild($xmlnode);
	}

	$modenode->appendChild($xmldoc->createTextNode("$offset "));
	$modenode->appendChild($confirmnode);
	$modenode->appendChild($xmldoc->createTextNode("$offset "));
	$modenode->appendChild($rebootnode);
	$modenode->appendChild($xmldoc->createTextNode("$offset "));
	$modenode->appendChild($forcebootnode);
	$modenode->appendChild($xmldoc->createTextNode("$offset "));
	$modenode->appendChild($interactive_bootnode);
	$modenode->appendChild($xmldoc->createTextNode("$offset"));

	#networking
	$xmlnode = $networkingnode->getPreviousSibling;
	if ((defined $xmlnode) && ($xmlnode->getNodeType == 3))
	{
		$offset = $xmlnode->getNodeValue;
	}
	else
	{
		$offset = "\n";
	}

	my ($dnsnode, $hostnamenode, $domainnode);
	my $ex_dns      = 0;
	my $ex_hostname = 0;
	my $ex_domain   = 0;

	# for SLES10
	my ($interfacenode, $bootprotonode, $netdevicenode, $ipaddrnode, $netmasknode, $startmodenode);

	foreach $xmlnode ($networkingnode->getChildNodes)
	{
		if (($xmlnode->getNodeType == 1) && ($xmlnode->getNodeName eq "dns"))
		{
			$dnsnode = $xmlnode;
			$ex_dns  = 1;
			last;
		}
	}

	# for SLES10
	if ($::DISTRO_NAME =~ /SLES/ && $::DISTRO_VERSION eq '10')
	{
	   $xmlnodelist = $xmlroot->getElementsByTagName("interfaces");
	   if ($xmlnodelist->getLength != 1)
	   {
	       MessageUtils->messageFromCat(
						'csmInstall.cat',        $::MSGMAPPATH,
						'csminstall',            'E2',
						'EMsgPARSING_YAST_FILE', $tmpl
					   );
	   }

	   $xmlnodelist = $xmlroot->getElementsByTagName("interface");
	   if ($xmlnodelist->getLength != 1)
	   {
	       MessageUtils->messageFromCat(
						'csmInstall.cat',        $::MSGMAPPATH,
						'csminstall',            'E2',
						'EMsgPARSING_YAST_FILE', $tmpl
					   );
	   }
	   else
	   {
	       $interfacenode = $xmlnodelist->item(0);
	   }

	   $xmlnodelist = $interfacenode->getElementsByTagName("bootproto");
	   if ($xmlnodelist->getLength != 1)
	   {
		MessageUtils->messageFromCat(
						'csmInstall.cat',        $::MSGMAPPATH,
						'csminstall',            'E2',
						'EMsgPARSING_YAST_FILE', $tmpl
					   );
	   }
	   else
	   {
	       $bootprotonode = $xmlnodelist->item(0);
	       foreach $xmlnode ($bootprotonode->getChildNodes)
	       {
		   $bootprotonode->removeChild($xmlnode);
	       }
	       $bootprotonode->appendChild($xmldoc->createTextNode("static"));
	   }

	   # specify network device in autoyast configure file
	   $xmlnodelist = $interfacenode->getElementsByTagName("device");
	   if ($xmlnodelist->getLength != 1)
	   {
		MessageUtils->messageFromCat(
						'csmInstall.cat',        $::MSGMAPPATH,
						'csminstall',            'E2',
						'EMsgPARSING_YAST_FILE', $tmpl
					   );
	   }
	   else
	   {
	       $netdevicenode = $xmlnodelist->item(0);
	       foreach $xmlnode ($netdevicenode->getChildNodes)
	       {
		   $netdevicenode->removeChild($xmlnode);
	       }
	       $netdevicenode->appendChild($xmldoc->createTextNode($::NODE_NETDEV));
	   }

	   $xmlnodelist = $interfacenode->getElementsByTagName("ipaddr");
	   if ($xmlnodelist->getLength != 1)
	   {
		MessageUtils->messageFromCat(
						'csmInstall.cat',        $::MSGMAPPATH,
						'csminstall',            'E2',
						'EMsgPARSING_YAST_FILE', $tmpl
					   );
	   }
	   else
	   {
	       $ipaddrnode = $xmlnodelist->item(0);
	       foreach $xmlnode ($ipaddrnode->getChildNodes)
	       {
		   $ipaddrnode->removeChild($xmlnode);
	       }
	       $ipaddrnode->appendChild($xmldoc->createTextNode($::NODE_IP));
	   }

	   $xmlnodelist = $interfacenode->getElementsByTagName("netmask");
	   if ($xmlnodelist->getLength != 1)
	   {
		MessageUtils->messageFromCat(
						'csmInstall.cat',        $::MSGMAPPATH,
						'csminstall',            'E2',
						'EMsgPARSING_YAST_FILE', $tmpl
					   );
	   }
	   else
	   {
	       $netmasknode = $xmlnodelist->item(0);
	       foreach $xmlnode ($netmasknode->getChildNodes)
	       {
		   $netmasknode->removeChild($xmlnode);
	       }
	       $netmasknode->appendChild($xmldoc->createTextNode($::NODE_MASK));
	   }

	   $xmlnodelist = $interfacenode->getElementsByTagName("startmode");
	   if ($xmlnodelist->getLength != 1)
	   {
		MessageUtils->messageFromCat(
						'csmInstall.cat',        $::MSGMAPPATH,
						'csminstall',            'E2',
						'EMsgPARSING_YAST_FILE', $tmpl
					   );
	   }
	   else
	   {
	       $startmodenode = $xmlnodelist->item(0);
	       foreach $xmlnode ($startmodenode->getChildNodes)
	       {
		   $startmodenode->removeChild($xmlnode);
	       }
	       $startmodenode->appendChild($xmldoc->createTextNode("onboot"));
	   }
        }

	if ($ex_dns == 0)
	{
		$networkingnode->insertBefore($xmldoc->createTextNode("$offset "),
									  $networkingnode->getLastChild);
		$dnsnode = $xmldoc->createElement("dns");
		$dnsnode->appendChild($xmldoc->createTextNode("$offset "));
		$networkingnode->insertBefore($dnsnode, $networkingnode->getLastChild);
	}

	foreach $xmlnode ($dnsnode->getChildNodes)
	{
		if (($xmlnode->getNodeType == 1))
		{
			if ($xmlnode->getNodeName eq "hostname")
			{
				$hostnamenode = $xmlnode;
				$ex_hostname  = 1;
			}
			if ($xmlnode->getNodeName eq "domain")
			{
				$domainnode = $xmlnode;
				$ex_domain  = 1;
			}
		}
	}

	if ($ex_hostname == 0)
	{
		$dnsnode->insertBefore($xmldoc->createTextNode("$offset  "),
							   $dnsnode->getLastChild);
		$hostnamenode = $xmldoc->createElement("hostname");
		$dnsnode->insertBefore($hostnamenode, $dnsnode->getLastChild);
	}
	if ($ex_domain == 0)
	{
		$dnsnode->insertBefore($xmldoc->createTextNode("$offset  "),
							   $dnsnode->getLastChild);
		$domainnode = $xmldoc->createElement("domain");
		$dnsnode->insertBefore($domainnode, $dnsnode->getLastChild);
	}

	foreach $xmlnode ($hostnamenode->getChildNodes)
	{
		$hostnamenode->removeChild($xmlnode);
	}

	$hostnamenode->appendChild($xmldoc->createTextNode($::NODE_SHORTNAME));

	foreach $xmlnode ($domainnode->getChildNodes)
	{
		$domainnode->removeChild($xmlnode);
	}
	$domainnode->appendChild($xmldoc->createTextNode($::DNSDOMAIN));

	#if hostname is an IP address,remove it
	my $hostname_is_ip = NetworkUtils->isIpaddr($::NODE_HOSTNAME);
	if ($hostname_is_ip)
	{
		foreach $xmlnode ($networkingnode->getChildNodes)
		{
			if (   ($xmlnode->getNodeType == 1)
				&& ($xmlnode->getNodeName eq "dns"))
			{
				$networkingnode->removeChild($xmlnode);
			}
		}
		my $networking_enabled_node = $xmldoc->createElement("enabled");
		$networking_enabled_node->setAttribute("config:type", "boolean");
		$networking_enabled_node->appendChild($xmldoc->createTextNode("true"));
		$networkingnode->insertBefore($networking_enabled_node,
									  $networkingnode->getFirstChild);
		$networkingnode->insertBefore($xmldoc->createTextNode("$offset  "),
									  $networkingnode->getFirstChild);
	}

	#setting Gateway
	if (($::GATEWAY ne "") && ($::GATEWAY ne "0.0.0.0"))
	{
		my $routingnode;
		my $routesnode;
		my $routenode;
		my ($destinationnode, $devicenode, $gatewaynode, $netmasknode);

		my $ex_routing     = 0;
		my $ex_routes      = 0;
		my $ex_route       = 0;
		my $ex_destination = 0;
		my $ex_device      = 0;
		my $ex_gateway     = 0;
		my $ex_netmask     = 0;

		foreach $xmlnode ($networkingnode->getChildNodes)
		{
			if (   ($xmlnode->getNodeType == 1)
				&& ($xmlnode->getNodeName eq "routing"))
			{
				$routingnode = $xmlnode;
				$ex_routing  = 1;
				last;
			}
		}
		$offset .= "  ";
		if ($ex_routing == 0)
		{
			$networkingnode->insertBefore($xmldoc->createTextNode("$offset"),
										  $networkingnode->getLastChild);
			$routingnode = $xmldoc->createElement("routing");
			$routingnode->appendChild($xmldoc->createTextNode("$offset"));
			$networkingnode->insertBefore($routingnode,
										  $networkingnode->getLastChild);
		}

		foreach $xmlnode ($routingnode->getChildNodes)
		{
			if (   ($xmlnode->getNodeType == 1)
				&& ($xmlnode->getNodeName eq "routes"))
			{
				$routesnode = $xmlnode;
				$ex_routes  = 1;
				last;
			}
		}
		$offset .= "  ";
		if ($ex_routes == 0)
		{
			$routingnode->insertBefore($xmldoc->createTextNode("$offset"),
									   $routingnode->getLastChild);
			$routesnode = $xmldoc->createElement("routes");
			$routesnode->setAttribute("config:type", "list");
			$routesnode->appendChild($xmldoc->createTextNode("$offset"));
			$routingnode->insertBefore($routesnode, $routingnode->getLastChild);
		}

		foreach $xmlnode ($routesnode->getChildNodes)
		{
			if (   ($xmlnode->getNodeType == 1)
				&& ($xmlnode->getNodeName eq "route"))
			{
				$routenode = $xmlnode;
				$ex_route  = 1;
				last;
			}
		}
		$offset .= "  ";
		if ($ex_route == 0)
		{
			$routesnode->insertBefore($xmldoc->createTextNode("$offset"),
									  $routesnode->getLastChild);
			$routenode = $xmldoc->createElement("route");
			$routenode->appendChild($xmldoc->createTextNode("$offset"));
			$routesnode->insertBefore($routenode, $routesnode->getLastChild);
		}
		foreach $xmlnode ($routenode->getChildNodes)
		{
			if (($xmlnode->getNodeType == 1))
			{
				if ($xmlnode->getNodeName eq "destination")
				{
					$destinationnode = $xmlnode;
					$ex_destination  = 1;
				}
				if ($xmlnode->getNodeName eq "device")
				{
					$devicenode = $xmlnode;
					$ex_device  = 1;
				}
				if ($xmlnode->getNodeName eq "gateway")
				{
					$gatewaynode = $xmlnode;
					$ex_gateway  = 1;
				}
				if ($xmlnode->getNodeName eq "netmask")
				{
					$netmasknode = $xmlnode;
					$ex_netmask  = 1;
				}
			}
		}
		$offset .= "  ";
		if ($ex_destination == 0)
		{
			$routenode->insertBefore($xmldoc->createTextNode("$offset"),
									 $routenode->getLastChild);
			$destinationnode = $xmldoc->createElement("destination");
			$routenode->insertBefore($destinationnode,
									 $routenode->getLastChild);
		}
		if ($ex_device == 0)
		{
			$routenode->insertBefore($xmldoc->createTextNode("$offset"),
									 $routenode->getLastChild);
			$devicenode = $xmldoc->createElement("device");
			$routenode->insertBefore($devicenode, $routenode->getLastChild);
		}

		if ($ex_gateway == 0)
		{
			$routenode->insertBefore($xmldoc->createTextNode("$offset"),
									 $routenode->getLastChild);
			$gatewaynode = $xmldoc->createElement("gateway");
			$routenode->insertBefore($gatewaynode, $routenode->getLastChild);
		}

		if ($ex_netmask == 0)
		{
			$routenode->insertBefore($xmldoc->createTextNode("$offset"),
									 $routenode->getLastChild);
			$netmasknode = $xmldoc->createElement("netmask");
			$routenode->insertBefore($netmasknode, $routenode->getLastChild);
		}

		foreach $xmlnode ($destinationnode->getChildNodes)
		{
			$destinationnode->removeChild($xmlnode);
		}
		$destinationnode->appendChild($xmldoc->createTextNode("default"));
		foreach $xmlnode ($devicenode->getChildNodes)
		{
			$devicenode->removeChild($xmlnode);
		}
		$devicenode->appendChild($xmldoc->createTextNode("-"));
		foreach $xmlnode ($gatewaynode->getChildNodes)
		{
			$gatewaynode->removeChild($xmlnode);
		}
		$gatewaynode->appendChild($xmldoc->createTextNode("$::GATEWAY"));
		foreach $xmlnode ($netmasknode->getChildNodes)
		{
			$netmasknode->removeChild($xmlnode);
		}
		$netmasknode->appendChild($xmldoc->createTextNode("-"));

	}    #End of Gateway

	#clock
	$xmlnode = $clocknode->getPreviousSibling;
	if ((defined $xmlnode) && ($xmlnode->getNodeType == 3))
	{
		$offset = $xmlnode->getNodeValue;
	}
	else
	{
		$offset = "\n";
	}
	my $timezonenode;
	my $ex_timezone = 0;
	my $hwclocknode;
	my $ex_hwclock;
	foreach $xmlnode ($clocknode->getChildNodes)
	{
		if (   ($xmlnode->getNodeType == 1)
			&& ($xmlnode->getNodeName eq "timezone"))
		{
			$timezonenode = $xmlnode;
			$ex_timezone  = 1;
		}
		if (   ($xmlnode->getNodeType == 1)
			&& ($xmlnode->getNodeName eq "hwclock"))
		{
			$hwclocknode = $xmlnode;
			$ex_hwclock  = 1;
		}

	}
	if ($ex_timezone == 0)
	{
		$clocknode->insertBefore($xmldoc->createTextNode("$offset "),
								 $clocknode->getLastChild);
		$timezonenode = $xmldoc->createElement("timezone");
		$clocknode->insertBefore($timezonenode, $clocknode->getLastChild);
	}
	if ($timezonenode->hasChildNodes() != 1)
	{
		$timezonenode->appendChild($xmldoc->createTextNode($::TIMEZONE));
	}

	if ($ex_hwclock == 0)
	{
		$clocknode->insertBefore($xmldoc->createTextNode("$offset  "),
								 $clocknode->getLastChild);
		$hwclocknode = $xmldoc->createElement("hwclock");
		$clocknode->insertBefore($hwclocknode, $clocknode->getLastChild);
	}
	if ($hwclocknode->hasChildNodes() != 1)
	{
		$hwclocknode->appendChild($xmldoc->createTextNode("UTC"));
	}

	#for init section
	$xmlnode = $initnode->getPreviousSibling;
	if ((defined $xmlnode) && ($xmlnode->getNodeType == 3))
	{
		$offset = $xmlnode->getNodeValue;
	}
	else
	{
		$offset = "\n";
	}

	foreach $xmlnode ($initnode->getChildNodes)
	{
		$initnode->removeChild($xmlnode);
	}

	my $install_protocol = NodesetUtils->get_NetworkInstallProtocol();
	my $info_file        = <<INFOEND

#
# Don't remove the following line:
# start_linuxrc_conf
#
install: ${install_protocol}://$::NFS_IP$::NFS_DIR/CD1
Usedhcp: 1
Textmode: 1

# end_linuxrc_conf
# Do not remove the above comment

INFOEND
	  ;
	my $info_filenode = $xmldoc->createElement("info_file");
	$info_filenode->appendChild($xmldoc->createTextNode("\n"));
	$info_filenode->appendChild($xmldoc->createCDATASection($info_file));
	$info_filenode->appendChild($xmldoc->createTextNode("$offset "));

	my $insmodenode = $xmldoc->createElement("insmode");
	$insmodenode->appendChild($xmldoc->createTextNode($install_protocol));

	my $profile_locationnode = $xmldoc->createElement("profile_location");
	$profile_locationnode->appendChild($xmldoc->createTextNode($tmpl));

	my $profile_protocolnode = $xmldoc->createElement("profile_protocol");
	$profile_protocolnode->appendChild(
									$xmldoc->createTextNode($install_protocol));

	my $servernode = $xmldoc->createElement("server");
	$servernode->appendChild($xmldoc->createTextNode($::NFS_IP));

	my $serverdirnode = $xmldoc->createElement("serverdir");
	$serverdirnode->appendChild($xmldoc->createTextNode($::NFS_DIR));

	my $textmodenode = $xmldoc->createElement("textmode");
	$textmodenode->setAttribute("config:type", "boolean");
	$textmodenode->appendChild($xmldoc->createTextNode("true"));

	my $usedhcpnode = $xmldoc->createElement("usedhcp");
	$usedhcpnode->setAttribute("config:type", "boolean");
	$usedhcpnode->appendChild($xmldoc->createTextNode("true"));

	$initnode->appendChild($xmldoc->createTextNode("$offset "));
	$initnode->appendChild($info_filenode);
	$initnode->appendChild($xmldoc->createTextNode("$offset "));
	$initnode->appendChild($insmodenode);
	$initnode->appendChild($xmldoc->createTextNode("$offset "));
	$initnode->appendChild($profile_locationnode);
	$initnode->appendChild($xmldoc->createTextNode("$offset "));
	$initnode->appendChild($profile_protocolnode);
	$initnode->appendChild($xmldoc->createTextNode("$offset "));
	$initnode->appendChild($servernode);
	$initnode->appendChild($xmldoc->createTextNode("$offset "));
	$initnode->appendChild($serverdirnode);
	$initnode->appendChild($xmldoc->createTextNode("$offset "));
	$initnode->appendChild($textmodenode);
	$initnode->appendChild($xmldoc->createTextNode("$offset "));
	$initnode->appendChild($usedhcpnode);
	$initnode->appendChild($xmldoc->createTextNode("$offset"));

	#post-scripts

	$xmlnode = $scriptsnode->getPreviousSibling;
	if ((defined $xmlnode) && ($xmlnode->getNodeType == 3))
	{
		$offset = $xmlnode->getNodeValue;
	}
	else
	{
		$offset = "\n";
	}

	foreach $xmlnode ($scriptsnode->getChildNodes)
	{
		if (($xmlnode->getNodeType == 1))
		{
			if ($xmlnode->getNodeName eq "post-scripts")
			{
				$postnode = $xmlnode;
				$post     = 1;
			}
			if ($xmlnode->getNodeName eq "chroot-scripts")
			{
				$chrootnode = $xmlnode;
				$chroot     = 1;
			}
			if ($xmlnode->getNodeName eq "pre-scripts")
			{
				$prenode = $xmlnode;
				$pre     = 1;
			}
		}
	}

	if ($post == 0)
	{
		$scriptsnode->insertBefore($xmldoc->createTextNode("$offset "),
								   $scriptsnode->getLastChild);
		$postnode = $xmldoc->createElement("post-scripts");
		$postnode->appendChild($xmldoc->createTextNode("$offset "));
		$postnode->setAttribute("config:type", "list");
		$scriptsnode->insertBefore($postnode, $scriptsnode->getLastChild);
	}
	if ($chroot == 0)
	{
		$scriptsnode->insertBefore($xmldoc->createTextNode("$offset "),
								   $scriptsnode->getLastChild);
		$chrootnode = $xmldoc->createElement("chroot-scripts");
		$chrootnode->appendChild($xmldoc->createTextNode("$offset "));
		$chrootnode->setAttribute("config:type", "list");
		$scriptsnode->insertBefore($chrootnode, $scriptsnode->getLastChild);
	}

	#VJBBEGIN
	if ($pre == 0)
	{
		$scriptsnode->insertBefore($xmldoc->createTextNode("$offset "),
								   $scriptsnode->getLastChild);
		$prenode = $xmldoc->createElement("pre-scripts");
		$prenode->appendChild($xmldoc->createTextNode("$offset "));
		$prenode->setAttribute("config:type", "list");
		$scriptsnode->insertBefore($prenode, $scriptsnode->getLastChild);
	}

	$prenode->setAttribute("config:type", "list");

	#VJBEND
	$postnode->setAttribute("config:type",   "list");
	$chrootnode->setAttribute("config:type", "list");
	my ($scriptnode, $filenamenode, $interpreternode, $sourcenode);

	#VJBBEGIN - add pre script
    my ($effective_distro_name) = NodeUtils->getEffectiveDistro($::DISTRO_NAME);
	# Edit the prescript file and add it as a CDATA node if it exits
	my $prescriptsource = "$::TEMPLATESCRIPTS/pre.$effective_distro_name";
	my @prefile         = ("$::DISTRO_VERSION", "$::ARCH");

	# get the most specific file we can, but generalize if that's the
	# only thing we can find.

	while (@prefile)
	{
		my $f = "$prescriptsource-" . join('-', @prefile);

		#print "trying $f\n";
		if (-f "$f")
		{

			#print "$f exists\n";
			$prescriptsource = $f;
			last;
		}
		else
		{
			pop @prefile;
		}
	}

	#print "prescript is: $prescriptsource\n";
	# now make sure we can read it.
	my $presource;

	if (-r $prescriptsource)
	{
		$presource    = &subvars($prescriptsource);
		$scriptnode   = $xmldoc->createElement("script");
		$offset       = "$offset  ";
		$filenamenode = $xmldoc->createElement("filename");
		$filenamenode->appendChild($xmldoc->createTextNode("csmprescript"));
		$interpreternode = $xmldoc->createElement("interpreter");
		$interpreternode->appendChild($xmldoc->createTextNode("shell"));
		$sourcenode = $xmldoc->createElement("source");
		$sourcenode->appendChild($xmldoc->createTextNode("\n"));
		$sourcenode->appendChild($xmldoc->createCDATASection($presource));
		$sourcenode->appendChild($xmldoc->createTextNode("$offset  "));
		$scriptnode->appendChild($xmldoc->createTextNode("$offset "));
		$scriptnode->appendChild($filenamenode);
		$scriptnode->appendChild($xmldoc->createTextNode("$offset "));
		$scriptnode->appendChild($interpreternode);
		$scriptnode->appendChild($xmldoc->createTextNode("$offset "));
		$scriptnode->appendChild($sourcenode);
		$scriptnode->appendChild($xmldoc->createTextNode("$offset"));

		# Now add the node to the tree.
		$prenode->insertBefore($xmldoc->createTextNode("$offset"),
							   $prenode->getLastChild);
		$prenode->insertBefore($scriptnode, $prenode->getLastChild);
	}
	else
	{

		#print "No prescript... $prescriptsource\n";
		#MessageUtils->messageFromCat('csmInstall.cat',
		#	$::MSGMAPPATH, 'csminstall', 'E2',
		#	'EMsgCANT_READ_FILE', $prescriptsource);
	}

	#VJBEND

	#SSSBEGIN

	#
	# Edit the chrootscript file and add it as a CDATA node
	#
	my $chrootsourcefile = "$::TEMPLATESCRIPTS/chroot." . $effective_distro_name;
	my $chrootsource;

	if ($::ARCH eq "ppc64")
	{
		$chrootsourcefile .= ".ppc64";
	}

	if (-r $chrootsourcefile)
	{
		$chrootsource = &subvars($chrootsourcefile);
	}
	else
	{

		MessageUtils->messageFromCat(
									 'csmInstall.cat',     $::MSGMAPPATH,
									 'csminstall',         'E2',
									 'EMsgCANT_READ_FILE', $chrootsourcefile
									);
	}

	$scriptnode = $xmldoc->createElement("script");
	$offset     = "$offset  ";

	$filenamenode = $xmldoc->createElement("filename");
	$filenamenode->appendChild($xmldoc->createTextNode("csmchrootscript"));

	$interpreternode = $xmldoc->createElement("interpreter");
	$interpreternode->appendChild($xmldoc->createTextNode("shell"));

	$sourcenode = $xmldoc->createElement("source");
	$sourcenode->appendChild($xmldoc->createTextNode("\n"));
	$sourcenode->appendChild($xmldoc->createCDATASection($chrootsource));
	$sourcenode->appendChild($xmldoc->createTextNode("$offset  "));

	$scriptnode->appendChild($xmldoc->createTextNode("$offset "));
	$scriptnode->appendChild($filenamenode);
	$scriptnode->appendChild($xmldoc->createTextNode("$offset "));
	$scriptnode->appendChild($interpreternode);
	$scriptnode->appendChild($xmldoc->createTextNode("$offset "));
	$scriptnode->appendChild($sourcenode);
	$scriptnode->appendChild($xmldoc->createTextNode("$offset"));

	# Now add the node to the tree.
	$chrootnode->insertBefore($xmldoc->createTextNode("$offset"),
							  $chrootnode->getLastChild);
	$chrootnode->insertBefore($scriptnode, $chrootnode->getLastChild);

	#SSSEND

	#
	# Edit the postscript file and add it as a CDATA node
	#
	my $postsourcefile = "$::TEMPLATESCRIPTS/post." . $effective_distro_name;
	my $postsource;

	if (-r $postsourcefile)
	{
		$postsource = &subvars($postsourcefile);
	}
	else
	{

		MessageUtils->messageFromCat(
									 'csmInstall.cat',     $::MSGMAPPATH,
									 'csminstall',         'E2',
									 'EMsgCANT_READ_FILE', $postsourcefile
									);

	}

	$scriptnode = $xmldoc->createElement("script");
	$offset     = "$offset  ";

	$filenamenode = $xmldoc->createElement("filename");
	$filenamenode->appendChild($xmldoc->createTextNode("csmpostscript"));

	$interpreternode = $xmldoc->createElement("interpreter");
	$interpreternode->appendChild($xmldoc->createTextNode("shell"));

	$sourcenode = $xmldoc->createElement("source");
	$sourcenode->appendChild($xmldoc->createTextNode("\n"));
	$sourcenode->appendChild($xmldoc->createCDATASection($postsource));
	$sourcenode->appendChild($xmldoc->createTextNode("$offset  "));

	$scriptnode->appendChild($xmldoc->createTextNode("$offset "));
	$scriptnode->appendChild($filenamenode);
	$scriptnode->appendChild($xmldoc->createTextNode("$offset "));
	$scriptnode->appendChild($interpreternode);
	$scriptnode->appendChild($xmldoc->createTextNode("$offset "));
	$scriptnode->appendChild($sourcenode);
	$scriptnode->appendChild($xmldoc->createTextNode("$offset"));

	#
	# Now add the node to the tree
	$postnode->insertBefore($xmldoc->createTextNode("$offset"),
							$postnode->getLastChild);
	$postnode->insertBefore($scriptnode, $postnode->getLastChild);

	# insert the addtional modules for some special platform
	# into config section
	my @explicit_additional_modules = @$explicit_additional_mod_ref;
	if ($#explicit_additional_modules >= 0)
	{
		foreach $xmlnode ($configurenode->getChildNodes)
		{
			if ($xmlnode->getNodeType == 1)
			{
				if ($xmlnode->getNodeName eq "sysconfig")
				{
					$configurenode = $xmlnode;
					$ex_sysconfig  = 1;
				}
			}
		}
		$xmlnode = $configurenode->getPreviousSibling;
		if ((defined $xmlnode) && ($xmlnode->getNodeType == 3))
		{
			$offset = $xmlnode->getNodeValue;
		}
		else
		{
			$offset = "\n";
		}

		if ($ex_sysconfig == 0)
		{
			$sysconfignode = $xmldoc->createElement("sysconfig");
			$sysconfignode->setAttribute("config:type", "list");
			$sysconfignode->insertBefore($xmldoc->createTextNode("$offset  "),
										 $sysconfignode->getLastChild);
			$sysconfig_entrynode = $xmldoc->createElement("sysconfig_entry");
			$sysconfignode->insertBefore($xmldoc->createTextNode("$offset    "),
										 $sysconfignode->getLastChild);
			$sysconfignode->insertBefore($sysconfig_entrynode,
										 $sysconfignode->getLastChild);

			$configurenode->insertBefore($xmldoc->createTextNode("$offset  "),
										 $configurenode->getLastChild);
			$configurenode->insertBefore($sysconfignode,
										 $configurenode->getLastChild);

			$ex_sysconfig = 1;
		}

		$sysconfig_keynode = $xmldoc->createElement("sysconfig_key");
		$sysconfig_keynode->appendChild(
									 $xmldoc->createTextNode("INITRD_MODULES"));
		$sysconfig_entrynode->appendChild(
									  $xmldoc->createTextNode("$offset      "));
		$sysconfig_entrynode->appendChild($sysconfig_keynode);

		$sysconfig_pathnode = $xmldoc->createElement("sysconfig_path");
		$sysconfig_pathnode->appendChild($xmldoc->createTextNode("kernel"));
		$sysconfig_entrynode->appendChild(
									  $xmldoc->createTextNode("$offset      "));
		$sysconfig_entrynode->appendChild($sysconfig_pathnode);

		my $modules = join ' ', @explicit_additional_modules;
		$sysconfig_valuenode = $xmldoc->createElement("sysconfig_value");
		$sysconfig_valuenode->appendChild($xmldoc->createTextNode($modules));
		$sysconfig_entrynode->appendChild(
									  $xmldoc->createTextNode("$offset      "));
		$sysconfig_entrynode->appendChild($sysconfig_valuenode);

		$sysconfig_entrynode->appendChild(
										$xmldoc->createTextNode("$offset    "));
	}

	#
	$xmldoc->printToFile($tmpl);
	
	if ($bootMethod eq 'getmacssnmp')
	{
		return;
	}
	unlink($hexfile_link);
	symlink $yastfile_real, $hexfile_link;
	unlink $yastfile_link;
	symlink $yastfile_real, $yastfile_link;
	if (!$nameIsIP)
	{
		unlink $yastfile_hostlink;
		symlink $yastfile_real, $yastfile_hostlink;
	}
}

#--End

# Internal routine
sub get_node_isvr
{
	my $nodename = shift;

	my $adp_hostname = $nodeHash{$nodename}{'InstallAdapterHostname'};
	$adp_hostname ||= $nodename;

	my ($server_host, $server_ip);

	$server_ip = NetworkUtils->get_source_ip_to_target($adp_hostname);
	chomp($server_ip);

	($server_host, undef) = NetworkUtils->getHost_rveg($server_ip);

	if ($::GETHOST_RC != $::OK)
	{
		$server_host = $server_ip;
	}

	return ($server_host, $server_ip, $::CSMINSTALL_ROOT);
}

sub get_node_nfssvr
{
	my $nodename = shift;
	my ($server_host, $server_ip, $dir);

	my $is           = $nodeHash{$nodename}{'InstallServer'};
	my $akb_server   = $nodeHash{$nodename}{'InstallServerAKBNode'};
	my $adp_hostname = $nodeHash{$nodename}{'InstallAdpaterHostname'};
	my $nfssvr       = $nodeHash{$nodename}{'NFSServer'};
	my $ms_ip        =
	  NetworkUtils->validate_ip($nodeHash{$nodename}{'ManagementServer'});

	# Do not take NFSServer attribute into account if those attributes
	# are specified.
	return (undef, undef, undef)
	  if ($is || $akb_server || $adp_hostname || !$nfssvr);

	($server_host, $dir) = split(/:/, $nfssvr);
	($server_host, $server_ip) = NetworkUtils->getHost($server_host);

	if (!$dir && $ms_ip && $server_ip)
	{
		if ($ms_ip eq $server_ip)
		{
			$dir = "/csminstall";
		}
		else
		{
			$dir = "/csmserver";
		}
	}

	return ($server_host, $server_ip, $dir);
}

sub abbreviateDistroName
{
	my $distro_name   = shift;
	my $abbrev_distro = $distro_name;
	if ($distro_name =~ /RedHatEL-AS/)
	{
		$abbrev_distro = "RHAS";
	}
	elsif ($distro_name =~ /RedHatEL-ES/)
	{
		$abbrev_distro = "RHES";
	}
	elsif ($distro_name =~ /RedHatEL-WS/)
	{
		$abbrev_distro = "RHWS";
	}
	elsif ($distro_name =~ /RedHatEL-Server/)
	{
		$abbrev_distro = "RHServer";
	}
	elsif ($distro_name =~ /RedHatEL-Client/)
	{
		$abbrev_distro = "RHClient";
	}
	else
	{
		$abbrev_distro = "SL";
	}

	return $abbrev_distro;
}

sub copyGetmacsKernel
{
	my $hwmaint_flag = shift;

	mkpath("$::TFTPBOOT/csm", $::VERBOSE, 0110);
	NetworkUtils->secureFilePermissions("$::TFTPBOOT/csm", "0110", "0440", 1);
	my $source_kernel;
	my $dest_kernel;
	my $runcmd;
	my @service_levels = NodeUtils->getServiceLevel(\@targetNodes);
	my ($effective_distro_name, $effective_distro_ver) = 
         NodeUtils->getEffectiveDistro($::DISTRO_NAME,$::DISTRO_VERSION);

	foreach my $svclevel (@service_levels)
	{
		if ($effective_distro_name =~ /SLES/)
		{
			if ($effective_distro_ver eq '10')
			{
				$source_kernel = "$::TOP_DIR/$svclevel/CD1/boot/$::ARCH/loader/linux";
			}
			else
			{
				$source_kernel = "$::TOP_DIR/$svclevel/boot/loader/linux";
			}
			$runcmd        = "csmsetupyast";
		}
		else
		{
			my $my_dirname;
			if ($svclevel eq "GA")
			{
				$my_dirname =
				  $::DISTRO_NAME . $::DISTRO_VERSION . "-" . $::ARCH;
			}
			else
			{
				$my_dirname =
				  $::DISTRO_NAME . $::DISTRO_VERSION . "-" . $svclevel;
			}
			$source_kernel = "$::TOP_DIR/$my_dirname/images/pxeboot/vmlinuz";
			$runcmd        = "csmsetupks";
		}

		if (!$source_kernel || !-f $source_kernel)
		{
			MessageUtils->messageFromCat('HCnodecmds.cat', '/opt/csm/msgmaps',
				'getadapters', 'E', "EMsgNotExistingCDInitrd", "$source_kernel",
				$runcmd);

		}
		if ($hwmaint_flag)
		{
			my $distro_name = &abbreviateDistroName($::DISTRO_NAME);
			if ($::ARCH eq "x86_64")
			{
				$dest_kernel =
				    "$::TFTPBOOT/csm/hm-"
				  . "$distro_name$::DISTRO_VERSION"
				  . "$svclevel" . "Ez";
			}
			else
			{
				$dest_kernel =
				    "$::TFTPBOOT/csm/hm-"
				  . "$distro_name$::DISTRO_VERSION"
				  . "$svclevel" . "z";

			}
		}
		else
		{
			$dest_kernel =
			    "$::TFTPBOOT/csm/getmac-"
			  . "$::DISTRO_NAME$::DISTRO_VERSION"
			  . "-$svclevel-$::ARCH" . "z";
		}
		&copyfile($source_kernel, $dest_kernel);
		NetworkUtils->secureFilePermissions($dest_kernel, "0110", "0440");
	}
}

sub copyKickstartKernel
{

	# FOR KICKSTART
	# Copy different kernel for different service levels.

	my ($cmd);
	my ($rc)         = 0;
	my ($returncode) = 0;
	my ($output);
	my ($source_kernel, $ks_kernel);

	my @service_levels = NodeUtils->getServiceLevel(\@targetNodes);

	mkpath("$::TFTPBOOT/csm", $::VERBOSE, 0110);
	NetworkUtils->secureFilePermissions("$::TFTPBOOT/csm", "0110", "0440", 1);
	foreach my $svclevel (@service_levels)
	{
		my $my_dirname;
		if ($svclevel eq "GA")
		{
			$my_dirname = $::DISTRO_NAME . $::DISTRO_VERSION . "-" . $::ARCH;
		}
		else
		{
			$my_dirname = $::DISTRO_NAME . $::DISTRO_VERSION . "-" . $svclevel;
		}
		$source_kernel =
		  $::REDHAT_TOP . "/" . $my_dirname . "/images/pxeboot/vmlinuz";
		if ($ENV{CSM_USERKERNEL})
		{
			$source_kernel =
			  "$ENV{CSMINSTALL_ROOT}/csm/usrkernel/$ENV{CSM_USERKERNEL}";
		}

		$ks_kernel =
		    $::TFTPBOOT . "/csm/" . "ks-"
		  . $::DISTRO_NAME
		  . $::DISTRO_VERSION
		  . "-$svclevel-"
		  . $::ARCH . "z";

		# if the path has already been created then we need to secure it:
		&copyfile($source_kernel, $ks_kernel);
		NetworkUtils->secureFilePermissions($ks_kernel, "0110", "0440");
	}
	return $returncode;
}

sub copyAutoyastKernel
{

	# FOR AUTOYAST
	my ($cmd);
	my ($rc)         = 0;
	my ($returncode) = 0;
	my ($output);
	my ($source_kernel, $yast_kernel);

	my @service_levels = NodeUtils->getServiceLevel(\@targetNodes);
	mkpath("$::TFTPBOOT/csm", $::VERBOSE, 0110);
	NetworkUtils->secureFilePermissions("$::TFTPBOOT/csm", "0110", "0440", 1);
	foreach my $svclevel (@service_levels)
	{
		if ($::DISTRO_VERSION eq '10')
		{
			$source_kernel = $::SUSE_TOP . "/" . $svclevel . "/CD1/boot/$::ARCH/loader/linux";
		}
		else
		{
			$source_kernel = $::SUSE_TOP . "/" . $svclevel . "/boot/loader/linux";
		}
		$yast_kernel   =
		    $::TFTPBOOT . "/csm/" . "yast-"
		  . $::DISTRO_NAME
		  . $::DISTRO_VERSION
		  . "-$svclevel-"
		  . $::ARCH . "z";
		if ($ENV{CSM_USERKERNEL})
		{
			$source_kernel =
			  "$ENV{CSMINSTALL_ROOT}/csm/usrkernel/$ENV{CSM_USERKERNEL}";
		}

		# if the path has already been created then we need to secure it:
		&copyfile($source_kernel, $yast_kernel);
		NetworkUtils->secureFilePermissions($yast_kernel, "0110", "0440");
	}
	return $returncode;
}

sub copySISKernel
{
	my ($returncode) = 0;

	my ($source_kernel) = "/usr/share/systemimager/boot/i386/standard/kernel";
	my ($sis_kernel)    = $::TFTPBOOT . "/csm/sis" . $::DISTRO_VERSION . "z";

	mkpath("$::TFTPBOOT/csm", $::VERBOSE, 0110);
	NetworkUtils->secureFilePermissions("$::TFTPBOOT/csm", "0110", "0440", 1);

	# mkpath can fail to set the mode - so do it explicitly.
	&copyfile($source_kernel, $sis_kernel);
	NetworkUtils->secureFilePermissions($sis_kernel, "0110", "0440");
	return $returncode;
}

sub copyKernel
{

	# Create /tftpboot and set Permissions if not
	if (!-d $::TFTPBOOT)
	{
		mkpath("$::TFTPBOOT");
		NetworkUtils->secureFilePermissions("$::TFTPBOOT", "0110", "0440", 1);
	}

	#for getmac
	#Copy the kernel, ramdisk and pxelinux files needed for MAC address collection
	if ($bootMethod eq 'getmacs' || $bootMethod eq 'getmacssnmp')
	{
		&copyGetmacsKernel;
	}
	elsif ($bootMethod eq 'kickstart' or $bootMethod eq 'kickstart-upgrade')
	{
		&copyKickstartKernel;
	}
	elsif ($bootMethod eq 'autoyast')
	{
		&copyAutoyastKernel;
	}
	elsif ($bootMethod eq 'hwmaint')
	{
		my $hwmaint_flag = 1;
		&copyGetmacsKernel($hwmaint_flag);
	}
	elsif ($bootMethod eq 'sis')
	{
		&copySISKernel();
	}
}

sub copyAndHackPPC64Kernel
{
	# Reload the pkgdefs for nodes
	my %old_pkgdefs    = %::pkgdefs;
	my %nodes_pkgdefs  =
	  ServerUtils->get_pkgdefs('Linux', $::DISTRO_NAME, $::DISTRO_VERSION,
							   $::ARCH, "MgdNode", $::CSM_VERSION);
	%::pkgdefs = %old_pkgdefs;

	# is the tool to modify kernel parameters available?
	my $ks_hack   = 0;
	my $yast_hack = 0;
	# get the is's pkgdefs
	%old_pkgdefs = %::pkgdefs;
	my %is_pkgdefs = ServerUtils->get_pkgdefs();
	%::pkgdefs = %old_pkgdefs;
	if (-x $is_pkgdefs{mkzimage})
	{
		$yast_hack = 1;
	}
	elsif (-x "/usr/bin/mkzimage")
	{
		$ks_hack = 1;
	}

	#colloect all InstallServerAKBNodes
	my @akb_servers = &collectInstallServerAKBServer;

	my $installdir =
	  $ENV{'CSMINSTALL_ROOT'} ? $ENV{'CSMINSTALL_ROOT'} : $::CSMINSTDIR;

	my @service_levels = NodeUtils->getServiceLevel(\@targetNodes);
    my ($effective_distro_name, $effective_distro_ver) =
        NodeUtils->getEffectiveDistro($::DISTRO_NAME, $::DISTRO_VERSION);
         
	if($effective_distro_name =~ /RedHatEL/)
	{    #copy netboot.img from the first CD
		foreach my $svclevel (@service_levels)
		{
			my $my_dirname;
			if ($svclevel eq "GA")
			{
				$my_dirname =
				  $::DISTRO_NAME . $::DISTRO_VERSION . "-" . $::ARCH;
			}
			else
			{
				$my_dirname =
				  $::DISTRO_NAME . $::DISTRO_VERSION . "-" . $svclevel;
			}
			my $source_img = $::REDHAT_TOP . "/" . $my_dirname . "/"
                . $nodes_pkgdefs{'install_image_dir'} . "/"
                . $nodes_pkgdefs{'initrd_file_name'};
			if ($ENV{CSM_USERKERNEL})
			{
				$source_img =
				  "$ENV{CSMINSTALL_ROOT}/csm/usrkernel/$ENV{CSM_USERKERNEL}";
				$ks_hack = 0;
			}

			my $netboot_img =
			    $::TFTPBOOT . "/csm/" . "ks"
			  . $::DISTRO_VERSION
			  . "-$svclevel-ppc64-zImage.initrd";

			mkpath("$::TFTPBOOT/csm", $::VERBOSE, 0110);
			NetworkUtils->setDefaultFilePermission("$::TFTPBOOT/csm", 1);
			&copyfile($source_img, $netboot_img);
			NetworkUtils->setDefaultFilePermission($netboot_img);

			# workround for installing RedHatEL-AS 3 QU1 on a pSeries machine
			if (   ($::DISTRO_NAME eq "RedHatEL-AS")
				&& ($::DISTRO_VERSION eq "3")
				&& ($svclevel         eq "QU1"))
			{
				$ks_hack = 0;
			}

            # rhel4 doesn't hack rhel5 now ...
            if (NodeUtils->get_DistributionVersion lt $::DISTRO_VERSION 
                &&
                $::DISTRO_VERSION eq '5') {
                $ks_hack = 0;
            }

			# Create zImage duplications based on InstallServerAKBNode, and put a front-end into RHEL zImage
			# to pass kernel parameters to kickstart.
			&hackKickstartzImage(         $netboot_img, $svclevel, \@akb_servers,
								 $installdir,  $ks_hack);
		}
		return 0;
	}
	elsif ($effective_distro_name eq 'SLES' && ($effective_distro_ver eq '9' || $effective_distro_ver eq '10'))
	{

		# SLES9 and SLES10 don't have kernel+initrd in kernel rpm for full installation
		# So use install file in the first CD to network install
		foreach my $svclevel (@service_levels)
		{
			my $source_img;
			if ($nodes_pkgdefs{'install_image_dir'} eq "."
				&& defined $nodes_pkgdefs{'sp_disks'})
			{
				my @disks;
				if ($svclevel eq "GA")
				{
					@disks = @{$nodes_pkgdefs{'distro_disks'}};
				}else
				{
					@disks = @{$nodes_pkgdefs{'sp_disks'}{$svclevel}};
				}
				$source_img =
					$::SUSE_TOP . "/" . $svclevel . "/"
					. $disks[0]->{diskid_target}. "/"
					. $nodes_pkgdefs{'initrd_file_name'};
			}
			elsif ($nodes_pkgdefs{'install_image_dir'} eq "suseboot")
			{
			    # sles10
			    my @disks;
			    if ($svclevel eq "GA")
			    {
				@disks = @{$nodes_pkgdefs{'distro_disks'}};
			    }
			    else
			    {
				@disks = @{$nodes_pkgdefs{'sp_disks'}{$svclevel}};
			    }
			    $source_img =
				 $::SUSE_TOP . "/" . $svclevel . "/"
				 . $disks[0]->{diskid_target}. "/"
				 . $nodes_pkgdefs{'install_image_dir'} . "/"
				 . $nodes_pkgdefs{'initrd_file_name'};
			}
			else
			{
				$source_img =
					$::SUSE_TOP . "/" . $svclevel . "/"
					. $nodes_pkgdefs{'install_image_dir'}. "/"
					. $nodes_pkgdefs{'initrd_file_name'};
			}
			my $netboot_img = $::TFTPBOOT
			  . "/csm/yast"
			  . $::DISTRO_VERSION
			  . "-$svclevel-ppc64-zImage.initrd";
			mkpath("$::TFTPBOOT/csm", $::VERBOSE, 0110);
			NetworkUtils->setDefaultFilePermission("$::TFTPBOOT/csm", 1);
			if ($ENV{CSM_USERKERNEL})
			{
				$source_img =
				  "$ENV{CSMINSTALL_ROOT}/csm/usrkernel/$ENV{CSM_USERKERNEL}";
				$yast_hack = 0;
			}
			&copyfile($source_img, $netboot_img);
			NetworkUtils->setDefaultFilePermission($netboot_img);

			# Create zImage duplications based on InstallServerAKBNode, and put built-in kernel
			# parameters into zImage
			&hackAutoyastzImage(         $netboot_img, $svclevel, \@akb_servers,
								$installdir,  $yast_hack);
		}
		return 0;
	}
	else
	{
		foreach my $svclevel (@service_levels)
		{
			my $kerneldir  = $::SUSE_TOP . "/" . $svclevel . "/updates/kernel";
			my $source_rpm =
			  $::SUSE_TOP . "/" . $svclevel . "/$::kernel_path_name";
			my $kernelversion;
			my $detailkernelversion;

			#should always be true
			if ($source_rpm =~ /kernel-ppc64-(2\.4\.\d{2})-(\d+)\.ppc\.rpm/)
			{
				$kernelversion       = $1;
				$detailkernelversion = $2;
			}

			my $cmd =
			  "ls $kerneldir/kernel-ppc64-2.4.??-*.ppc.rpm 2>/dev/null | sort -dr | head -n 1";
			my $kernelrpm = `$cmd`;
			chomp($kernelrpm);

			if ($kernelrpm =~ /kernel-ppc64-(2\.4\.\d{2})-(\d+)\.ppc\.rpm/)
			{
				$source_rpm          = $kernelrpm;
				$kernelversion       = $1;
				$detailkernelversion = $2;
			}

			my $rpmtmpdir = "/tmp/rpmtmp";
			if ($::PLTFRM eq "AIX")
			{
				my @rpmname = split(/\//, $kernelrpm);
				my $kernelrpm_base;
				foreach my $temp (@rpmname)
				{
					if ($temp =~ /\.rpm/)
					{
						$kernelrpm_base = $temp;
					}
				}
				$cmd =
				  "$::RM -rf $rpmtmpdir 1>/dev/null 2>&1 ; mkdir -p $rpmtmpdir 1>/dev/null 2>&1; cp -f $source_rpm $rpmtmpdir 1>/dev/null 2>&1";
				system($cmd);
				my $oldDir = getcwd;
				chdir($rpmtmpdir);
				$cmd =
				  "rpm2cpio $rpmtmpdir/$kernelrpm_base | /opt/freeware/bin/cpio -id 1>/dev/null 2>&1 ";
				system($cmd);
				chdir($oldDir);
			}
			else
			{
				$cmd =
				  "$::RM -rf $rpmtmpdir 1>/dev/null 2>&1 ; mkdir -p $rpmtmpdir/var/lib/rpm 1>/dev/null 2>&1 ; rpm --initdb --root $rpmtmpdir  1>/dev/null 2>&1 ;"
				  . "rpm -i --force --nodeps --ignorearch --root $rpmtmpdir $source_rpm 1>/dev/null 2>&1 ";
				system($cmd);
			}

			my ($source_kernel) =
			  "$rpmtmpdir/boot/zImage.initrd.ppc64-$kernelversion";
			my ($ppc_kernel) = $::TFTPBOOT
			  . "/csm/yast"
			  . $::DISTRO_VERSION
			  . "-$svclevel-ppc64-zImage.initrd";

			my $relPpcKernel =
			  "yast" . $::DISTRO_VERSION . "-$svclevel-ppc64-zImage.initrd";
			my $real_kernel = "$ppc_kernel-$kernelversion-$detailkernelversion";
			my $relRealKernel =
			  "$relPpcKernel-$kernelversion-$detailkernelversion";

			mkpath("$::TFTPBOOT/csm", $::VERBOSE, 0110);
			if ($ENV{CSM_USERKERNEL})
			{
				$source_kernel =
				  "$ENV{CSMINSTALL_ROOT}/csm/usrkernel/$ENV{CSM_USERKERNEL}";
				$yast_hack = 0;
			}
			&copyfile($source_kernel, $real_kernel);

			#unlink $ppc_kernel;
			chdir("$::TFTPBOOT/csm/");
			unlink $relPpcKernel;
			symlink($relRealKernel, $relPpcKernel);
			NetworkUtils->setDefaultFilePermission("$::TFTPBOOT/csm");

			# Create zImage duplications based on InstallServerAKBNode, and put built-in kernel
			# parameters into zImage
			if ($::PLTFRM eq "AIX")
			{
				&hackAutoyastzImage(            $relPpcKernel, $svclevel, \@akb_servers,
									$installdir,   $yast_hack);
			}
			else
			{
				#&hackAutoyastzImage(            $real_kernel, $svclevel, \@akb_servers,
                                #                                               $installdir,  $yast_hack);
                                # generate the zImage file without kernel version in it's name.
                                # If need different kernels for different nodes,
                                # may be install them one by one.
				&hackAutoyastzImage(            $ppc_kernel, $svclevel, \@akb_servers,
                                                                        $installdir,  $yast_hack);
			}
		}
		return 0;
	}
}

sub setAttributes
{
	$::BOOT_ATTRIBUTES{"Netmask"} = $::ATTRS{"Netmask"};
	$::BOOT_ATTRIBUTES{"Gateway"} = $::ATTRS{"Gateway"};
    $::BOOT_ATTRIBUTES{"Nameservers"} = $::ATTRS{"Nameservers"};
	# If netmask is not provided, use the netmask of the management server
	if (!$::BOOT_ATTRIBUTES{"Netmask"})
	{
		my $cmd = $::IFCONFIG;
		$cmd .= " -a" if ($::PLTFRM eq "AIX");
		$cmd = $cmd . "|$::GREP inet";
		my @result = `$cmd`;
		if ($::PLTFRM eq "AIX")
		{
			$result[0] =~ /netmask (\S+)/;
			my $hexmask = $1;
			my $ipmask  = NetworkUtils->hex2dec($hexmask);
			$::BOOT_ATTRIBUTES{"Netmask"} = $ipmask;
		}
		else
		{
			$result[0] =~ /Mask:(\d+.\d+.\d+.\d+)/;
			$::BOOT_ATTRIBUTES{"Netmask"} = $1;
		}
	}

	# If Gateway is not provided, use the gateway of the management server
	if (!$::BOOT_ATTRIBUTES{"Gateway"})
	{
		if ($::PLTFRM eq "AIX")
		{
			$::BOOT_ATTRIBUTES{"Gateway"} =
			  (split(' ', `$::NETSTAT -rn | $::GREP default | $::TAIL -n 1`))
			  [1];
		}
		else
		{
			$::BOOT_ATTRIBUTES{"Gateway"} =
			  (split(' ', `$::NETSTAT -rn | $::GREP 0.0.0.0 | $::TAIL -n 1`))
			  [1];
		}
		chomp $::BOOT_ATTRIBUTES{"Gateway"};
	}

	# If Nameservers is not provided, use the nameservers of the
	# management server
	if (!$::BOOT_ATTRIBUTES{"Nameservers"})
	{
		my $filename = "/etc/resolv.conf";
		if(-f $filename)
		{
			my $nameservers = "";
			open(RESOLV, "<$filename")
		  		|| MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
						   'csminstall', 'E2', 'EMsgCANT_READ_FILE', $filename);

			while (<RESOLV>)
			{
				my $line = $_;
				chomp $line;

				if ($line =~ /^nameserver/i)
				{

					$nameservers .= "," if ($nameservers);
					$nameservers .= (split(' ', $line))[1];
				}
			}
			close(RESOLV);
			$::BOOT_ATTRIBUTES{"Nameservers"} = $nameservers;
			chomp $::BOOT_ATTRIBUTES{"Nameservers"};
		}	
	}

}

#-----------------------------------------------------------------------------------

=head3 copyfile

	Copy file or file list to $dest

	Arguments:
		$src	Source file(s)
		$dest	Target file or directory
		$mod	Target file mode
	Returns:
		1	Error
		0	Success
	Globals:

	Examples:
		copyfile("/var/a /var/b", "/tmp", 0755);

	Comments:
		The file mod cannot be a string and must start with 0
=cut

#----------------------------------------------------------------------------------

sub copyfile
{
	my ($src, $dest, $mod) = @_;
	my @srcfiles = split(/\s+/, $src);
	my $rc       = 0;

	# Cann't copy multi files to a file
	if ((@srcfiles > 1) && (!-d $dest))
	{
		MessageUtils->messageFromCat(
									 'csmInstall.cat',     $::MSGMAPPATH,
									 'csminstall',         'E1',
									 'EMsgNO_FILECOPY_RC', $src,
									 $dest,                1
									);
		return 1;
	}

	MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
								 'V', 'IMsgCOPYING_SRC_DST', $src, $dest);

	foreach my $source (@srcfiles)
	{
		$rc = copy($source, $dest);
		if ($rc == 0)
		{
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
					'csminstall', 'E1', 'EMsgNO_FILECOPY_RC', $src, $dest, $rc);
			return 1;
		}

		# Set the file attribute
		if ($mod)
		{
			if (-f $dest)
			{
				chmod $mod, $dest;
			}
			else
			{

				# Extract the Directory from the name
				my ($file) = $source =~ /\/([^\/]*)$/;
				chmod $mod, $dest . "\/" . $file;
			}
		}
	}
	return 0;
}
#################################################
sub appendStrToFile
{
	my ($str, $dest) = @_;
	open(WRITEFILE, "+<$dest")
	  || MessageUtils->messageFromCat(
									  'csmInstall.cat',      $::MSGMAPPATH,
									  'csminstall',          'E2',
									  'EMsgCANT_WRITE_FILE', $dest
									 );
	seek WRITEFILE, -1, 2;
	print WRITEFILE $str;
	close(WRITEFILE);
}
####################################################
sub appendfile
{
	my ($class, $srcfiles, $dest) = @_;
	my $rc = 0;

	open(WRITEFILE, ">>$dest")
	  || MessageUtils->messageFromCat(
									  'csmInstall.cat',      $::MSGMAPPATH,
									  'csminstall',          'E2',
									  'EMsgCANT_WRITE_FILE', $dest
									 );

	foreach my $src (split(/\s/, $srcfiles))
	{
		MessageUtils->messageFromCat(
									 'csmInstall.cat',        $::MSGMAPPATH,
									 'csminstall',            'V',
									 'IMsgAPPENDING_SRC_DST', $src,
									 $dest
									);
		open(READFILE, "<$src")
		  || MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
								'csminstall', 'E2', 'EMsgCANT_READ_FILE', $src);

		my @context = <READFILE>;
		print WRITEFILE @context;

		close(READFILE);
	}
	close(WRITEFILE);

	return $rc;
}

sub dup_drivers
{

	# dup drivers for different service levels in the nodelist.

	my ($top) = @_;
	my ($cmd, $src_dir, $target_dir, $output, $rc);

	my @service_levels = NodeUtils->getServiceLevel(\@targetNodes);
    my ($effective_distro_name) =
        NodeUtils->getEffectiveDistro($::DISTRO_NAME);

	foreach my $svclevel (@service_levels)
	{
		if ($effective_distro_name =~ /SLES/)
		{
			$target_dir = $top . "/" . $svclevel . "/drivers";
		}
		else
		{
			my $my_dirname;
			if ($svclevel eq "GA")
			{
				$my_dirname =
				  $::DISTRO_NAME . $::DISTRO_VERSION . "-" . $::ARCH;
			}
			else
			{
				$my_dirname =
				  $::DISTRO_NAME . $::DISTRO_VERSION . "-" . $svclevel;
			}
			$target_dir = $top . "/" . $my_dirname . "/drivers";
		}

		my $default_dir = "/csminstall";
		if ($ENV{'CSMINSTALL_ROOT'}) { $default_dir = $ENV{'CSMINSTALL_ROOT'}; }
		$src_dir = "$default_dir/csm/drivers";

		return if ($top eq "");

		if (-d "$target_dir")
		{
			rmtree($target_dir, $::VERBOSE, 1);
		}

		if (-d "$src_dir")
		{
			$cmd    = "$::COPY -rf $src_dir $target_dir";
			$output = NodeUtils->runcmd($cmd, 0);
			$rc     = $::RUNCMD_RC;
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
								  'csminstall', 'I', 'IMsgShow_Output', $output)
			  if ($rc);
		}
	}
}

sub makeKickstartRAMDisk
{

	# If node is provided as an argument, that means to create a specific
	# ramdisk for that node (which is needed for UUID installs).  If node
	# is not specified, create a common ramdisk for each service level.
    my ($node,$ppc_ramdisk) = @_;
	&prepare_mount();

	# for kickstart
	my ($cmd);
	my ($rc)         = 0;
	my ($returncode) = 0;
	my ($output);
	my @nodes;

	if ($node)
	{
		push(@nodes, $node);
	}
	else
	{
		@nodes = @targetNodes;
	}
	my @service_levels = NodeUtils->getServiceLevel(\@nodes);
	my %old_pkgdefs    = %::pkgdefs;
	my %nodes_pkgdefs  =
	  ServerUtils->get_pkgdefs('Linux', $::DISTRO_NAME, $::DISTRO_VERSION,
							   $::ARCH, "MgdNode", $::CSM_VERSION);
	%::pkgdefs = %old_pkgdefs;

    my ($effective_distro_name,$effective_distro_ver) = NodeUtils->getEffectiveDistro($::DISTRO_NAME, $::DISTRO_VERSION);
	foreach my $svclevel (@service_levels)
	{
		my ($host, $nodename, $nodeip);
		if ($node)
		{
			$host = $node;
			if ($nodeHash{$node}{"InstallAdapterHostname"})
			{
				$host = $nodeHash{$node}{"InstallAdapterHostname"};
			}
			($nodename, $nodeip) = NetworkUtils->getHost($host);
		}

		my $my_dirname;
		if ($svclevel eq "GA")
		{
			$my_dirname = $::DISTRO_NAME . $::DISTRO_VERSION . "-" . $::ARCH;
		}
		else
		{
			$my_dirname = $::DISTRO_NAME . $::DISTRO_VERSION . "-" . $svclevel;
		}
		my ($initrd) =
		    $::REDHAT_TOP . "/"
		  . $my_dirname
		  . "/images/pxeboot/initrd-everything.img";
		if (!-f $initrd)
		{
			$initrd =
			  $::REDHAT_TOP . "/" . $my_dirname . "/"
              . $nodes_pkgdefs{'install_image_dir'}. "/"
              . $nodes_pkgdefs{'initrd_file_name'};
		}
        if($ppc_ramdisk){
            $initrd=$ppc_ramdisk;
        }

		my ($ramdisk_basename);
		if ($node)
		{

			# file name of initrd for each being installed using their UUIDs
			# are based on their InstallAdapterHostname
			$ramdisk_basename = "$nodeip";
		}
		else
		{
			$ramdisk_basename = "ks-"
			  . $::DISTRO_NAME
			  . $::DISTRO_VERSION
			  . "-$svclevel-"
			  . $::ARCH;
		}
		my ($ks_ramdisk) = $::TFTPBOOT . "/csm/" . $ramdisk_basename . ".gz";
		if ($ENV{CSM_USERRAMDISK})
		{
			my $userRamdisk =
			  "$ENV{CSMINSTALL_ROOT}/csm/usrkernel/$ENV{CSM_USERRAMDISK}";
			$rc = &copyfile($userRamdisk, $ks_ramdisk);
			NetworkUtils->secureFilePermissions("$ks_ramdisk", "0110", "0440");
			$returncode = $rc if ($rc > $returncode);
			next;
		}
		my $tmpdir = "/tmp/ks" . $::DISTRO_VERSION;    # e.g. /tmp/ks4
		my $kstmp  = "$tmpdir/kstmp";                  # e.g. /tmp/ks4/kstmp
		if (-d $tmpdir)
		{
			NodeUtils->runcmd("$::UMOUNT $kstmp > /dev/null 2>&1", -1);
			rmtree($tmpdir, $::VERBOSE, 1);
		}
		mkpath($tmpdir, $::VERBOSE, 0755);

		#-------------------------------------------------
		# Unzip the ramdisk
		#-------------------------------------------------
		my $ramdisk = "$tmpdir/tmp_$ramdisk_basename";    # /tmp/ks4/tmp_ks
		$cmd    = "$::GUNZIP -c $initrd > $ramdisk";
		$output = NodeUtils->runcmd($cmd, 0);
		$rc     = $::RUNCMD_RC;
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'I', 'IMsgShow_Output',
									 $output)
		  if ($rc);
		$returncode = $rc if ($rc > $returncode);

		#-------------------------------------------------
		# Mount the ramdisk to kstmp so it can be modified
		#-------------------------------------------------
		mkpath($kstmp, $::VERBOSE, 0755);
        if ($effective_distro_ver >= 5)
        {
            $cmd = "(cd $kstmp;cpio -id --quiet < $ramdisk)";
        }
        else
        {
            $cmd    = "$::MOUNT -o loop $ramdisk $kstmp";
        }
		$output = NodeUtils->runcmd($cmd, 0);
		$rc     = $::RUNCMD_RC;
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'I', 'IMsgShow_Output',
									 $output)
		  if ($rc);
		$returncode = $rc if ($rc > $returncode);


		#-------------------------------------------------
		# Copy a terminfo file onto the ramdisk
		#-------------------------------------------------
		mkpath("$kstmp/etc/terminfo/x", $::VERBOSE, 0755);
		mkpath("$kstmp/etc/terminfo/v", $::VERBOSE, 0755);
		$rc =
		  &copyfile("/usr/share/terminfo/x/xterm",
					"$kstmp/etc/terminfo/v/vt100");
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'I', 'IMsgShow_Output',
									 $output)
		  if ($rc);
		$returncode = $rc if ($rc > $returncode);

		#-------------------------------------------------
		# Copy kickstart file to initrd for each node being
		# installed based on their UUID
		#-------------------------------------------------
		if ($node)
		{
			my $ksfile_src =
			  $ksmapHash{$node}{ksdir} . "/" . $ksmapHash{$node}{ksfile};
			my $ksfile_tgt = $kstmp . "/ks";
			&copyfile($ksfile_src, $ksfile_tgt);
		}

		#-------------------------------------------------
		# Insert the drivers into the ramdisk
		#-------------------------------------------------

		my $kernel_level = "";
		$::FIND = "/usr/bin/find";

		# Copy the modules.cgz file to a temporary location
		&copyfile("$kstmp/modules/modules.cgz", "$tmpdir/modules.cgz");

		# Unpack the modules.cgz file
		$cmd = "cd $tmpdir; $::GUNZIP -c modules.cgz | $::CPIO -id 2>/dev/null";
		$output = NodeUtils->runcmd($cmd, 0);

		# Determine the kernel level used in the modules.cgz.
		$cmd = "cd $tmpdir; $::LS -d [0-9]*";
		$output = NodeUtils->runcmd($cmd, 0);
		chomp $output;
		if (-d "$tmpdir/$output")
		{
			$kernel_level = $output;
		}

		my $DIR_ARCH = $nodes_pkgdefs{'kernel_arch_dir'}{$svclevel};
        if (!$DIR_ARCH)
        {
            $DIR_ARCH = $nodes_pkgdefs{'kernel_arch_dir'}{'default'};
        }

		# foreach directory in "/opt/csm/install/drivers/$kernel_level"
		my (@driver_list, @pcitable_list, @modinfo_list, @dep_list);
		my $csm_moduledir;
		if (  -d $::REDHAT_TOP . "/"
			. $my_dirname
			. "/drivers/$kernel_level/$DIR_ARCH")
		{
			$csm_moduledir =
			    $::REDHAT_TOP . "/"
			  . $my_dirname
			  . "/drivers/$kernel_level/$DIR_ARCH";
		}
		else
		{
			$csm_moduledir =
			  $::REDHAT_TOP . "/" . $my_dirname . "/drivers/$kernel_level";
		}

		#linux 2.4, driver files are "*.o"
		#linux 2.6, driver files are "*.ko"
		my $suffix;
		if ($kernel_level =~ /^2\.6/)
		{
			$suffix = "ko";
		}
		else
		{
			$suffix = "o";
		}
		if (-d "$csm_moduledir")
		{

			# deal with each driver module
			$cmd = "cd $csm_moduledir; $::LS *.$suffix";
			my @output = NodeUtils->runcmd("$cmd", -1);
			# If user put some drivers into here,
			# Enlarge the size of initrd avoid less ramdisk size.
			# For pSeries, installnode --noreboot will be forbidden,
			# since we have no chance passing kernel parameter (ramdisk_size)
			# into install kernel but the default size is too small to run.
			# If there will not any drivers needed to update for the specific 
			# kernel version, we don't enlarge the size of initrd.It is much safer.
			
			if ($::RUNCMD_RC ==0
				&& $effective_distro_name =~ /RedHat/  && $effective_distro_ver < 5)
			{
					#-------------------------------------------------
					# Create a new ramdisk to avoid less ramdisk size
					#-------------------------------------------------
					my $newtmpdir = "/tmp/newks" . $::DISTRO_VERSION; # e.g. /tmp/newks4
					my $newkstmp = "$newtmpdir/kstmp";    # e.g. /tmp/newks4/kstmp
					NodeUtils->runcmd("$::UMOUNT $newkstmp > /dev/null 2>&1", -1);
					if (-d $newtmpdir)
					{
							rmtree($newtmpdir, $::VERBOSE, 1);
					}
					mkpath($newtmpdir, $::VERBOSE, 0755);
					mkpath($newkstmp,  $::VERBOSE, 0755);
					my $rdsize = $nodes_pkgdefs{'ramdisk_size'};
					my $chk    =
						`$::DD if=/dev/zero of=$newtmpdir/tmp_$ramdisk_basename bs=1k count=$rdsize 2>/dev/null`;
					if ($chk)
					{
							MessageUtils->message('E', 'EMsgCMD_FAILED_RC', "dd", $chk);
							exit 1;
					}
					NodeUtils->runcmd(
									"$::MKE2FS -qFm0 $newtmpdir/tmp_$ramdisk_basename $rdsize");
					NodeUtils->runcmd(
									"$::MOUNT -o loop $newtmpdir/tmp_$ramdisk_basename $newkstmp");
					# Copy the entire tmpdir content
					NodeUtils->runcmd("$::COPY -rf $tmpdir/* $newtmpdir/");
                    # for using on sles10 ...
					NodeUtils->runcmd("$::COPY -r --remove-destination $kstmp/* $newkstmp/");
					
					&copyfile("$kstmp/.buildstamp $kstmp/.profile", $newkstmp);

					#-------------------------------------------------
					# Remove the old ramdisk and directory
					# Replace the them into new ramdisk and directory
					#-------------------------------------------------
					NodeUtils->runcmd("$::UMOUNT $kstmp > /dev/null 2>&1");
					rmtree($tmpdir, $::VERBOSE, 1);
					$tmpdir  = $newtmpdir;
					$kstmp   = $newkstmp;
					$ramdisk =
							"$tmpdir/tmp_$ramdisk_basename"
							;    # /newtmp/ks4/tmp_ks4/tmp_ks-RedHatEL-AS4-GA-i386
					if ($::ARCH =~ /ppc/)
					{
						MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'I', 'IMsgNoRebootSupport4KS'
									 ,$::DISTRO_NAME
									. $::DISTRO_VERSION
   					                . "-$svclevel-"
   					                . $DIR_ARCH,"$::CSMINSTALL_ROOT/csm/drivers/$kernel_level/$DIR_ARCH"
									 );
					}
			}
			goto ks_modules_not_found if ($::RUNCMD_RC != 0);

			foreach my $driver (@output)
			{
				push(@driver_list, "$csm_moduledir/$driver")
				  if (-f "$csm_moduledir/$driver");
			}

			# deal with each module_info & dep & pcitable file
			$cmd = "cd $csm_moduledir; $::LS *.module-info";
			@output = NodeUtils->runcmd("$cmd", -1);
			goto ks_modules_not_found if ($::RUNCMD_RC != 0);

			foreach my $info (@output)
			{
				my ($prefix, undef) = split(/\./, $info);

				my $pcitable = "$csm_moduledir/$prefix.pcitable";
				push(@pcitable_list, $pcitable) if (-f $pcitable);

				my $modinfo = "$csm_moduledir/$prefix.module-info";
				push(@modinfo_list, $modinfo) if (-f $modinfo);

				my $dep = "$csm_moduledir/$prefix.dep";
				push(@dep_list, $dep) if (-f $dep);
			}

		}

	  ks_modules_not_found:

		# Insert the modules into the modules.cgz
		if (scalar(@driver_list) > 0)
		{
			if (-d "$tmpdir/$kernel_level/$DIR_ARCH")
			{
				&copyfile(join(' ', @driver_list),
						  "$tmpdir/$kernel_level/$DIR_ARCH");
			}
			else
			{
				&copyfile(join(' ', @driver_list), "$tmpdir/$kernel_level");
			}
		}

		# Remove FAStT modules from the modules.cgz
		if (-d "$tmpdir/$kernel_level/$DIR_ARCH")
		{
			unlink <$tmpdir/$kernel_level/$DIR_ARCH/qla*.$suffix>;
			unlink <$tmpdir/$kernel_level/$DIR_ARCH/lpfc.$suffix>;
		}
		else
		{
			unlink <$tmpdir/$kernel_level/qla*.$suffix>;
			unlink <$tmpdir/$kernel_level/lpfc.$suffix>;
		}

		# Repack the modules.cgz file
		$cmd =
		    "cd $tmpdir; $::FIND $kernel_level -type f -print | "
		  . "$::CPIO -o -H crc 2>/dev/null | "
		  . "$::GZIP -c -9 > $tmpdir/modules.cgz";
		$output = NodeUtils->runcmd($cmd, 0);

		# Copy modules.cgz back into the ramdisk
		&copyfile("$tmpdir/modules.cgz", "$kstmp/modules/modules.cgz");

		# Add modules' entries to module-info and pcitable
		if (($#pcitable_list + 1) > 0)
		{
			NodesetUtils->appendfile(join(' ', @pcitable_list), "$kstmp/modules/pcitable");
		}

        # do special actions for the modules
        NodesetUtils->updateDriver(
                \@driver_list,
                $::DISTRO_NAME,
                $::DISTRO_VERSION,
                $svclevel,
                $kernel_level,
                $::ARCH,
                $tmpdir
                );

		if (($#modinfo_list + 1) > 0)
		{
			NodesetUtils->appendfile(join(' ', @modinfo_list), "$kstmp/modules/module-info");
		}

		if (($#dep_list + 1) > 0)
		{
			NodesetUtils->appendfile(join(' ', @dep_list), "$kstmp/modules/modules.dep");
		}

		# Copy the drivers into /tmp on the ramdisk to fix a possible bug.
		if (($#driver_list + 1) > 0)
		{
			&copyfile(join(' ', @driver_list), "$kstmp/tmp");
		}

		#-------------------------------------------------
		# Unmount the ramdisk
		#-------------------------------------------------
        if ($effective_distro_ver >= 5)
        {
            $cmd = "(cd $kstmp;find . -print | $::CPIO -H newc -o > $ramdisk)";
        }
        else
        {
            $cmd    = "$::UNMOUNT $kstmp";
        }
		$output = NodeUtils->runcmd($cmd, 0);
		$rc     = $::RUNCMD_RC;
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'I', 'IMsgShow_Output',
									 $output)
		  if ($rc);
		$returncode = $rc if ($rc > $returncode);

		#-------------------------------------------------
		# Zip up the ramdisk into <distro_version>.gz (e.g. ks7.3.gz)
		#-------------------------------------------------
		$cmd    = "$::GZIP -f $ramdisk >/dev/null 2>&1";
		$output = NodeUtils->runcmd($cmd, 0);
		$rc     = $::RUNCMD_RC;
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'I', 'IMsgShow_Output',
									 $output)
		  if ($rc);
		$returncode = $rc if ($rc > $returncode);

		# Copy the new ramdisk to /tftpboot
		if($ppc_ramdisk){
			&copyfile("$ramdisk.gz", $ppc_ramdisk);
		}
		else{
			&copyfile("$ramdisk.gz", $ks_ramdisk);
			NetworkUtils->secureFilePermissions("$ks_ramdisk", "0110", "0440");
		}

		# Clean up the temporary directory
		rmtree($tmpdir, $::VERBOSE, 1);
	}

	return $returncode;
}

#-----------------------------------------------------------------------------------
# makeGetmacsRAMDisk copy initrd from /csminstall/... directory and add displaymac, ifconfig and its dependent
# libraries to these initrds, it calls makeAutoyastRAMDisk() for SLES and makeKickstartRAMDisk() for
# Redhat&Redhat EL
# Input:   $::TOP_DIR ------ set in file pxeboot_mac
#-----------------------------------------------------------------------------------
sub makeGetmacsRAMDisk()
{
	my $hwmaint_flag = shift;
	my $node         = shift;

	my @service_levels;
	my ($nodename, $nodeip, $ramdisk);

	if ($node)
	{
		my $host = $node;
		if ($nodeHash{$node}{"InstallAdapterHostname"})
		{
			$host = $nodeHash{$node}{"InstallAdapterHostname"};
		}
		($nodename, $nodeip) = NetworkUtils->getHost($host);
		my @nodes = ($node);
		@service_levels = NodeUtils->getServiceLevel(\@nodes);

	}
	else
	{
		@service_levels = NodeUtils->getServiceLevel(\@targetNodes);
	}

    my ($effective_distro_name) =
        NodeUtils->getEffectiveDistro($::DISTRO_NAME);
	foreach my $svclevel (@service_levels)
	{

		# make kickstart or autoyast ramdisk
		if ($effective_distro_name =~ /RedHat/)
		{
			&dup_drivers($::REDHAT_TOP);
			&makeKickstartRAMDisk($node);
		}
		else
		{
			&dup_drivers($::SUSE_TOP);
			&makeAutoyastRAMDisk($node);
		}

		# get ks/autoyast ramdisk file location
		if ($node)
		{
			$ramdisk = $::TFTPBOOT . "/csm/" . $nodeip . ".gz";
		}
		else
		{
			my $prefix = $effective_distro_name =~ /RedHat/ ? "ks" : "yast";
			my $ramdisk_base =
			    $prefix . "-"
			  . $::DISTRO_NAME
			  . $::DISTRO_VERSION . "-"
			  . $svclevel . "-"
			  . $::ARCH;
			$ramdisk = $::TFTPBOOT . "/csm/" . $ramdisk_base . ".gz";
		}

		# get ks/yast stage2 ramdisk file location
		my $sl_dir;
		if ($effective_distro_name =~ /SLES/)
		{
			$sl_dir = $svclevel;
		}
		elsif ($effective_distro_name =~ /RedHat/ && $svclevel eq 'GA')
		{
			$sl_dir = $::DISTRO_NAME . $::DISTRO_VERSION . "-" . $::ARCH;
		}
		else
		{
			$sl_dir = $::DISTRO_NAME . $::DISTRO_VERSION . "-" . $svclevel;
		}
		my $stage2_rd = 
            $::DISTRO_NAME =~ /RedHat/ && $::DISTRO_VERSION >= 5
                ? "$::TOP_DIR/$sl_dir/images/stage2.img" 
            : $::DISTRO_NAME =~ /RedHat/ 
                ? "$::TOP_DIR/$sl_dir/RedHat/base/stage2.img" 
            : $::DISTRO_VERSION eq '10' 
                ? "$::TOP_DIR/$sl_dir/CD1/boot/$::ARCH/root" # only for GA now
		    : 
                "$::TOP_DIR/$sl_dir/boot/root";

		# get getmacs ramdisk file location
		my $dst_ramdisk;
		if ($hwmaint_flag)
		{
			if ($node)
			{
				$dst_ramdisk = $::TFTPBOOT . "/csm/" . "hm-$nodeip.gz";
			}
			else
			{
				my $distro_name = &abbreviateDistroName($::DISTRO_NAME);
				if ($::ARCH eq "x86_64")
				{
					$dst_ramdisk =
					  $::TFTPBOOT . "/csm/"
					  . "hm-$distro_name$::DISTRO_VERSION$svclevel" . "E.gz";
				}
				else
				{
					$dst_ramdisk =
					  $::TFTPBOOT . "/csm/"
					  . "hm-$distro_name$::DISTRO_VERSION$svclevel.gz";
				}
			}
		}
		else
		{
			$dst_ramdisk =
			  $::TFTPBOOT . "/csm/"
			  . "getmac-$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH.gz";
		}

		# make a ramdisk for getmacs
		&newGetmacsRAMDisk($ramdisk, $stage2_rd, $dst_ramdisk, $hwmaint_flag,
						   $svclevel);
	}
}

$::SLESRAMDISKSIZE   = 25364;
$::REDHATRAMDISKSIZE = 32768;

sub getGetmacsRAMDiskSize
{

	if (defined($::pkgdefs{'getmacs_RamDiskSize'}))
	{
		return $::pkgdefs{'getmacs_RamDiskSize'};
	}

	my $rdsize;
    my ($effective_distro_name) =
        NodeUtils->getEffectiveDistro($::DISTRO_NAME);

	if ($effective_distro_name =~ /SLES/)
	{
		$rdsize = $::SLESRAMDISKSIZE;
	}
	else
	{
		$rdsize = $::REDHATRAMDISKSIZE;
	}
	return $rdsize;
}

sub getRAMDiskSize
{
	if (defined($::pkgdefs{'ramdisk_size'}))
	{
		return $::pkgdefs{'ramdisk_size'};
	}

    my ($effective_distro_name) =
        NodeUtils->getEffectiveDistro($::DISTRO_NAME);
	if ($effective_distro_name =~ /SLES/)
	{
		return $::SLESRAMDISKSIZE;
	}
	else
	{
		return $::REDHATRAMDISKSIZE;
	}
}

sub extractRPMAndCopyFile
{
	my ($svclevel, $rpm, $file, $target) = @_;

	# 1. find gawk-*.rpm
	my $csmserver =
	  $ENV{'CSMINSTALL_ROOT'} ? $ENV{'CSMINSTALL_ROOT'} : $::CSMINSTDIR;

	my $pkgs_basedir;
    my ($effective_distro_name) =
        NodeUtils->getEffectiveDistro($::DISTRO_NAME);

	if ($effective_distro_name =~ /RedHat/)
	{
		if ($svclevel ne "GA")
		{
			$pkgs_basedir =
			    $csmserver . "/Linux"
			  . "/$::DISTRO_NAME"
			  . "/$::DISTRO_VERSION"
			  . "/$::ARCH"
			  . "/$::DISTRO_NAME$::DISTRO_VERSION-$svclevel"
			  . "/RPMS/";
		}
		else
		{
			$pkgs_basedir =
			    $csmserver . "/Linux"
			  . "/$::DISTRO_NAME"
			  . "/$::DISTRO_VERSION"
			  . "/$::ARCH"
			  . "/$::DISTRO_NAME$::DISTRO_VERSION-$::ARCH"
			  . "/RPMS/";
		}
	}
	else
	{
		$pkgs_basedir =
		    $csmserver . "/Linux"
		  . "/$::DISTRO_NAME"
		  . "/$::DISTRO_VERSION"
		  . "/$::ARCH"
		  . "/$svclevel"
		  . "/RPMS/";
	}

	# This subroutine can accpect both the RPM name and Rpm object.
	$::FIND = "/usr/bin/find";
	my $k_pkg;
	my $need_to_find = 1;
	if ( ref( $rpm) =~ /Rpm/)
	{
		my $shortname = $rpm->getShortName();
		my @filelist = `$::FIND $pkgs_basedir -name "$shortname*"`;
		chomp(@filelist);
		if ($rpm->searchHighestVersionInFileList(\@filelist, $pkgs_basedir, 1))
		{
			$k_pkg = $rpm->getFullPath();
			$need_to_find = 0;
		}
		else
		{
			# Can not find the highest version, what happened?
			# This should not happen, unless you specified
			# a wrong Rpm definition in the pkgdefs
			# We have to use the original search prog
			$rpm = $rpm->getRpmDetails();
			$need_to_find = 1;
		}
		
	}
	if ($need_to_find)
	{
		my $cmd = "$::FIND $pkgs_basedir -name \"$rpm*\"";
		my @filelist = NodeUtils->runcmd($cmd, -1);
		if ($::RUNCMD_RC)
		{
			MessageUtils->messageFromCat(
										 'csmInstall.cat', $::MSGMAPPATH,
										 'csminstall',     'I',
										 'IMsgShow_Output', join('\n', @filelist)
										);
			return $::RUNCMD_RC;
		}
		$k_pkg = $filelist[0];
	}

	#2. extract gawk-*.rpm
	my $extract_dir = "/tmp/extract";
	if (-d $extract_dir)
	{
		rmtree($extract_dir, $::VERBOSE, 1);
	}
	mkpath($extract_dir, $::VERBOSE, 0755);

	my $cmd = "cd $extract_dir; $::RPM2CPIO $k_pkg | cpio -idu --quiet;";
	my $output = NodeUtils->runcmd($cmd, -1);
	if ($::RUNCMD_RC)
	{
		rmtree($extract_dir, $::VERBOSE, 1);
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'I', 'IMsgShow_Output',
									 $output);
		return $::RUNCMD_RC;
	}

	#3. copy "awk" to target dir
	&copyfile("$extract_dir/$file", $target, 0755);

	#4. clean up
	rmtree($extract_dir, $::VERBOSE, 1);
}

sub newGetmacsRAMDisk
{
	my ($discgz, $stage2_rd, $dst_ramdisk, $hwmaint_flag, $svclevel) = @_;
	my $WORKDIR = "/tmp/getmacs";

	my %old_pkgdefs    = %::pkgdefs;
	my %nodes_pkgdefs  =
	  ServerUtils->get_pkgdefs('Linux', $::DISTRO_NAME, $::DISTRO_VERSION,
							   $::ARCH, "MgdNode", $::CSM_VERSION);
    my %ms_pkgdefs     = ServerUtils->get_pkgdefs();
	%::pkgdefs = %old_pkgdefs;

    my $lib = "";

	if (-d $WORKDIR)
	{
		NodeUtils->runcmd("$::UMOUNT $WORKDIR/discgz > /dev/null 2>&1",   -1);
		NodeUtils->runcmd("$::UMOUNT $WORKDIR/getmacgz > /dev/null 2>&1", -1);
		NodeUtils->runcmd("$::UMOUNT $WORKDIR/stage2gz > /dev/null 2>&1", -1);
		rmtree($WORKDIR, $::VERBOSE, 1);
	}
	NodeUtils->runcmd("$::MKDIR -p $WORKDIR");
	MessageUtils->message('V', 'IMsgCREATE_GMRD');
	NodeUtils->runcmd("$::MKDIR -p $WORKDIR/discgz");
	NodeUtils->runcmd("$::MKDIR -p $WORKDIR/getmacgz");
	NodeUtils->runcmd("$::MKDIR -p $WORKDIR/stage2gz");
	NodeUtils->runcmd("$::GZIP -d -c $discgz > $WORKDIR/discrd");

	my ($effective_distro_name, $effective_distro_ver) =
            NodeUtils->getEffectiveDistro($::DISTRO_NAME, $::DISTRO_VERSION);

	# make a new getmacs ramdisk
	if (($effective_distro_name eq 'SLES' && $effective_distro_ver eq '10')
        || ($effective_distro_name =~ /RedHatEL/ && $effective_distro_ver >=
            5))
	{
	    #NodeUtils->runcmd("(cd $WORKDIR/discgz;$::CPIO -id < $WORKDIR/discrd)");
	    # dump every items of initrd to the getmacsgz
	    NodeUtils->runcmd("(cd $WORKDIR/getmacgz;$::CPIO -id < $WORKDIR/discrd)");
	}
	else
	{
		my $rdsize = &getGetmacsRAMDiskSize();
		my $chk    =
		  `$::DD if=/dev/zero of=$WORKDIR/tmp_getmac_gz bs=1k count=$rdsize 2>/dev/null`;
		if ($chk)
		{
			MessageUtils->message('E1', 'EMsgCMD_FAILED_RC', "dd", $chk);
		}
		NodeUtils->runcmd("$::MKE2FS -qFm0 $WORKDIR/tmp_getmac_gz $rdsize");
		NodeUtils->runcmd("$::MOUNT -o loop $WORKDIR/tmp_getmac_gz $WORKDIR/getmacgz");
		NodeUtils->runcmd("$::MOUNT -o loop $WORKDIR/discrd $WORKDIR/discgz");
	}
    if ($effective_distro_name =~ /RedHatEL/ && $effective_distro_ver >= 5) {
        NodeUtils->runcmd("$::MOUNT -t squashfs -o loop $stage2_rd $WORKDIR/stage2gz");
    }
    else {
        NodeUtils->runcmd("$::MOUNT -o loop $stage2_rd $WORKDIR/stage2gz");
    }

	# first copy $WORKDIR/discgz/** to $WORKDIR/getmacgz and make lib directory
	my @dirs = (@{$nodes_pkgdefs{getmacs_DirStructure}});
	foreach my $dir (@dirs)
	{
		NodeUtils->runcmd("$::COPY -rf $WORKDIR/discgz/$dir $WORKDIR/getmacgz");
	}
	if ($hwmaint_flag)
	{
		my $ks = "$WORKDIR/discgz/ks";
		if (-f $ks)
		{
			NodeUtils->runcmd("$::COPY -p $ks $WORKDIR/getmacgz");
		}

		my $info = "$WORKDIR/discgz/info";
		if (-f $info)
		{
			NodeUtils->runcmd("$::COPY -p $info $WORKDIR/getmacgz");
		}

		NodeUtils->runcmd(
			"$::COPY -p /opt/csm/install/hwmaint_linuxrc.tmpl $WORKDIR/getmacgz/hmrc");
		chmod 0755, "$WORKDIR/getmacgz/hmrc";
		NodeUtils->runcmd(
			   "$::COPY -p /opt/csm/install/invoker $WORKDIR/getmacgz/invoker");
		chmod 0755, "$WORKDIR/getmacgz/invoker";
 
         # 'init' replace the 'linuxrc'. but hmrc call 'linuxrc'.
 	    if ($effective_distro_name =~ /SLES/ && $effective_distro_ver eq '10'
             ||
             $effective_distro_name =~ /RedHat/i && $effective_distro_ver ge '5'
             )
 	    {
 	    	NodeUtils->runcmd("mv $WORKDIR/getmacgz/init $WORKDIR/getmacgz/linuxrc");
 	    	NodeUtils->runcmd("(cd $WORKDIR/getmacgz;$::LN -s hmrc init)");
 	    }
	}
	else
	{
		my $dispmac = "$WORKDIR/getmacgz/displaymac";
		NodeUtils->runcmd(
						"$::COPY -p $::TEMPLATES_DIR/displaymac.tmpl $dispmac");

		# replace TIMER with the proper value.
		my $timeout = 30;
		if ($ENV{'GETADAPTERS_TIMEOUT'})
		{
			$timeout = $ENV{'GETADAPTERS_TIMEOUT'};
		}
		`perl -pi -e "s/#ENV:TIMEOUT#/$timeout/g" $dispmac`;

		chmod 0755, $dispmac;
 
         # 'init' replace the 'linuxrc'. but displaymac call 'linuxrc'.
 	    if ($effective_distro_name =~ /SLES/ && $effective_distro_ver eq '10'
             ||
             $effective_distro_name =~ /RedHat/i && $effective_distro_ver ge '5')
 
 	    {
 	    	NodeUtils->runcmd("mv $WORKDIR/getmacgz/init $WORKDIR/getmacgz/linuxrc");
 	    	NodeUtils->runcmd("(cd $WORKDIR/getmacgz;$::LN -s displaymac init)");
 	    }
  	}
	
	my $libpath = $nodes_pkgdefs{getmacs_Lib};
	if (defined($libpath))
	{
		if (!-d "$WORKDIR/getmacgz/$libpath")
		{
			mkdir("$WORKDIR/getmacgz/$libpath");
		}
	}

	# second copy getmacs ramdisk files and libraries
	my @files = (@{$nodes_pkgdefs{getmacs_ReqLibs}});
	if (scalar(@files))
	{
		foreach my $file (@files)
		{
			NodeUtils->runcmd(
				"$::COPY -rfL $WORKDIR/stage2gz/$file $WORKDIR/getmacgz/$libpath");
		}
	}
	@files = (@{$nodes_pkgdefs{getmacs_Exec}});
	foreach my $file (@files)
	{
		NodeUtils->runcmd(
				   "$::COPY -rf $WORKDIR/stage2gz/$file $WORKDIR/getmacgz/bin");
	}
	my $cwd = getcwd();

	# create the mountpoint at the root of the ramdisk
	#
	chdir("$WORKDIR/getmacgz");
	NodeUtils->runcmd("$::MKDIR -p mnt");

	chdir("$WORKDIR/getmacgz/bin");

	# remove any existing link so the new one may be created
	#
	unlink "sh";
	symlink "bash", "sh";
	chdir("$cwd");

	# Copy additional lib and binaries for hwmaint
	if ($hwmaint_flag)
	{

		# Create the directory for the UpdateXpress log file.  In debug mode we can examine
		# this log at the shell prompt.  Also prevents an error message from
		# being displayed
		#
		NodeUtils->runcmd("$::MKDIR -p $WORKDIR/getmacgz/boot/uxlog");

		my @hw_libs = (@{$nodes_pkgdefs{hwmaint_ReqLibs}});
		foreach my $file (@hw_libs)
		{
			NodeUtils->runcmd(
				"$::COPY -rfL $WORKDIR/stage2gz/$file $WORKDIR/getmacgz/$libpath");
		}

		if ($::ARCH eq "x86_64")
		{
			my @hw_libs32 = (@{$nodes_pkgdefs{hwmaint_ReqLibs32}});
			if (!-d "$WORKDIR/getmacgz/lib")
			{
				mkdir("$WORKDIR/getmacgz/lib");
			}
			foreach my $file (@hw_libs32)
			{
				NodeUtils->runcmd("$::COPY -rfL $file $WORKDIR/getmacgz/lib");
			}
		}

		my @hw_bins = (@{$nodes_pkgdefs{hwmaint_Exec}});
		foreach my $file (@hw_bins)
		{
			NodeUtils->runcmd(
				   "$::COPY -rf $WORKDIR/stage2gz/$file $WORKDIR/getmacgz/bin");
		}

		# The stage2 ramdisk shipped with RedHat does not include "awk" utility, so
		# extract the "awk" from rpm package and then copy it into the ramdisk
		if ($effective_distro_name =~ /RedHat/)
		{
			&extractRPMAndCopyFile($svclevel, "gawk", "/usr/bin/awk",
								   "$WORKDIR/getmacgz/bin");
		}

		my @rmt_libs = (@{$ms_pkgdefs{preinstall_libs}});
		if (!-d "$::CSMINSTALL_ROOT/csm/lib")
		{
			NodeUtils->runcmd("$::MKDIR -p $::CSMINSTALL_ROOT/csm/lib");
		}
		foreach my $file (@rmt_libs)
		{
			NodeUtils->runcmd("$::COPY -rfL $file $::CSMINSTALL_ROOT/csm/lib");
		}

        if (!-d "$WORKDIR/getmacgz/lib64")
        {
            mkdir("$WORKDIR/getmacgz/lib64");
        }

        # Check if there are any required libraries that need to be manually copied
        # into the ramdisk.
        #
        my $rd_dest;
        if( exists( $nodes_pkgdefs{ hwmaint_ReqLibsFromRPM } ) )
        {
            foreach my $lib_key( sort keys %{ $nodes_pkgdefs{ hwmaint_ReqLibsFromRPM } } )
            {
                # 64-bit libraries go into the /lib64 directory of the ramdisk
                #
                if( $lib_key =~ /.+lib64\// )
                {
                    $rd_dest = "$WORKDIR/getmacgz/lib64";
                }
                else
                {
                    $rd_dest = "$WORKDIR/getmacgz/lib";
                }

                # See if there's a specific destination name for the library.  If so,
                # use it.  This may occur if the source RPM does not provide the necessary
                # symbolic link for the destination, and we need to specify a different
                # name for the target.
                #
                my $split_count = split /::/, $lib_key, 2;

                if( $split_count == 2 ) {
                    my @split_result = split /::/, $lib_key, 2;
                    $lib = $split_result[ 0 ];
                    $rd_dest = $rd_dest . "/" . $split_result[ 1 ];
                } else {
                    $lib = $lib_key;
                }

                &extractRPMAndCopyFile(
                                       $svclevel,
                                       $nodes_pkgdefs{ hwmaint_ReqLibsFromRPM }{ $lib_key },
                                       $lib,
                                       $rd_dest
                                      );
            }
        }

		# The hwmaint ramdisk also needs the portmap program and supporting libraries.  portmap
		# and the libs are already on the SLES stage2 ramdisk, but portmap is not part of the
		# RH stage2 ramdisk and must be extracted from the rpm.  The libs are contained within
		# the RH stage2 ramdisk and can be copied directly.
		#
		my $portmap_rpm;
		if ($effective_distro_name =~ /RedHat/)
		{
			if ($::ARCH eq "x86_64")
			{
				$portmap_rpm = "portmap-*.x86_64";
			}
			else
			{
				$portmap_rpm = "portmap-*.i386";
			}

			&extractRPMAndCopyFile($svclevel, $portmap_rpm, "/sbin/portmap",
								   "$WORKDIR/getmacgz/bin");
		}

		my @hwm_execs = (@{$nodes_pkgdefs{preinstall_execs}});
		foreach my $file (@hwm_execs)
		{
			&copyfile("$file", "$::CSMINSTALL_ROOT/csm/", 0755);
		}
	}

	# third for Redhat the above first step will create dev directory, but for SLES it will not.
	# so we need to create dev directory with the following steps. (SLES's initrd contains too many    # dev files, we can't just use cp and tar to do this job)
	if (!-d "$WORKDIR/getmacgz/dev")
	{
		mkdir("$WORKDIR/getmacgz/dev");
		if ($effective_distro_name =~ /RedHat/)
		{
			NodeUtils->runcmd(
				"$::TAR cf - -C $WORKDIR/discgz/dev . | $::TAR xvf - -C $WORKDIR/getmacgz/dev"
			);
		}
		else
		{

			# this is the SLES case
			NodeUtils->runcmd(
						  "$::MKNOD -m600 $WORKDIR/getmacgz/dev/console c 5 1");
			NodeUtils->runcmd(
							 "$::MKNOD -m640 $WORKDIR/getmacgz/dev/kmem c 1 2");
			NodeUtils->runcmd("$::CHGRP kmem $WORKDIR/getmacgz/dev/kmem");
			NodeUtils->runcmd("$::MKNOD -m640 $WORKDIR/getmacgz/dev/mem c 1 1");
			NodeUtils->runcmd("$::CHGRP kmem $WORKDIR/getmacgz/dev/mem");
			NodeUtils->runcmd(
							 "$::MKNOD -m666 $WORKDIR/getmacgz/dev/null c 1 3");
			NodeUtils->runcmd("$::MKNOD -m640 $WORKDIR/getmacgz/dev/ram b 1 1");
			NodeUtils->runcmd("$::CHGRP disk $WORKDIR/getmacgz/dev/ram");
			NodeUtils->runcmd(
							 "$::MKNOD -m600 $WORKDIR/getmacgz/dev/tty1 c 4 1");
			NodeUtils->runcmd(
							 "$::MKNOD -m600 $WORKDIR/getmacgz/dev/tty2 c 4 2");
			NodeUtils->runcmd(
							 "$::MKNOD -m600 $WORKDIR/getmacgz/dev/tty3 c 4 3");
			NodeUtils->runcmd(
						   "$::MKNOD -m644 $WORKDIR/getmacgz/dev/ttyS0 c 4 64");
			NodeUtils->runcmd(
						   "$::MKNOD -m644 $WORKDIR/getmacgz/dev/ttyS1 c 4 65");
			NodeUtils->runcmd("$::MKDIR -p $WORKDIR/getmacgz/sbin");

			if (!$effective_distro_ver =~ /9/)
			{
				if (-f "$WORKDIR/stage2gz/sbin/modprobe")
				{
					&copyfile("$WORKDIR/stage2gz/sbin/modprobe",
							  "$WORKDIR/getmacgz/sbin", 0755);
				}
			}
		}
	}

	if (($effective_distro_name =~ /SLES/ && $effective_distro_ver eq '10')
        || ($effective_distro_name =~ /RedHatEL/ && $effective_distro_ver >=
            5))
	{
		NodeUtils->runcmd("$::UMOUNT $WORKDIR/stage2gz > /dev/null 2>&1", -1);
		NodeUtils->runcmd("(cd $WORKDIR/getmacgz;find . -print|$::CPIO -H newc -o > $WORKDIR/tmp_getmac_gz)");
	}
	else
	{
		NodeUtils->runcmd("$::UMOUNT $WORKDIR/discgz > /dev/null 2>&1",   -1);
		NodeUtils->runcmd("$::UMOUNT $WORKDIR/getmacgz > /dev/null 2>&1", -1);
		NodeUtils->runcmd("$::UMOUNT $WORKDIR/stage2gz > /dev/null 2>&1", -1);
	}

	# last copy $WORKDIR/tmp_getmac_gz to $dst_ramdisk
	NodeUtils->runcmd("$::GZIP $WORKDIR/tmp_getmac_gz");
	&copyfile("$WORKDIR/tmp_getmac_gz.gz", $dst_ramdisk);
	if (-d $WORKDIR)
	{
		rmtree($WORKDIR, $::VERBOSE, 1);
	}
	NetworkUtils->secureFilePermissions("$dst_ramdisk", "0110", "0440");
}

sub makeRAMDisk
{
	if ($bootMethod eq 'getmacs' || $bootMethod eq 'getmacssnmp')
	{
		my $hwmaint_flag = 0;
		&makeGetmacsRAMDisk($hwmaint_flag);
	}
	elsif ($bootMethod eq 'kickstart' or $bootMethod eq 'kickstart-upgrade')
	{
		my $commonRAMDisk = 0;
		&dup_drivers($::REDHAT_TOP);
		foreach my $node (@targetNodes)
		{
			if (!$nodeHash{$node}{InstallAdapterMacaddr}
				&& $nodeHash{$node}{UUID})
			{
				&makeKickstartRAMDisk($node);
			}
			else
			{
				++$commonRAMDisk;
			}
		}
		if ($commonRAMDisk)
		{
			&makeKickstartRAMDisk;
		}
	}
	elsif ($bootMethod eq 'autoyast')
	{
		my $commonRAMDisk = 0;
		&dup_drivers($::SUSE_TOP);
		foreach my $node (@targetNodes)
		{
			if (!$nodeHash{$node}{InstallAdapterMacaddr}
				&& $nodeHash{$node}{UUID})
			{
				&makeAutoyastRAMDisk($node);
			}
			else
			{
				++$commonRAMDisk;
			}
		}
		if ($commonRAMDisk)
		{
			&makeAutoyastRAMDisk;
		}

		#&copyDrivers();	# Maybe we'll need to do this
	}
	elsif ($bootMethod eq 'hwmaint')
	{
		my $hwmaint_flag  = 1;
		my $commonRAMDisk = 0;
		foreach my $node (@targetNodes)
		{
			if (!$nodeHash{$node}{InstallAdapterMacaddr}
				&& $nodeHash{$node}{UUID})
			{
				&makeGetmacsRAMDisk($hwmaint_flag, $node);
			}
			else
			{
				++$commonRAMDisk;
			}
		}
		if ($commonRAMDisk)
		{
			&makeGetmacsRAMDisk($hwmaint_flag);
		}
	}
	elsif ($bootMethod eq 'sis')
	{
		&makeSISRAMDisk();
	}
	elsif ($bootMethod eq 'warewulf')

	{
		&dup_drivers($::TOP_DIR);
		&makeWarewulfRAMDisk();
	}
	
}

sub makeWarewulfRAMDisk
{
		#print "Building VNFS image...\n";
		if (!$ENV{'SKIP_BUILDING_VNFSIMAGE'})
		{
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,'csminstall', 'I', 'IMsgBuildVNFSImage');
		}

		my @servicelevels = NodeUtils->getServiceLevel(\@targetNodes);
        foreach my $svclevel (@servicelevels)
		{
    		#---------------------------------------------------------------
			# Since we setup vnfs according to each servicelevel,
			# we set $DisklessNodeGroupName by default value
			# Note: vnfs and vnfs image(tarball) are two concepts.
			# vnfs ties with service level, 
			# vnfs image ties with diskless node group name. 
			#---------------------------------------------------------------
			my $DisklessNodeGroupName = "$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH";
	        my $vnfs_repo = NodeUtils->GetVnfsDIRFromWarewulf();#"$::CSMINSTALL_ROOT/diskless/vnfs/$DisklessNodeGroupName";
			$vnfs_repo = $vnfs_repo . "/$DisklessNodeGroupName";

			if (!NodeUtils->isAIX())
			{
				# Make sure the destination directory exists
				if (!-d "$vnfs_repo/opt/csm/install/")
				{ 
					mkpath("$vnfs_repo/opt/csm/install/", $::VERBOSE, 0755); 
				}

				NodeUtils->runcmd("$::COPY -f $::CSMINSTALL_ROOT/csm/makedisklessnode $vnfs_repo/opt/csm/install/makedisklessnode");
			}
            #create some specific devices file:/dev/null /dev/random /dev/urandom 
			#                                  /dev/MAKEDEV /dev/log /dev/isdnctrl /dev/initctl
			if ( ! -d "$vnfs_repo/dev" )
			{
				mkpath("$vnfs_repo/dev", $::VERBOSE, 0755);
			}
			#Because rsync or rdist can't sync some device files, so we tar them and untar them for syncing files to install server.
			if ($::DISTRO_NAME eq "SLES")
            { 
				#Untar "/dev" directory
				if (-e "$vnfs_repo/dev.tar.gz")
				{
            		NodeUtils->runcmd("$::TAR zxvf $vnfs_repo/dev.tar.gz -C $vnfs_repo",-2);
				}
			}
			if ( ! -c "$vnfs_repo/dev/random" )  
			{
				NodeUtils->runcmd("/bin/mknod $vnfs_repo/dev/random c 1 8");
			}
			if ( ! -c "$vnfs_repo/dev/urandom" )
			{
				NodeUtils->runcmd("/bin/mknod $vnfs_repo/dev/urandom c 1 9");
			}
			if ( ! -c "$vnfs_repo/dev/null" )
			{
				NodeUtils->runcmd("/bin/mknod $vnfs_repo/dev/null c 1 3");	
			}
			NodeUtils->runcmd("chown root.sys $vnfs_repo/dev/random $vnfs_repo/dev/urandom");
			#NodeUtils->runcmd("/bin/mknod $vnfs_repo/dev/null c 1 3");
			# For these files can be read by non-root account,
			# change files permission. 
            NodeUtils->runcmd("chmod 0666 $vnfs_repo/dev/random $vnfs_repo/dev/urandom $vnfs_repo/dev/null");
            NodeUtils->runcmd("ln -fs ../sbin/MAKEDEV $vnfs_repo/dev/MAKEDEV");
			NodeUtils->runcmd("ln -fs isdnctrl0 $vnfs_repo//dev/isdnctrl");
			if ( ! -S "$vnfs_repo/dev/log" )
			{
				NodeUtils->runcmd("/usr/sbin/mksock $vnfs_repo/dev/log");
			}
			NodeUtils->runcmd("chmod 0755 $vnfs_repo/dev/log");
			if ( ! -p "$vnfs_repo/dev/initctl" )
			{
				NodeUtils->runcmd("/usr/bin/mkfifo $vnfs_repo/dev/initctl");
		    }
			NodeUtils->runcmd("chmod 0600 $vnfs_repo/dev/initctl");
			#remove "/var/tmp/*" for buildiing VNFS"
			rmtree("/var/tmp/*",$::VERBOSE,1);
			#Secure shadow file in VNFS
            NetworkUtils->secureFilePermissions("$vnfs_repo/$DisklessNodeGroupName/etc/shadow", "0110", "0644");
			
			# Run disklessprebuild scripts customer provided
			# We have define scriptlist in  $::DISKLESSPREBUILDSCRIPTSFORVNFS{$svclevel}.
			# These scripts can customize the specified VNFS
    		#  The data directory where additional user provided scripts
    		#    and data files will be located.
    		if (!$::SKIP_VNFS_BUILD)
			{
					$ENV{'SCRIPTDATAPATH'} = "$::CSMCLIENTMNTDIR/csm/scripts/data";

					foreach my $name (@{$::DISKLESSPREBUILDSCRIPTSFORVNFS{$svclevel}})
					{

							# cd to the directory of the users cust script in case they
							#   use a relative path to get to the data directory.
							my $cmd = "cd $::CSMINSTALL_ROOT/csm/scripts/disklessprebuild; ./$name";
							my $output = NodeUtils->runcmd($cmd, 0);
							if ($::RUNCMD_RC)
							{
									MessageUtils->message('E', 'EMsgCANT_RUN', $cmd, $::RUNCMD_RC);
							}
							else
							{
									MessageUtils->message('I', 'IMsgShow_Output', $output);
							}
					}
			}

			#execute "/usr/sbin/wwmkinitrd" for creating kernel and initial ramdisk in "/tftpboot" directory
			my ( $distro_name_IS, $distro_ver_IS, $distro_svc_level_IS, $distro_arch_IS)
				= NodeUtils->getDistroAndSvcLevel;

			my $kernel_version_ww;
			my $kernel_ww;
			
			# Kernel name in different distribution and servicelevel under /boot
			# RedHat X: vmlinuz* P:vmlinuz*
				 
			if (!$ENV{'SKIP_BUILDING_VNFSIMAGE'})
			{
				if ($distro_name_IS =~ /SLES/)
				{
					my $linkname;
					$linkname = $distro_arch_IS =~ /ppc64/ ? "vmlinux":"vmlinuz";
					$kernel_version_ww = `cd $vnfs_repo/boot;readlink $linkname`;
					$kernel_ww = "$vnfs_repo/boot/$kernel_version_ww";
					$kernel_version_ww =~ s/$linkname-//g;
				}
				else
				{
					# Select smp kernel firstly. So sort -r
					$kernel_version_ww = `cd $vnfs_repo/boot;$::LS vmlinuz* | sort -r | head -n 1`;
					$kernel_ww = "$vnfs_repo/boot/$kernel_version_ww";
					$kernel_version_ww =~ s/vmlinuz-//g;
				}
				chomp($kernel_version_ww);
				chomp($kernel_ww);
			}

			# If the disklessnode and IS have the same distribution and servicelevel,
			# use default wwmkinitrd command. 
			# If user don't take patch to wwmkinitrd, it also can work for 
			# disklessnode and IS homologous. 
			
			if ($DisklessNodeGroupName eq "$distro_name_IS$distro_ver_IS-$distro_svc_level_IS-$distro_arch_IS")
			{
				print "Running default wwmkinitrd command.\n" if $::DEBUG;
				NodeUtils->runcmd("/usr/sbin/wwmkinitrd", -2);
			}
			else
			{		
            	print "Running hacked wwmkinitrd command.Please make sure pactch taken.\n" if $::DEBUG;	
				NodeUtils->runcmd("cd $vnfs_repo;/usr/sbin/wwmkinitrd ".
					  "--kernel $kernel_ww ".
					  "--moduledir ./lib/modules/$kernel_version_ww/ ".
					  "$kernel_version_ww", -2);
			}
			# Convert ext2 file system block size from 1024 into 4096.
			# Because default blocksize has become 4096 bytes in RHEL5 kernel.
			# However warewulf create initrd always with 1024 bytes block size.
			# We can add boot parameters ramdisk_blocksize=1024 to work around this issue.
			# But to avoid boot parameters beyond the limited length in some p series machine,
			# CSM will convert warewulf initrd block size into default value (4096).
			
			if ($distro_name_IS =~ /RedHat/ && $distro_ver_IS >= 5 && $distro_arch_IS =~/ppc64/)
			{
				&convertext2fs("/tftpboot/wwinitrd.img",4096);
			}

			# Copy drivers into VNFS and initrd
			# In this release, warewulf extract some modules from Management Server's /lib/modules 
			# and /boot directory accoring to /etc/warewulf/wwinitrd.config file,
			# maybe in the future we should make kernel and initrd from CDs 
			# by wwmkinitrd --kernel --moduledir option. So far, there are some defects in this command. 
			# I don't know whether it works well if specify kernel and module directory.
			# (e.g. it command can't handle with full-path moduledir)
			# Perhaps in the next release, warewulf will fix this defect.
			
			&hackWarewulfimg("/tftpboot/wwinitrd.img",$svclevel,"$vnfs_repo");

 			if (!-d "/tftpboot/csm")
			{
				 mkpath("/tftpboot/csm", $::VERBOSE, 0755);
			}
			# Change kernel and initrd name of CSM def.And move them into "/tftpboot/csm" directory.
			# Make sure the destination file don't exist.
			unlink("/tftpboot/csm/$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH"."z");
			unlink("/tftpboot/csm/ww-$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH.gz");
			# Change kernel name into standard name.
			my $tftp_kernel = "kernel";
			my $kernel_ww_basename;
			if ($kernel_ww)
			{
				$kernel_ww_basename = `basename $kernel_ww`;
			}
			else
			{
				$kernel_ww_basename = `uname -r`;
			}
			chomp($kernel_ww_basename);
			if ($DisklessNodeGroupName ne "$distro_name_IS$distro_ver_IS-$distro_svc_level_IS-$distro_arch_IS") 
			{
				NodeUtils->runcmd("$::MV -f /tftpboot/$kernel_ww_basename /tftpboot/$tftp_kernel ",-2);
			}
			NodeUtils->runcmd("$::CP -f /tftpboot/$tftp_kernel /tftpboot/csm/".
								"$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH"."z"
								,-2);
			NodeUtils->runcmd("$::CP -f /tftpboot/wwinitrd.img /tftpboot/csm/".
							   "ww-$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH.gz"	
								,-2);
            # Set owner and group name to tftpd. 
			NodeUtils->runcmd("$::CHOWN tftpd /tftpboot/csm/$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH"."z" , -2);
			
			NodeUtils->runcmd("$::CHGRP tftpd /tftpboot/csm/$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH"."z" , -2);
			
			NodeUtils->runcmd("$::CHOWN tftpd /tftpboot/csm/ww-$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH.gz" , -2);
			NodeUtils->runcmd("$::CHGRP tftpd /tftpboot/csm/ww-$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH.gz" , -2);
			#Change zimage name
			$::WAREWULF_ZIMAGE_FILLE ="/tftpboot/csm/ww-zimage-$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH";

            if ($distro_arch_IS eq "ppc64" )
			{
				if ($distro_name_IS eq "SLES")
				{
					#Make zimage for pseries SLES netboot. 
            		if ($distro_ver_IS eq '9')
					{
						NodeUtils->runcmd("/lib/lilo/chrp/chrp64/addRamdisk.sh /tmp/ppc_lilo /tftpboot/$tftp_kernel" . 
                 		             	  "  /tftpboot/wwinitrd.img $::WAREWULF_ZIMAGE_FILLE");
					}
					else
					{
							NodeUtils->runcmd("/bin/mkzimage --vmlinux /tftpboot/$tftp_kernel" . 
                 		             	      "  --initrd /tftpboot/wwinitrd.img ".
											  " --output $::WAREWULF_ZIMAGE_FILLE".
											  " --tmp /tmp");
					} 
           			#Set owner and group of zimage file.
            		NodeUtils->runcmd("$::CHOWN tftpd $::WAREWULF_ZIMAGE_FILLE" , -2);
            		NodeUtils->runcmd("$::CHGRP tftpd $::WAREWULF_ZIMAGE_FILLE" , -2);
				}
				elsif ($distro_name_IS =~ /RedHat/)
				{
					#Make zimage for RedHat netboot.
					my $stubfile;
					if ($ENV{'SKIP_BUILDING_VNFSIMAGE'})
					{
						my $kversion = `uname -r`;
						$stubfile = `find /boot -name "*zImage.stub-$kversion" | head -n1`;
					}
					else
					{
						# Before RedHatEL5, stub file locate at /boot
						# In RedHat5, stub file locate at /usr/share/ppc64-utils/ and belongs to ppc64-utils package
						if ($distro_ver_IS >= 5)
						{
							$stubfile = "$vnfs_repo/.$::pkgdefs{'zImage.stub'}";
						}
						else
						{
							$stubfile = `find $vnfs_repo/boot -name "zImage.stub-$kernel_version_ww" | head -n1`;
						}
					}
                    chomp($stubfile);                   
                    NodeUtils->runcmd("mkzimage /tftpboot/$tftp_kernel no no /tftpboot/wwinitrd.img $stubfile".
									" $::WAREWULF_ZIMAGE_FILLE");
					#Set owner and group of zimage file.
					NodeUtils->runcmd("$::CHOWN tftpd $::WAREWULF_ZIMAGE_FILLE" , -2);
					NodeUtils->runcmd("$::CHGRP tftpd $::WAREWULF_ZIMAGE_FILLE" , -2);
				} 
			}
            #Make sure /tftpboot/pxelinux.cfg directory exist. It is justified by wwinit --exports
            if (!-d "/tftpboot/pxelinux.cfg")
            {
				mkpath("/tftpboot/pxelinux.cfg", $::VERBOSE, 0755);
            }
			# Clean up useless files under /tftpboot
			unlink </tftpboot/kernel-*>;
			unlink </tftpboot/vmlinu*>;

         }
		 
		 #--------------------------------------------------------------------------------
		 # Build VNFS image (tarball) for each diskless node group
		 #--------------------------------------------------------------------------------

		 foreach my $node (@targetNodes)
		 {
				#----------------------------------------------------
				# Get warewulf diskless group name from the node's 
				# InstallTemplate attribute.
				# If InstallTemplate is blank, we use 
				# $::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH as 
				# default name. 
				#----------------------------------------------------
				my $svclevel = NodeUtils->getNodeServiceLevel($node);
				my $DisklessNodeGroupName = $nodeHash{$node}{"InstallTemplate"}; 
				$DisklessNodeGroupName = `basename $DisklessNodeGroupName`
						if ($DisklessNodeGroupName ne "");
				$DisklessNodeGroupName =~ s/^.*warewulf-tmpl\.//g; 
				chomp($DisklessNodeGroupName);
				$DisklessNodeGroupName = "$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH"
						 if ($DisklessNodeGroupName eq "");

				# Do not create VNFS image for the same diskless node group more than one time
				if ($::ALREADYVNFSIMAGE{$DisklessNodeGroupName})
				{
					next;
				}
				if (!$ENV{'SKIP_BUILDING_VNFSIMAGE'})
				{
					# Get DisklessType from config file
					# Set global variable $::DisklessType value.
					NodeUtils->GetDisklessType($DisklessNodeGroupName);

					#-------------------------------------------------------
					# Get vnfs directory from /etc/warewulf/nodes/<NODEGRP>/config file
					#-------------------------------------------------------
					my $vnfs_repo = NodeUtils->GetVnfsDIRFromWarewulf();
					$vnfs_repo = $vnfs_repo . "/$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH";

					#Set symbol link "/vnfs" to VNFSDIR for hybrid situation.
				    my $linkvnfs = NodeUtils->GetVnfsDIRFromWarewulf();
					if ($::DisklessType eq "hybrid")
					{
						 # If vnfs directory is "/vnfs" fitly,
						 # It is not necessary to create symbol link.
						 if ($linkvnfs eq "/vnfs")
						 {
								 unlink "$vnfs_repo/vnfs";
								 mkpath("$vnfs_repo/vnfs", $::VERBOSE, 0755);
						 }
						 else
						 {
								 NodeUtils->runcmd("chroot $vnfs_repo ln -fs $linkvnfs /vnfs");
						 }
				}
				else
				{
						 unlink "$vnfs_repo/vnfs";
				}
				
				#--------------------------------------------------------
				# Create symbol link to default VNFS 
				# e.g. ln -fs ./Compute ./SLES9-SP3-ppc64   
				#--------------------------------------------------------
				if ($DisklessNodeGroupName ne "$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH")
				{
					unlink "$linkvnfs/$DisklessNodeGroupName";
					#symlink "$linkvnfs/$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH","$linkvnfs/$DisklessNodeGroupName"; 
					NodeUtils->runcmd("cd $linkvnfs;$::LN -fs ./$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH ./$DisklessNodeGroupName",-2);
				}
				# DisklessType attribute is defined in nodegroup configuration file.
				# If DisklessType =hybrid, build the hybrid diskless boot image.
				# If DisklessType =ramdisk, build a non-hybrid diskless boot image.
				if ($::DisklessType eq "hybrid")
				{
						NodeUtils->runcmd("wwvnfs --vnfs $DisklessNodeGroupName --build --hybrid " .
										"--excludes \ $::WAREWULF_DEPLOY_DIR" ."vnfs/"."$::WAREWULF_VNFS_EXCLUDES_AGGRESSIVE_TMPL." .
										$DisklessNodeGroupName .
										" --includes \ $::WAREWULF_DEPLOY_DIR" ."vnfs/"."$::WAREWULF_VNFS_INCLUDES_TMPL.".
										$DisklessNodeGroupName);
				}
				else
				{
						NodeUtils->runcmd("wwvnfs --vnfs $DisklessNodeGroupName --build  " .
										"--excludes \ $::WAREWULF_DEPLOY_DIR" ."vnfs/"."$::WAREWULF_VNFS_EXCLUDES_TMPL." .
										$DisklessNodeGroupName .
										" --includes \ $::WAREWULF_DEPLOY_DIR" ."vnfs/"."$::WAREWULF_VNFS_INCLUDES_TMPL.".
										$DisklessNodeGroupName);

				}
			}
				#copy "/usr/lib/warewulf/wwinitrc" to "/srv/vnfs/DisklessGroupName/wwinitrc"
				NodeUtils->runcmd("$::COPY -f /usr/lib/warewulf/wwinitrc /srv/vnfs/$DisklessNodeGroupName/wwinitrc"); 
				#Create synctree.tar.gz for VNFS.
				if (!$ENV{'SKIP_BUILDING_VNFSIMAGE'})
				{
					NodeUtils->runcmd("wwnodes --sync --nonodes",-2);
				}
				#---------------------------------------------------------
				# If user defines diskless node group, copy synctree.tar.gz from 
				# default directory ($::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH)
				# into $DisklessNodeGroupName directory.
				if ($DisklessNodeGroupName ne "$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH")
				{
					NodeUtils->runcmd("$::CP -f /srv/vnfs/$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH/synctree.tar.gz /srv/vnfs/$DisklessNodeGroupName/synctree.tar.gz",-2);
				}
				$::ALREADYVNFSIMAGE{$DisklessNodeGroupName} = 1;
			
		 }	
		 undef %::ALREADYVNFSIMAGE;

}

sub makeAutoyastRAMDisk
{

	# If node is provided as an argument, that means to create a specific
	# ramdisk for that node (which is needed for UUID installs).  If node
	# is not specified, create a common ramdisk for each service level.
	my ($node, $ppc_ramdisk) = @_;
	&prepare_mount();

	my ($cmd);
	my ($rc) = 0;
	my ($output);
	my ($returncode) = 0;
	my @nodes;

	if ($node)
	{
		push(@nodes, $node);
	}
	else
	{
		@nodes = @targetNodes;
	}
	my @service_levels = NodeUtils->getServiceLevel(\@nodes);

	my %old_pkgdefs    = %::pkgdefs;
	my %nodes_pkgdefs  =
	  ServerUtils->get_pkgdefs('Linux', $::DISTRO_NAME, $::DISTRO_VERSION,
							   $::ARCH, "MgdNode", $::CSM_VERSION);
	%::pkgdefs = %old_pkgdefs;

	foreach my $svclevel (@service_levels)
	{
		my ($host, $nodename, $nodeip);
		if ($node)
		{
			$host = $node;
			if ($nodeHash{$node}{"InstallAdapterHostname"})
			{
				$host = $nodeHash{$node}{"InstallAdapterHostname"};
			}
			($nodename, $nodeip) = NetworkUtils->getHost($host);
		}

		my $initrd;
		if ($::DISTRO_VERSION eq '10')
		{
			$initrd = "$::SUSE_TOP/$svclevel/CD1/boot/$::ARCH/loader/initrd";
		}
		else
		{
			$initrd = "$::SUSE_TOP/$svclevel/boot/loader/initrd";
		}

		if($ppc_ramdisk){
			$initrd=$ppc_ramdisk;
		}

		my ($ramdisk_basename);
		if ($node)
		{

			# file name of initrd for each being installed using their UUIDs
			# are based on their InstallAdapterHostname
			$ramdisk_basename = "$nodeip";
		}
		else
		{
			$ramdisk_basename = "yast-"
			  . $::DISTRO_NAME
			  . $::DISTRO_VERSION
			  . "-$svclevel-"
			  . $::ARCH;
		}
		my ($yast_ramdisk) = $::TFTPBOOT . "/csm/" . $ramdisk_basename . ".gz";
		if ($ENV{CSM_USERRAMDISK})
		{
			my $userRamdisk =
			  "$ENV{CSMINSTALL_ROOT}/csm/usrkernel/$ENV{CSM_USERRAMDISK}";
			$rc = &copyfile($userRamdisk, $yast_ramdisk);
			NetworkUtils->secureFilePermissions("$yast_ramdisk", "0110",
												"0440");
			$returncode = $rc if ($rc > $returncode);
			next;
		}

		# e.g. /tftpboot/csm/yast-SLES8.1-i386.gz

		&copyfile("$initrd", $yast_ramdisk) if ! $ppc_ramdisk;
		# Just quit for now until we determine if there is anything that needs to
		# go into the ramdisk (drivers, etc.).
		# Maybe there is something that can be added to the ramdisk that will
		# allow rconsole to work during install (termcap?).
		# Some of this code can be copied from makeKickstartRAMDisk.

		#ywbegin
		# Need to add drivers ( bcm5700 ) for x335.
		# Copy some code from makeKickstartRAMDisk
		my $tmpdir = "/tmp/yast"
		  . $::DISTRO_VERSION
		  . "-$svclevel";    # e.g. /tmp/yast8.1-SP3
		if (-d $tmpdir)
		{
			rmtree($tmpdir, $::VERBOSE, 1);
		}
		mkpath($tmpdir, $::VERBOSE, 0755);

		#-------------------------------------------------
		# Unzip the ramdisk
		#-------------------------------------------------
		my $ramdisk = "$tmpdir/$ramdisk_basename";

		# e.g. /tmp/yast8.1/yast-SLES8.1-i386
		$cmd = "$::GUNZIP --quiet -c $initrd > $ramdisk";

		# There is a trailing grabage issue ( rc=2 ) when gunzip the initrd file.
		# Don't post any error message for the time being.
		$output = NodeUtils->runcmd($cmd, -1);
		$rc = $::RUNCMD_RC;
		if ($rc != 2 && $rc > 0)
		{
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
								 'csminstall', 'I', 'IMsgShow_Output', $output);
			$returncode = $rc;
		}

		#-------------------------------------------------
		# Mount the ramdisk to yasttmp so it can be modified
		#-------------------------------------------------
		my $yasttmp = "/tmp/yast" . $::DISTRO_VERSION . "-$svclevel" . "/yasttmp";
		$yasttmp = NodesetUtils->unpack_ramdisk( $ramdisk, $nodes_pkgdefs{'ramdisk_format'}, $yasttmp);

		#create a new ramdisk for ppc64 nodes         
		if($ppc_ramdisk && $::DISTRO_NAME =~ /SLES/ && $::DISTRO_VERSION eq '9'){     
				#-------------------------------------------------                                         
				# Create a new ramdisk to avoid less ramdisk size                                          
				#-------------------------------------------------                                         
				my $newtmpdir = "/tmp/newyast" . $::DISTRO_VERSION . "-$svclevel"; # e.g. /tmp/newyast9  
				my $newyasttmp = "$newtmpdir/yasttmp";    # e.g. /tmp/newyast9/yasttmp                     
				NodeUtils->runcmd("$::UMOUNT $newyasttmp > /dev/null 2>&1", -1);                           
				if (-d $newtmpdir)                                                                         
				{                                                                                          
					rmtree($newtmpdir, $::VERBOSE, 1);                                                 
				}                                                                                          
				mkpath($newtmpdir, $::VERBOSE, 0755);                                                      
				mkpath($newyasttmp,  $::VERBOSE, 0755);                                                    
				my $rdsize = $nodes_pkgdefs{'ramdisk_size'};                                               
				my $chk    =                                                                               
					`$::DD if=/dev/zero of=$newtmpdir/tmp_$ramdisk_basename bs=1k count=$rdsize 2>/dev/null`;
				if ($chk)                                                                                  
				{                                                                                          
					MessageUtils->message('E', 'EMsgCMD_FAILED_RC', "dd", $chk);                       
					exit 1;                                                                            
				}                                                                                          
				NodeUtils->runcmd("$::MKE2FS -qFm0 $newtmpdir/tmp_$ramdisk_basename $rdsize");               
				NodeUtils->runcmd("$::MOUNT -o loop $newtmpdir/tmp_$ramdisk_basename $newyasttmp");
				NodeUtils->runcmd("$::COPY -rf $yasttmp/* $newyasttmp/");       
				#-------------------------------------------------    
				# Remove the old ramdisk and directory                                              
				# Replace the them into new ramdisk and directory                                   
				#-------------------------------------------------                                  
				NodeUtils->runcmd("$::UMOUNT $yasttmp > /dev/null 2>&1");                           
				rmtree($tmpdir, $::VERBOSE, 1);                                                     
				$tmpdir  = $newtmpdir;                                                              
				$yasttmp   = $newyasttmp;                                                           
				$ramdisk = "$tmpdir/tmp_$ramdisk_basename"; # /newtmp/ks4/tmp_ks4/tmp_ks-RedHatEL-AS4-GA-i386
		}   
		#-------------------------------------------------
		# Create new "info" file in the ramdisk
		#-------------------------------------------------
		my $info = "$yasttmp/info";
		open(INFOFILE, ">$info")
		  || MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
							  'csminstall', 'E2', 'EMsgCANT_WRITE_FILE', $info);
		if (($::DISTRO_VERSION eq "8" || $::DISTRO_VERSION =~ /^8\.\d/)
			&& $::DISTRO_NAME eq "SLES")
		{
			print INFOFILE "Insmod: bcm5700" . "\n";
			print INFOFILE "Insmod: mptscsih" . "\n";
		}

		# SLES 10 can not use root-path of dhcp to find the install
		# source. Use info to specify the install source.
		if ($::DISTRO_VERSION >= 10 && $::DISTRO_NAME =~ /SLES/ && !$node)
		{
		    my ($nd, $is_addr, $inst_mod);
		    ($nd) = @nodes;
		    $is_addr = NetworkUtils->get_source_ip_to_target($nd);
		    $inst_mod = NodesetUtils->get_NetworkInstallProtocol();

		    if ($inst_mod =~ /http/i)
		    {
			print INFOFILE "Install: http://$is_addr/$::SUSE_TOP/$svclevel/CD1/" . "\n";
		    }
		    elsif ($inst_mod =~ /nfs/i)
		    {
			print INFOFILE "Install: nfs://$is_addr/$::SUSE_TOP/$svclevel/CD1/" . "\n";
		    }
		}

		# put the related parameters into ramdisk:/linuxrc.config for
		# '--noreboot' on ppc64. this would replace the using of mkzimage_cmdline
		# to make the parameters passed from rconsole overwrite the parameters
		# written into zimage.
		if ($ppc_ramdisk)
		{
		    my $config = "$yasttmp/linuxrc.config";

		    open (CONFIGFILE, ">>$config")
		    || MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 
			'csminstall', 'E2', 'EMsgCANT_WRITE_FILE', $config);

		    my $is_addr = NetworkUtils->get_source_ip_to_target($nodes[0]);
		    my $inst_mod = NodesetUtils->get_NetworkInstallProtocol();
		    my $installdir = $ENV{'CSMINSTALL_ROOT'} ? $ENV{'CSMINSTALL_ROOT'} : $::CSMINSTDIR;

		    if ($inst_mod =~ /nfs/i)
		    {
			print CONFIGFILE "AutoYaST: nfs://$is_addr/$installdir/csm/" . $::DISTRO_NAME . $::DISTRO_VERSION . "/" . "\n";
		    }
		    elsif ($inst_mod =~ /http/i)
		    {
			print CONFIGFILE "AutoYaST: http://$is_addr/$installdir/csm" . $::DISTRO_NAME . $::DISTRO_VERSION . "/" . "\n";
		    }

		    if (   ($::KERNEL_VERSION > 19)
			|| ($::DETAIL_KERNEL_VERSION > 215)
			|| ($::DISTRO_VERSION >= 9))
		    {
			print CONFIGFILE "DHCPTimeout: 150" . "\n";
		    }

		    close CONFIGFILE;
		}

		if ($node)
		{
			if ($nodeHash{$node}{InstallDistributionVersion} >= 9)
			{
				print INFOFILE "HostIP: $nodeip\n";
			}
			else
			{
				print INFOFILE "IP: $nodeip\n";
			}
			my ($node_bc, $node_mask) = NetworkUtils->getNetmask($nodeip);
			if ($node_mask)
			{
				print INFOFILE "Netmask: $node_mask\n";
			}
			my $nameservers = $::ATTRS{"Nameservers"};
			if ($nameservers)
			{
				print INFOFILE "Nameserver: $nameservers\n";
			}
			my $gateway =
			  NetworkUtils->validate_ip(
									 $nodeHash{$node}{'InstallAdapterGateway'});
			if ($gateway == -1)
			{
				$gateway = $::BOOT_ATTRIBUTES{"Gateway"};
			}
			if ($gateway)
			{
				my ($gw_bc, $gw_mask) = NetworkUtils->getNetmask($gateway);
				if($gw_bc ne $node_bc)
				{
					# the gateway and the node are not in the same subnet,
					# this will cause problems for UUID install.
					# use the node's own IP instead.
					print INFOFILE "Gateway: $nodeip\n";
				
				}
				else
				{
					print INFOFILE "Gateway: $gateway\n";
				}	
			}
			if ($nodeHash{$node}{InstallAdapterName})
			{
				print INFOFILE "Netdevice: $nodeHash{$node}{InstallAdapterName}\n";
			}

			my $install_protocol = NodesetUtils->get_NetworkInstallProtocol();

			# Add the Install Source location. But do not put the Install Source to the info
			# file when http install method meets blade targets
			if (   $nodeHash{$node}{"IsBlade"} =~ /yes/i
				&& $install_protocol =~ /http/i)
			{

				# todo
			}
			else
			{
				if (   $ksmapHash{$node}{nfsdir}
					&& $ksmapHash{$node}{nfssvr})
				{
					print INFOFILE
					  "Install: ${install_protocol}://$ksmapHash{$node}{nfssvr}/$ksmapHash{$node}{nfsdir}\n";
				}
			}

			# Add the yastcfg.xml file location
			if (   $ksmapHash{$node}{ksdir}
				&& $ksmapHash{$node}{ksfile}
				&& $ksmapHash{$node}{issvr})
			{
				print INFOFILE
				  "AutoYaST: $install_protocol://$ksmapHash{$node}{issvr}/$ksmapHash{$node}{ksdir}/$ksmapHash{$node}{ksfile}\n";
			}
		}
		close INFOFILE;

		#---------------------------------------------------
		# Determine the kernel level
		#---------------------------------------------------
		my $module_path = "$yasttmp/modules";
		my $dummy_module;
		my $kernel_level;
		my @driver_list;
		my $csm_moduledir;

		$dummy_module = "$module_path/e100.ko";
		if (!-f $dummy_module)
		{
			$dummy_module = "$module_path/e100.o";
			goto yast_modules_not_found if (!-f $dummy_module);
		}
		$cmd = "strings $dummy_module|grep vermagic";
		my @output = NodeUtils->runcmd("$cmd", -1);
		if ($::RUNCMD_RC)
		{
			$cmd = "strings $dummy_module|grep kernel_version";
			@output = NodeUtils->runcmd("$cmd", -1);
			goto yast_modules_not_found if ($::RUNCMD_RC);
		}

		# extract the kernel level from first line
		$kernel_level = $output[0];
		chomp $kernel_level;

		# for module issued with linux kernel 2.4, the format looks like:
		#  kernel_version=2.4.21-11.EL
		#
		# for module issued with linux kernel 2.6, the format looks like:
		#  vermagic=2.6.5-7.97-pseries64 SMP gcc-3.3
		(undef, $kernel_level) = split '=', $kernel_level;
		($kernel_level, undef, undef) = split(/\s+/, $kernel_level);

		#-------------------------------------------------
		# Append addtional drivers
		#-------------------------------------------------
		if (-d "$::SUSE_TOP/$svclevel/drivers/$kernel_level/$::ARCH")
		{
			$csm_moduledir =
			  "$::SUSE_TOP/" . $svclevel . "/drivers/$kernel_level/$::ARCH";
		}
		else
		{
			$csm_moduledir =
			  "$::SUSE_TOP/" . $svclevel . "/drivers/$kernel_level";
		}

		if (-d "$csm_moduledir")
		{
			$cmd = "cd $csm_moduledir; $::LS *.o";
			my @output = NodeUtils->runcmd("$cmd", -1);
			if ($::RUNCMD_RC != 0)
			{
				$cmd = "cd $csm_moduledir; $::LS *.ko";
				@output = NodeUtils->runcmd("$cmd", -1);
				goto yast_modules_not_found if ($::RUNCMD_RC != 0);
			}

			foreach my $driver (@output)
			{
				push(@driver_list, "$driver") if (-f "$csm_moduledir/$driver");
			}
		}

	  yast_modules_not_found:
		$info = "$yasttmp/info";
		if (!-f $info)
		{

			#NodeUtils->runcmd("touch $info");
			&touch($info);
		}

		foreach my $driver (@driver_list)
		{
			my ($module, undef) = split('\.', $driver);
			if ($module ne "")
			{

				#-------------------------------------------------
				# Create new "info" file in the ramdisk
				#-------------------------------------------------
				if (($::DISTRO_VERSION eq "8" || $::DISTRO_VERSION =~ /^8\.\d/)
					&& $::DISTRO_NAME eq "SLES")
				{
					open(INFOFILE, ">>$info")
					  || MessageUtils->messageFromCat('csmInstall.cat',
											  $::MSGMAPPATH, 'csminstall', 'E2',
											  'EMsgCANT_WRITE_FILE', $info);
					if ($module ne "bcm5700" && $module ne "mptscsih")
					{
						print INFOFILE "Insmod: $module" . "\n";
					}
					close INFOFILE;
				}
				&copyfile("$csm_moduledir/$driver", "$yasttmp/modules");

				my $yasttmpfile = $yasttmp . "/modules/module.config";

				open(OBJFILE, "<$yasttmpfile")
				  || MessageUtils->messageFromCat('csmInstall.cat',
						$::MSGMAPPATH, 'csminstall', 'E2', 'EMsgCANT_READ_FILE',
						$yasttmpfile);
				my @filecontent = <OBJFILE>;
				close OBJFILE;

				open(OBJFILE, ">$yasttmpfile")
				  || MessageUtils->messageFromCat('csmInstall.cat',
					   $::MSGMAPPATH, 'csminstall', 'E2', 'EMsgCANT_WRITE_FILE',
					   $yasttmpfile);
				foreach my $line (@filecontent)
				{
					if ($line =~ $module) { next }
					print OBJFILE $line;
					if ($line =~ "autoload") { print OBJFILE "$module,,-\n"; }
				}
				close OBJFILE;
			}
		}

		# do special actions for the modules
		NodesetUtils->updateDriver(\@driver_list, $::DISTRO_NAME, $::DISTRO_VERSION, $svclevel, $kernel_level, $::ARCH, $yasttmp);

		#-------------------------------------------------
		# Unmount the ramdisk
		#-------------------------------------------------
		NodesetUtils->pack_ramdisk( $ramdisk, $nodes_pkgdefs{'ramdisk_format'}, $yasttmp);

		#-------------------------------------------------
		# Zip up the ramdisk into <distro_version>.gz (e.g. yast-SLES8.1-i386.gz)
		#-------------------------------------------------
		$cmd    = "$::GZIP -f $ramdisk";
		$output = NodeUtils->runcmd($cmd, 0);
		$rc     = $::RUNCMD_RC;
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'I', 'IMsgShow_Output',
									 $output)
		  if ($rc);
		$returncode = $rc if ($rc > $returncode);

		# Copy the new ramdisk to /tftpboot
		if($ppc_ramdisk){
			&copyfile("$ramdisk.gz", $ppc_ramdisk);
		}
		else{
			&copyfile("$ramdisk.gz", $yast_ramdisk);
			NetworkUtils->secureFilePermissions("$yast_ramdisk", "0110", "0440");
		}
		# Clean up the temporary directory
		rmtree($tmpdir, $::VERBOSE, 1);

		#ywend
	}
	return $returncode;
}

sub makeSISRAMDisk
{
	my ($returncode) = 0;

	my ($initrd) = "/usr/share/systemimager/boot/i386/standard/initrd.img";
	my ($ramdisk_basename) = "sis" . $::DISTRO_VERSION;
	my ($sis_ramdisk)      = $::TFTPBOOT . "/csm/" . $ramdisk_basename . ".gz";

	&copyfile("$initrd", $sis_ramdisk);

	return $returncode;
}

# Copy the drivers (kernel modules) that will be used to update the system
# after it is installed.  The modules are copied to /lib/modules/<kernel>*
# during the kickstart post-install.
sub copyDrivers
{
	my $srcdir = "/opt/csm/install/drivers";
	my $tgtdir = "/csminstall/csm/drivers";
	mkpath("$tgtdir", $::VERBOSE, 0755);
	my $cmd = "$::COPY -rp $srcdir/* $tgtdir";
	NodeUtils->runcmd("$cmd", 0);
	my $rc = $::RUNCMD_RC;

	return ($rc);
}

sub setupInstallPxeHex
{

	# Change the pxelinux HEX file to link to <node_hostname>.install
	my @nodes = @targetNodes;
	my @hexnodes;    # node list including InstallAdapterHostname

	# Generate a hex representation for each node.
	foreach my $node (@nodes)
	{
		my $installAdapterHostname = $nodeHash{$node}{InstallAdapterHostname};
		if (!$installAdapterHostname) { $installAdapterHostname = $node; }
		($installAdapterHostname, undef) =
		  NetworkUtils->getHost($installAdapterHostname);

		push @hexnodes, $installAdapterHostname;
	}

	my %hex  = NetworkUtils->genHex(@hexnodes);
	my $mode = "440";

	foreach my $node (@hexnodes)
	{

		# Copy /tftpboot/pxelinux.pxe/node_hostname.install to the file named
		# with the hex representation of the node's ip address.
		my $nodehex = $hex{$node};

		# Use different pxe config file name for different install methods
		my $src;
		if ($bootMethod eq 'autoyast' || 
			$bootMethod eq 'kickstart' || 
			$bootMethod eq 'kickstart-upgrade')
		{
			$src = "$::PXELINUX_CFG_DIR/$node.install";
		}
		elsif ($bootMethod eq 'hwmaint')
		{
			$src = "$::PXELINUX_CFG_DIR/$node.hwmaint";
		}		
		else
		{
			$src = "$::PXELINUX_CFG_DIR/$node.warewulf";
		}
		my $tgt = "$::PXELINUX_CFG_DIR/$nodehex";
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'V',
									 'IMsgSETTING_PXELINUX_TO_INSTALL', $node);

		# If we do a symlink, the src file gets overwritten when the node
		# updates the tgt file via tftp.  Therefore, a copy is used instead.
		&copyfile($src, $tgt);
		&appendStrToFile(" $ENV{KERNELPAR}", $tgt) if $ENV{KERNELPAR};

		# secure file:
		NetworkUtils->secureFilePermissions($tgt, '0110', '0440');
	}    # end of for loop

	return $::OK;
}

sub setupSISPxeHex
{

	# Change the pxelinux HEX file to link to <node_hostname>.install
	my @nodes = @targetNodes;

	# Generate a hex representation of each node's ip address.
	my %hex = NetworkUtils->genHex(@nodes);

	my $mode = "440";

	foreach my $node (@nodes)
	{

		# Copy /tftpboot/pxelinux.pxe/node_hostname.install to the file named
		# with the hex representation of the node's ip address.
		my $nodehex = $hex{$node};

		# Use different pxe config file name for different install methods
		my $src = "$::PXELINUX_CFG_DIR/${node}.sis";
		my $tgt = "$::PXELINUX_CFG_DIR/$nodehex";
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'V',
									 'IMsgSETTING_PXELINUX_TO_INSTALL', $node);

		# If we do a symlink, the src file gets overwritten when the node
		# updates the tgt file via tftp.  Therefore, a copy is used instead.
		&copyfile($src, $tgt);
		&appendStrToFile(" $ENV{KERNELPAR}", $tgt) if $ENV{KERNELPAR};
		NetworkUtils->secureFilePermissions($tgt, '0110', '0440');
	}    # end of for loop

	return $::OK;
}

sub setupPxeHex
{
	if (   $bootMethod eq 'kickstart'
		|| $bootMethod eq 'kickstart-upgrade'
		|| $bootMethod eq 'autoyast'
		|| $bootMethod eq 'hwmaint'
		|| $bootMethod eq 'warewulf')
	{
		&setupInstallPxeHex;
	}
	elsif ($bootMethod eq 'sis')
	{
		&setupSISPxeHex;
	}
}

sub verifyGetmacsDHCP
{
	my @verifiedNodes = @targetNodes;
	my $num           = 0;
	my $file          = "/etc/dhcpd.conf";
	my @nodeList;

	# make sure the /etc/dhcpd.conf file exists:
	unless (-f $file)
	{
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'E1', 'EMsgDOESNT_EXIST',
									 $file);
	}

	# Make sure that each node that we are going to process
	# has an entry in the /etc/dhcpd.conf file in the dynamic
	# entry section.

	# open /etc/dhcpd.conf
	unless (open(FILE, "<$file"))
	{
		MessageUtils->message('W', 'EMsgCANT_READ_FILE', $file);
		return 1;
	}

	# Read whole file into an array
	my @lines = <FILE>;
	close(FILE);

	foreach my $node (@verifiedNodes)
	{

		# get the ip address of the node:
		my (undef, $ipaddr) = NetworkUtils->getHost($node);

		# check if it's in the dhcpd.conf file:

		#my $out = NodeUtils->runcmd("$::GREP 'range $ipaddr' $file", -1);
		my @result = grep /range $ipaddr/, @lines;

		# if it is in the dhcpd.conf file, then put it into the @::nodes.
		# @::nodes is the list that will be processed:
		#if($out)
		if (@result)
		{
			$num = 1;
			push @nodeList, $node;

			# if it's not on the dhcpd.conf file, then we signal an error:
			# this node will not be processed.
		}
		else
		{
			MessageUtils->messageFromCat('W', 'EMsgNO_DHCP_ENTRY', $node);
		}
	}    # end of for
	@targetNodes = @nodeList;
}

sub verifyInstallDHCP
{
	my @nodes = @targetNodes;

	my $rc = NetworkUtils->verify_dhcp();
	($rc)
	  && MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									  'csminstall', "E$rc",
									  'EMsgCANT_START_DHCP');

	# open /etc/dhcpd.conf

	unless (open(FILE, "<$::DHCPDCONF"))
	{
		MessageUtils->message('W', 'EMsgCANT_READ_FILE', $::DHCPDCONF);
		return 1;
	}

	# Read whole file into an array
	my @lines = <FILE>;
	close(FILE);

	for my $node (@nodes)
	{
		my $installName = $nodeHash{$node}{InstallAdapterHostname};
		if (!$installName) { $installName = $node; }
		($installName, undef) = NetworkUtils->getHost($installName);

		my $defined = 0;
		if ($::PLTFRM eq "AIX")
		{
			if (grep /option 12 \"$installName\"/, @lines)
			{
				$defined = 1;
			}
		}
		else
		{
			if (   (grep /host $installName {/, @lines)
				|| (grep /class \"$installName\"/, @lines))
			{
				$defined = 1;
			}
		}
		if ($defined)
		{
			if ($::VERBOSE)
			{
				MessageUtils->message('V', 'IMsgDHCP_DEFINED', $installName,
									  $::DHCPDCONF);
			}
		}
		else
		{
			MessageUtils->message('W', 'EMsgDHCP_NOT_DEFINED', $installName,
								  $::DHCPDCONF);
		}
	}

	return $::OK;
}

sub verifyDHCP
{
	return if ($ENV{CSM_NO_SETUP_DHCP});

	if ($bootMethod eq 'getmacs')
	{
		&verifyGetmacsDHCP;
	}
	elsif (   ($bootMethod eq 'kickstart')
		   || ($bootMethod eq 'kickstart-upgrade')
		   || ($bootMethod eq 'autoyast')
		   || ($bootMethod eq 'hwmaint')
		   || ($bootMethod eq 'warewulf'))
	{
		&verifyInstallDHCP;
	}
}

sub verifyPxe
{

	# Check that /tftpboot/pxelinux.0 is in place
	unless (-e $::TFTPBOOT . "/pxelinux.0")
	{
		MessageUtils->message('W', 'EMsgCANT_READ_FILE',
							  $::TFTPBOOT . "/pxelinux.0");
		return $::NOK;
	}
	else
	{
		MessageUtils->message('V', 'IMsgFILE_EXISTS',
							  $::TFTPBOOT . "/pxelinux.0");
	}

	my $chkfile;
	my @nodes;
	if ($bootMethod eq 'getmacs')
	{
		my $chkfile = "$::PXELINUXCFG/getmacs.default";

		#ignore target nodes because all getmacs nodes share same pxe config file
		@nodes = ();
	}
	else
	{
		@nodes = @targetNodes;
	}

	foreach my $node (@nodes)
	{
		my $installAdapterHostname = $nodeHash{$node}{InstallAdapterHostname};
		if (!$installAdapterHostname) { $installAdapterHostname = $node; }
		($installAdapterHostname, undef) =
		  NetworkUtils->getHost($installAdapterHostname);

		# check that /tftpboot/pxelinux.cfg/<nodehostname>.install is defined
		# Check different pxe config file for different install methods
		if ($bootMethod =~ "sis")
		{
			$chkfile =
			  $::PXELINUX_CFG_DIR . "/" . $installAdapterHostname . ".sis";
		}
		elsif ($bootMethod eq "kickstart" 
				or $bootMethod eq "kickstart-upgrade"
				or $bootMethod eq "autoyast")
		{
			$chkfile =
			  $::PXELINUX_CFG_DIR . "/" . $installAdapterHostname . ".install";
		}
		elsif ($bootMethod eq 'hwmaint')
		{
			$chkfile =
			  $::PXELINUX_CFG_DIR . "/" . $installAdapterHostname . ".hwmaint";
		}
		elsif ($bootMethod eq 'warewulf')
		{
			$chkfile =
			  $::PXELINUX_CFG_DIR . "/" . $installAdapterHostname . ".warewulf";
		}

	}

	if (!-f $chkfile)
	{
		MessageUtils->messageFromCat(
									 'csmInstall.cat',     $::MSGMAPPATH,
									 'csminstall',         'E',
									 'EMsgFILE_NOT_FOUND', $chkfile
									);
	}

	return $::OK;
}

#--------------------------------------------------------------------------------

=head3    verifyPPC64Kernel

	Verify PPC64 kernel exists or not

        Notes:

=cut

#--------------------------------------------------------------------------------

sub verifyPPC64Kernel
{
	my ($netboot_kernel, $cmd);
	my @akb_servers    = &collectInstallServerAKBServer;
	my @service_levels = NodeUtils->getServiceLevel(\@targetNodes);
    my ($effective_distro_name) =
        NodeUtils->getEffectiveDistro($::DISTRO_NAME);
	my $prefix = $effective_distro_name =~ /RedHat/i ? "ks" : "yast";

	foreach my $server (@akb_servers)
	{
		foreach my $svclevel (@service_levels)
		{
			$netboot_kernel =
			    "$::TFTPBOOT/csm/$prefix"
			  . $::DISTRO_VERSION . "-"
			  . $svclevel
			  . "-ppc64-zImage.initrd"
			  . "_$server";

			unless (-e $netboot_kernel)
			{
				MessageUtils->message('W', 'EMsgCANT_READ_FILE',
									  $netboot_kernel);
				next;
			}

			if (defined $ENV{CSM_NO_REBOOT} && $ENV{CSM_NO_REBOOT} == 1)
			{

				# For RHEL3, it is not clear what is the difference between hacked and
				# unhacked zimage.
				if ($effective_distro_name =~ /RedHat/) { next; }
				# don't hack zimages for sles with mkzimage_cmdline now
				next if ($effective_distro_name =~ /SLES/);

				$cmd = "$::GREP \"csm\" $netboot_kernel";
				NodeUtils->runcmd("$cmd", -1);
				if ($::RUNCMD_RC)
				{
					my $nodestr = join("\t\n", @targetNodes);
					$nodestr .= "\n";
					MessageUtils->message('I', 'IMsgZIMAGE_NOT_HACKED',
										  $netboot_kernel, $nodestr);
				}
			}
		}
	}

	return;
}

sub verifyGetmacsKernel
{
	my @service_levels = NodeUtils->getServiceLevel(\@targetNodes);
	foreach my $svclevel (@service_levels)
	{
		my $getmacs_kernel =
		    "$::TFTPBOOT/csm/getmac-"
		  . "$::DISTRO_NAME$::DISTRO_VERSION"
		  . "-$svclevel-$::ARCH" . "z";
		unless (-f $getmacs_kernel)
		{
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
					  'csminstall', 'E', 'EMsgFILE_NOT_FOUND', $getmacs_kernel);
		}
	}

}

sub verifyInstallKernel
{
	my $prefix = $bootMethod eq 'autoyast' ? 'yast' : 'ks';
	my @service_levels = NodeUtils->getServiceLevel(\@targetNodes);
	foreach my $svclevel (@service_levels)
	{
		my ($kernel_basename) = "$prefix-"
		  . $::DISTRO_NAME
		  . $::DISTRO_VERSION
		  . "-$svclevel-"
		  . $::ARCH;    # e.g. yast-SLES8.1-GA-i386
		my $kernel = $::TFTPBOOT . "/csm/" . $kernel_basename . "z";
		unless (-f $kernel)
		{
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
							  'csminstall', 'E', 'EMsgFILE_NOT_FOUND', $kernel);
		}
	}

}

sub verifyHwmaintKernel
{
	my @service_levels = NodeUtils->getServiceLevel(\@targetNodes);
	my $distro_name    = &abbreviateDistroName($::DISTRO_NAME);
	foreach my $svclevel (@service_levels)
	{
		my $kernel_basename;
		if ($::ARCH eq "x86_64")
		{
			$kernel_basename = "hm-"
			  . $distro_name
			  . $::DISTRO_VERSION
			  . $svclevel
			  . "E";    # e.g. hwm-RHEL3QU2
		}
		else
		{
			$kernel_basename = "hm-"
			  . $distro_name
			  . $::DISTRO_VERSION
			  . $svclevel;    # e.g. hwm-RHEL3QU2

		}
		my $kernel = $::TFTPBOOT . "/csm/" . $kernel_basename . "z";
		unless (-f $kernel)
		{
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
							 'csminstall', 'E1', 'EMsgFILE_NOT_FOUND', $kernel);
		}
	}
}

sub verifySISKernel
{
	my $sis_kernel = $::TFTPBOOT . "/csm/sis" . $::DISTRO_VERSION . "z";
	unless (-f $sis_kernel)
	{
		MessageUtils->messageFromCat(
									 'csmInstall.cat',     $::MSGMAPPATH,
									 'csminstall',         'E',
									 'EMsgFILE_NOT_FOUND', $sis_kernel
									);
	}
}

sub verifyKernel
{
	my $prefix;
	if ($bootMethod eq 'hwmaint')
	{
		&verifyHwmaintKernel;
	}
	elsif ($bootMethod eq 'getmacs')
	{
		&verifyGetmacsKernel;
	}
	elsif (   $bootMethod eq 'autoyast'
		   || $bootMethod eq 'kickstart'
		   || $bootMethod eq 'kickstart-upgrade')
	{
		&verifyInstallKernel;
	}
	elsif ( $bootMethod eq 'warewulf' )
	{
		return;
	}		
	else
	{
		&verifySISKernel;
	}
}

sub verifyGetmacsRAMDisk
{
	my @service_levels = NodeUtils->getServiceLevel(\@targetNodes);
	foreach my $svclevel (@service_levels)
	{
		my $getmacs_ramdisk = $::TFTPBOOT
		  . "/csm/getmac-$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH.gz";
		unless (-f $getmacs_ramdisk)
		{
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
					 'csminstall', 'E', 'EMsgFILE_NOT_FOUND', $getmacs_ramdisk);

		}
	}
}

sub verifyInstallRAMDisk
{
	my %chknodes;
	my @chklvnodes;
	my @service_levels;

	my $prefix;
	if ($bootMethod eq 'kickstart' or $bootMethod eq 'kickstart-upgrade')
	{
		$prefix = "ks-";
	}
	else
	{
		$prefix = "yast-";
	}

	foreach my $node (@targetNodes)
	{
		if (!$nodeHash{$node}{InstallAdapterMacaddr}
			&& $nodeHash{$node}{UUID})
		{
			my $host = $node;
			if ($nodeHash{$node}{InstallAdapterHostname})
			{
				$host = $nodeHash{$node}{InstallAdapterHostname};
			}
			my ($hostname, $hostip) = NetworkUtils->getHost($host);
			if ($hostip)
			{
				$chknodes{$node}{hostip}        = $hostip;
				$chknodes{$node}{service_level} =
				  $nodeHash{$node}{InstallServiceLevel};
			}
		}
		else
		{
			push @chklvnodes, $node;
		}
	}

	if (@chklvnodes)
	{
		@service_levels = NodeUtils->getServiceLevel(\@chklvnodes);
	}

	foreach my $svclevel (@service_levels)
	{
		my ($ramdisk_basename) = "$prefix"
		  . $::DISTRO_NAME
		  . $::DISTRO_VERSION
		  . "-$svclevel-"
		  . $::ARCH;
		my ($ks_ramdisk) = $::TFTPBOOT . "/csm/" . $ramdisk_basename . ".gz";
		unless (-f $ks_ramdisk)
		{
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
						  'csminstall', 'E', 'EMsgFILE_NOT_FOUND', $ks_ramdisk);
		}
	}

	foreach my $node (keys %chknodes)
	{
		my $ramdisk_basename = "$chknodes{$node}{hostip}";
		my ($ks_ramdisk) = $::TFTPBOOT . "/csm/" . $ramdisk_basename . ".gz";
		unless (-f $ks_ramdisk)
		{
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
						  'csminstall', 'E', 'EMsgFILE_NOT_FOUND', $ks_ramdisk);
		}
	}
}

sub verifySISRAMDisk
{
	my ($ramdisk_basename) = "sis" . $::DISTRO_VERSION;
	my ($sis_ramdisk)      = $::TFTPBOOT . "/csm/" . $ramdisk_basename . ".gz";
	unless (-f $sis_ramdisk)
	{
		MessageUtils->messageFromCat(
									 'csmInstall.cat',     $::MSGMAPPATH,
									 'csminstall',         'E',
									 'EMsgFILE_NOT_FOUND', $sis_ramdisk
									);
	}
}

sub verifyHwmaintRAMDisk
{
	my $ramdisk;
	my @check_nodes;

	foreach my $node (@targetNodes)
	{
		if (!$nodeHash{$node}{InstallAdapterMacaddr} && $nodeHash{$node}{UUID})
		{

			# for the nodes that only have UUID, they have individual ramdisks.
			my $host = $node;
			if ($nodeHash{$node}{"InstallAdapterHostname"})
			{
				$host = $nodeHash{$node}{"InstallAdapterHostname"};
			}
			my ($nodename, $nodeip) = NetworkUtils->getHost($host);
			$ramdisk = $::TFTPBOOT . "/csm/hm-" . $nodeip . ".gz";
			unless (-f $ramdisk)
			{
				MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
							 'csminstall', 'E', 'EMsgFILE_NOT_FOUND', $ramdisk);
			}
		}
		else
		{
			push @check_nodes, $node;
		}
	}

	return if (!@check_nodes);

	my @service_levels = NodeUtils->getServiceLevel(\@check_nodes);
	my $distro_name    = &abbreviateDistroName($::DISTRO_NAME);
	foreach my $sl (@service_levels)
	{
		my $ramdisk;
		if ($::ARCH eq "x86_64")
		{
			$ramdisk =
			    "$::TFTPBOOT/csm/hm-"
			  . "$distro_name$::DISTRO_VERSION" . "$sl" . "E.gz";
		}
		else
		{
			$ramdisk =
			    "$::TFTPBOOT/csm/hm-"
			  . "$distro_name$::DISTRO_VERSION" . "$sl" . ".gz";

		}
		unless (-f $ramdisk)
		{
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
							 'csminstall', 'E', 'EMsgFILE_NOT_FOUND', $ramdisk);
		}
	}
}

sub verifyRAMDisk
{
	if ($bootMethod eq 'getmacs')
	{
		&verifyGetmacsRAMDisk;
	}
	elsif (   $bootMethod eq 'kickstart'
		   || $bootMethod eq 'kickstart-upgrade'
		   || $bootMethod eq 'autoyast')
	{
		&verifyInstallRAMDisk;
	}
	elsif ($bootMethod eq 'hwmaint')
	{
		&verifyHwmaintRAMDisk;
	}
	elsif ($bootMethod eq 'sis')
	{
		&verifySISRAMDisk;
	}

}

sub verifyTFTP
{
	if ($::PLTFRM eq "AIX")
	{
		return;
	}

	my $rc = 0;
	if (   $bootMethod eq 'getmacs'
		|| $bootMethod eq 'kickstart'
		|| $bootMethod eq 'kickstart-upgrade'
		|| $bootMethod eq 'sis'
		|| $bootMethod eq 'hwmaint'
		|| $bootMethod eq 'warewulf')
	{

		# 1 means its running, 0 means its not running.
		$rc = NetworkUtils->verifyTftp(1);
		unless ($rc)
		{
			$::BOOT_EXIT = 1;
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', "E1", 'EMsgCANT_START_TFTP');
		}
	}
}

sub verifyHTTP
{
	my $rc               = 0;
	my $install_protocol = NodesetUtils->get_NetworkInstallProtocol();
	if ($install_protocol eq "http")
	{
		if ($::PLTFRM eq "AIX")
		{
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', "E1", 'EMsg_NO_HTTP_ON_AIX');
		}
	}

	my $setup_install_protocol =
	  NodesetUtils->get_SetupNetworkInstallProtocol();

	# Only verify HTTP if HTTP is being used.
	if (    ($install_protocol =~ /http/i)
		and ($setup_install_protocol =~ /1|yes/i))
	{
		if (   $bootMethod eq 'autoyast'
			|| $bootMethod eq 'kickstart'
			|| $bootMethod eq 'kickstart-upgrade')
		{

			# 0 means apache is running, >0 means it is not
			$rc = ApacheUtils->test_apache();

			# If apache isn't running, try to start it.
			if ($rc > 0)
			{

				# start_apache exits if apache fails to run.
				ApacheUtils->start_apache();
			}
		}
	}

	# Now test if some files get be obtained from the HTTP server
	if ($install_protocol =~ /http/i)
	{

		# Get a file from /csminstall/csm/*
		# If this subroutine returns "1", it means that the wget command
		# was not avaialable.  This is not a fatal error, and this test
		# can just be skipped.
		my $testfile = $ENV{CSMINSTALL_ROOT} . "/csm/http_testfile";
		NodeUtils->runcmd("$::TOUCH $testfile", 0);
		$rc = ApacheUtils->test_http_wget("$testfile");
		unlink($testfile);

		if ($rc == 0)
		{

			# Only check for any more files if wget is avaialble.

			# Get a file from /csminstall/Linux/*
			# Look for the diskid file that is used to identify the CD.
			my @disks             = @{$::pkgdefs{'distro_disks'}};
			my $testfile_basename = $disks[0]->{diskid_searchargs}->{file};

			my @service_levels = NodeUtils->getServiceLevel(\@targetNodes);
            my ($effective_distro_name) =
                NodeUtils->getEffectiveDistro($::DISTRO_NAME);
			foreach my $svclevel (@service_levels)
			{
				if ($effective_distro_name =~ /RedHat/)
				{
					my $my_dirname;
					if ($svclevel eq "GA")
					{
						$my_dirname =
						  $::DISTRO_NAME . $::DISTRO_VERSION . "-" . $::ARCH;
					}
					else
					{
						$my_dirname =
						  $::DISTRO_NAME . $::DISTRO_VERSION . "-" . $svclevel;
					}
					$testfile = "$::TOP_DIR/$my_dirname/$testfile_basename";
				}
				else
				{
					$testfile = "$::TOP_DIR/$svclevel/$testfile_basename";
				}

				#MessageUtils->message('I', 'IMsgShow_Output', "testfile = $testfile");

				# If this subroutine returns "1", it means that the wget command
				# was not avaialable.  This is not a fatal error, and this test
				# can just be skipped.
				$rc = ApacheUtils->test_http_wget("$testfile");
			}
		}
	}

	return $rc;
}

#--------------------------------------------------------------------------------

=head3    verify_setup_ppc64

	Verifies that definenode and setupks have been run. verify_setupks sets
	the global @::BADNODES variable to contain a list of nodes that failed
	any part of the verification.

        Notes: ppc64 routine

=cut

#--------------------------------------------------------------------------------

sub verify_setup_ppc64
{
	my $InstallMethod = $bootMethod;
	my @nodes         = @targetNodes;
	my @badnodes;
	my $distro;

	# check that there are @nodes
	unless (scalar(@nodes))
	{
		MessageUtils->message('V', 'IMsgNO_NODES', $_);
	}

	MessageUtils->message('V', 'IMsgVERIFYING_SETUPINSTALL', $InstallMethod);


	my $configfile_dir;

    my ($effective_distro_name) =
        NodeUtils->getEffectiveDistro($::DISTRO_NAME);
	foreach my $node (@nodes)
	{
		# No checking required for some install methods or boot methods.
		next if ($InstallMethod eq "you" or $InstallMethod eq "disk");

		my ($issvr, $isdir);
		if (NodeUtils->isMgmtSvr || $ENV{'DC_ENVIRONMENT'})
		{
			$isdir = "/csminstall";
		}
		else
		{
			($issvr, $isdir) = split ':', $::NODEHASH{$node}{'InstallServer'};
			if (!$isdir) { $isdir = "/csmserver" }
		}

		my $thisNodeError = 0;

		if ($effective_distro_name =~ /RedHat/i)
		{
			$configfile_dir =
			    "/$isdir/csm/"
			  . $::NODEHASH{$node}{"InstallCSMVersion"}
			  . "/kickstart."
			  . $::NODEHASH{$node}{"InstallDistributionName"}
			  . $::NODEHASH{$node}{"InstallDistributionVersion"};
		}
		else
		{
			$configfile_dir =
			    "/$isdir/csm/"
			  . $::NODEHASH{$node}{"InstallCSMVersion"}
			  . "/autoyast."
			  . $::NODEHASH{$node}{"InstallDistributionName"}
			  . $::NODEHASH{$node}{"InstallDistributionVersion"};

		}

		my $chkfile;
		my $host = $node;
		if ($::NODEHASH{$node}{InstallAdapterHostname})
		{
			$host = $::NODEHASH{$node}{'InstallAdapterHostname'};
		}
		my ($_host, $ip) = NetworkUtils->getHost($host);

		if ($InstallMethod =~ "autoyast")
		{
			$chkfile = $configfile_dir . "/" . $ip . "-autoyast.xml";
		}
		elsif ($InstallMethod =~ "kickstart" 
				or $InstallMethod =~ "kickstart-upgrade")
		{
			$chkfile = $configfile_dir . "/" . $ip . "-kickstart";
		}

		if ($chkfile && -f $chkfile)
		{
			MessageUtils->message('V', 'IMsgFILE_EXISTS', $chkfile);
		}
		else
		{
			$thisNodeError++;
			MessageUtils->message('W', 'EMsgCANT_READ_FILE', $chkfile);
		}

		if ($::NODEHASH{$node}{"InstallAdapterMacaddr"} eq "")
		{
			$thisNodeError++;
			MessageUtils->message('W', 'EMsgCANT_GET_NODE_ATTR',
								  "InstallAdapterMacaddr", $node);
		}

		# The following attributes are only used for hmc nodes.
		if ($::NODEHASH{$node}{"PowerMethod"} eq "hmc")
		{
			if ($::NODEHASH{$node}{"InstallAdapterType"} eq "")
			{
				$thisNodeError++;
				MessageUtils->message('W', 'EMsgCANT_GET_NODE_ATTR',
									  "InstallAdapterType", $node);
			}

			if ($::NODEHASH{$node}{"InstallAdapterType"} eq "ent")
			{
				if ($::NODEHASH{$node}{"InstallAdapterDuplex"} eq "")
				{
					$thisNodeError++;
					MessageUtils->message('W', 'EMsgCANT_GET_NODE_ATTR',
										  "InstallAdapterDuplex", $node);
				}
				if ($::NODEHASH{$node}{"InstallAdapterSpeed"} eq "")
				{
					$thisNodeError++;
					MessageUtils->message('W', 'EMsgCANT_GET_NODE_ATTR',
										  "InstallAdapterSpeed", $node);
				}
			}
		}

		if ($thisNodeError)
		{
			push @badnodes, $node;
		}

	}

	if (@badnodes)
	{
		MessageUtils->message('E1', 'EMsgNODES_MISSING_ATTRS',
							  join("\n\t", @badnodes));
	}
	else
	{
		MessageUtils->message('V', 'IMsgVERIFY_SETUPINSTALL_OK',);
	}

	# return the number of errors that we found.
	return scalar @badnodes;
}

#--------------------------------------------------------------------------------

=head3    verify_setup

	Verifies that definenode and setupks have been run.  The return
	code from verify_setup is 0 if it looks like setupinstall was run properly
	for at least some of the nodes.  It returns >0 if there is some problem
	with the dhcpd.conf file or the pxelinux.0 file.  verify_setup sets
	the global @::BADNODES variable to contain a list of nodes that failed
	any part of the verification.

        Notes:

=cut

#--------------------------------------------------------------------------------

sub verify_setup
{

	my $InstallMethod = $bootMethod;
	my @nodes         = @targetNodes;
	my @badnodes;

	unless (   $InstallMethod eq 'kickstart'
			|| $InstallMethod eq 'kickstart-upgrade'
			|| $InstallMethod eq 'autoyast'
			|| $InstallMethod eq 'you')
	{
		return 0;
	}

	# check that there are @nodes
	unless (scalar(@nodes))
	{
		MessageUtils->message('V', 'IMsgNO_NODES', $_);
	}

	MessageUtils->message('V', 'IMsgVERIFYING_SETUPINSTALL', $InstallMethod);

	foreach my $node (@nodes)
	{
		my ($issvr, $isdir, $chkfile);
		$isdir = $ENV{'CSMINSTALL_ROOT'};
		my $host  = $node;
		if ($::NODEHASH{$node}{'InstallAdapterHostname'})
		{
			$host = $::NODEHASH{$node}{'InstallAdapterHostname'};
		}
		my ($_host, $ip) = NetworkUtils->getHost($host);

		my %pkgdefs =
            ServerUtils->get_pkgdefs(
							   $::NODEHASH{$node}{'InstallOSName'},
							   $::NODEHASH{$node}{'InstallDistributionName'},
							   $::NODEHASH{$node}{'InstallDistributionVersion'},
							   $::NODEHASH{$node}{'InstallPkgArchitecture'}
							  );
        my $location = 'MgdNode';
		if (!grep(/^$location$/, @{$pkgdefs{'where_supported'}}))
		{
			my $officially_supported = 1;	
			my %supported_distro = NodeUtils->getSupportedDistro($officially_supported);
			MessageUtils->message(         'W', 'EMsgUNSUPPORTED_DISTRO',
                    $::NODEHASH{$node}{'InstallDistributionName'}, $supported_distro{$location});
			push @badnodes, $node;
		}
		else
		{
			MessageUtils->message('V', 'IMsgDETECTED_DISTRO',
                    $::NODEHASH{$node}{'InstallDistributionName'});
		}

		# No more checking required for some install methods
		next if ($InstallMethod eq "you");


		if ($InstallMethod =~ "autoyast")
		{
			my $yastcfgfile_dir =
			    "/$isdir/csm/"
			  . $::CSM_VERSION
			  . "/autoyast."
			  . $::DISTRO_NAME
			  . $::DISTRO_VERSION;
			$chkfile = $yastcfgfile_dir . "/" . $ip . "-autoyast.xml";
		}
		elsif ($InstallMethod =~ "kickstart" 
				or $InstallMethod =~ "kickstart-upgrade")
		{
			my $ksfile_dir =
			    "/$isdir/csm/"
			  . $::CSM_VERSION
			  . "/kickstart."
			  . $::DISTRO_NAME
			  . $::DISTRO_VERSION;
			$chkfile = $ksfile_dir . "/" . $ip . "-kickstart";
		}

		if ($chkfile && -f $chkfile)
		{
			MessageUtils->message('V', 'IMsgFILE_EXISTS', $chkfile);
		}
		else
		{
			MessageUtils->message('W', 'EMsgCANT_READ_FILE', $chkfile);
			push @badnodes, $node;
		}

	}

	if (@badnodes)
	{
		MessageUtils->message('E1', 'EMsgNODES_MISSING_FILES',
							  join("\n\t", @badnodes));
	}
	else
	{
		MessageUtils->message('V', 'IMsgVERIFY_SETUPINSTALL_OK',);
	}
}

#--------------------------------------------------------------------------------

=head3    verify_files_in_csminstall

	Verify that all the correct files got copied to csminstall during installms.

        Notes:

=cut

#--------------------------------------------------------------------------------

sub verify_files_in_csminstall
{
	my ($errors) = 0;
	my ($checkfile, $basename);

	# i.e. OSTypeVer = "LinuxRedHatEL-AS3"
	%::pkgdefs =
	  ServerUtils->get_pkgdefs('Linux', $::DISTRO_NAME, $::DISTRO_VERSION,
							   $::ARCH, "MgdNode", $::CSM_VERSION)
	  if (!%::pkgdefs);

	if (   $bootMethod eq 'kickstart'
		|| $bootMethod eq 'kickstart-upgrade'
		|| $bootMethod eq 'autoyast'
		|| $bootMethod eq 'you')
	{
		&verify_install_files_in_csminstall;
	}
	elsif ($bootMethod eq 'hwmaint')
	{
		&verify_hwmaint_files_in_csminstall;
	}
}

sub verify_hwmaint_files_in_csminstall
{
	my $csmserver = $::CSMINSTALL_ROOT;

	my @hwm_libs = (@{$::pkgdefs{preinstall_libs}});
	foreach my $file (@hwm_libs)
	{
		my $basename  = basename($file);
		my $checkfile = "$csmserver/csm/lib/$basename";
		#Warewulf install method don't call this subroutine.
		#File "makdisklessnode" is needed by wareuwlf.
        #So, we don't check this file here.
		if ( (!-e $checkfile) && (!$checkfile =~/makdisklessnode/))
		{
			MessageUtils->message('E1', 'EMsgNOT_COPIED', $checkfile);
		}
	}

	my @hwm_execs = (@{$::pkgdefs{preinstall_execs}});
	foreach my $file (@hwm_execs)
	{
		my $basename  = basename($file);
		my $checkfile = "$csmserver/csm/$basename";
		if (!-e $checkfile)
		{
			MessageUtils->message('E1', 'EMsgNOT_COPIED', $checkfile);
		}
	}
}

sub verify_install_files_in_csminstall
{
	my @csm_bin_file_csm      = (@{$::pkgdefs{csm_bin_copy_csm}});
	my @csm_bin_file_tftpboot = (@{$::pkgdefs{csm_bin_copy_tftpboot}});

	my $csmserver = $::CSMINSTALL_ROOT;

	foreach my $file (@csm_bin_file_csm)
	{
		my $basename  = basename($file);
		my $checkfile = "$csmserver/csm/$basename";
		if (!-e $checkfile)
		{
			MessageUtils->message('E1', 'EMsgNOT_COPIED', $checkfile);
		}
	}

	foreach my $file (@csm_bin_file_tftpboot)
	{
		my $basename  = basename($file);
		my $checkfile = "/tftpboot/$basename";
		if (!-e $checkfile)
		{
			MessageUtils->message('E1', 'EMsgNOT_COPIED', $checkfile);
		}
	}

}

#--------------------------------------------------------------------------------

=head3    verify_iprdd_img

        Notes: 
        if RedHatEL-AS 3 GA or QU1 node, validate whether iprdd driver has
        been copied into /csminstall

=cut

#--------------------------------------------------------------------------------
sub verify_iprdd_img
{

	foreach my $node (keys %nodeHash)
	{
		my $svclevel = $::nodeHash{$node}{"InstallServiceLevel"};
		if (  ($::INSTALL_METHOD =~ "kickstart" or 
				$::INSTALL_METHOD =~ "kickstart-upgrade")
			&& $::DISTRO_NAME =~ /RedHatEL-AS/
			&& $::DISTRO_VERSION eq "3"
			&& (($svclevel eq "QU1") || ($svclevel eq "GA")))
		{
			my $csmserver =
			  $ENV{'CSMINSTALL_ROOT'} ? $ENV{'CSMINSTALL_ROOT'} : $::CSMINSTDIR;
			my $iprdd_img =
			    "$csmserver/csm/"
			  . $nodeHash{$node}{"InstallDistributionName"}
			  . $nodeHash{$node}{"InstallDistributionVersion"}
			  . "-drivers/iprdd.img";
			unless (-e $iprdd_img)
			{
				MessageUtils->message('E1', 'EMsgNOT_COPIED', $iprdd_img);
			}
		}
	}

	return 0;
}

# Verify the systemimager daemon to ensure the rsyncd is running
sub verify_systemimager
{
	my ($InstallMethod);
	&loadNodeAttributes();

	# Find whether there are some nodes use "sis" InstallMethod
	foreach my $node (@targetNodes)
	{
		$InstallMethod = $nodeHash{$node}{'InstallMethod'};
		if ($InstallMethod =~ "sis")
		{
			my $cmd = "/etc/init.d/systemimager start";
			my $rc = NodeUtils->runcmd($cmd, 0);
			return $::RUNCMD_RC;
		}
	}

	return 0;
}

sub getCommonAttributes
{

	# Get the attributes that are common across all nodes.
	if ($bootMethod eq 'hwmaint')
	{
		#enable HWMAINT flag so that csm version validation
		#can be ignored by get_common_attrs
		$::HWMAINT = 1;
	}
	($::DISTRO_NAME, $::DISTRO_VERSION, $::ARCH, $::CSM_VERSION) =
	  NodeUtils->get_common_attrs();
}

#prepare_mount sub-routine will check if the director/tmp/... is mounted.
#If mounted, then it will unmount.
sub prepare_mount
{
	&getCommonAttributes();
	my ($cmd, @my_result, $cnt);

	#SSSBEGIN
	my ($tmpdir, $check_val);
	if (   $bootMethod eq 'autoyast'
		|| $bootMethod eq 'getmacs'
		|| $bootMethod eq 'getmacssnmp'
		|| $bootMethod eq 'hwmaint' && $::SUSE_TOP ne "")
	{
		$tmpdir    = "/tmp/yast" . $::DISTRO_VERSION;    # e.g. /tmp/yast8.1
		$check_val = $tmpdir . "/yasttmp";
	}
	elsif (   $bootMethod eq 'kickstart'
		   || $bootMethod eq 'kickstart-upgrade'
		   || $bootMethod eq 'getmacs'
		   || $bootMethod eq 'getmacssnmp'
		   || $bootMethod eq 'hwmaint' && $::REDHAT_TOP ne "")
	{
		$tmpdir    = "/tmp/ks" . $::DISTRO_VERSION;      # e.g. /tmp/ks7.3
		$check_val = $tmpdir . "/kstmp";
	}
	elsif ( $bootMethod eq 'warewulf')
	{
		$tmpdir    = "/tmp/ww";
		$check_val = $tmpdir . "/wwtmp";
		print "Enter prepare_mount subroutine: $bootMethod\n" if ($::DEBUG);
	}

	#SSSEND
	$cmd = "$::MOUNT | grep $check_val";
	@my_result = NodeUtils->runcmd($cmd, -1);
	chomp(@my_result);
	$cnt = @my_result;
	if ($cnt > 0)
	{
		my $i;
		for ($i = 1 ; $i <= $cnt ; $i++)
		{
			$cmd = "$::UNMOUNT $check_val";
			NodeUtils->runcmd($cmd);
		}
	}
}

sub loadNodeAttributes
{
	my @nodeList = @inputNodes;

	# Process the various ways of inputting the list of nodes.

	my ($ref_DestNode, $ref_DestNodeHash) =
	  ServerUtils->getNodesInfo(\@nodeList);
	@targetNodes = @$ref_DestNode;

	# get rid of the duplicated nodes
	my @tmp_targetNodes;
	foreach my $node (@targetNodes)
	{
		if(!grep /^\Q$node\E$/, @tmp_targetNodes)
		{
			push @tmp_targetNodes, $node;
		}
	}
	@targetNodes=@tmp_targetNodes;

	foreach my $node (@nodeList)
	{
		foreach my $key (keys %{$$ref_DestNodeHash{$node}})
		{
			$::NODEHASH{$node}{$key} = $$ref_DestNodeHash{$node}{$key};
		}
        my $svclevel = $::NODEHASH{$node}{'InstallServiceLevel'};
        # Consider all service level whose distro version contains '.' as default value 'GA'.
        if (  $::NODEHASH{$node}{'InstallMethod'} eq "warewulf"
           && $::NODEHASH{$node}{'InstallDistributionName'} =~ /RedHatEL/
           && $::NODEHASH{$node}{'InstallDistributionVersion'} =~ /\./
           && $svclevel ne "GA"
       )
       {
           $::NODEHASH{$node}{'InstallServiceLevel'} = "GA";
       }

	}
	%nodeHash = %$ref_DestNodeHash;
}

#Takes a list of nodes and checks for the InstallAdapterMacaddr attribute
#value. Returns a list with references to both a list of nodes with MAC address  and
#to the list without MAC address.
sub checkMACAddress
{
	shift;
	my @nodeList = @_;

	# First, find the nodes whose InstallAdapterMacaddr attribute
	# is  already set.
	my ($ref_DestNode, $ref_lsnode_info, $ref_DestNodeHash) =
	  NodeUtils->get_target_nodes(\@nodeList);
	my %latestNodeHash = %$ref_DestNodeHash;
	my @hasMACList     = ();
	my @noMACList      = ();
	my @result         = (\@hasMACList, \@noMACList);
	my $InstallAdapterMacaddr;
	my $uuid;
	my $arch;

	foreach my $hostname (keys %latestNodeHash)
	{
		$arch = $latestNodeHash{$hostname}{'InstallPkgArchitecture'};
		if($arch ne "ppc64")
		{
			# UUID is okay to replace MAC only for xSeries nodes.
			$uuid = $latestNodeHash{$hostname}{'UUID'};
			$uuid =~ s/\s//g;
			if ($uuid =~ /[0-9A-F]{32}/)
			{
				push(@hasMACList, $hostname);
				next;
			}
		}	

		$InstallAdapterMacaddr =
		  $latestNodeHash{$hostname}{'InstallAdapterMacaddr'};
		my $InstallAdapterName =
		  $latestNodeHash{$hostname}{'InstallAdapterName'};
		if ($InstallAdapterName !~ /eth\d+/ && $InstallAdapterName ne "")
		{
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
				  'csminstall', 'E', 'EMsgAdapterNotValid', $InstallAdapterName,
				  $hostname);
			next;
		}
		if (($InstallAdapterMacaddr =~ /(..:..:..:..:..:..)/))
		{

			#VJB: I had to change this back.  I have a linux node that
			# I didn't set the installadapterName and I don't think I should
			# have to.  Seems like it should default to eth0...
			push(@hasMACList, $hostname);
		}
		else
		{
			push(@noMACList, $hostname);
		}
	}

	#return the node list for which for which we have MAC address.
	return @result;

}

sub setupBoot
{
	shift(@_);
	my ($boot, $hexOption, @nodeList) = @_;

	my @commonBootMethods = (
							 "getmacs", "kickstart", "kickstart-upgrade",
							 "sis",     "autoyast",
							 "hwmaint", "disk",
							 "getmacsdisk","warewulf",
							 "you", "getmacssnmp",
							);
	my $rc = 0;
	$bootMethod    = $boot;
	$hexFileOption = $hexOption;
	return () if (!@nodeList);
	@inputNodes = @nodeList;

	&setAttributes();
	&loadNodeAttributes();

	return () if (!grep(/^$bootMethod$/, @commonBootMethods));

	#Disk boot setup
	if (($bootMethod eq "disk") 
		|| ($bootMethod eq "getmacsdisk")
		|| ($bootMethod eq "you"))
	{
		&setupDiskBoot($hexFileOption);
	}
	else
	{
		&getCommonAttributes();

		#if $::pkgdefs is not exist yet(nodeset.utils.pl didn't create
		#it), then create it.
		$::pkgdefs =
		  ServerUtils->get_pkgdefs('Linux', $::DISTRO_NAME, $::DISTRO_VERSION,
								   $::ARCH, "MgdNode", $::CSM_VERSION)
		  if (!$::pkgdefs);
		$::TOP_DIR =
		  ServerUtils->getBaseDir("Linux", $::DISTRO_NAME, $::DISTRO_VERSION,
								  $::ARCH);
		$::SUSE_TOP   = $::TOP_DIR;
		$::REDHAT_TOP = $::TOP_DIR;

		if ($::ARCH eq "ppc64")
		{
			if ($hexFileOption eq "onlyhex")
			{
				if ($bootMethod ne "warewulf")
				{
 					$::BOOT_EXIT = &doPPC64Verify();
				}
			}
			else
			{
				$::BOOT_EXIT = &doPPC64Setup();
			}
		}
		else
		{
			if ($hexFileOption eq "yes")
			{
				$::BOOT_EXIT = &doFullSetup();
			}
			elsif ($hexFileOption eq "no")
			{
				$::BOOT_EXIT = &doFullSetupGenerateNoHex();
			}
			elsif ($hexFileOption eq "onlyhex")
			{
				$::BOOT_EXIT = &doSetupGenerateOnlyHex();
			}
		}
	}
	return (@targetNodes);
}

=item

  getVariables - exports variables to programs that will be called later
  such as subvars.  This is added for the modular install template 
  support.

  This subroutine is used by createInstallFiles.

=cut

sub getVariables
{
	my $node = shift;
	my $type = shift;    # Which install method are we doing?
	     # Set some variables that will be substituted into the kickstart
	     # configuration template file in place of #VARIABLE#.

	# Generate a hex representation of each node's ip address.
	#print "getting variables for $node\n";
	my %hex;
	if (   $nodeHash{$node}{'InstallAdapterHostname'}
		&& $nodeHash{$node}{'InstallAdapterHostname'} ne '')
	{
		%hex = NetworkUtils->genHex($nodeHash{$node}{'InstallAdapterHostname'});
	}
	else
	{
		%hex = NetworkUtils->genHex($node);
	}
	my $nfs_dir;

	my $sp = NodeUtils->getNodeServiceLevel($node);
	if ($type eq "KickStart")
	{
		my $my_dirname;
		if ($sp eq "GA")
		{
			$my_dirname = $::DISTRO_NAME . $::DISTRO_VERSION . "-" . $::ARCH;
		}
		else
		{
			$my_dirname = $::DISTRO_NAME . $::DISTRO_VERSION . "-" . $sp;
		}
		$nfs_dir = $::REDHAT_TOP . "/" . $my_dirname;
	}
	elsif ($type eq "AutoYast")
	{
		$nfs_dir = $::SUSE_TOP;
	}
	else
	{
		print "AHHHH, NodesetUtils->getVariables died!\n";
	}

	my ($timezone, $timezone_utc);
	if ($::PLTFRM eq "AIX")
	{

		# use this quick fix until a better solution is found
		$timezone     = "US/Pacific";
		$timezone_utc = "--utc";
	}
	else
	{

		# Get the management server's timezone information
		my $clockcfg = "/etc/sysconfig/clock";
		my ($zone, $junk);
		my $ms_distro =
		  NodeUtils->get_DistributionName()
		  ;    #need the OS of MS to determine format of clock file.
		if ($ms_distro =~ /SLES/)
		{
			$zone = `$::GREP "^TIMEZONE" $clockcfg`;
		}
		else
		{      #RH machine
			$zone = `$::GREP "ZONE" $clockcfg`;
		}
		($junk, $timezone) = split('=', $zone);
		$timezone =~ s/"//g;
		$timezone =~ s/'//g;

		# Get the management server's timezone --utc flag.
		my $utc = `$::GREP "UTC" $clockcfg`;
		($junk, $timezone_utc) = split('=', $utc);
		$timezone_utc =~ s/"//g;
		$timezone_utc =~ s/'//g;
		if (($timezone_utc =~ /yes/i) || ($timezone_utc =~ /true/i))
		{
			$timezone_utc = "--utc";
		}
		else { $timezone_utc = ""; }
	}

	my $nameservers = $::BOOT_ATTRIBUTES{"Nameservers"};

	my $gateway =
	  NetworkUtils->validate_ip($nodeHash{$node}{'InstallAdapterGateway'});
	if ($gateway == -1)
	{
		$gateway = $::BOOT_ATTRIBUTES{"Gateway"};
	}

	my $host = $node;
	if ($nodeHash{$node}{"InstallAdapterHostname"})
	{
		$host = $nodeHash{$node}{"InstallAdapterHostname"};
	}
	my ($node_hostname, $node_ipaddr) = NetworkUtils->getHost($host);
	my ($node_bc,       $node_mask)   = NetworkUtils->getNetmask($node_ipaddr);

	my $node_hex = $hex{$node_hostname};
	my $node_shortname = (split('\.', $node_hostname))[0];
	if ($node_shortname eq "") { $node_shortname = $node_hostname }

	# Get the hostname of the management server as known by this node
	#my ($ms_hostname, $ms_ipaddr) = &get_node_management_server($node);
	my ($ms_hostname, $ms_ipaddr) =
	  NetworkUtils->getHost($nodeHash{$node}{"ManagementServer"});
	my $ms_shorthost = (split('\.', $ms_hostname))[0];
	(my $dnsdomain = $node) =~ s/^.*?\.//;
	if ($dnsdomain eq $node)
	{

		# If the node's hostname has no domain name (short hostname),
		# use the domain name of the management server.
		($dnsdomain = $ms_hostname) =~ s/^.*?\.//;
		if ($dnsdomain eq $ms_hostname)
		{
			$dnsdomain = "";
		}
	}

	# change $bootdisk logical
	my $bootdisk     = $nodeHash{$node}{'InstallDisk'};
	my $not_set_disk = 0;
	if (!$bootdisk)
	{
		$bootdisk = $nodeHash{$node}{'InstallDiskType'};
		if ($bootdisk eq "scsi")
		{
			$bootdisk = "/dev/sda";
		}
		elsif ($bootdisk eq "ide")
		{
			$bootdisk = "/dev/hda";
		}
		else
		{
			$bootdisk     = "/dev/sda";
			$not_set_disk = 1;
		}
	}
	my ($junk, $junk2, $install_driver) = split('/', $bootdisk);

	# sda is just the default install disk  for pSeries, for xSeries it is nothing
	# So export another variable to indicate it avoiding effect exiting code!
	my $ondrive_install_disk =
	  "--ondrive=$install_driver";    # like "--ondrive=sda"
	if ($not_set_disk)
	{
		$ondrive_install_disk = "";   #no user set disk, so let kickstart choose
	}

	# The NFS Hostname and IP addr are taken from the InstallServer attribute
	# or default to the management server.
	my ($isvr_hostname,   $isvr_ipaddr,   $isvr_dir)   = &get_node_isvr($node);
	my ($nfssvr_hostname, $nfssvr_ipaddr, $nfssvr_dir) =
	  &get_node_nfssvr($node);
	my $nfssvr = $nfssvr_ipaddr;

	if (!$nfssvr_ipaddr)
	{
		$nfssvr_hostname = $isvr_hostname;
		$nfssvr_ipaddr   = $isvr_ipaddr;
		$nfssvr_dir      = $isvr_dir;
	}

	# If NFSServer is not null, the node should mount mgmtsvr:/csminstall/csm
	# to execute scripts during installing.
	my $csm_mount = "/csminstall/csm";
	if ($isvr_dir)
	{
		$csm_mount =~ s/\/csminstall/$isvr_dir/;
	}
	if ($nfssvr_dir)
	{
		$nfs_dir =~ s/^\/csminstall/$nfssvr_dir/;
	}

	my $install_protocol = NodesetUtils->get_NetworkInstallProtocol();
	if ($install_protocol =~ /nfs/i)
	{
		$ENV{'KS_INSTALL_SOURCE'} =
		  "nfs --server $nfssvr_ipaddr --dir $nfs_dir";
	}
	elsif ($install_protocol =~ /http/i)
	{
		$ENV{'KS_INSTALL_SOURCE'} = "url --url http://$isvr_ipaddr$nfs_dir";
	}
	else
	{
		MessageUtils->messageFromCat(
									 'csmInstall.cat',
									 $::MSGMAPPATH,
									 'csminstall',
									 'E2',
									 'EMsgINVALID_NETWORK_INSTALL_PROTOCOL',
									 $install_protocol
									);
	}
	my $InstallMethod = $nodeHash{$node}{'InstallMethod'};

	# Substitute values in the kickstart configuration template file
	# with variables defined above.
	if (!$nodeHash{$node}{InstallAdapterMacaddr} && $nodeHash{$node}{UUID})
	{

		# configure network statically
		my $network_info =
		    "--bootproto=static "
		  . "--ip=$node_ipaddr "
		  . "--netmask=$node_mask ";
		if ($gateway)
		{
			$network_info .= "--gateway=$gateway ";
		}

		if ($nameservers)
		{
			$network_info .= "--nameserver=$nameservers ";
		}
		$ENV{'NETWORK_INFO'} = $network_info;

	}
	else
	{
		$ENV{'NETWORK_INFO'} = "--bootproto dhcp";
	}
	$ENV{'TEMPLATESCRIPTS'}  = $::TEMPLATESCRIPTS;
	$::MGMTSVR_HOSTNAME      = $ms_hostname;       # Management Server hostname
	$ENV{'MGMTSVR_HOSTNAME'} = $::MGMTSVR_HOSTNAME;
	$::MGMTSVR_SHORTHOST     = $ms_shorthost;      # Management Server shorthost
	$ENV{'MGMTSVR_SHORTHOST'} = $::MGMTSVR_SHORTHOST;
	$::MGMTSVR_IP      = $ms_ipaddr;        # Management Server IP Address
	$ENV{'MGMTSVR_IP'} = $::MGMTSVR_IP;
	$::NODE_HOSTNAME   = $node_hostname;    # Node hostname
	     #$ENV{'NODE_HOSTNAME'} = $::NODE_HOSTNAME;
	$ENV{'NODE_HOSTNAME'} = $nodeHash{$node}{Hostname};
	($::NODE_SHORTNAME) = split /\./, $ENV{'NODE_HOSTNAME'};
	$ENV{'NODE_SHORTNAME'} = $::NODE_SHORTNAME;
	$ENV{'HWTYPE'}         = $nodeHash{$node}{HWType};
	$ENV{'INSTALL_ARCH'}   = $nodeHash{$node}{'InstallPkgArchitecture'};
	$::NODE_IP           = $node_ipaddr;        # Node ip address
	$ENV{'NODE_IP'}      = $::NODE_IP;
	$::NODE_BC           = $node_bc;            # Node ip broadcast
	$ENV{'NODE_BC'}      = $::NODE_BC;
	$::NODE_MASK         = $node_mask;          # Node ip netmask
	$ENV{'NODE_MASK'}    = $::NODE_MASK;
	$::NODE_HEX          = $node_hex;           # Node ip address in hex.
	$ENV{'NODE_HEX'}     = $::NODE_HEX;
	# try to specify network device in autoyast configure file for sles10
	my $device_name = 'eth0';
	if ($nodeHash{$node}{'InstallAdapterMacaddr'})
	{
	    $device_name = $nodeHash{$node}{'InstallAdapterMacaddr'};
	}
	elsif ($nodeHash{$node}{'InstallAdapterName'})
	{
	    $device_name = $nodeHash{$node}{'InstallAdapterName'};
	}
	$::NODE_NETDEV	     = $device_name;
	$ENV{'NODE_NETDEV'}  = $::NODE_NETDEV;
	$::NFS_HOSTNAME      = $nfssvr_hostname;    # NFS server hostname
	$ENV{'NFS_HOSTNAME'} = $::NFS_HOSTNAME;
	$::NFS_IP            = $nfssvr_ipaddr;      # NFS server ip address
	$ENV{'NFS_IP'}       = $::NFS_IP;
	$::NFSSERVER      = $nfssvr;
	$ENV{'NFSSERVER'} = $::NFSSERVER;
	$::NFS_DIR        = $nfs_dir;                        # REDHAT_TOP
	$ENV{'NFS_DIR'}   = $::NFS_DIR;
	$::CSM_MOUNT      = $csm_mount;                      # CSM mount point
	$ENV{'CSM_MOUNT'} = $::CSM_MOUNT;
	$::TFTP_IP          = $ms_ipaddr;       # TFTP Server(Management server)
	$ENV{'TFTP_IP'}     = $::TFTP_IP;
	$::NAMESERVERS      = $nameservers;     # Nameservers (comma-separated)
	$ENV{'NAMESERVERS'} = $::NAMESERVERS;
	$::GATEWAY          = $gateway;         # Gateway
	$ENV{'GATEWAY'}     = $::GATEWAY;
	$::DNSDOMAIN        = $dnsdomain;       # Node's DNS Domain name
	$ENV{'DNSDOMAIN'}   = $::DNSDOMAIN;

	#$::CSM_VERSION = $::CSM_VERSION;   # Version of CSM
	$ENV{'CSM_VERSION'} = $::CSM_VERSION;
	chomp($::TIMEZONE = $timezone);         # Timezone of MS
	$ENV{'TIMEZONE'}        = $::TIMEZONE;
	$::TIMEZONE_UTC         = $timezone_utc;         # Timezone --utc flag of MS
	$ENV{'TIMEZONE_UTC'}    = $::TIMEZONE_UTC;
	$::BOOTDISK             = $bootdisk;
	$ENV{'BOOTDISK'}        = $::BOOTDISK;
	$::ONDRIVE_INSTALL_DISK = $ondrive_install_disk;
	$ENV{'ONDRIVE_INSTALL_DISK'}  = $::ONDRIVE_INSTALL_DISK;
	$::INSTALL_DRIVER             = $install_driver;
	$ENV{'INSTALL_DRIVER'}        = $::INSTALL_DRIVER;
	my ($effective_distro_name, $effective_distro_ver, $effective_svl_level) =
		NodeUtils->getEffectiveDistro(
			$nodeHash{$node}{'InstallDistributionName'},
			$nodeHash{$node}{'InstallDistributionVersion'},
			$nodeHash{$node}{'InstallServiceLevel'}
                );
	$ENV{'OSVER'}                 = $nodeHash{$node}{'InstallDistributionName'};
	$ENV{'DISTRO_NAME'}           = $::DISTRO_NAME;
	$ENV{'DISTRO_VERSION'}        = $::DISTRO_VERSION;
	$ENV{'INSTALL_SERVICE_LEVEL'} = $nodeHash{$node}{'InstallServiceLevel'};
	$ENV{'ARCH'}                  = $::ARCH;
	$ENV{'EFFECTIVE_DISTRO_NAME'} = $effective_distro_name;
	$ENV{'EFFECTIVE_DISTRO_VERSION'} = $effective_distro_ver;
	$ENV{'EFFECTIVE_SERVICE_LEVEL'} = $effective_svl_level;

	$ENV{'INSTALL_METHOD'}        = $InstallMethod;

	if ($nodeHash{$node}{'ConsoleSerialDevice'})
	{
		$ENV{'STTYCRTSCTS'} =
		  "stty -crtscts < /dev/$nodeHash{$node}{'ConsoleSerialDevice'}";
	}

	return;
}

=item subvars

    subvars calls the subvars program to substitute template files
    with ENV variables.  THis is used for modular templates

=cut

sub subvars
{
	my $file = shift;
	if (!-f "$file")
	{
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'E2', 'EMsgCANT_READ_FILE',
									 $file);
	}
	return `/opt/csm/csmbin/substvars < $file`;
}

=item getInstallFile

    getInstallFile gets the installation file that will be used.
    for RH it returns the install file, for yast, it returns
    the real file and the link file.

	This subroutine is used by createInstallFiles.
=cut

sub getInstallFile
{
	my $node = shift;
	my $type = shift;
	my ($node_hostname, $node_ipaddr);
	if (   $nodeHash{$node}{'InstallAdapterHostname'}
		&& $nodeHash{$node}{'InstallAdapterHostname'} ne '')
	{
		($node_hostname, $node_ipaddr) =
		  NetworkUtils->getHost($nodeHash{$node}{'InstallAdapterHostname'});
	}
	else
	{
		($node_hostname, $node_ipaddr) = NetworkUtils->getHost($node);
	}

	# Generate a hex representation of each node's ip address.
	my %hex;
	if (   $nodeHash{$node}{'InstallAdapterHostname'}
		&& $nodeHash{$node}{'InstallAdapterHostname'} ne '')
	{
		%hex = NetworkUtils->genHex($nodeHash{$node}{'InstallAdapterHostname'});
	}
	else
	{
		%hex = NetworkUtils->genHex($node);
	}
	my $node_hex    = $hex{$node_hostname};
	my $default_dir = "/csminstall";
	if ($ENV{'CSMINSTALL_ROOT'}) { $default_dir = $ENV{'CSMINSTALL_ROOT'}; }

	if ($type eq "AutoYast")
	{

		# Autoyast config file directory.
		# Example:  /csminstall/csm/1.3.1/autoyast.SLES8.1/9.114.179.14-autoyast.xml
		my $yastfile_hostlink;
		my $yastfile_hexlink;
		my $yastfile_dir =
		    "$default_dir/csm/"
		  . $::CSM_VERSION
		  . "/autoyast."
		  . $::DISTRO_NAME
		  . $::DISTRO_VERSION;

		MessageUtils->messageFromCat(
									 'csmInstall.cat',         $::MSGMAPPATH,
									 'csminstall',             'V',
									 'IMsgCREATING_YAST_FILE', $yastfile_dir
									);
		mkpath("$yastfile_dir", $::VERBOSE, 0755);

		my $yastdir_real =
		  $::CSM_VERSION . "/autoyast." . $::DISTRO_NAME . $::DISTRO_VERSION;
		my $yastdir_link =
		  "$default_dir/csm/" . $::DISTRO_NAME . $::DISTRO_VERSION;
		unlink $yastdir_link;
		symlink $yastdir_real, $yastdir_link;

		my ($yastfile, $yastfile_real, $yastfile_link);
		$yastfile = $yastfile_dir . "/" . $node_ipaddr . "-autoyast.xml";
		$yastfile_real = $node_ipaddr . "-autoyast.xml";
		$yastfile_link = $yastfile_dir . "/" . $node_ipaddr . ".xml";
		if ($node_hostname)
		{
			$yastfile_hostlink =
			  $yastfile_dir . "/" . $node_hostname . "-autoyast.xml";
			$yastfile_hexlink = $yastfile_dir . "/" . $node_hex;
		}

		return ($yastfile, $yastfile_real, $yastfile_link, $yastfile_hostlink,
				$yastfile_hexlink);
	}
	elsif ($type eq "KickStart")
	{

		# Kickstart config file directory.
		# Example:  /csminstall/csm/1.5.0/kickstart.RedHatEL-AS4
		my $ksfile_hostlink;
		my $ksfile_dir =
		    "$default_dir/csm/"
		  . $::CSM_VERSION
		  . "/kickstart."
		  . $::DISTRO_NAME
		  . $::DISTRO_VERSION;
		MessageUtils->messageFromCat(
									 'csmInstall.cat',       $::MSGMAPPATH,
									 'csminstall',           'V',
									 'IMsgCREATING_KS_FILE', $ksfile_dir
									);
		mkpath("$ksfile_dir", $::VERBOSE, 0755);

		my $ksdir_real =
		  $::CSM_VERSION . "/kickstart." . $::DISTRO_NAME . $::DISTRO_VERSION;
		my $ksdir_link =
		  "$default_dir/csm/" . $::DISTRO_NAME . $::DISTRO_VERSION;
		unlink $ksdir_link;
		symlink $ksdir_real, $ksdir_link;

		my ($ksfile, $ksfile_real, $ksfile_link);
		$ksfile      = $ksfile_dir . "/" . $node_ipaddr . "-kickstart";
		$ksfile_real = $node_ipaddr . "-kickstart";
		$ksfile_link = $ksfile_dir . "/" . $node_ipaddr;
		if ($node_hostname)
		{
			$ksfile_hostlink =
		  		$ksfile_dir . "/" . $node_hostname . "-kickstart";
		}
		return ($ksfile, $ksfile_real, $ksfile_link, $ksfile_hostlink, undef);

	}
}

#--------------------------------------------------------------------------------

=head3 	run_setupBoot

	Call nodeset via dsh from install server or call setupBoot from Management Server

        Notes:

=cut

#--------------------------------------------------------------------------------

sub run_setupBoot
{
	my $routine = "run_setupBoot";
	print "ENTERING: $routine\n" if $::DEBUG;

	my ($class, $installmethod, $hexOption, $ref_nodelist) = @_;

	my @dest_node_list = @$ref_nodelist;
	my %dest_node_hash = %::NODEHASH;

	foreach my $node (keys %dest_node_hash)
	{
		if (!grep /^$node$/, @dest_node_list)
		{
			delete $dest_node_hash{$node};
		}
	}

	my ($ref_MgtNodes, $ref_InstallServers) =
	  ServerUtils->getInstallServers(\%dest_node_hash);
	my %InstallServers = %$ref_InstallServers;
	my @MgtNodes       = @$ref_MgtNodes;
	my ($cmd, $cmd2);

	foreach my $node (@MgtNodes)
	{

		# for the nodes with no Install Servers, use MS as their IS.
		my ($ms_hostname, $ms_ip) =
		  NetworkUtils->getHost_rveg(
									$dest_node_hash{$node}{"ManagementServer"});
		if ($::GETHOST_RC != $::OK)
		{
			MessageUtils->messageFromCat('nodecmds.cat', '/opt/csm/msgmaps',
									'NodeUtils', 'E', $::GETHOST_MSG,
									$dest_node_hash{$node}{"ManagementServer"});
			next;
		}
		push(@{$InstallServers{$ms_hostname}{nodelist}}, $node);
		push(@{$InstallServers{$ms_hostname}{dir}{"/csminstall"}}, $node);
	}

	$ENV{DSH_LIST} = '';    #clear dsh env.

	# >>> check reachability to the Install Servers >>>
	my @installServers;
	foreach my $is (keys %InstallServers)
	{
		if ($InstallServers{$is}{isGrp})
		{
			my $refGroup = NodeUtils->getNodegrp($is);
			if ($refGroup)
			{
				push @installServers, @$refGroup;
			}
		}
		else
		{
			push @installServers, $is;
		}
	}
	my $refISNotReachable = NetworkUtils->checkRSReachability(\@installServers);
	if ($refISNotReachable != 0)
	{
		if (scalar @$refISNotReachable > 0)
		{
			my $isvrs = join ",", @$refISNotReachable;
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									  'csminstall', 'E1', 'EMsgISDown', $isvrs);
		}
	}

	# <<< check reachability to the Install Servers <<<

	foreach my $is (keys %InstallServers)
	{

		my $isISGrp = $InstallServers{$is}{isGrp};

		my $realis = $is;
		if ($isISGrp)
		{
			$realis =~ s/^\+//;
		}

		foreach my $dir (keys %{$InstallServers{$is}{dir}})
		{
			my @nodelist = @{$InstallServers{$is}{dir}{$dir}};
			my $node_file;
			if (scalar(@nodelist) > 500)
			{

				# for better performance: only build and use a temporary file
				# if the list is greater than 500 nodes.
				$node_file = ServerUtils->make_node_list_file(\@nodelist);
				if ($isISGrp)
				{
					$cmd = "/opt/csm/bin/dcp -N $realis $node_file $node_file";
				}
				else
				{
					$cmd = "/opt/csm/bin/dcp -n $is $node_file $node_file";
				}
				NodeUtils->runcmd($cmd, -1);
			}

			if ((($installmethod eq "disk") || ($installmethod eq "you")) 
				&& ($hexOption eq "onlyhex"))
			{

				# Create the reboot_ready flag file on IS
				my @status_files;
				my $file_list;

				# Make parent directory as necessary
				my $stat_dir = $dir . "/csm/status";
				if ($isISGrp)
				{
					$cmd  = "/opt/csm/bin/dsh -N $realis mkdir -p $stat_dir";
					$cmd2 = "/opt/csm/bin/dsh -N $realis chmod 755 $stat_dir";
				}
				else
				{
					$cmd  = "/opt/csm/bin/dsh -n $is mkdir -p  $stat_dir";
					$cmd2 = "/opt/csm/bin/dsh -n $is chmod 755  $stat_dir";
				}
				NodeUtils->runcmd($cmd,  -2);
				NodeUtils->runcmd($cmd2, -2);

				foreach my $hostname (@nodelist)
				{
					push @status_files,
					  $stat_dir . "/" . $hostname . ".rebootready";
				}
				$file_list = join " ", @status_files;
				if ($isISGrp)
				{
					$cmd = "/opt/csm/bin/dsh -N $realis touch $file_list";
				}
				else
				{
					$cmd = "/opt/csm/bin/dsh -n $is touch $file_list";
				}
				NodeUtils->runcmd($cmd, -2);
			}
			my $rmt_cmd;
			my $rmt_var;
			if (defined $ENV{CSM_NO_SETUP_DHCP})
			{
				$rmt_var .= "export CSM_NO_SETUP_DHCP=1; ";
			}
			if (defined $ENV{CSM_NO_VERIFY})
			{
				$rmt_var .= "export CSM_NO_VERIFY=1; ";
			}
			if (defined $ENV{CSM_NO_REBOOT})
			{
				$rmt_var .= "export CSM_NO_REBOOT=1; ";
			}
			if (defined $ENV{CSM_USERKERNEL})
			{
				my $baseName = basename($ENV{CSM_USERKERNEL});
				$rmt_var .= "export CSM_USERKERNEL=$baseName; ";
			}
			if (defined $ENV{CSM_USERRAMDISK})
			{
				my $baseName = basename($ENV{CSM_USERRAMDISK});
				$rmt_var .= "export CSM_USERRAMDISK=$baseName; ";
			}
			if (defined $ENV{CSM_USERPXEFILE})
			{
				my $baseName = basename($ENV{CSM_USERPXEFILE});
				$rmt_var .= "export CSM_USERPXEFILE=$baseName; ";
			}
			if (defined $ENV{KERNELPAR})
			{
				$rmt_var .= "export KERNELPAR=\"$ENV{KERNELPAR}\";";
			}
			my $install_protocol = NodesetUtils->get_NetworkInstallProtocol();
			$rmt_var .= "export NETWORK_INSTALL_PROTOCOL=$install_protocol; ";

			my $setup_install_protocol =
			  NodesetUtils->get_SetupNetworkInstallProtocol();
			$rmt_var .=
			  "export SETUP_NETWORK_INSTALL_PROTOCOL=$setup_install_protocol; ";

			# build up attributes string including Gateway=xxx Netmask=xxx,
			# which can be identified by nodeset.utils.
			my $attrs_str;
			foreach my $key (%::ATTRS)
			{
				if (grep(/^$key$/, @VALID_ATTRIBUTES))
				{
					my $value = $::ATTRS{"$key"};
					$attrs_str .= " $key=$value " if ($value);
				}
			}

			if ($node_file)
			{
				$rmt_cmd =
				  "$rmt_var export CSMINSTALL_ROOT=$dir; /opt/csm/bin/nodeset.utils -b $installmethod -P $hexOption -f $node_file $attrs_str && $::RM -f $node_file";
			}
			else
			{
				my $nodestring = join(',', @nodelist);

				$rmt_cmd =
				  "$rmt_var export CSMINSTALL_ROOT=$dir; /opt/csm/bin/nodeset.utils -b $installmethod -P $hexOption -n $nodestring $attrs_str";
			}

			if ($isISGrp)
			{
				$cmd = "$::DSH -N $realis '$rmt_cmd'";
			}
			else
			{
				$cmd = "$::DSH -n $is '$rmt_cmd'";
			}
			my $output = NodeUtils->runcmd($cmd, 1);
			$::BOOT_EXIT = 1 if $::RUNCMD_RC;
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
								 'csminstall', 'I', 'IMsgShow_Output', $output);

			#
			#Need analyse to get detail error info ?
			#
			if ($node_file)
			{
				ServerUtils->close_delete_file($::NODE_LIST_FILE, $node_file);
			}
		}
	}
	print "LEAVING: $routine\n" if $::DEBUG;
}

#--------------------------------------------------------------------------------

=head3   hackKickstartzImage

        Notes: 

=cut

#--------------------------------------------------------------------------------
sub hackKickstartzImage
{
	my ($netboot_kernel, $svclevel, $ref_akb_servers, $installdir, $hack) = @_;
	my $template_dir  = "$installdir/csm/templates";
	my $protocol      = NodesetUtils->get_NetworkInstallProtocol;
	my $template_file =
	  $protocol =~ /http/
	  ? "$template_dir/tmpl/rhloader_HTTP.cfg"
	  : "$template_dir/tmpl/rhloader.cfg";
	my $kp_dir =
	    "$installdir/csm/"
	  . $::CSM_VERSION
	  . "/kickstart."
	  . "$::DISTRO_NAME"
	  . "$::DISTRO_VERSION";
	if (!-d $kp_dir) { mkpath($kp_dir); }

	if ($hack)
	{
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'I',
									 'IMsgADD_BUILT_IN_KS_PARAMS');
	}

	# command and temporay dir will be used to hack zImage
	$::OBJCOPY  = "/usr/bin/objcopy";
	$::MKZIMAGE = "/usr/bin/mkzimage";
	$::CSMTMP   = "/var/opt/csm/tmp";

	# Build up install protocol and kickstart dir
	my $ksdir = "$installdir" . "/csm/$::DISTRO_NAME$::DISTRO_VERSION" . "/";

	foreach my $installserver (@{$ref_akb_servers})
	{

		# Duplicate zimage for each InstalLServerAKBNode
		my $new_zimage = $netboot_kernel . "_" . $installserver;
		&copyfile($netboot_kernel, $new_zimage);
		NetworkUtils->setDefaultFilePermission("$new_zimage");

		# Do not hack zimage if prerequisate utils are not found
		if (!$hack) { next; }

		# Clean up tmp dir
		my $tmpdir =
		    $::CSMTMP . "/"
		  . $::DISTRO_NAME
		  . $::DISTRO_VERSION . "-"
		  . $svclevel;    # e.g. /tmp/ks4
		if (-d $tmpdir)
		{
			rmtree($tmpdir, $::VERBOSE, 1);
		}
		mkpath($tmpdir, $::VERBOSE, 0755);

		# Extract kernel and ramdisk from zImage
		my ($kernel, $ramdisk) = &extractPPCzImage($new_zimage, $tmpdir);
		if (!$kernel || !$ramdisk)
		{
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
					 'csminstall', 'I', 'IMsgCANT_EXTRACT_ZIMAGE', $new_zimage);
			next;
		}

		# Initiate built-in kernel parameters
		my $kp_file = "$kp_dir/rhloader_$installserver";
		open(KP_FILE, ">$kp_file")
		  || MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
						   'csminstall', 'E2', 'EMsgCANT_WRITE_FILE', $kp_file);
		my @content = NodeUtils->readFile($template_file);
		foreach my $line (@content)
		{
			$line =~ s/#NETINSTALL_PROTOCOL#/$protocol/g;
			$line =~ s/#IS_IP#/$installserver/g;
			$line =~ s/#KS_DIR#/$ksdir/g;
			$line =~ s/#RAMDISK_SIZE#/32768/g;
			print KP_FILE $line;
		}
		close(KP_FILE);

		&makeKickstartRAMDisk('',$ramdisk);

		# Put csm hook and built-in kernel parameters into ramdisk
		if (&putCSMHookToRamdisk($ramdisk, $kp_file, $tmpdir) != $::OK)
		{
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
				   'csminstall', 'I', 'IMsgCANT_PUT_CSM_FRONTEND', $new_zimage);
			next;
		}

		# Rebuild the zimage
		if (&buildPPCzImage($kernel, $ramdisk, $svclevel, $new_zimage, $tmpdir)
			!= $::OK)
		{
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
					 'csminstall', 'I', 'IMsgCANT_REBUILD_ZIMAGE', $new_zimage);
			next;
		}

		rmtree($tmpdir, $::VERBOSE, 1);
	}

	return 0;
}

#--------------------------------------------------------------------------------

=head3   extractPPCzImage

        Notes: 
            extract zImage file with specified temporary dir
        Arguments:
            $image:    zImage file name with full path
            $tmpdir:   temporary dir 
        Return:
            $kernel:   ppc kernel file name with full path 
            $ramdisk:  ppc ramdisk file name with full path

=cut

#--------------------------------------------------------------------------------
sub extractPPCzImage
{
	my $image  = shift;
	my $tmpdir = shift;

	my ($cmd, $output, $rc, $kernel, $ramdisk);

	$kernel  = "$tmpdir/vmlinux.gz";
	$ramdisk = "$tmpdir/initrd.gz";

    if($::DISTRO_NAME =~ /SLES/ && $::DISTRO_VERSION eq '10'){
        my (undef, $service_level) = split /-/, $tmpdir;

        # search the kernel on CD
        my $cmd = "find $::SUSE_TOP/$service_level -name \"linux64.gz\"";
        my @filelist = NodeUtils->runcmd($cmd, -1);
        my $kernel_on_cd = $filelist[0];

        # search the initrd on CD
        $cmd = "find $::SUSE_TOP/$service_level -name \"initrd64\"";
        @filelist = NodeUtils->runcmd($cmd, -1);
        my $initrd_on_cd = $filelist[0];

        &copyfile($kernel_on_cd,$kernel);
        &copyfile($initrd_on_cd,$ramdisk);
        return ($kernel, $ramdisk);
    }

    if ($::DISTRO_NAME =~ /RedHat/ && $::DISTRO_VERSION ge '5') {
        my (undef, undef, $service_level) = split /-/, $tmpdir;
        my $top_path;

        if ($service_level eq 'GA') {
            $top_path 
            = "$::REDHAT_TOP/$::DISTRO_NAME"
            . $::DISTRO_VERSION
            . "-" 
            . $::ARCH;
        }
        else {
            $top_path 
            = "$::REDHAT_TOP/$::DISTRO_NAME"
            . $::DISTRO_VERSION
            . "-" 
            . $service_level;
        }
        my $kernel_on_cd = "$top_path/ppc/ppc64/vmlinuz";
        my $initrd_on_cd = "$top_path/ppc/ppc64/ramdisk.image.gz";

        copyfile($kernel_on_cd, $kernel);
        copyfile($initrd_on_cd, $ramdisk);
        return ($kernel, $ramdisk);
    }

	$cmd = "cd $tmpdir; $::OBJCOPY -j .kernel:vmlinux -O binary $image $kernel";
	$output = NodeUtils->runcmd("$cmd", -1);
	if ($::RUNCMD_RC)
	{
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'I', 'IMsgShow_Output',
									 $output);
		return (undef, undef);
	}

	$cmd = "cd $tmpdir; $::OBJCOPY -j .kernel:initrd -O binary $image $ramdisk";
	$output = NodeUtils->runcmd("$cmd", -1);
	if ($::RUNCMD_RC)
	{
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'I', 'IMsgShow_Output',
									 $output);
		return (undef, undef);
	}

	return ($kernel, $ramdisk);
}

#--------------------------------------------------------------------------------

=head3   putCSMHookToRamdisk

        Notes: Put csm hook and built-in kernel parameters into ks ramdisk
        Arguments:
            $ramdisk: ramdisk file name with full path
            $kp_file: file contianing built-in kernel parameters
            $tmpdir:  temporay dir 

        Return:
        0: successful
        1: failed

=cut

#--------------------------------------------------------------------------------
sub putCSMHookToRamdisk
{
	my $ramdisk  = shift;
	my $kp_file  = shift;
	my $tmpdir   = shift;
	my $mntpoint = "$tmpdir/mnt";
	my ($cmd, $output, $rc);

	# Extract ramdisk
	$cmd = "cd $tmpdir; $::GZIP -d $ramdisk";
	$output = NodeUtils->runcmd($cmd, -1);
	if ($::RUNCMD_RC)
	{
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'I', 'IMsgShow_Output',
									 $output);
		return $::RUNCMD_RC;
	}
	$ramdisk =~ s/.gz$//;

	# Mount ramdisk
	if (!-d "$mntpoint")
	{
		mkpath($mntpoint, $::VERBOSE, 0755);
	}

	$cmd = "$::MOUNT | $::GREP $mntpoint";
	$output = NodeUtils->runcmd($cmd, -1);
	if ($::RUNCMD_RC == 0)
	{
		NodeUtils->runcmd("$::UMOUNT $mntpoint", -1);
	}

    # this routine only used for redhat ...
    if ($::DISTRO_VERSION ge '5') {
        $cmd = "(cd $mntpoint; cpio -id < $ramdisk)";
    }
    else {
	    $cmd = "$::MOUNT -o loop $ramdisk $mntpoint";
    }

	$output = NodeUtils->runcmd($cmd, -1);
	if ($::RUNCMD_RC)
	{
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'I', 'IMsgShow_Output',
									 $output);
		return $::RUNCMD_RC;
	}

	# Put into csm kernel command line
	&copyfile($kp_file, "$mntpoint/csm_params");

	# Put csm front-end into ramdisk
	&copyfile("/opt/csm/install/csm_rhloader", "$tmpdir/csm_rhloader");
	$cmd = "/usr/bin/strip -s $tmpdir/csm_rhloader";
	$output = NodeUtils->runcmd($cmd, -1);
	if ($::RUNCMD_RC)
	{
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'I', 'IMsgShow_Output',
									 $output);
	}
	&copyfile("$tmpdir/csm_rhloader", "$mntpoint/sbin/csmldr", 0755);

	# Replace the loader inside the initrd with our front-end loader
	$cmd = "sed -e 's/loader/csmldr/g' $mntpoint/sbin/init > $tmpdir/init.tmp";
	$output = NodeUtils->runcmd($cmd, -1);
	if ($::RUNCMD_RC)
	{
		NodeUtils->runcmd("$::UMOUNT $mntpoint", -1);
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'I', 'IMsgShow_Output',
									 $output);
		return $::RUNCMD_RC;
	}
	&copyfile("$tmpdir/init.tmp", "$mntpoint/sbin/init");

    if ($::DISTRO_VERSION ge '5') {
        $cmd = "(cd $mntpoint;find . |cpio -o -H newc > $ramdisk)";
    }
    else {
	    # umount initrd and remove mnt point
	    $cmd    = "$::UMOUNT $mntpoint";
    }
	$output = NodeUtils->runcmd($cmd, -1);

	# Compress the ramdisk
	$cmd = "cd $tmpdir; $::GZIP $ramdisk";
	$output = NodeUtils->runcmd($cmd, -1);
	if ($::RUNCMD_RC)
	{
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'I', 'IMsgShow_Output',
									 $output);
		$rc = $::RUNCMD_RC;
	}

	rmtree($mntpoint, $::VERBOSE, 1);
	return $rc;
}

#--------------------------------------------------------------------------------

=head3   buildPPCzImage

        Notes: Rebuild zimage based on specifed kernel and ramdisk.
               This subroutine will look for kernel rpm under /csminstall/Linux to extract required kernel-stub
        Arguments:
           $kernel: kernel file name 
           $ramdisk: ramdisk file name
           $svclevel: required to assemble path to seek kernel rpm
           $zimage: target zimage file
           $tmpdir: temporary dir
        Return:
            0: successful
            1: failed
=cut

#--------------------------------------------------------------------------------
sub buildPPCzImage
{
	my ($kernel, $ramdisk, $svclevel, $zimage, $tmpdir) = @_;
	my ($cmd, $output, $rc);
	my ($pkgs_basedir, $k_pkg, $extract_dir, $kernel_stub);
	$::FIND = "/usr/bin/find";

    if ($::DISTRO_VERSION lt '5') {
	    # 1. Find kernel package from install image
	    my $csmserver =
	      $ENV{'CSMINSTALL_ROOT'} ? $ENV{'CSMINSTALL_ROOT'} : $::CSMINSTDIR;
	    if ($svclevel ne "GA")
	    {
	    	$pkgs_basedir =
	    	    $csmserver . "/Linux"
	    	  . "/$::DISTRO_NAME"
	    	  . "/$::DISTRO_VERSION"
	    	  . "/$::ARCH"
	    	  . "/$::DISTRO_NAME$::DISTRO_VERSION-$svclevel"
	    	  . "/RPMS/";
	    }
	    else
	    {
	    	$pkgs_basedir =
	    	    $csmserver . "/Linux"
	    	  . "/$::DISTRO_NAME"
	    	  . "/$::DISTRO_VERSION"
	    	  . "/$::ARCH"
	    	  . "/$::DISTRO_NAME$::DISTRO_VERSION-$::ARCH"
	    	  . "/RPMS/";
	    }
	    if ($::DISTRO_VERSION eq "3")
	    {
	    	$cmd = "$::FIND $pkgs_basedir -name kernel-2*ppc64pseries.rpm";
	    }
	    elsif ($::DISTRO_VERSION eq "4" || $::DISTRO_VERSION =~ /4\./)
	    {
	    	$cmd = "$::FIND $pkgs_basedir -name kernel-2*ppc64.rpm";
	    }
	    my @filelist = NodeUtils->runcmd($cmd, -1);
	    if ($::RUNCMD_RC)
	    {
	    	MessageUtils->messageFromCat(
	    								 'csmInstall.cat', $::MSGMAPPATH,
	    								 'csminstall',     'I',
	    								 'IMsgShow_Output', join('\n', @filelist)
	    								);
	    	return $::RUNCMD_RC;
	    }
	    $k_pkg = $filelist[0];

	    # 2. Extract kernel package
	    $extract_dir = "$tmpdir/extract";
	    if (-d $extract_dir)
	    {
	    	rmtree($extract_dir, $::VERBOSE, 1);
	    }
	    mkpath($extract_dir, $::VERBOSE, 0755);

	    $cmd = "cd $extract_dir; $::RPM2CPIO $k_pkg | cpio -idu --quiet;";
	    NodeUtils->runcmd($cmd, -1);
	    if ($::RUNCMD_RC)
	    {
	    	rmtree($extract_dir, $::VERBOSE, 1);
	    	MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
	    								 'csminstall', 'I', 'IMsgShow_Output',
	    								 $output);
	    	return $::RUNCMD_RC;
	    }

	    #3. Find the kernel stub file
	    if ($::DISTRO_VERSION eq "3")
	    {

	    	# command to locate the stub file to rebuild ppc zimage
	    	$cmd = "$::LS $extract_dir/boot/vmlinuz-partial*";
	    }
	    elsif ($::DISTRO_VERSION eq "4" || $::DISTRO_VERSION =~ /4\./)
	    {

	    	# command to locate the stub file to rebuild ppc zimage
	    	$cmd = "$::LS $extract_dir/boot/zImage.stub*";
	    }
	    @filelist = NodeUtils->runcmd($cmd, -1);
	    if ($::RUNCMD_RC)
	    {
	    	MessageUtils->messageFromCat(
	    								 'csmInstall.cat', $::MSGMAPPATH,
	    								 'csminstall',     'I',
	    								 'IMsgShow_Output', join('\n', @filelist)
	    								);
	    	return $::RUNCMD_RC;
	    }
	    $kernel_stub = $filelist[0];
    }

	# 4. Rebuild zImage according to RHEL Distribution Version
	if (NodeUtils->get_DistributionVersion eq "3")
	{
		if ($::DISTRO_VERSION eq "3")
		{
			$cmd =
			  "cd $tmpdir; $::MKZIMAGE $kernel_stub $tmpdir/csm_zimage.tmp $ramdisk";
		}
		else
		{
			$cmd =
			  "cd $tmpdir; $::OBJCOPY -F elf32-powerpc $kernel_stub $tmpdir/zImage.bits.tmp --add-section .kernel:vmlinux=$kernel --set-section-flags .kernel:vmlinux=contents,alloc,load,readonly,data --add-section .kernel:initrd=$ramdisk --set-section-flags .kernel:initrd=contents,alloc,load,readonly,data && ld -m elf32ppclinux -Ttext 0x00400000 -e _start -T /usr/share/ppc64-utils/zImage.lds -o $tmpdir/csm_zimage.tmp $tmpdir/zImage.bits.tmp";
		}
	}
	elsif (NodeUtils->get_DistributionVersion eq "4" || NodeUtils->get_DistributionVersion =~ /4\./)
	{
		if ($::DISTRO_VERSION eq "3")
		{
			$cmd =
			  "cd $tmpdir; $::MKZIMAGE no no no $ramdisk $kernel_stub $tmpdir/csm_zimage.tmp";
		}
		else
		{
			$cmd =
			  "cd $tmpdir; $::MKZIMAGE $kernel no no $ramdisk $kernel_stub $tmpdir/csm_zimage.tmp";
		}
	}
    elsif (NodeUtils->get_DistributionVersion eq "5") {
        if ($::DISTRO_VERSION eq "5") {
            $cmd
            = "cd $tmpdir; $::MKZIMAGE $kernel no no $ramdisk "
            . "/usr/share/ppc64-utils/zImage.stub $tmpdir/csm_zimage.tmp";
        }
        elsif ($::DISTRO_VERSION eq "4" || $::DISTRO_VERSION =~ /4\./) {
            # exract the lds file ...
            extractRPMAndCopyFile( 
                $svclevel, 
                "ppc64-utils", 
                "/usr/share/ppc64-utils/zImage.lds",
                "$tmpdir/zImage.lds.rhel4"
            );
            if ($::RUNCMD_RC) {
                exit -1;
            }

            $cmd 
            = "cd $tmpdir;"
            # objcopy
            . "$::OBJCOPY -F elf32-powerpc $kernel_stub "
            . "$tmpdir/zImage.bits.tmp "
            . "--add-section .kernel:vmlinux=$kernel "
            . '--set-section-flags \
            .kernel:vmlinux=contents,alloc,load,readonly,data '
            . "--add-section .kernel:initrd=$ramdisk "
            . '--set-section-flags \
            .kernel:initrd=contents,alloc,load,readonly,data '
            . ' && '
            # ld ...
            . 'ld -m elf32ppclinux -Ttext 0x00400000 '
            . "-e _start -T $tmpdir/zImage.lds.rhel4 "
            . "-o $tmpdir/csm_zimage.tmp $tmpdir/zImage.bits.tmp";
        }
        elsif ($::DISTRO_VERSION eq "3") {
            # exract the lds file ...
            extractRPMAndCopyFile( 
                $svclevel, 
                "ppc64-utils", 
                "/usr/share/ppc64-utils/zImage.lds",
                "$tmpdir/zImage.lds.rhel3"
            );
            if ($::RUNCMD_RC) {
                exit -1;
            }

            # learn from RHEL4 building RHEL3 above ...
            $cmd 
            = "cd $tmpdir;"
            # objcopy
            . "$::OBJCOPY -F elf32-powerpc $kernel_stub "
            . "$tmpdir/zImage.bits.tmp "
            . "--add-section .kernel:initrd=$ramdisk "
            . '--set-section-flags \
            .kernel:initrd=contents,alloc,load,readonly,data '
            . ' && '
            # ld ...
            . 'ld -m elf32ppclinux -Ttext 0x00400000 '
            . "-e _start -T $tmpdir/zImage.lds.rhel3 "
            . "-o $tmpdir/csm_zimage.tmp $tmpdir/zImage.bits.tmp";
        }
    }

	NodeUtils->runcmd($cmd, -1);
	if ($::RUNCMD_RC)
	{
		rmtree($extract_dir, $::VERBOSE, 1) if $extract_dir;
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'I', 'IMsgShow_Output',
									 $output);
		return $::RUNCMD_RC;
	}

	move("$tmpdir/csm_zimage.tmp", "$zimage");
	NetworkUtils->setDefaultFilePermission("$zimage");

	# 4. Do cleanup
	rmtree($extract_dir, $::VERBOSE, 1) if $extract_dir;

	return 0;
}

sub collectInstallServerAKBServer
{

	#colloect all InstallServerAKBNodes
	my @akb_servers;

	foreach my $node (@targetNodes)
	{
		my $server = $nodeHash{$node}{"InstallServerAKBNode"};
		if (!$server)
		{
			($server, undef) = split(/:/, $nodeHash{$node}{"InstallServer"});
		}

		if (!$server)
		{
			$server = $nodeHash{$node}{"ManagementServer"};
		}

		if (!$server)
		{
			MessageUtils->messageFromCat('nodecmds.cat', $::MSGMAPPATH,
					   'mgmtsvr', 'E2', 'EMsgManagementServerInvalid', $server);
		}

		my ($server_host, $server_ip) = NetworkUtils->getHost_rveg($server);
		if ($::GETHOST_RC == $::OK)
		{
			push @akb_servers, $server_ip
			  if (!grep(/^$server_ip$/, @akb_servers));
		}
		else
		{
			MessageUtils->messageFromCat('nodecmds.cat', $::MSGMAPPATH,
								'NodeUtils', 'E2', 'EMsgBAD_HOSTNAME', $server);
		}
	}

	return @akb_servers;
}

#--------------------------------------------------------------------------------

=head3   hackAutoyastzImage

        Notes: 

=cut

#--------------------------------------------------------------------------------
sub hackAutoyastzImage
{
	my ($netboot_kernel, $svclevel, $ref_akb_servers, $installdir, $hack) = @_;
	my ($kernelparameters, $new_zimage, $cmd, $output);
	# command and temporay dir will be used to hack zImage
	$::OBJCOPY  = "/usr/bin/objcopy";
	$::CSMTMP   = "/var/opt/csm/tmp";

	my %old_pkgdefs = %::pkgdefs;
	my %is_pkgdefs  = ServerUtils->get_pkgdefs();
	%::pkgdefs = %old_pkgdefs;

	if ($hack)
	{
		MessageUtils->messageFromCat(
									 'csmInstall.cat',
									 $::MSGMAPPATH,
									 'csminstall',
									 'I',
									 'IMsgADD_BUILT_IN_YAST_PARAMS'
									);
	}

	foreach my $installserver (@{$ref_akb_servers})
	{

		$new_zimage = $netboot_kernel . "_" . $installserver;
		&copyfile($netboot_kernel, $new_zimage);
		NetworkUtils->setDefaultFilePermission("$new_zimage");
		# Do not hack zimage if prerequisate utils are not found
		if (!$hack) { next; }
		# Clean up tmp dir
		my $tmpdir =
				$::CSMTMP . "/"
				. $::DISTRO_NAME
				. $::DISTRO_VERSION . "-"
				. $svclevel;    # e.g. /tmp/ks4
		if (-d $tmpdir)
		{
			rmtree($tmpdir, $::VERBOSE, 1);
		}
		mkpath($tmpdir, $::VERBOSE, 0755);
		# Extract kernel and ramdisk from zImage
		# only when is's version equal or greater than mn's version
		# i.e. doesn't support sles9 hack sles10 now
		if (NodeUtils->get_DistributionVersion >= $::DISTRO_VERSION)
		{
		    my ($kernel, $ramdisk) = &extractPPCzImage($new_zimage, $tmpdir);
		    if (!$kernel || !$ramdisk)
		    {
		    	MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
		    						'csminstall', 'I', 'IMsgCANT_EXTRACT_ZIMAGE', $new_zimage);
		    	next;
		    }
		    &makeAutoyastRAMDisk('',$ramdisk);
		    &buildSLESzImage($ramdisk,$kernel,$new_zimage);
		    &copyfile($new_zimage, $netboot_kernel);
		}

		my $disable_recurtive = 1;
		NetworkUtils->setDefaultFilePermission("$new_zimage", $disable_recurtive);
	}

	return;
}

sub buildSLESzImage{
    my ($ramdisk, $kernel, $new_zimage) = @_;
    my $cmd = "$::GUNZIP $kernel";
    $kernel =~ s/\.gz$//;
    NodeUtils->runcmd($cmd, 0);
    if(NodeUtils->get_DistributionVersion eq '10'){
	$cmd = "env -u POSIXLY_CORRECT /lib/lilo/scripts/make_zimage_chrp.sh --vmlinux $kernel --initrd $ramdisk --output $new_zimage";
    }
    else{
	$cmd = "env -u POSIXLY_CORRECT /lib/lilo/chrp/chrp64/make_zimage_chrp64.sh --vmlinux $kernel --initrd $ramdisk --output $new_zimage";
    }
    NodeUtils->runcmd($cmd, 0);
}

#--------------------------------------------------------------------------------
=head3  copy_templates

         Copy templates files to /csminstall/csm/templates

        Notes:

=cut

#--------------------------------------------------------------------------------

sub copy_templates
{
	my ($class, $installmethod, $ref_nodelist, $ref_ishash) = @_;
	my $cmd;
	my $template_dir = "/csminstall/csm/templates";
	my $src_dir      = "/opt/csm/install";
	my @pxe_templates = (
				   'default.pxe',          'getmacs.pxe',
				   'install.pxe',          'install_HTTP.pxe',
				   'install_UUID.pxe',     'yastinstall.pxe',
				   'yastinstall_HTTP.pxe', 'yastinstall_UUID.pxe',
				   'csm_rhloader_param.tmpl',
				   'yasthwmaint.pxe',      'yasthwmaint_UUID.pxe',
				   'kshwmaint.pxe',        'kshwmaint_UUID.pxe',
				   'csm_rhloader_param_HTTP.tmpl',	
						);
    if (!defined($ENV{'DC_ENVIRONMENT'}) || $ENV{'DC_ENVIRONMENT'} eq "CSM")
    {
        push @pxe_templates, 'displaymac.tmpl';
    }

    if (!NodeUtils->isAIX())
    {
    	push @pxe_templates, 'warewulf.pxe';
    }

	# Do not copy these files more than once
	if (!$::COPY_TEMPLATES{'ALREADY_RUN'} && !$::COPY_TEMPLATES{'HWMAINT'})
	{
		my $template_scripts_dest = "$template_dir/scripts";
		my $template_scripts_src  = "$src_dir/templatescripts";

		mkpath($template_dir, $::VERBOSE, 0755);

		foreach my $file (@pxe_templates)
		{
			$cmd = "$::CP -r $src_dir/$file $template_dir";
			NodeUtils->runcmd($cmd, -2);
		}

		mkpath($template_scripts_dest, $::VERBOSE, 0755);

		$cmd = "$::CP -r $template_scripts_src/* $template_scripts_dest";
		NodeUtils->runcmd($cmd, -2);

		my ($cfg_dir, $cfg_name);
	}

	mkpath("$template_dir/tmpl", $::VERBOSE, 0755);
	foreach my $node (@$ref_nodelist)
	{
		# Do not copy templates for same node/installmethod more than once
		# one node will not have more than one instal method in one command
		if ($::COPY_TEMPLATES{$node}{$installmethod})
		{
			next;
		}	
		my $nodetemplate = NodeUtils->getNodeTemplate($node, $installmethod);
		
		if ($nodetemplate)
		{
			if ($installmethod eq "warewulf")
			{
				#Warewulf copying templates start
				#So far, warewulf don't supprot AIX diskless node.
				if (!NodeUtils->isAIX())
				{
					my $installset = "$::NODEHASH{$node}{'InstallDistributionName'}$::NODEHASH{$node}{'InstallDistributionVersion'}-$::NODEHASH{$node}{'InstallServiceLevel'}-$::NODEHASH{$node}{'InstallPkgArchitecture'}";
					NodesetUtils->copy_warewulf_config_files($installset, $src_dir, $template_dir);
					NodesetUtils->copy_warewulf_templates($nodetemplate, $template_dir);
				}
			}
			else
			{
				$cmd = "$::CP -L $nodetemplate $template_dir/tmpl/$node.cfg";
				NodeUtils->runcmd($cmd, -2);

				# The configure file will be copy to IS, 
				# and be substituted on the IS. In COEX 
				# environments, there are no 
				# EFFECTIVE_DISTRO_VERSION and so on
				# in lower version CSM
				my $is = $::NODEHASH{$node}{'InstallServer'};
				if (
				    exists($$ref_ishash{$is}) &&
				    $$ref_ishash{$is}{'InstallCSMVersion'} &&
				    $$ref_ishash{$is}{'InstallCSMVersion'} lt NodeUtils->get_CSMVersion('csm.core'))
				{
				   $cmd = "perl -pi -e 's/EFFECTIVE_DISTRO_VERSION/DISTRO_VERSION/g; s/EFFECTIVE_DISTRO_NAME/DISTRO_NAME/g;' $template_dir/tmpl/$node.cfg";
				   NodeUtils->runcmd($cmd, -2);
				}
			}
		}
		$::COPY_TEMPLATES{$node}{$installmethod} = 1;
		#it should have no else.
	}

	if ($::HWMAINT)
	{
		$::COPY_TEMPLATES{'HWMAINT'} = 1;
		return;
	}

	if (!$::COPY_TEMPLATES{'ALREADY_RUN'})
	{
		# Parameters to put into RHEL ppc zImage
		if ($installmethod eq "kickstart" || $installmethod eq "kickstart-upgrade")
		{
			$cmd =
		  	"$::CP -L  $template_dir/csm_rhloader_param.tmpl $template_dir/tmpl/rhloader.cfg";
			NodeUtils->runcmd($cmd, -2);
			$cmd =
		  	"$::CP -L  $template_dir/csm_rhloader_param_HTTP.tmpl $template_dir/tmpl/rhloader_HTTP.cfg";
			NodeUtils->runcmd($cmd, -2);
		}
	}
	$::COPY_TEMPLATES{'ALREADY_RUN'} = 1;
}

############################################################################
#
#       setupInstall
#               setup autoyast or kickstart by NodesetUtils->run_setupBoot
#
#       Note:
#               This function is one merged function. Old code is taken from
#               setup_kickstart in csmsetupks and setup_autoyast in csmsetupyast
#
#       Arguments:
#               setup method. Only "autoyast" and "kickstart" is allowed
#
#       Globals:
#               @::NODELIST
#               $::DEBUG
#
#       Returns:
#
#############################################################################
sub setupInstall
{
	my ($class, $method) = @_;
	if (   $method ne "autoyast"
		&& $method ne "kickstart"
		&& $method ne "kickstart-upgrade"
		&& $method ne "warewulf"
		&& $method ne "you")
	{
		MessageUtils->message('E1', 'EMsgInvalidMethod');
	}
	my $routine = "setup";
	print "ENTERING: $routine\n" if $::DEBUG;
	my ($cmd, $output, $returncode);
	$returncode = 0;

	my @nodeList = @::NODELIST;

	if ($method eq "autoyast")
	{
		unless (@nodeList)
		{
			MessageUtils->message('I', 'IMsgNO_NODES_TO_AUTOYAST_SETUP');
			return 0;
		}
		MessageUtils->message('I', 'IMsgSETUP_YAST');
	}
	elsif ($method eq "kickstart" or $method eq "kickstart-upgrade")
	{
		unless (@nodeList)
		{
			MessageUtils->message('I', 'IMsgNO_NODES_TO_KICKSTART_SETUP');
			return 0;
		}
		MessageUtils->message('I', 'IMsgSETUP_KICKSTART');
	}
	elsif ($method eq "warewulf")
	{
		unless (@nodeList)
		{
				MessageUtils->message('I', 'IMsgNO_NODES_TO_WAREWULF_SETUP');
				#print "no nodes to warewulf setup\n";
				return 0;
		}
		MessageUtils->message('I', 'IMsgSETUP_WAREWULF');
	}
	elsif ($method eq "you")
	{
		unless (@nodeList)
		{
				MessageUtils->message('I', 'IMsgNO_NODES_TO_YOU_SETUP');
				#print "no nodes to you setup\n";
				return 0;
		}
		MessageUtils->message('I', 'IMsgSETUP_YOU');
	}

	$method = "hwmaint" if ($::HWMAINT);
	DCUtils->run_setupBoot($method, 'no', \@nodeList, \%::NODEHASH);

	print "LEAVING: $routine\n" if $::DEBUG;
	return $NodesetUtils::BOOT_EXIT;
}

#-------------------------------------------------------------------------------

=head3    get_NetworkInstallProtocol

        Get the value of NetworkInstallProtocol from IBM.DmsCtrl.  
	The first time the DmsCtrl attribute is obtained, it is cached, so 
	that the next time get_NetworkInstallProtocol is called, the cached 
	copy is returned.  When this subroutine is called from an install
	server that is not the management server, the NETWORK_INSTALL_PROTOCOL
	environment variable must be set.

        Arguments:
                none
        Returns:
                value from database, cache or NETWORK_INSTALL_PROTOCOL env var.
        Globals:
                $::__NETWORK_INSTALL_PROTOCOL (do not reference this directly)
        Error:
                undefined
        Example:
                $install_protocol =
                    NodesetUtils->get_NetworkInstallProtocol();
        Comments:
                none

=cut

#-------------------------------------------------------------------------------

sub get_NetworkInstallProtocol
{
	if ($ENV{'DC_ENVIRONMENT'})
	{
		require DCUtils;
		if (DCUtils->get_NetworkInstallProtocol)
		{
			return DCUtils->get_NetworkInstallProtocol;
		}
	}

	# If the NETWORK_INSTALL_PROTOCOL environment variable is set, it
	# overrides the value in the NetworkInstallProtocol DmsCtrl attribute.
	# This environment variable is normally only set when run_setupBoot() calls
	# nodeset.utils on the install server (because when running on the install
	# server, we do not have access to the IBM.DmsCtrl attributes.
	if (defined $ENV{"NETWORK_INSTALL_PROTOCOL"})
	{
		$::__NETWORK_INSTALL_PROTOCOL = $ENV{"NETWORK_INSTALL_PROTOCOL"};
	}

	# If the value is already cached, or set in the environment above, then
	# use it.  The global variable should not be used directly except within
	# this subroutine.
	if (!$::__NETWORK_INSTALL_PROTOCOL)
	{

		# set local scope because we only want classes on the mgmt svr
		$ENV{'CT_MANAGEMENT_SCOPE'} = 1;

		# todo: remove when lsrsrc-api converts to above
		$ENV{'CT_SESSION_SCOPE'} = 1;
		if (NodeUtils->isMgmtSvr())
		{    #only defined on managment server
			    #If need to get an attribute from IBM.DmsCtrl
			    #we get all cluster attributes once
			    #    using ServerUtils->get_cluster_attr function
			    #and set all global variables
			    #avoiding muticall lsrsrc-api command in each "get" subroutine.
			ServerUtils->get_cluster_attr;

			#$::__NETWORK_INSTALL_PROTOCOL has been set in last fuction

		}
	}

	if ($::__NETWORK_INSTALL_PROTOCOL !~ /nfs|http/i)
	{

		# Exit with error message if unsupported protocol.
		MessageUtils->messageFromCat(
									 'csmInstall.cat',
									 $::MSGMAPPATH,
									 'csminstall',
									 'E2',
									 'EMsgINVALID_NETWORK_INSTALL_PROTOCOL',
									 $::__NETWORK_INSTALL_PROTOCOL
									);
	}

	# Convert to lower case and return.
	return (lc($::__NETWORK_INSTALL_PROTOCOL));
}

#-------------------------------------------------------------------------------

=head3    get_SetupNetworkInstallProtocol

	Get the value of SetupNetworkInstallProtocol from IBM.DmsCtrl.  
	The first time the DmsCtrl attribute is obtained, it is cached, so 
	that the next time get_SetupNetworkInstallProtocol is called, the 
	cached copy is returned.  When this subroutine is called from an 
	install server that is not the management server, the 
	SETUP_NETWORK_INSTALL_PROTOCOL environment variable must be set.

        Arguments:
                none
        Returns:
                Value from database, cache or SETUP_NETWORK_INSTALL_PROTOCOL 
				    environment variable
        Globals:
                $::__SETUP_NETWORK_INSTALL_PROTOCOL 
				    (do not reference this directly)
        Error:
                undefined
        Example:
                $setup_install_protocol =
                    NodesetUtils->get_SetupNetworkInstallProtocol();
        Comments:
                none

=cut

#-------------------------------------------------------------------------------

sub get_SetupNetworkInstallProtocol
{
	if ($ENV{'DC_ENVIRONMENT'})
	{
		require DCUtils;
		if (DCUtils->get_SetupNetworkInstallProtocol)
		{
			return DCUtils->get_SetupNetworkInstallProtocol;
		}
	}

	# If the SETUP_NETWORK_INSTALL_PROTOCOL environment variable is set, it
	# overrides the value in the SetupNetworkInstallProtocol DmsCtrl attribute.
	# This environment variable is normally only set when run_setupBoot() calls
	# nodeset.utils on the install server (because when running on the install
	# server, we do not have access to the IBM.DmsCtrl attributes.
	if (defined $ENV{"SETUP_NETWORK_INSTALL_PROTOCOL"})
	{
		$::__SETUP_NETWORK_INSTALL_PROTOCOL =
		  $ENV{"SETUP_NETWORK_INSTALL_PROTOCOL"};
	}

	# If the value is already cached, or set in the environment above, then
	# use it.  The global variable should not be used directly except within
	# this subroutine.
	if (!$::__SETUP_NETWORK_INSTALL_PROTOCOL)
	{

		# set local scope because we only want classes on the mgmt svr
		$ENV{'CT_MANAGEMENT_SCOPE'} = 1;

		# todo: remove when lsrsrc-api converts to above
		$ENV{'CT_SESSION_SCOPE'} = 1;
		if (NodeUtils->isMgmtSvr())
		{

			#only defined on managment server
			#If need to get an attribute from IBM.DmsCtrl
			#we get all cluster attributes once
			#    using ServerUtils->get_cluster_attr function
			#and set all global variables
			#avoiding muticall lsrsrc-api command in each "get" subroutine.
			ServerUtils->get_cluster_attr;

			#$::__SETUP_NETWORK_INSTALL_PROTOCOL has been set in last function

		}
	}

	if ($::__SETUP_NETWORK_INSTALL_PROTOCOL !~ /1|0|yes|no/i)
	{

		# Exit with error message if unsupported protocol.
		MessageUtils->messageFromCat(
								   'csmInstall.cat',
								   $::MSGMAPPATH,
								   'csminstall',
								   'E2',
								   'EMsgINVALID_SETUP_NETWORK_INSTALL_PROTOCOL',
								   $::__SETUP_NETWORK_INSTALL_PROTOCOL
		);
	}

	# Convert to lower case and return.
	if ($::__SETUP_NETWORK_INSTALL_PROTOCOL =~ /1|yes/i)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}

#-------------------------------------------------------------------------------------

=head  remove_trace_on_MS
       remove all node's trace on ManagemetServer when removing a node

        Argument:
		$nodeName: node name that need removing.
		$nodeHashRef:  
        Returns:
		none
        Globals:
		none
        Error:
                undefined
        Example:
                NodesetUtils->remove_trace_on_MS($nodeName,$nodeHashRef );
        Comments:
                none
=cut

#-------------------------------------------------------------------------------------
sub remove_trace_on_MS
{
	my ($class, $nodeName, $nodeHashRef) = @_;
	my $shortName = NodeUtils->getShorthost($nodeName);
	my $ip        = NetworkUtils->validate_ip($nodeName);
	my ($a, $b, $c, $d) = split /\./, $ip;
	my $hexIP = sprintf("%02X%02X%02X%02X", $a, $b, $c, $d);
    my ($effective_distro_name) =
        NodeUtils->getEffectiveDistro(
                $$nodeHashRef{$nodeName}{InstallDistributionName});
	my $cmd;
	if ($$nodeHashRef{$nodeName}{InstallOSName} ne 'AIX')
	{
		$cmd =
		  "$::RM -rf /tftpboot/pxelinux.cfg/$hexIP /tftpboot/pxelinux.cfg/$nodeName.install /tftpboot/pxelinux.cfg/$nodeName.getmacs /tftpboot/pxelinux.cfg/$nodeName.warewulf;";
		$cmd .= "$::RM -rf /tftpboot/csm/$ip.gz;";
		$cmd .= "$::RM -rf /csminstall/csm/status/$nodeName.rebootready;";
		$cmd .= "$::RM -rf /csminstall/csm/templates/tmpl/$nodeName.cfg;";
	}
	if ($effective_distro_name =~ /RedHat/)
	{
		my $ksCfgDir =
		  "/csminstall/csm/$$nodeHashRef{$nodeName}{InstallCSMVersion}/kickstart.$$nodeHashRef{$nodeName}{InstallDistributionName}$$nodeHashRef{$nodeName}{InstallDistributionVersion}";
		$cmd .=
		  "$::RM -rf $ksCfgDir/$ip $ksCfgDir/$ip-kickstart $ksCfgDir/$nodeName-kickstart;";
	}
	if ($effective_distro_name =~ /SLES/)
	{
		my $yastCfgDir =
		  "/csminstall/csm/$$nodeHashRef{$nodeName}{InstallCSMVersion}/autoyast.$$nodeHashRef{$nodeName}{InstallDistributionName}$$nodeHashRef{$nodeName}{InstallDistributionVersion}";
		$cmd .=
		  "$::RM -rf $yastCfgDir/$ip.xml $yastCfgDir/$ip-autoyast.xml $yastCfgDir/$nodeName-autoyast.xml $yastCfgDir/$hexIP;";
	}
        if(-e '/cfmroot/'){
            NodeUtils->findAndRm('/cfmroot/', "*._$nodeName", 1);
            NodeUtils->findAndRm('/cfmroot/', "*._$shortName", 1) if ( $nodeName ne $shortName);
            NodeUtils->findAndRm('/cfmroot/', "*._$ip", 1) if ( $nodeName ne $ip);
        }
        if(-e '/csminstall/csm/scripts/'){
            NodeUtils->findAndRm('/csminstall/csm/scripts/', "*._$nodeName", 1);
            NodeUtils->findAndRm('/csminstall/csm/scripts/', "*._$shortName", 1) if ( $nodeName ne $shortName);;
            NodeUtils->findAndRm('/csminstall/csm/scripts/', "*._$ip", 1) if ( $nodeName ne $ip);
        }
	$cmd .=
	  "$::RM -rf /csminstall/csm/config/$nodeName.config_info /csminstall/csm/config/$ip.config_info /csminstall/csm/config/$shortName.config_info;";
	$cmd .= "$::RM -rf /csminstall/csm/status/$nodeName;";
        $cmd .= "$::RM -rf /csminstall/csm/status/$nodeName.cfmcomplete;";
        if(-e '/var/log/csm/'){
            NodeUtils->findAndRm('/var/log/csm/', "*.$nodeName.log*", 1);
            NodeUtils->findAndRm('/var/log/csm/',"*.$ip.log*", 1) if ( $nodeName ne $ip);
        }
	$cmd .= "$::RM -rf /var/log/consoles/$nodeName;";

	if ($$nodeHashRef{$nodeName}{InstallOSName} eq 'AIX')
	{
		$cmd .= "$::RM -rf /tftpboot/$nodeName ;";
		$cmd .= "$::RM -rf /tftpboot/$nodeName.info ;";
	}
	if ($$nodeHashRef{$nodeName}{'InstallMethod'} =~ /warewulf/)
	{
        NodeUtils->findAndRm('/etc/warewulf/nodes/', "$nodeName", 1);
	}

	NodeUtils->runcmd("$cmd", -1);
}

#-------------------------------------------------------------------------------------

=head  remove_trace_on_IS
       remove all node's trace on InstallServer when removing a node

        Argument:
		$nodeName: node name that need removing.
		$nodeHashRef:  
        Returns:
		none
        Globals:
		none
        Error:
                undefined
        Example:
                NodesetUtils->remove_trace_on_IS($nodeName,$nodeHashRef );
        Comments:
                none
=cut

#-------------------------------------------------------------------------------------
sub remove_trace_on_IS
{
	my ($class, $nodeName, $nodeHashRef) = @_;
	if ($$nodeHashRef{$nodeName}{InstallServer} eq '')
	{
		return;
	}
	else
	{
                my $ISDir = $$nodeHashRef{$nodeName}{ISDir};
                my @ISArray = @{$$nodeHashRef{$nodeName}{ISArrayRef}}; 
		my $shortName = NodeUtils->getShorthost($nodeName);
		my $ip        = NetworkUtils->validate_ip($nodeName);
		my ($a, $b, $c, $d) = split /\./, $ip;
		my $hexIP = sprintf("%02X%02X%02X%02X", $a, $b, $c, $d);
        my ($effective_distro_name) =
            NodeUtils->getEffectiveDistro(
                    $$nodeHashRef{$nodeName}{InstallDistributionName});
		my $cmd;
		if ($$nodeHashRef{$nodeName}{InstallOSName} ne 'AIX')
		{
			$cmd =
			  "$::RM -rf /tftpboot/pxelinux.cfg/$hexIP /tftpboot/pxelinux.cfg/$nodeName.install /tftpboot/pxelinux.cfg/$nodeName.getmacs;";
			$cmd .= "$::RM -rf /tftpboot/csm/$ip.gz;";
			$cmd .= "$::RM -rf  $ISDir/csm/status/$nodeName.rebootready;";
			$cmd .= "$::RM -rf  $ISDir/csm/templates/tmpl/$nodeName.cfg;";
		}

		if ($effective_distro_name =~ /RedHat/)
		{
			my $ksCfgDir =
			  "$ISDir/csm/$$nodeHashRef{$nodeName}{InstallCSMVersion}/kickstart.$$nodeHashRef{$nodeName}{InstallDistributionName}$$nodeHashRef{$nodeName}{InstallDistributionVersion}";
			$cmd .=
			  "$::RM -rf $ksCfgDir/$ip $ksCfgDir/$ip-kickstart $ksCfgDir/$nodeName-kickstart;";
		}
		if ($effective_distro_name =~ /SLES/)
		{
			my $yastCfgDir =
			  "$ISDir/csm/$$nodeHashRef{$nodeName}{InstallCSMVersion}/autoyast.$$nodeHashRef{$nodeName}{InstallDistributionName}$$nodeHashRef{$nodeName}{InstallDistributionVersion}";
			$cmd .=
			  "$::RM -rf $yastCfgDir/$ip.xml $yastCfgDir/$ip-autoyast.xml $yastCfgDir/$nodeName-autoyast.xml $yastCfgDir/$hexIP;";
		}

		$cmd .=
		  "$::RM -rf $ISDir/csm/config/$nodeName.config_info $ISDir/csm/config/$ip.config_info $ISDir/csm/config/$shortName.config_info;";
		$cmd .=
		  "/usr/bin/find  $ISDir/csm/scripts/ -name '*._$nodeName'|$::XARGS $::RM -rf;";
		$cmd .=
		  "/usr/bin/find  $ISDir/csm/scripts/ -name '*._$shortName'|$::XARGS $::RM -rf;";
		$cmd .=
		  "/usr/bin/find  $ISDir/csm/scripts/ -name '*._$ip'|$::XARGS $::RM -rf;";
		$cmd .= "$::RM -rf  $ISDir/csm/status/$nodeName;";

		if ($$nodeHashRef{$nodeName}{InstallOSName} eq 'AIX')
		{
			$cmd .= "$::RM -rf /tftpboot/$nodeName ;";
			$cmd .= "$::RM -rf /tftpboot/$nodeName.info ;";

		}
		my $nodeList = join ",", @ISArray;
		my $dshcmd = "$::DSH -v -n $nodeList \"$cmd\"";
		NodeUtils->runcmd("$dshcmd", -1);
	}
}
#-------------------------------------------------------------------------------------

=head  remove_RDMentry
       remove RDM entry  when removing a node

        Argument:
		$nodeHashRef:  
        Returns:
		none
        Globals:
		none
        Error:
                undefined
        Example:
                NodesetUtils->remove_RDMentry($nodeHashRef );
        Comments:
                none

#-------------------------------------------------------------------------------------
sub remove_RDMentry
{
	my ($class, $nodeHashRef) = @_;
	my %nodeHash = %$nodeHashRef;
	my @nodeList = keys %nodeHash;

	srand(time | $$);    #random number generator start
	my $rdmconfig_file = "/tmp/csm_$$";
	while (-e $rdmconfig_file)
	{
		$rdmconfig_file = ServerUtils->CreateRandomName($rdmconfig_file);
	}

	open(RDMCONFIG, ">$rdmconfig_file")
	  or die MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
						  'csminstall', 'E1', 'EMsgCANT_OPEN', $rdmconfig_file);
	print RDMCONFIG "<pxeconfig>\n";
	print RDMCONFIG "  <pxe>\n";

	my @allIS;
	my $entryExist = 0;
	foreach my $node (@nodeList)
	{
		if (   $nodeHash{$node}{'InstallPkgArchitecture'} =~ /ppc/
			|| $nodeHash{$node}{'InstallOSName'} eq 'AIX')
		{
			next;
		}
		my ($type, $key);
		my $uuid = $nodeHash{$node}{'UUID'};
		my $mac  = $nodeHash{$node}{'InstallAdapterMacaddr'};
		if ($mac)
		{
			$type = "mac";
			($key = $mac) =~ s/://g;    # Strip colons (:) from Macaddr
		}
		elsif ($uuid)
		{
			$type = "uuid";
			($key = $uuid) =~ s/ //g;    # Strip spaces from UUID
		}
		else
		{
			next;
		}
		print RDMCONFIG
		  "    <pxeclient type=\"$type\" action=\"respond\" op=\"remove\">\n";
		print RDMCONFIG "      <target>$key</target>\n";
		print RDMCONFIG "    </pxeclient>\n";

		my ($ISDir, @ISArray) =
		  &dealwith_IS_attr($$nodeHashRef{$node}{InstallServer});
		push @allIS, @ISArray if @ISArray and $ISArray[0] ne '';
		$entryExist = 1;
	}
	print RDMCONFIG "  </pxe>\n";
	print RDMCONFIG "</pxeconfig>\n";
	close(RDMCONFIG);
	if (!$entryExist)
	{
		unlink $rdmconfig_file;
		return;
	}

	my $cmd = "$::UPDATERDMDSERVER $rdmconfig_file";
	NodeUtils->runcmd($cmd, -1);

	#remove RDM entries on IS
	if (@allIS)
	{
		my $ISList = join ",", @allIS;
		$cmd = "/opt/csm/bin/dcp -n $ISList $rdmconfig_file /tmp/";
		NodeUtils->runcmd($cmd, -1);
		$cmd =
		  qq(/opt/csm/bin/dsh -n $ISList "$::UPDATERDMDSERVER $rdmconfig_file;$::RM -f $rdmconfig_file");
		NodeUtils->runcmd($cmd, -1);
	}

	unlink $rdmconfig_file;

}
=cut

#-------------------------------------------------------------------------------------

=head  remove_SMSentry
       remove RDM entry  when removing a node

        Argument:
		@nodeList  
        Returns:
		none
        Globals:
		none
        Error:
                undefined
        Example:
                NodesetUtils->remove_SMSentry(@nodeList );
        Comments:
                none
=cut

#-------------------------------------------------------------------------------------
sub remove_SMSentry
{
	if (-e '/csminstall/csm/config/sms.info')
	{
		my ($class, @nodeList) = @_;
		my @allEntries =
		  NodeUtils->runcmd("/bin/cat /csminstall/csm/config/sms.info", -1);
		if ($::RUNCMD)
		{
			return;
		}
		my $excludeNodes = join "|", @nodeList;
		@allEntries = grep !/$excludeNodes/, @allEntries;
		my $writeBackEntry = join "\n", @allEntries;
		NodeUtils->runcmd(
				   "echo \"$writeBackEntry\" > /csminstall/csm/config/sms.info",
				   -1);
	}
	return;
}

#-------------------------------------------------------------------------------------

=head  remove_group_trace
       remove group trace  when removing a node group 

        Argument:
		 $grpName 
        Returns:
		none
        Globals:
		none
        Error:
                undefined
        Example:
                NodesetUtils->remove_group_trace($grpName );
        Comments:
                none
=cut

#-------------------------------------------------------------------------------------
sub remove_group_trace
{
	my ($class, $grpName) = @_;
	my $cmd;
	$cmd = "/usr/bin/find /cfmroot/ -name '*._$grpName'|$::XARGS $::RM -rf;";
	$cmd .=
	  "/usr/bin/find /csminstall/csm/scripts/ -name '*._$grpName'|$::XARGS $::RM -rf;";
	NodeUtils->runcmd("$cmd", -1);
	$cmd = "/usr/bin/find /csminstall/Linux/ -name $grpName";
	my @grpDir = NodeUtils->runcmd("$cmd", -1);

	#grep /csminstall/Linux/SLES/9/ppc64/
	my @grpDir1 = grep /\/csminstall\/Linux\/[^\/]+\/[^\/]+\/[^\/]+\/install/,
	  @grpDir;
	my @grpDir2 = grep /\/csminstall\/Linux\/[^\/]+\/[^\/]+\/[^\/]+\/updates/,
	  @grpDir;

	#grep /csminstall/Linux/SLES/9/ppc64/SP1/
	my @grpDir3 =
	  grep /\/csminstall\/Linux\/[^\/]+\/[^\/]+\/[^\/]+\/[^\/]+\/install/,
	  @grpDir;
	my @grpDir4 =
	  grep /\/csminstall\/Linux\/[^\/]+\/[^\/]+\/[^\/]+\/[^\/]+\/updates/,
	  @grpDir;
	my $grpList = join " ", (@grpDir1, @grpDir2, @grpDir3, @grpDir4);
	$cmd = "$::RM -rf $grpList";
	NodeUtils->runcmd("$cmd", -1);
}

#---------------------------------------------------------------------------------------

=head remove_dhcp_entries
	remove nodelist entries in dhcp.conf file.

	Argument:
		@nodeArray
	Returns:
		none
	Globals:
		none
	Error:
		undefined
	Example:
		NodesetUtils->remove_dhcp_entries( @nodeArray);
	Comments:
		none
=cut

#----------------------------------------------------------------------------------------
sub remove_dhcp_entries
{
	my ($class, $nodeHashRef) = @_;
	my @nodeArray;
	foreach my $node (keys %$nodeHashRef)
	{
		push @nodeArray, $node if $$nodeHashRef{$node}{InstallOSName} ne 'AIX';
	}
	if (@nodeArray)
	{
		my $nodeFile;
		my $cmd;
		if (scalar(@nodeArray) > 500)
		{
			$nodeFile = ServerUtils->make_node_list_file(\@nodeArray);
		}
		if ($nodeFile)
		{
			$cmd = "/opt/csm/bin/mkdhcp --del -f $nodeFile 1>/dev/null 2>&1;";
		}
		else
		{
			my $nodeList = join(',', @nodeArray);
			$cmd = "/opt/csm/bin/mkdhcp --del -n $nodeList 1>/dev/null 2>&1;";
		}
		NodeUtils->runcmd("$cmd", -1);
		if ($nodeFile)
		{
			ServerUtils->close_delete_file($::NODE_LIST_FILE, $nodeFile);
		}
	}
}

#-------------------------------------------------------------------------------

=head3 getKernelParm

    read suitable kernel parameter from the global variable $::pkgdefs.
    so this variable has to be set first.

    Two values are accepted for $parmType, "install" and "hwmaintain".
    "install" stands for $::pkgdefs{'install_kernel_parameter'},
    and "hwmaintain" stands for $::pkgdefs{'hwmaintain_kernel_parameter'}.

=cut

#-------------------------------------------------------------------------------
sub getKernelParm
{
    my ($class, $parmType, $NodeHash) = @_;

    if (($parmType ne "install" && $parmType ne "hwmaintain") ||
            !defined($NodeHash))
    {
        return;
    }

    my %old_pkgdefs = %::pkgdefs;
    my %my_pkgdefs = ServerUtils->get_pkgdefs(
	'Linux',
	$NodeHash->{'InstallDistributionName'},
	$NodeHash->{'InstallDistributionVersion'},
	$NodeHash->{'InstallPkgArchitecture'},
	'MgdNode',
	$NodeHash->{'InstallCSMVersion'}
    );
    %::pkgdefs = %old_pkgdefs;
    my ($hwType, $hwModel, $svlLevel) = ($NodeHash->{'HWType'}, $NodeHash->{'HWModel'}, $NodeHash->{'InstallServiceLevel'});

    my $key = $parmType."_kernel_parameter";
    my @possibleParms = (
            $my_pkgdefs{$key}{$hwType}{$hwModel}{$svlLevel},
            $my_pkgdefs{$key}{$hwType}{$hwModel}{'all_svclevels'},
            $my_pkgdefs{$key}{$hwType}{'all_models'}{$svlLevel},
            $my_pkgdefs{$key}{'all_types'}{$hwModel}{$svlLevel},
            $my_pkgdefs{$key}{$hwType}{'all_models'}{'all_svclevels'},
            $my_pkgdefs{$key}{'all_types'}{$hwModel}{'all_svclevels'},
            $my_pkgdefs{$key}{'all_types'}{'all_models'}{$svlLevel},
            $my_pkgdefs{$key}{'all_types'}{'all_models'}{'all_svclevels'}
            );
    # try possible value one by one
    foreach my $parm (@possibleParms)
    {
        if ($parm && $parm ne "blank")
        {
            return $parm;
        }elsif ($parm eq "blank")
		{
            return;	
		}
    }
}

#-------------------------------------------------------------------------------
#
# This subroutine returns one corresponding Perl driver module.
# If the module file is in /csminstall/csm/drivers/pm, the file name without
# the directory is returned, for exmaple, a32raid.
# If tis module file is in /csminstall/csm/drivers/pm/custom, the file name
# with relative directory is returned, for exmaple, custom::a320raid
# 
#-------------------------------------------------------------------------------
sub findDriverCustPerlModule
{
    my ($class, $module, $kernelLvl, $arch) = @_;

    # remove the suffix
    $module =~ s/\.ko$//;
    $module =~ s/\.o$//;
    my $nok = 0;
    if (!-d $::moduleDir)
    {
        return $nok;
    }
    my $custModDir = "$::moduleDir/custom";
    my @possibleDirs = ($custModDir, $::moduleDir);
    my @possibleModules = ("$module._$kernelLvl._$arch.pm", "$module._$kernelLvl.pm", "$module.pm");
    foreach my $possibleMod (@possibleModules)
    {
        foreach my $dir (@possibleDirs)
        {
            if (-f "$dir/$possibleMod" && -x "$dir/$possibleMod")
            {
                if ($dir =~ m/\/custom$/)
                {
                    return ($possibleMod, "custom");
                }else
                {
                    return ($possibleMod);
                }
            }
        }
    }
    return $nok;
}

#-------------------------------------------------------------------------------

=head3

    updateDriver

        do special actions related to the modules against the Ramdisk

    Arguments:
        $ref_drivers    one reference that contains driver files
        $disName        node distribution name
        $disVer         node distribution version
        $disSvl         node service level
        $kernel_level   node kernel level
        $arch           node architecture
        $tmpDir         temp directory to place unzipped kernel

    Returns:

    Note:
        This subroutine supposes all driver names do not contain ".".
        If this is not the case in furture,
        one part should be rewritten to get real package name.

=cut

#-------------------------------------------------------------------------------
sub updateDriver
{
    my ($class, $ref_drivers, $disName, $disVer, $disSvl, $kernel_level, $arch, $tmpDir) = @_;
    my @drivers = @$ref_drivers;

    my @files = glob("$::moduleDir/*");
    if (-d "$::moduleDir" && scalar(@files))
    {
        my $dir = Cwd::getcwd();
        # run post_copy of all modules           
        foreach my $driver (@drivers)
        {
            # move possible directory
            my $driverFile = $driver;
            $driverFile =~ s/\S+\///;
            my ($moduleFile, $subDir) = NodesetUtils->findDriverCustPerlModule($driverFile, $kernel_level, $arch);
            if ($moduleFile)
            {
                # cd the directory to load target file				
                if ($subDir eq "custom")
                {
                    chdir "$::moduleDir/$subDir" or next;
                }else
                {
                    chdir $::moduleDir or next;
                }
                eval
                {
                    require $moduleFile;
                    my ($package) = $moduleFile =~ m/^(.+?)\./;
                    # get the real package name
                    # for example, $moduleFile = "bcm5700._2.6.9-34.EL._i386.pm",
                    # while $package = "bcm5700"
                    $package->post_copy($disName, $disVer, $disSvl, $arch, $tmpDir, $driver);
                };
				chdir $dir;
            }
        }

        # run final_post subroutine
        use lib $::moduleDir;
        require drivers_post;
        drivers_post->final_post($disName, $disVer, $disSvl, $arch, $tmpDir);
        my $custModDir = "$::moduleDir/custom";
        my $postModule = "drivers_post.pm";
        if (-f "$custModDir/$postModule")
        {
            require custom::drivers_post;
            eval{
                drivers_post->final_post($disName, $disVer, $disSvl, $arch, $tmpDir);
            };
        }
    }
}

sub getAutoyastModules
{
    my ($class, $disName, $disVer, $disSvl, $hwType, $hwModel) = @_;
    my ($ref_csm_modules, $ref_csm_explicit_mods) = NodesetUtils->getCSMAutoyastModules($disName, $disVer, $disSvl, $hwType, $hwModel);
    my ($ref_cust_modules, $ref_cust_explicit_mods) = NodesetUtils->getCustAutoyastModules($disName, $disVer, $disSvl, $hwType, $hwModel);

    # select out repeated modules
    my (@modules, @explicit_modules);
    foreach my $module (@$ref_csm_modules, @$ref_cust_modules)
    {
        if (!grep (/$module/g, @modules))
        {
            push @modules, $module;
        }
    }
    foreach my $module (@$ref_csm_explicit_mods, @$ref_cust_explicit_mods)
    {
        if (!grep (/$module/g, @explicit_modules))
        {
            push @explicit_modules, $module;
        }
    }
    return (\@modules, \@explicit_modules);
}

sub getCSMAutoyastModules
{
    my ($class, $disName, $disVer, $disSvl, $hwType, $hwModel) = @_;
    my $yastModule = "AutoYast_drivers.pm";
    if (!-f "$::moduleDir/$yastModule")
    {
        return (undef, undef);
    }

    require AutoYast_drivers;
    my ($ref_modules, $ref_explicit_mods) = AutoYast_drivers->get_initrd_modules($disName, $disVer, $disSvl, $hwType, $hwModel);
    return ($ref_modules, $ref_explicit_mods);
}

sub getCustAutoyastModules
{
    my ($class, $disName, $disVer, $disSvl, $hwType, $hwModel) = @_;
	my $custModDir = "$::moduleDir/custom";
    my $yastModule = "AutoYast_drivers.pm";
    if (!-f "$custModDir/$yastModule")
    {
        return (undef, undef);
    }
    
    require custom::AutoYast_drivers;
    my ($ref_modules, $ref_explicit_mods);
    eval{
        ($ref_modules, $ref_explicit_mods) = AutoYast_drivers->get_initrd_modules($disName, $disVer, $disSvl, $hwType, $hwModel);    
    };
    return ($ref_modules, $ref_explicit_mods);
}

sub substituteWWMasterConf
{
     my (
		$hostname,         $alias,             
		$admin_adapter_name, $sharedfs_adapter_name, $cluster_adapter_name, $boot_adapter_name,
		$remoteshell,    $vnfs_dir, $host_ip, $if_cfg,    
		$mastertemplate, $masterfile, 
	    )
	     = @_;
	 NodeUtils->BackupWarewulfFile($masterfile);
	 if (!NodeUtils->IsCreateByCSM($masterfile))
	 {
	 		# Overwrite it if it is not created by CSM
			 NodeUtils->runcmd("$::CP -f $mastertemplate $masterfile " , -2);
	 }
	 
	 # Read this file firstly,
	 # If any CSMVARs, customize them.
	 open(READFILE, "<$masterfile")
			 || MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
							 'csminstall', 'E2', 'EMsgCANT_READ_FILE', "$masterfile");
	 my @content = <READFILE>;
	 close(READFILE);

	 open(MASTERFILE, ">$masterfile")
			 || MessageUtils->messageFromCat(
							 'csmInstall.cat',      $::MSGMAPPATH,
							 'csminstall',          'E2',
							 'EMsgCANT_WRITE_FILE', $masterfile
							 );

	 foreach my $line (@content)
	 {
			 $line =~	s/#CSMVAR:ISHostName#/$hostname/g;
			 $line =~	s/#CSMVAR:ISAlias#/$alias/g;
			 $line =~	s/#CSMVAR:ISAdminAdapterName#/$admin_adapter_name/g;
			 $line =~	s/#CSMVAR:ISSharedfsAdapterName#/$sharedfs_adapter_name/g;
			 $line =~	s/#CSMVAR:ISClusterAdapterName#/$cluster_adapter_name/g;
			 $line =~	s/#CSMVAR:ISBootAdapterName#/$boot_adapter_name/g;      
			 $line =~	s/#CSMVAR:ISRemoteShell#/$remoteshell/g;    
			 $line =~	s/#CSMVAR:ISVnfsDir#/$vnfs_dir/g;
			 $line =~	s/#CSMVAR:ISHostIP#/$host_ip/g; 
			 $line =~	s/#CSMVAR:ISIfcfg#/$if_cfg/g;
			 print MASTERFILE $line;
	 }
	 close(MASTERFILE);
}

sub substituteWWClientConf
{
	#shift(@_);
    my (
		$hostname,                 
		$clienttemplate, $clientfile, 
	   )
	   = @_;
	NodeUtils->BackupWarewulfFile($clientfile);
	if (!NodeUtils->IsCreateByCSM($clientfile))
	{
			# Overwrite it if it is not created by CSM
			NodeUtils->runcmd("$::CP -f $clienttemplate $clientfile " , -2);
	}

	# Read this file firstly,
	# If any CSMVARs, customize them.
	open(READFILE, "<$clientfile")
			|| MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
							'csminstall', 'E2', 'EMsgCANT_READ_FILE', "$clientfile");
	my @content = <READFILE>;
	close(READFILE);

	open(CLIENTFILE, ">$clientfile")
			|| MessageUtils->messageFromCat(
							'csmInstall.cat',      $::MSGMAPPATH,
							'csminstall',          'E2',
							'EMsgCANT_WRITE_FILE', $clientfile
							);

	foreach my $line (@content)
	{
			$line =~ s/#CSMVAR:ISHostName#/$hostname/g;

			print CLIENTFILE $line;
	}

	close(CLIENTFILE);
}


sub substituteWWNodeGrpConf
{
		#shift(@_);
        my (
		$node_admin_adapter_name, $node_sharedfs_adapter_name, $node_cluster_adapter_name, 
		$node_vnfs_dir, $svclevel,     
		$nodegrptemplate, $nodegrpfile 
	   	)
	  	= @_;
		NodeUtils->BackupWarewulfFile($nodegrpfile);
		#if (NodeUtils->WhetherToModifyFile($nodegrpfile))
		#{
				open(NODEGRPTEMPLATE, "<$nodegrptemplate")
						|| MessageUtils->messageFromCat(
										'csmInstall.cat',     $::MSGMAPPATH,
										'csminstall',         'E2',
										'EMsgCANT_READ_FILE', $nodegrptemplate
										);

				open(NODEGRPFILE, ">$nodegrpfile")
						|| MessageUtils->messageFromCat(
										'csmInstall.cat',      $::MSGMAPPATH,
										'csminstall',          'E2',
										'EMsgCANT_WRITE_FILE', $nodegrpfile
										);
				my $kernel = "csm/$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH"."z";
				my $initrd = "csm/ww-$::DISTRO_NAME$::DISTRO_VERSION-$svclevel-$::ARCH.gz";

				while (<NODEGRPTEMPLATE>)
				{
						s/#CSMVAR:NodeAdminAdapterName#/$node_admin_adapter_name/g;
						s/#CSMVAR:NodeSharedfsAdapterName#/$node_sharedfs_adapter_name/g;
						s/#CSMVAR:NodeClusterAdapterName#/$node_cluster_adapter_name/g;
						s/#CSMVAR:NodeVnfsName#/$node_vnfs_dir/g;
						s/#CSMVAR:KERNEL#/$kernel/g;
						s/#CSMVAR:WWINITRD#/$initrd/g;

						print NODEGRPFILE $_ ;

				}

				close(NODEGRPFILE) ;
				close(NODEGRPTEMPLATE);
		#}
}

sub substituteWWNodeConf
{
		#shift(@_);
        my (
		$node_hardwareaddr, $node_admin_ipaddr, $node_sharedfs_ipaddr, $node_cluster_ipaddr, 
		$node_admin_adapter_name , $node_cluster_adapter_name, $node_sharedfs_adapter_name, $node_gateway_ip,
		$nodetemplate, $nodefile 
	   )
	  = @_;

	open(NODETEMPLATE, "<$nodetemplate")
	  || MessageUtils->messageFromCat(
									  'csmInstall.cat',     $::MSGMAPPATH,
									  'csminstall',         'E2',
									  'EMsgCANT_READ_FILE', $nodetemplate
									 );
#    if (  -f "$nodefile" )
#	{
#		NodeUtils->runcmd("$::MV -f $nodefile $nodefile.precsm");
#	}	
	open(NODEFILE, ">$nodefile")
	  || MessageUtils->messageFromCat(
									  'csmInstall.cat',      $::MSGMAPPATH,
									  'csminstall',          'E2',
									  'EMsgCANT_WRITE_FILE', $nodefile
									 );
    # Warewulf depends on mac address of node to create /etc/hosts.
    # If it is empty, use "00:00:00:00:00:00" instead.
    chomp($node_hardwareaddr);
    if ($node_hardwareaddr eq "")
    {
        $node_hardwareaddr = "00:00:00:00:00:00";
    }

	while (<NODETEMPLATE>)
	{
		s/#CSMVAR:NodeHardwareAddr#/$node_hardwareaddr/g;
		s/#CSMVAR:NodeAdminIPAddr#/$node_admin_ipaddr/g;
		s/#CSMVAR:NodeSharedfsIPAddr#/$node_sharedfs_ipaddr/g;
		s/#CSMVAR:NodeClusterIPAddr#/$node_cluster_ipaddr/g;
        s/#CSMVAR:NodeAdminAdapterName#/$node_admin_adapter_name/g;
		s/#CSMVAR:NodeClusterAdapterName#/$node_cluster_adapter_name/g;
		s/#CSMVAR:NodeSharedfsAdapterName#/$node_sharedfs_adapter_name/g;
		s/#CSMVAR:NodeGatewayIP#/$node_gateway_ip/g;
		print NODEFILE $_;

	}

	close(NODEFILE);
	close(NODETEMPLATE);
}

# subroutines for deal with sles ramdisk
sub unpack_ramdisk
{
    my ($class, $ramdisk_filename, $ramdisk_format, $tmp_ramdisk_dir) = @_;
    if ( ! $tmp_ramdisk_dir)
    {
        my $tmp_dir = '/tmp';
        my $tmp_ramdisk_dir = "$tmp_dir/rd_$$";

        while ( -e $tmp_ramdisk_dir)
        {
            $tmp_ramdisk_dir = ServerUtils->CreateRandomName($tmp_ramdisk_dir);
        }
    }
    
    if (! -d $tmp_ramdisk_dir)
    {
        mkpath($tmp_ramdisk_dir, $::VERBOSE, 0755);
    }

    if ( $ramdisk_format eq 'ext' ||
         $ramdisk_format eq 'minix')
    {
        NodeUtils->runcmd( "$::MOUNT $ramdisk_filename $tmp_ramdisk_dir -o loop");
    }
    elsif( $ramdisk_format eq 'cpio')
    {
        my $old_dir = getcwd;
        chdir $tmp_ramdisk_dir;
        NodeUtils->runcmd( "$::CPIO -id --quiet< $ramdisk_filename");
        chdir $old_dir;
    }
    else
    {
        MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                'E1', 'EMsgInvalideRamdiskFormat',
                $ramdisk_format, join( ',', @::VALID_RAMDISK_FORMAT ));
    }
    return $tmp_ramdisk_dir;
}

sub pack_ramdisk
{
    my ($class, $ramdisk_filename, $ramdisk_format, $ramdisk_dir) = @_;
    
    my $tmp_dir = '/tmp';
    my $tmp_ramdisk_dir = "$tmp_dir/rd_$$";
   
    while ( -e $tmp_ramdisk_dir)
    {
        $tmp_ramdisk_dir = ServerUtils->CreateRandomName($tmp_ramdisk_dir);
    }

    if ( $ramdisk_format eq 'ext' ||
         $ramdisk_format eq 'minix')
    {
        NodeUtils->runcmd( "$::UMOUNT $ramdisk_dir");
    }
    elsif ( $ramdisk_format eq 'cpio')
    {
        NodeUtils->runcmd( "(cd $ramdisk_dir;find . -print | $::CPIO -H newc -o > $ramdisk_filename)");
    }
    else
    {
        MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                'E1', 'EMsgInvalideRamdiskFormat',
                $ramdisk_format, join( ',', @::VALID_RAMDISK_FORMAT ));
    }
    NodeUtils->runcmd( "$::RM -rf $ramdisk_dir", 0);
    return 1;
}

sub extend_ramdisk
{
    my $tmp_dir = '/tmp';
    my ($class, $ramdisk_filename, $ramdisk_format, $ramdisk_size) = @_;
    if ( $ramdisk_format eq 'cpio')
    {
        return 1;
    }
    elsif ( $ramdisk_format eq 'ext' || $ramdisk_format eq 'minix')
    {
        my $old_ramdisk_dir = "$tmp_dir/rd_$$";
        while ( -e $old_ramdisk_dir)
        {
            $old_ramdisk_dir = ServerUtils->CreateRandomName($old_ramdisk_dir);
        }
        mkpath($old_ramdisk_dir, $::VERBOSE, 0755);
        NodeUtils->runcmd( "$::MOUNT -o loop $ramdisk_filename $old_ramdisk_dir");
        my $new_ramdisk_filename = "$tmp_dir/rd_$$";
        while ( -e $new_ramdisk_filename)
        {
            $new_ramdisk_filename = ServerUtils->CreateRandomName($new_ramdisk_filename);
        }
        NodeUtils->runcmd( "$::DD if=/dev/zero of=$new_ramdisk_filename bs=1k count=$ramdisk_size 2>/dev/null");
        if ( $ramdisk_format eq 'ext')
        {
            NodeUtils->runcmd( "$::MKE2FS -qFm0 $new_ramdisk_filename $ramdisk_size");
        }
        else
        {
            NodeUtils->runcmd( "$::MKFS.minix -qFm0 $new_ramdisk_filename $ramdisk_size");
        }
        my $new_ramdisk_dir = "$tmp_dir/rd_$$";
        while ( -e $new_ramdisk_filename)
        {
            $new_ramdisk_filename = ServerUtils->CreateRandomName($new_ramdisk_filename);
        }
        mkpath($new_ramdisk_filename, $::VERBOSE, 0755);
        NodeUtils->runcmd( "$::MOUNT -o loop $new_ramdisk_filename $new_ramdisk_dir");
        my $old_dir = getcwd;
        chdir $old_ramdisk_dir;
        NodeUtils->runcmd( "$::FIND .|$::CPIO -dump $new_ramdisk_dir --quiet");
        chdir $old_dir;
        NodeUtils->runcmd( "$::UMOUNT $old_ramdisk_dir $new_ramdisk_dir");
        NodeUtils->runcmd( "$::RM $old_ramdisk_dir $new_ramdisk_dir");
        NodeUtils->runcmd( "$::MOVE $new_ramdisk_filename $ramdisk_filename -f");
        return 1;
    }
    else
    {
        MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                'E1', 'EMsgInvalideRamdiskFormat',
                $ramdisk_format, join( ',', @::VALID_RAMDISK_FORMAT ));
    }
}
#-----------------------------------------------------------------------------------

=head3 hackWarewulfimg

	copy drivers into init ramdisk and vnfs

	Arguments:
		$initd	   init ramdisk to be hacked
		$svclevel  service level 
		$vnfsdir   vnfs directory 	
	Returns:
	
	Globals:
		$::DISTRO_NAME, $::DISTRO_VERSIO,$::ARCH,$::TOP
	Examples:
		hackWarewulfimg("/tftpboot/wwinitrd.img","/vnfs");

	Comments:
=cut

#----------------------------------------------------------------------------------

sub hackWarewulfimg
{
		my ($initrd,$svclevel,$vnfsdir) = @_;
		&prepare_mount();
		my $tmpdir = "/tmp/ww";
 		my ($cmd,$rc,$output,$returncode);
		my @output;
		# Check whther there are customization drivers existed.
		my $default_dir = "/csminstall";
		if ($ENV{'CSMINSTALL_ROOT'}) { $default_dir = $ENV{'CSMINSTALL_ROOT'}; }
		my $src_dir = "$default_dir/csm/drivers";
		$cmd = "find $src_dir -regex \".*[k]*o\$\"";
		$output = NodeUtils->runcmd($cmd, -1);
        chomp($output);
		return if ($output eq "");
		if (-d $tmpdir)
		{
				rmtree($tmpdir, $::VERBOSE, 1);
		}
		mkpath($tmpdir, $::VERBOSE, 0755);
		
		#-------------------------------------------------
		# Unzip the ramdisk
		#-------------------------------------------------
		my $ramdisk = "$tmpdir/wwimg";

		$cmd = "$::GUNZIP --quiet -c $initrd > $ramdisk";

		# There is a trailing grabage issue ( rc=2 ) when gunzip the initrd file.
		# Don't post any error message for the time being.
		$output = NodeUtils->runcmd($cmd, -1);
		$rc = $::RUNCMD_RC;
		if ($rc != 2 && $rc > 0)
		{
				MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
								'csminstall', 'I', 'IMsgShow_Output', $output);
				$returncode = $rc;
		}

		#-------------------------------------------------
		# Mount the ramdisk to wwtmp so it can be modified
		#-------------------------------------------------
		my $wwtmp = "/tmp/ww" . "/wwtmp";
		
		# Warewulf make ext2/3 initrd.
		$wwtmp = NodesetUtils->unpack_ramdisk( $ramdisk,"ext" , $wwtmp);

		#---------------------------------------------------
		# Determine the kernel level
		#---------------------------------------------------
		my $module_path = "$wwtmp/lib/modules";
		my $kernel_level;
		my @driver_list;
		my $csm_moduledir;

		
		$cmd = `find $wwtmp/lib/modules -name \"2*\" | head -n 1`;
        $kernel_level = `basename $cmd`;
		# extract the kernel level from first line
		chomp $kernel_level;

		#--------------------------------------------------
		# Determine the driver list
		#--------------------------------------------------
		#$karch = `echo $::ARCH | sed \"s/i.86/i386/g\"`;
		#if ($kernel_level =~ /^2\.6/)
		if ($::DISTRO_NAME =~ /SLES/)
		{
				if (-d "$::TOP_DIR/$svclevel/drivers/$kernel_level/$::ARCH")
				{
						$csm_moduledir =
								"$::TOP_DIR/" . $svclevel . "/drivers/$kernel_level/$::ARCH";
				}
				else
				{
						$csm_moduledir =
								"$::TOP_DIR/" . $svclevel . "/drivers/$kernel_level";
				}
		}
		elsif ($::DISTRO_NAME =~  /RedHat/)
		{

				if ($svclevel eq "GA")
				{
						$csm_moduledir = "$::TOP_DIR/".
								$::DISTRO_NAME . $::DISTRO_VERSION . "-" . $::ARCH.
								"/drivers/$kernel_level";
						if (-d "$csm_moduledir/$::ARCH")
						{
								$csm_moduledir = "$csm_moduledir/$::ARCH";
						}

				}
				else
				{
						$csm_moduledir = "$::TOP_DIR/".
								$::DISTRO_NAME . $::DISTRO_VERSION . "-" . $svclevel.
								"/drivers/$kernel_level";
						if (-d "$csm_moduledir/$::ARCH")
						{
								$csm_moduledir =
										"$csm_moduledir/$::ARCH";
						}

				}
		}
		if (-d "$csm_moduledir")
		{
			$cmd = "cd $csm_moduledir; $::LS *.o";
			my @output = NodeUtils->runcmd("$cmd", -1);
			if ($::RUNCMD_RC != 0)
			{
				$cmd = "cd $csm_moduledir; $::LS *.ko";
				@output = NodeUtils->runcmd("$cmd", -1);
			}

			foreach my $driver (@output)
			{
				push(@driver_list, "$driver") if (-f "$csm_moduledir/$driver");
			}
		}		
		#--------------------------------------------------
		# Copy drivers into vnfs and init ramdisk
		#--------------------------------------------------
	
		foreach my $driver (@driver_list)
		{
			my ($module, undef) = split('\.', $driver);
			if ($module ne "")
			{
                my $target;
				$target = `cd $vnfsdir;find ./lib/modules/$kernel_level -name $driver | head -n 1`;
				chomp($target);
				if ($target ne "")
				{
					$target = `dirname $target`;
				}
				chomp($target);
				# If driver don't exist in modules dir, 
				# Get default location.
				if ($target eq "")
				{
					$target = "./lib/modules/$kernel_level/kernel/drivers/addon/e1000" if ($module =~ /e1000/);
         			$target = "./lib/modules/$kernel_level/kernel/drivers/addon/bcm5700" if ($module =~ /bcm5700/);
					$target = "./lib/modules/$kernel_level/kernel/drivers/message/fusion" if ($module =~ /mptbase/);
					$target = "./lib/modules/$kernel_level/kernel/drivers/message/fusion" if ($module =~ /mptctl/);
					$target = "./lib/modules/$kernel_level/kernel/drivers/message/fusion" if ($module =~ /mptlan/);
					$target = "./lib/modules/$kernel_level/kernel/drivers/message/fusion" if ($module =~ /mptscsih/);
					$target = "./lib/modules/$kernel_level/kernel/drivers/scsi" if ($module =~ /ips/);
				}
				if ($target eq "")
				{
					$target = "./lib/modules/$kernel_level/kernel/drivers/addon";
				}	
	            
				# Make path both in vnfs and initrd
				if (!-d "$wwtmp/$target")
	    		{
		  			mkpath("$wwtmp/$target");
	    		}
				if (!-d "$vnfsdir/$target")
				{
					mkpath("$vnfsdir/$target");
				}
				
				&copyfile("$csm_moduledir/$driver", "$wwtmp/$target");
				&copyfile("$csm_moduledir/$driver", "$vnfsdir/$target");

				#-----------------------------------------
				# Add driver name into load_module list
				# in order to load driver during diskless boot
				#-----------------------------------------

				my $ww_load_module = $wwtmp . "/etc/load_modules";
                @output=`$::GREP $module $ww_load_module`;
			    if(!@output)
			    {
        			open(LOADMODULE,">>$ww_load_module")
					 || MessageUtils->messageFromCat('csmInstall.cat',
                        $::MSGMAPPATH, 'csminstall', 'E2', 'EMsgCANT_READ_FILE',
                        $ww_load_module);

        			print LOADMODULE "$module\n";
        			close LOADMODULE;
    			}

			}
		}
	
		#-------------------------------------------------
		# Compute modules dependencies
		#-------------------------------------------------
		NodeUtils->runcmd("depmod -a -b $wwtmp $kernel_level",-2);
		if (-f "$vnfsdir/lib/modules/$kernel_level/modules.dep")
		{
			NodeUtils->runcmd("depmod -a -b $vnfsdir $kernel_level",-2);
		}
		#-------------------------------------------------
		# Unmount the ramdisk
		#-------------------------------------------------
		NodesetUtils->pack_ramdisk( $ramdisk, "ext", $wwtmp);

		#-------------------------------------------------
		# Zip up the ramdisk into $initrd
		#-------------------------------------------------
		$cmd    = "$::GZIP -f $ramdisk";
		$output = NodeUtils->runcmd($cmd, 0);
		$rc     = $::RUNCMD_RC;
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
						'csminstall', 'I', 'IMsgShow_Output',
						$output)
				if ($rc);
		$returncode = $rc if ($rc > $returncode);

		# Copy the new ramdisk to /tftpboot
		unlink $initrd;
		&copyfile("$ramdisk.gz", "$initrd");
		NetworkUtils->secureFilePermissions("$initrd", "0110", "0644");
		# Clean up the temporary directory
		rmtree($tmpdir, $::VERBOSE, 1);

		#ywend

}
#--------------------------------------------------------------------------------

=head3  copy_warewulf_templates 
        Notes: The nodes with the same InstallTemplate share the same warewulf templates, do not copy them more than once. 

Arguments:
		$nodetemplate - the node templates 
		$template_dir - the target template directory

Returns:
		N/A

=cut

#--------------------------------------------------------------------------------
sub copy_warewulf_templates()
{
	my ($class, $nodetemplate, $template_dir) = @_;

	# Do not copy the same template more than once
	if ($::WWTMPL_ALREADY_COPIED{$nodetemplate})
	{
		return;
	}

	my $template_ww_dest = "$template_dir/warewulf";

	#copy warewulf templates files
	mkpath($template_ww_dest, $::VERBOSE,0755);

	my $warewulfcfgdir = `basename $nodetemplate`;
	chomp($warewulfcfgdir);
	mkpath("$template_ww_dest/$warewulfcfgdir", $::VERBOSE,0755);
	my $cmd = "$::CP -f $nodetemplate/* $template_ww_dest/$warewulfcfgdir/";
	NodeUtils->runcmd($cmd, -2);
	$::WWTMPL_ALREADY_COPIED{$nodetemplate} = 1;
}

#--------------------------------------------------------------------------------

=head3  copy_warewulf_config_files 
        Notes: The nodes with the same Install* attributes share the same warewulf configuration files, do not copy them more than once. 

Arguments:
		$installset - the Install* attributes set 
		$src_dir - the source directory of warewulf configuration files
		$template_dir - the target configuration directory

Returns:
		N/A

=cut

#--------------------------------------------------------------------------------
sub copy_warewulf_config_files()
{
	my ($class, $installset, $src_dir, $template_dir) = @_;

	my $template_ww_dest = "$template_dir/warewulf";
	my $template_ww_src  = "$src_dir/warewulf";
	# same installset warewulf nodes share the same template
	# do not copy these templates more than once
	if ($::WWCFG_ALREADY_COPIED{$installset})
	{
		return;
	}
	#Warewulf vnfsrpm template
	my $template_vnfsrpm_dest = NodeUtils->GetVnfsDIRFromWarewulf();
	mkpath($template_vnfsrpm_dest, $::VERBOSE,0755);
	# Get vnfsrpmlist 
	my $vnfsfile = "vnfsrpm.$installset";
	if (! NodeUtils->IsCreateByCSM("$template_vnfsrpm_dest/$vnfsfile"))
	{
		NodeUtils->runcmd("$::CP -f $template_ww_src/$vnfsfile $template_vnfsrpm_dest/$vnfsfile");
	}

	#Warewulf basic configuration template files
	mkpath($template_ww_dest, $::VERBOSE, 0755);
	my @wwconf = ("wwinitrd.config.$installset", "master.conf", "client.conf");
	foreach my $wwconffile (@wwconf)
	{
		NodeUtils->runcmd("$::CP -f $template_ww_src/$wwconffile $template_ww_dest/$wwconffile");
	}

	$::WWCFG_ALREADY_COPIED{$installset} = 1;
}
#-----------------------------------------------------------------------------------

=head3 convertext2fs

	convert ext2 file system block size  into target value

	Arguments:
		$initrd	       init ramdisk to be converted
		$target_block  block size of target initrd
	Returns:
	        $initrd with 
	Examples:
		convertext2fs("/tftpboot/wwinitrd.img",4096);

	Comments:
=cut

#----------------------------------------------------------------------------------

sub convertext2fs
{
	my ($initrd,$target_block_size) = @_;
    &prepare_mount();
    my $tmpdir = "/tmp/ww";
    if (-d $tmpdir)
    {
    	rmtree($tmpdir, $::VERBOSE, 1);
    }
    mkpath($tmpdir, $::VERBOSE, 0755);
	#-------------------------------------------------
	# Unzip the ramdisk
	#-------------------------------------------------
	my $ramdisk = "$tmpdir/wwimg";
	my ($cmd , $output, $rc ,$returncode);
	$cmd = "$::GUNZIP --quiet -c $initrd > $ramdisk";

	# There is a trailing grabage issue ( rc=2 ) when gunzip the initrd file.
	# Don't post any error message for the time being.
	$output = NodeUtils->runcmd($cmd, -1);
	$rc = $::RUNCMD_RC;
	if ($rc != 2 && $rc > 0)
	{
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
							'csminstall', 'I', 'IMsgShow_Output', $output);
			$returncode = $rc;
	}

	#-------------------------------------------------
	# Mount the ramdisk to wwtmp so it can be modified
	#-------------------------------------------------
	my $ww_src_fs = "/tmp/ww" . "/wwtmp";

	# Warewulf make ext2/3 initrd.
	$ww_src_fs = NodesetUtils->unpack_ramdisk( $ramdisk,"ext" , $ww_src_fs);

	#-------------------------------------------------
	# Make target ext2 file system with new block size
	#-------------------------------------------------
	my $wwtmpfs = "/tmp/ww" . "/newext2fs";
	NodeUtils->runcmd( "$::DD if=/dev/zero of=$wwtmpfs bs=1k count=$::WW_MAX_INITRD_SIZE 2>/dev/null");
	NodeUtils->runcmd(
					"$::ECHO y | $::MKE2FS -b $target_block_size $wwtmpfs");
	my $ww_tar_fs = "/tmp/ww" . "/ww_target_fs";
	
	# Mount target file system
	$ww_tar_fs = NodesetUtils->unpack_ramdisk( $wwtmpfs , "ext", $ww_tar_fs);
	
	#-------------------------------------------------
	# Copy initrd content from src to target.
	#-------------------------------------------------
	
	NodeUtils->runcmd(
					"$::CP -a $ww_src_fs/* $ww_tar_fs/");

    #-------------------------------------------------
    # Unmount the ramdisk
    #-------------------------------------------------

    NodesetUtils->pack_ramdisk( $ramdisk, "ext", $ww_src_fs);
	NodesetUtils->pack_ramdisk( $wwtmpfs, "ext", $ww_tar_fs);

    #-------------------------------------------------
    # Zip up the ramdisk into $initrd
    #-------------------------------------------------
    $cmd    = "$::GZIP -f $wwtmpfs";
    $output = NodeUtils->runcmd($cmd, 0);
    $rc     = $::RUNCMD_RC;
    MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                        'csminstall', 'I', 'IMsgShow_Output',
                        $output)
              if ($rc);
    $returncode = $rc if ($rc > $returncode);
    
	# Copy the new ramdisk to $init
    unlink $initrd;
    &copyfile("$wwtmpfs.gz", "$initrd");
    NetworkUtils->secureFilePermissions("$initrd", "0110", "0644");
    # Clean up the temporary directory
    rmtree($tmpdir, $::VERBOSE, 1);
	return $returncode;
}
#-----------------------------------------------------------------------------------

=head3 export_vnfs
    Export vnfs directory for diskless nodes 
        and write exported directory into /etc/exports in case of nfs service restart
    The default directory is /csminstall/diskless/vnfs or /csmserver/diskless/vnfs
     
	Arguments:
    
	Returns:
	    None.
	Examples:
		NodesetUtils->export_vnfs();
    Comments:

        Note that this subroutine is valid for Linux diskless installation. 
=cut

#----------------------------------------------------------------------------------
sub export_vnfs
{
    my ($class) 
        = @_;
    my $output = "";
    # Get config info from /etc/warewulf/master.conf
    my $ref_master_hash
        = NodeUtils->get_config("$::WAREWULF_DEPLOY_DIR"
                               ."$::WAREWULF_MASTER_CONF_TMPL");
    my $is_hostname = $$ref_master_hash{'network'}{'nodename'};
    my ($bc, $netmask) = NetworkUtils->getNetmask($is_hostname);
    if (!defined $netmask)
    {
        MessageUtils->message("W", 'EMsgINVALID_NETMASK', $is_hostname);
        next;
    }
    my $subnet = NetworkUtils->subnet($is_hostname, $netmask);
    open(EXPORT, "< /etc/exports")
    || MessageUtils->messageFromCat(
        'csmInstall.cat',     $::MSGMAPPATH,
        'csminstall',         'E2',
        'EMsgCANT_READ_FILE', "/etc/exports"
    );
    while (<EXPORT>) {
        my $line = $_;
        chomp $line;
        if ( $line eq '# Warewulf exports #' ) {
            last;
        } else {
            $output .= "$line\n";
        }
    }
    close(EXPORT);
    $output .= "# Warewulf exports #\n";
    $output .= "# Do not edit below this line or it may be overwritten by wwmaster.exports! #\n";
    $output .= "$$ref_master_hash{'paths'}{'vnfs dir'}\t$subnet/$netmask(ro,no_root_squash,async)\n";
	open(EXPORT, ">/etc/exports")
	  || MessageUtils->messageFromCat(
									  'csmInstall.cat',      $::MSGMAPPATH,
									  'csminstall',          'E2',
									  'EMsgCANT_WRITE_FILE', "/etc/exports"
									 );
    print EXPORT "$output\n";
    close(EXPORT);

    # Export VNFS dir
    
    if ($::PLTFRM ne "AIX")
    {
        my $rc;
        my $cmd = "$::EXPORTFS -i -o ro,no_root_squash,async $subnet/$netmask:$$ref_master_hash{'paths'}{'vnfs dir'}";
        $rc = NodeUtils->run_cmd($cmd, "W", "ignore_errors");
        if ($rc)
        {
            MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                'csminstall', 'E', 'EMsgCANT_RUN', $cmd, $rc);
        }

    }
}

1;
