# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2006,2007 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 

##############################################################
# @(#)28   1.4   src/csm/core/pm/Rpm/Child/RsctRpmList.pm.perl, setup, csm_rfish, rfishs001b 8/14/06 04:51:22
##############################################################
#!/usr/bin/perl
use strict;

use Rpm::Rpm;
use Rpm::RpmList;
package RsctRpmList;
@RsctRpmList::ISA = qw( RpmList);

# why to overwrite this subrountine of father class:
# 
# If rsct.basic is installed on MS, IS or node,
# we need UPDATE rsct.basic together with other RSCT packages.
sub searchAllRpmsInDirList
{
    my $self = shift;
    my $dirListRef = shift;
    my $destDir = shift;
    $self->SUPER::searchAllRpmsInDirList($dirListRef, $destDir);

    my $basic_pkg = new Rpm('rsct.basic');
    if ($basic_pkg->isInstalled)
    {
        $self->addRpm($basic_pkg);
    }
    $self->SUPER::searchAllRpmsInDirList($dirListRef, $destDir);
}

# why to overwrite this subrountine of father class:
#
# If anyone of these two packages, rsct.basic and csm.client,
# are installed, we should not uninstall RSCT packages
sub uninstallAll
{
    my $self = shift;
    my $options = shift;
    my $returnCode = $::TRUE;

    my $basic_pkg = new Rpm('rsct.basic');
    my $client_pkg = new Rpm('csm.client');
    my $flagList = new RpmList('', $basic_pkg, $client_pkg);
    my @installed_pkgs = $flagList->getInstalledRpms();

    if (!scalar(@installed_pkgs))
    {
        $returnCode = $self->SUPER::uninstallAll($options);
    }
    return $returnCode;
}

1;
