# @(#)73   1.23.1.1   src/csm/core/pm/Rpm/RpmList.pm.perl, csmcore, csm_rfish, rfishs001b 3/19/07 04:18:58
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2006,2007 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
package RpmList;

my ($MSGCAT, $MSGMAPPATH, $MSGSET);
BEGIN
{
    @::VALID_SEARCHING_STYLE = ("MANDATORY", "OPTIONAL");
    @::VALID_UPDATING_STYLE = ("UPDATE_ONLY", "UPDATE_OR_INSTALL");
    @::VALID_GROUPING_STYLE = ("INDIVIDUAL", "GROUPED");
    
    $MSGCAT = 'csmInstall.cat';
    $MSGMAPPATH = $ENV{'CSM_MSGMAPS'} ? $ENV{'CSM_MSGMAPS'} : '/opt/csm/msgmaps';
    $MSGSET = 'csminstall';
    $::TRUE = 1;
    $::FALSE = 0;
}

umask(0022);   #  This sets umask for all CSM files so that group and world only
               #  have read permissions.
               #  To change it, simply use the umask call in your script, after
               #  the "use RpmList;" line

use Rpm::Rpm;
use Rpm::Child::TftpRpm;
use Rpm::Child::NoDepsRpm;
use Rpm::Child::KshRpm;
use NodeUtils;
use ServerUtils;
use strict;
#--------------------------------------------------------------------------------
=head3    new
	Create a new object of class RpmList

    Arguments:
        description	    self description of this RpmList
        list of Rpm	    the Rpms belong to this RpmList
    Returns:
        the reference of the RpmList object be created
    Globals:
        $::pkgdefs $::UNKNOWN $::FALSE
    Error:

    Example:
        my $perl_pkg = new Rpm('perl', '5');
        my $expect_pkg = new Rpm('expect', '4');
        my $ospr_ref{'InstallServer'} = new RpmList(
                'Management Server Operating System Prerequisites Packages',
                $perl_pkg,
                $expect_pkg
                );

    Comments:
=cut
#--------------------------------------------------------------------------------
sub new
{
    my $class = shift;
    my $description = shift;
    my $self = {};
    bless $self, $class;
    $self->{ "_rpms"} = {};
    $self->addRpms(@_);
    $self->{ "_searchingStyle"} = "MANDATORY";
    $self->{ "_isContainedInCds"} = 0;
    $self->{ "_updatingStyle"} = "UPDATE_OR_INSTALL";
    $self->{ "_installGroupingStyle"} = "GROUPED";
    # This attribute is only meaningful when _searchingStyle is "OPTIONAL".
    # By default _installGroupingStyle is ""GROUPED"",
    # that means CSM will not install/uninstall any packages,
    # if not all the packages in this list can be found.
    #
    # If _installGroupingStyle is set to "INDIVIDUAL",
    # CSM will try to install/uninstall as more packages as possible,
    # if not all the packages in this list can be found.

    $self->{ "_isPrompted"} = $::FALSE;
    $self->{ '_needToBeUninstall'} = $::FALSE;
    $self->{ '_description'} = $description;
    $self->{ '_needCompareVersionWithDest'} = $::FALSE;
    if ( defined %::pkgdefs)
    {
        $self->{ "_additionalRpmCommandOptions"} = $::pkgdefs{ "additionalRpmCommandOptions"};
    }
    else
    {
        $self->{ "_additionalRpmCommandOptions"} = "";
    }
    return $self;
}
#--------------------------------------------------------------------------------
=head3    getUpdatingStyle
	Get the update style and install grouping style

    Arguments:
        none
    Returns:
        update style and install grouping style in array environment
        update style in scalar environment
    Globals:
    Error:

    Example:

    Comments:
=cut
#--------------------------------------------------------------------------------
sub getUpdatingStyle
{
    my $self = shift;
    if (wantarray)
    {
        return ( $self->{'_updatingStyle'}, $self->{ "_installGroupingStyle"});
    }
    else
    {
        return $self->{'_updatingStyle'};
    }
}
#--------------------------------------------------------------------------------
=head3    setUpdatingStyle
	Set the update style and install grouping style

    Arguments:
        updatingStyle	    "UPDATE_ONLY" or "UPDATE_OR_INSTALL"
        installGroupingStyle    "INDIVIDUAL" or "GROUPED"
    Returns:
        none
    Globals:
        @::VALID_UPDATING_STYLE
        @::VALID_GROUPING_STYLE
    Error:
        messageFromCat E1
    Example:
        $_node_op_pkgs = new RpmList( 
            'Managed Node Optional Packages',
            new Rpm( 'autoupdate'),
            new Rpm( 'perl-RPM2')
            );
        $_node_op_pkgs->setUpdatingStyle( 'UPDATE_OR_INSTALL', 'INDIVIDUAL');
    Comments:
=cut
#--------------------------------------------------------------------------------
sub setUpdatingStyle
{
    my $self = shift;
    my $updatingStyle = shift;
    my $installGroupingStyle = shift;
    if ( $updatingStyle )
    {
        if ( grep /^$updatingStyle$/, @::VALID_UPDATING_STYLE)
        {
            $self->{ "_updatingStyle"} = $updatingStyle;
        }
        else
        {
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
					'csminstall', 'E1', 'EMsgInvalideParameterForRpmList', 'updatingStyle', $self->getDescription());
        }
    }
    
    if ( $installGroupingStyle)
    {
        if ( grep /^$installGroupingStyle$/, @::VALID_GROUPING_STYLE)
        {
            $self->{ "_installGroupingStyle"} = $installGroupingStyle;
        }
        else
        {
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
					'csminstall', 'E1', 'EMsgInvalideParameterForRpmList', 'installGroupingStyle', $self->getDescription());
        }
    }
}
#--------------------------------------------------------------------------------
=head3    setSearchingStyle
	Set the searching style of current RpmList object

    Arguments:
        searchingStyle	"MANDATORY" or "OPTIONAL"	
    Returns:
        none
    Globals:
        @::VALID_SEARCHING_STYLE
    Error:
        messageFromCat E1
    Example:
        $_node_op_pkgs = new RpmList( 
            'Managed Node Optional Packages',
            new Rpm( 'autoupdate'),
            new Rpm( 'perl-RPM2')
            );
        $_node_op_pkgs->setSearchingStyle( 'OPTIONAL');
    Comments:
=cut
#--------------------------------------------------------------------------------
sub setSearchingStyle
{
    my $self = shift;
    my $searchingStyle = shift;
    
    if ( $searchingStyle )
    {
        if ( grep /^$searchingStyle$/, @::VALID_SEARCHING_STYLE)
        {
            $self->{ "_searchingStyle"} = $searchingStyle;
        }
        else
        {
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
					'csminstall', 'E1', 'EMsgInvalideParameterForRpmList', 'searchingStyle', $self->getDescription());
        }
    }
}
#--------------------------------------------------------------------------------
=head3    getRpm
	Get the Rpm object identified by the given name

    Arguments:
        shortname	    rpm package's short name, such as 'perl'
    Returns:
        corresponding Rpm object to the shortname
    Globals:
    Error:
    Example:
    Comments:
=cut
#--------------------------------------------------------------------------------
sub getRpm
{
    my $self = shift;
    my $shortName = shift;
    return $self->{"_rpms"}->{$shortName};
}
#--------------------------------------------------------------------------------
=head3    getAllRpms
	Get all Rpm objects in currect RpmList object

    Arguments:
        none
    Returns:
        a hash of all Rpm objects with 'shortname' => 'rpm object' format
    Globals:
    Error:
    Example:
    Comments:
=cut
#--------------------------------------------------------------------------------
sub getAllRpms
{
    my $self = shift;
    return values( %{$self->{ "_rpms"}});
}
#--------------------------------------------------------------------------------
=head3    getAllRpmShortNames
	Get short names of all rpm packages representing by Rpm objects
	of current RpmList object.

    Arguments:
        none
    Returns:
        a array of short names
    Globals:
    Error:
    Example:
    Comments:
=cut
#--------------------------------------------------------------------------------
sub getAllRpmShortNames
{
    my $self = shift;
    my @shortNames;
    for my $rpm ( values %{$self->{ "_rpms"}})
    {
        push @shortNames, $rpm->getShortName();
    }
    return @shortNames;
}
#--------------------------------------------------------------------------------
=head3    searchAllRpmsInDirList
	Search the given directories list for all rpm packages represented by
	the Rpm objects of current RpmList object.

    Arguments:
        dirList	a array of directories
    Returns:
        a array of the Rpm objects which could not be found
    Globals:
    Error:
    Example:
    Comments:
        The goal is to set the corresponding attributes of the Rpm objects.
        Call searchAllRpmsInFileList to do the dirty works.
=cut
#--------------------------------------------------------------------------------
sub searchAllRpmsInDirList
{
    my $self = shift;
    my $dirListRef = shift;
    my $destDir = shift;
    my @dirList = @$dirListRef;
    
    my @files = NodeUtils->getFilePathListInDirList("*.rpm", @dirList);
    return $self->searchAllRpmsInFileList( \@files, $destDir);
}
#--------------------------------------------------------------------------------
=head3    searchAllRpmsInFileList
	Search the given files list for all rpm packages represented by
	the Rpm objects of current RpmList object.

    Arguments:
        files	a array of files
    Returns:
        a array of the Rpm objects which could not be found
    Globals:
    Error:
    Example:
    Comments:
        The goal is to set the corresponding attributes of the Rpm objects.
        Call searchHighestVersionInFileList of each Rpm object to do the 
        dirty works.
        Be called by searchAllRpmsInDirList.
=cut
#--------------------------------------------------------------------------------
sub searchAllRpmsInFileList
{
    my $self = shift;
    my $fileListRef = shift;
    my $destDir = shift;
    my @files = @$fileListRef;
    my @notFoundRpms;

    if (!$self->{'_isPrompted'})
    {
        MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                'csminstall', 'I', 'IMsgSearchingRpmList', $self->getDescription());
        $self->{'_isPrompted'} = $::TRUE;
    }
    
    if ( $self->needCompareVersionWithDest() && $destDir)
    {
        $destDir = NodeUtils->getAbsolutePath( $destDir);
    }
    else
    {
        $self->setNeedCompareVersionWithDest($::FALSE);
    }

    for my $rpm ( values %{$self->{ "_rpms"}})
    {
        if ( ! $rpm->searchHighestVersionInFileList( \@files, $destDir, $self->needCompareVersionWithDest()))
        {
            push @notFoundRpms, $rpm;
        }
    }
    return @notFoundRpms;
}
#--------------------------------------------------------------------------------
=head3    getUnfoundRpmShortNames
	Get the short names of rpm packages which could not be found. Those rpm
	packages are repesented by the Rpm objects belong to current RpmList 
	object.

    Arguments:
        none
    Returns:
        a array of the short names 
    Globals:
    Error:
    Example:
    Comments:
=cut
#--------------------------------------------------------------------------------
sub getUnfoundRpmShortNames
{
    my $self = shift;
    my @notFoundRpms;
    for my $rpm ( values %{$self->{ "_rpms"}})
    {
        if ( ! $rpm->isFound)
        {
            push @notFoundRpms, $rpm->getShortName();
        }
    }
    return @notFoundRpms;
}
#--------------------------------------------------------------------------------
=head3    getUnfoundRpmDetails
	Get the details of each rpm packages which could not be found.
	Detail is such as 'perl.*.i386.rpm'.

    Arguments:
        none
    Returns:
        a array of the 'detail' of rpm package which could not be found
    Globals:
    Error:
    Example:
    Comments:
=cut
#--------------------------------------------------------------------------------
sub getUnfoundRpmDetails
{
    my $self = shift;
    my @notFoundRpms;
    my @notFoundRpmDetails;
    @notFoundRpms = $self->getUnfoundRpms();
    for my $rpm ( @notFoundRpms)
    {
        push @notFoundRpmDetails, $rpm->getRpmDetails();
    }
    return @notFoundRpmDetails;
}
#--------------------------------------------------------------------------------
=head3    getUnfoundRpms
	Get all Rpm objects which belong to current RpmList object and their 
	repesenting package could not be found.

    Arguments:
        none 
    Returns:
        a array of the Rpm objects which repesenting package could not be
        found.
    Globals:
    Error:
    Example:
    Comments:
=cut
#--------------------------------------------------------------------------------
sub getUnfoundRpms
{
    my $self = shift;
    my @notFoundRpms;
    for my $rpm ( values %{$self->{ "_rpms"}})
    {
        if ( ! $rpm->isFound)
        {
            push @notFoundRpms, $rpm;
        }
    }
    return @notFoundRpms;
}
#--------------------------------------------------------------------------------
=head3    getFoundRpms
	Get all Rpm objects which belong to current RpmList object and their 
	repesenting packages already be found.

    Arguments:
        none 
    Returns:
        a array of the Rpm objects which repesenting package be found.
    Globals:
    Error:
    Example:
    Comments:
=cut
#--------------------------------------------------------------------------------
sub getFoundRpms
{
    my $self = shift;
    my @foundRpms;
    for my $rpm ( values %{$self->{ "_rpms"}})
    {
        if ( $rpm->isFound)
        {
            push @foundRpms, $rpm;
        }
    }
    return @foundRpms;
}
#--------------------------------------------------------------------------------
=head3    copyAllFoundRpms
	Copy all rpm packages repesented by the Rpm objects which belong 
	to current RpmList object to the given destination

    Arguments:
        dest	the given destination
    Returns:
        none
    Globals:
    Error:
    Example:
    Comments:
        Call each Rpm object's copy routines to do the dirty works.
=cut
#--------------------------------------------------------------------------------
sub copyAllFoundRpms
{
    my $self = shift;
    my $dest = shift;
    for my $rpm (values %{$self->{ "_rpms"}})
    {
        $rpm->copy( $dest);
    }
}
#--------------------------------------------------------------------------------
=head3    checkAllRpmsInstallStatus
	Check the installation status of each Rpm objects of 
	current RpmList object.

    Arguments:
        none
    Returns:
        none
    Globals:
    Error:
    Example:
    Comments:
        Call each Rpm object's checkInstallStatus routine to do the dirty works.
=cut
#--------------------------------------------------------------------------------
sub checkAllRpmsInstallStatus
{
    my $self = shift;
    for my $rpm (values %{$self->{ "_rpms"}})
    {
        $rpm->checkInstallStatus();
    }
}
#--------------------------------------------------------------------------------
=head3    installAll
	Install all rpm packages repesented by the Rpm objects of current RpmList
	object.

    Arguments:
        options	    the rpm command options to be used when installing
                the rpm packges.
    Returns:
        true	1. some rpm packages couldn't be found, but the 
                searching style is not 'MANDATORY'; there are no
                rpms would be installed.
                2. the rpm packages be installed successful.
        false	1. some rpm packages couldn't be found, and the 
                searching style is 'MANDATORY'; there are no rpms
                would be installde.
                2. there are some errors when installing, and the
                searching style is 'MANDATORY'.
    Globals:
    Error:
    Example:
    Comments:
=cut
#--------------------------------------------------------------------------------
sub installAll
{
    my $self = shift;
    my $options = shift;
    my (@groupedRpms, @individualRpms);

    my @unfoundRpms = $self->getUnfoundRpms();
    my @foundRpms = $self->getFoundRpms();
    
    if ( $self->{ "_installGroupingStyle"} eq "GROUPED" && scalar(@unfoundRpms)> 0)
    {
        my @unfoundAndNotInstalled;
        my $rpmNameList;
        for my $rpm ( @unfoundRpms)
        {
            if ( ! $rpm->isInstalled())
            {
                push @unfoundAndNotInstalled, $rpm;
                $rpmNameList .= ' ' . $rpm->getShortName();
            }
        }
        if ( scalar( @unfoundAndNotInstalled) > 0 && $self->{ "_searchingStyle"} eq  "MANDATORY")
        {
            MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                'csminstall', 'W', 'EMsgInstallRpmNotFound', $rpmNameList);
            return $::FALSE;
        }elsif (scalar( @unfoundAndNotInstalled) > 0)
        # some rpm couldn't be found, but this group isn't mandatory.
        {
            return $::TRUE;
	}
    }

    my @toBeInstalled;
    for my $rpm ( @foundRpms)
    {
        if ( $rpm->isFoundRequiredToBeInstalled &&
               ( $self->{ "_updatingStyle"} eq "UPDATE_OR_INSTALL" ||
		            ( $self->{ "_updatingStyle"} eq "UPDATE_ONLY" && $rpm->isInstalled)
               )
           )
        {
            push @toBeInstalled, $rpm;
        }
    }

    my @inOneCmd;
    my @inMutilCmd;
    for my $rpm ( @toBeInstalled)
    {
        my $className;
        $className = ref( $rpm);
		 # if this object is not a child Rpm object or 
		 # it is a child Rpm object but the install function has not been overloaded
		 # install those Rpm packages in one 'rpm' command
		 # this logical might fail when this object is an grandchild Rpm object
        if ( $className eq 'Rpm' || 
		     !defined ${*main::}{$className . '::'}{'install'}
		   ) 
        {
            push @inOneCmd, "$rpm->{'_absDirName'}/$rpm->{'_fullName'}";
        }
        else
        {
            push @inMutilCmd, $rpm;
        }
    }
    

	my $returnCode = $::TRUE;

	if (scalar(@inOneCmd))
	{
        for my $rpm ( @toBeInstalled)
        {
            if ( ! $rpm->runPreinstall() &&
                $self->{ "_searchingStyle"} eq  "MANDATORY")
            {
                $returnCode = $::FALSE;
            }        
        }
        MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
				'csminstall', 'I', 'IMsgInstallRpmList', $self->getDescription());
		my $cmd = "$::RPMCMD $options " . join(" ", @inOneCmd);
	    NodeUtils->runcmd( $cmd, -1);
    	if ( $::RUNCMD_RC != $::OK &&
            $self->{ "_searchingStyle"} eq  "MANDATORY")
	    {
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
				'csminstall', 'W', 'EMsgInstallRpmList', $self->getDescription());
        	$returnCode = $::FALSE;
	    }
	    for my $rpm ( @toBeInstalled)
        {
            if ( ! $rpm->runPostinstall() &&
                $self->{ "_searchingStyle"} eq  "MANDATORY")
            {
                $returnCode = $::FALSE;
            }
        }
	}

    for my $rpm ( @inMutilCmd)
    {
        my $cmdReturnCode = $rpm->install( $options);
        if ( $cmdReturnCode == $::FALSE &&
            $self->{ "_searchingStyle"} eq  "MANDATORY")
        {
            $returnCode = $::FALSE    
        };
    }

    return $returnCode;
}
#--------------------------------------------------------------------------------
=head3    uninstallAll
	Uninstall all rpm packages repesented by the Rpm objects belong to current
	RpmList object.

    Arguments:
        options	the rpm command options used when uninstalling
    Returns:
        true	1.some packages not be installed and the install style
                is 'GROUPED'; no package would be uninstall
                2. uninstall successful

        false	the uninstalling failed
    Globals:
    Error:
    Example:
    Comments:
=cut
#--------------------------------------------------------------------------------
sub uninstallAll
{
    my $self = shift;
    my $options = shift;
    my (@groupedRpms, @individualRpms);
    my $returnCode = $::TRUE;

    my @installedRpms = $self->getInstalledRpms();
    my @allRpms = $self->getAllRpmShortNames();
    if (scalar(@installedRpms) < scalar(@allRpms) &&
        $self->{ "_installGroupingStyle"} eq "GROUPED")
    # if not all the packages are installed, we may ignore them
    {
        if (scalar(@installedRpms))
        {
            MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                'csminstall', 'I', 'IMsgOptionalRpmListNotHandle',
                $self->getDescription(), 'uninstalled');
        }
        return $returnCode;    
    }
    
    my @inOneCmd;
    my @inMutilCmd;
    for my $rpm ( @installedRpms)
    {
        if ( ref( $rpm) eq "Rpm")
        {
            push @inOneCmd, $rpm->getShortName();
        }
        else
        {
            push @inMutilCmd, $rpm;
        }
    }

	if (scalar(@inOneCmd))
	{
		
        MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
            'csminstall', 'I', 'IMsgUninstallRpmList', $self->getDescription());
        my $cmd = "$::RPMCMD $options " . join(" ", @inOneCmd);
        NodeUtils->runcmd( $cmd, -1);
    	if ( $::RUNCMD_RC != $::OK)
        {
            MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                'csminstall', 'W', 'EMsgUninstallRpmList', $self->getDescription());
            $returnCode = $::FALSE;
        }
    }

    for my $rpm ( @inMutilCmd)
    {
       my $cmdReturnCode = $rpm->uninstall( $options);
       $returnCode = $::FALSE if ( $cmdReturnCode == $::FALSE);
    }

    return $returnCode;
}


#===========new functions===============
#--------------------------------------------------------------------------------
=head3    addRpm
	Add the given Rpm object into current RpmList object.

    Arguments:
        rpm	    the Rpm object's reference
    Returns:
        none
    Globals:
    Error:
    Example:
    Comments:
=cut
#--------------------------------------------------------------------------------
sub addRpm
{
    my $self = shift;
    my $rpm = shift;
    my $shortName = $rpm->getShortName();
    chomp $shortName;
    
    if ( $shortName)
    {
        ${$self->{ "_rpms"}}{$shortName} = $rpm;
    }
}
#--------------------------------------------------------------------------------
=head3    addRpms
	Add the given Rpm objects  into current RpmList object.

    Arguments:
        rpms	    a array of Rpm objects
    Returns:
        none
    Globals:
    Error:
    Example:
    Comments:
=cut
#--------------------------------------------------------------------------------
sub addRpms
{
    my $self = shift;
    my @rpms = @_;
    for my $rpm (@rpms)
    {
        $self->addRpm($rpm);
    }
}
#--------------------------------------------------------------------------------
=head3    addRpmList
	Add the given RpmList object's all Rpm objects into current 
	RpmList object.

    Arguments:
        rpmListObj		the RpmList object
    Returns:
        none
    Globals:
    Error:
    Example:
    Comments:
=cut
#--------------------------------------------------------------------------------
sub addRpmList
{
	my $self = shift;
	my $rpmListObj = shift;
	if ( $rpmListObj)
	{
	    my @rpms = $rpmListObj->getRpms();
	    $self->addRpms(@rpms);
	}
}
#--------------------------------------------------------------------------------
=head3    addRpmLists
	Merge all Rpm objects of the given RpmList objects into current RpmList
	object.

    Arguments:
        rpmLists		the RpmList objects list
    Returns:
        none
    Globals:
    Error:
    Example:
    Comments:
=cut
#--------------------------------------------------------------------------------
sub addRpmLists
{
	my $self = shift;
	my @rpmLists = @_;
	for my $rpmList (@rpmLists)
	{
		$self->addRpmList($rpmList);
	}
}
#--------------------------------------------------------------------------------
=head3    getRpms
	Get all Rpm objects of current RpmList

    Arguments:
        none
    Returns:
        a array of the Rpm objects
    Globals:
    Error:
    Example:
    Comments:
=cut
#--------------------------------------------------------------------------------
sub getRpms
{
	my $self = shift;
	return values( %{$self->{ "_rpms"}});
}
#--------------------------------------------------------------------------------
=head3    isMandatoryRpmList
	Check current RpmList's searching style whether is 'MANDATORY'

    Arguments:
        none
    Returns:
        true	searching style is 'MANDATORY'
        false	searching style isn't 'MANDATORY'
    Globals:
    Error:
    Example:
    Comments:
=cut
#--------------------------------------------------------------------------------
sub isMandatoryRpmList
{
    my $self = shift;
    if ( $self->{ '_searchingStyle'} eq 'MANDATORY')
    {
       return $::TRUE;
    }
    else
    {
        return $::FALSE;
    }
}
#--------------------------------------------------------------------------------
=head3    setContainedInCds
	Set the '_isContainedInCds' attribute of current RpmList

    Arguments:
        the value of the '_isContainedInCds'
    Returns:
        none
    Globals:
    Error:
    Example:
    Comments:
        '_isContainedInCds' used to identify whether should find the
        rpm packages in CD
=cut
#--------------------------------------------------------------------------------
sub setContainedInCds
{
    my $self = shift;
    $self->{ '_isContainedInCds'} = shift;
}
#--------------------------------------------------------------------------------
=head3    isContainedInCds
	Get the vaule of '_isContainedInCds'

    Arguments:
        none
    Returns:
        value of '_isContainedInCds'
    Globals:
    Error:
    Example:
    Comments:
        Be used to check the vaule of '_isContainedInCds'
=cut
#--------------------------------------------------------------------------------
sub isContainedInCds
{
    my $self = shift;
    return $self->{ '_isContainedInCds'};
}
#--------------------------------------------------------------------------------
=head3    isAllFound
	Check whether all rpm packages repesented by the Rpm objects belong to
	the RpmList found.

    Arguments:
        none
    Returns:
        true	all rpm packages found
        false	not all found
    Globals:
    Error:
    Example:
    Comments:
=cut
#--------------------------------------------------------------------------------
sub isAllFound
{
    my $self = shift;
    for my $rpm ( values %{$self->{ "_rpms"}})
    {
        return $::FALSE if ( !$rpm->isFound());
    }
    return $::TRUE;
}
#--------------------------------------------------------------------------------
=head3    setDescription
	Set the self description of the RpmList

    Arguments:
        self description string
    Returns:
        none
    Globals:
    Error:
    Example:
    Comments:
=cut
#--------------------------------------------------------------------------------
sub setDescription
{
    my $self = shift;
    $self->{ '_description'} = shift;
}
#--------------------------------------------------------------------------------
=head3    getDescription
	Get the self description of the RpmList

    Arguments:
        none
    Returns:
        self description string
    Globals:
    Error:
    Example:
    Comments:
=cut
#--------------------------------------------------------------------------------
sub getDescription
{
    my $self = shift;
    return $self->{ '_description'};
}
#--------------------------------------------------------------------------------
=head3    setToBeUninstall
	Set the value of '_needToBeUninstall'

    Arguments:
        value of '_needToBeUninstall'
    Returns:
        none
    Globals:
    Error:
    Example:
    Comments:
        '_needToBeUninstall' identify whether those rpm packages
        should be uninstalled when uninstalling CSM
=cut
#--------------------------------------------------------------------------------
sub setToBeUninstall
{
    my $self = shift;
    $self->{ '_needToBeUninstall'} = shift;
}
#--------------------------------------------------------------------------------
=head3    needToBeUninstall
	Check whether those rpm package would be uninstalled when uninstalling
	CSM.

    Arguments:
        none
    Returns:
        true	would be uninstalled when uninstalling CSM
        false	would not be uninstalled when uninstalling CSM
    Globals:
    Error:
    Example:
    Comments:
=cut
#--------------------------------------------------------------------------------
sub needToBeUninstall
{
    my $self = shift;
    return $self->{ '_needToBeUninstall'};
}
#--------------------------------------------------------------------------------
=head3    removeAllExcept
	Remove all Rpm object from this RpmList object except those givens

    Arguments:
        A array of short names rpm packages which wouldn't be removed
        from the RpmList
    Returns:
        none
    Globals:
    Error:
    Example:
    Comments:
=cut
#--------------------------------------------------------------------------------
sub removeAllExcept
{
    my $self = shift;
    my @rpmsNotToBeRemoved = @_;
    for my $rpm (keys %{$self->{ "_rpms"}})
    {
        my $toBeRemoved = $::TURE;
        for my $rpmNotToBeRemoved ( @rpmsNotToBeRemoved)
        {
            $toBeRemoved = $::FALSE if ( $rpm eq $rpmNotToBeRemoved);
        }
        if ( $toBeRemoved)
        {
            delete ${$self->{ "_rpms"}}{ $rpm};
        }
    }
}    
#--------------------------------------------------------------------------------
=head3    getInstalledRpms
	Get all installed Rpm objects of current RpmList.

    Arguments:
        none
    Returns:
        A array of installed Rpm objects.
    Globals:
    Error:
    Example:
    Comments:
=cut
#--------------------------------------------------------------------------------
sub getInstalledRpms
{
		my $self = shift;
		my @installedRpms;
		for my $rpm (values %{$self->{ "_rpms"}})
		{
				if ( $rpm->isInstalled())
				{
						push @installedRpms, $rpm;
				}
		}
		return @installedRpms;
}

sub setNeedCompareVersionWithDest
{
    my $self = shift;
    $self->{ '_needCompareVersionWithDest'} = shift;
}

sub needCompareVersionWithDest
{
    my $self = shift;
    return $self->{ '_needCompareVersionWithDest'};
}

sub removeRpmByShortName
{
    my $self = shift;
    my $shortName = shift;
    chomp $shortName;
    if ( $shortName)
    {
        delete ${$self->{ "_rpms"}}{$shortName};
    }
}

sub removeRpm
{
    my $self = shift;
    my $rpm = shift;
    $self->removeRpmByShortName( $rpm->getShortName());
}

sub removeRpms
{
    my $self = shift;
    my @rpms = @_;
    for my $rpm (@rpms)
    {
        $self->removeRpm( $rpm);
    }
}

sub removeRpmList
{
    my $self = shift;
    my $rpmList = shift;
    if ( $rpmList)
    {
        my @rpms = $rpmList->getRpms();
        $self->removeRpms( @rpms);
    }
}

#--------------------------------------------------------------------------------
=head3   setAllInstalled 
	Set all Rpm objects' isInstalled flags to $::TRUE or $::FALSE or $::UNKNOWN.

    Arguments:
        $installFlag: $::TRUE or $::FALSE or $::UNKNOWN
    Returns:
        none
    Globals:
    Error:
    Example:
    Comments:
=cut
#--------------------------------------------------------------------------------
sub setAllInstalled
{
    my $self = shift;
    my $installFlag = shift;
    for my $rpm ( values %{$self->{ '_rpms'}})
    {
        $rpm->setInstalled( $installFlag);
    }
}
                
return 1;
