#!/usr/bin/perl
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2005,2007 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 

package xCATCSM;

use strict;
BEGIN { $::csmpm = $ENV{'CSM_PM'} ? $ENV{'CSM_PM'} : '/opt/csm/pm'; }
use lib $::csmpm;

# FUNCTIONS from XCATROOT/lib/GUMI/Functions.pm
# take in a number, return a mask
sub bitscount
{
	my $class = shift;
	my $num   = shift;
	my $bits  = ((2**32) - 1) << (32 - $num);
	my $mask  = sprintf("%d.%d.%d.%d",
					   ($bits & 0xff000000) >> 24,
					   ($bits & 0x00ff0000) >> 16,
					   ($bits & 0x0000ff00) >> 8,
					   ($bits & 0x000000ff));
	return $mask;
}

# take in a mask, return the number of bits
sub countbits
{
	my $class = shift;
	my $mask  = shift;
	my @quads = split('\.', $mask);
	$mask = pack("CCCC", $quads[0], $quads[1], $quads[2], $quads[3]);
	my $bits += unpack("%32b*", $mask);
	return $bits;
}

sub ipCalc
{
	my $class = shift;
	my $out   = shift;
	unless ($out =~ /network/ || $out =~ /broadcast/) { return 1; }
	my $ip   = shift;
	my $mask = shift;
	my $bcast;

	my @ip   = split('\.', $ip);
	my @mask = split('\.', $mask);

	my $binIp   = unpack("B32", pack("C4", @ip));
	my $binMask = unpack("B32", pack("C4", @mask));
	my $net = $binIp & $binMask;

	#print "net: $net\n";
	my @net = unpack("C4", pack("B*", $net));

	if ($out =~ /broadcast/)
	{

		my $binXor = unpack("B32", pack("C4", 255, 255, 255, 255));
		my $binXorMask = $binMask ^ $binXor;
		$bcast = $binXorMask | $net;

		#print "bcast: $bcast\n";
		my @bcast = unpack("C4", pack("B32", $bcast));
		$bcast = join(".", @bcast);

		#print "bcast: $bcast\n";

	}

	$net = join('.', @net);
	if ($out =~ /network/)
	{
		return $net;
	}
	else
	{
		return $bcast;
	}
}

sub osver
{
	my $osver = "unknown";
	my $os    = '';
	my $ver   = '';
	my $line  = '';
	my @lines;
	if (-f "/etc/redhat-release")
	{
		chomp($line = `head -n 1 /etc/redhat-release`);
		$os = "rh";
		chomp($ver = `tr -d '.' < /etc/redhat-release | head -n 1`);
		$ver =~ s/[^0-9]*([0-9]+).*/$1/;
		if    ($line =~ /AS/) { $os = 'rhas' }
		elsif ($line =~ /ES/) { $os = 'rhes' }
		elsif ($line =~ /WS/) { $os = 'rhws' }
        elsif ($line =~ /Server/) { $os = 'rhserver' }
        elsif ($line =~ /Client/) { $os = 'rhclient' }
		elsif (-f "/etc/fedora-release") { $os = 'rhfc' }
	}
	elsif (-f "/etc/SuSE-release")
	{
		chomp(@lines = `cat /etc/SuSE-release`);
		if (grep /SLES|Enterprise Server/, @lines) { $os = "sles" }
		if (grep /SLEC/, @lines) { $os = "slec" }
		chomp($ver = `tr -d '.' < /etc/SuSE-release | head -n 1 `);
		$ver =~ s/[^0-9]*([0-9]+).*/$1/;

		#print "ver: $ver\n";
	}
	elsif (-f "/etc/HmcBase")
    {
        $os = "sles";
        $ver = "8";
        #print "ver: $ver\n";
    }
	elsif (-f "/etc/UnitedLinux-release")
	{

		$os = "ul";
		chomp($ver = `tr -d '.' < /etc/UnitedLinux-release | head -n 1 `);
		$ver =~ s/[^0-9]*([0-9]+).*/$1/;
	}
	$os = "$os" . "$ver";
	return ($os);
}

sub noderange
{
	my ($class, $ref_nodes, $nodegrp, $file) = @_;
	my %opthashref = ();
	if ($file)
	{
		%opthashref = (NodeFile => $file, NodeGrp => $nodegrp);
	}
	else
	{
		%opthashref = (NodeFile => 1, NodeGrp => $nodegrp);
	}
	my $ref_nodelist = NodeUtils->gatherNodeList($ref_nodes, \%opthashref);
	return @$ref_nodelist;

}

1;
