#!/usr/bin/perl
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# Restricted Materials of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2005 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
# Blame: Mark Atkins and/or Wes Jones
#---------------------------------------------------------------------------
# See StateFormat subroutine for format
#---------------------------------------------------------------------------
#  	org type = c for cluster; n for network; e for enclosure; s=system
#  	  (for now s=e)
#---------------------------------------------------------------------------
# This is to be used with VPD keyword output from vpdfs. The vpdfs data
# can be provided in an input file or streamed in STDIN
#---------------------------------------------------------------------------

#--------------------------------------------------------------------------
# include files
#--------------------------------------------------------------------------
use Getopt::Std;
use Time::Local;

#--------------------------------------------------
# Get timestamp info
#  May need to reformat this
#--------------------------------------------------

@ltime=localtime;
$month=$ltime[4]+1; $year = 1900 + $ltime[5]; $hour=$ltime[2];
$minute=$ltime[1];

if ( length($month) < 2 ) { $month="0".$month; }
if ( length($day) < 2 ) { $day="0".$day; }
if ( length($hour) < 2 ) { $hour="0".$hour; }
if ( length($minute) < 2 ) { $minute="0".$minute; }
#$timestamp="$year$month$day"."_"."$hour$minute";
$timestamp=time()*1000;

#-----------------------------------------
# Get and check command line options
#-----------------------------------------
getopts("i:g:n:hs");

$infile=$opt_i;
$orgtype=$opt_g;
if ( $orgtype eq "s" ) { $orgtype = "e"; } # for now, s = e

$network=$opt_n;
$stdin=$opt_s;

chkFormat();  # check command line options

#---------------------------------------
# Indent just helps keep things pretty
# It is used sparingly.
# Arguably, it would be better to have
# an @indent array and reference it by
# the level.
#---------------------------------------
$indent="\t";


#-------------------------------------------------------------------------
# Open up the proper input stream (file or STDIN)
# In the case of STDIN, it is already open.
# $fh = filehandle, and is sued to direct us to the proper stream in the
# standard "while (<filehandle>)" loop used below.
#------------------------------------------------------------------------
if ( $stdin eq "" ) {
	open (VPDFILE, $infile) or die "Can't open $infile : $!";
	$fh=VPDFILE;
} else {
	$fh=STDIN;
}

#-----------------------------------------------------
# Set some tracking indices to their first values
#-----------------------------------------------------
$enclosure_done=0;
$resource=-1;
$props=0;
$enclosure=0;

#-----------------------------------------------------
# Step through the input stream
#-----------------------------------------------------
while (<$fh>) {

 chomp; # drop any pesky control characters at the end of the line
 
 $record=$_;
 $property=substr($record,1,2);
 $property=~s/"//g;
 $value=substr($record,4,length($record)-4);
 $value=~s/"//g;
 $value=~s/\///g;
 $property=~s/[\000-\037]//g;
 $value=~s/[\000-\037]//g;

 if ($value =~ m/U\./i) 
 {
      $value =~ s/U\./U####.###.#######&/;
      @words = split(/&/, $value);
      $value = @words[0];
 }
 if($value eq "N\A")
 {
      #print "value equaled N/\A\n";
      $value="N/\A";
 }

 #$value =~ tr/A-Za-z0-9'\.,\-\$\%/ /cs; #remove invalid characters
 # Look for the last global property for an enclosure
 if ( ! defined $enclosures[$enclosure]{RD} ) {
	 $enclosures[$enclosure]{$property}=$value;
 } else {
   # SE lets you know that you're back to enclosure global properties
   if ( $property eq "SE" ) {
	   $enclosure=$enclosure + 1;
	   $enclosures[$enclosure]{$property}=$value;
	   # Step through all of the properties picked up so far for this
	   # enclosure before we determined this was an enclosure instead of
	   # yet another resource from the previous enclosure
	   for ($i=0; $i<=$#{$enclosures[$enclosure-1]{resources}[$resource]}; $i++ ) {
		$p=$enclosures[$enclosure-1]{resources}[$resource][$i]{property};
		$v=$enclosures[$enclosure-1]{resources}[$resource][$i]{value};
		$enclosures[$enclosure]{$p}=$v;
	   }
	   undef $enclosures[$enclosure-1]{resources}[$resource];
	   pop @{$enclosures[$enclosure-1]{resources}[$resource]};
	   $#{$enclosures[$enclosure-1]{resources}[$resource]}=$#{$enclosures[$enclosure-1]{resources}[$resource]}-1;
	   $resource=-1;
   } else {
	   # You're going through the resources here
	   # fC is the first property of a new FRU resource
	   if ( $property eq "FC" ) { $resource++; $props=1; $cbsep="";};
	   
	   
	   # This assumes that we're getting two "CB" keywords for the
	   # risers, and we must reformat them into a single keyword
	   # as a string array (string[]).
	   if ( $property ne "CB" ) {
		   
	     # normal keyword format as a string
	     $enclosures[$enclosure]{resources}[$resource][$props]{property}=$property;
	     $enclosures[$enclosure]{resources}[$resource][$props]{value}=$value;
           } else {

	      # working the CB keyword into a string[]
	      if ( $cbsep eq ";" ) { $props=$props-1; }
              $enclosures[$enclosure]{resources}[$resource][$props]{property}=$property;
              #$value=~s/"//g;
	       #$value="\"$value\"";
	      if ( $cbsep eq ";")
	      {
	      	$enclosures[$enclosure]{resources}[$resource][$props]{value}.=$cbsep.$value;
		chomp $enclosures[$enclosure]{resources}[$resource][$props]{value};
	      }
	      else
	      {
			$enclosures[$enclosure]{resources}[$resource][$props]{value}.=$value;
			chomp $enclosures[$enclosure]{resources}[$resource][$props]{value};
	       }
	     $cbsep=";";
	     chomp $cbsep;
	   }
	   if ( $property eq "DS" ) { 
		$value=~s/\s+$//g;
		$value=~s/^\s+//g;
		$enclosures[$enclosure]{resources}[$resource][0]{value}=$value;
	   }
	  
	   $props++;
	   
   }
 }
 
 #print "'$property' = '$value'\n";

}


##############################################################################
# Output stuff
#  1. Output any header info and top-level organization stuff
#  2. step through enclosures
#  3. close up the xml by using the </...> for each level
##############################################################################

#------------------------------------------------------------------------------
# only one xml file and set of header info if organized as a network or cluster
#------------------------------------------------------------------------------
if ( $orgtype eq "c" or $orgtype eq "n" ) {

  OutputHeader($timestamp);
  

  # different system MTMS based on cluster or network organization
  if ( $orgtype eq "c" ) {
  	#print "\t7045-SW4\n";
	$hpsnm_orgtype="7045-SW4";
  } else {
	  #print "\t7045-SW4-NETWORK$network\n";
	  $hpsnm_orgtype="7045-SW4-NETWORK$network";
  }
  print "\t<Resource displayName=\"$hpsnm_orgtype\" uniqueId=\"$hpsnm_orgtype\">\n";

  print "\t$hpsnm_orgtype\n";

  # Always list enclosures after this point (for both cluster and network)
  print "\t  <ResourceList displayName=\"Enclosures\">\n";  
}

#--------------------------------------
# Step through the enclosures
#--------------------------------------

for($i=0; $i<=$#enclosures; $i++ ) {

  #------------------------------------------------------------------
  # If we're organized by enclosure, and we get more than one, we'll
  # start a new xml definition for each one
  # This doesn't happen for cluster and network organization
  #-------------------------------------------------------------------
  if ( $orgtype eq "e" ) {
	  if ( $i > 0 ) { print "\n\n"; }

	  OutputHeader($timestamp);
	  print "\t<Resource displayName=\"System's MTMS\" uniqueId=\"System's MTMS\">\n";
	  print "\t$enclosures[$i]{YL}\n";
  	  print "\t  <ResourceList displayName=\"Enclosures\">\n";  
  }
  
  print "\t\t<Resource displayName=\"$enclosures[$i]{DS}\" uniqueId=\"$enclosures[$i]{YL}\">\n\t\t\t$enclosures[$i]{DS}\n\n";
  
  #---------------------------------------
  # Output Enclosure properties
  #---------------------------------------
  for $k (keys %{$enclosures[$i]} ) {
	  if ( $k ne "resources" ) {
		$enclosures[$i]{$k}=~s/\s+$//g;
		if ($k ne ""){
	    print "\t\t  <Property name=\"$k\" displayName=\"$k\">\n";
	    print "\t\t    $k\n";
	    print "\t\t    <Value type=\"string\">$enclosures[$i]{$k}</Value>\n";
	    print "\t\t   </Property>\n";
		}
  	  }
  }
$v2=1;
###############################################################################################################
for ($j=0; $j<=$#{$enclosures[$i]{resources}}; $j++ ){
        for ($k=1; $k<=$#{$enclosures[$i]{resources}[$j]}; $k++) {

     	        if ( ($enclosures[$i]{resources}[$j][$k]{property} eq "CB") && ($v2==1) ) {
		@semi = split(/;/, $enclosures[$i]{resources}[$j][$k]{value});
		($semi_split) = @semi; 
		@blank = split(/ /, $semi_split); 
		shift(@blank);

		$array_size = @blank;   # get array size

		for ($w=0;$w<$array_size;$w++){
			$retain = pop(@blank);
			$retain = substr($retain, 0, -9);
			unshift(@blank,$retain);	
		}
		
   			print "\t\t  <Property name=\"V2\" displayName=\"V2\">\n";
            print "\t\t    V2\n";
	    if ($array_size == 1)
	    {
            	print "\t\t    <Value type=\"string\">@blank</Value>\n";
           }
		elsif ($array_size > 1) 
		{
            	print "\t\t    <Value type=\"string[]\">@blank</Value>\n";

		} 
	  print "\t\t   </Property>\n";
		$v2=0; 
		}
        }
}

###############################################################################################################
$resourceList=0;
  #-------------------------------------------
  # Step through FRUs
  #-------------------------------------------
  	#print "\n\t\t  <ResourceList displayName=\"Global Resources\">\n";
  for ($j=0; $j<=$#{$enclosures[$i]{resources}}; $j++ ){
if ($enclosures[$i]{resources}[$j][0]{value} ne "")
{
  	if ($resourceList==0)
	{
        	print "\n\t\t  <ResourceList displayName=\"Global Resources\">\n";
		$resourceList=1;
	}
	
        #print "\n\t\t\t<Resource displayName=\"$enclosures[$i]{resources}[$j][0]{value}\" uniqueId=\"$enclosures[$i]{resources}[$j][0]{value}\">\n\t\t\t   $enclosures[$i]{resources}[$j][0]{value}\n\n"; 

###############################################################################################################
for $k (keys %{$enclosures[$i]{resources}[$j]} ) {
        for ($k=1; $k<=$#{$enclosures[$i]{resources}[$j]}; $k++) {

	if ( $enclosures[$i]{resources}[$j][$k]{property} eq "YL" ) {
	print "\n\t\t\t<Resource displayName=\"$enclosures[$i]{resources}[$j][0
]{value}\" uniqueId=\"$enclosures[$i]{resources}[$j][$k]{value}\">\n\t\t\t   $enclosures[$i]{resources}[$j][0
]{value}\n\n";   
    }
	}
}

###############################################################################################################
	#------------------------------------------------
	# Output FRU properties
	#------------------------------------------------
#	for $k (keys %{$enclosures[$i]{resources}[$j]} ) {
	for ($k=1; $k<=$#{$enclosures[$i]{resources}[$j]}; $k++) {
		$p=$enclosures[$i]{resources}[$j][$k]{property};
		if ($p ne "")
		{
		$enclosures[$i]{resources}[$j][$k]{value}=~s/\n//g;
		print "\t\t\t   <Property name=\"$p\" displayName=\"$p\">\n";
		print "\t\t\t     $p\n";
	 	$enclosures[$i]{resources}[$j][$k]{value}=~s/\s+$//g;	
		if ( $enclosures[$i]{resources}[$j][$k]{property} eq "CB" ) {
		  print "\t\t\t     <Value type=\"string[]\">$enclosures[$i]{resources}[$j][$k]{value}</Value>\n";
		} else {
		  print "\t\t\t     <Value type=\"string\">$enclosures[$i]{resources}[$j][$k]{value}</Value>\n";
		}
	
		print "\t\t\t    </Property>\n";
		}
	}
	print "\t\t\t</Resource>\n";
  }

}
	if ($resourceList==1)
	{
     		print "\t\t  </ResourceList>\n";
		$resourceList=0;
	}
  	print "\t\t  </Resource>\n";
  #----------------------------------------------------------------------------
  # If this is an enclosure organization, we have to close out all open levels
  # at this point; before proceeding to the next enclosure.
  #----------------------------------------------------------------------------
  if ( $orgtype eq "e" ) { 
	print "\t\t</ResourceList>\n";
	print "\t  </Resource>\n";
	print "\t</ResourceSet>\n";
	print "</com.ibm.inventory>\n";
  }
}

#-------------------------------------------------------------------------
# If this is network or cluster, we have to close out all of the open
# levels at this point
#------------------------------------------------------------------------
if ( $orgtype eq "n" or $orgtype eq "c" ) {
 print "\t\t</ResourceList>\n";
 print "\t  </Resource>\n";
 print "\t</ResourceSet>\n";
 print "</com.ibm.inventory>\n";
}

##############################################################################
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# SUBROUTINES
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
##############################################################################

##########################################################################
#-----------------------------------------------------------------------------
# Output the standard stuff at the beginning of a VPD XML file
#-----------------------------------------------------------------------------
##########################################################################
sub OutputHeader {
 my ($timestamp) = (@_);
	
print <<ENDHDR;
<?xml version="1.0" encoding="UTF-8" ?> 
 <com.ibm.inventory version="1.0">
 <ResourceSet class="com.ibm.inventory.HPScluster" timestamp="$timestamp" type="HPScluster" version="1.0">
ENDHDR

 return;
}

##########################################################################
#-------------------------------------------------------------------------
# Check format of command line options and check for help request
#-------------------------------------------------------------------------
##########################################################################
sub chkFormat {

 # Got to tell me where the input is coming from
 if ( $infile eq "" and $stdin eq "" ) {
	 print "\n!! Need either -i or -s !!\n";
	 StateFormat();
	 exit;
 }

 # A cry for help
 if ( $opt_h ne "" ) {
	 StateFormat();
	 exit;
 }

 # if they want to organize by network, they need to give the network number
 if ( $orgtype eq "n" and $network eq "" ) {
	 print "\n !! Need -n with '-g n' option !!\n";
	 StateFormat();
	 exit;
 }

 if ( $orgtype ne "c" and $orgtype ne "n" and 
      $orgtype ne "e" and $orgtype ne "s" ) {
      print "\n !! -g value not 'c', 'n', 'e' or 's' !!\n";
      StateFormat();
      exit;
 }

 return;
}

##########################################################################
#-----------------------------------------------------------------------------
# Output the format of this command.
#
# It's arguable that the "e" for enclosure should really be "s" for system.
# That would be architecturally pure. For now, we'll treat them the same. That
# seems to work just fine for switches and BPAs... Kind of a luck thing.
# 
#-----------------------------------------------------------------------------
##########################################################################
sub StateFormat {
 
 print <<EOFmt;

 Format:  vpd2xml.pl { -i [input file] | -s } -g [orgtype] [-n [network]]
 	             -h

		     -i = input file; need this or '-s' option
		     -s = use STDIN for input; need this or '-i' option
		     -g = organization type;
		     	  c = by cluster
			  n = by network
			  e = by enclosure
			  s = by system (for now, the same as by enclosure)
		     -n = network number; this is required with "-g n"
		     -h = help
		     
EOFmt
 return;
}
