#!/bin/bash

#set -x

showUsage()
{
  echo  "Usage: "
  echo  "  $CMD enumInstances  [-h host] [-p port] [-s] -u user -n name_space [-w password] -c className"
  echo  "  $CMD enumAssociated [-h host] [-p port] [-s] -u user -n name_space [-w password] -c className -a associator"
}

# Main from here
#
CMD=$0
CMD=${CMD#.\/}
OP=$1

export JAVA_HOME=/opt/IBMJava
export PEGASUS_ROOT=/opt/hsc/pegasus
export PEGASUS_HOME=$PEGASUS_ROOT/peghome
export PEGASUS_CODEBASE=/opt/hsc/pegasus/codebase
export CLASSPATH=$PEGASUS_CODEBASE/hmcprov.jar:$PEGASUS_ROOT/lib/jmpi.jar:/usr/lib/pegasus/jmpi/JMPIImpl.jar
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$PEGASUS_HOME/lib:$JAVA_HOME/jre/lib:$JAVA_HOME/jre/bin:$JAVA_HOME/jre/bin/classic

x=`type -p java 2>/dev/null`
if [ "$x" != "" ]
then
  JAVAPATH=`/usr/bin/dirname $x`
fi
PATH=$JAVAPATH:$PATH

export CLASSPATH PATH LD_LIBRARY_PATH

case $OP in
  enumInstances )
    java com.ibm.power.client.$OP $*
    ;;

  enumAssociated )
    java com.ibm.power.client.$OP $*
    ;;

  * )
    showUsage
    exit 1
esac

exit 0

