# @(#)57   1.3   src/csm/install/drivers/pm/a320raid.pm.perl, setup, csm_rfish, rfishs001b 3/5/07 03:16:37
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# IBM CONFIDENTIAL 
#  
# OBJECT CODE ONLY SOURCE MATERIALS 
#  
# (C) COPYRIGHT International Business Machines Corp. 2006,2007 
# All Rights Reserved 
#  
# The source code for this program is not published or otherwise 
# divested of its trade secrets, irrespective of what has been 
# deposited with the U.S. Copyright Office. 
#  
# IBM_PROLOG_END_TAG 
#!/usr/bin/perl
#
# encapsulate all the special operations for a320raid.
# All special cases about a320raid driver should be here
# or pkgdef files
#
package a320raid;
use strict;
BEGIN
{
    $::csmroot = $ENV{'CSM_ROOT'} ? $ENV{'CSM_ROOT'} : '/opt/csm';
    $::csmpm   = "$::csmroot/pm";
}
use lib $::csmpm;
require NodeUtils;
use File::Copy;
my $module = "a320raid";
my $ok = 1;     # return 1 when succeeds
my $nok = 0;    # return 0 when fails

sub post_copy
{
    my ($class, $disName, $disVer, $disSvl, $disArch, $sourceDir, $destDir) = @_;
    if (!$sourceDir)
    {
        return $nok;
    }

    # replace aic79xx entries with a320raid on Redhat
    # for entries already tagged by RedHat as HostRAID--no pcitable
    # fragment for a320raid is necesary with this method. Will do
    # search and replace by PCI IDs listed in a pcitable fragment
    # file for a320raid in future release.

    # TO do, we should confirm a320raid is in the driver list
    if ($disName =~ m/RedHat/)
    {
        my $kstmp = "$sourceDir/kstmp";            # e.g. /tmp/newks4/kstmp
        if ($disVer eq "3")
        {
            my $cmd = "/bin/sed -i '/HostRAID/s/aic79xx/$module/g' $kstmp/modules/pcitable"; 
            NodeUtils->runcmd($cmd, 0);
            if ($::RUNCMD_RC)
            {
                return $nok;
            }
        }elsif ($disVer eq "4" || $disVer =~ /4\./)
        {
            # seperates comments from pcitable to pci.ids
            my $cmd = "/bin/awk '/HostRAID/ { print \$1; }' $kstmp/modules/pci.ids";
            my @output = NodeUtils->runcmd($cmd, 0);
            if ($::RUNCMD_RC)
            {
                return $nok;
            }
            foreach my $id (@output)
            {
                my $pci_id = "0x" . $id;
                $cmd = "/bin/sed -i '/$pci_id/s/aic79xx/$module/g' $kstmp/modules/pcitable";
                NodeUtils->runcmd($cmd, 0);
                if ($::RUNCMD_RC)
                {
                    return $nok;
                }
            }
        }
    } 

    return $ok;
}

1;
