# @(#)58   1.2   src/csm/install/drivers/pm/bcm5700.pm.perl, setup, csm_rfish, rfishs001b 8/14/06 00:47:01
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# IBM CONFIDENTIAL 
#  
# OBJECT CODE ONLY SOURCE MATERIALS 
#  
# (C) COPYRIGHT International Business Machines Corp. 2006,2007 
# All Rights Reserved 
#  
# The source code for this program is not published or otherwise 
# divested of its trade secrets, irrespective of what has been 
# deposited with the U.S. Copyright Office. 
#  
# IBM_PROLOG_END_TAG 
#!/usr/bin/perl
#
# encapsulate all the special operations for bcm5700.
# All special cases about bcm5700 driver should be here
# or pkgdef files
#
package bcm5700;
use strict;
BEGIN
{
    $::csmroot = $ENV{'CSM_ROOT'} ? $ENV{'CSM_ROOT'} : '/opt/csm';
    $::csmpm   = "$::csmroot/pm";
}
use lib $::csmpm;
require NodeUtils;
use File::Copy;    # Provides move();
my $module = "bcm5700";
my $ok = 1;     # return 1 when succeeds
my $nok = 0;    # return 0 when fails

sub post_copy
{
    my ($class, $disName, $disVer, $disSvl, $disArch, $sourceDir) = @_;
    if (!$sourceDir)
    {
        return $nok;
    }

    # replace tg3 entries with bcm5700 on Redhat
    if ($disName =~ m/RedHat/)
    {
        my $kstmp = "$sourceDir/kstmp";            # e.g. /tmp/newks4/kstmp
        my $cmd = "/bin/sed -i 's/tg3/$module/g' $kstmp/modules/pcitable";
        my $output = NodeUtils->runcmd($cmd, 0);
        if ($::RUNCMD_RC)
        {
            return $nok;
        }
        $cmd = "/bin/sed -i 's/tg3/$module/g' $kstmp/modules/modules.pcimap";
        $output = NodeUtils->runcmd($cmd, 0);
        if ($::RUNCMD_RC)
        {
            return $nok;
        }
    }
    
    return $ok;
}

1;
