# @(#)56   1.8   src/csm/install/drivers/pm/drivers_post.pm.perl, setup, csm_rfish, rfishs001b 3/15/07 05:13:05
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# IBM CONFIDENTIAL 
#  
# OBJECT CODE ONLY SOURCE MATERIALS 
#  
# (C) COPYRIGHT International Business Machines Corp. 2006,2007 
# All Rights Reserved 
#  
# The source code for this program is not published or otherwise 
# divested of its trade secrets, irrespective of what has been 
# deposited with the U.S. Copyright Office. 
#  
# IBM_PROLOG_END_TAG 
#!/usr/bin/perl
#
# this file includes the post copy actions of all drivers
#
package drivers_post;
use strict;
BEGIN
{
    $::csmroot = $ENV{'CSM_ROOT'} ? $ENV{'CSM_ROOT'} : '/opt/csm';
    $::csmpm   = "$::csmroot/pm";
}
use lib $::csmpm;
require NodeUtils;
my $ok = 1;     # return 1 when succeeds
my $nok = 0;    # return 0 when fails

sub final_post
{
    my ($class, $disName, $disVer, $disSvl, $disArch, $sourceDir) = @_;
    if (!$sourceDir)
    {
        return $nok;
    }

    # Remove FAStT modules from the modules.cgz
    if ($disName =~ m/RedHat/)
    {
        # Determine the kernel level used in the modules.cgz
        my $kernel_level;
        my $cmd = "cd $sourceDir; $::LS -d [0-9]*";
        my $output = NodeUtils->runcmd($cmd, 0);
        if ($::RUNCMD_RC)
        {
            return $nok;
        }
        chomp $output;
        if (-d "$sourceDir/$output")
        {
            $kernel_level = $output;
        }
        my $DIR_ARCH = $::pkgdefs{'kernel_arch_dir'}{$disSvl};
        if (!$DIR_ARCH)
        {
            $DIR_ARCH = $::pkgdefs{'kernel_arch_dir'}{'default'};
        }

        if (-d "$sourceDir/$kernel_level/$DIR_ARCH")
        {
            unlink glob("$sourceDir/$kernel_level/$DIR_ARCH/qla*.o");
            unlink glob("$sourceDir/$kernel_level/$DIR_ARCH/qla*.ko");
            unlink glob("$sourceDir/$kernel_level/$DIR_ARCH/lpfc.o");
            unlink glob("$sourceDir/$kernel_level/$DIR_ARCH/lpfc.ko");
        }else
        {
            unlink <"$sourceDir/$kernel_level/qla*.o">;
            unlink <"$sourceDir/$kernel_level/qla*.ko">;
            unlink <"$sourceDir/$kernel_level/lpfc.o">;
            unlink <"$sourceDir/$kernel_level/lpfc.ko">;
        }
		# For specific hardware type:p5 510, 505, 550  
		# Redhat loads 10g Ethernet driver (s2io) before intel (e1000) on install 
		# But this adapter driver has not been supported until RHEL4 QU4. 
		# We build its module from source after installation.
		# Therefore, we disable it in the initrd on RHEL4.But that is not to say we will not 
		# support the OS driver version in the future.

        if (($disVer eq "4" && $disArch =~ /ppc64/)
          ||($disVer =~ /4\./ && $disArch =~ /ppc64/))
        {
            my $pcimap = "$sourceDir/kstmp/modules/modules.pcimap";
            if ( -f $pcimap )
            {
                my $cmd = "/bin/sed -i 's/^s2io.*\$//g' $pcimap";
                my $output = NodeUtils->runcmd($cmd, 0);
            }
        }

    }else
    {
        # SLES section

        # Remove FAStT modules from the modules directory
        my $cmd = "$::RM -f $sourceDir/modules/qla*.o;".
                "$::RM -f $sourceDir/modules/qla*.ko;".
                "$::RM -f $sourceDir/modules/lpfc.o;".
                "$::RM -f $sourceDir/modules/lpfc.ko;";
        #not using unlink here because we want the patern matching from the shell
        NodeUtils->runcmd($cmd, 0);

        # Replace tg3 with bcm5700 in modules.pcimap
        if ($disVer eq "9" && $disSvl eq "GA")
        {
            unlink "$sourceDir/modules/tg3.ko";
            $cmd = "$::LS $sourceDir/lib/modules";
            my @kerneldir = NodeUtils->runcmd($cmd, 0);
            if ($::RUNCMD_RC)
            {
                return $nok;
            }
            foreach my $dir (@kerneldir)
            {
                my $pcimap = "$sourceDir/lib/modules/$dir/modules.pcimap";
                my $temp   = "/tmp/pcimap";
                if (-f "$pcimap")
                {

                    open(TEMP, ">$temp");
                    open(CONF, "$pcimap");

                    while (<CONF>)
                    {
                        my $temp_line = $_;    # read first line
                        if (($temp_line =~ /tg3/))
                        {
                            $temp_line =~ s/tg3/bcm5700/;    # sub it
                            print TEMP $temp_line;
                            next;
                        }
                        else
                        {
                            print TEMP $temp_line;
                        }
                    }   # end read CONF file.
                    close CONF;
                    close TEMP;
                    my $cp = "$::MV $temp $pcimap";
                    my $output = NodeUtils->runcmd($cp, 0);
                    if ($::RUNCMD_RC)
                    {
                        return $nok;
                    }
                }
            }
        }
    }

    return $ok;
}

1;
