#!/usr/bin/perl
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# IBM CONFIDENTIAL 
#  
# OBJECT CODE ONLY SOURCE MATERIALS 
#  
# (C) COPYRIGHT International Business Machines Corp. 2006,2007 
# All Rights Reserved 
#  
# The source code for this program is not published or otherwise 
# divested of its trade secrets, irrespective of what has been 
# deposited with the U.S. Copyright Office. 
#  
# IBM_PROLOG_END_TAG 
# @(#)57   1.3   src/csm/install/drivers/pm/mptsas.pm.perl, setup, csm_rfish, rfishs001b 3/15/07 04:44:49
#
# encapsulate all the special operations for mptsas.
# All special cases about mptsas driver should be here
# or pkgdef files
#
package mptsas;
use strict;
BEGIN
{
    $::csmroot = $ENV{'CSM_ROOT'} ? $ENV{'CSM_ROOT'} : '/opt/csm';
    $::csmpm   = "$::csmroot/pm";
}
use lib $::csmpm;
require NodeUtils;
require NodesetUtils;
use File::Basename; # provide dirname
my $module = "mptsas";
my $ok = 1;     # return 1 when succeeds
my $nok = 0;    # return 0 when fails

sub post_copy
{
    my ($class, $disName, $disVer, $disSvl, $disArch, $sourceDir, $driver) = @_;
    if (!$sourceDir)
    {
        return $nok;
    }

    # if user modules.dep is used for Redhat nodes
    # remove all lines with mpt
    # and append the contents of user modules.dep to OS modules.dep
    if ($disName =~ m/RedHat/)
    {
        my $kstmp = "$sourceDir/kstmp";            # e.g. /tmp/newks4/kstmp
        my $modules_dep = "$kstmp/modules/modules\.dep";
        my $driverDir = dirname($driver);
        my $user_dep = "$driverDir/modules\.dep";
        if (-f $modules_dep && -f $user_dep)
        {
            # remove all lines with mpt
            my $cmd = "/bin/sed -i 's/mpt//g' $modules_dep";
            NodeUtils->runcmd($cmd, 0);
            if ($::RUNCMD_RC)
            {
                return $nok;
            }

            NodesetUtils->appendfile($user_dep, $modules_dep);
        }
    }
    
    return $ok;
}

1;
